/*
 * Decompiled with CFR 0.152.
 */
package kd.wtc.wtp.formplugin.web.quota.qulification;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import java.util.ArrayList;
import java.util.Collections;
import java.util.EventObject;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.datamodel.events.AfterAddRowEventArgs;
import kd.bos.entity.datamodel.events.BeforeDeleteRowEventArgs;
import kd.bos.ext.form.control.CustomControl;
import kd.bos.ext.hr.ruleengine.infos.ConditionExpressInfo;
import kd.bos.ext.hr.ruleengine.infos.ConditionInfo;
import kd.bos.ext.hr.ruleengine.infos.RuleConditionInfo;
import kd.bos.form.IFormView;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.CustomEventArgs;
import kd.bos.orm.util.CollectionUtils;
import kd.hr.hbp.common.util.HRStringUtils;
import kd.hr.hbp.formplugin.web.HRDataBaseEdit;
import kd.wtc.wtbs.business.history.service.WTCHisService;
import kd.wtc.wtbs.business.personfilter.enums.RuleParamTypeEnum;
import kd.wtc.wtbs.common.util.third.util.StringUtils;
import kd.wtc.wtp.business.ex.helper.ExKDStringHelper;
import kd.wtc.wtp.constants.quota.QTQualificationConstants;

public class QTQualificationCusEdit
extends HRDataBaseEdit
implements QTQualificationConstants {
    public void beforeBindData(EventObject evt) {
        super.beforeBindData(evt);
        this.initCustomControl();
    }

    private void initCustomControl() {
        DynamicObjectCollection entryEntity;
        String entryType;
        boolean isLock = WTCHisService.isLock((IFormView)this.getView());
        String showType = isLock ? "1" : "0";
        String conditionStr = this.getModel().getDataEntity().getString("conditionstr");
        String condition = "";
        String conditionType = "";
        boolean var = this.getModel().getDataEntity().getBoolean("varcheckbox");
        String string = entryType = var ? "varcondsubentryentity" : "condsubentryentity";
        if (!HRStringUtils.isEmpty((String)conditionStr)) {
            RuleConditionInfo ruleConditionInfo = (RuleConditionInfo)JSON.parseObject((String)conditionStr, RuleConditionInfo.class);
            this.setValue(ruleConditionInfo);
            conditionType = ruleConditionInfo.getConditionExpressType();
            condition = ruleConditionInfo.getConditionExpressStr();
        }
        String string2 = conditionType = HRStringUtils.isEmpty((String)conditionType) ? "0" : conditionType;
        if (HRStringUtils.isEmpty((String)condition) && (entryEntity = this.getModel().getEntryEntity(entryType)).size() == 1) {
            condition = "T01";
        }
        HashMap<String, Object> args = new HashMap<String, Object>(16);
        args.put("showType", Integer.parseInt(showType));
        args.put("conditionType", Integer.parseInt(conditionType));
        args.put("data", condition);
        HashMap<String, Object> emptyArgs = new HashMap<String, Object>(16);
        emptyArgs.put("showType", Integer.parseInt(showType));
        emptyArgs.put("conditionType", 0);
        emptyArgs.put("data", "T01");
        HashMap<String, Object> returnData = new HashMap<String, Object>(16);
        returnData.put("args", args);
        HashMap<String, Object> emptyReturnData = new HashMap<String, Object>(16);
        emptyReturnData.put("args", emptyArgs);
        HashMap<String, Object> varMap = var ? returnData : emptyReturnData;
        HashMap<String, Object> conditionMap = var ? emptyReturnData : returnData;
        QTQualificationCusEdit.setCustomCtrlReturnData(this.getView(), varMap, "varconditionlogic");
        QTQualificationCusEdit.setCustomCtrlReturnData(this.getView(), conditionMap, "conditionlogic");
    }

    public void afterDoOperation(AfterDoOperationEventArgs afterDoOperationEventArgs) {
        String opKey;
        switch (opKey = afterDoOperationEventArgs.getOperateKey()) {
            case "save": 
            case "saveandnew": 
            case "submit": 
            case "submitandaudit": 
            case "confirmchange": 
            case "confirmchangenoaudit": {
                this.initCustomControl();
                this.getModel().setDataChanged(false);
            }
        }
    }

    public void customEvent(CustomEventArgs evt) {
        super.customEvent(evt);
        String args = evt.getEventArgs();
        String eventName = evt.getEventName();
        if ("getData".equals(eventName)) {
            JSONObject jsonObj = (JSONObject)JSONObject.parse((String)args);
            Object data = jsonObj.get((Object)"data");
            Object conditionType = jsonObj.get((Object)"conditionType");
            this.getModel().setValue("logicstr", data);
            this.getModel().setValue("logictype", conditionType);
            this.setConditionStr();
            String operateKey = jsonObj.get((Object)"opType").toString();
            if (operateKey == null) {
                return;
            }
            if (!"confirmchange".equals(operateKey)) {
                this.getPageCache().put("IS_SYN", "IS_SYN");
                this.getView().invokeOperation(operateKey);
            }
        }
    }

    public void afterAddRow(AfterAddRowEventArgs evt) {
        super.afterAddRow(evt);
        String entryName = evt.getEntryProp().getName();
        if ("condsubentryentity".equals(entryName) || "varcondsubentryentity".equals(entryName)) {
            String limitType = "condsubentryentity".equals(entryName) ? "condsubentryentity" : "varcondsubentryentity";
            String limitNo = "condsubentryentity".equals(entryName) ? "limitno" : "limitnov";
            DynamicObjectCollection entryEntity = this.getModel().getEntryEntity(limitType);
            String newIndex = this.getNextLimitIndex(limitType, limitNo);
            this.getModel().setValue(limitNo, (Object)newIndex, entryEntity.size() - 1);
            this.sendConditionChangeEvent(Collections.singletonList(newIndex));
        }
    }

    private String getNextLimitIndex(String limitType, String limitNo) {
        DynamicObjectCollection entryEntity = this.getModel().getEntryEntity(limitType);
        if (entryEntity.size() == 1) {
            return "T01";
        }
        DynamicObject lastRow = (DynamicObject)entryEntity.get(entryEntity.size() - 2);
        Integer lastIndex = Integer.parseInt(lastRow.getString(limitNo).substring(1));
        Integer newIndex = lastIndex + 1;
        String newIndexStr = newIndex.toString();
        if (newIndex < 10) {
            newIndexStr = "0" + newIndexStr;
        }
        return "T" + newIndexStr;
    }

    public void beforeDeleteRow(BeforeDeleteRowEventArgs evt) {
        String entryName = evt.getEntryProp().getName();
        if (this.getPageCache().get("need_del") == null) {
            evt.setCancel(true);
            return;
        }
        if ("condsubentryentity".equals(entryName) || "varcondsubentryentity".equals(entryName)) {
            int[] deleteRows = evt.getRowIndexs();
            String limitType = "condsubentryentity".equals(entryName) ? "condsubentryentity" : "varcondsubentryentity";
            String limitNo = "condsubentryentity".equals(entryName) ? "limitno" : "limitnov";
            DynamicObjectCollection entryEntity = this.getModel().getEntryEntity(limitType);
            ArrayList<String> list = new ArrayList<String>(deleteRows.length);
            for (int row : deleteRows) {
                list.add(((DynamicObject)entryEntity.get(row)).getString(limitNo));
            }
            this.sendConditionChangeEvent(list);
            if (deleteRows.length == 0 || deleteRows.length == entryEntity.size()) {
                return;
            }
            HashSet<Integer> scrappedIndex = new HashSet<Integer>(deleteRows.length);
            for (int deleteRow : deleteRows) {
                scrappedIndex.add(deleteRow);
            }
            Integer lastIndex = 0;
            for (int i = 0; i < entryEntity.size(); ++i) {
                if (scrappedIndex.contains(i)) {
                    this.getModel().setValue(limitNo, null, i);
                    continue;
                }
                if (HRStringUtils.isEmpty((String)((DynamicObject)entryEntity.get(i)).getString(limitNo))) continue;
                Integer newIndex = lastIndex + 1;
                String newIndexStr = 'T' + newIndex.toString();
                if (newIndex < 10) {
                    newIndexStr = "T0" + newIndex;
                }
                this.getModel().setValue(limitNo, (Object)newIndexStr, i);
                Integer n = lastIndex;
                Integer n2 = lastIndex = Integer.valueOf(lastIndex + 1);
            }
        }
    }

    private void sendConditionChangeEvent(List<String> changeData) {
        HashMap<String, Object> returnData = new HashMap<String, Object>(16);
        returnData.put("event", "conditionChange");
        returnData.put("args", changeData);
        returnData.put("nanoTime", System.nanoTime());
        boolean var = this.getModel().getDataEntity().getBoolean("varcheckbox");
        String controlType = var ? "varconditionlogic" : "conditionlogic";
        QTQualificationCusEdit.setCustomCtrlReturnData(this.getView(), returnData, controlType);
    }

    static void sendGetDataEvent(IFormView view, String opType, String controlType) {
        HashMap<String, Object> returnData = new HashMap<String, Object>(16);
        returnData.put("event", "getData");
        returnData.put("args", opType);
        returnData.put("nanoTime", System.nanoTime());
        QTQualificationCusEdit.setCustomCtrlReturnData(view, returnData, controlType);
    }

    static void setCustomCtrlReturnData(IFormView view, Map<String, Object> returnData, String controlType) {
        CustomControl control = (CustomControl)view.getControl(controlType);
        control.setData(returnData);
    }

    private void setValue(RuleConditionInfo ruleConditionInfo) {
        if (ruleConditionInfo == null) {
            return;
        }
        IDataModel model = this.getModel();
        model.beginInit();
        boolean var = model.getDataEntity().getBoolean("varcheckbox");
        boolean att = model.getDataEntity().getBoolean("attitemcheckbox");
        String entryType = var ? "varcondsubentryentity" : (att ? "condsubentryentity" : "");
        List conditionInfos = ruleConditionInfo.getConditionList();
        if (conditionInfos != null && !HRStringUtils.isEmpty((String)entryType)) {
            model.deleteEntryData(entryType);
            model.batchCreateNewEntryRow(entryType, conditionInfos.size());
            for (int index = 0; index < conditionInfos.size(); ++index) {
                ConditionInfo conditionInfo = (ConditionInfo)conditionInfos.get(index);
                if ("condsubentryentity".equals(entryType)) {
                    model.setValue("limitno", (Object)conditionInfo.getName(), index);
                    model.setValue("condrel", (Object)conditionInfo.getOperators(), index);
                    model.setValue("condvalue", (Object)conditionInfo.getValue(), index);
                    model.setValue("condattitem", (Object)conditionInfo.getParam(), index);
                    continue;
                }
                model.setValue("limitnov", (Object)conditionInfo.getName(), index);
                model.setValue("varcondrel", (Object)conditionInfo.getOperators(), index);
                model.setValue("varcondvalue", (Object)conditionInfo.getValue(), index);
                model.setValue("varconditionm", (Object)conditionInfo.getParam(), index);
            }
        }
        model.endInit();
    }

    private void setConditionStr() {
        String entryType;
        boolean var = this.getModel().getDataEntity().getBoolean("varcheckbox");
        boolean att = this.getModel().getDataEntity().getBoolean("attitemcheckbox");
        String string = var ? "varcondsubentryentity" : (entryType = att ? "condsubentryentity" : "");
        if (HRStringUtils.isEmpty((String)entryType)) {
            return;
        }
        DynamicObjectCollection dynamicObjectCollection = this.getModel().getEntryEntity(entryType);
        if (dynamicObjectCollection != null) {
            RuleConditionInfo ruleConditionInfo = new RuleConditionInfo();
            ArrayList<ConditionInfo> conditionInfos = new ArrayList<ConditionInfo>(dynamicObjectCollection.size());
            StringBuilder expritStr = new StringBuilder();
            String logType = (String)this.getModel().getValue("logictype");
            for (int index = 0; index < dynamicObjectCollection.size(); ++index) {
                DynamicObject attitem;
                DynamicObject dynamicObject = (DynamicObject)dynamicObjectCollection.get(index);
                ConditionInfo conditionInfo = new ConditionInfo();
                conditionInfo.setIndex(index);
                conditionInfo.setParamType(RuleParamTypeEnum.NUMBER.getValue());
                if ("condsubentryentity".equals(entryType)) {
                    attitem = dynamicObject.getDynamicObject("condattitem");
                    if (attitem != null) {
                        conditionInfo.setParam(attitem.getString("id"));
                    }
                    conditionInfo.setName(dynamicObject.getString("limitno"));
                    conditionInfo.setOperators(dynamicObject.getString("condrel"));
                    conditionInfo.setValueType("2");
                    conditionInfo.setDisplayValue(dynamicObject.getString("condvalue"));
                    conditionInfo.setValue(dynamicObject.getString("condvalue"));
                } else {
                    attitem = dynamicObject.getDynamicObject("varconditionm");
                    if (attitem != null) {
                        conditionInfo.setParam(attitem.getString("id"));
                    }
                    conditionInfo.setName(dynamicObject.getString("limitnov"));
                    conditionInfo.setOperators(dynamicObject.getString("varcondrel"));
                    conditionInfo.setValueType("2");
                    conditionInfo.setDisplayValue(dynamicObject.getString("varcondvalue"));
                    conditionInfo.setValue(dynamicObject.getString("varcondvalue"));
                }
                expritStr.append(conditionInfo.getName()).append(' ');
                if (index != dynamicObjectCollection.size() - 1) {
                    if (HRStringUtils.equals((String)logType, (String)"0")) {
                        expritStr.append(ExKDStringHelper.getAndStr()).append(' ');
                    } else if (HRStringUtils.equals((String)logType, (String)"1")) {
                        expritStr.append(ExKDStringHelper.getPerhapsStr()).append(' ');
                    }
                }
                conditionInfos.add(conditionInfo);
            }
            ruleConditionInfo.setConditionList(conditionInfos);
            ruleConditionInfo.setConditionExpressType(logType);
            String conditionExpressStr = (String)this.getModel().getValue("logicstr");
            conditionExpressStr = HRStringUtils.equals((String)logType, (String)"2") ? conditionExpressStr : expritStr.toString();
            ruleConditionInfo.setConditionExpressStr(conditionExpressStr);
            ruleConditionInfo.setConditionExpressList(this.analyzeExpress(conditionExpressStr, conditionInfos));
            String conditionStr = JSON.toJSONString((Object)ruleConditionInfo);
            this.getModel().setValue("conditionstr", (Object)conditionStr);
        }
    }

    private List<ConditionExpressInfo> analyzeExpress(String conditionExpressStr, List<ConditionInfo> conditionInfos) {
        if (StringUtils.isEmpty((CharSequence)conditionExpressStr) && CollectionUtils.isEmpty(conditionInfos)) {
            return Collections.emptyList();
        }
        conditionExpressStr = conditionExpressStr.replaceAll(ExKDStringHelper.getAndStr(), "and");
        conditionExpressStr = conditionExpressStr.replaceAll(ExKDStringHelper.getPerhapsStr(), "or");
        ArrayList<ConditionExpressInfo> conditionExpressInfos = new ArrayList<ConditionExpressInfo>(conditionInfos.size());
        for (int index = 0; index < conditionInfos.size(); ++index) {
            int lastIndex;
            ConditionExpressInfo conditionExpressInfo = new ConditionExpressInfo();
            String name = conditionInfos.get(index).getName();
            conditionExpressInfo.setName(name);
            int in = conditionExpressStr.indexOf(name);
            if (in < 0) {
                return Collections.emptyList();
            }
            String preStr = conditionExpressStr.substring(0, in);
            String nextStr = conditionExpressStr.substring(in + name.length());
            if (!StringUtils.isEmpty((CharSequence)preStr) && (lastIndex = (preStr = preStr.trim()).lastIndexOf(65288)) != -1 && lastIndex + 1 == preStr.length()) {
                conditionExpressInfo.setLeftBracket(" ( ");
            }
            if (!StringUtils.isEmpty((CharSequence)nextStr)) {
                if ((nextStr = nextStr.trim()).indexOf("\uff09and") == 0) {
                    conditionExpressInfo.setRightBracket(" ) ");
                    conditionExpressInfo.setLogical("and");
                } else if (nextStr.indexOf("and") == 0) {
                    conditionExpressInfo.setLogical("and");
                } else if (nextStr.indexOf("\uff09or") == 0) {
                    conditionExpressInfo.setRightBracket(" ) ");
                    conditionExpressInfo.setLogical("or");
                } else if (nextStr.indexOf("or") == 0) {
                    conditionExpressInfo.setLogical("or");
                } else if (nextStr.indexOf(65289) == 0) {
                    conditionExpressInfo.setRightBracket(" ) ");
                }
            }
            conditionExpressInfos.add(conditionExpressInfo);
        }
        return conditionExpressInfos;
    }
}

