/*
 * Decompiled with CFR 0.152.
 */
package kd.wtc.wtp.formplugin.web.quota.qulification;

import com.alibaba.fastjson.JSON;
import java.math.BigDecimal;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.EventObject;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import kd.bos.bill.OperationStatus;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.datamodel.events.ChangeData;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.entity.operate.SaveAndNew;
import kd.bos.ext.hr.ruleengine.infos.ConditionInfo;
import kd.bos.ext.hr.ruleengine.infos.RuleConditionInfo;
import kd.bos.form.IFormView;
import kd.bos.form.container.Container;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.field.BasedataEdit;
import kd.bos.form.field.FieldEdit;
import kd.bos.form.field.events.BeforeF7SelectEvent;
import kd.bos.form.field.events.BeforeF7SelectListener;
import kd.bos.form.operate.FormOperate;
import kd.bos.orm.query.QFilter;
import kd.hr.hbp.business.servicehelper.HRBaseServiceHelper;
import kd.hr.hbp.common.util.HRStringUtils;
import kd.hr.hbp.formplugin.web.HRDataBaseEdit;
import kd.wtc.wtbs.business.personfilter.enums.RuleOperatorEnum;
import kd.wtc.wtbs.common.enums.AttitemUnitEnum;
import kd.wtc.wtbs.common.util.WTCCollections;
import kd.wtc.wtbs.common.util.WTCSerializationUtils;
import kd.wtc.wtbs.common.util.third.collect.Maps;
import kd.wtc.wtbs.common.util.third.util.CollectionUtils;
import kd.wtc.wtp.business.ex.ExConditionFilterService;
import kd.wtc.wtp.business.ex.helper.ExKDStringHelper;
import kd.wtc.wtp.business.incrdecrrules.IncDecConfKDStringHelper;
import kd.wtc.wtp.business.quota.QTKDStringHelper;
import kd.wtc.wtp.constants.mobile.quota.QTQualificationInfo;
import kd.wtc.wtp.constants.quota.QTQualificationConstants;
import kd.wtc.wtp.enums.quota.QTLimitMethodEnum;
import kd.wtc.wtp.enums.quota.QTQualityTypeEnum;
import kd.wtc.wtp.formplugin.web.quota.qulification.QTQualificationCusEdit;

public class QTQualificationEdit
extends HRDataBaseEdit
implements QTQualificationConstants,
BeforeF7SelectListener {
    private static final String CHANG_BSED = "changBsed";
    private static final HRBaseServiceHelper ATTIEM_HELPER = new HRBaseServiceHelper("wtbd_attitem");
    private static final HRBaseServiceHelper VAR_CONTION_HELPER = new HRBaseServiceHelper("wtbd_qtvarcondition");

    public void beforeBindData(EventObject eventObject) {
        DynamicObject dynamicObject = this.getModel().getDataEntity();
        Map customParams = this.getView().getFormShowParameter().getCustomParams();
        String hisAction = (String)customParams.get("his_action");
        boolean isNewVersion = HRStringUtils.equals((String)"open_insert_new_data_page", (String)hisAction);
        boolean isCopyHis = HRStringUtils.equals((String)"open_copy_his_data_page", (String)hisAction);
        boolean isUpdateHis = HRStringUtils.equals((String)"open_insert_data_page", (String)hisAction);
        boolean isCopy = customParams.get("iscopy") != null ? (Boolean)customParams.get("iscopy") : false;
        OperationStatus opStatus = this.getView().getFormShowParameter().getStatus();
        boolean tag = !OperationStatus.ADDNEW.equals((Object)opStatus);
        Container infoContainer = (Container)this.getView().getControl("fs_baseinfo");
        infoContainer.setCollapse(tag);
        if (isNewVersion) {
            IDataModel model = this.getModel();
            model.beginInit();
            model.deleteEntryData("condsubentryentity");
            model.deleteEntryData("varcondsubentryentity");
            model.endInit();
            this.getView().updateView("condsubentryentity");
            this.getView().updateView("varcondsubentryentity");
            this.setConditionMustInput(true);
            this.setReslutMustInput(true);
            return;
        }
        String vale = (String)this.getModel().getValue("qualitytypem");
        if (!HRStringUtils.isEmpty((String)vale)) {
            boolean vTag = QTQualityTypeEnum.ATTITEM.getCode().equals(vale);
            this.getModel().setValue("attitemcheckbox", (Object)vTag);
            this.getModel().setValue("varcheckbox", (Object)(!vTag ? 1 : 0));
            this.setConditionMustInput(vTag);
        } else {
            this.setConditionMustInput(true);
        }
        boolean isFixedValue = QTLimitMethodEnum.FIXED_VALE.getCode().equals(dynamicObject.getString("limitmethodm"));
        this.setReslutMustInput(isFixedValue);
        if (isFixedValue && (tag || isCopyHis || isCopy || isUpdateHis)) {
            this.getModel().setValue("limitquatityv", this.getModel().getValue("limitquatitym"));
        } else if (!isFixedValue && (tag || isCopyHis || isCopy || isUpdateHis)) {
            this.getModel().setValue("limitprecentgv", this.getModel().getValue("limitprecentgm"));
        }
    }

    public void afterBindData(EventObject e) {
        super.afterBindData(e);
        this.setResult();
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        Object source = args.getSource();
        String operateKey = ((FormOperate)source).getOperateKey();
        if (source instanceof SaveAndNew) {
            SaveAndNew opSource = (SaveAndNew)source;
            operateKey = opSource.getOriOperateKey();
        }
        String isSyn = this.getPageCache().get("IS_SYN");
        Map customParams = this.getView().getFormShowParameter().getCustomParams();
        String hisAction = (String)customParams.get("his_action");
        boolean isUpdateHis = HRStringUtils.equals((String)"open_insert_data_page", (String)hisAction) || HRStringUtils.equals((String)"open_data_page", (String)hisAction);
        switch (operateKey) {
            case "save": 
            case "saveandnew": 
            case "submit": 
            case "submitandaudit": {
                if (isSyn == null && !isUpdateHis) {
                    args.setCancel(true);
                }
                if (isUpdateHis) {
                    operateKey = "confirmchange";
                }
            }
            case "confirmchange": 
            case "confirmchangenoaudit": {
                boolean var = this.getModel().getDataEntity().getBoolean("varcheckbox");
                String controlType = var ? "varconditionlogic" : "conditionlogic";
                String conditionFilter = (String)this.getModel().getValue("conditionstr");
                if (isSyn == null) {
                    QTQualificationCusEdit.sendGetDataEvent(this.getView(), operateKey, controlType);
                }
                if (HRStringUtils.isEmpty((String)conditionFilter)) {
                    args.setCancel(true);
                    return;
                }
                if (args.isCancel()) {
                    return;
                }
                this.getPageCache().put("IS_SYN", null);
                BigDecimal value = (BigDecimal)this.getModel().getValue("limitquatityv");
                value = value != null ? value : BigDecimal.ZERO;
                this.getModel().setValue("limitquatitym", (Object)value);
                BigDecimal tagValue = (BigDecimal)this.getModel().getValue("limitprecentgv");
                tagValue = tagValue != null ? tagValue : BigDecimal.ZERO;
                this.getModel().setValue("limitprecentgm", (Object)tagValue);
                boolean emptyEntry = this.isValidEntry(this.getView());
                if (!emptyEntry) {
                    args.setCancel(true);
                    return;
                }
                String qualityValue = var ? QTQualityTypeEnum.CONDITION.getCode() : QTQualityTypeEnum.ATTITEM.getCode();
                this.getModel().setValue("qualitytypem", (Object)qualityValue);
                boolean emptyJudge = this.isValidCondition(this.getView(), conditionFilter);
                if (!emptyJudge) {
                    args.setCancel(true);
                    return;
                }
                DynamicObjectCollection dynamicObjectCollection = this.getModel().getEntryEntity("condsubentryentity");
                ArrayList<String> indexs = new ArrayList<String>(dynamicObjectCollection.size());
                Date bsed = this.getModel().getDataEntity().getDate("bsed");
                boolean delTag = false;
                for (int index = 0; index < dynamicObjectCollection.size(); ++index) {
                    DynamicObject attDy = ((DynamicObject)dynamicObjectCollection.get(index)).getDynamicObject("condattitem");
                    if (attDy == null) continue;
                    Date firstBsed = attDy.getDate("firstbsed");
                    if (bsed != null && !firstBsed.after(bsed)) continue;
                    int row = index + 1;
                    indexs.add(String.valueOf(row));
                    delTag = true;
                }
                if (!delTag || var) break;
                String str = String.join((CharSequence)"\uff0c", indexs);
                String errorMsg = ResManager.loadKDString((String)"\u8bf7\u6ce8\u610f\uff0c\u7b2c%s\u884c\u7684\u8003\u52e4\u9879\u76ee\u7684\u6700\u65e9\u751f\u6548\u65f6\u95f4\u5e94\u65e9\u4e8e\u201c\u751f\u6548\u65f6\u95f4\u201d\u3002", (String)"QTQualificationEdit_4", (String)"wtc-wtp-formplugin", (Object[])new Object[]{str});
                args.setCancel(true);
                this.getView().showErrorNotification(errorMsg);
                return;
            }
            case "vardeleteentry": 
            case "deleteentry": {
                this.getPageCache().put("need_del", "need_del");
            }
        }
    }

    private boolean isValidEntry(IFormView view) {
        boolean var = (Boolean)this.getModel().getValue("varcheckbox");
        String entryType = var ? "varcondsubentryentity" : "condsubentryentity";
        boolean tag = true;
        DynamicObjectCollection dynamicObjectCollection = this.getModel().getEntryEntity(entryType);
        if (CollectionUtils.isEmpty((Collection)dynamicObjectCollection)) {
            view.showErrorNotification(QTKDStringHelper.qtQualificationEntity());
            return false;
        }
        for (int index = 0; index < dynamicObjectCollection.size(); ++index) {
            DynamicObject dynamicObject = (DynamicObject)dynamicObjectCollection.get(index);
            String msg = "";
            if (var) {
                if (HRStringUtils.isEmpty((String)dynamicObject.getString("varconditionm"))) {
                    msg = QTKDStringHelper.qtQualificationVar();
                    tag = false;
                }
                if (HRStringUtils.isEmpty((String)dynamicObject.getString("varcondrel"))) {
                    msg = StringUtils.isEmpty((CharSequence)msg) ? QTKDStringHelper.qtQualificationCondrel() : msg + QTKDStringHelper.qtQualificationSpliStr() + QTKDStringHelper.qtQualificationCondrel();
                    tag = false;
                }
                if (dynamicObject.getBigDecimal("varcondvalue") == null) {
                    msg = StringUtils.isEmpty((CharSequence)msg) ? QTKDStringHelper.qtQualificationCondrel() : msg + QTKDStringHelper.qtQualificationSpliStr() + QTKDStringHelper.qtQualificationCondVal();
                    tag = false;
                }
            } else {
                if (HRStringUtils.isEmpty((String)dynamicObject.getString("condattitem"))) {
                    msg = QTKDStringHelper.qtQualificationCondattitem();
                    tag = false;
                }
                if (HRStringUtils.isEmpty((String)dynamicObject.getString("condrel"))) {
                    msg = StringUtils.isEmpty((CharSequence)msg) ? QTKDStringHelper.qtQualificationCondrel() : msg + QTKDStringHelper.qtQualificationSpliStr() + QTKDStringHelper.qtQualificationCondrel();
                    tag = false;
                }
                if (dynamicObject.getBigDecimal("condvalue") == null) {
                    msg = StringUtils.isEmpty((CharSequence)msg) ? QTKDStringHelper.qtQualificationCondrel() : msg + QTKDStringHelper.qtQualificationSpliStr() + QTKDStringHelper.qtQualificationCondVal();
                    tag = false;
                }
            }
            if (!StringUtils.isNotEmpty((CharSequence)msg)) continue;
            view.showErrorNotification(MessageFormat.format(QTKDStringHelper.qtQualificationIndex(), index + 1, msg));
        }
        return tag;
    }

    private boolean isValidCondition(IFormView view, String conditionFilter) {
        if (HRStringUtils.isEmpty((String)conditionFilter)) {
            view.showTipNotification(QTKDStringHelper.qtQualificationEntity());
            return false;
        }
        RuleConditionInfo ruleConditionInfo = (RuleConditionInfo)JSON.parseObject((String)conditionFilter, RuleConditionInfo.class);
        String logicStr = ruleConditionInfo.getConditionExpressStr();
        String expressStr = QTQualificationEdit.parseToCulCondition(logicStr);
        List expressInfos = ruleConditionInfo.getConditionExpressList();
        if (WTCCollections.isEmpty((Collection)expressInfos)) {
            view.showTipNotification(ExKDStringHelper.expressTypeError());
            return false;
        }
        List conditionInfos = ruleConditionInfo.getConditionList();
        if (conditionInfos.size() > 10) {
            view.showTipNotification(ExKDStringHelper.getMaxConditionNum());
            return false;
        }
        String pattern = "^\\(*T[0-9]+\\)*((and|or)\\(*T[0-9]+\\)*)*$";
        if (!Pattern.matches(pattern, expressStr.replaceAll(" ", ""))) {
            view.showTipNotification(ExKDStringHelper.expressTypeError());
            return false;
        }
        String[] str = expressStr.split(" ");
        int leftBracket = 0;
        int rightBracket = 0;
        Set expressNameSet = conditionInfos.stream().map(row -> row.getName()).collect(Collectors.toSet());
        for (int i = 0; i < str.length; ++i) {
            if (StringUtils.isEmpty((CharSequence)str[i])) continue;
            if ("(".equals(str[i])) {
                ++leftBracket;
                continue;
            }
            if (")".equals(str[i])) {
                ++rightBracket;
                continue;
            }
            if ("and".equals(str[i]) || "or".equals(str[i])) continue;
            if (Pattern.matches("^T\\d{2,}$", str[i])) {
                if (expressNameSet.contains(str[i])) continue;
                view.showTipNotification(ExKDStringHelper.expressTypeError());
                return false;
            }
            view.showTipNotification(ExKDStringHelper.expressTypeError());
            return false;
        }
        if (leftBracket != rightBracket) {
            view.showTipNotification(ExKDStringHelper.expressTypeError());
            return false;
        }
        return true;
    }

    private static String parseToCulCondition(String condition) {
        return condition.replaceAll("\uff08", "\\(").replaceAll("\uff09", ")").replaceAll(IncDecConfKDStringHelper.or(), "or").replaceAll(IncDecConfKDStringHelper.and(), "and").replaceAll("\u00a0", " ");
    }

    public void afterDoOperation(AfterDoOperationEventArgs afterDoOperationEventArgs) {
        String opKey = afterDoOperationEventArgs.getOperateKey();
        if ("newentry".equals(opKey) && !this.bsedIsNotEmpty()) {
            return;
        }
        this.getPageCache().put("need_del", null);
        switch (opKey) {
            case "save": 
            case "saveandnew": 
            case "submit": 
            case "submitandaudit": 
            case "confirmchange": 
            case "confirmchangenoaudit": {
                boolean var = this.getModel().getDataEntity().getBoolean("varcheckbox");
                String entryType = var ? "condsubentryentity" : "varcondsubentryentity";
                this.getModel().beginInit();
                this.getModel().deleteEntryData(entryType);
                this.getModel().endInit();
                this.getView().updateView(entryType);
                this.setResult();
                this.getModel().setDataChanged(false);
            }
        }
    }

    private void setResult() {
        boolean var = this.getModel().getDataEntity().getBoolean("varcheckbox");
        boolean att = this.getModel().getDataEntity().getBoolean("attitemcheckbox");
        String entryType = var ? "varcondsubentryentity" : (att ? "condsubentryentity" : "");
        DynamicObjectCollection dynamicObjectCollection = this.getModel().getEntryEntity(entryType);
        String conditionStr = this.getModel().getDataEntity().getString("conditionstr");
        if (dynamicObjectCollection != null && !HRStringUtils.isEmpty((String)conditionStr)) {
            DynamicObject dynamicObject;
            RuleConditionInfo ruleConditionInfo = (RuleConditionInfo)JSON.parseObject((String)conditionStr, RuleConditionInfo.class);
            for (int index = 0; index < dynamicObjectCollection.size(); ++index) {
                DynamicObject attitem;
                dynamicObject = (DynamicObject)dynamicObjectCollection.get(index);
                ConditionInfo conditionInfo = (ConditionInfo)ruleConditionInfo.getConditionList().get(index);
                if ("condsubentryentity".equals(entryType)) {
                    attitem = dynamicObject.getDynamicObject("condattitem");
                    if (attitem == null) continue;
                    conditionInfo.setDisplayParam(attitem.getString("name"));
                    continue;
                }
                attitem = dynamicObject.getDynamicObject("varconditionm");
                if (attitem == null) continue;
                conditionInfo.setDisplayParam(attitem.getString("name"));
            }
            String newConditionStr = JSON.toJSONString((Object)ruleConditionInfo);
            dynamicObject = this.getModel().getDataEntity();
            if (!HRStringUtils.isEmpty((String)newConditionStr)) {
                QTQualificationInfo qualificationInfo = new QTQualificationInfo();
                qualificationInfo.changToMobile(dynamicObject);
                String condStr = QTQualificationEdit.getStrOfSettingCondition(dynamicObjectCollection, newConditionStr, entryType);
                dynamicObject.set("resultm", (Object)qualificationInfo.getInspectRangDescV2(condStr));
                this.getView().updateView("resultm");
            }
        }
    }

    static String getStrOfSettingCondition(DynamicObjectCollection dynamicObjectCollection, String conditions, String entryType) {
        String conditionExpressStr;
        RuleConditionInfo accessDto = (RuleConditionInfo)WTCSerializationUtils.fromJsonString((String)conditions, RuleConditionInfo.class);
        List conditionList = accessDto.getConditionList();
        if (conditionList == null || conditionList.isEmpty()) {
            return ExConditionFilterService.getUnLimitStr();
        }
        HashMap map = Maps.newHashMapWithExpectedSize((int)conditionList.size());
        for (int index = 0; index < dynamicObjectCollection.size(); ++index) {
            DynamicObject attitem;
            DynamicObject dynamicObject = (DynamicObject)dynamicObjectCollection.get(index);
            String paramName = "";
            String unit = "";
            if ("condsubentryentity".equals(entryType)) {
                attitem = dynamicObject.getDynamicObject("condattitem");
                if (attitem != null) {
                    paramName = attitem.getString("name");
                    AttitemUnitEnum attitemUnitEnum = AttitemUnitEnum.of((String)attitem.getString("unit"));
                    unit = attitemUnitEnum.getDescription();
                }
            } else {
                attitem = dynamicObject.getDynamicObject("varconditionm");
                if (attitem != null) {
                    paramName = attitem.getString("name");
                }
            }
            ConditionInfo dto = (ConditionInfo)conditionList.get(index);
            String desc = String.format(Locale.ROOT, ResManager.loadKDString((String)"\u3010%1$s\u3011%2$s\u201c%3$s\u201d%4$s", (String)"QTQualificationEdit_01", (String)"wtc-wtp-formplugin", (Object[])new Object[0]), paramName, RuleOperatorEnum.getEnum((String)dto.getOperators()).getName(), dto.getDisplayValue(), unit);
            map.put(dto.getName(), desc);
        }
        if (map.isEmpty()) {
            return ExConditionFilterService.getUnLimitStr();
        }
        String result = conditionExpressStr = accessDto.getConditionExpressStr();
        result = result.replace("and", ExKDStringHelper.getAndStr());
        result = result.replace("or", ExKDStringHelper.getPerhapsStr());
        for (Map.Entry entry : map.entrySet()) {
            result = result.replace((CharSequence)entry.getKey(), (CharSequence)entry.getValue());
        }
        return result;
    }

    private boolean bsedIsNotEmpty() {
        Date bsed = this.getModel().getDataEntity().getDate("bsed");
        if (bsed == null) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u6309\u8981\u6c42\u586b\u5199\u201c\u751f\u6548\u65e5\u671f\u201d\u3002", (String)"QTQualificationEdit_0", (String)"wtc-wtp-formplugin", (Object[])new Object[0]));
            return false;
        }
        return true;
    }

    public void propertyChanged(PropertyChangedArgs pro) {
        String name = pro.getProperty().getName();
        ChangeData[] changeSet = pro.getChangeSet();
        ChangeData changeData = changeSet[0];
        if ("varcheckbox".equals(name) || "attitemcheckbox".equals(name)) {
            boolean tag = (Boolean)this.getModel().getValue(name);
            String setValueFile = "varcheckbox".equals(name) ? "attitemcheckbox" : "varcheckbox";
            this.getModel().setValue(setValueFile, (Object)(!tag ? 1 : 0));
            boolean isAttitem = "attitemcheckbox".equals(name) ? tag : !tag;
            this.setConditionMustInput(isAttitem);
        }
        if ("limitmethodm".equals(name)) {
            boolean isFixedValue = QTLimitMethodEnum.FIXED_VALE.getCode().equals(changeData.getNewValue());
            this.setReslutMustInput(isFixedValue);
            if (isFixedValue) {
                this.getModel().setValue("limitprecentgv", null);
            } else {
                this.getModel().setValue("limitquatityv", null);
            }
        }
    }

    private void setConditionMustInput(boolean isAttitem) {
        FieldEdit attControl = (FieldEdit)this.getView().getControl("condattitem");
        FieldEdit condreControl = (FieldEdit)this.getView().getControl("condrel");
        FieldEdit condValueControl = (FieldEdit)this.getView().getControl("condvalue");
        attControl.setMustInput(isAttitem);
        condreControl.setMustInput(isAttitem);
        condValueControl.setMustInput(isAttitem);
        this.getView().updateView("condsubentryentity");
        FieldEdit varControl = (FieldEdit)this.getView().getControl("varconditionm");
        FieldEdit varCondreControl = (FieldEdit)this.getView().getControl("varcondrel");
        FieldEdit varCondValueControl = (FieldEdit)this.getView().getControl("varcondvalue");
        varControl.setMustInput(!isAttitem);
        varCondreControl.setMustInput(!isAttitem);
        varCondValueControl.setMustInput(!isAttitem);
        this.getView().updateView("varcondsubentryentity");
    }

    private void setReslutMustInput(boolean isFixedValue) {
        FieldEdit preControl = (FieldEdit)this.getView().getControl("limitprecentgv");
        FieldEdit quatityControl = (FieldEdit)this.getView().getControl("limitquatityv");
        preControl.setMustInput(!isFixedValue);
        quatityControl.setMustInput(isFixedValue);
        this.getView().updateView("limitprecentgv");
        this.getView().updateView("limitquatityv");
    }

    public void registerListener(EventObject event) {
        BasedataEdit fieldEdit = (BasedataEdit)this.getView().getControl("condattitem");
        fieldEdit.setF7BatchFill(false);
        fieldEdit.addBeforeF7SelectListener((BeforeF7SelectListener)this);
    }

    public void beforeF7Select(BeforeF7SelectEvent beforeF7SelectEvent) {
        if ("condattitem".equals(beforeF7SelectEvent.getProperty().getName()) && !this.bsedIsNotEmpty()) {
            beforeF7SelectEvent.setCancel(true);
            return;
        }
        Date bsed = (Date)this.getModel().getValue("bsed");
        QFilter corQfliter = new QFilter("firstbsed", "<=", (Object)bsed);
        beforeF7SelectEvent.addCustomQFilter(corQfliter);
    }
}

