/*
 * Decompiled with CFR 0.152.
 */
package kd.wtc.wtp.formplugin.web.quota.qulification;

import com.alibaba.fastjson.JSONObject;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Date;
import java.util.EventObject;
import java.util.HashMap;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.datamodel.events.ChangeData;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.form.FieldTip;
import kd.bos.form.IFormView;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.field.BasedataEdit;
import kd.bos.form.field.FieldEdit;
import kd.bos.form.field.events.BeforeF7SelectEvent;
import kd.bos.form.field.events.BeforeF7SelectListener;
import kd.bos.orm.query.QFilter;
import kd.hr.hbp.formplugin.web.HRDynamicFormBasePlugin;
import kd.wtc.wtp.constants.mobile.quota.QTQualificationInfo;
import kd.wtc.wtp.constants.quota.QTQualificationConstants;
import kd.wtc.wtp.enums.quota.QTLimitMethodEnum;
import kd.wtc.wtp.enums.quota.QTQualityTypeEnum;

public class QTQualificationInfoPlugin
extends HRDynamicFormBasePlugin
implements QTQualificationConstants,
BeforeF7SelectListener {
    private static final String OK_OPKEY = "ok";

    public void beforeBindData(EventObject eventObject) {
        Map paramMap = (Map)this.getView().getFormShowParameter().getCustomParams().get("createorg");
        this.getModel().setValue("createorg", paramMap.get("createorg"));
        this.getModel().setValue("bsed", paramMap.get("bsed"));
        JSONObject model = (JSONObject)paramMap.get("entry");
        if (model != null) {
            for (String field : ENTRYFIELDS) {
                if ("rulecondition".equals(field) || "resultm".equals(field)) continue;
                if ("condattitem".equals(field) || "varcondition".equals(field)) {
                    JSONObject jsonObject = model.getJSONObject(field);
                    Long pk = jsonObject != null ? jsonObject.getLong("id") : null;
                    this.getModel().setValue(field, (Object)pk);
                    continue;
                }
                this.getModel().setValue(field, model.get((Object)field));
            }
        }
    }

    public void registerListener(EventObject event) {
        BasedataEdit fieldEdit = (BasedataEdit)this.getView().getControl("condattitem");
        fieldEdit.addBeforeF7SelectListener((BeforeF7SelectListener)this);
    }

    public void beforeF7Select(BeforeF7SelectEvent beforeF7SelectEvent) {
        Date bsed = (Date)this.getModel().getValue("bsed");
        QFilter corQfliter = new QFilter("firstbsed", "<=", (Object)bsed);
        beforeF7SelectEvent.addCustomQFilter(corQfliter);
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        if (!this.checkZero()) {
            args.setCancel(true);
        }
    }

    public void afterDoOperation(AfterDoOperationEventArgs afterDoOperationEventArgs) {
        String opKey = afterDoOperationEventArgs.getOperateKey();
        if (OK_OPKEY.equals(opKey)) {
            IFormView view = this.getView();
            IFormView parentView = view.getParentView();
            if (parentView == null) {
                return;
            }
            HashMap<String, Object> data = new HashMap<String, Object>(16);
            this.setParentDate(data);
            view.returnDataToParent(data);
            view.sendFormAction(parentView);
            view.close();
        }
    }

    private boolean checkZero() {
        DynamicObject dy = this.getModel().getDataEntity();
        String tip = ResManager.loadKDString((String)"\u503c\u4e0d\u80fd\u4e3a\u7a7a", (String)"QTQualificationInfoPlugin_0", (String)"wtc-wtp-formplugin", (Object[])new Object[0]);
        BigDecimal limitquatity = dy.getBigDecimal("limitquatitym");
        BigDecimal limitprecentg = dy.getBigDecimal("limitprecentgm");
        String limitmethod = dy.getString("limitmethodm");
        boolean tag = true;
        ArrayList<FieldTip> tipsList = new ArrayList<FieldTip>(16);
        if (QTLimitMethodEnum.FIXED_VALE.getCode().equals(limitmethod)) {
            if (limitquatity == null) {
                FieldTip fieldTip = this.createTip("limitquatitym", tip);
                tipsList.add(fieldTip);
                tag = false;
            }
        } else if (limitprecentg == null) {
            FieldTip fieldTip = this.createTip("limitprecentgm", tip);
            tipsList.add(fieldTip);
            tag = false;
        }
        this.getView().showFieldTips(tipsList);
        return tag;
    }

    private FieldTip createTip(String fieldName, String tip) {
        FieldTip fieldTip = new FieldTip();
        fieldTip.setSuccess(false);
        fieldTip.setTip(tip);
        fieldTip.setTipsType(FieldTip.FieldTipsTypes.scope);
        fieldTip.setFieldKey(fieldName);
        fieldTip.setLevel(FieldTip.FieldTipsLevel.Error);
        return fieldTip;
    }

    private void setParentDate(Map<String, Object> data) {
        DynamicObject dynamicObject = this.getModel().getDataEntity();
        QTQualificationInfo qualificationInfo = new QTQualificationInfo();
        qualificationInfo.changToMobile(dynamicObject);
        for (String field : ENTRYFIELDS) {
            if ("rulecondition".equals(field)) {
                data.put(field, qualificationInfo.getRuleCondition());
                continue;
            }
            if ("resultm".equals(field)) {
                data.put(field, qualificationInfo.getResult());
                continue;
            }
            if ("condattitem".equals(field) || "varcondition".equals(field)) {
                DynamicObject dynamicObject1 = this.getModel().getDataEntity().getDynamicObject(field);
                Object pk = dynamicObject1 != null ? dynamicObject1.getPkValue() : null;
                data.put(field, pk);
                continue;
            }
            data.put(field, this.getModel().getValue(field));
        }
    }

    public void propertyChanged(PropertyChangedArgs pro) {
        String name = pro.getProperty().getName();
        ChangeData[] changeSet = pro.getChangeSet();
        ChangeData changeData = changeSet[0];
        if ("qualitytype".equals(name)) {
            boolean mustInput = QTQualityTypeEnum.ATTITEM.getCode().equals(changeData.getNewValue());
            FieldEdit attControl = (FieldEdit)this.getView().getControl("condattitem");
            FieldEdit conditionControl = (FieldEdit)this.getView().getControl("varcondition");
            attControl.setMustInput(mustInput);
            conditionControl.setMustInput(!mustInput);
            if (mustInput) {
                this.getModel().setValue("varcondition", null);
            } else {
                this.getModel().setValue("condattitem", null);
            }
            this.getView().updateView("condattitem");
            this.getView().updateView("varcondition");
        }
        if ("limitmethodm".equals(name)) {
            boolean isFixedValue = QTLimitMethodEnum.FIXED_VALE.getCode().equals(changeData.getNewValue());
            FieldEdit preControl = (FieldEdit)this.getView().getControl("limitprecentgm");
            FieldEdit quatityControl = (FieldEdit)this.getView().getControl("limitquatitym");
            preControl.setMustInput(isFixedValue);
            quatityControl.setMustInput(!isFixedValue);
            if (isFixedValue) {
                this.getModel().setValue("limitprecentgm", null);
            } else {
                this.getModel().setValue("limitquatitym", null);
            }
            this.getView().updateView("limitprecentgm");
            this.getView().updateView("limitquatitym");
        }
    }
}

