/*
 * Decompiled with CFR 0.152.
 */
package kd.wtc.wtp.formplugin.web.quota.useconfig;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.EventObject;
import java.util.List;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.entity.operate.SaveAndNew;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.field.BasedataEdit;
import kd.bos.form.field.FieldEdit;
import kd.bos.form.field.events.BeforeF7SelectEvent;
import kd.bos.form.field.events.BeforeF7SelectListener;
import kd.bos.form.operate.FormOperate;
import kd.bos.orm.query.QFilter;
import kd.hr.hbp.formplugin.web.HRDataBaseEdit;
import kd.wtc.wtp.formplugin.web.quota.QTAttItemFilterUtils;
import kd.wtc.wtp.formplugin.web.quota.QTAttitemService;

public class QTUseConfigEdit
extends HRDataBaseEdit
implements BeforeF7SelectListener {
    private static final QTAttItemFilterUtils.QTControlInfo[] ctrlArr;
    private static final List<String> pros;

    public void registerListener(EventObject e) {
        BasedataEdit useDuration = (BasedataEdit)this.getControl("useduration");
        useDuration.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        BasedataEdit freeze = (BasedataEdit)this.getControl("freeze");
        freeze.addBeforeF7SelectListener((BeforeF7SelectListener)this);
    }

    public void beforeBindData(EventObject evt) {
        int startDelay = this.getModel().getDataEntity().getInt("startdelay");
        Integer showStartDelay = startDelay == 0 ? null : Integer.valueOf(startDelay);
        this.getModel().setValue("sstartdelay", (Object)showStartDelay);
        int endDelay = this.getModel().getDataEntity().getInt("enddelay");
        Integer showEndDelay = endDelay == 0 ? null : Integer.valueOf(endDelay);
        this.getModel().setValue("senddelay", (Object)showEndDelay);
    }

    public void afterBindData(EventObject e) {
        if (this.getModel().getDataEntity().getBoolean("sdelay")) {
            this.showStartDelayControls();
        }
        if (this.getModel().getDataEntity().getBoolean("edelay")) {
            this.showEndDelayControls();
        }
    }

    public void beforeF7Select(BeforeF7SelectEvent evt) {
        String propertyName = evt.getProperty().getName();
        if ("useduration".equals(propertyName) || "freeze".equals(propertyName)) {
            Date startDate = this.getModel().getDataEntity().getDate("bsed");
            if (startDate == null) {
                this.getView().showErrorNotification(ResManager.loadKDString((String)"\u8bf7\u6309\u8981\u6c42\u586b\u5199\u201c\u751f\u6548\u65e5\u671f\u201d\u3002", (String)"QTUseConfigEdit_1", (String)"wtc-wtp-formplugin", (Object[])new Object[0]));
                evt.setCancel(true);
                return;
            }
            QFilter qFilter = QTAttItemFilterUtils.getQTConfigItemFilter(startDate);
            evt.setCustomQFilters(Collections.singletonList(qFilter));
        }
    }

    public void propertyChanged(PropertyChangedArgs args) {
        String propertyName = args.getProperty().getName();
        if ("sdelay".equals(propertyName)) {
            if (this.getModel().getDataEntity().getBoolean("sdelay")) {
                this.showStartDelayControls();
            } else {
                this.hideStartDelayControls();
            }
        } else if ("edelay".equals(propertyName)) {
            if (this.getModel().getDataEntity().getBoolean("edelay")) {
                this.showEndDelayControls();
            } else {
                this.hideEndDelayControls();
            }
        }
    }

    private void showStartDelayControls() {
        ((FieldEdit)this.getControl("sstartdelay")).setMustInput(true);
        ((FieldEdit)this.getControl("startdelayunit")).setMustInput(true);
        this.getView().setVisible(Boolean.TRUE, new String[]{"sstartdelay", "startdelayunit"});
    }

    private void hideStartDelayControls() {
        ((FieldEdit)this.getControl("sstartdelay")).setMustInput(false);
        ((FieldEdit)this.getControl("startdelayunit")).setMustInput(false);
        this.getModel().setValue("sstartdelay", null);
        this.getModel().setValue("startdelayunit", null);
        this.getView().setVisible(Boolean.FALSE, new String[]{"sstartdelay", "startdelayunit"});
    }

    private void showEndDelayControls() {
        ((FieldEdit)this.getControl("senddelay")).setMustInput(true);
        ((FieldEdit)this.getControl("enddelayunit")).setMustInput(true);
        this.getView().setVisible(Boolean.TRUE, new String[]{"senddelay", "enddelayunit"});
    }

    private void hideEndDelayControls() {
        ((FieldEdit)this.getControl("senddelay")).setMustInput(false);
        ((FieldEdit)this.getControl("enddelayunit")).setMustInput(false);
        this.getModel().setValue("senddelay", null);
        this.getModel().setValue("enddelayunit", null);
        this.getView().setVisible(Boolean.FALSE, new String[]{"senddelay", "enddelayunit"});
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        Object source = args.getSource();
        String operateKey = ((FormOperate)source).getOperateKey();
        if (source instanceof SaveAndNew) {
            SaveAndNew opSource = (SaveAndNew)source;
            operateKey = opSource.getOriOperateKey();
        }
        DynamicObject dataEntity = this.getModel().getDataEntity();
        switch (operateKey) {
            case "save": 
            case "saveandnew": 
            case "submit": 
            case "submitandaudit": 
            case "confirmchange": 
            case "confirmchangenoaudit": {
                if (QTAttitemService.checkAttitemEmpty(dataEntity, this.getView(), pros)) {
                    args.setCancel(true);
                    return;
                }
                Object sStartDelay = dataEntity.get("sstartdelay");
                this.getModel().setValue("startdelay", sStartDelay == null ? Integer.valueOf(0) : sStartDelay);
                Object sEndDelay = dataEntity.get("senddelay");
                this.getModel().setValue("enddelay", sEndDelay == null ? Integer.valueOf(0) : sEndDelay);
                String errMsg = QTAttItemFilterUtils.checkFirstBSED(dataEntity, ctrlArr);
                if (errMsg != null) {
                    args.setCancel(true);
                    this.getView().showErrorNotification(errMsg);
                }
                if (!QTAttitemService.checkAttitemEqual(dataEntity, this.getView(), pros)) break;
                args.setCancel(true);
                return;
            }
        }
    }

    static {
        pros = new ArrayList<String>(){
            {
                this.add("useduration");
                this.add("freeze");
            }
        };
        ctrlArr = new QTAttItemFilterUtils.QTControlInfo[2];
        String useItemName = ResManager.loadKDString((String)"\u5b9a\u989d\u4f7f\u7528\u65f6\u957f", (String)"QTUseConfigEdit_3", (String)"wtc-wtp-formplugin", (Object[])new Object[0]);
        QTUseConfigEdit.ctrlArr[0] = new QTAttItemFilterUtils.QTControlInfo("useduration", useItemName);
        String freeItemName = ResManager.loadKDString((String)"\u5b9a\u989d\u51bb\u7ed3\u65f6\u957f", (String)"QTUseConfigEdit_4", (String)"wtc-wtp-formplugin", (Object[])new Object[0]);
        QTUseConfigEdit.ctrlArr[1] = new QTAttItemFilterUtils.QTControlInfo("freeze", freeItemName);
    }
}

