/*
 * Decompiled with CFR 0.152.
 */
package kd.wtc.wtp.formplugin.web.ruleenging;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.EventObject;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import kd.bos.bill.BillShowParameter;
import kd.bos.bill.OperationStatus;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.entity.OrmLocaleValue;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.db.DB;
import kd.bos.entity.datamodel.AbstractFormDataModel;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.datamodel.TableValueSetter;
import kd.bos.entity.datamodel.events.ChangeData;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.exception.ErrorCode;
import kd.bos.exception.KDException;
import kd.bos.ext.hr.ruleengine.controls.DefaultResult;
import kd.bos.form.CloseCallBack;
import kd.bos.form.ConfirmCallBackListener;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.IPageCache;
import kd.bos.form.MessageBoxOptions;
import kd.bos.form.MessageBoxResult;
import kd.bos.form.OpenStyle;
import kd.bos.form.ShowType;
import kd.bos.form.StyleCss;
import kd.bos.form.control.EntryGrid;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.events.HyperLinkClickEvent;
import kd.bos.form.events.HyperLinkClickListener;
import kd.bos.form.events.MessageBoxClosedEvent;
import kd.bos.form.operate.AbstractOperate;
import kd.bos.form.plugin.IFormPlugin;
import kd.hr.hbp.common.util.HRDateTimeUtils;
import kd.hr.hbp.common.util.HRDynamicObjectUtils;
import kd.hr.hbp.common.util.HRObjectUtils;
import kd.hr.hbp.common.util.HRStringUtils;
import kd.hr.hbp.formplugin.web.HRDataBaseEdit;
import kd.wtc.wtbs.business.history.service.WTCHisService;
import kd.wtc.wtbs.common.util.WTCSerializationUtils;
import kd.wtc.wtbs.common.util.WTCStringUtils;
import kd.wtc.wtbs.common.util.third.collect.Lists;
import kd.wtc.wtbs.common.util.third.collect.Maps;
import kd.wtc.wtp.business.ruleenging.RuleEngingHelper;
import kd.wtc.wtp.business.ruleenging.RuleEngingService;
import kd.wtc.wtp.business.ruleenging.RuleOrder;
import kd.wtc.wtp.business.ruleenging.RuleOrderTool;
import kd.wtc.wtp.business.ruleenging.RulePreviewUtil;
import kd.wtc.wtp.common.constants.RuleEngingConstants;

public class RuleEngingEdit
extends HRDataBaseEdit
implements RuleEngingConstants,
HyperLinkClickListener {
    private static final String CALL_BACK_RULE_PAGE_NEW = "CALL_BACK_RULE_PAGE_NEW";
    private static final String RETRUNDEFAULT = "retrundefault";
    private final RuleOrderTool ruleOrderTool = new RuleOrderTool();

    private DefaultResult getDefaultResult() {
        return (DefaultResult)this.getControl("defaultresultap");
    }

    public void registerListener(EventObject evt) {
        super.registerListener(evt);
        EntryGrid entryGrid = (EntryGrid)this.getView().getControl("entryrulelist");
        entryGrid.addHyperClickListener((HyperLinkClickListener)this);
    }

    public void beforeBindData(EventObject evt) {
        super.beforeBindData(evt);
        if (!this.isSpecifiedDirectly(this.getView())) {
            return;
        }
        this.setAdvconapVisitAndRuleSet();
        this.initNewData(false);
        this.initRuleOrderTool();
        this.getView().getParentView().getModel().setDataChanged(false);
    }

    public void afterBindData(EventObject evt) {
        super.afterBindData(evt);
        String pageState = WTCHisService.isLock((IFormView)this.getView().getParentView()) ? "VIEW" : "EDIT";
        this.getDefaultResult().setPageState(pageState);
    }

    public void propertyChanged(PropertyChangedArgs evt) {
        super.propertyChanged(evt);
        String propertyName = evt.getProperty().getName();
        if ("ruleset".equals(propertyName)) {
            RuleEngingService.getCache().put(this.getView().getParentView().getPageId(), this.getModel().getValue("ruleset"));
            this.getView().getParentView().getPageCache().put("ruleset", (String)this.getModel().getValue("ruleset"));
            String radioGroupField = this.getModel().getDataEntity().getString("ruleset");
            this.getView().getParentView().getModel().setValue("setruleway", (Object)radioGroupField);
            RuleEngingService.getCache().put(this.getView().getParentView().getModel().getValue("number") + "setruleway", (Object)radioGroupField);
            if ("1".equals(radioGroupField)) {
                this.getView().getParentView().setVisible(Boolean.TRUE, new String[]{"advconap"});
            } else if ("2".equals(radioGroupField)) {
                this.getView().getParentView().setVisible(Boolean.FALSE, new String[]{"advconap"});
                this.initNewData(true);
                this.initRuleOrderTool();
            }
            this.getView().sendFormAction(this.getView().getParentView());
        } else if (RETRUNDEFAULT.equals(propertyName)) {
            if (((Boolean)this.getModel().getValue(RETRUNDEFAULT)).booleanValue()) {
                String planFlag = (String)this.getView().getFormShowParameter().getCustomParam("planFlag");
                DynamicObject sceneDy = RuleEngingHelper.queryScene((String)RuleEngingConstants.Plan.getSceneNumberByPlanFlag((String)planFlag));
                this.getDefaultResult().setScene(String.valueOf(sceneDy.getLong("id")));
            } else {
                this.getDefaultResult().clear();
            }
        } else if ("ruleenable".equals(propertyName)) {
            this.validateRuleEnable(evt);
        }
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        String operateKey;
        super.beforeDoOperation(args);
        switch (operateKey = ((AbstractOperate)args.getSource()).getOperateKey()) {
            case "deleteruleentry": {
                this.validateSelectOneRow(args);
                break;
            }
            case "moveentryup_": {
                this.validateSelectRows(args);
                this.validateMoveUp(args);
                break;
            }
            case "moveentrydown_": {
                this.validateSelectRows(args);
                this.validateMoveDown(args);
                break;
            }
            case "refreshcache": {
                args.setCancel(true);
                this.setRuleEngingCacheData(this.getModel());
                break;
            }
        }
    }

    public void afterDoOperation(AfterDoOperationEventArgs args) {
        String operateKey;
        switch (operateKey = ((AbstractOperate)args.getSource()).getOperateKey()) {
            case "newrule": {
                this.showRuleDesignTab(null);
                break;
            }
            case "insertruleentry": {
                this.showRuleDesignTab(null);
                break;
            }
            case "deleteruleentry": {
                this.handleDeleteRule();
                break;
            }
            case "moveentryup_": {
                this.moveEntryUp();
                break;
            }
            case "moveentrydown_": {
                this.moveEntryDown();
                break;
            }
            case "save": {
                if (!args.getOperationResult().isSuccess()) break;
                RuleEngingHelper.saveRuleAssociation((DynamicObject)this.getModel().getDataEntity());
                break;
            }
        }
    }

    public void confirmCallBack(MessageBoxClosedEvent evt) {
        String callBack = evt.getCallBackId();
        int result = evt.getResult().getValue();
        if (HRStringUtils.equals((String)callBack, (String)"deleteRuleConfirmCallBack") && result == MessageBoxResult.Yes.getValue()) {
            EntryGrid ruleEntry = (EntryGrid)this.getView().getControl("entryrulelist");
            this.handleDeleteRuleOrder(ruleEntry.getSelectRows());
            this.getModel().deleteEntryRows("entryrulelist", ruleEntry.getSelectRows());
            this.setRuleEngingCacheData(this.getModel());
        }
    }

    public void closedCallBack(ClosedCallBackEvent event) {
        super.closedCallBack(event);
        String actionId = event.getActionId();
        Object returnData = event.getReturnData();
        if (HRObjectUtils.isEmpty((Object)returnData)) {
            return;
        }
        this.setRuleEngingCache(actionId, (Map)returnData);
    }

    private void setRuleEngingCache(String actionId, Map<String, Object> returnData) {
        IDataModel model = this.getModel();
        if (HRStringUtils.equals((String)CALL_BACK_RULE_PAGE_NEW, (String)actionId)) {
            String ruleDesignStr = String.valueOf(returnData.get("ruleDesign"));
            String filterCondition = String.valueOf(returnData.get("conditions"));
            String filterResult = String.valueOf(returnData.get("results"));
            Object descriptionObject = returnData.get("description");
            OrmLocaleValue description = null;
            if (!HRObjectUtils.isEmpty((Object)descriptionObject)) {
                description = (OrmLocaleValue)WTCSerializationUtils.deSerializeFromBase64((String)String.valueOf(descriptionObject));
            }
            if (!HRStringUtils.isEmpty((String)ruleDesignStr)) {
                this.getPageCache().remove("ruleConfigDy");
                this.fillRuleDesignEntryForNew(ruleDesignStr, filterCondition, filterResult, model, description);
                this.getPageCache().remove("conditionJson");
                this.getPageCache().remove("resultJson");
            }
        }
        this.setRuleEngingCacheData(model);
    }

    private void setRuleEngingCacheData(IDataModel model) {
        String resultJson = null;
        boolean retrunDefault = (Boolean)this.getModel().getValue(RETRUNDEFAULT);
        if (retrunDefault) {
            resultJson = this.getDefaultResult().getValue();
        }
        DynamicObject pageDy = model.getDataEntity();
        HashMap policyMap = Maps.newHashMapWithExpectedSize((int)14);
        policyMap.put("policymode", "FirstMatch");
        policyMap.put("bizappid", RuleEngingHelper.queryAppIdByNumber((String)this.getView().getFormShowParameter().getAppId()));
        policyMap.put("scene", pageDy.getLong("scene.id"));
        policyMap.put("enable", pageDy.getString("enable"));
        policyMap.put("results", resultJson);
        policyMap.put("defaultresultap", retrunDefault);
        policyMap.put("rostercondition", "");
        policyMap.put("rosterresult", "");
        DynamicObjectCollection entryRuleDys = model.getEntryEntity("entryrulelist");
        ArrayList entryRuleList = Lists.newArrayListWithExpectedSize((int)entryRuleDys.size());
        for (DynamicObject entryRuleDy : entryRuleDys) {
            HashMap entryRuleMap = Maps.newHashMapWithExpectedSize((int)8);
            entryRuleMap.put("id", entryRuleDy.get("id"));
            entryRuleMap.put("rulename", entryRuleDy.getString("rulename"));
            entryRuleMap.put("rulenumber", entryRuleDy.getString("rulenumber"));
            entryRuleMap.put("ruleorder", entryRuleDy.getInt("ruleorder"));
            entryRuleMap.put("ruleenable", entryRuleDy.getBoolean("ruleenable"));
            entryRuleMap.put("filtercondition", entryRuleDy.getString("filtercondition"));
            entryRuleMap.put("filterresult", entryRuleDy.getString("filterresult"));
            entryRuleMap.put("ruledescription", entryRuleDy.getString("ruledescript"));
            entryRuleList.add(entryRuleMap);
        }
        policyMap.put("entryrulelist", entryRuleList);
        LinkedHashMap entryBuMap = Maps.newLinkedHashMapWithExpectedSize((int)2);
        Long createOrgId = this.getView().getParentView().getModel().getDataEntity().getLong("createorg.id");
        entryBuMap.put("entitybu", createOrgId);
        entryBuMap.put("containssub", Boolean.TRUE);
        List<LinkedHashMap> entryBuList = Collections.singletonList(entryBuMap);
        policyMap.put("entrybulist", entryBuList);
        IPageCache pageCache = this.getView().getParentView().getPageCache();
        pageCache.put("entryrulelist", JSONArray.toJSONString((Object)policyMap));
    }

    private void showRuleDesignTab(Map<String, Object> policyMap) {
        Date startDate = null;
        IFormView parentView = this.getView().getParentView();
        if (parentView != null && (startDate = parentView.getModel().getDataEntity().getDate("bsed")) == null) {
            parentView.showTipNotification(ResManager.loadKDString((String)"\u8bf7\u6309\u8981\u6c42\u586b\u5199\u201c\u751f\u6548\u65e5\u671f\u201d\u3002", (String)"RuleEngingEdit_0", (String)"wtc-wtp-formplugin", (Object[])new Object[0]));
            this.getView().sendFormAction(parentView);
            return;
        }
        BillShowParameter fsp = new BillShowParameter();
        HashMap params = Maps.newHashMapWithExpectedSize((int)16);
        params.put("rule_design_edit", Boolean.FALSE);
        fsp.setCustomParams((Map)params);
        fsp.setCloseCallBack(new CloseCallBack((IFormPlugin)this, CALL_BACK_RULE_PAGE_NEW));
        fsp.setCustomParam("sceneid", this.getModel().getDataEntity().get("scene.id"));
        fsp.setCustomParam("policyid", this.getModel().getDataEntity().get("policyid"));
        fsp.setCustomParam("entryrulelist", policyMap);
        fsp.setFormId("wtp_ruleengingset");
        boolean isLock = WTCHisService.isLock((IFormView)this.getView().getParentView());
        fsp.setCustomParam("isLock", (Object)isLock);
        fsp.setCustomParam("bsed", (Object)HRDateTimeUtils.format((Date)startDate, (String)"yyyy-MM-dd"));
        fsp.setCustomParam("planFlag", this.getView().getFormShowParameter().getCustomParam("planFlag"));
        fsp.setParentPageId(this.getView().getPageId());
        fsp.setPageId(WTCStringUtils.joinStr((String[])new String[]{this.getView().getPageId(), "_", "page_id_new_rule", "_", String.valueOf(DB.genGlobalLongId())}));
        fsp.setCaption(ResManager.loadKDString((String)"\u65b0\u589e\u89c4\u5219", (String)"RuleEngingEdit_1", (String)"wtc-wtp-formplugin", (Object[])new Object[0]));
        fsp.getOpenStyle().setShowType(ShowType.Modal);
        OpenStyle openStyle = fsp.getOpenStyle();
        StyleCss inlineStyleCss = new StyleCss();
        inlineStyleCss.setWidth("1500px");
        openStyle.setInlineStyleCss(inlineStyleCss);
        this.getView().showForm((FormShowParameter)fsp);
    }

    private void fillRuleDesignEntryForNew(String ruleDesignStr, String filterCondition, String filterResult, IDataModel model, OrmLocaleValue description) {
        model.beginInit();
        DynamicObject ruleDesignDy = RuleEngingService.parseDynamicObjectJson((String)ruleDesignStr, (String)"brm_ruledesign");
        Object number = ((Map)JSON.parseObject((String)ruleDesignStr, Map.class)).get("number");
        DynamicObjectCollection entryDys = this.getModel().getEntryEntity("entryrulelist");
        List modifyEntryList = entryDys.stream().filter(entryDy -> HRObjectUtils.equals((Object)entryDy.get("rulenumber"), (Object)number)).collect(Collectors.toList());
        if (!modifyEntryList.isEmpty()) {
            DynamicObject modifyEntryDy = (DynamicObject)modifyEntryList.get(0);
            modifyEntryDy.set("rulenumber", ruleDesignDy.get("number"));
            modifyEntryDy.set("rulename", ruleDesignDy.get("name"));
            modifyEntryDy.set("filtercondition", (Object)filterCondition);
            modifyEntryDy.set("filterresult", (Object)filterResult);
            modifyEntryDy.set("ruledescript", (Object)description);
            modifyEntryDy.set("filterconditionpreview", (Object)RulePreviewUtil.getConditionPreviewStr((String)filterCondition));
            modifyEntryDy.set("filterresultpreview", (Object)RulePreviewUtil.getResultPreviewStr((String)filterResult));
        } else {
            int count = model.getEntryRowCount("entryrulelist");
            this.genRuleEntryListData(filterCondition, filterResult, ruleDesignDy, 0, description);
            this.handleNewRowOrder(count);
        }
        model.endInit();
        this.getView().updateView("entryrulelist");
    }

    private void genRuleEntryListData(String filterCondition, String filterResult, DynamicObject ruleDesignDy, int row, OrmLocaleValue description) {
        AbstractFormDataModel dataModel = (AbstractFormDataModel)this.getModel();
        dataModel.beginInit();
        TableValueSetter vs = new TableValueSetter(new String[0]);
        TableValueSetter tableValueSetter = vs.addRow(new Object[0]);
        tableValueSetter.set("rulenumber", ruleDesignDy.get("number"), row);
        tableValueSetter.set("rulename", ruleDesignDy.get("name"), row);
        tableValueSetter.set("filtercondition", (Object)filterCondition, row);
        tableValueSetter.set("filterresult", (Object)filterResult, row);
        tableValueSetter.set("ruledescript", (Object)description, row);
        tableValueSetter.set("filterconditionpreview", (Object)RulePreviewUtil.getConditionPreviewStr((String)filterCondition), row);
        tableValueSetter.set("filterresultpreview", (Object)RulePreviewUtil.getResultPreviewStr((String)filterResult), row);
        dataModel.batchCreateNewEntryRow("entryrulelist", vs);
        dataModel.endInit();
        this.getView().updateView("entryrulelist");
    }

    private void handleNewRowOrder(int count) {
        int newRowOrder = this.ruleOrderTool.addNewRuleOrder(this.getModel().getEntryRowEntity("entryrulelist", count), this.getPageCache());
        this.getModel().setValue("ruleorder", (Object)newRowOrder, count);
    }

    private void handleDeleteRule() {
        ConfirmCallBackListener confirmListener = new ConfirmCallBackListener("deleteRuleConfirmCallBack", (IFormPlugin)this);
        this.getView().showConfirm(ResManager.loadKDString((String)"\u5220\u9664\u89c4\u5219\u540e\u5c06\u65e0\u6cd5\u6062\u590d\uff0c\u786e\u8ba4\u5220\u9664\uff1f", (String)"RuleEngingEdit_2", (String)"wtc-wtp-formplugin", (Object[])new Object[0]), MessageBoxOptions.OKCancel, confirmListener);
    }

    private void moveEntryDown() {
        EntryGrid ruleEntry = (EntryGrid)this.getView().getControl("entryrulelist");
        if (ruleEntry.getSelectRows().length == 0) {
            return;
        }
        int currentRow = this.getModel().getEntryCurrentRowIndex("entryrulelist");
        this.ruleOrderTool.moveDownRuleOrder(currentRow - 1, this.getPageCache());
        this.reWriteEntryOrder();
    }

    private void moveEntryUp() {
        EntryGrid ruleEntry = (EntryGrid)this.getView().getControl("entryrulelist");
        if (ruleEntry.getSelectRows().length == 0) {
            return;
        }
        int currentRow = this.getModel().getEntryCurrentRowIndex("entryrulelist");
        this.ruleOrderTool.moveUpRuleOrder(currentRow + 1, this.getPageCache());
        this.reWriteEntryOrder();
    }

    private void reWriteEntryOrder() {
        ArrayList ruleOrders = this.ruleOrderTool.getEntryRowList(this.getPageCache());
        int index = 0;
        for (RuleOrder ruleOrder : ruleOrders) {
            this.getModel().setValue("ruleorder", (Object)ruleOrder.getOrder(), index++);
        }
    }

    private void handleDeleteRuleOrder(int[] selectedRows) {
        this.ruleOrderTool.deleteRuleOrder(selectedRows, this.getPageCache());
    }

    private void initNewData(boolean isChange) {
        this.initSceneData();
        FormShowParameter parameter = this.getView().getParentView().getFormShowParameter();
        OperationStatus status = parameter.getStatus();
        Object fromPage = parameter.getCustomParam("fromPage");
        Boolean isCopy = (Boolean)parameter.getCustomParam("iscopy");
        if (OperationStatus.ADDNEW.equals((Object)status) && !"fromHisAction".equals(fromPage) && !"revise".equals(fromPage) && isCopy != null && Boolean.TRUE.equals(isCopy == false)) {
            RuleEngingService.setPolicyNumberAndName((IDataModel)this.getView().getModel());
        } else {
            RuleEngingService.initViewAndEidtData((IFormView)this.getView(), (DefaultResult)this.getDefaultResult());
            this.setRuleEngingCacheData(this.getModel());
            if (isChange) {
                RuleEngingService.setPolicyNumberAndName((IDataModel)this.getView().getModel());
            }
        }
    }

    private void initRuleOrderTool() {
        this.ruleOrderTool.init(this.getModel().getEntryEntity("entryrulelist"), this.getPageCache());
        this.getModel().setValue("policyid", this.getView().getFormShowParameter().getCustomParam("policy"));
    }

    private boolean isSpecifiedDirectly(IFormView view) {
        FormShowParameter parameter = view.getFormShowParameter();
        String ruleSet = (String)this.getView().getFormShowParameter().getCustomParam("ruleset");
        if (!HRStringUtils.isEmpty((String)ruleSet)) {
            view.getParentView().getModel().setValue("setruleway", (Object)ruleSet);
            RuleEngingService.getCache().put(this.getView().getParentView().getModel().getValue("number") + "setruleway", (Object)ruleSet);
        }
        return "2".equals(ruleSet);
    }

    private void setAdvconapVisitAndRuleSet() {
        String ruleSet = (String)this.getView().getFormShowParameter().getCustomParam("ruleset");
        if ("1".equals(ruleSet)) {
            this.getView().getParentView().setVisible(Boolean.TRUE, new String[]{"advconap"});
            this.getView().getModel().setValue("ruleset", (Object)ruleSet);
        } else if ("2".equals(ruleSet)) {
            this.getView().getParentView().setVisible(Boolean.FALSE, new String[]{"advconap"});
            this.getView().getModel().setValue("ruleset", (Object)ruleSet);
        }
    }

    private void validateSelectOneRow(BeforeDoOperationEventArgs args) {
        EntryGrid ruleEntry = (EntryGrid)this.getView().getControl("entryrulelist");
        if (ruleEntry.getSelectRows().length == 0) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u4e2d\u4e00\u884c\u518d\u8fdb\u884c\u64cd\u4f5c\u3002", (String)"RuleEngingEdit_3", (String)"wtc-wtp-formplugin", (Object[])new Object[0]));
            args.setCancel(true);
        }
    }

    private void validateSelectRows(BeforeDoOperationEventArgs args) {
        EntryGrid ruleEntry = (EntryGrid)this.getView().getControl("entryrulelist");
        if (ruleEntry.getSelectRows().length > 1) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u53ea\u80fd\u5bf9\u9009\u4e2d\u7684\u4e00\u884c\u8fdb\u884c\u8be5\u64cd\u4f5c\u3002", (String)"RuleEngingEdit_4", (String)"wtc-wtp-formplugin", (Object[])new Object[0]));
            args.setCancel(true);
        }
    }

    private void validateMoveUp(BeforeDoOperationEventArgs args) {
        int currentIndex = this.getModel().getEntryCurrentRowIndex("entryrulelist");
        if (currentIndex == 0) {
            args.setCancel(true);
        }
    }

    private void validateMoveDown(BeforeDoOperationEventArgs args) {
        int currentIndex = this.getModel().getEntryCurrentRowIndex("entryrulelist");
        if (currentIndex == this.getModel().getEntryRowCount("entryrulelist") - 1) {
            args.setCancel(true);
        }
    }

    private void initSceneData() {
        FormShowParameter parameter = this.getView().getFormShowParameter();
        IDataModel model = this.getView().getModel();
        String planFlag = (String)parameter.getCustomParam("planFlag");
        String sceneNumber = RuleEngingConstants.Plan.getSceneNumberByPlanFlag((String)planFlag);
        if (sceneNumber == null || sceneNumber.isEmpty()) {
            throw new KDException(ErrorCode.of((String)"500", (String)"wtp", (String)"wtc_wtp_formplugin", (String)ResManager.loadKDString((String)"\u672a\u83b7\u53d6\u5230\u914d\u7f6e\u7684\u573a\u666f", (String)"RuleEngingEdit_5", (String)"wtc-wtp-formplugin", (Object[])new Object[0])), new Object[]{new Object()});
        }
        DynamicObject sceneDy = RuleEngingHelper.queryScene((String)sceneNumber);
        if (sceneDy == null) {
            throw new KDException(ErrorCode.of((String)"500", (String)"wtp", (String)"wtc_wtp_formplugin", (String)ResManager.loadKDString((String)"\u672a\u83b7\u53d6\u5230\u914d\u7f6e\u7684\u573a\u666f", (String)"RuleEngingEdit_5", (String)"wtc-wtp-formplugin", (Object[])new Object[0])), new Object[]{new Object()});
        }
        model.setValue("scene", (Object)sceneDy);
        ((DefaultResult)this.getView().getControl("defaultresultap")).setScene(String.valueOf(sceneDy.getLong("id")));
    }

    public void hyperLinkClick(HyperLinkClickEvent event) {
        String fieldName = event.getFieldName();
        if ("rulename".equals(fieldName)) {
            Map stringObjectMap = HRDynamicObjectUtils.convertDynamicObjectToMap((DynamicObject)((DynamicObject)this.getModel().getEntryEntity("entryrulelist").get(event.getRowIndex())));
            this.showRuleDesignTab(stringObjectMap);
        }
    }

    private void validateRuleEnable(PropertyChangedArgs evt) {
        DynamicObjectCollection entryDys;
        long count;
        ChangeData changeSet = evt.getChangeSet()[0];
        boolean enable = Boolean.parseBoolean(String.valueOf(changeSet.getNewValue()));
        if (!enable && (count = (entryDys = this.getModel().getEntryEntity("entryrulelist")).stream().filter(entryDy -> entryDy.getBoolean("ruleenable")).count()) == 0L) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u786e\u4fdd\u81f3\u5c11\u6709\u4e00\u6761\u201c\u4f7f\u7528\u72b6\u6001\u201d\u4e3a\u5f00\u542f\u72b6\u6001\u3002", (String)"RuleEngingEdit_6", (String)"wtc-wtp-formplugin", (Object[])new Object[0]));
            this.getModel().setValue("ruleenable", changeSet.getOldValue());
        }
    }
}

