/*
 * Decompiled with CFR 0.152.
 */
package kd.wtc.wtp.formplugin.web.ruleenging;

import java.util.EventObject;
import java.util.Map;
import java.util.Objects;
import kd.bos.bill.BillOperationStatus;
import kd.bos.bill.BillShowParameter;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.utils.ArrayUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.ext.hr.ruleengine.controls.DefaultResult;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.operate.FormOperate;
import kd.hr.hbp.common.util.HRStringUtils;
import kd.hr.hbp.formplugin.web.HRDataBaseEdit;
import kd.wtc.wtbs.business.history.service.WTCHisService;
import kd.wtc.wtp.business.ruleenging.RuleEngingHelper;
import kd.wtc.wtp.business.ruleenging.RuleEngingService;
import kd.wtc.wtp.common.constants.RuleEngingConstants;

public class RuleEngingPublicEdit
extends HRDataBaseEdit
implements RuleEngingConstants {
    public void afterBindData(EventObject evt) {
        super.afterBindData(evt);
        if (RuleEngingService.checkRuleEngingEnableSet()) {
            return;
        }
        Boolean iscopy = (Boolean)this.getView().getFormShowParameter().getCustomParam("iscopy");
        if (Boolean.TRUE.equals(iscopy)) {
            DynamicObject dy;
            FormShowParameter formShowParameter = this.getView().getFormShowParameter();
            Object pkId = null;
            if (formShowParameter instanceof BillShowParameter) {
                pkId = ((BillShowParameter)formShowParameter).getPkId();
            }
            if (pkId != null && (dy = RuleEngingHelper.queryPolicyDataByPlanId((long)Long.parseLong(String.valueOf(((BillShowParameter)this.getView().getFormShowParameter()).getPkId())))) != null) {
                this.getModel().setValue("setruleway", (Object)dy.getString("ruleset"));
                this.getModel().setValue("policyid", (Object)dy.getLong("policyid"));
            }
        }
        this.initData();
        this.getModel().setDataChanged(false);
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        super.beforeDoOperation(args);
        FormOperate operate = (FormOperate)args.getSource();
        String operateKey = operate.getOperateKey();
        String setRuleWay = String.valueOf(this.getModel().getValue("setruleway"));
        if (RuleEngingService.checkRuleEngingEnableSet() || !"2".equals(setRuleWay)) {
            operate.getOption().setVariableValue("setruleway", setRuleWay);
            return;
        }
        if (!"new".equals(operateKey)) {
            this.handleChildPage();
        }
        if ("audit".equals(operateKey)) {
            operate.getOption().setVariableValue("option", "audit");
        }
        operate.getOption().setVariableValue("setruleway", String.valueOf(this.getModel().getValue("setruleway")));
        operate.getOption().setVariableValue("policynumber", this.getView().getPageCache().get("number"));
        operate.getOption().setVariableValue("entryrulelist", this.getView().getPageCache().get("entryrulelist"));
    }

    private void handleChildPage() {
        String childPageId = this.getPageCache().get("childpageid");
        if (StringUtils.isNotBlank((CharSequence)childPageId)) {
            IFormView childView = this.getView().getView(childPageId);
            childView.invokeOperation("refreshcache");
            this.getView().sendFormAction(childView);
        }
    }

    public void afterDoOperation(AfterDoOperationEventArgs args) {
        super.afterDoOperation(args);
        if (RuleEngingService.checkRuleEngingEnableSet()) {
            return;
        }
        String operateKey = args.getOperateKey();
        if (HRStringUtils.equals((String)"new", (String)operateKey)) {
            this.getModel().setValue("setruleway", (Object)"1");
            RuleEngingService.genShowRuleEngingPage((IFormView)this.getView());
            this.getModel().setDataChanged(false);
        }
        if (Objects.nonNull(args.getOperationResult()) && args.getOperationResult().isSuccess()) {
            boolean isSaveOrSubmit;
            String pageId = this.getPageCache().get("childpageid");
            if (pageId != null) {
                IFormView view = this.getView().getView(pageId);
                view.setStatus(RuleEngingService.getFormStatus((IFormView)this.getView(), (boolean)true));
                String pageState = WTCHisService.isLock((IFormView)this.getView()) ? "VIEW" : "EDIT";
                this.getDefaultResult().setPageState(pageState);
                this.getView().sendFormAction(view);
                this.getView().updateView(pageId);
            }
            boolean bl = isSaveOrSubmit = "save".equals(operateKey) || "submit".equals(operateKey) || "confirmchangenoaudit".equals(operateKey) || "confirmchange".equals(operateKey);
            if (isSaveOrSubmit) {
                RuleEngingService.genShowRuleEngingPage((IFormView)this.getView());
            }
        }
    }

    public void propertyChanged(PropertyChangedArgs args) {
        String name = args.getProperty().getName();
        if ("setruleway".equals(name)) {
            if (ArrayUtils.isEmpty((Object[])args.getChangeSet())) {
                return;
            }
            String newValue = (String)args.getChangeSet()[0].getNewValue();
            boolean isEngineSetWay = StringUtils.equals((CharSequence)"2", (CharSequence)newValue);
            this.getView().setVisible(Boolean.valueOf(!isEngineSetWay), new String[]{"advconap"});
        }
    }

    private DefaultResult getDefaultResult() {
        String pageId = this.getPageCache().get("childpageid");
        return (DefaultResult)this.getView().getView(pageId).getControl("defaultresultap");
    }

    private void initData() {
        FormShowParameter parameter = this.getView().getFormShowParameter();
        Map customParams = parameter.getCustomParams();
        Object fromPage = customParams.get("fromPage");
        WTCHisService.updateRealBillStatus((IFormView)this.getView());
        String realBillStatus = this.getView().getPageCache().get("realBillStatus");
        boolean isAddNew = String.valueOf(BillOperationStatus.ADDNEW.getValue()).equals(realBillStatus);
        boolean isFromHisAction = "fromHisAction".equals(fromPage);
        boolean isRevise = "revise".equals(fromPage);
        boolean isOpenInsertNewDataPage = "open_insert_new_data_page".equals(parameter.getCustomParam("his_action"));
        Boolean iscopy = (Boolean)this.getView().getFormShowParameter().getCustomParam("iscopy");
        boolean isOpenVersionPage = "openVersionPage".equals(fromPage);
        boolean isHisCopy = "open_copy_his_data_page".equals(customParams.get("his_action"));
        if (!isAddNew || isFromHisAction && !isOpenInsertNewDataPage || isRevise || Boolean.TRUE.equals(iscopy) && !isFromHisAction || isOpenVersionPage || isHisCopy) {
            Object pkId;
            long id = this.getCurrentDataId(customParams);
            if (this.getView().getFormShowParameter() instanceof BillShowParameter && (pkId = ((BillShowParameter)this.getView().getFormShowParameter()).getPkId()) != null) {
                long l = id = id == 0L ? Long.parseLong(String.valueOf(((BillShowParameter)this.getView().getFormShowParameter()).getPkId())) : id;
            }
            if (RuleEngingService.checkRuleEngingAssociation((long)id)) {
                this.fillPagePolicyData(id);
            } else {
                this.getModel().setValue("setruleway", (Object)"1");
                this.getView().setVisible(Boolean.TRUE, new String[]{"advconap"});
            }
        } else {
            this.getModel().setValue("setruleway", (Object)"1");
            this.getView().setVisible(Boolean.TRUE, new String[]{"advconap"});
        }
        RuleEngingService.genShowRuleEngingPage((IFormView)this.getView());
    }

    private void fillPagePolicyData(long id) {
        DynamicObject ruleDy = RuleEngingHelper.queryPolicyDataByPlanId((long)id);
        this.getModel().setValue("policyid", (Object)ruleDy.getLong("policyid"));
        String ruleSet = ruleDy.getString("ruleset");
        if (ruleSet == null) {
            ruleSet = "1";
        }
        this.getModel().setValue("setruleway", (Object)ruleSet);
        String number = String.valueOf(this.getModel().getValue("number"));
        number = number.length() > 30 ? number.substring(0, 30) : number;
        String policyNumber = number + RuleEngingService.getCodeRuleNumber();
        this.getModel().setValue("policynumber", (Object)policyNumber);
        this.getView().getPageCache().put("number", policyNumber);
        if ("2".equals(ruleSet)) {
            this.getView().setVisible(Boolean.FALSE, new String[]{"advconap"});
        }
    }

    private long getCurrentDataId(Map<String, Object> customParams) {
        long id = this.getModel().getDataEntity().getLong("id");
        Object currentDataId = customParams.get("currentDataId");
        if (id == 0L && currentDataId != null) {
            id = (Long)currentDataId;
        }
        return id;
    }
}

