/*
 * Decompiled with CFR 0.152.
 */
package kd.wtc.wtp.formplugin.web.ruleenging;

import java.util.Date;
import java.util.EventObject;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.datamodel.events.ChangeData;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.ext.hr.ruleengine.controls.RuleCondition;
import kd.bos.ext.hr.ruleengine.controls.RuleResult;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.operate.AbstractOperate;
import kd.hr.hbp.common.util.HRDateTimeUtils;
import kd.hr.hbp.common.util.HRStringUtils;
import kd.hr.hbp.formplugin.web.HRBaseDataCommonEdit;
import kd.wtc.wtbs.common.util.WTCCollectionIndexUtil;
import kd.wtc.wtbs.common.util.WTCSerializationUtils;
import kd.wtc.wtbs.common.util.third.collect.Maps;
import kd.wtc.wtp.business.ruleenging.RuleEngingService;
import kd.wtc.wtp.common.constants.RuleEngingConstants;

public class RuleEngingSetPlugin
extends HRBaseDataCommonEdit {
    private RuleCondition getRuleCondition() {
        return (RuleCondition)this.getControl("ruleconditionap");
    }

    private RuleResult getRuleResult() {
        return (RuleResult)this.getControl("ruleresultap");
    }

    public void beforeBindData(EventObject evt) {
        FormShowParameter parameter = this.getView().getFormShowParameter();
        String sceneid = parameter.getCustomParam("sceneid").toString();
        this.getRuleCondition().setScene(sceneid);
        String policyId = parameter.getCustomParam("policyid").toString();
        this.getRuleCondition().setPolicy(policyId);
        String ruleName = RuleEngingService.getRuleName();
        ruleName = this.fillDataByViewAndEdit(parameter, ruleName);
        this.getModel().setValue("number", (Object)ruleName);
        this.getRuleResult().setScene(sceneid);
        this.setTips();
        this.getModel().setDataChanged(false);
    }

    private void setTips() {
        String tips = this.getView().getParentView().getParentView().getPageCache().get("tips");
        if (HRStringUtils.isEmpty((String)tips)) {
            this.getView().setVisible(Boolean.FALSE, new String[]{"tipsflex"});
        } else {
            this.getModel().setValue("tips", (Object)tips);
        }
    }

    private String fillDataByViewAndEdit(FormShowParameter parameter, String ruleName) {
        Object customParam = parameter.getCustomParam("entryrulelist");
        if (customParam != null) {
            Map ruleMap = (Map)customParam;
            ruleName = String.valueOf(ruleMap.get("rulenumber"));
            this.getModel().setValue("name", ruleMap.get("rulename"));
            String filterCondition = String.valueOf(ruleMap.get("filtercondition"));
            this.getRuleCondition().setValue(filterCondition);
            String filterResult = String.valueOf(ruleMap.get("filterresult"));
            this.getRuleResult().setValue(filterResult);
            this.getModel().setValue("description", ruleMap.get("ruledescript"));
        }
        return ruleName;
    }

    public void afterBindData(EventObject event) {
        super.afterBindData(event);
        FormShowParameter parameter = this.getView().getFormShowParameter();
        Boolean isLock = (Boolean)parameter.getCustomParam("isLock");
        if (Boolean.TRUE.equals(isLock)) {
            this.getView().setEnable(Boolean.FALSE, new String[]{"name", "description"});
            this.getRuleResult().setPageState("VIEW");
            this.getRuleCondition().setPageState("VIEW");
            this.getView().setVisible(Boolean.FALSE, new String[]{"closepage", "save"});
            this.getView().setVisible(Boolean.TRUE, new String[]{"close"});
        }
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        AbstractOperate op;
        String operateKey;
        super.beforeDoOperation(args);
        if (args.getSource() instanceof AbstractOperate && "save".equals(operateKey = (op = (AbstractOperate)args.getSource()).getOperateKey())) {
            this.validSave(args);
            this.checkNameRepeat(args);
            this.getModel().setDataChanged(false);
        }
    }

    private void checkNameRepeat(BeforeDoOperationEventArgs args) {
        String name = String.valueOf(this.getModel().getValue("name"));
        String number = String.valueOf(this.getModel().getValue("number"));
        if (HRStringUtils.isEmpty((String)name) || HRStringUtils.isEmpty((String)number)) {
            return;
        }
        DynamicObjectCollection entryDys = this.getView().getParentView().getModel().getEntryEntity("entryrulelist");
        for (int i = 0; i < entryDys.size(); ++i) {
            DynamicObject entryDy = (DynamicObject)entryDys.get(i);
            if (number.equals(entryDy.getString("rulenumber")) || !name.equals(entryDy.getString("rulename"))) continue;
            this.getView().showErrorNotification(ResManager.loadResFormat((String)ResManager.loadKDString((String)"\u201c\u89c4\u5219\u540d\u79f0\u201d\u4e0e\u7b2c%s\u884c\u540d\u79f0\u91cd\u590d\u3002", (String)"RuleEngingSetPlugin_0", (String)"wtc-wtp-formplugin", (Object[])new Object[0]), (String)"RuleEngingSetPlugin_0", (String)"wtc_wtp_formplugin", (Object[])new Object[]{i + 1}));
            args.setCancel(true);
        }
    }

    public void afterDoOperation(AfterDoOperationEventArgs args) {
        super.afterDoOperation(args);
        String operateKey = args.getOperateKey();
        if ("save".equals(operateKey) && args.getOperationResult().isSuccess()) {
            DynamicObject pageDy = this.getModel().getDataEntity();
            String conditions = pageDy.getString("conditions");
            String results = pageDy.getString("results");
            HashMap map = Maps.newHashMapWithExpectedSize((int)4);
            map.put("conditions", conditions);
            map.put("results", results);
            map.put("ruleDesign", RuleEngingService.convertDynamicObjectToJson((DynamicObject)this.getModel().getDataEntity()));
            map.put("description", WTCSerializationUtils.serializeToBase64((Object)pageDy.getLocaleString("description")));
            this.getView().returnDataToParent((Object)map);
        }
    }

    private void validSave(BeforeDoOperationEventArgs args) {
        String conditionJson = this.getRuleCondition().getValue();
        this.getModel().setValue("conditions", (Object)conditionJson);
        if (!RuleEngingService.validCondition((IFormView)this.getView(), (BeforeDoOperationEventArgs)args, (String)conditionJson)) {
            args.setCancel(true);
            return;
        }
        String resultJson = this.getRuleResult().getValue();
        this.getModel().setValue("results", (Object)resultJson);
        if (!RuleEngingService.validRuleResult((IFormView)this.getView(), (BeforeDoOperationEventArgs)args, (String)resultJson)) {
            args.setCancel(true);
            return;
        }
        String planFlag = (String)this.getView().getFormShowParameter().getCustomParam("planFlag");
        Date startDate = this.getView().getParentView().getParentView().getModel().getDataEntity().getDate("bsed");
        String planName = Objects.requireNonNull(RuleEngingConstants.Plan.getPlanEnum((String)planFlag)).getPlanName().loadKDString();
        String ruleFormId = RuleEngingConstants.Plan.getRuleFormIdByPlanFlag((String)planFlag);
        String tips = RuleEngingService.compareBsedWithPlanFirstBsed((String)resultJson, (Date)startDate, (String)ruleFormId, (String)planName, (String)ResManager.loadKDString((String)"\u8fd4\u56de\u7ed3\u679c", (String)"RuleEngingSetPlugin_1", (String)"wtc-wtp-formplugin", (Object[])new Object[0]));
        if (HRStringUtils.isNotEmpty((String)tips)) {
            this.getView().showTipNotification(tips);
            args.setCancel(true);
            return;
        }
        tips = RuleEngingService.getInstance().customValidator(resultJson, planFlag, startDate);
        if (HRStringUtils.isNotEmpty((String)tips)) {
            this.getView().showTipNotification(tips);
            args.setCancel(true);
        }
    }

    public void propertyChanged(PropertyChangedArgs e) {
        String key = e.getProperty().getName();
        if (HRStringUtils.equals((String)"ruledate", (String)key)) {
            Date newData = WTCCollectionIndexUtil.getEleFromArr((Object[])e.getChangeSet(), (int)0).map(ChangeData::getNewValue).orElse(null);
            if (null == newData) {
                return;
            }
            String dateFormat = this.getView().getPageCache().get("ruleDateFormat");
            if (dateFormat == null) {
                dateFormat = "yyyy-MM-dd";
            }
            String data = HRDateTimeUtils.format((Date)newData, (String)dateFormat);
            this.getRuleCondition().setDate(data);
            this.getRuleResult().setDate(data);
            this.getModel().setValue("ruledate", null);
        }
    }
}

