/*
 * Decompiled with CFR 0.152.
 */
package kd.wtc.wtp.formplugin.web.supple;

import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.EventObject;
import java.util.List;
import java.util.stream.Collectors;
import kd.bos.bill.OperationStatus;
import kd.bos.dataentity.entity.DataEntityState;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.metadata.IDataEntityType;
import kd.bos.dataentity.metadata.clr.DataEntityPropertyCollection;
import kd.bos.dataentity.metadata.dynamicobject.DynamicComplexProperty;
import kd.bos.entity.ValueMapItem;
import kd.bos.entity.datamodel.AbstractFormDataModel;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.datamodel.TableValueSetter;
import kd.bos.entity.datamodel.events.ChangeData;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.entity.property.ComboProp;
import kd.bos.form.CloseCallBack;
import kd.bos.form.FormShowParameter;
import kd.bos.form.ShowType;
import kd.bos.form.control.EntryData;
import kd.bos.form.control.EntryGrid;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.BeforeClosedEvent;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.field.BasedataEdit;
import kd.bos.form.field.ComboEdit;
import kd.bos.form.field.events.BeforeF7SelectEvent;
import kd.bos.form.field.events.BeforeF7SelectListener;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.hr.hbp.common.util.HRStringUtils;
import kd.hr.hbp.formplugin.web.HRDataBaseEdit;
import kd.wtc.wtbs.common.util.third.collect.Lists;
import kd.wtc.wtbs.wtp.enums.supple.CountLimitAttItemEnum;
import kd.wtc.wtp.constants.supple.SuppleConstants;
import kd.wtc.wtp.constants.supple.SuppleKDString;

public class SuppleCountLimitEdit
extends HRDataBaseEdit
implements SuppleConstants,
BeforeF7SelectListener {
    public void registerListener(EventObject evt) {
        BasedataEdit aboveAttItem;
        super.registerListener(evt);
        BasedataEdit attItem = (BasedataEdit)this.getControl("attitem");
        if (attItem != null) {
            attItem.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        }
        if ((aboveAttItem = (BasedataEdit)this.getControl("aboveattitem")) != null) {
            aboveAttItem.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        }
    }

    public void beforeBindData(EventObject args) {
        super.beforeBindData(args);
        IDataModel model = this.getModel();
        DynamicObject dataEntity = model.getDataEntity();
        String limitType = dataEntity.getString("limittype");
        if ("B".equals(limitType)) {
            DynamicObjectCollection dynamicObjectCollection = dataEntity.getDynamicObjectCollection("entryentity");
            TableValueSetter tableValueSetter = this.getTableValueSetter((List<DynamicObject>)dynamicObjectCollection);
            for (int index = 0; index < dynamicObjectCollection.size(); ++index) {
                DynamicObject dynamicObject = (DynamicObject)dynamicObjectCollection.get(index);
                dynamicObject.set("condition", tableValueSetter.get("condition", index));
                dynamicObject.set("result", tableValueSetter.get("result", index));
            }
        } else {
            FormShowParameter formShowParameter = this.getView().getFormShowParameter();
            OperationStatus status = formShowParameter.getStatus();
            if (OperationStatus.ADDNEW.equals((Object)status)) {
                model.setValue("attitem", (Object)CountLimitAttItemEnum.RC_1010_S.getId());
            }
        }
    }

    public void afterBindData(EventObject evt) {
        super.afterBindData(evt);
        IDataModel model = this.getModel();
        DynamicObject dataEntity = model.getDataEntity();
        String allowAbove = dataEntity.getString("allowabove");
        this.getView().setEnable(Boolean.valueOf("1".equals(allowAbove)), new String[]{"abovepanel"});
        String limitType = dataEntity.getString("limittype");
        this.getView().setVisible(Boolean.valueOf("A".equals(limitType)), new String[]{"bycardpanel"});
        this.getView().setVisible(Boolean.valueOf("B".equals(limitType)), new String[]{"byreasonpanel"});
        this.setAllowNullDefaultIntValue("count", "countbak");
        this.setAllowNullDefaultIntValue("abovecount", "abovecountbak");
        this.getModel().setDataChanged(false);
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        super.beforeDoOperation(args);
        DynamicObject dataEntity = this.getModel().getDataEntity();
        String limitType = dataEntity.getString("limittype");
        if (!"A".equals(limitType)) {
            dataEntity.set("count", (Object)0);
            dataEntity.set("abovecount", (Object)0);
        } else {
            dataEntity.set("count", this.getModel().getValue("countbak"));
            String allowAbove = dataEntity.getString("allowabove");
            if ("0".equals(allowAbove)) {
                dataEntity.set("abovecount", (Object)0);
            } else {
                dataEntity.set("abovecount", this.getModel().getValue("abovecountbak"));
            }
        }
    }

    public void afterDoOperation(AfterDoOperationEventArgs afterDoOperationEventArgs) {
        super.afterDoOperation(afterDoOperationEventArgs);
        String operateKey = afterDoOperationEventArgs.getOperateKey();
        if ("addentry".equals(operateKey)) {
            FormShowParameter showParameter = this.getCountSetByReasonForm(0L);
            this.getView().showForm(showParameter);
        } else if ("editentry".equals(operateKey)) {
            EntryGrid entryGrid = (EntryGrid)this.getView().getControl("entryentity");
            int[] selectRows = entryGrid.getSelectRows();
            int selectRowIndex = selectRows[0];
            EntryData entryData = entryGrid.getEntryData();
            DynamicObject[] dataEntitys = entryData.getDataEntitys();
            DynamicObject dataEntity = dataEntitys[selectRowIndex];
            DynamicObject reasonDy = dataEntity.getDynamicObject("reason");
            Long reasonId = 0L;
            if (reasonDy != null) {
                reasonId = reasonDy.getLong("id");
            }
            FormShowParameter showParameter = this.getCountSetByReasonForm(reasonId);
            this.setEntryDataParam(dataEntity, showParameter);
            showParameter.setCustomParam("selectRowIndex", (Object)selectRowIndex);
            showParameter.setCustomParam("reasonDy", (Object)dataEntity);
            this.getPageCache().put("selectRowIndex", String.valueOf(selectRowIndex));
            this.getView().showForm(showParameter);
        }
        this.getView().updateView("flexpanelap");
    }

    private void setEntryDataParam(DynamicObject dataEntity, FormShowParameter showParameter) {
        showParameter.setCustomParam("reason", (Object)this.getDynamicObjectId(dataEntity.get("reason")));
        showParameter.setCustomParam("enticountsco", dataEntity.get("enticountsco"));
        showParameter.setCustomParam("enticount", dataEntity.get("enticount"));
        showParameter.setCustomParam("entiattitem", (Object)this.getDynamicObjectId(dataEntity.get("entiattitem")));
        showParameter.setCustomParam("entiallowabove", dataEntity.get("entiallowabove"));
        showParameter.setCustomParam("entiabovecount", dataEntity.get("entiabovecount"));
        showParameter.setCustomParam("entiaboveattitem", (Object)this.getDynamicObjectId(dataEntity.get("entiaboveattitem")));
    }

    private Long getDynamicObjectId(Object dy) {
        if (dy == null) {
            return 0L;
        }
        if (dy instanceof DynamicObject) {
            return ((DynamicObject)dy).getLong("id");
        }
        return (Long)dy;
    }

    private FormShowParameter getCountSetByReasonForm(Long reasonId) {
        FormShowParameter showParameter = new FormShowParameter();
        showParameter.setFormId("wtp_countsetbyreason");
        showParameter.setCaption(SuppleKDString.byReasonLimit());
        showParameter.getOpenStyle().setShowType(ShowType.Modal);
        List<Long> reasonIds = this.getSelectedReasonIds();
        if (!CollectionUtils.isEmpty(reasonIds)) {
            reasonIds.remove(reasonId);
            showParameter.setCustomParam("selectReasonId", reasonIds);
        }
        showParameter.setCloseCallBack(new CloseCallBack((IFormPlugin)this, "wtp_countsetbyreason"));
        return showParameter;
    }

    public void propertyChanged(PropertyChangedArgs args) {
        String name = args.getProperty().getName();
        ChangeData changeData = args.getChangeSet()[0];
        Object newValue = changeData.getNewValue();
        if ("limittype".equals(name)) {
            boolean isLimitByCard = "A".equals(newValue);
            this.getView().setVisible(Boolean.valueOf(isLimitByCard), new String[]{"bycardpanel"});
            this.getView().setVisible(Boolean.valueOf(!isLimitByCard), new String[]{"byreasonpanel"});
            Object attItem = this.getModel().getValue("attitem");
            if (isLimitByCard && attItem == null) {
                this.getModel().setValue("attitem", (Object)CountLimitAttItemEnum.RC_1010_S.getId());
            }
            boolean isAllowAbove = "1".equals(this.getModel().getDataEntity().getString("allowabove"));
            this.allowAboveChanged(isAllowAbove);
            if (!isLimitByCard) {
                this.getModel().setValue("countbak", null);
                this.getModel().setValue("abovecountbak", null);
            }
        } else if ("allowabove".equals(name)) {
            boolean isAllowAbove = "1".equals(newValue);
            this.allowAboveChanged(isAllowAbove);
        }
    }

    public void closedCallBack(ClosedCallBackEvent closedCallBackEvent) {
        super.closedCallBack(closedCallBackEvent);
        String actionId = closedCallBackEvent.getActionId();
        if ("wtp_countsetbyreason".equals(actionId)) {
            String selectRowIndex = this.getPageCache().get("selectRowIndex");
            this.getPageCache().remove("selectRowIndex");
            DynamicObject returnData = (DynamicObject)closedCallBackEvent.getReturnData();
            if (returnData == null) {
                return;
            }
            if (HRStringUtils.isNotEmpty((String)selectRowIndex)) {
                TableValueSetter tableValueSetter = this.getTableValueSetter(Lists.newArrayList((Object[])new DynamicObject[]{returnData}));
                this.copyTableValueSetter2DynamicObject(tableValueSetter, Integer.parseInt(selectRowIndex));
            } else {
                AbstractFormDataModel dataModel = (AbstractFormDataModel)this.getModel();
                TableValueSetter tableValueSetter = this.getTableValueSetter(Lists.newArrayList((Object[])new DynamicObject[]{returnData}));
                dataModel.beginInit();
                dataModel.batchCreateNewEntryRow("entryentity", tableValueSetter);
                dataModel.endInit();
            }
            this.getView().updateView("entryentity");
        }
    }

    public void beforeF7Select(BeforeF7SelectEvent beforeF7SelectEvent) {
        String propKey = beforeF7SelectEvent.getProperty().getName();
        if ("attitem".equals(propKey) || "aboveattitem".equals(propKey)) {
            beforeF7SelectEvent.addCustomQFilter(new QFilter("datatype", "=", (Object)"0"));
        }
    }

    private void copyTableValueSetter2DynamicObject(TableValueSetter tableValueSetter, int selectRowIndex) {
        List fields = tableValueSetter.getFields();
        int rowIndex = 0;
        IDataModel model = this.getModel();
        for (String field : fields) {
            Object obj = tableValueSetter.get(field, rowIndex);
            if (obj instanceof Long && (Long)obj == 0L) {
                model.setValue(field, null, selectRowIndex);
                continue;
            }
            model.setValue(field, tableValueSetter.get(field, rowIndex), selectRowIndex);
        }
    }

    private TableValueSetter getTableValueSetter(List<DynamicObject> dynamicObjects) {
        TableValueSetter tableValueSetter = new TableValueSetter(new String[]{"condition", "result", "reason", "enticountsco", "enticount", "entiattitem", "entiallowabove", "entiabovecount", "entiaboveattitem"});
        for (DynamicObject dynamicObject : dynamicObjects) {
            Object entiAboveCountObj;
            DynamicObject reason = dynamicObject.getDynamicObject("reason");
            String entiCountSco = dynamicObject.getString("enticountsco");
            Object entiCountObj = dynamicObject.get("enticount");
            int entiCount = entiCountObj == null ? 0 : (Integer)entiCountObj;
            DynamicObject entiAttItem = dynamicObject.getDynamicObject("entiattitem");
            String entiAllowAbove = dynamicObject.getString("entiallowabove");
            if (HRStringUtils.isEmpty((String)entiAllowAbove)) {
                entiAllowAbove = "0";
            }
            int entiAboveCount = (entiAboveCountObj = dynamicObject.get("entiabovecount")) == null ? 0 : (Integer)entiAboveCountObj;
            DynamicObject entiAboveAttItem = dynamicObject.getDynamicObject("entiaboveattitem");
            String reasonName = reason.getString("name");
            String condition = MessageFormat.format(SuppleKDString.suppleReason(), reasonName);
            String entiCountScoName = this.getComboItemNameByValue(entiCountSco, "enticountsco");
            String result = "";
            result = !"1".equals(entiAllowAbove) ? this.getNotAllowDesc(entiAttItem, entiCountScoName, entiCount) : (entiAttItem == null ? this.getAllowItemNullDesc(entiAboveAttItem, entiAboveCount, entiCountScoName, entiCount) : this.getAllowItemNotNullDesc(entiAttItem, entiAboveAttItem, entiAboveCount, entiCount, entiCountScoName));
            tableValueSetter.addRow(new Object[]{condition, result, this.getPkValue(reason), entiCountSco, entiCount, this.getPkValue(entiAttItem), entiAllowAbove, entiAboveCount, this.getPkValue(entiAboveAttItem)});
        }
        return tableValueSetter;
    }

    private String getNotAllowDesc(DynamicObject entiAttItem, String entiCountScoName, int entiCount) {
        String result;
        if (entiAttItem == null) {
            result = MessageFormat.format(SuppleKDString.noAttItemNotAbove(), entiCountScoName, entiCount);
        } else {
            String entiAttItemName = entiAttItem.getString("name");
            result = MessageFormat.format(SuppleKDString.haveAttItemNotAbove(), entiCountScoName, entiCount, entiAttItemName);
        }
        return result;
    }

    private String getAllowItemNullDesc(DynamicObject entiAboveAttItem, int entiAboveCount, String entiCountScoName, int entiCount) {
        String result;
        if (entiAboveAttItem == null) {
            result = entiAboveCount <= 0 ? MessageFormat.format(SuppleKDString.notAttItemAbove0(), entiCountScoName, entiCount, entiCountScoName) : MessageFormat.format(SuppleKDString.notAttItemAbove(), entiCountScoName, entiCount, entiCountScoName, entiAboveCount);
        } else {
            String entiAboveAttItemName = entiAboveAttItem.getString("name");
            result = entiAboveCount <= 0 ? MessageFormat.format(SuppleKDString.noAttItemAboveHavaAboveItem0(), entiCountScoName, entiCount, entiCountScoName, entiAboveAttItemName) : MessageFormat.format(SuppleKDString.noAttItemAboveHavaAboveItem(), entiCountScoName, entiCount, entiCountScoName, entiAboveCount, entiAboveAttItemName);
        }
        return result;
    }

    private String getAllowItemNotNullDesc(DynamicObject entiAttItem, DynamicObject entiAboveAttItem, int entiAboveCount, int entiCount, String entiCountScoName) {
        String result;
        String entiAttItemName = entiAttItem.getString("name");
        if (entiAboveAttItem == null) {
            result = entiAboveCount <= 0 ? MessageFormat.format(SuppleKDString.haveAttItemAbove0(), entiCountScoName, entiCount, entiAttItemName, entiCountScoName) : MessageFormat.format(SuppleKDString.haveAttItemAbove(), entiCountScoName, entiCount, entiAttItemName, entiCountScoName, entiAboveCount);
        } else {
            String entiAboveAttItemName = entiAboveAttItem.getString("name");
            result = entiAboveCount <= 0 ? MessageFormat.format(SuppleKDString.allAttItemAbove0(), entiCountScoName, entiCount, entiAttItemName, entiCountScoName, entiAboveAttItemName) : MessageFormat.format(SuppleKDString.allAttItemAbove(), entiCountScoName, entiCount, entiAttItemName, entiCountScoName, entiAboveCount, entiAboveAttItemName);
        }
        return result;
    }

    private Long getPkValue(DynamicObject dy) {
        if (dy == null) {
            return 0L;
        }
        return (Long)dy.getPkValue();
    }

    private String getComboItemNameByValue(String value, String fieldKey) {
        ComboEdit comboEdit = (ComboEdit)this.getControl(fieldKey);
        ComboProp comboProp = (ComboProp)comboEdit.getProperty();
        List comboItems = comboProp.getComboItems();
        String name = null;
        for (ValueMapItem valueMapItem : comboItems) {
            if (!valueMapItem.getValue().equals(value)) continue;
            name = valueMapItem.getName().getLocaleValue();
            break;
        }
        return name;
    }

    private List<Long> getSelectedReasonIds() {
        DynamicObjectCollection reasonCountColl = this.getModel().getEntryEntity("entryentity");
        List<Long> reasonIds = new ArrayList<Long>(0);
        if (reasonCountColl != null) {
            reasonIds = reasonCountColl.stream().mapToLong(reasonCountDy -> {
                DynamicObject reasonDy = reasonCountDy.getDynamicObject("reason");
                if (reasonDy != null) {
                    return (Long)reasonDy.getPkValue();
                }
                return 0L;
            }).filter(reasonId -> reasonId > 0L).boxed().collect(Collectors.toList());
        }
        return reasonIds;
    }

    private void allowAboveChanged(boolean isAllowAbove) {
        this.getView().setEnable(Boolean.valueOf(isAllowAbove), new String[]{"abovepanel"});
        if (isAllowAbove) {
            Object aboveAttItem = this.getModel().getValue("aboveattitem");
            if (aboveAttItem == null) {
                this.getModel().setValue("aboveattitem", (Object)CountLimitAttItemEnum.RC_1020_S.getId());
            }
        } else {
            this.getModel().setValue("aboveattitem", null);
            this.getModel().setValue("abovecountbak", null);
        }
    }

    public void beforeClosed(BeforeClosedEvent args) {
        super.beforeClosed(args);
        DynamicObjectCollection dynamicObjectCollection = this.getModel().getDataEntity(true).getDynamicObjectCollection("entryentity");
        if (this.getModel().getDataChanged() && !CollectionUtils.isEmpty((Collection)dynamicObjectCollection)) {
            ArrayList prop = Lists.newArrayList((Object[])new String[]{"reason", "enticountsco", "enticount", "entiattitem", "entiallowabove", "entiabovecount", "entiaboveattitem"});
            for (DynamicObject dynamicObject : dynamicObjectCollection) {
                this.setDataChangedFalse(dynamicObject, prop);
            }
        }
    }

    private void setDataChangedFalse(DynamicObject dataEntity, List<String> propList) {
        IDataEntityType dataEntityType = dataEntity.getDataEntityType();
        DataEntityPropertyCollection properties = dataEntityType.getProperties();
        DataEntityState dataEntityState = dataEntity.getDataEntityState();
        String id = "_id";
        for (String prop : propList) {
            IDataEntityProperty iDataEntityPropertyId;
            IDataEntityProperty iDataEntityProperty = (IDataEntityProperty)properties.get((Object)prop);
            if (iDataEntityProperty == null) continue;
            if (iDataEntityProperty instanceof DynamicComplexProperty && (iDataEntityPropertyId = (IDataEntityProperty)properties.get((Object)(prop + id))) != null) {
                dataEntityState.setBizChanged(iDataEntityPropertyId.getOrdinal(), false);
            }
            dataEntityState.setBizChanged(iDataEntityProperty.getOrdinal(), false);
        }
    }

    private void setAllowNullDefaultIntValue(String fromProp, String toProp) {
        int value = this.getModel().getDataEntity().getInt(fromProp);
        if (0 == value) {
            this.getModel().setValue(toProp, null);
        } else {
            this.getModel().setValue(toProp, (Object)value);
        }
    }
}

