/*
 * Decompiled with CFR 0.152.
 */
package kd.wtc.wtp.formplugin.web.supple;

import java.util.Date;
import java.util.EventObject;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.field.BasedataEdit;
import kd.bos.form.field.events.BeforeF7SelectEvent;
import kd.bos.form.field.events.BeforeF7SelectListener;
import kd.bos.orm.query.QFilter;
import kd.hr.hbp.business.servicehelper.HRBaseServiceHelper;
import kd.hr.hbp.formplugin.web.HRDataBaseEdit;
import kd.wtc.wtbs.common.util.WTCStringUtils;
import kd.wtc.wtbs.common.util.third.collect.Lists;
import kd.wtc.wtp.constants.supple.SuppleKDString;

public class SupplePlanEdit
extends HRDataBaseEdit
implements BeforeF7SelectListener {
    private static final HRBaseServiceHelper RULEHELPER = new HRBaseServiceHelper("wtp_supplerule");

    public void registerListener(EventObject e) {
        super.registerListener(e);
        BasedataEdit ruleEdit = (BasedataEdit)this.getControl("rule");
        ruleEdit.addBeforeF7SelectListener((BeforeF7SelectListener)this);
    }

    public void beforeBindData(EventObject evt) {
        super.beforeBindData(evt);
        String ruleType = this.getModel().getDataEntity().getString("ruletype");
        this.getModel().setValue("setruleway", (Object)ruleType);
    }

    public void afterBindData(EventObject e) {
        super.afterBindData(e);
        DynamicObject dataEntity = this.getModel().getDataEntity();
        String ruleType = dataEntity.getString("ruletype");
        this.setMustInput(ruleType);
        String setRuleWay = dataEntity.getString("setruleway");
        if ("2".equals(setRuleWay)) {
            dataEntity.set("rule", null);
        }
    }

    public void afterDoOperation(AfterDoOperationEventArgs afterDoOperationEventArgs) {
        super.afterDoOperation(afterDoOperationEventArgs);
        if (afterDoOperationEventArgs.getOperationResult() != null && afterDoOperationEventArgs.getOperationResult().isSuccess()) {
            this.getView().updateView("flexpanelap");
        }
    }

    public void propertyChanged(PropertyChangedArgs args) {
        String propName = args.getProperty().getName();
        if (args.getChangeSet() == null || args.getChangeSet().length <= 0) {
            return;
        }
        if ("setruleway".equals(propName)) {
            String newValue = (String)args.getChangeSet()[0].getNewValue();
            this.setMustInput(newValue);
            this.getModel().setValue("ruletype", (Object)newValue);
        } else if ("bsed".equals(propName)) {
            DynamicObject dataEntity = this.getModel().getDataEntity();
            String ruleType = dataEntity.getString("ruletype");
            if ("2".equals(ruleType)) {
                return;
            }
            DynamicObject ruleDy = dataEntity.getDynamicObject("rule");
            if (ruleDy == null) {
                return;
            }
            Date bsed = dataEntity.getDate("bsed");
            QFilter qFilter = new QFilter("datastatus", "in", (Object)Lists.newArrayList((Object[])new String[]{"0", "1"}));
            qFilter.and(new QFilter("boid", "=", (Object)ruleDy.getLong("id")));
            qFilter.and(new QFilter("bsed", "<=", (Object)bsed));
            DynamicObject[] query = RULEHELPER.query(WTCStringUtils.joinOnComma((String[])new String[]{"bsed", "datastatus"}), qFilter.toArray());
            if (query == null || query.length == 0) {
                this.getModel().setValue("rule", null);
            }
        }
    }

    private void setMustInput(String ruleType) {
        BasedataEdit ruleEdit = (BasedataEdit)this.getControl("rule");
        ruleEdit.setMustInput(!"2".equals(ruleType));
    }

    public void beforeF7Select(BeforeF7SelectEvent beforeF7SelectEvent) {
        String propName = beforeF7SelectEvent.getProperty().getName();
        if ("rule".equals(propName)) {
            Date bsed = this.getModel().getDataEntity().getDate("bsed");
            if (bsed == null) {
                this.getView().showTipNotification(SuppleKDString.pleaseInputBsed());
                beforeF7SelectEvent.setCancel(true);
            } else {
                QFilter qFilter = new QFilter("firstbsed", "<=", (Object)bsed);
                beforeF7SelectEvent.addCustomQFilter(qFilter);
            }
        }
    }
}

