/*
 * Decompiled with CFR 0.152.
 */
package kd.wtc.wtp.formplugin.web.swshift.baseset;

import java.util.EventObject;
import java.util.HashSet;
import kd.bos.dataentity.entity.DataEntityState;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.metadata.clr.DataEntityPropertyCollection;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.form.events.BeforeClosedEvent;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.field.FieldEdit;
import kd.bos.form.operate.FormOperate;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.hr.hbp.common.util.HRStringUtils;
import kd.hr.hbp.formplugin.web.HRDataBaseEdit;
import kd.wtc.wtbs.common.util.third.collect.Sets;
import kd.wtc.wtbs.common.util.third.util.StringUtils;
import kd.wtc.wtp.constants.swshift.SwShiftKDString;

public class SwShiftBaseSetEdit
extends HRDataBaseEdit {
    private static final Log LOG = LogFactory.getLog(SwShiftBaseSetEdit.class);

    public void beforeBindData(EventObject evt) {
        super.beforeBindData(evt);
        this.setDataBaseFieldToShow();
    }

    public void afterBindData(EventObject evt) {
        super.afterBindData(evt);
        this.handleFlexVisible();
    }

    public void propertyChanged(PropertyChangedArgs args) {
        super.propertyChanged(args);
        switch (args.getProperty().getName()) {
            case "isrepair": 
            case "isaheadmax": 
            case "isahead": {
                this.handleFlexVisible();
                break;
            }
            case "maxaheadtime_s": 
            case "aheadperiod": 
            case "aheadmaxval_s": 
            case "aheadmaxunit": 
            case "maxrepairtime_s": 
            case "repairperiod": {
                this.handleNumberVal(args.getProperty().getName());
                break;
            }
        }
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        super.beforeDoOperation(args);
        FormOperate operate = (FormOperate)args.getSource();
        switch (operate.getOperateKey()) {
            case "save": 
            case "submit": 
            case "audit": 
            case "submitandaudit": 
            case "confirmchange": 
            case "confirmchangenoaudit": {
                this.setNumberToDataBaseField();
                break;
            }
        }
    }

    public void beforeClosed(BeforeClosedEvent evt) {
        super.beforeClosed(evt);
        HashSet propNames = Sets.newHashSet((Object[])new String[]{"maxaheadtime", "aheadmaxval", "maxrepairtime"});
        DataEntityState dataEntityState = this.getModel().getDataEntity().getDataEntityState();
        DataEntityPropertyCollection properties = this.getModel().getDataEntity().getDataEntityType().getProperties();
        for (int i = 0; i < properties.size(); ++i) {
            IDataEntityProperty iDataEntityProperty = (IDataEntityProperty)properties.get(i);
            String name = iDataEntityProperty.getName();
            if (!HRStringUtils.isNotEmpty((String)name) || !propNames.contains(name)) continue;
            dataEntityState.setBizChanged(i, false);
        }
    }

    private void setDataBaseFieldToShow() {
        this.getModel().beginInit();
        DynamicObject dataEntity = this.getModel().getDataEntity();
        dataEntity.beginInit();
        if (dataEntity.getBoolean("isahead")) {
            this.getModel().setValue("maxaheadtime_s", (Object)dataEntity.getInt("maxaheadtime"));
        }
        if (dataEntity.getBoolean("isaheadmax")) {
            this.getModel().setValue("aheadmaxval_s", (Object)dataEntity.getInt("aheadmaxval"));
        }
        if (dataEntity.getBoolean("isrepair")) {
            this.getModel().setValue("maxrepairtime_s", (Object)dataEntity.getInt("maxrepairtime"));
        }
        this.getModel().endInit();
    }

    private void setNumberToDataBaseField() {
        DynamicObject dataEntity = this.getModel().getDataEntity(true);
        this.setNumber(dataEntity, "maxaheadtime");
        this.setNumber(dataEntity, "aheadmaxval");
        this.setNumber(dataEntity, "maxrepairtime");
        if (!dataEntity.getBoolean("isahead")) {
            this.getModel().setValue("maxaheadtime_s", null);
            this.getModel().setValue("maxaheadtime", (Object)0);
            this.getModel().setValue("aheadperiod", (Object)" ");
        }
        if (!dataEntity.getBoolean("isaheadmax")) {
            this.getModel().setValue("aheadmaxval_s", null);
            this.getModel().setValue("aheadmaxval", (Object)0);
            this.getModel().setValue("aheadmaxunit", (Object)" ");
        }
        if (!dataEntity.getBoolean("isrepair")) {
            this.getModel().setValue("maxrepairtime_s", null);
            this.getModel().setValue("maxrepairtime", (Object)0);
            this.getModel().setValue("repairperiod", (Object)" ");
        }
    }

    private void setNumber(DynamicObject dataEntity, String numberKey) {
        Object timeObj = dataEntity.get(numberKey + "_s");
        if (timeObj != null) {
            this.getModel().setValue(numberKey, timeObj);
        } else {
            this.getModel().setValue(numberKey, (Object)0);
        }
    }

    private void handleNumberVal(String name) {
        DynamicObject dataEntity = this.getModel().getDataEntity();
        if (StringUtils.equalsAny((CharSequence)name, (CharSequence[])new CharSequence[]{"maxaheadtime_s", "aheadperiod"}) && this.isAttPeriodZero(dataEntity, "isahead", "maxaheadtime_s", "aheadperiod")) {
            this.getView().showTipNotification(SwShiftKDString.getAttPeriodValZeroTip());
        }
        if (StringUtils.equalsAny((CharSequence)name, (CharSequence[])new CharSequence[]{"aheadmaxval_s", "aheadmaxunit"}) && this.isAttPeriodZero(dataEntity, "isaheadmax", "aheadmaxval_s", "aheadmaxunit")) {
            this.getView().showTipNotification(SwShiftKDString.getAttPeriodValZeroTip());
        }
        if (StringUtils.equalsAny((CharSequence)name, (CharSequence[])new CharSequence[]{"maxrepairtime_s", "repairperiod"}) && this.isAttPeriodZero(dataEntity, "isrepair", "maxrepairtime_s", "repairperiod")) {
            this.getView().showTipNotification(SwShiftKDString.getAttPeriodValZeroTip());
        }
    }

    private boolean isAttPeriodZero(DynamicObject dataEntity, String isMustKey, String numberShowKey, String unitKey) {
        Object numberObj = dataEntity.get(numberShowKey);
        return dataEntity.getBoolean(isMustKey) && numberObj instanceof Integer && (Integer)numberObj == 0 && !"C".equals(dataEntity.getString(unitKey));
    }

    private void handleFlexVisible() {
        DynamicObject dataEntity = this.getModel().getDataEntity();
        this.getView().setVisible(Boolean.valueOf(dataEntity.getBoolean("isrepair")), new String[]{"isrepairchild"});
        this.getView().setVisible(Boolean.valueOf(dataEntity.getBoolean("isaheadmax")), new String[]{"isaheadmaxchild"});
        this.getView().setVisible(Boolean.valueOf(dataEntity.getBoolean("isahead")), new String[]{"isaheadchild"});
        this.setMustInput("maxrepairtime_s", dataEntity.getBoolean("isrepair"));
        this.setMustInput("aheadmaxval_s", dataEntity.getBoolean("isaheadmax"));
        this.setMustInput("maxaheadtime_s", dataEntity.getBoolean("isahead"));
    }

    private void setMustInput(String key, boolean isMust) {
        FieldEdit fieldEdit = (FieldEdit)this.getControl(key);
        fieldEdit.setMustInput(isMust);
    }
}

