/*
 * Decompiled with CFR 0.152.
 */
package kd.wtc.wtp.formplugin.web.swshift.rule;

import java.util.Collection;
import java.util.Date;
import java.util.EventObject;
import java.util.Map;
import kd.bos.bill.BillOperationStatus;
import kd.bos.bill.BillShowParameter;
import kd.bos.bill.OperationStatus;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.form.CloseCallBack;
import kd.bos.form.FormShowParameter;
import kd.bos.form.ShowType;
import kd.bos.form.control.EntryGrid;
import kd.bos.form.control.events.ItemClickEvent;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.hr.hbp.common.util.HRStringUtils;
import kd.hr.hbp.formplugin.web.HRDataBaseEdit;
import kd.wtc.wtbs.business.util.WTCDynamicObjectUtils;
import kd.wtc.wtbs.common.enums.WTCCommonMessages;
import kd.wtc.wtbs.common.util.WTCCollections;
import kd.wtc.wtbs.common.util.third.util.StringUtils;
import kd.wtc.wtp.business.ruleenging.RulePreviewUtil;
import kd.wtc.wtp.constants.swshift.SwShiftKDString;

public class SwShiftRuleEdit
extends HRDataBaseEdit {
    private static final Log LOG = LogFactory.getLog(SwShiftRuleEdit.class);
    private static final String ADDROWENTRY = "addrowentry";
    private static final String COPYENTRY = "copyentry";

    public void registerListener(EventObject evt) {
        super.registerListener(evt);
        this.addItemClickListeners(new String[]{"advcontoolbarap"});
    }

    public void beforeBindData(EventObject evt) {
        super.beforeBindData(evt);
        this.setCalculdes();
    }

    public void afterBindData(EventObject e) {
        super.afterBindData(e);
        Map customParams = this.getView().getFormShowParameter().getCustomParams();
        String hisAction = (String)customParams.get("his_action");
        boolean isNewVersion = HRStringUtils.equals((String)"open_insert_new_data_page", (String)hisAction);
        if (isNewVersion) {
            IDataModel model = this.getModel();
            model.beginInit();
            model.deleteEntryData("entryentity");
            model.endInit();
            this.getView().updateView("entryentity");
        }
    }

    private void setCalculdes() {
        DynamicObjectCollection entryDys = this.getModel().getDataEntity(true).getDynamicObjectCollection("entryentity");
        if (WTCCollections.isNotEmpty((Collection)entryDys)) {
            for (int i = 0; i < entryDys.size(); ++i) {
                DynamicObject entryDy = (DynamicObject)entryDys.get(i);
                String limitScope = entryDy.getString("limitscope");
                if (HRStringUtils.isEmpty((String)limitScope)) continue;
                this.getModel().setValue("calculdes", (Object)RulePreviewUtil.getConditionPreviewStr((String)limitScope), i);
            }
        }
    }

    public void itemClick(ItemClickEvent evt) {
        super.itemClick(evt);
        switch (evt.getItemKey()) {
            case "addrowentry": {
                this.openDialog(null, "newentry");
                break;
            }
            case "copyentry": {
                this.copyEntry();
                break;
            }
        }
    }

    public void afterDoOperation(AfterDoOperationEventArgs afterDoOperationEventArgs) {
        super.afterDoOperation(afterDoOperationEventArgs);
        if (StringUtils.equalsAny((CharSequence)afterDoOperationEventArgs.getOperateKey(), (CharSequence[])new CharSequence[]{"editentry", "viewentry"})) {
            EntryGrid entryGrid = (EntryGrid)this.getControl("entryentity");
            entryGrid.getEntryData().getDataEntitys();
            int focusRow = entryGrid.getEntryState().getFocusRow();
            if (focusRow >= 0 && entryGrid.getEntryData().getDataEntitys().length > focusRow) {
                DynamicObject entryDy = entryGrid.getEntryData().getDataEntitys()[focusRow];
                this.openDialog(entryDy, afterDoOperationEventArgs.getOperateKey());
            }
        }
    }

    public void closedCallBack(ClosedCallBackEvent closedCallBackEvent) {
        super.closedCallBack(closedCallBackEvent);
        if (closedCallBackEvent.getActionId().equals("wtp_swshiftruledialog") && closedCallBackEvent.getReturnData() instanceof Map) {
            int entryRowCount;
            Map returnMap = (Map)closedCallBackEvent.getReturnData();
            String operate = (String)returnMap.get("operate");
            int index = "editentry".equals(operate) ? Integer.parseInt((String)returnMap.get("entryseq")) - 1 : this.getModel().createNewEntryRow("entryentity");
            if (index >= (entryRowCount = this.getModel().getEntryRowCount("entryentity"))) {
                return;
            }
            String limitScope = (String)returnMap.get("limitscope");
            this.getModel().setValue("swshiftbaseset", (Object)Long.parseLong((String)returnMap.get("swshiftbaseset")), index);
            this.getModel().setValue("swshiftpolicy", (Object)Long.parseLong((String)returnMap.get("swshiftpolicy")), index);
            this.getModel().setValue("limitscope", (Object)limitScope, index);
            if (HRStringUtils.isNotEmpty((String)limitScope)) {
                this.getModel().setValue("calculdes", (Object)RulePreviewUtil.getConditionPreviewStr((String)limitScope), index);
            }
        }
    }

    private void copyEntry() {
        EntryGrid entryGrid = (EntryGrid)this.getControl("entryentity");
        int[] selectRows = entryGrid.getSelectRows();
        DynamicObject[] dataEntitys = entryGrid.getEntryData().getDataEntitys();
        if (selectRows != null && selectRows.length == 1 && selectRows[0] < dataEntitys.length) {
            this.openDialog(entryGrid.getEntryData().getDataEntitys()[selectRows[0]], COPYENTRY);
        } else {
            this.getView().showTipNotification(SwShiftKDString.chooseOneRowTip());
        }
    }

    private void openDialog(DynamicObject entryDy, String action) {
        if (this.isHasBsed()) {
            return;
        }
        FormShowParameter formShowParameter = new FormShowParameter();
        formShowParameter.setFormId("wtp_swshiftruledialog");
        formShowParameter.setCloseCallBack(new CloseCallBack((IFormPlugin)this, "wtp_swshiftruledialog"));
        formShowParameter.getOpenStyle().setShowType(ShowType.Modal);
        formShowParameter.setCustomParam("operate", (Object)action);
        if (entryDy != null) {
            formShowParameter.setCustomParam("basedataid", (Object)entryDy.getString("id"));
            formShowParameter.setCustomParam("entryseq", (Object)entryDy.getString("seq"));
            formShowParameter.setCustomParam("swshiftbaseset", (Object)String.valueOf(WTCDynamicObjectUtils.getBaseDataId((DynamicObject)entryDy, (String)"swshiftbaseset")));
            formShowParameter.setCustomParam("swshiftpolicy", (Object)String.valueOf(WTCDynamicObjectUtils.getBaseDataId((DynamicObject)entryDy, (String)"swshiftpolicy")));
            formShowParameter.setCustomParam("limitscope", (Object)entryDy.getString("limitscope"));
        }
        OperationStatus viewStatus = this.getView().getFormShowParameter().getStatus();
        if (this.getView().getFormShowParameter() instanceof BillShowParameter) {
            BillShowParameter showParameter = (BillShowParameter)this.getView().getFormShowParameter();
            viewStatus = BillOperationStatus.ADDNEW == showParameter.getBillStatus() || BillOperationStatus.EDIT == showParameter.getBillStatus() ? OperationStatus.EDIT : OperationStatus.VIEW;
        }
        formShowParameter.setStatus(viewStatus);
        this.getView().showForm(formShowParameter);
    }

    private boolean isHasBsed() {
        DynamicObject dataEntity = this.getModel().getDataEntity();
        Date date = dataEntity.getDate("bsed");
        if (date == null) {
            this.getView().showTipNotification(WTCCommonMessages.BSED_EMPTY.load());
            return true;
        }
        return false;
    }
}

