/*
 * Decompiled with CFR 0.152.
 */
package kd.wtc.wtp.formplugin.web.swshift.rule;

import java.util.Date;
import java.util.EventObject;
import java.util.HashMap;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.field.BasedataEdit;
import kd.bos.form.field.events.BeforeF7SelectEvent;
import kd.bos.form.field.events.BeforeF7SelectListener;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.hr.hbp.common.util.HRStringUtils;
import kd.hr.hbp.formplugin.web.HRDynamicFormBasePlugin;
import kd.wtc.wtbs.business.rulecontrol.RuleConditionService;
import kd.wtc.wtbs.business.util.WTCDynamicObjectUtils;
import kd.wtc.wtbs.common.util.third.collect.Maps;
import kd.wtc.wtp.business.swshift.SwShiftPlanService;

public class SwShiftRulePlugin
extends HRDynamicFormBasePlugin
implements BeforeF7SelectListener {
    private static final Log LOG = LogFactory.getLog(SwShiftRulePlugin.class);

    public void registerListener(EventObject evt) {
        BasedataEdit setEdit;
        super.registerListener(evt);
        BasedataEdit policyEdit = (BasedataEdit)this.getControl("swshiftpolicy");
        if (policyEdit != null) {
            policyEdit.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        }
        if ((setEdit = (BasedataEdit)this.getControl("swshiftbaseset")) != null) {
            setEdit.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        }
    }

    public void afterCreateNewData(EventObject evt) {
        super.afterCreateNewData(evt);
        IFormView parentView = this.getView().getViewNoPlugin(this.getView().getFormShowParameter().getParentPageId());
        if (parentView != null) {
            this.getModel().setValue("createorg", parentView.getModel().getValue("createorg"));
        }
        this.initValue();
    }

    private void initValue() {
        String limitScope;
        String swPolicyIdStr;
        String swShiftBaseSetIdStr;
        FormShowParameter formShowParameter = this.getView().getFormShowParameter();
        String operate = (String)formShowParameter.getCustomParam("operate");
        if ("editentry".equals(operate)) {
            String basedataId;
            String entrySeq = (String)formShowParameter.getCustomParam("entryseq");
            if (HRStringUtils.isNotEmpty((String)entrySeq)) {
                this.getModel().setValue("entryseq", (Object)Integer.parseInt(entrySeq));
            }
            if (HRStringUtils.isNotEmpty((String)(basedataId = (String)formShowParameter.getCustomParam("basedataid")))) {
                this.getModel().setValue("basedataid", (Object)Long.parseLong(basedataId));
            }
        }
        if (HRStringUtils.isNotEmpty((String)(swShiftBaseSetIdStr = (String)formShowParameter.getCustomParam("swshiftbaseset")))) {
            this.getModel().setValue("swshiftbaseset", (Object)Long.parseLong(swShiftBaseSetIdStr));
        }
        if (HRStringUtils.isNotEmpty((String)(swPolicyIdStr = (String)formShowParameter.getCustomParam("swshiftpolicy")))) {
            this.getModel().setValue("swshiftpolicy", (Object)Long.parseLong(swPolicyIdStr));
        }
        if (HRStringUtils.isNotEmpty((String)(limitScope = (String)formShowParameter.getCustomParam("limitscope")))) {
            RuleConditionService instance = RuleConditionService.getInstance((String)"customcontroswllimit");
            instance.setView(this.getView());
            instance.setValue(limitScope);
        }
    }

    public void afterDoOperation(AfterDoOperationEventArgs afterDoOperationEventArgs) {
        super.afterDoOperation(afterDoOperationEventArgs);
        if ("save".equals(afterDoOperationEventArgs.getOperateKey()) && afterDoOperationEventArgs.getOperationResult().isSuccess()) {
            DynamicObject dataEntity = this.getModel().getDataEntity();
            RuleConditionService instance = RuleConditionService.getInstance((String)"customcontroswllimit");
            instance.setView(this.getView());
            String validateConditionMsg = SwShiftPlanService.getInstance().validateCondition(instance.getValue());
            if (HRStringUtils.isNotEmpty((String)validateConditionMsg)) {
                this.getView().showTipNotification(validateConditionMsg);
                return;
            }
            HashMap returnMap = Maps.newHashMap();
            returnMap.put("operate", this.getView().getFormShowParameter().getCustomParam("operate"));
            returnMap.put("limitscope", instance.getValue());
            returnMap.put("entryseq", dataEntity.getString("entryseq"));
            returnMap.put("swshiftbaseset", String.valueOf(WTCDynamicObjectUtils.getBaseDataId((DynamicObject)dataEntity, (String)"swshiftbaseset")));
            returnMap.put("swshiftpolicy", String.valueOf(WTCDynamicObjectUtils.getBaseDataId((DynamicObject)dataEntity, (String)"swshiftpolicy")));
            returnMap.put("basedataid", String.valueOf(dataEntity.getLong("basedataid")));
            this.getView().returnDataToParent((Object)returnMap);
            this.getView().close();
        }
    }

    public void beforeF7Select(BeforeF7SelectEvent beforeF7SelectEvent) {
        Date bsed;
        IFormView parentView;
        String f7Name = beforeF7SelectEvent.getProperty().getName();
        if ("swshiftpolicy".equals(f7Name)) {
            beforeF7SelectEvent.addCustomQFilter(new QFilter("type", "=", (Object)"SW"));
        } else if ("swshiftbaseset".equals(f7Name) && (parentView = this.getView().getViewNoPlugin(this.getView().getFormShowParameter().getParentPageId())) != null && (bsed = parentView.getModel().getDataEntity().getDate("bsed")) != null) {
            beforeF7SelectEvent.addCustomQFilter(new QFilter("firstbsed", "<=", (Object)bsed));
        }
    }
}

