/*
 * Decompiled with CFR 0.152.
 */
package kd.wtc.wtp.formplugin.web.timecut;

import java.util.Arrays;
import java.util.EventObject;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.bos.bill.OperationStatus;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.datamodel.events.ChangeData;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.exception.KDBizException;
import kd.bos.form.ConfirmCallBackListener;
import kd.bos.form.ConfirmTypes;
import kd.bos.form.FormShowParameter;
import kd.bos.form.MessageBoxOptions;
import kd.bos.form.MessageBoxResult;
import kd.bos.form.control.Control;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.BeforeClosedEvent;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.events.CustomEventArgs;
import kd.bos.form.events.MessageBoxClosedEvent;
import kd.bos.form.field.BasedataEdit;
import kd.bos.form.field.events.BeforeF7SelectEvent;
import kd.bos.form.field.events.BeforeF7SelectListener;
import kd.bos.form.operate.AbstractOperate;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.list.ListShowParameter;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.hr.hbp.formplugin.web.HRDataBaseEdit;
import kd.wtc.wtbs.business.rulecontrol.RuleConditionService;
import kd.wtc.wtbs.common.util.WTCMaps;
import kd.wtc.wtbs.common.util.WTCStringUtils;
import kd.wtc.wtbs.common.util.third.collect.Maps;
import kd.wtc.wtp.business.timecut.TimeCutValidatorHelper;
import kd.wtc.wtp.common.kdstring.TimeCutKDString;

public class TimeCutConfigEdit
extends HRDataBaseEdit
implements BeforeF7SelectListener {
    public static final Log LOG = LogFactory.getLog(TimeCutConfigEdit.class);
    private static List<String> DATE_RANGE_CONDITIONS = Arrays.asList("beforedaycond", "daycond", "afterdaycond");
    private RuleConditionService ruleConditionBeforeDayService = RuleConditionService.getInstance((String)"beforedaycond");
    private RuleConditionService ruleConditionDayService = RuleConditionService.getInstance((String)"daycond");
    private RuleConditionService ruleConditionAfterDayService = RuleConditionService.getInstance((String)"afterdaycond");
    private static final String[] ALL_OFF_SHIFT_COND = new String[]{"timecut.wtbd_stddaterange.dateattribute==DS-0003", "timecut.wtbd_stddaterange.dateattribute==DS-0002", "timecut.wtbd_stddaterange.dateattributeinDS-0002,DS-0003", "timecut.wtbd_stddaterange.dateattributeinDS-0002", "timecut.wtbd_stddaterange.dateattributeinDS-0003", "timecut.wtbd_stddaterange.dateattribute!=DS-0001", "timecut.wtbd_stddaterange.dateattributenot_inDS-0001", "timecut.wtbd_stddaterange.dateattributenot_inDS-0001,DS-0002", "timecut.wtbd_stddaterange.dateattributenot_inDS-0001,DS-0003"};

    public void registerListener(EventObject e) {
        super.registerListener(e);
        BasedataEdit dateTypeTime = (BasedataEdit)this.getView().getControl("datetypetime");
        dateTypeTime.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        BasedataEdit dateType = (BasedataEdit)this.getView().getControl("cutattitem");
        dateType.addBeforeF7SelectListener((BeforeF7SelectListener)this);
    }

    public void afterLoadData(EventObject e) {
        super.afterLoadData(e);
        this.setPageData();
    }

    public void afterCreateNewData(EventObject e) {
        super.afterCreateNewData(e);
        this.setPageData();
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs evt) {
        AbstractOperate op;
        String operateKey;
        if (evt.getSource() instanceof AbstractOperate && "save".equals(operateKey = (op = (AbstractOperate)evt.getSource()).getOperateKey())) {
            evt.setCancel(!this.checkParamsBeforeSave());
        }
    }

    public void afterDoOperation(AfterDoOperationEventArgs evt) {
        AbstractOperate op;
        String operateKey;
        if (evt.getSource() instanceof AbstractOperate && "save".equals(operateKey = (op = (AbstractOperate)evt.getSource()).getOperateKey())) {
            Map<String, Object> returnData = this.setReturnDate();
            FormShowParameter formShowParameter = this.getView().getFormShowParameter();
            Integer rowIndex = (Integer)formShowParameter.getCustomParam("rowIndex");
            returnData.put("rowIndex", rowIndex);
            this.getView().getPageCache().put("forceClose", "1");
            this.getView().returnDataToParent(returnData);
            this.getView().sendFormAction(this.getView().getParentView());
        }
    }

    public void beforeF7Select(BeforeF7SelectEvent beforeF7SelectEvent) {
        ListShowParameter showParameter;
        String key = ((Control)beforeF7SelectEvent.getSource()).getKey();
        if ("datetypetime".contains(key)) {
            showParameter = (ListShowParameter)beforeF7SelectEvent.getFormShowParameter();
            showParameter.getListFilterParameter().setFilter(new QFilter("datatype", "=", (Object)"2"));
        }
        if ("cutattitem".contains(key)) {
            showParameter = (ListShowParameter)beforeF7SelectEvent.getFormShowParameter();
            showParameter.getListFilterParameter().setFilter(new QFilter("datatype", "=", (Object)"1"));
        }
    }

    public void customEvent(CustomEventArgs args) {
        super.customEvent(args);
        if (DATE_RANGE_CONDITIONS.contains(args.getKey()) && "setValue".equals(args.getEventName())) {
            String beforeDayCond = this.ruleConditionBeforeDayService.setView(this.getView()).getValue();
            String dayCond = this.ruleConditionDayService.setView(this.getView()).getValue();
            String afterDayCond = this.ruleConditionAfterDayService.setView(this.getView()).getValue();
            this.setIsCutAttItemButton(beforeDayCond, dayCond, afterDayCond);
            this.checkConditionStrLength(beforeDayCond, TimeCutKDString.getBeforeDayStr());
            this.checkConditionStrLength(dayCond, TimeCutKDString.getDayStr());
            this.checkConditionStrLength(afterDayCond, TimeCutKDString.getAfterDayStr());
        }
    }

    public void propertyChanged(PropertyChangedArgs evt) {
        ChangeData changeData;
        super.propertyChanged(evt);
        String key = evt.getProperty().getName();
        if ("iscutattitem".equals(key) && !((Boolean)(changeData = evt.getChangeSet()[0]).getNewValue()).booleanValue()) {
            this.getModel().setValue("cutattitem", null);
        }
    }

    public void beforeClosed(BeforeClosedEvent e) {
        super.beforeClosed(e);
        if (this.getModel().getDataChanged() && !"1".equals(this.getView().getPageCache().get("forceClose"))) {
            HashMap btnNameMaps = Maps.newHashMapWithExpectedSize((int)2);
            btnNameMaps.put(MessageBoxResult.Cancel.getValue(), ResManager.loadKDString((String)"\u8fd4\u56de\u7f16\u8f91", (String)"TimeCutConfigEdit_1", (String)"wtc-wtp-formplugin", (Object[])new Object[0]));
            btnNameMaps.put(MessageBoxResult.Yes.getValue(), ResManager.loadKDString((String)"\u76f4\u63a5\u9000\u51fa", (String)"TimeCutConfigEdit_2", (String)"wtc-wtp-formplugin", (Object[])new Object[0]));
            ConfirmCallBackListener confirmCallBackListener = new ConfirmCallBackListener("back", (IFormPlugin)this);
            MessageBoxOptions options = MessageBoxOptions.OKCancel;
            this.getView().showConfirm(TimeCutKDString.getCloseNotify(), this.getModel().getChangeDesc(), options, ConfirmTypes.Save, confirmCallBackListener, (Map)btnNameMaps);
            e.setCancel(true);
        }
    }

    public void confirmCallBack(MessageBoxClosedEvent messageBoxClosedEvent) {
        super.confirmCallBack(messageBoxClosedEvent);
        MessageBoxResult result = messageBoxClosedEvent.getResult();
        if (MessageBoxResult.Yes.equals((Object)result) && "back".equals(messageBoxClosedEvent.getCallBackId())) {
            this.getView().getPageCache().put("forceClose", "1");
            this.getView().close();
        }
    }

    private void setPageData() {
        FormShowParameter formShowParameter = this.getView().getFormShowParameter();
        Map customParams = formShowParameter.getCustomParams();
        if (WTCMaps.isNotEmpty((Map)customParams)) {
            Map entryInfoMap = (Map)customParams.get("entry_info");
            this.setEntryInfo(entryInfoMap);
            if (WTCMaps.isNotEmpty((Map)entryInfoMap)) {
                this.setIsCutAttItemButton((String)entryInfoMap.get("beforedaycond"), (String)entryInfoMap.get("daycond"), (String)entryInfoMap.get("afterdaycond"));
            }
        }
        if (this.getView().getFormShowParameter().getStatus() == OperationStatus.VIEW) {
            this.getView().getPageCache().put("forceClose", "1");
        } else {
            this.getView().getPageCache().put("forceClose", "0");
        }
    }

    private void setEntryInfo(Map<String, Object> entryInfoMap) {
        if (WTCMaps.isNotEmpty(entryInfoMap)) {
            this.getModel().setValue("configname", entryInfoMap.get("configname"));
            this.getModel().setValue("configdes", entryInfoMap.get("configdes"));
            if (entryInfoMap.containsKey("beforedaycond")) {
                this.ruleConditionBeforeDayService.setView(this.getView()).setValue((String)entryInfoMap.get("beforedaycond"));
            }
            if (entryInfoMap.containsKey("daycond")) {
                this.ruleConditionDayService.setView(this.getView()).setValue((String)entryInfoMap.get("daycond"));
            }
            if (entryInfoMap.containsKey("afterdaycond")) {
                this.ruleConditionAfterDayService.setView(this.getView()).setValue((String)entryInfoMap.get("afterdaycond"));
            }
            this.getModel().setValue("datetypetime", entryInfoMap.get("datetypetime"));
            this.getModel().setValue("iscutattitem", entryInfoMap.get("iscutattitem"));
            this.getModel().setValue("cutattitem", entryInfoMap.get("cutattitem"));
            this.getModel().setValue("org", entryInfoMap.get("createorg"));
        } else {
            this.getModel().setValue("org", (Object)RequestContext.get().getOrgId());
        }
    }

    private Map<String, Object> setReturnDate() {
        HashMap<String, Object> returnData = new HashMap<String, Object>(16);
        returnData.put("configname", this.getModel().getValue("configname"));
        returnData.put("configdes", this.getModel().getValue("configdes"));
        returnData.put("beforedaycond", this.ruleConditionBeforeDayService.setView(this.getView()).getValue());
        returnData.put("daycond", this.ruleConditionDayService.setView(this.getView()).getValue());
        returnData.put("afterdaycond", this.ruleConditionAfterDayService.setView(this.getView()).getValue());
        returnData.put("datetypetime", ((DynamicObject)this.getModel().getValue("datetypetime")).getPkValue());
        returnData.put("iscutattitem", this.getModel().getValue("iscutattitem"));
        if (this.getModel().getValue("cutattitem") != null) {
            returnData.put("cutattitem", ((DynamicObject)this.getModel().getValue("cutattitem")).getPkValue());
        }
        returnData.put("org", this.getModel().getValue("org"));
        return returnData;
    }

    private boolean checkParamsBeforeSave() {
        boolean passed = true;
        IDataModel model = this.getModel();
        if (model.getValue("datetypetime") == null) {
            this.getView().showErrorNotification(TimeCutKDString.getConfigEditNotifyStr0());
            return false;
        }
        String ruleConditionDayJson = this.ruleConditionDayService.setView(this.getView()).getValue();
        if (TimeCutValidatorHelper.checkCondition((String)TimeCutKDString.getDayStr(), (String)ruleConditionDayJson)) {
            this.getView().showErrorNotification(TimeCutKDString.getConfigEditNotifyStr1());
            return false;
        }
        LOG.info("TimeCutConfigEdit.beforeDoSave.beforeCondJson:{}", (Object)ruleConditionDayJson);
        String ruleConditionBeforeJson = this.ruleConditionBeforeDayService.setView(this.getView()).getValue();
        String ruleConditionAfterJson = this.ruleConditionAfterDayService.setView(this.getView()).getValue();
        if (TimeCutValidatorHelper.checkCondition((String)TimeCutKDString.getBeforeDayStr(), (String)ruleConditionBeforeJson) & TimeCutValidatorHelper.checkCondition((String)TimeCutKDString.getAfterDayStr(), (String)ruleConditionAfterJson)) {
            this.getView().showErrorNotification(TimeCutKDString.getConfigEditNotifyStr2());
            return false;
        }
        this.checkConditionStrLength(ruleConditionDayJson, TimeCutKDString.getDayStr());
        this.checkConditionStrLength(ruleConditionBeforeJson, TimeCutKDString.getBeforeDayStr());
        this.checkConditionStrLength(ruleConditionAfterJson, TimeCutKDString.getAfterDayStr());
        boolean neighbourCheck = true;
        String neighbourCheckMsg = "";
        LOG.info("TimeCutConfigEdit.beforeDoSave.beforeCondJson:{}", (Object)ruleConditionBeforeJson);
        if (!TimeCutValidatorHelper.unSameCondition((String)ruleConditionDayJson, (String)ruleConditionBeforeJson)) {
            neighbourCheck = false;
            neighbourCheckMsg = TimeCutKDString.getConfigEditNotifyStr3((String)TimeCutKDString.getBeforeDayStr());
        }
        LOG.info("TimeCutConfigEdit.beforeDoSave.afterCondJson:{}", (Object)ruleConditionAfterJson);
        if (!TimeCutValidatorHelper.unSameCondition((String)ruleConditionDayJson, (String)ruleConditionAfterJson)) {
            neighbourCheck = false;
            if (WTCStringUtils.isNotEmpty((String)neighbourCheckMsg)) {
                neighbourCheckMsg = neighbourCheckMsg + "\r\n";
            }
            neighbourCheckMsg = neighbourCheckMsg + TimeCutKDString.getConfigEditNotifyStr3((String)TimeCutKDString.getAfterDayStr());
        }
        if (!neighbourCheck) {
            this.getView().showErrorNotification(neighbourCheckMsg);
            return false;
        }
        if (!this.checkOtherEntrySameCond(ruleConditionBeforeJson, ruleConditionDayJson, ruleConditionAfterJson)) {
            this.getView().showErrorNotification(TimeCutKDString.getConfigEditNotifyStr4());
            return false;
        }
        return passed;
    }

    private boolean checkOtherEntrySameCond(String beforeDayCond, String dayCond, String afterDayCond) {
        boolean passed = true;
        DynamicObjectCollection entryEntity = this.getView().getParentView().getModel().getEntryEntity("timecutentry");
        FormShowParameter formShowParameter = this.getView().getFormShowParameter();
        Integer rowIndex = (Integer)formShowParameter.getCustomParam("rowIndex");
        for (int index = 0; index < entryEntity.size(); ++index) {
            DynamicObject dy;
            String otherDayCond;
            if (rowIndex != null && index == rowIndex || TimeCutValidatorHelper.unSameCondition((String)dayCond, (String)(otherDayCond = (dy = (DynamicObject)entryEntity.get(index)).getString("daycond"))) || TimeCutValidatorHelper.unSameCondition((String)dy.getString("beforedaycond"), (String)beforeDayCond) || TimeCutValidatorHelper.unSameCondition((String)dy.getString("afterdaycond"), (String)afterDayCond)) continue;
            passed = false;
        }
        return passed;
    }

    private void setIsCutAttItemButton(String beforeDayCond, String dayCond, String afterDayCond) {
        if (this.checkNeighbourDayAllIsOffShift(beforeDayCond, dayCond, afterDayCond)) {
            this.getModel().setValue("iscutattitem", (Object)false);
            this.getModel().setValue("cutattitem", null);
            this.getView().setEnable(Boolean.valueOf(false), new String[]{"iscutattitem"});
        } else {
            this.getView().setEnable(Boolean.valueOf(true), new String[]{"iscutattitem"});
        }
        this.getView().updateView("iscutattitem");
        this.getView().updateView("cutattitem");
    }

    private boolean checkNeighbourDayAllIsOffShift(String beforeDayCond, String dayCond, String afterDayCond) {
        boolean dayAllOffShift = TimeCutValidatorHelper.isAllSame((String)dayCond, (String[])ALL_OFF_SHIFT_COND);
        if (!(!dayAllOffShift || WTCStringUtils.isEmpty((String)beforeDayCond) && WTCStringUtils.isEmpty((String)afterDayCond))) {
            boolean beforeDayAllOffShift = TimeCutValidatorHelper.isAllSameTimeCut((String)beforeDayCond, (String[])ALL_OFF_SHIFT_COND);
            boolean afterDayAllOffShift = TimeCutValidatorHelper.isAllSameTimeCut((String)afterDayCond, (String[])ALL_OFF_SHIFT_COND);
            if (beforeDayAllOffShift && afterDayAllOffShift) {
                return true;
            }
        }
        return false;
    }

    private void checkConditionStrLength(String conditionStr, String condType) {
        if (WTCStringUtils.isNotEmpty((String)conditionStr) && conditionStr.length() > 4000) {
            throw new KDBizException(TimeCutKDString.getConditionStrUltramarineNotify((Object[])new Object[]{condType}));
        }
    }
}

