/*
 * Decompiled with CFR 0.152.
 */
package kd.wtc.wtp.formplugin.web.timecut;

import java.util.ArrayList;
import java.util.Collection;
import java.util.EventObject;
import java.util.HashMap;
import java.util.Map;
import kd.bos.bill.OperationStatus;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.datamodel.events.AfterDeleteRowEventArgs;
import kd.bos.form.CloseCallBack;
import kd.bos.form.FormShowParameter;
import kd.bos.form.ShowType;
import kd.bos.form.control.EntryGrid;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.events.HyperLinkClickEvent;
import kd.bos.form.events.HyperLinkClickListener;
import kd.bos.form.operate.FormOperate;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.lang.Lang;
import kd.bos.orm.util.CollectionUtils;
import kd.hr.hbp.formplugin.web.HRDataBaseEdit;
import kd.wtc.wtbd.common.constants.scenecfg.SceneCfgKDString;
import kd.wtc.wtbs.common.util.WTCMaps;
import kd.wtc.wtbs.common.util.WTCStringUtils;
import kd.wtc.wtbs.common.util.WTCSymbolMultiLanguageUtil;
import kd.wtc.wtp.business.ruleenging.RulePreviewUtil;
import kd.wtc.wtp.business.timecut.TimeCutValidatorHelper;
import kd.wtc.wtp.common.kdstring.TimeCutKDString;
import kd.wtc.wtp.constants.timecut.TimeCutConstants;

public class TimeCutEdit
extends HRDataBaseEdit
implements HyperLinkClickListener {
    public void afterBindData(EventObject evt) {
        super.afterBindData(evt);
        DynamicObjectCollection entries = this.getModel().getEntryEntity("timecutentry");
        for (int i = 0; i < entries.size(); ++i) {
            this.setConditionStr(i);
        }
    }

    public void registerListener(EventObject evt) {
        super.registerListener(evt);
        this.addItemClickListeners(TimeCutConstants.CLICK_ID);
        EntryGrid formulaEntryGrid = (EntryGrid)this.getView().getControl("timecutentry");
        formulaEntryGrid.addHyperClickListener((HyperLinkClickListener)this);
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        String operateKey;
        FormOperate formOperate = (FormOperate)args.getSource();
        switch (operateKey = formOperate.getOperateKey()) {
            case "save": 
            case "submit": 
            case "saveandnew": {
                DynamicObjectCollection entity = this.getView().getModel().getEntryEntity("timecutentry");
                if (!CollectionUtils.isEmpty((Collection)entity)) break;
                this.getView().showErrorNotification(TimeCutKDString.getNeedOneStr());
                args.setCancel(true);
                break;
            }
        }
    }

    public void afterDoOperation(AfterDoOperationEventArgs evt) {
        super.afterDoOperation(evt);
        switch (evt.getOperateKey()) {
            case "addentry": {
                this.getView().showForm(this.openConfigPage(OperationStatus.ADDNEW, null));
                break;
            }
            case "edit": {
                EntryGrid entryGrid = (EntryGrid)this.getControl("timecutentry");
                int rowIndex = entryGrid.getEntryState().getFocusRow();
                DynamicObject dynamicObject = (DynamicObject)this.getModel().getEntryEntity("timecutentry").get(rowIndex);
                FormShowParameter showParameter = this.openConfigPage(OperationStatus.EDIT, dynamicObject);
                showParameter.getCustomParams().put("rowIndex", rowIndex);
                this.getView().showForm(showParameter);
            }
        }
    }

    public void afterDeleteRow(AfterDeleteRowEventArgs e) {
        this.getView().showSuccessNotification(ResManager.loadKDString((String)"\u5220\u9664\u6210\u529f\u3002", (String)"OverWorkRuleEdit_5", (String)"wtc-wtp-formplugin", (Object[])new Object[0]));
    }

    public void closedCallBack(ClosedCallBackEvent event) {
        String actionId = event.getActionId();
        Map returnData = (Map)event.getReturnData();
        if ("wtp_timecutconfig".equals(actionId) && WTCMaps.isNotEmpty((Map)returnData)) {
            Integer rowIndex = (Integer)returnData.get("rowIndex");
            if (rowIndex == null) {
                IDataModel entryOperate = this.getModel();
                rowIndex = entryOperate.createNewEntryRow("timecutentry");
            }
            this.updateEntryRow(returnData, rowIndex);
        }
    }

    public void hyperLinkClick(HyperLinkClickEvent args) {
        String name = args.getFieldName();
        if ("configname".equals(name)) {
            int rowIndex = args.getRowIndex();
            DynamicObject dynamicObject = (DynamicObject)this.getModel().getEntryEntity("timecutentry").get(rowIndex);
            FormShowParameter showParameter = this.openConfigPage(OperationStatus.VIEW, dynamicObject);
            Map customParams = showParameter.getCustomParams();
            customParams.put("rowIndex", rowIndex);
            this.getView().showForm(showParameter);
        }
    }

    private FormShowParameter openConfigPage(OperationStatus operationStatus, DynamicObject entryDy) {
        FormShowParameter formShowParameter = new FormShowParameter();
        formShowParameter.setFormId("wtp_timecutconfig");
        formShowParameter.getOpenStyle().setShowType(ShowType.Modal);
        formShowParameter.setCloseCallBack(new CloseCallBack((IFormPlugin)this, "wtp_timecutconfig"));
        formShowParameter.setStatus(operationStatus);
        HashMap<String, Object> entryInfo = new HashMap<String, Object>(16);
        DynamicObject org = (DynamicObject)this.getModel().getValue("createorg");
        if (org != null) {
            entryInfo.put("createorg", org.getPkValue());
        } else {
            entryInfo.put("createorg", RequestContext.get().getOrgId());
        }
        if (operationStatus == OperationStatus.EDIT || operationStatus == OperationStatus.VIEW) {
            this.setEntryInfoToEditPage(entryInfo, entryDy);
        }
        formShowParameter.setCustomParam("entry_info", entryInfo);
        return formShowParameter;
    }

    private void updateEntryRow(Map<String, Object> returnData, Integer rowIndex) {
        this.getModel().setValue("configname", returnData.get("configname"), rowIndex.intValue());
        this.getModel().setValue("configdes", returnData.get("configdes"), rowIndex.intValue());
        this.getModel().setValue("beforedaycond", returnData.get("beforedaycond"), rowIndex.intValue());
        this.getModel().setValue("daycond", returnData.get("daycond"), rowIndex.intValue());
        this.getModel().setValue("afterdaycond", returnData.get("afterdaycond"), rowIndex.intValue());
        this.getModel().setValue("datetypetime", returnData.get("datetypetime"), rowIndex.intValue());
        this.getModel().setValue("iscutattitem", returnData.get("iscutattitem"), rowIndex.intValue());
        this.getModel().setValue("cutattitem", returnData.get("cutattitem"), rowIndex.intValue());
        this.setConditionStr(rowIndex);
        this.getView().updateView("timecutentry");
    }

    private void setEntryInfoToEditPage(Map<String, Object> entryInfo, DynamicObject entryDy) {
        entryInfo.put("configname", entryDy.get("configname"));
        entryInfo.put("configdes", entryDy.get("configdes"));
        entryInfo.put("beforedaycond", entryDy.get("beforedaycond"));
        entryInfo.put("daycond", entryDy.get("daycond"));
        entryInfo.put("afterdaycond", entryDy.get("afterdaycond"));
        entryInfo.put("datetypetime", entryDy.get("datetypetime.id"));
        entryInfo.put("iscutattitem", entryDy.get("iscutattitem"));
        entryInfo.put("cutattitem", entryDy.get("cutattitem.id"));
    }

    private void setConditionStr(Integer rowIndex) {
        String emptyStr;
        DynamicObject entry = (DynamicObject)this.getModel().getEntryEntity("timecutentry").get(rowIndex.intValue());
        String beforeStr = null;
        String dayStr = null;
        String afterStr = null;
        Object beforeCond = entry.get("beforedaycond");
        Object dayCond = entry.get("daycond");
        Object afterCond = entry.get("afterdaycond");
        String string = emptyStr = Lang.zh_TW == Lang.get() || Lang.zh_CN == Lang.get() ? "" : " ";
        if (beforeCond != null && !TimeCutValidatorHelper.emptyCondition((String)((String)beforeCond))) {
            beforeStr = TimeCutKDString.getBeforeDayStr() + emptyStr + RulePreviewUtil.getConditionPreviewStr((String)((String)beforeCond));
        }
        if (dayCond != null && !TimeCutValidatorHelper.emptyCondition((String)((String)dayCond))) {
            dayStr = TimeCutKDString.getDayStr() + emptyStr + RulePreviewUtil.getConditionPreviewStr((String)((String)dayCond));
        }
        if (afterCond != null && !TimeCutValidatorHelper.emptyCondition((String)((String)afterCond))) {
            afterStr = TimeCutKDString.getAfterDayStr() + emptyStr + RulePreviewUtil.getConditionPreviewStr((String)((String)afterCond));
        }
        ArrayList<String> conditionStr = new ArrayList<String>();
        if (WTCStringUtils.isNotEmpty(beforeStr)) {
            conditionStr.add(beforeStr);
        }
        if (WTCStringUtils.isNotEmpty(dayStr)) {
            conditionStr.add(dayStr);
        }
        if (WTCStringUtils.isNotEmpty(afterStr)) {
            conditionStr.add(afterStr);
        }
        this.getModel().setValue("conditionstr", (Object)String.join((CharSequence)(WTCSymbolMultiLanguageUtil.getCommonSymbol() + SceneCfgKDString.and() + emptyStr), conditionStr), rowIndex.intValue());
    }
}

