/*
 * Decompiled with CFR 0.152.
 */
package kd.wtc.wtp.formplugin.web.timeresolve;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.EventObject;
import java.util.HashMap;
import java.util.List;
import java.util.stream.Collectors;
import kd.bos.bill.OperationStatus;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.datamodel.AbstractFormDataModel;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.datamodel.TableValueSetter;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.form.control.Control;
import kd.bos.form.control.EntryGrid;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.field.FieldEdit;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.MetadataServiceHelper;
import kd.hr.hbp.business.servicehelper.HRBaseServiceHelper;
import kd.hr.hbp.common.util.HRStringUtils;
import kd.hr.hbp.formplugin.web.HRDataBaseEdit;
import kd.wtc.wtp.formplugin.web.timeresolve.DoWrapper;

public class TimeResolveEdit
extends HRDataBaseEdit {
    private static final String WTP_TIMECOMBINATION = "wtp_timecombination";
    private static final String ENTRYENTITY = "entryentity";
    private static final String WTP_COLUMNMAP = "wtp_columnmap";
    private static final String RESULT_WTP_COLUMN_PREFIX = "result";
    private static final String WTP_TRITOTAL = "wtp_tritotal";

    public void afterBindData(EventObject evt) {
        super.afterBindData(evt);
        this.swithToView();
        this.initEntryColumn();
        OperationStatus viewStatus = this.getView().getFormShowParameter().getStatus();
        if (OperationStatus.ADDNEW.equals((Object)viewStatus)) {
            return;
        }
        EntryGrid entryGrid = (EntryGrid)this.getControl(ENTRYENTITY);
        List items = entryGrid.getItems();
        HashMap<String, Control> map = new HashMap<String, Control>(16);
        for (Control control : items) {
            map.put(control.getKey(), control);
        }
        HRBaseServiceHelper hrBaseServiceHelper = new HRBaseServiceHelper(WTP_COLUMNMAP);
        String selectProp = "columnname,totalid";
        QFilter[] qFilters = new QFilter[]{new QFilter("timeresolve", "=", (Object)Long.parseLong(this.getModel().getValue("id").toString()))};
        DynamicObject[] objects = hrBaseServiceHelper.query(selectProp, qFilters);
        if (objects.length > 0) {
            this.renameFirstResultCColumn();
        }
        HRBaseServiceHelper hrBaseServiceHelper2 = new HRBaseServiceHelper(WTP_TRITOTAL);
        Arrays.stream(objects).forEach(object -> {
            if (map.containsKey(object.get("columnname"))) {
                FieldEdit fieldEdit = (FieldEdit)map.get(object.get("columnname"));
                fieldEdit.setVisible("", true);
                DynamicObject dynamicObject = hrBaseServiceHelper2.queryOne("name", new QFilter[]{new QFilter("id", "=", (Object)object.getLong("totalid"))});
                fieldEdit.setCaption(new LocaleString(dynamicObject.getString("name")));
            }
        });
    }

    private void initEntryColumn() {
        EntryGrid entryGrid = (EntryGrid)this.getControl(ENTRYENTITY);
        entryGrid.getItems().forEach(oo -> ((FieldEdit)oo).setVisible("", false));
        FieldEdit fieldEdit0 = (FieldEdit)entryGrid.getItems().get(0);
        fieldEdit0.setVisible("", true);
        FieldEdit fieldEdit1 = (FieldEdit)entryGrid.getItems().get(1);
        fieldEdit1.setVisible("", true);
        FieldEdit fieldEdit2 = (FieldEdit)entryGrid.getItems().get(2);
        fieldEdit2.setVisible("", true);
        fieldEdit2.setCaption(new LocaleString(ResManager.loadKDString((String)"\u89e3\u6790\u7ed3\u679c", (String)"TimeResolveEdit_0", (String)"wtc-wtp-formplugin", (Object[])new Object[0])));
    }

    private void renameFirstResultCColumn() {
        EntryGrid entryGrid = (EntryGrid)this.getControl(ENTRYENTITY);
        FieldEdit fieldEdit2 = (FieldEdit)entryGrid.getItems().get(2);
        fieldEdit2.setVisible("", true);
        fieldEdit2.setCaption(new LocaleString(ResManager.loadKDString((String)"\u975e\u7d2f\u8ba1\u89e6\u53d1\u65f6\u6bb5", (String)"TimeResolveEdit_1", (String)"wtc-wtp-formplugin", (Object[])new Object[0])));
    }

    public void propertyChanged(PropertyChangedArgs evt) {
        String key;
        switch (key = evt.getProperty().getName()) {
            case "timesystem": {
                this.swithToView();
                break;
            }
            case "timecombine": {
                this.timeCombineChanged();
                break;
            }
        }
    }

    public void afterDoOperation(AfterDoOperationEventArgs afterDoOperationEventArgs) {
        boolean isAppointKey;
        super.afterDoOperation(afterDoOperationEventArgs);
        String operateKey = afterDoOperationEventArgs.getOperateKey();
        boolean bl = isAppointKey = HRStringUtils.equals((String)operateKey, (String)"save") || HRStringUtils.equals((String)operateKey, (String)"submit") || HRStringUtils.equals((String)operateKey, (String)"submitandaudit") && afterDoOperationEventArgs.getOperationResult().isSuccess();
        if (isAppointKey) {
            HRBaseServiceHelper hrBaseServiceHelper = new HRBaseServiceHelper(WTP_COLUMNMAP);
            DynamicObject dataEntity = this.getModel().getDataEntity(true);
            long timeresolveId = dataEntity.getLong("id");
            QFilter[] delqFilters = new QFilter[]{new QFilter("timeresolve", "=", (Object)timeresolveId)};
            hrBaseServiceHelper.deleteByFilter(delqFilters);
            DynamicObject[] dynamicObjects = this.getColumnmapDOs(dataEntity, timeresolveId);
            hrBaseServiceHelper.save(dynamicObjects);
        }
    }

    private DynamicObject[] getColumnmapDOs(DynamicObject dataEntity, long timeresolveId) {
        DynamicObject timecombine = dataEntity.getDynamicObject("timecombine");
        Long id = timecombine.getLong("id");
        HRBaseServiceHelper hrBaseServiceHelper = new HRBaseServiceHelper(WTP_TIMECOMBINATION);
        QFilter[] qFilters = new QFilter[]{new QFilter("id", "=", (Object)id)};
        String selectProp = "triggerperiodentry.totalid,triggerperiodentry.totalid.name";
        DynamicObject dynamicObject = hrBaseServiceHelper.queryOne(selectProp, qFilters);
        DynamicObjectCollection triggerperiodentry = dynamicObject.getDynamicObjectCollection("triggerperiodentry");
        MainEntityType columnMapType = MetadataServiceHelper.getDataEntityType((String)WTP_COLUMNMAP);
        int size = triggerperiodentry.size();
        DynamicObject[] dynamicObjects = new DynamicObject[size];
        for (int i = 0; i < size; ++i) {
            long totalId = ((DynamicObject)triggerperiodentry.get(i)).getDynamicObject("totalid").getLong("id");
            DynamicObject dy = new DynamicObject((DynamicObjectType)columnMapType);
            dy.set("timeresolve", (Object)timeresolveId);
            dy.set("totalid", (Object)totalId);
            dy.set("columnname", (Object)(RESULT_WTP_COLUMN_PREFIX + (i + 2)));
            dynamicObjects[i] = dy;
        }
        return dynamicObjects;
    }

    private void timeCombineChanged() {
        IDataModel model = this.getModel();
        DynamicObject timecombine = model.getDataEntity().getDynamicObject("timecombine");
        if (timecombine == null) {
            model.deleteEntryData(ENTRYENTITY);
            return;
        }
        Long id = timecombine.getLong("id");
        HRBaseServiceHelper hrBaseServiceHelper = new HRBaseServiceHelper(WTP_TIMECOMBINATION);
        QFilter[] qFilters = new QFilter[]{new QFilter("id", "=", (Object)id)};
        String selectProp = "shiftperiodentry.shiftinner,shiftperiodentry.shiftinner.name,shiftperiodentry.shiftinner.shiftstarttime,shiftperiodentry.shiftinner.shiftendtime,shiftperiodentry.shiftinner.shiftofftime,shiftperiodentry.shiftinner.shiftresttimedatetypeentry,datetypeentry.typeid,datetypeentry.typeid.name,triggerperiodentry.totalid,triggerperiodentry.totalid.name";
        DynamicObject dynamicObject = hrBaseServiceHelper.queryOne(selectProp, qFilters);
        DynamicObjectCollection shiftperiodentry = dynamicObject.getDynamicObjectCollection("shiftperiodentry");
        DynamicObjectCollection datetypeentry = dynamicObject.getDynamicObjectCollection("datetypeentry");
        List<List<DoWrapper>> subsets = this.getSubsets(shiftperiodentry, datetypeentry);
        subsets.sort(Comparator.comparingInt(List::size));
        this.setSubsetsToEntry(model, subsets);
        DynamicObjectCollection triggerperiodentry = dynamicObject.getDynamicObjectCollection("triggerperiodentry");
        int size = triggerperiodentry.size();
        EntryGrid entryGrid = (EntryGrid)this.getControl(ENTRYENTITY);
        this.initEntryColumn();
        if (triggerperiodentry.size() > 0) {
            this.renameFirstResultCColumn();
        }
        for (int i = 0; i < size; ++i) {
            String caption = ((DynamicObject)triggerperiodentry.get(i)).getDynamicObject("totalid").getString("name");
            FieldEdit fieldEdit = (FieldEdit)entryGrid.getItems().get(i + 3);
            fieldEdit.setCaption(new LocaleString(caption));
            fieldEdit.setVisible("", true);
        }
        this.getView().updateView(ENTRYENTITY);
    }

    private void setSubsetsToEntry(IDataModel model, List<List<DoWrapper>> subsets) {
        AbstractFormDataModel model2 = (AbstractFormDataModel)model;
        model2.deleteEntryData(ENTRYENTITY);
        TableValueSetter vs = new TableValueSetter(new String[0]);
        model2.beginInit();
        for (int i = 0; i < subsets.size(); ++i) {
            List<DoWrapper> rowData = subsets.get(i);
            TableValueSetter tableValueSetter = vs.addRow(new Object[0]);
            List shiftPeriods = rowData.stream().filter(ee -> ee.getType() == 1).collect(Collectors.toList());
            List dateTypes = rowData.stream().filter(ee -> ee.getType() == 2).collect(Collectors.toList());
            StringBuilder shiftPeriodId = new StringBuilder();
            StringBuilder shiftPeriodName = new StringBuilder();
            if (shiftPeriods.size() > 0) {
                for (DoWrapper shiftPeriod : shiftPeriods) {
                    shiftPeriodId.append(shiftPeriod.getDynamicObject().getDynamicObject("shiftinner").getLong("id")).append('*');
                    shiftPeriodName.append(shiftPeriod.getDynamicObject().getDynamicObject("shiftinner").getString("name")).append('+');
                }
                shiftPeriodId.deleteCharAt(shiftPeriodId.length() - 1);
                shiftPeriodName.deleteCharAt(shiftPeriodName.length() - 1);
            }
            StringBuilder dateTypeId = new StringBuilder();
            StringBuilder dateTypeName = new StringBuilder();
            if (dateTypes.size() > 0) {
                for (DoWrapper dateType : dateTypes) {
                    dateTypeId.append(dateType.getDynamicObject().getDynamicObject("typeid").getLong("id")).append('*');
                    dateTypeName.append(dateType.getDynamicObject().getDynamicObject("typeid").getString("name")).append('+');
                }
                dateTypeId.deleteCharAt(dateTypeId.length() - 1);
                dateTypeName.deleteCharAt(dateTypeName.length() - 1);
            }
            String compositionId = shiftPeriodId.append('+').append((CharSequence)dateTypeId).toString();
            String composition = null;
            composition = shiftPeriodName.length() == 0 && dateTypeName.length() == 0 ? ResManager.loadKDString((String)"\u9ed8\u8ba4", (String)"TimeResolveEdit_2", (String)"wtc-wtp-formplugin", (Object[])new Object[0]) : (dateTypeName.length() == 0 ? shiftPeriodName.toString() : (shiftPeriodName.length() == 0 ? dateTypeName.toString() : shiftPeriodName.append('+').append((CharSequence)dateTypeName).toString()));
            tableValueSetter.set("compositionid", (Object)compositionId, i);
            tableValueSetter.set("composition", (Object)composition, i);
        }
        model2.batchCreateNewEntryRow(ENTRYENTITY, vs);
        this.getView().updateView(ENTRYENTITY);
        model2.endInit();
    }

    private List<List<DoWrapper>> getSubsets(DynamicObjectCollection shiftperiodentry, DynamicObjectCollection datetypeentry) {
        ArrayList allEntrys = new ArrayList();
        shiftperiodentry.stream().forEach(ee -> allEntrys.add(new DoWrapper((DynamicObject)ee, 1)));
        datetypeentry.stream().forEach(ee -> allEntrys.add(new DoWrapper((DynamicObject)ee, 2)));
        ArrayList<List<DoWrapper>> res = new ArrayList<List<DoWrapper>>();
        ArrayList list = new ArrayList();
        res.add(list);
        for (DoWrapper dy : allEntrys) {
            ArrayList newRes = new ArrayList(10);
            for (List list2 : res) {
                ArrayList<DoWrapper> list1 = new ArrayList<DoWrapper>(list2);
                list1.add(dy);
                if (list1.stream().filter(oo -> oo.getType() == 1).count() > 1L) continue;
                newRes.add(new ArrayList(list1));
            }
            res.addAll(newRes);
        }
        return res;
    }

    private List<List<DoWrapper>> getSubsets2(DynamicObjectCollection shiftperiodentry, DynamicObjectCollection datetypeentry) {
        ArrayList<DoWrapper> allEntrys = new ArrayList<DoWrapper>();
        shiftperiodentry.forEach(ee -> allEntrys.add(new DoWrapper((DynamicObject)ee, 1)));
        datetypeentry.forEach(ee -> allEntrys.add(new DoWrapper((DynamicObject)ee, 2)));
        ArrayList<List<DoWrapper>> res = new ArrayList<List<DoWrapper>>();
        this.dfs(0, res, allEntrys, new ArrayList<DoWrapper>());
        return res;
    }

    private void dfs(int ii, List<List<DoWrapper>> res, List<DoWrapper> nums, ArrayList<DoWrapper> list) {
        res.add(new ArrayList<DoWrapper>(list));
        for (int j = ii; j < nums.size(); ++j) {
            list.add(nums.get(ii));
            this.dfs(j + 1, res, nums, list);
            list.remove(list.size() - 1);
        }
    }

    private void swithToView() {
        if ("1".equals(this.getModel().getValue("timesystem"))) {
            this.standardTimeView();
        } else if ("2".equals(this.getModel().getValue("timesystem"))) {
            this.compositeTimeView();
        } else if ("3".equals(this.getModel().getValue("timesystem"))) {
            this.unTimeView();
        }
    }

    public void standardTimeView() {
        this.getView().setVisible(Boolean.FALSE, new String[]{"timeaddway", "timetotalitem", "attaddtritotal", "balanceitem"});
        FieldEdit timeaddway = (FieldEdit)this.getControl("timeaddway");
        timeaddway.setMustInput(false);
        FieldEdit timetotalitem = (FieldEdit)this.getControl("timetotalitem");
        timetotalitem.setMustInput(false);
        FieldEdit attaddtritotal = (FieldEdit)this.getControl("attaddtritotal");
        attaddtritotal.setMustInput(false);
        FieldEdit balanceitem = (FieldEdit)this.getControl("balanceitem");
        balanceitem.setMustInput(false);
        this.getView().setVisible(Boolean.TRUE, new String[]{"shouldattitem"});
        FieldEdit shouldattitem = (FieldEdit)this.getControl("shouldattitem");
        shouldattitem.setMustInput(true);
    }

    public void compositeTimeView() {
        this.getView().setVisible(Boolean.FALSE, new String[]{""});
        this.getView().setVisible(Boolean.TRUE, new String[]{"timeaddway", "shouldattitem", "timetotalitem", "attaddtritotal", "balanceitem"});
        FieldEdit timeaddway = (FieldEdit)this.getControl("timeaddway");
        timeaddway.setMustInput(true);
        FieldEdit shouldattitem = (FieldEdit)this.getControl("shouldattitem");
        shouldattitem.setMustInput(true);
        FieldEdit timetotalitem = (FieldEdit)this.getControl("timetotalitem");
        timetotalitem.setMustInput(true);
        FieldEdit attaddtritotal = (FieldEdit)this.getControl("attaddtritotal");
        attaddtritotal.setMustInput(true);
    }

    public void unTimeView() {
        this.getView().setVisible(Boolean.FALSE, new String[]{"timeaddway", "timetotalitem", "attaddtritotal", "balanceitem", "shouldattitem"});
        FieldEdit timeaddway = (FieldEdit)this.getControl("timeaddway");
        timeaddway.setMustInput(false);
        FieldEdit timetotalitem = (FieldEdit)this.getControl("timetotalitem");
        timetotalitem.setMustInput(false);
        FieldEdit attaddtritotal = (FieldEdit)this.getControl("attaddtritotal");
        attaddtritotal.setMustInput(false);
        FieldEdit balanceitem = (FieldEdit)this.getControl("balanceitem");
        balanceitem.setMustInput(false);
        FieldEdit shouldattitem = (FieldEdit)this.getControl("shouldattitem");
        shouldattitem.setMustInput(false);
    }
}

