/*
 * Decompiled with CFR 0.152.
 */
package kd.wtc.wtp.formplugin.web.vacation;

import java.util.Date;
import java.util.EventObject;
import java.util.Map;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.ext.hr.ruleengine.controls.TargetCondition;
import kd.bos.ext.hr.ruleengine.infos.RuleValidateInfo;
import kd.bos.ext.hr.ruleengine.utils.RuleValidateUtil;
import kd.bos.form.IFormView;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.hr.hbp.common.util.HRDateTimeUtils;
import kd.hr.hbp.common.util.HRStringUtils;
import kd.hr.hbp.formplugin.web.HRDataBaseEdit;
import kd.wtc.wtbs.business.history.service.WTCHisService;
import kd.wtc.wtbs.common.util.third.util.StringUtils;
import kd.wtc.wtbs.formplugin.util.WTCFormUtils;
import kd.wtc.wtp.business.ex.helper.ExKDStringHelper;

public class VaBaseSetDataRangeEdit
extends HRDataBaseEdit {
    public void propertyChanged(PropertyChangedArgs evt) {
        String name;
        switch (name = evt.getProperty().getName()) {
            case "bsed": {
                this.updateDateRangeDate();
                break;
            }
        }
    }

    public void afterCreateNewData(EventObject e) {
        super.afterCreateNewData(e);
        Map customParams = this.getView().getFormShowParameter().getCustomParams();
        String hisAction = (String)customParams.get("his_action");
        if (HRStringUtils.isEmpty((String)hisAction) || HRStringUtils.equals((String)"open_insert_new_data_page", (String)hisAction)) {
            ((TargetCondition)this.getControl("targetconditionap")).setValue("");
            this.getModel().setValue("daterangecondition", null);
        }
    }

    private void updateDateRangeDate() {
        Date bsed = (Date)this.getModel().getValue("bsed");
        if (bsed != null) {
            ((TargetCondition)this.getView().getControl("targetconditionap")).setDate(HRDateTimeUtils.format((Date)bsed, (String)"yyyy-MM-dd"));
        } else {
            ((TargetCondition)this.getView().getControl("targetconditionap")).setDate(null);
        }
    }

    public void beforeBindData(EventObject event) {
        super.beforeBindData(event);
        String shiftConditionJson = this.getModel().getDataEntity().getString("daterangecondition");
        if (StringUtils.isNotBlank((CharSequence)shiftConditionJson)) {
            ((TargetCondition)this.getControl("targetconditionap")).setValue(shiftConditionJson);
        }
    }

    public void afterBindData(EventObject e) {
        super.afterBindData(e);
        this.lockCondition();
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        super.beforeDoOperation(args);
        if (WTCFormUtils.isSave((BeforeDoOperationEventArgs)args)) {
            String shiftConditionJson = ((TargetCondition)this.getView().getControl("targetconditionap")).getValue();
            if (shiftConditionJson != null && shiftConditionJson.contains("is_or_isSub")) {
                this.getView().showTipNotification(ExKDStringHelper.gradeError());
                args.setCancel(true);
                return;
            }
            RuleValidateInfo info = RuleValidateUtil.validCondition((String)shiftConditionJson, (boolean)false);
            if (!info.isSuccess()) {
                args.setCancel(true);
                this.getView().showTipNotification(String.join((CharSequence)",", info.getMsgList()));
                return;
            }
            this.getModel().setValue("daterangecondition", (Object)shiftConditionJson);
        }
    }

    public void afterDoOperation(AfterDoOperationEventArgs afterDoOperationEventArgs) {
        super.afterDoOperation(afterDoOperationEventArgs);
        this.lockCondition();
    }

    private void lockCondition() {
        TargetCondition condition = (TargetCondition)this.getView().getControl("targetconditionap");
        String pageState = WTCHisService.isLock((IFormView)this.getView()) ? "view" : "edit";
        condition.setPageState(pageState);
        this.getView().updateView("targetconditionap");
    }
}

