/*
 * Decompiled with CFR 0.152.
 */
package kd.wtc.wtp.formplugin.web.vacation;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import java.math.BigDecimal;
import java.util.Collections;
import java.util.Date;
import java.util.EventObject;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.metadata.clr.DataEntityPropertyCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.ext.hr.ruleengine.controls.TargetCondition;
import kd.bos.ext.hr.ruleengine.infos.RuleConditionInfo;
import kd.bos.ext.hr.ruleengine.infos.RuleValidateInfo;
import kd.bos.ext.hr.ruleengine.utils.RuleValidateUtil;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.MessageBoxOptions;
import kd.bos.form.control.Control;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.field.BasedataEdit;
import kd.bos.form.field.events.BeforeF7SelectEvent;
import kd.bos.form.field.events.BeforeF7SelectListener;
import kd.bos.form.operate.AbstractOperate;
import kd.bos.orm.query.QFilter;
import kd.hr.hbp.common.util.HRDateTimeUtils;
import kd.hr.hbp.common.util.HRStringUtils;
import kd.hr.hbp.formplugin.web.HRDynamicFormBasePlugin;
import kd.wtc.wtbs.business.web.attitem.AttItemFilterHelper;
import kd.wtc.wtbs.common.predata.wtbd.PreDataAttItem;
import kd.wtc.wtbs.common.predata.wtbd.PreDataVacationType;
import kd.wtc.wtbs.common.util.third.collect.Maps;
import kd.wtc.wtbs.common.util.third.util.StringUtils;
import kd.wtc.wtbs.wtbd.common.attitem.AttItemItemType;
import kd.wtc.wtbs.wtbd.common.attitem.AttItmeDataTypeEnum;
import kd.wtc.wtp.business.ex.helper.ExKDStringHelper;
import kd.wtc.wtp.business.ruleenging.RulePreviewUtil;

public class VaCalculateRuleEdit
extends HRDynamicFormBasePlugin
implements BeforeF7SelectListener {
    private static final Map<Long, Long> VATYPE_MAP = new HashMap<Long, Long>();
    private static final Map<Long, Long> RESULT_MAP;
    private static final Map<Long, Long> VATYPE_SHIFT_MAP;
    private static final Map<Long, Long> VATYPE_DAY_MAP;
    private static final Set<String> PROPERTY_SET;

    private static boolean showErrorNotification(IFormView view, BeforeDoOperationEventArgs args, RuleValidateInfo info) {
        if (!info.isSuccess()) {
            List msgList = info.getMsgList();
            if (args != null) {
                args.setCancel(true);
            }
            String limitScope = ResManager.loadKDString((String)"\u9650\u5b9a\u6761\u4ef6\uff1a", (String)"AttCalculrulePlugin_2", (String)"wtc-wtp-formplugin", (Object[])new Object[0]);
            view.showTipNotification(limitScope + String.join((CharSequence)",", msgList));
        }
        return info.isSuccess();
    }

    public void beforeBindData(EventObject eventObject) {
        JSONObject info;
        JSONObject jsonObject = new JSONObject(this.getView().getFormShowParameter().getCustomParams());
        if (jsonObject.containsKey((Object)"singleInfo") && (info = jsonObject.getJSONObject("singleInfo")) != null) {
            for (String key : info.keySet()) {
                Object obj = info.get((Object)key);
                if (obj == null || this.getModel().getProperty(key) == null) continue;
                this.getModel().setValue(key, obj);
            }
            String dataStatus = jsonObject.getString("datastatus");
            String isEditRow = jsonObject.getString("editrow");
            if (Objects.equals(isEditRow, "editrow") && !"-3".equals(dataStatus)) {
                this.getView().setEnable(Boolean.FALSE, new String[]{"vatype"});
            }
            TargetCondition dateRangeTargetCondition = (TargetCondition)this.getView().getControl("daterangtargetconditionap");
            dateRangeTargetCondition.setValue((String)this.getModel().getValue("daterange"));
        }
        ((BasedataEdit)this.getControl("roundruleitem")).setMustInput(this.getModel().getDataEntity().getDynamicObject("roundrule") != null);
        boolean isQuota = this.getModel().getDataEntity().getBoolean("isquota");
        ((BasedataEdit)this.getControl("deductrule")).setMustInput(isQuota);
    }

    public void afterBindData(EventObject eventObject) {
        super.afterBindData(eventObject);
        this.getTargetCondition().setValue((String)this.getModel().getValue("limitscope"));
        this.getView().updateView("targetconditionap");
        this.getPageCache().put("bar_change", Boolean.FALSE.toString());
    }

    public void registerListener(EventObject event) {
        super.registerListener(event);
        for (String sign : PROPERTY_SET) {
            ((BasedataEdit)this.getView().getControl(sign)).addBeforeF7SelectListener((BeforeF7SelectListener)this);
        }
    }

    public void beforeF7Select(BeforeF7SelectEvent event) {
        IFormView parentView;
        String key = ((Control)event.getSource()).getKey();
        if (!PROPERTY_SET.contains(key)) {
            return;
        }
        if (StringUtils.equalsAny((CharSequence)key, (CharSequence[])new CharSequence[]{"vaitem", "roundruleitem", "resultitem"})) {
            QFilter qFilter = StringUtils.equals((CharSequence)key, (CharSequence)"resultitem") ? AttItemFilterHelper.dataTypeFilter(Collections.singletonList(AttItmeDataTypeEnum.DUTATION.typeVal)).and(AttItemFilterHelper.issaveQFilter((boolean)true).and(AttItemFilterHelper.itemtypeQFilter((String[])new String[]{AttItemItemType.DETAIL_ITEM.type, AttItemItemType.DETAIL_SUM_ITEM.type})).or(AttItemFilterHelper.issaveQFilter((boolean)false))) : AttItemFilterHelper.dataTypeFilter(Collections.singletonList(AttItmeDataTypeEnum.DUTATION.typeVal)).and(AttItemFilterHelper.issaveQFilter((boolean)true)).and(AttItemFilterHelper.itemtypeQFilter((String[])new String[]{AttItemItemType.DETAIL_ITEM.type, AttItemItemType.DETAIL_SUM_ITEM.type}));
            event.addCustomQFilter(qFilter);
        }
        if ((parentView = this.getView().getViewNoPlugin(this.getView().getFormShowParameter().getParentPageId())) != null) {
            Date bsed = parentView.getModel().getDataEntity().getDate("bsed");
            QFilter filter = new QFilter("firstbsed", "<=", (Object)bsed);
            event.addCustomQFilter(filter);
        }
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs evt) {
        AbstractOperate op;
        String operateKey;
        super.beforeDoOperation(evt);
        if (evt.getSource() instanceof AbstractOperate && "save".equals(operateKey = (op = (AbstractOperate)evt.getSource()).getOperateKey())) {
            if (this.getModel().getValue("timebyshiftitem") == null) {
                this.getView().showErrorNotification(ResManager.loadKDString((String)"\u8bf7\u586b\u5199\u201c\u73ed\u6b21/\u65e5\u5386\u5929\u8f6c\u6362\u65f6\u957f\u201d\u3002", (String)"VaCalculateRuleEdit_2", (String)"wtc-wtp-formplugin", (Object[])new Object[0]));
                evt.setCancel(true);
                return;
            }
            this.validateJSON(evt);
            this.validateVaType(evt);
            if (!evt.isCancel()) {
                evt.setCancel(!this.validateDeductRule());
            }
            this.setQuotaValues();
            this.validateUnitTimes();
        }
    }

    private boolean validateDeductRule() {
        DynamicObject dataEntity = this.getModel().getDataEntity();
        if (dataEntity.getBoolean("vabasesetid.isspecialholiday") && dataEntity.getLong("deductrule.id") != 0L && dataEntity.getBoolean("isquota")) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u5b9a\u989d\u5047\u4e0d\u80fd\u4e3a\u7279\u6b8a\u5047\uff0c\u8bf7\u8c03\u6574\u3002", (String)"VaCalculateRuleEdit_1", (String)"wtc-wtp-formplugin", (Object[])new Object[0]));
            return false;
        }
        return true;
    }

    private void validateVaType(BeforeDoOperationEventArgs evt) {
        if (evt.isCancel()) {
            return;
        }
        JSONObject obj = new JSONObject(this.getView().getFormShowParameter().getCustomParams());
        JSONObject info = obj.getJSONObject("singleInfo");
        if (info != null && info.containsKey((Object)"vatypeset")) {
            JSONArray jsonArray = info.getJSONArray("vatypeset");
            if (jsonArray == null) {
                return;
            }
            DynamicObject dy = this.getModel().getDataEntity().getDynamicObject("vatype");
            if (dy == null) {
                return;
            }
            for (Object value : jsonArray) {
                if (!dy.getPkValue().equals(value)) continue;
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u5df2\u5b58\u5728\u8be5\u4f11\u5047\u7c7b\u578b\u7684\u89c4\u5219\u3002", (String)"VaCalculateRuleEdit_0", (String)"wtc-wtp-formplugin", (Object[])new Object[0]));
                evt.setCancel(true);
            }
        }
    }

    private void validateJSON(BeforeDoOperationEventArgs evt) {
        if (evt.isCancel()) {
            return;
        }
        String conditionJson = this.getTargetCondition().getValue();
        boolean isEmpty = HRStringUtils.isEmpty((String)conditionJson);
        if (!isEmpty) {
            RuleConditionInfo ruleConditionInfo = (RuleConditionInfo)SerializationUtils.fromJsonString((String)conditionJson, RuleConditionInfo.class);
            isEmpty = StringUtils.isEmpty((CharSequence)ruleConditionInfo.getConditionExpressStr());
        }
        if (!isEmpty) {
            RuleValidateInfo info = RuleValidateUtil.validCondition((String)conditionJson, (boolean)true);
            if (VaCalculateRuleEdit.showErrorNotification(this.getView(), evt, info)) {
                String conditionPreviewStr = RulePreviewUtil.getConditionPreviewStr((String)conditionJson);
                this.getModel().setValue("calculdes", (Object)conditionPreviewStr);
                this.getModel().setValue("limitscope", (Object)conditionJson);
            }
        } else {
            this.getModel().setValue("calculdes", null);
            this.getModel().setValue("limitscope", null);
        }
        String shiftConditionJson = ((TargetCondition)this.getView().getControl("daterangtargetconditionap")).getValue();
        if (shiftConditionJson != null && shiftConditionJson.contains("is_or_isSub")) {
            this.getView().showTipNotification(ExKDStringHelper.gradeError());
            evt.setCancel(true);
            return;
        }
        RuleValidateInfo info = RuleValidateUtil.validCondition((String)shiftConditionJson, (boolean)false);
        if (!info.isSuccess()) {
            evt.setCancel(true);
            this.getView().showTipNotification(String.join((CharSequence)",", info.getMsgList()));
            return;
        }
        TargetCondition targetCondition = (TargetCondition)this.getView().getControl("daterangtargetconditionap");
        String conditionJson2 = targetCondition.getValue();
        this.getModel().setValue("calculname", (Object)RulePreviewUtil.getConditionPreviewStr((String)conditionJson2));
        this.getModel().setValue("daterange", (Object)conditionJson2);
        String value = ((TargetCondition)this.getView().getControl("targetconditionap")).getValue();
        if (!HRStringUtils.isEmpty((String)value) && value.contains("is_or_isSub")) {
            this.getView().showTipNotification(ExKDStringHelper.gradeError());
            evt.setCancel(true);
        }
    }

    public void afterDoOperation(AfterDoOperationEventArgs args) {
        super.afterDoOperation(args);
        if (args.getSource() instanceof AbstractOperate && args.getOperationResult() != null && args.getOperationResult().isSuccess() && "save".equals(args.getOperateKey())) {
            HashMap<String, Object> returnData = new HashMap<String, Object>(16);
            DataEntityPropertyCollection properties = this.getModel().getDataEntityType().getProperties();
            for (IDataEntityProperty property : properties) {
                returnData.putIfAbsent(property.getName(), this.getModel().getValue(property.getName()));
                if (!StringUtils.equals((CharSequence)property.getName(), (CharSequence)"daterange")) continue;
                returnData.putIfAbsent("daterangecondition", this.getModel().getValue(property.getName()));
            }
            returnData.put("bar_change", this.getPageCache().get("bar_change"));
            FormShowParameter formShowParameter = this.getView().getFormShowParameter();
            Integer rowIndex = (Integer)formShowParameter.getCustomParam("rowIndex");
            returnData.put("rowIndex", rowIndex);
            this.getView().returnDataToParent(returnData);
            this.getView().sendFormAction(this.getView().getParentView());
            this.getView().close();
        }
    }

    public void propertyChanged(PropertyChangedArgs args) {
        String name = args.getProperty().getName();
        if (args.getChangeSet() == null || args.getChangeSet().length <= 0) {
            return;
        }
        Object newValue = args.getChangeSet()[0].getNewValue();
        this.getPageCache().put("bar_change", Boolean.TRUE.toString());
        switch (name) {
            case "vatype": {
                boolean containsKey;
                DynamicObject dy = (DynamicObject)newValue;
                Long value = 0L;
                if (dy != null) {
                    value = (Long)dy.getPkValue();
                }
                if (!(containsKey = VATYPE_MAP.containsKey(value))) break;
                this.getModel().setValue("vaitem", (Object)VATYPE_MAP.get(value));
                this.getModel().setValue("resultitem", (Object)RESULT_MAP.get(value));
                this.setShiftCalendarAttItems();
                break;
            }
            case "ruledate": {
                Date ruledate = (Date)this.getModel().getValue("ruledate");
                if (ruledate == null) break;
                this.updateCustomControlDate(ruledate);
                break;
            }
            case "roundrule": {
                boolean roundRuleIsNotNull;
                boolean bl = roundRuleIsNotNull = this.getModel().getDataEntity().getDynamicObject("roundrule") != null;
                if (!roundRuleIsNotNull) {
                    this.getModel().setValue("roundruleitem", null);
                }
                ((BasedataEdit)this.getControl("roundruleitem")).setMustInput(roundRuleIsNotNull);
                break;
            }
            case "vabasesetid": {
                this.validateDeductRule();
                this.setShiftCalendarAttItems();
                this.validateUnitTimes();
                break;
            }
            case "isquota": {
                boolean isQuota = this.getModel().getDataEntity().getBoolean("isquota");
                if (!isQuota) {
                    this.getModel().setValue("isdisposable", (Object)Boolean.FALSE);
                }
                ((BasedataEdit)this.getControl("deductrule")).setMustInput(isQuota);
                break;
            }
            case "deductrule": {
                if (newValue != null) break;
                this.getModel().getDataEntity().set("isnonquotaapply", (Object)true);
                break;
            }
            case "timebyshiftitem": {
                this.getModel().getDataEntity().set("timebydayitem", newValue);
                break;
            }
        }
    }

    private void validateUnitTimes() {
        DynamicObject vaBaseSet = this.getModel().getDataEntity().getDynamicObject("vabasesetid");
        DynamicObject deductRule = this.getModel().getDataEntity().getDynamicObject("deductrule");
        if (vaBaseSet == null || !vaBaseSet.getBoolean("isapplyspan")) {
            return;
        }
        if (deductRule == null || deductRule.getBigDecimal("lowerlimit") == null || BigDecimal.ZERO.compareTo(deductRule.getBigDecimal("lowerlimit")) == 0) {
            return;
        }
        this.getView().showConfirm(ResManager.loadKDString((String)"\u4f11\u5047\u57fa\u7840\u914d\u7f6e\u548c\u5b9a\u989d\u6263\u51cf\u89c4\u5219\u90fd\u8bbe\u7f6e\u4e86\u5355\u4f4d\u65f6\u957f\uff0c\u7cfb\u7edf\u5c06\u6309\u5b9a\u989d\u6263\u51cf\u89c4\u5219\u7684\u5355\u4f4d\u65f6\u957f\u8fdb\u884c\u6821\u9a8c\u3002", (String)"VaCalculateRuleEdit_4", (String)"wtc-wtp-formplugin", (Object[])new Object[0]), MessageBoxOptions.OK);
    }

    private void updateCustomControlDate(Date ruleDate) {
        this.getTargetCondition().setDate(HRDateTimeUtils.format((Date)ruleDate, (String)"yyyy-MM-dd"));
        this.getModel().setValue("ruledate", null);
    }

    private TargetCondition getTargetCondition() {
        return (TargetCondition)this.getView().getControl("targetconditionap");
    }

    private void setShiftCalendarAttItems() {
        this.getModel().beginInit();
        DynamicObject vaBaseSet = this.getModel().getDataEntity().getDynamicObject("vabasesetid");
        if (vaBaseSet != null) {
            String timeCalcType = vaBaseSet.getString("timecalctype");
            boolean byShift = "A".equals(timeCalcType);
            boolean byCalendar = "B".equals(timeCalcType);
            long vaTypeId = this.getModel().getDataEntity().getLong("vatype.id");
            Long typeAId = null;
            if (byShift) {
                typeAId = VATYPE_SHIFT_MAP.get(vaTypeId);
            } else if (byCalendar) {
                typeAId = VATYPE_DAY_MAP.get(vaTypeId);
            }
            this.getModel().setValue("timebyshiftitem", (Object)typeAId);
            this.getModel().setValue("timebydayitem", (Object)typeAId);
        }
        this.getModel().endInit();
        this.getView().updateView("timebyshiftitem");
    }

    private void setQuotaValues() {
        DynamicObject dataEntity = this.getModel().getDataEntity();
        boolean isQuota = dataEntity.getBoolean("isquota");
        long deductRuleId = dataEntity.getLong("deductrule.id");
        if (!isQuota) {
            if (deductRuleId == 0L) {
                this.getModel().setValue("issplit", (Object)Boolean.FALSE);
            }
            this.getModel().setValue("isdisposable", (Object)Boolean.FALSE);
        } else {
            this.getModel().setValue("isnonquotaapply", (Object)Boolean.FALSE);
        }
    }

    static {
        VATYPE_MAP.put(PreDataVacationType.PD_1010_S, PreDataAttItem.PD_LE_1010_S);
        VATYPE_MAP.put(PreDataVacationType.PD_1020_S, PreDataAttItem.PD_LE_1030_S);
        VATYPE_MAP.put(PreDataVacationType.PD_1030_S, PreDataAttItem.PD_LE_1020_S);
        VATYPE_MAP.put(PreDataVacationType.PD_1040_S, PreDataAttItem.PD_LE_1040_S);
        VATYPE_MAP.put(PreDataVacationType.PD_1050_S, PreDataAttItem.PD_LE_1050_S);
        VATYPE_MAP.put(PreDataVacationType.PD_1060_S, PreDataAttItem.PD_LE_1070_S);
        VATYPE_MAP.put(PreDataVacationType.PD_1070_S, PreDataAttItem.PD_LE_1060_S);
        VATYPE_MAP.put(PreDataVacationType.PD_1080_S, PreDataAttItem.PD_LE_1080_S);
        VATYPE_MAP.put(PreDataVacationType.PD_1090_S, PreDataAttItem.PD_LE_1250_S);
        RESULT_MAP = new HashMap<Long, Long>();
        RESULT_MAP.put(PreDataVacationType.PD_1010_S, PreDataAttItem.PD_LE_1170_S);
        RESULT_MAP.put(PreDataVacationType.PD_1020_S, PreDataAttItem.PD_LE_1190_S);
        RESULT_MAP.put(PreDataVacationType.PD_1030_S, PreDataAttItem.PD_LE_1180_S);
        RESULT_MAP.put(PreDataVacationType.PD_1040_S, PreDataAttItem.PD_LE_1200_S);
        RESULT_MAP.put(PreDataVacationType.PD_1050_S, PreDataAttItem.PD_LE_1210_S);
        RESULT_MAP.put(PreDataVacationType.PD_1060_S, PreDataAttItem.PD_LE_1230_S);
        RESULT_MAP.put(PreDataVacationType.PD_1070_S, PreDataAttItem.PD_LE_1220_S);
        RESULT_MAP.put(PreDataVacationType.PD_1080_S, PreDataAttItem.PD_LE_1240_S);
        RESULT_MAP.put(PreDataVacationType.PD_1090_S, PreDataAttItem.PD_LE_1270_S);
        VATYPE_SHIFT_MAP = Maps.newHashMap();
        VATYPE_SHIFT_MAP.put(PreDataVacationType.PD_1010_S, PreDataAttItem.PD_LE_1280_S);
        VATYPE_SHIFT_MAP.put(PreDataVacationType.PD_1020_S, PreDataAttItem.PD_LE_1300_S);
        VATYPE_SHIFT_MAP.put(PreDataVacationType.PD_1030_S, PreDataAttItem.PD_LE_1290_S);
        VATYPE_SHIFT_MAP.put(PreDataVacationType.PD_1040_S, PreDataAttItem.PD_LE_1310_S);
        VATYPE_SHIFT_MAP.put(PreDataVacationType.PD_1090_S, PreDataAttItem.PD_LE_1360_S);
        VATYPE_DAY_MAP = Maps.newHashMap();
        VATYPE_DAY_MAP.put(PreDataVacationType.PD_1050_S, PreDataAttItem.PD_LE_1320_S);
        VATYPE_DAY_MAP.put(PreDataVacationType.PD_1060_S, PreDataAttItem.PD_LE_1340_S);
        VATYPE_DAY_MAP.put(PreDataVacationType.PD_1070_S, PreDataAttItem.PD_LE_1330_S);
        VATYPE_DAY_MAP.put(PreDataVacationType.PD_1080_S, PreDataAttItem.PD_LE_1350_S);
        PROPERTY_SET = new HashSet<String>(16);
        PROPERTY_SET.add("vabasesetid");
        PROPERTY_SET.add("vachangesetid");
        PROPERTY_SET.add("vaitem");
        PROPERTY_SET.add("roundruleitem");
        PROPERTY_SET.add("resultitem");
        PROPERTY_SET.add("deductrule");
    }
}

