/*
 * Decompiled with CFR 0.152.
 */
package kd.wtc.wtp.formplugin.web.vacation;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.EventObject;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import kd.bos.dataentity.entity.DataEntityState;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.metadata.clr.DataEntityPropertyCollection;
import kd.bos.entity.ValueMapItem;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.datamodel.ListSelectedRowCollection;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.entity.property.ComboProp;
import kd.bos.form.CloseCallBack;
import kd.bos.form.FormShowParameter;
import kd.bos.form.control.EntryGrid;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.BeforeClosedEvent;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.field.BasedataEdit;
import kd.bos.form.field.ComboEdit;
import kd.bos.form.field.ComboItem;
import kd.bos.form.field.FieldEdit;
import kd.bos.form.field.MulComboEdit;
import kd.bos.form.field.events.BeforeF7SelectEvent;
import kd.bos.form.field.events.BeforeF7SelectListener;
import kd.bos.form.operate.FormOperate;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.list.ListShowParameter;
import kd.bos.orm.query.QFilter;
import kd.bos.util.CollectionUtils;
import kd.hr.hbp.business.servicehelper.HRBaseServiceHelper;
import kd.hr.hbp.common.util.HRStringUtils;
import kd.hr.hbp.formplugin.web.HRDataBaseEdit;
import kd.wtc.wtbs.business.history.service.WTCHisService;
import kd.wtc.wtbs.common.enums.bill.BaseSetUnitTypeEnum;
import kd.wtc.wtbs.common.enums.bill.va.SpecialVaTypeEnum;
import kd.wtc.wtbs.common.util.WTCCollections;
import kd.wtc.wtbs.common.util.WTCStringUtils;
import kd.wtc.wtbs.common.util.third.collect.Lists;
import kd.wtc.wtbs.common.util.third.collect.Sets;
import kd.wtc.wtbs.common.util.third.util.ArrayUtils;
import kd.wtc.wtbs.common.util.third.util.StringUtils;
import kd.wtc.wtp.business.vacation.VaBaseSetService;
import kd.wtc.wtp.formplugin.web.vacation.common.VaBaseSetConstants;

public class VacationBaseSetPlugin
extends HRDataBaseEdit
implements BeforeF7SelectListener {
    private static final String IS_HEAD = "isahead";
    private static final String IS_REPAIR = "isrepair";
    private static final String AHEAD_PERIOD = "aheadperiod";
    private static final String EXCESSVAL_REAL = "excessval_real";
    private static final String EXCESSVAL = "excessval";
    private static final String MAX_AHEAD_TIME = "maxaheadtime";
    private static final String MAX_AHEAD_TIME_REAL = "maxaheadtime_real";
    private static final String AHEADMAXVALFIELD = "aheadmaxvalfield";
    private static final String REPAIR_PERIOD = "repairperiod";
    private static final String MAX_REPAIR_TIME = "maxrepairtime";
    private static final String MAX_REPAIR_TIME_REAL = "maxrepairtime_real";
    private static final String FIELD_OVERLAPVATYPE = "overlapvatype";
    private static final String NEWTYPEENTRY = "newtypeentry";

    private static boolean validateSave(String type) {
        return "bar_saveandnew".equals(type) || "bar_save".equals(type) || "bar_submit".equals(type) || "bar_submitandaudit".equals(type) || "confirmchange".equals(type) || "bar_audit".equals(type) || "save".equals(type) || "submit".equals(type) || "submitandaudit".equals(type);
    }

    public void registerListener(EventObject eventObject) {
        super.registerListener(eventObject);
        ((BasedataEdit)this.getView().getControl(FIELD_OVERLAPVATYPE)).addBeforeF7SelectListener((BeforeF7SelectListener)this);
        ((BasedataEdit)this.getView().getControl("vacationtype")).addBeforeF7SelectListener((BeforeF7SelectListener)this);
    }

    public void afterBindData(EventObject eventObject) {
        Object pkId;
        DynamicObject dy;
        MulComboEdit control = (MulComboEdit)this.getView().getControl("personinfo");
        ArrayList items = Lists.newArrayListWithCapacity((int)10);
        VaBaseSetService vaBaseSetService = new VaBaseSetService();
        Map tuples = vaBaseSetService.parseVaSceneRule();
        for (Map.Entry tuple : tuples.entrySet()) {
            ComboItem item = new ComboItem((LocaleString)tuple.getValue(), (String)tuple.getKey());
            items.add(item);
        }
        control.setComboItems((List)items);
        int excessVal = this.getModel().getDataEntity().getInt(EXCESSVAL_REAL);
        if (excessVal != 0) {
            this.getModel().setValue(EXCESSVAL, this.getModel().getValue(EXCESSVAL_REAL));
        }
        this.getModel().setValue(MAX_AHEAD_TIME, this.getModel().getValue(MAX_AHEAD_TIME_REAL));
        this.getModel().beginInit();
        int maxRepair = this.getModel().getDataEntity().getInt(MAX_REPAIR_TIME_REAL);
        this.getModel().setValue(MAX_REPAIR_TIME, (Object)maxRepair);
        this.getModel().endInit();
        this.getView().updateView(MAX_REPAIR_TIME);
        if (this.getModel().getDataEntity().getBoolean("isaheadmax")) {
            this.getModel().setValue(AHEADMAXVALFIELD, this.getModel().getValue("aheadmaxval"));
        }
        this.toControlField(this.isTrue(IS_HEAD), AHEAD_PERIOD, MAX_AHEAD_TIME_REAL);
        this.toControlField(this.isTrue("isaheadmax"), "aheadmaxunit", AHEADMAXVALFIELD);
        this.toControlField(this.isTrue(IS_REPAIR), REPAIR_PERIOD, MAX_REPAIR_TIME);
        this.toControlField(this.isEnumTrue("enclosurelimit"), EXCESSVAL);
        this.toControlField(this.isTrue("isspecialholiday"), "specialdaytype", "breastdaytype", "breasttime", "offtimeperday");
        Object oldValue = this.getModel().getValue("timecalctype");
        this.getModel().setValue("timecalctype", null);
        this.getModel().setValue("timecalctype", oldValue);
        FormShowParameter params = this.getView().getFormShowParameter();
        String hisAction = WTCHisService.getHisAction((FormShowParameter)params);
        if (StringUtils.equalsAny((CharSequence)hisAction, (CharSequence[])new CharSequence[]{"open_insert_new_data_page", "open_insert_data_page", "open_edit_data_page", "open_copy_his_data_page", "open_data_page", "revise"}) && (dy = new HRBaseServiceHelper("wtp_vabaseset").loadSingle(pkId = Optional.ofNullable(params.getCustomParam("boid")).orElseGet(() -> params.getCustomParam("currentDataId")))).getBoolean("isspecialholiday")) {
            this.getView().setEnable(Boolean.FALSE, new String[]{"isspecialholiday"});
            if ("open_insert_new_data_page".equals(hisAction)) {
                this.getModel().setValue("unit", dy.get("unit"));
                this.getModel().setValue("isspecialholiday", dy.get("isspecialholiday"));
            }
        }
        if (StringUtils.isBlank((CharSequence)((CharSequence)this.getModel().getValue("specialdaytype")))) {
            this.getModel().setValue("specialdaytype", (Object)"A");
        }
        if (BigDecimal.valueOf(kd.wtc.wtbs.wtabm.common.constants.VaBaseSetConstants.BREASTTIME_MIN.intValue()).compareTo((BigDecimal)this.getModel().getValue("breasttime")) > 0) {
            this.getModel().setValue("breasttime", (Object)kd.wtc.wtbs.wtabm.common.constants.VaBaseSetConstants.BREASTTIME_MIN);
        }
        this.getModel().setDataChanged(false);
    }

    private boolean isEnumTrue(String fieldKey) {
        return HRStringUtils.equals((String)this.getModel().getDataEntity().getString(fieldKey), (String)"condition");
    }

    private void toControlField(boolean flag, String ... controlKeys) {
        for (String controlKey : controlKeys) {
            FieldEdit control = (FieldEdit)this.getControl(controlKey);
            if (control == null) continue;
            control.setMustInput(flag);
        }
    }

    private boolean isTrue(String fieldKey) {
        return Boolean.TRUE.equals(this.getModel().getValue(fieldKey));
    }

    public void beforeBindData(EventObject e) {
        super.beforeBindData(e);
        this.initApplySpanComboEdit();
    }

    public void propertyChanged(PropertyChangedArgs args) {
        super.propertyChanged(args);
        String evtKey = args.getProperty().getName();
        if (args.getChangeSet() == null || args.getChangeSet().length <= 0) {
            return;
        }
        switch (evtKey) {
            case "isahead": {
                this.toControlField(this.isTrue(IS_HEAD), AHEAD_PERIOD, MAX_AHEAD_TIME);
                this.getModel().setValue(MAX_AHEAD_TIME, null);
                this.getModel().setValue(MAX_AHEAD_TIME_REAL, (Object)0);
                this.getModel().setValue(AHEAD_PERIOD, null);
                break;
            }
            case "isaheadmax": {
                this.toControlField(this.isTrue("isaheadmax"), AHEADMAXVALFIELD, "aheadmaxunit");
                this.getModel().setValue("aheadmaxunit", null);
                this.getModel().setValue(AHEADMAXVALFIELD, null);
                break;
            }
            case "isrepair": {
                this.toControlField(this.isTrue(IS_REPAIR), REPAIR_PERIOD, MAX_REPAIR_TIME);
                this.getModel().setValue(MAX_REPAIR_TIME, null);
                this.getModel().setValue(MAX_REPAIR_TIME_REAL, (Object)0);
                this.getModel().setValue(REPAIR_PERIOD, null);
                break;
            }
            case "enclosurelimit": {
                this.toControlField(this.isEnumTrue("enclosurelimit"), EXCESSVAL);
                break;
            }
            case "excessval": {
                this.getModel().setValue(EXCESSVAL_REAL, args.getChangeSet()[0].getNewValue());
                break;
            }
            case "maxaheadtime": 
            case "aheadperiod": {
                this.updateval(MAX_AHEAD_TIME, AHEAD_PERIOD, IS_HEAD);
                break;
            }
            case "aheadmaxvalfield": 
            case "aheadmaxunit": {
                this.updateval(AHEADMAXVALFIELD, "aheadmaxunit", "isaheadmax");
                break;
            }
            case "maxrepairtime": 
            case "repairperiod": {
                this.updateval(MAX_REPAIR_TIME, REPAIR_PERIOD, IS_REPAIR);
                break;
            }
            case "isspecialholiday": {
                boolean isSpecialHoliday = this.isTrue("isspecialholiday");
                if (isSpecialHoliday && !"B".equals(this.getModel().getValue("unit"))) {
                    this.getModel().setValue("isspecialholiday", (Object)Boolean.FALSE);
                    this.getView().showTipNotification(VaBaseSetConstants.RES6.loadKDString());
                    return;
                }
                this.toControlField(isSpecialHoliday, "specialdaytype", "breastdaytype", "breasttime", "offtimeperday");
                DynamicObjectCollection entity = this.getModel().getEntryEntity("wtp_vabasesetbreast");
                if (isSpecialHoliday) {
                    this.getModel().setValue("isapplyspan", (Object)false);
                    if (entity.isEmpty()) {
                        this.getModel().batchCreateNewEntryRow("wtp_vabasesetbreast", 3);
                        entity = this.getModel().getEntryEntity("wtp_vabasesetbreast");
                        IntStream.range(0, entity.size()).forEach(i -> this.getModel().setValue("offtimeperday", (Object)(i + 1), i));
                    }
                    IntStream.range(0, entity.size()).forEach(i -> this.getModel().setValue("babynum", (Object)(i + 1), i));
                    break;
                }
                this.getModel().deleteEntryData("wtp_vabasesetbreast");
                break;
            }
            case "timecalctype": {
                String timeCalcType = this.getModel().getDataEntity().getString("timecalctype");
                if (timeCalcType == null) {
                    return;
                }
                this.getModel().beginInit();
                HashSet searchStrings = "A".equals(timeCalcType) ? Sets.newHashSet((Object[])new String[]{"A", "B"}) : Sets.newHashSet((Object[])new String[]{"C"});
                ComboEdit halfDayType = (ComboEdit)this.getControl("halfdaytype");
                List comboItems = ((ComboProp)halfDayType.getProperty()).getComboItems().stream().filter(item -> searchStrings.contains(item.getValue())).map(item -> new ComboItem(item.getName(), item.getValue())).collect(Collectors.toList());
                halfDayType.setComboItems(comboItems);
                String halfDayTypeVal = (String)this.getModel().getValue("halfdaytype");
                if ("A".equals(timeCalcType) && !searchStrings.contains(halfDayTypeVal)) {
                    this.getModel().setValue("halfdaytype", (Object)"A");
                } else if ("B".equals(timeCalcType) && !searchStrings.contains(halfDayTypeVal)) {
                    this.getModel().setValue("halfdaytype", (Object)"C");
                }
                this.getModel().endInit();
                this.getView().updateView("halfdaytype");
                break;
            }
            case "unit": {
                this.getModel().setValue("applyspan", null);
                this.initApplySpanComboEdit();
                break;
            }
        }
    }

    private void initApplySpanComboEdit() {
        String unit = this.getModel().getDataEntity().getString("unit");
        ComboEdit applySpan = (ComboEdit)this.getControl("applyspan");
        if ("A".equals(unit)) {
            ComboEdit applySpanItems = (ComboEdit)this.getControl("applyspanday");
            ComboProp comboProp = (ComboProp)applySpanItems.getProperty();
            applySpan.setComboItems(this.parseMapToComboItem(comboProp.getComboItems()));
        } else if ("B".equals(unit)) {
            ComboEdit applySpanItems = (ComboEdit)this.getControl("applyspanhour");
            ComboProp comboProp = (ComboProp)applySpanItems.getProperty();
            applySpan.setComboItems(this.parseMapToComboItem(comboProp.getComboItems()));
        }
    }

    private List<ComboItem> parseMapToComboItem(List<ValueMapItem> valueMapItems) {
        if (CollectionUtils.isEmpty(valueMapItems)) {
            return Collections.emptyList();
        }
        ArrayList<ComboItem> propertyItems = new ArrayList<ComboItem>(valueMapItems.size());
        for (ValueMapItem valueMapItem : valueMapItems) {
            ComboItem comboItem = new ComboItem();
            comboItem.setValue(valueMapItem.getValue());
            comboItem.setCaption(valueMapItem.getName());
            propertyItems.add(comboItem);
        }
        return propertyItems;
    }

    private void updateval(String timeValKey, String periodKey, String switchKey) {
        DynamicObject dynamicObject = this.getModel().getDataEntity();
        boolean switchOn = dynamicObject.getBoolean(switchKey);
        String repairPeriod = this.getModel().getDataEntity().getString(periodKey);
        if (switchOn && WTCStringUtils.isNotEmpty((String)repairPeriod)) {
            boolean isAttPeriod = BaseSetUnitTypeEnum.PERIOD.getCode().equals(repairPeriod);
            BigDecimal maxRepairTime = this.getModel().getDataEntity().getBigDecimal(timeValKey);
            if (maxRepairTime != null && maxRepairTime.intValue() == 0 && !isAttPeriod) {
                this.getView().showTipNotification(VaBaseSetConstants.RES7.loadKDString());
                if (StringUtils.equals((CharSequence)MAX_REPAIR_TIME, (CharSequence)timeValKey)) {
                    this.getModel().setValue(MAX_REPAIR_TIME_REAL, (Object)0);
                }
                if (StringUtils.equals((CharSequence)MAX_AHEAD_TIME, (CharSequence)timeValKey)) {
                    this.getModel().setValue(MAX_AHEAD_TIME_REAL, (Object)0);
                }
                this.getModel().setValue(timeValKey, null);
            } else if (maxRepairTime != null) {
                if (StringUtils.equals((CharSequence)MAX_REPAIR_TIME, (CharSequence)timeValKey)) {
                    this.getModel().setValue(MAX_REPAIR_TIME_REAL, (Object)maxRepairTime.intValue());
                }
                if (StringUtils.equals((CharSequence)MAX_AHEAD_TIME, (CharSequence)timeValKey)) {
                    this.getModel().setValue(MAX_AHEAD_TIME_REAL, (Object)maxRepairTime.intValue());
                }
            }
        }
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        super.beforeDoOperation(args);
        String operateKey = ((FormOperate)args.getSource()).getOperateKey();
        if (VacationBaseSetPlugin.validateSave(operateKey)) {
            DynamicObject dynamicObject = this.getModel().getDataEntity(true);
            boolean isAhead = dynamicObject.getBoolean(IS_HEAD);
            boolean isRepair = dynamicObject.getBoolean(IS_REPAIR);
            String aheadPeriod = dynamicObject.getString(AHEAD_PERIOD);
            int maxAheadTime = dynamicObject.getInt(MAX_AHEAD_TIME_REAL);
            String maxAheadPeriod = dynamicObject.getString(AHEAD_PERIOD);
            String repairPeriod = dynamicObject.getString(REPAIR_PERIOD);
            int maxRepairTime = dynamicObject.getInt(MAX_REPAIR_TIME_REAL);
            boolean isAttPeriod = BaseSetUnitTypeEnum.PERIOD.getCode().equals(repairPeriod);
            boolean isAheadMax = dynamicObject.getBoolean("isaheadmax");
            Object aheadMaxValueFieldObj = dynamicObject.get(AHEADMAXVALFIELD);
            if (isAheadMax && aheadMaxValueFieldObj != null) {
                int aheadMaxValField = dynamicObject.getInt(AHEADMAXVALFIELD);
                dynamicObject.set("aheadmaxval", (Object)aheadMaxValField);
            }
            if (isAhead && HRStringUtils.isEmpty((String)aheadPeriod)) {
                this.getView().showTipNotification(VaBaseSetConstants.RES0.loadKDString());
                args.setCancel(true);
                return;
            }
            if (isAhead && maxAheadTime == 0 && !StringUtils.equals((CharSequence)maxAheadPeriod, (CharSequence)BaseSetUnitTypeEnum.PERIOD.getCode())) {
                this.getView().showTipNotification(VaBaseSetConstants.RES1.loadKDString());
                args.setCancel(true);
                return;
            }
            if (isRepair && HRStringUtils.isEmpty((String)repairPeriod)) {
                this.getView().showTipNotification(VaBaseSetConstants.RES2.loadKDString());
                args.setCancel(true);
                return;
            }
            if (isRepair && maxRepairTime == 0 && !isAttPeriod) {
                this.getView().showTipNotification(VaBaseSetConstants.RES3.loadKDString());
                args.setCancel(true);
                return;
            }
            if (this.isTrue("isspecialholiday") && !"B".equals(this.getModel().getValue("unit"))) {
                this.getView().showTipNotification(VaBaseSetConstants.RES6.loadKDString());
                args.setCancel(true);
                return;
            }
            boolean isSpecialHoliday = dynamicObject.getBoolean("isspecialholiday");
            String specialVaType = dynamicObject.getString("specialdaytype");
            if (isSpecialHoliday && SpecialVaTypeEnum.LACTATION_TYPE.vaType.equals(specialVaType)) {
                boolean isAllowOverlap = dynamicObject.getBoolean("isallowoverlap");
                DynamicObjectCollection vaTypeEntries = dynamicObject.getDynamicObjectCollection("vatypeentry");
                if (isAllowOverlap && WTCCollections.isEmpty((Collection)vaTypeEntries)) {
                    this.getView().showTipNotification(VaBaseSetConstants.RES8.loadKDString());
                    args.setCancel(true);
                    return;
                }
            }
        }
        switch (operateKey) {
            case "newentry": {
                int size = this.getModel().getEntryEntity("wtp_vabasesetbreast").size();
                if (size < 10) break;
                this.getView().showTipNotification(VaBaseSetConstants.RES5.loadKDString());
                args.setCancel(true);
                return;
            }
            case "deleteentry": {
                int[] selectRows = ((EntryGrid)this.getView().getControl("wtp_vabasesetbreast")).getSelectRows();
                if (ArrayUtils.isEmpty((int[])selectRows)) {
                    return;
                }
                int size2 = this.getModel().getEntryEntity("wtp_vabasesetbreast").size();
                if (selectRows.length <= 1 && selectRows[0] == size2 - 1) break;
                this.getView().showTipNotification(VaBaseSetConstants.RES4.loadKDString());
                args.setCancel(true);
                break;
            }
            case "newtypeentry": {
                BasedataEdit control = (BasedataEdit)this.getView().getControl(FIELD_OVERLAPVATYPE);
                control.click();
                break;
            }
        }
    }

    public void afterDoOperation(AfterDoOperationEventArgs afterDoOperationEventArgs) {
        OperationResult operationResult;
        super.afterDoOperation(afterDoOperationEventArgs);
        if ("newentry".equals(afterDoOperationEventArgs.getOperateKey())) {
            int size = this.getModel().getEntryEntity("wtp_vabasesetbreast").size();
            this.getModel().setValue("babynum", (Object)size, size - 1);
            this.getModel().setValue("offtimeperday", (Object)size, size - 1);
        }
        if (StringUtils.equalsAny((CharSequence)afterDoOperationEventArgs.getOperateKey(), (CharSequence[])new CharSequence[]{"submit", "unsubmit"})) {
            this.getView().updateView();
        }
        if (VacationBaseSetPlugin.validateSave(afterDoOperationEventArgs.getOperateKey()) && (operationResult = afterDoOperationEventArgs.getOperationResult()) != null && operationResult.isSuccess()) {
            boolean isSpecialHoliday = (Boolean)this.getModel().getValue("isspecialholiday");
            String specialVaType = (String)this.getModel().getValue("specialdaytype");
            boolean isAllowOverlap = (Boolean)this.getModel().getValue("isallowoverlap");
            if (!(isSpecialHoliday && SpecialVaTypeEnum.LACTATION_TYPE.vaType.equals(specialVaType) && isAllowOverlap)) {
                this.getView().updateView("vatypeentry");
                this.getView().updateView("isallowoverlap");
            }
        }
    }

    public void beforeClosed(BeforeClosedEvent beforeClosedEvent) {
        super.beforeClosed(beforeClosedEvent);
        DataEntityPropertyCollection properties = this.getModel().getDataEntity().getDataEntityType().getProperties();
        DataEntityState dataEntityState = this.getModel().getDataEntity().getDataEntityState();
        for (int i = 0; i < properties.size(); ++i) {
            IDataEntityProperty property = (IDataEntityProperty)properties.get(i);
            if (!EXCESSVAL_REAL.equals(property.getName()) && !MAX_AHEAD_TIME_REAL.equals(property.getName()) && !MAX_REPAIR_TIME_REAL.equals(property.getName())) continue;
            dataEntityState.setBizChanged(i, false);
        }
    }

    public void beforeF7Select(BeforeF7SelectEvent beforeF7SelectEvent) {
        String sourceKey = ((BasedataEdit)beforeF7SelectEvent.getSource()).getKey();
        ListShowParameter formShowParameter = (ListShowParameter)beforeF7SelectEvent.getFormShowParameter();
        DynamicObjectCollection typeEntryEntity = this.getModel().getEntryEntity("vatypeentry");
        List<Long> entryVaTypeIds = typeEntryEntity.stream().map(entryDy -> entryDy.getLong("vacationtype.id")).collect(Collectors.toList());
        if (WTCStringUtils.equals((String)sourceKey, (String)FIELD_OVERLAPVATYPE)) {
            formShowParameter.setCloseCallBack(new CloseCallBack((IFormPlugin)this, sourceKey));
            formShowParameter.setMultiSelect(true);
            formShowParameter.setSelectedRows((Object[])entryVaTypeIds.toArray(new Long[0]));
        } else if (WTCStringUtils.equals((String)sourceKey, (String)"vacationtype")) {
            formShowParameter.setMultiSelect(false);
            beforeF7SelectEvent.addCustomQFilter(new QFilter("id", "not in", entryVaTypeIds));
        }
    }

    public void closedCallBack(ClosedCallBackEvent closedCallBackEvent) {
        ListSelectedRowCollection returnData;
        super.closedCallBack(closedCallBackEvent);
        String actionId = closedCallBackEvent.getActionId();
        if (WTCStringUtils.equals((String)actionId, (String)FIELD_OVERLAPVATYPE) && WTCCollections.isNotEmpty((Collection)(returnData = (ListSelectedRowCollection)closedCallBackEvent.getReturnData()))) {
            this.setSelectedRows(returnData);
        }
    }

    private void setSelectedRows(ListSelectedRowCollection selectedRows) {
        IDataModel model = this.getView().getModel();
        model.beginInit();
        DynamicObjectCollection entity = model.getEntryEntity("vatypeentry");
        if (entity.size() > selectedRows.size()) {
            model.deleteEntryRows("vatypeentry", IntStream.range(selectedRows.size(), entity.size()).toArray());
        } else if (entity.size() < selectedRows.size()) {
            model.batchCreateNewEntryRow("vatypeentry", selectedRows.size() - entity.size());
        }
        for (int i = 0; i < selectedRows.size(); ++i) {
            model.setValue("vacationtype", selectedRows.get(i).getPrimaryKeyValue(), i);
        }
        model.endInit();
        this.getView().updateView("vatypeentry");
    }
}

