/*
 * Decompiled with CFR 0.152.
 */
package kd.wtc.wtp.formplugin.web.vacation;

import java.util.ArrayList;
import java.util.EventObject;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.entity.operate.SaveAndNew;
import kd.bos.entity.property.BasedataProp;
import kd.bos.form.CloseCallBack;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.ShowType;
import kd.bos.form.StyleCss;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.field.BasedataEdit;
import kd.bos.form.field.FieldEdit;
import kd.bos.form.field.events.BeforeF7SelectEvent;
import kd.bos.form.field.events.BeforeF7SelectListener;
import kd.bos.form.operate.AbstractOperate;
import kd.bos.form.operate.FormOperate;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.list.ListShowParameter;
import kd.bos.orm.query.QFilter;
import kd.hr.hbp.formplugin.web.HRDataBaseEdit;
import kd.wtc.wtbs.formplugin.util.WTCFormUtils;

public class VacationChangeSetPlugin
extends HRDataBaseEdit
implements BeforeF7SelectListener {
    private static final String VOTYPENUMBER = "votypenumber";

    public void registerListener(EventObject evt) {
        super.registerListener(evt);
        BasedataEdit fieldEdit = (BasedataEdit)this.getView().getControl(VOTYPENUMBER);
        fieldEdit.addBeforeF7SelectListener((BeforeF7SelectListener)this);
    }

    public void beforeBindData(EventObject eventObject) {
        this.toControlField("iscloudchangeval", "changeval");
    }

    public void propertyChanged(PropertyChangedArgs args) {
        super.propertyChanged(args);
        String evtKey = args.getProperty().getName();
        if ("iscloudchangeval".equals(evtKey)) {
            this.toControlField("iscloudchangeval", "changeval");
        } else if ("iscloudchangetype".equals(evtKey)) {
            this.toSetBillValue("iscloudchangetype");
        }
    }

    private void toControlField(String byKey, String controlKey) {
        FieldEdit control = (FieldEdit)this.getControl(controlKey);
        if (control != null) {
            control.setMustInput(this.isTrue(byKey));
        }
    }

    private void toSetBillValue(String isCloudChangeType) {
        if (!this.isTrue(isCloudChangeType)) {
            this.getModel().deleteEntryData("entryentity");
        } else {
            DynamicObjectCollection entryEntity = this.getModel().getEntryEntity("entryentity");
            if (entryEntity.size() == 0) {
                this.getModel().createNewEntryRow("entryentity");
            }
        }
    }

    private boolean isTrue(String fieldKey) {
        return Boolean.TRUE.equals(this.getModel().getValue(fieldKey));
    }

    public void beforeF7Select(BeforeF7SelectEvent beforeF7SelectEvent) {
        DynamicObjectCollection entryEntity = this.getModel().getEntryEntity("entryentity");
        if (entryEntity == null || entryEntity.size() == 0) {
            return;
        }
        ArrayList<Long> courseIdList = new ArrayList<Long>();
        for (DynamicObject dynamicObject : entryEntity) {
            if (dynamicObject.getDynamicObject(VOTYPENUMBER) == null) continue;
            long masterId = dynamicObject.getLong("VOTYPENUMBER.masterid");
            courseIdList.add(masterId);
        }
        QFilter filter = new QFilter("masterid", "not in", courseIdList);
        ListShowParameter showParameter = (ListShowParameter)beforeF7SelectEvent.getFormShowParameter();
        showParameter.getListFilterParameter().setFilter(filter);
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        super.beforeDoOperation(args);
        String key = ((FormOperate)args.getSource()).getOperateKey();
        if ("confirmchange".equals(key) && !this.isTrue("iscloudchangetype")) {
            this.getModel().deleteEntryData("entryentity");
        }
        this.addEntryRow(args);
    }

    public void afterDoOperation(AfterDoOperationEventArgs afterDoOperationEventArgs) {
        super.afterDoOperation(afterDoOperationEventArgs);
        if (afterDoOperationEventArgs.getOperationResult() != null && !afterDoOperationEventArgs.getOperationResult().isSuccess()) {
            return;
        }
        Object source = afterDoOperationEventArgs.getSource();
        if (source instanceof SaveAndNew) {
            this.getModel().setValue("iscloudchangetype", (Object)Boolean.FALSE);
            this.toSetBillValue("iscloudchangetype");
            this.getModel().setDataChanged(false);
        }
    }

    public void closedCallBack(ClosedCallBackEvent event) {
        super.closedCallBack(event);
        WTCFormUtils.addEntryClosedCallBack((IFormView)this.getView(), (String)VOTYPENUMBER, (ClosedCallBackEvent)event);
    }

    private void addEntryRow(BeforeDoOperationEventArgs args) {
        if ("addentry".equals(((AbstractOperate)args.getSource()).getOperateKey())) {
            IFormView view = this.getView();
            BasedataEdit edit = (BasedataEdit)view.getControl(VOTYPENUMBER);
            BasedataProp prop = (BasedataProp)edit.getProperty();
            String formId = prop.getBaseEntityId();
            ListShowParameter parameter = new ListShowParameter();
            parameter.setBillFormId(formId);
            parameter.getOpenStyle().setShowType(ShowType.Modal);
            parameter.setFormId("bos_listf7");
            StyleCss styleCss = new StyleCss();
            styleCss.setHeight("580");
            styleCss.setWidth("960");
            parameter.getOpenStyle().setInlineStyleCss(styleCss);
            parameter.setLookUp(true);
            parameter.setUseOrgId(this.getModel().getDataEntity().getLong("createorg.id"));
            QFilter qFilters = new QFilter("enable", "=", (Object)Boolean.TRUE).and("status", "=", (Object)"C");
            parameter.getListFilterParameter().setFilter(qFilters);
            parameter.setShowTitle(false);
            parameter.setMultiSelect(true);
            IDataModel model = view.getModel();
            String entryKey = ((BasedataEdit)view.getControl(VOTYPENUMBER)).getProperty().getParent().getName();
            parameter.setSelectedRows((Object[])model.getEntryEntity(entryKey).stream().filter(dy -> dy.get(VOTYPENUMBER) != null).map(dy -> dy.getLong(String.join((CharSequence)".", VOTYPENUMBER, "id"))).toArray(Long[]::new));
            parameter.setCloseCallBack(new CloseCallBack((IFormPlugin)this, "addentry"));
            parameter.setHasRight(true);
            this.getView().showForm((FormShowParameter)parameter);
        }
    }
}

