/*
 * Decompiled with CFR 0.152.
 */
package kd.wtc.wtp.formplugin.web.vacation;

import java.time.LocalDate;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.EventObject;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.bill.OperationStatus;
import kd.bos.dataentity.entity.DataEntityState;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.metadata.IDataEntityType;
import kd.bos.dataentity.metadata.clr.DataEntityPropertyCollection;
import kd.bos.dataentity.metadata.dynamicobject.DynamicComplexProperty;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.ObjectUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.form.CloseCallBack;
import kd.bos.form.FormShowParameter;
import kd.bos.form.ShowType;
import kd.bos.form.control.EntryGrid;
import kd.bos.form.control.events.BeforeItemClickEvent;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.BeforeClosedEvent;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.events.HyperLinkClickEvent;
import kd.bos.form.events.HyperLinkClickListener;
import kd.bos.form.operate.FormOperate;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.mvc.base.BaseModel;
import kd.bos.orm.util.CollectionUtils;
import kd.hr.hbp.business.servicehelper.HRBaseServiceHelper;
import kd.hr.hbp.common.util.HRStringUtils;
import kd.hr.hbp.formplugin.web.HRDataBaseEdit;
import kd.wtc.wtbs.common.util.Tuple;
import kd.wtc.wtbs.common.util.WTCDateUtils;
import kd.wtc.wtbs.common.util.third.collect.Lists;
import kd.wtc.wtbs.common.util.third.collect.Maps;
import kd.wtc.wtp.business.ruleenging.RulePreviewUtil;

public class VacationRuleEdit
extends HRDataBaseEdit
implements HyperLinkClickListener {
    private static final HRBaseServiceHelper ATTITEM = new HRBaseServiceHelper("wtbd_attitem");
    private static final HRBaseServiceHelper BASESET = new HRBaseServiceHelper("wtp_vabaseset");
    private static final HRBaseServiceHelper CHANGESET = new HRBaseServiceHelper("wtp_vachangeset");

    public void registerListener(EventObject e) {
        super.registerListener(e);
        ((EntryGrid)this.getControl("entryentity")).addHyperClickListener((HyperLinkClickListener)this);
        super.addItemClickListeners(new String[]{"tbmain"});
    }

    public void afterBindData(EventObject eventObject) {
        String hisAction;
        boolean isNewVersion;
        super.afterBindData(eventObject);
        Map customParams = this.getView().getFormShowParameter().getCustomParams();
        Long boId = (Long)customParams.get("boid");
        DynamicObjectCollection entryEntity = this.getModel().getEntryEntity("entryentity");
        if (!entryEntity.isEmpty()) {
            for (int index = 0; index < entryEntity.size(); ++index) {
                DynamicObject dynamicObject = (DynamicObject)entryEntity.get(index);
                String condition = dynamicObject.getString("daterangecondition");
                this.getModel().setValue("daterange", (Object)condition, index);
                this.getModel().setValue("calculname", (Object)RulePreviewUtil.getConditionPreviewStr((String)condition), index);
                String limitCondition = dynamicObject.getString("limitscope");
                String conditionPreviewStr = RulePreviewUtil.getConditionPreviewStr((String)limitCondition);
                this.getModel().setValue("calculdes", (Object)conditionPreviewStr, index);
                this.getModel().setValue("limitscope", (Object)limitCondition, index);
            }
        }
        if (isNewVersion = HRStringUtils.equals((String)"open_insert_new_data_page", (String)(hisAction = (String)customParams.get("his_action")))) {
            this.getModel().deleteEntryData("entryentity");
        }
        this.getModel().setDataChanged(false);
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        String operateKey;
        super.beforeDoOperation(args);
        FormOperate formOperate = (FormOperate)args.getSource();
        switch (operateKey = formOperate.getOperateKey()) {
            case "copyentryrow": 
            case "editrow": 
            case "newentry": {
                this.checkEffDate(args);
                break;
            }
            case "save": 
            case "submit": 
            case "confirmchange": 
            case "submitandaudit": {
                DynamicObjectCollection entity = this.getView().getModel().getEntryEntity("entryentity");
                if (CollectionUtils.isEmpty((Collection)entity)) {
                    this.getView().showErrorNotification(ResManager.loadKDString((String)"\u8bf7\u6dfb\u52a0\u81f3\u5c11\u4e00\u884c\u6570\u636e\u5230\u8ba1\u7b97\u89c4\u5219\u4e2d\u3002", (String)"VacationRuleEdit_1", (String)"wtc-wtp-formplugin", (Object[])new Object[0]));
                    args.setCancel(true);
                }
                if (!this.checkPrjValite()) break;
                args.setCancel(true);
                break;
            }
        }
    }

    public void beforeItemClick(BeforeItemClickEvent evt) {
        String itemKey = evt.getItemKey();
        if ("bar_save".equals(itemKey) || "bar_submit".equals(itemKey) || "confirmchange".equals(itemKey) || "bar_saveandnew".equals(itemKey)) {
            DynamicObjectCollection entity = this.getView().getModel().getEntryEntity("entryentity");
            if (CollectionUtils.isEmpty((Collection)entity)) {
                this.getView().showErrorNotification(ResManager.loadKDString((String)"\u8bf7\u6dfb\u52a0\u81f3\u5c11\u4e00\u884c\u6570\u636e\u5230\u8ba1\u7b97\u89c4\u5219\u4e2d\u3002", (String)"VacationRuleEdit_1", (String)"wtc-wtp-formplugin", (Object[])new Object[0]));
                evt.setCancel(true);
            }
            if (this.checkPrjValite()) {
                evt.setCancel(true);
            }
        }
    }

    private boolean checkPrjValite() {
        HashMap map = Maps.newHashMapWithExpectedSize((int)16);
        HashMap vaBase = Maps.newHashMapWithExpectedSize((int)16);
        HashMap vaChange = Maps.newHashMapWithExpectedSize((int)16);
        DynamicObjectCollection dynamicObjectCollection = this.getModel().getEntryEntity("entryentity");
        for (DynamicObject dynamicObject : dynamicObjectCollection) {
            this.getMap(dynamicObject, "vabasesetid", vaBase);
            this.getMap(dynamicObject, "vachangesetid", vaChange);
            this.getMap(dynamicObject, "vaitem", map);
            this.getMap(dynamicObject, "roundruleitem", map);
            this.getMap(dynamicObject, "resultitem", map);
        }
        ArrayList<Tuple<Map<Long, String>, HRBaseServiceHelper>> tuples = new ArrayList<Tuple<Map<Long, String>, HRBaseServiceHelper>>();
        tuples.add(new Tuple((Object)vaBase, (Object)BASESET));
        tuples.add(new Tuple((Object)vaChange, (Object)CHANGESET));
        tuples.add(new Tuple((Object)map, (Object)ATTITEM));
        return StringUtils.isNotBlank((CharSequence)this.getErrMsg(tuples));
    }

    private void getMap(DynamicObject dynamicObject, String prjKey, Map<Long, String> map) {
        DynamicObject prj = dynamicObject.getDynamicObject(prjKey);
        if (prj != null) {
            map.put(prj.getLong("id"), prj.getString("name"));
        }
    }

    private String getErrMsg(List<Tuple<Map<Long, String>, HRBaseServiceHelper>> tuples) {
        Date firstDate = this.getModel().getDataEntity().getDate("bsed");
        if (firstDate == null) {
            return null;
        }
        LocalDate firstLDate = WTCDateUtils.toLocalDate((Date)firstDate);
        StringBuilder errMsg = new StringBuilder();
        String separater = ResManager.loadKDString((String)"\u3001", (String)"VacationRuleEdit_2", (String)"wtc-wtp-formplugin", (Object[])new Object[0]);
        for (Tuple<Map<Long, String>, HRBaseServiceHelper> tuple : tuples) {
            Map map = (Map)tuple.getKey();
            HRBaseServiceHelper helper = (HRBaseServiceHelper)tuple.getValue();
            Map<Long, DynamicObject> prjMap = this.getMap(map.keySet(), helper);
            map.forEach((key, value) -> {
                LocalDate prjFirstLDate;
                Date prjFirstDate;
                DynamicObject dy = (DynamicObject)prjMap.get(key);
                if (dy != null && (prjFirstDate = dy.getDate("firstbsed")) != null && (prjFirstLDate = WTCDateUtils.toLocalDate((Date)prjFirstDate)).isAfter(firstLDate)) {
                    errMsg.append((String)value).append(separater);
                }
            });
        }
        if (!StringUtils.isEmpty((CharSequence)errMsg)) {
            errMsg.replace(errMsg.lastIndexOf(separater), errMsg.length(), "");
            errMsg.append(ResManager.loadKDString((String)"\u751f\u6548\u65e5\u671f\u5e94\u65e9\u4e8e\u6216\u7b49\u4e8e\u4f11\u5047\u89c4\u5219\u751f\u6548\u65e5\u671f\uff0c\u8bf7\u8c03\u6574\u3002", (String)"VacationRuleEdit_3", (String)"wtc-wtp-formplugin", (Object[])new Object[0]));
            this.getView().showErrorNotification(errMsg.toString());
        }
        return errMsg.toString();
    }

    private Map<Long, DynamicObject> getMap(Set<Long> pkIds, HRBaseServiceHelper helper) {
        HashMap prjMap = Maps.newHashMapWithExpectedSize((int)16);
        DynamicObject[] dys = helper.loadDynamicObjectArray(pkIds.toArray());
        if (dys != null && dys.length > 0) {
            for (DynamicObject dy : dys) {
                prjMap.put(dy.getLong("id"), dy);
            }
        }
        return prjMap;
    }

    public void closedCallBack(ClosedCallBackEvent event) {
        super.closedCallBack(event);
        this.getView().setEnable(Boolean.FALSE, new String[]{"createorg"});
        String actionId = event.getActionId();
        Map returnData = (Map)event.getReturnData();
        if (returnData == null) {
            return;
        }
        if ("btnok".equals(actionId)) {
            Integer rowIndex = (Integer)returnData.get("rowIndex");
            if (rowIndex != null) {
                this.updateEntryRow(returnData, rowIndex);
            } else {
                rowIndex = this.getModel().createNewEntryRow("entryentity");
                this.updateEntryRow(returnData, rowIndex);
            }
            this.getView().updateView("entryentity");
        }
    }

    private void updateEntryRow(Map<String, Object> returnData, Integer rowIndex) {
        if (!Boolean.parseBoolean((String)returnData.get("bar_change"))) {
            return;
        }
        DataEntityPropertyCollection properties = this.getModel().getEntryEntity("entryentity").getDynamicObjectType().getProperties();
        for (IDataEntityProperty property : properties) {
            Object targetValue = returnData.get(property.getName());
            if (targetValue == null) continue;
            this.getModel().setValue(property.getName(), targetValue, rowIndex.intValue());
        }
        this.getModel().setValue("basedataid", (Object)0, rowIndex.intValue());
    }

    private void checkEffDate(BeforeDoOperationEventArgs args) {
        if (this.getModel().getValue("bsed") == null) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u6309\u8981\u6c42\u586b\u5199\u201c\u751f\u6548\u65e5\u671f\u201d\u3002", (String)"VacationRuleEdit_4", (String)"wtc-wtp-formplugin", (Object[])new Object[0]));
            args.setCancel(true);
            return;
        }
        FormOperate formOperate = (FormOperate)args.getSource();
        String operateKey = formOperate.getOperateKey();
        EntryGrid entryGrid = (EntryGrid)this.getControl("entryentity");
        int[] selectedRows = entryGrid.getEntryState().getSelectedRows();
        if ("copyentryrow".equals(operateKey) || "editrow".equals(operateKey)) {
            if (ObjectUtils.isEmpty((Object)selectedRows)) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u8981\u6267\u884c\u7684\u6570\u636e\u3002", (String)"VacationRuleEdit_5", (String)"wtc-wtp-formplugin", (Object[])new Object[0]));
                args.setCancel(true);
            } else if (selectedRows.length > 1 && "copyentryrow".equals(operateKey)) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u65e0\u6cd5\u6279\u91cf\u590d\u5236\u3002", (String)"VacationRuleEdit_9", (String)"wtc-wtp-formplugin", (Object[])new Object[0]));
                args.setCancel(true);
            }
        }
    }

    public void afterCopyData(EventObject eventObject) {
        BaseModel source = (BaseModel)eventObject.getSource();
        DynamicObject dataEntity = source.getDataEntity();
    }

    public void afterDoOperation(AfterDoOperationEventArgs evt) {
        super.afterDoOperation(evt);
        String name = evt.getOperateKey();
        if ("copyentryrow".equals(name) || "newentry".equals(name) || "editrow".equals(name)) {
            DynamicObjectCollection entryEntity = this.getModel().getEntryEntity("entryentity");
            EntryGrid entryGrid = (EntryGrid)this.getControl("entryentity");
            int[] selectedRows = entryGrid.getEntryState().getSelectedRows();
            if (("copyentryrow".equals(name) || "editrow".equals(name)) && ObjectUtils.isEmpty((Object)selectedRows)) {
                return;
            }
            if ("copyentryrow".equals(name)) {
                DynamicObject dynamicObject = (DynamicObject)entryEntity.get(selectedRows[0]);
                FormShowParameter formShowParameter = this.getFormShowCustom(dynamicObject, null, name);
                this.openCalculRule(formShowParameter, null);
                return;
            }
            if ("newentry".equals(name)) {
                this.openCalculRule(this.getFormShowCustom(null, null, name), null);
                return;
            }
            if ("editrow".equals(name)) {
                int rowIndex = entryGrid.getEntryState().getFocusRow();
                if (rowIndex < 0 || entryEntity.size() <= rowIndex) {
                    return;
                }
                DynamicObject dynamicObject = (DynamicObject)entryEntity.get(rowIndex);
                FormShowParameter formShowParameter = this.getFormShowCustom(dynamicObject, rowIndex, name);
                formShowParameter.setCustomParam("editrow", (Object)"editrow");
                this.openCalculRule(formShowParameter, OperationStatus.EDIT);
            }
        }
    }

    private FormShowParameter getFormShowCustom(DynamicObject dynamicObject, Integer rowIndex, String type) {
        FormShowParameter formShowParameter = new FormShowParameter();
        formShowParameter.setCustomParam("datastatus", this.getModel().getValue("datastatus"));
        List filterSet = this.getModel().getEntryEntity("entryentity").stream().map(dy -> dy.getLong("vatype.id")).collect(Collectors.toList());
        if (rowIndex != null) {
            filterSet.remove(rowIndex);
        }
        HashMap<String, Object> map = new HashMap<String, Object>(16);
        DynamicObject org = (DynamicObject)this.getModel().getValue("createorg");
        map.put("bsed", this.getModel().getValue("bsed"));
        map.put("vatypeset", filterSet);
        formShowParameter.setCustomParam("singleInfo", map);
        formShowParameter.setCustomParam("status", this.getModel().getValue("status"));
        if (org != null) {
            map.put("createorg", org.getPkValue());
        }
        if (dynamicObject == null) {
            return formShowParameter;
        }
        if (!"copyentryrow".equals(type)) {
            this.setSingleBaseId(dynamicObject, map, "vatype");
        }
        this.setSingleBaseId(dynamicObject, map, "vabasesetid");
        this.setSingleBaseId(dynamicObject, map, "vachangesetid");
        this.setSingleBaseId(dynamicObject, map, "attpolicy");
        map.put("limitscope", dynamicObject.getString("limitscope"));
        map.put("calculname", dynamicObject.getString("calculname"));
        map.put("daterange", dynamicObject.getString("daterangecondition"));
        this.setSingleBaseId(dynamicObject, map, "vaitem");
        this.setSingleBaseId(dynamicObject, map, "roundrule");
        this.setSingleBaseId(dynamicObject, map, "roundruleitem");
        this.setSingleBaseId(dynamicObject, map, "resultitem");
        map.put("basedataid", dynamicObject.get("basedataid"));
        this.setSingleBaseId(dynamicObject, map, "deductrule");
        map.put("isquota", dynamicObject.get("isquota"));
        map.put("isdisposable", dynamicObject.get("isdisposable"));
        map.put("isnonquotaapply", dynamicObject.get("isnonquotaapply"));
        map.put("issplit", dynamicObject.get("issplit"));
        this.setSingleBaseId(dynamicObject, map, "timebyshiftitem");
        this.setSingleBaseId(dynamicObject, map, "timebydayitem");
        formShowParameter.setCustomParam("rowIndex", (Object)rowIndex);
        if (rowIndex == null) {
            formShowParameter.setCustomParam("copyentryrow", (Object)Boolean.TRUE);
        }
        return formShowParameter;
    }

    private void setSingleBaseId(DynamicObject dynamicObject, Map<String, Object> map, String key) {
        DynamicObject single = dynamicObject.getDynamicObject(key);
        if (single != null) {
            map.put(key, single.getLong("id"));
        }
    }

    private void openCalculRule(FormShowParameter formShowParameter, OperationStatus operationStatus) {
        if (formShowParameter == null) {
            formShowParameter = new FormShowParameter();
        }
        formShowParameter.setFormId("wtp_vacalculrule");
        formShowParameter.getOpenStyle().setShowType(ShowType.Modal);
        formShowParameter.setStatus(operationStatus == null ? OperationStatus.ADDNEW : operationStatus);
        formShowParameter.setCloseCallBack(new CloseCallBack((IFormPlugin)this, "btnok"));
        this.getView().showForm(formShowParameter);
    }

    public void hyperLinkClick(HyperLinkClickEvent hyperLinkClickEvent) {
        String name = hyperLinkClickEvent.getFieldName();
        if ("vatype".equals(name)) {
            int rowIndex = hyperLinkClickEvent.getRowIndex();
            DynamicObject dynamicObject = (DynamicObject)this.getModel().getEntryEntity("entryentity").get(rowIndex);
            FormShowParameter formShowParameter = this.getFormShowCustom(dynamicObject, rowIndex, name);
            this.openCalculRule(formShowParameter, OperationStatus.VIEW);
        }
    }

    public void beforeClosed(BeforeClosedEvent e) {
        super.beforeClosed(e);
        ArrayList prop = Lists.newArrayList((Object[])new String[]{"daterange", "limitscope", "daterangecondition"});
        DynamicObjectCollection entries = this.getModel().getDataEntity(true).getDynamicObjectCollection("entryentity");
        for (DynamicObject entry : entries) {
            VacationRuleEdit.setDataChangedFalse(entry, prop);
        }
    }

    private static void setDataChangedFalse(DynamicObject dataEntity, List<String> propList) {
        IDataEntityType dataEntityType = dataEntity.getDataEntityType();
        DataEntityPropertyCollection properties = dataEntityType.getProperties();
        DataEntityState dataEntityState = dataEntity.getDataEntityState();
        String _id = "_id";
        for (String prop : propList) {
            IDataEntityProperty iDataEntityProperty_id;
            IDataEntityProperty iDataEntityProperty = (IDataEntityProperty)properties.get((Object)prop);
            if (iDataEntityProperty == null) continue;
            if (iDataEntityProperty instanceof DynamicComplexProperty && (iDataEntityProperty_id = (IDataEntityProperty)properties.get((Object)(prop + _id))) != null) {
                dataEntityState.setBizChanged(iDataEntityProperty_id.getOrdinal(), false);
            }
            dataEntityState.setBizChanged(iDataEntityProperty.getOrdinal(), false);
        }
    }
}

