/*
 * Decompiled with CFR 0.152.
 */
package kd.wtc.wtp.business.attconfirm;

import com.alibaba.fastjson.JSON;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.entity.ILocaleString;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.db.DB;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.form.CloseCallBack;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.OpenStyle;
import kd.bos.form.ShowType;
import kd.bos.form.field.events.BeforeF7SelectEvent;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.DispatchServiceHelper;
import kd.bos.servicehelper.MetadataServiceHelper;
import kd.bos.servicehelper.user.UserServiceHelper;
import kd.bos.servicehelper.workflow.MessageCenterServiceHelper;
import kd.bos.url.UrlService;
import kd.bos.util.CollectionUtils;
import kd.bos.workflow.engine.msg.info.MessageInfo;
import kd.hr.hbp.business.servicehelper.HRBaseServiceHelper;
import kd.hr.hbp.common.util.HRDateTimeUtils;
import kd.hr.hbp.common.util.HRDynamicObjectUtils;
import kd.hr.hbp.common.util.HRStringUtils;
import kd.wtc.wtbs.business.servicehelper.WTCServiceHelper;
import kd.wtc.wtbs.business.util.WTCDynamicObjectUtils;
import kd.wtc.wtbs.business.web.attperiod.PerAttPeriodQueryServiceImpl;
import kd.wtc.wtbs.business.web.file.AttFileQueryServiceImpl;
import kd.wtc.wtbs.common.helper.WTCAppContextHelper;
import kd.wtc.wtbs.common.model.attfile.AttFileQueryParam;
import kd.wtc.wtbs.common.model.period.PerAttPeriod;
import kd.wtc.wtbs.common.model.period.PerAttPeriodQueryParam;
import kd.wtc.wtbs.common.util.Tuple;
import kd.wtc.wtbs.common.util.WTCCollections;
import kd.wtc.wtbs.common.util.WTCStringUtils;
import kd.wtc.wtbs.common.util.third.collect.Lists;
import kd.wtc.wtbs.common.util.third.collect.Maps;
import kd.wtc.wtbs.common.util.third.collect.Sets;
import kd.wtc.wtp.business.attconfirm.impl.AttConfirmQueryServiceImpl;
import kd.wtc.wtp.common.constants.attconfirm.AttConfirmConstants;
import kd.wtc.wtp.common.enums.attconfirm.AttConRecordModeEnum;
import kd.wtc.wtp.common.enums.attconfirm.AttConRecordStatusEnum;
import kd.wtc.wtp.common.enums.attconfirm.AttConRecordTypeEnum;
import kd.wtc.wtp.common.enums.attconfirm.AttConfirmDataStatusEnum;
import kd.wtc.wtp.common.kdstring.AttConfirmKDString;
import kd.wtc.wtp.common.model.attconfirm.AttConfirmRecordGenModel;
import kd.wtc.wtp.common.model.attconfirm.AttConfirmRecordModel;
import kd.wtc.wtp.common.model.attconfirm.AttConfirmRecordOpResult;
import kd.wtc.wtp.common.model.attconfirm.AttConfirmRecordQueryParam;

public class AttConfirmHelper {
    private static final Log LOG = LogFactory.getLog(AttConfirmHelper.class);
    public static final int BATCH_SIZE_DEFAULT = 1000;

    public static AttConfirmHelper getInstance() {
        return (AttConfirmHelper)WTCAppContextHelper.getBean(AttConfirmHelper.class);
    }

    public void genShowAttConfirmOpResult(AttConfirmRecordOpResult attConfirmRecordOpResult, IFormPlugin plugin, IFormView view, String entityNumber) {
        FormShowParameter formShowParameter = new FormShowParameter();
        formShowParameter.setFormId(entityNumber);
        OpenStyle openStyle = new OpenStyle();
        openStyle.setShowType(ShowType.Modal);
        formShowParameter.setOpenStyle(openStyle);
        formShowParameter.setCloseCallBack(new CloseCallBack(plugin, "wtam_attconopresult"));
        formShowParameter.setCustomParam("AttConfirmRecordOpResult", (Object)JSON.toJSONString((Object)attConfirmRecordOpResult));
        view.showForm(formShowParameter);
    }

    public void updateAttConfirmRecordData(List<AttConfirmRecordModel> recordModelList) {
        DynamicObject[] confirmRecordDys;
        Map<Long, AttConfirmRecordModel> recordModelMap = recordModelList.stream().collect(Collectors.toMap(AttConfirmRecordModel::getId, recordModel -> recordModel, (a, b) -> a));
        HRBaseServiceHelper helper = new HRBaseServiceHelper("wtam_attconrecord");
        for (DynamicObject confirmRecordDy : confirmRecordDys = helper.loadDynamicObjectArray(recordModelMap.keySet().toArray())) {
            long id = confirmRecordDy.getLong("id");
            AttConfirmRecordModel recordModel2 = recordModelMap.get(id);
            if (recordModel2.getRevoker() != 0L) {
                confirmRecordDy.set("revoker", (Object)recordModel2.getRevoker());
            }
            if (recordModel2.getRevokeTime() != null) {
                confirmRecordDy.set("revoketime", (Object)recordModel2.getRevokeTime());
            }
            if (recordModel2.getConFirmer() != 0L) {
                confirmRecordDy.set("confirmer", (Object)recordModel2.getConFirmer());
            }
            if (recordModel2.getConfirmMode() != null) {
                confirmRecordDy.set("confirmmode", (Object)recordModel2.getConfirmMode().getCode());
            }
            if (recordModel2.getConfirmTime() != null) {
                confirmRecordDy.set("confirmtime", (Object)recordModel2.getConfirmTime());
            }
            if (recordModel2.getStatus() == null) continue;
            confirmRecordDy.set("status", (Object)recordModel2.getStatus().getCode());
        }
        helper.update(confirmRecordDys);
    }

    @Deprecated
    public void initAttConfirmRecordGenModelFileIdSet(AttConfirmRecordGenModel attConfirmRecordGenModel, Set<Long> personIdSet, Set<Long> fileBoIdSet) {
        AttFileQueryParam attFileQueryParam = new AttFileQueryParam();
        if (WTCCollections.isNotEmpty(personIdSet)) {
            attConfirmRecordGenModel.setPersonIdSet(personIdSet);
            attFileQueryParam.setAttPersonSetIds(personIdSet);
        }
        if (WTCCollections.isNotEmpty(fileBoIdSet)) {
            attFileQueryParam.setSetBoIds(fileBoIdSet);
        }
        attFileQueryParam.setProperties("id");
        Set authFileIdSet = AttFileQueryServiceImpl.getInstance().queryAttFiles(attFileQueryParam).stream().map(d -> d.getLong("id")).collect(Collectors.toSet());
        attConfirmRecordGenModel.setFileAuthIdSet(authFileIdSet);
        if (WTCCollections.isNotEmpty(fileBoIdSet)) {
            attConfirmRecordGenModel.setFileBoIdSet(fileBoIdSet);
        } else {
            attFileQueryParam.setAuthCheck(Boolean.FALSE);
            attFileQueryParam.setProperties("boid");
            Set fileBoId = AttFileQueryServiceImpl.getInstance().queryAttFiles(attFileQueryParam).stream().map(d -> d.getLong("boid")).collect(Collectors.toSet());
            attConfirmRecordGenModel.setFileBoIdSet(fileBoId);
        }
    }

    public List<DynamicObject> genAttConfirmBillHisData(List<AttConfirmRecordModel> modelList, boolean isSaveOrm) {
        if (CollectionUtils.isEmpty(modelList)) {
            return Lists.newArrayList((Object[])new DynamicObject[]{new HRBaseServiceHelper("wtam_attconfirmbill").generateEmptyDynamicObject()});
        }
        int batchSize = WTCAppContextHelper.getSysParams().getIntValue("kd.wtc.wtp.attConfirm.batchSize", 1000);
        List modelListPartition = Lists.partition(modelList, (int)batchSize);
        ArrayList<DynamicObject> resDys = new ArrayList<DynamicObject>();
        for (List attConfirmRecordModels : modelListPartition) {
            ArrayList detailDateList = Lists.newArrayListWithExpectedSize((int)attConfirmRecordModels.size());
            HashSet detailFileBoIds = Sets.newHashSetWithExpectedSize((int)attConfirmRecordModels.size());
            HashSet periodFileBoIds = Sets.newHashSetWithExpectedSize((int)attConfirmRecordModels.size());
            ArrayList<Long> perAttPeriodIds = new ArrayList<Long>(10);
            Date minStartDate = null;
            Date maxEndDate = null;
            for (AttConfirmRecordModel recordModel : attConfirmRecordModels) {
                AttConRecordTypeEnum type = recordModel.getType();
                if (AttConRecordTypeEnum.BY_DATE == type) {
                    detailDateList.add(recordModel.getStartDate());
                    detailFileBoIds.add(recordModel.getAttFile());
                    continue;
                }
                if (AttConRecordTypeEnum.BY_PERIOD != type) continue;
                periodFileBoIds.add(recordModel.getAttFile());
                perAttPeriodIds.add(recordModel.getPerAttPeriod());
                Date startDate = recordModel.getStartDate();
                if (minStartDate == null || minStartDate.compareTo(startDate) > 0) {
                    minStartDate = startDate;
                }
                Date endDate = recordModel.getEndDate();
                if (maxEndDate != null && maxEndDate.compareTo(endDate) >= 0) continue;
                maxEndDate = endDate;
            }
            Map<Long, Map<String, Map<Long, String>>> attItemDetailMap = null;
            if (detailDateList.size() > 0) {
                attItemDetailMap = this.callDetailData(detailFileBoIds, detailDateList);
            }
            Map<Long, Map<String, Map<Long, BigDecimal>>> attItemPeriodMap = null;
            Map<Object, Object> perAttPeriodMap = Maps.newHashMapWithExpectedSize((int)1);
            if (CollectionUtils.isNotEmpty(perAttPeriodIds)) {
                PerAttPeriodQueryParam queryParam = new PerAttPeriodQueryParam();
                queryParam.setExtendQFilter(new QFilter("id", "in", perAttPeriodIds));
                List perAttPeriodList = PerAttPeriodQueryServiceImpl.getInstance().queryPerAttPeriodEntity(queryParam);
                perAttPeriodMap = perAttPeriodList.stream().collect(Collectors.toMap(PerAttPeriod::getPrimaryId, PerAttPeriod::getId, (a, b) -> a));
                Map<Long, List<Long>> fileBoToVidMap = this.getFileBoToVidMap(periodFileBoIds);
                attItemPeriodMap = this.callPeriodData(periodFileBoIds, fileBoToVidMap, new ArrayList<Object>(perAttPeriodMap.values()));
            }
            List<DynamicObject> dys = this.transformToAttConfirmBillDy(attConfirmRecordModels, isSaveOrm, attItemDetailMap, attItemPeriodMap, (Map<Long, String>)perAttPeriodMap);
            resDys.addAll(dys);
        }
        return resDys;
    }

    private Map<Long, Map<String, Map<Long, BigDecimal>>> callPeriodData(Set<Long> periodFileBoIds, Map<Long, List<Long>> fileBoToVidMap, List<String> list) {
        int batchSize = WTCAppContextHelper.getSysParams().getIntValue("kd.wtc.wtp.attConfirm.batchSize", 1000);
        List partition = Lists.partition(new ArrayList<Long>(periodFileBoIds), (int)batchSize);
        HashMap<Long, Map<String, Map<Long, BigDecimal>>> attItemPeriodMap = new HashMap<Long, Map<String, Map<Long, BigDecimal>>>();
        partition.forEach(ids -> {
            try {
                Map map = (Map)WTCServiceHelper.invokeBizService((String)"wtc", (String)"wtbs", (String)"IMobileSchemeQueryService", (String)"batchMatchMobileSchemeByFileBoId", (Object[])new Object[]{new HashSet(ids), "A"});
                attItemPeriodMap.putAll((Map)DispatchServiceHelper.invokeBizService((String)"wtc", (String)"wtbs", (String)"IMobileSchemeQueryService", (String)"getPerSumAttItems", (Object[])new Object[]{map, fileBoToVidMap, list, true}));
            }
            catch (Exception ex) {
                LOG.warn("kd.wtc.wtp.business.attconfirm.AttConfirmHelper.callPeriodData  error ", (Throwable)ex);
            }
        });
        return attItemPeriodMap;
    }

    private Map<Long, Map<String, Map<Long, String>>> callDetailData(Set<Long> detailFileBoIds, List<Date> detailDateList) {
        int batchSize = WTCAppContextHelper.getSysParams().getIntValue("kd.wtc.wtp.attConfirm.batchSize", 1000);
        List partition = Lists.partition(new ArrayList<Long>(detailFileBoIds), (int)batchSize);
        HashMap<Long, Map<String, Map<Long, String>>> attItemDetailMap = new HashMap<Long, Map<String, Map<Long, String>>>();
        partition.forEach(ids -> {
            try {
                Map map = (Map)WTCServiceHelper.invokeBizService((String)"wtc", (String)"wtbs", (String)"IMobileSchemeQueryService", (String)"batchMatchMobileSchemeByFileBoId", (Object[])new Object[]{new HashSet(ids), "A"});
                attItemDetailMap.putAll((Map)WTCServiceHelper.invokeBizService((String)"wtc", (String)"wtbs", (String)"IMobileSchemeQueryService", (String)"getDailyAttItemsDetail", (Object[])new Object[]{map, detailDateList, true}));
            }
            catch (Exception ex) {
                LOG.warn("kd.wtc.wtp.business.attconfirm.AttConfirmHelper.callDetailData  error ", (Throwable)ex);
            }
        });
        return attItemDetailMap;
    }

    private Map<Long, List<Long>> getFileBoToVidMap(Set<Long> periodFileBoIds) {
        AttFileQueryParam queryParam = new AttFileQueryParam(false);
        queryParam.setSetBoIds(periodFileBoIds);
        queryParam.setBeCurrent(Boolean.valueOf(false));
        queryParam.setProperties("id, boid");
        List attFileDys = AttFileQueryServiceImpl.getInstance().queryAttFiles(queryParam);
        Map<Long, List<DynamicObject>> fileBoMap = attFileDys.stream().collect(Collectors.groupingBy(dy -> dy.getLong("boid")));
        HashMap fileBoToVidMap = Maps.newHashMapWithExpectedSize((int)fileBoMap.size());
        for (Map.Entry<Long, List<DynamicObject>> mapEntry : fileBoMap.entrySet()) {
            List tempList = mapEntry.getValue().stream().map(dy -> dy.getLong("id")).collect(Collectors.toList());
            fileBoToVidMap.put(mapEntry.getKey(), tempList);
        }
        return fileBoToVidMap;
    }

    private List<DynamicObject> transformToAttConfirmBillDy(List<AttConfirmRecordModel> modelList, boolean isSaveOrm, Map<Long, Map<String, Map<Long, String>>> attItemDetailMap, Map<Long, Map<String, Map<Long, BigDecimal>>> attItemPeriodMap, Map<Long, String> perAttPeriodMap) {
        HRBaseServiceHelper helper = new HRBaseServiceHelper("wtam_attconfirmbill");
        List<DynamicObject> dys = this.genLatestConfirmBillDy(modelList, attItemDetailMap, attItemPeriodMap, perAttPeriodMap, helper);
        if (isSaveOrm) {
            this.saveAttConfirmBill(helper, dys);
        }
        return dys;
    }

    public void saveAttConfirmBill(HRBaseServiceHelper helper, List<DynamicObject> latestDys) {
        List attConfirmRecordIdList = latestDys.stream().map(dy -> WTCDynamicObjectUtils.getBaseDataId((DynamicObject)dy, (String)"attconrecord")).collect(Collectors.toList());
        DynamicObject[] attConfirmRecordDys = helper.loadDynamicObjectArray(new QFilter[]{new QFilter("attconrecord", "in", attConfirmRecordIdList)});
        Map<Long, DynamicObject> map = Arrays.stream(attConfirmRecordDys).collect(Collectors.toMap(dy -> WTCDynamicObjectUtils.getBaseDataId((DynamicObject)dy, (String)"attconrecord"), dy -> dy, (a, b) -> a));
        HRBaseServiceHelper hisHelper = new HRBaseServiceHelper("wtam_attconfirmbillhis");
        ArrayList<DynamicObject> saveHisDyList = new ArrayList<DynamicObject>(latestDys.size());
        ArrayList<DynamicObject> saveCurrentDyList = new ArrayList<DynamicObject>(latestDys.size());
        ArrayList<DynamicObject> updateCurrentDyList = new ArrayList<DynamicObject>(latestDys.size());
        for (DynamicObject latestDy : latestDys) {
            long attConfirmRecordId = WTCDynamicObjectUtils.getBaseDataId((DynamicObject)latestDy, (String)"attconrecord");
            DynamicObject existsDy = map.get(attConfirmRecordId);
            if (existsDy != null) {
                boolean isEqual = this.compareWhetherLatestAndExistsEqual(latestDy, existsDy);
                if (isEqual) continue;
                Object object = existsDy.get("attconrecord");
                HRDynamicObjectUtils.copy((DynamicObject)latestDy, (DynamicObject)existsDy, (Set)Sets.newHashSet((Object[])new String[]{"id", "attconrecord", "createtime", "creator"}));
                existsDy.set("attconrecord", object);
                updateCurrentDyList.add(existsDy);
                DynamicObject hisEmptyDy = hisHelper.generateEmptyDynamicObject();
                HRDynamicObjectUtils.copy((DynamicObject)existsDy, (DynamicObject)hisEmptyDy, (Set)AttConfirmConstants.IGNOREFILEDSET);
                saveHisDyList.add(hisEmptyDy);
                continue;
            }
            saveCurrentDyList.add(latestDy);
        }
        if (CollectionUtils.isNotEmpty(saveHisDyList)) {
            this.resetBaseData(saveHisDyList);
            hisHelper.save(saveHisDyList.toArray(new DynamicObject[0]));
        }
        if (CollectionUtils.isNotEmpty(saveCurrentDyList)) {
            this.resetBaseData(saveCurrentDyList);
            helper.save(saveCurrentDyList.toArray(new DynamicObject[0]));
        }
        if (CollectionUtils.isNotEmpty(updateCurrentDyList)) {
            this.resetBaseData(updateCurrentDyList);
            helper.update(updateCurrentDyList.toArray(new DynamicObject[0]));
        }
    }

    private void resetBaseData(List<DynamicObject> updateCurrentDyList) {
        long currentUserId = UserServiceHelper.getCurrentUserId();
        Date currentDate = new Date();
        for (DynamicObject existsDy : updateCurrentDyList) {
            existsDy.set("creator", (Object)currentUserId);
            existsDy.set("createtime", (Object)currentDate);
            existsDy.set("modifier", (Object)currentUserId);
            existsDy.set("modifytime", (Object)currentDate);
        }
    }

    public boolean compareWhetherLatestAndExistsEqual(DynamicObject latestDy, DynamicObject existsDy) {
        DynamicObjectCollection existsEntryDys = existsDy.getDynamicObjectCollection("entryentity");
        DynamicObjectCollection latestEntryDys = latestDy.getDynamicObjectCollection("entryentity");
        if (existsEntryDys.size() != latestEntryDys.size()) {
            return false;
        }
        List existsAttItemIds = existsEntryDys.stream().map(existsEntryDy -> WTCDynamicObjectUtils.getBaseDataId((DynamicObject)existsEntryDy, (String)"attitem")).collect(Collectors.toList());
        List latestAttItemIds = latestEntryDys.stream().map(latestEntryDy -> WTCDynamicObjectUtils.getBaseDataId((DynamicObject)latestEntryDy, (String)"attitem")).collect(Collectors.toList());
        if (!latestAttItemIds.containsAll(existsAttItemIds)) {
            return false;
        }
        for (DynamicObject existsEntryDy2 : existsEntryDys) {
            long existsAttItemId = WTCDynamicObjectUtils.getBaseDataId((DynamicObject)existsEntryDy2, (String)"attitem");
            String existsValue = existsEntryDy2.getString("value");
            for (DynamicObject latestEntryDy2 : latestEntryDys) {
                long latestAttItemId = WTCDynamicObjectUtils.getBaseDataId((DynamicObject)latestEntryDy2, (String)"attitem");
                if (existsAttItemId != latestAttItemId || existsValue.equals(latestEntryDy2.getString("value"))) continue;
                return false;
            }
        }
        return true;
    }

    private List<DynamicObject> genLatestConfirmBillDy(List<AttConfirmRecordModel> modelList, Map<Long, Map<String, Map<Long, String>>> attItemDetailMap, Map<Long, Map<String, Map<Long, BigDecimal>>> attItemPeriodMap, Map<Long, String> perAttPeriodMap, HRBaseServiceHelper helper) {
        ArrayList<DynamicObject> dys = new ArrayList<DynamicObject>(10);
        MainEntityType dataEntityType = MetadataServiceHelper.getDataEntityType((String)"wtam_attconfirmbill");
        for (AttConfirmRecordModel recordModel : modelList) {
            Map<Long, BigDecimal> periodAttItemMap;
            Map<String, Map<Long, BigDecimal>> currentMap;
            DynamicObject entryDy;
            DynamicObject emptyDy = new DynamicObject((DynamicObjectType)dataEntityType);
            emptyDy.set("attconrecord", (Object)recordModel.getId());
            DynamicObjectCollection entryDys = emptyDy.getDynamicObjectCollection("entryentity");
            if (AttConRecordTypeEnum.BY_DATE == recordModel.getType()) {
                Map<Long, String> specifyDateMap;
                Map<String, Map<Long, String>> specifyFileMap;
                if (attItemDetailMap != null && attItemDetailMap.size() > 0 && (specifyFileMap = attItemDetailMap.get(recordModel.getAttFile())) != null && specifyFileMap.size() > 0 && (specifyDateMap = specifyFileMap.get(HRDateTimeUtils.format((Date)recordModel.getStartDate(), (String)"yyyy-MM-dd"))) != null && specifyDateMap.size() > 0) {
                    for (Map.Entry<Long, Object> entry : specifyDateMap.entrySet()) {
                        entryDy = entryDys.addNew();
                        entryDy.set("attitem", (Object)entry.getKey());
                        entryDy.set("value", entry.getValue());
                    }
                }
            } else if (attItemPeriodMap != null && attItemPeriodMap.size() > 0 && (currentMap = attItemPeriodMap.get(recordModel.getAttFile())) != null && currentMap.size() > 0 && (periodAttItemMap = currentMap.get(perAttPeriodMap.get(recordModel.getPerAttPeriod()))) != null && periodAttItemMap.size() > 0) {
                for (Map.Entry<Long, Object> entry : periodAttItemMap.entrySet()) {
                    entryDy = entryDys.addNew();
                    entryDy.set("attitem", (Object)entry.getKey());
                    entryDy.set("value", entry.getValue());
                }
            }
            dys.add(emptyDy);
        }
        return dys;
    }

    public Set<String> getRuleNumberSet(Map<String, Object> map, String fNumberStr) {
        return Arrays.stream(map.get(fNumberStr).toString().split(",")).collect(Collectors.toSet());
    }

    public void beforeF7Select(BeforeF7SelectEvent event, IDataModel model, IFormView view, String fieldMsgTemplate, String number, String msgScene) {
        if (fieldMsgTemplate.equals(event.getProperty().getName())) {
            if (model.getValue(msgScene) == null) {
                view.showTipNotification(AttConfirmKDString.getPleaseSelectMsgTplScene());
                event.setCancel(true);
            } else {
                String sceneNumber = model.getDataEntity().getString(number);
                event.getCustomQFilters().add(new QFilter("msgscene", "=", (Object)sceneNumber));
            }
        }
    }

    public void sendMessageWhenAttConRecordInvalidity(List<Long> attConRecordIds, Map<Object, Object> paramsMap) {
        HRBaseServiceHelper serviceHelper = new HRBaseServiceHelper("wtam_attconrecord");
        DynamicObject[] attConRecordDys = serviceHelper.queryOriginalArray("id, attfile.name, creator, attfile.id", new QFilter[]{new QFilter("id", "in", attConRecordIds)});
        if (attConRecordDys == null || attConRecordDys.length == 0) {
            return;
        }
        HRBaseServiceHelper msgTemplateHelper = new HRBaseServiceHelper("msg_template");
        DynamicObject msgTemplateDy = msgTemplateHelper.loadSingle((Object)2036310155682918400L);
        Map<Long, List<DynamicObject>> listMap = Arrays.stream(attConRecordDys).collect(Collectors.groupingBy(dy -> WTCDynamicObjectUtils.getBaseDataId((DynamicObject)dy, (String)"creator")));
        ArrayList messageInfos = Lists.newArrayListWithExpectedSize((int)listMap.size());
        for (Map.Entry<Long, List<DynamicObject>> mapEntry : listMap.entrySet()) {
            List<DynamicObject> value = mapEntry.getValue();
            if (WTCCollections.isEmpty(value)) continue;
            List<Long> currentCreators = value.stream().map(dy -> dy.getLong("id")).collect(Collectors.toList());
            DynamicObject attConRecordDy = value.get(0);
            MessageInfo message = new MessageInfo();
            message.setId(Long.valueOf(DB.genGlobalLongId()));
            message.setUserIds((List)Lists.newArrayList((Object[])new Long[]{mapEntry.getKey()}));
            message.setSenderId(Long.valueOf(UserServiceHelper.getCurrentUserId()));
            message.setType(msgTemplateDy.getString("msgtype"));
            message.setEntityNumber("wtam_attconrecord");
            message.setNotifyType("msgtemplate.msgchannel");
            message.setContentUrl(AttConfirmHelper.buildAttConfirmPushUrl(currentCreators));
            message.setMessageTitle(msgTemplateDy.getLocaleString("msgscenename"));
            LocaleString messageTag = new LocaleString();
            messageTag.setLocaleValue(AttConfirmKDString.getMessageTag());
            message.setMessageTag((ILocaleString)messageTag);
            message.setTemplateNumber(msgTemplateDy.getString("number"));
            message.setMessageContent(msgTemplateDy.getLocaleString("msgtemplate"));
            message.setBizDataId(Long.valueOf(attConRecordDy.getLong("id")));
            messageInfos.add(message);
        }
        MessageCenterServiceHelper.batchSendMessages((List)messageInfos);
    }

    private static String buildAttConfirmPushUrl(List<Long> attConRecordIds) {
        HashMap<String, String> params = new HashMap<String, String>(16);
        params.put("type", "list");
        params.put("formId", "bos_list");
        params.put("billFormId", "wtam_attconrecord");
        params.put("appName", "wtam");
        params.put("style", "model");
        params.put("source", "msgcenter");
        params.put("centerIds", JSON.toJSONString(attConRecordIds));
        return AttConfirmHelper.getInstance().getUrl(params);
    }

    private String getUrl(Map<String, String> params) {
        StringBuilder stringBuilder = new StringBuilder(UrlService.getDomainContextUrl()).append("/?");
        Iterator<Map.Entry<String, String>> iterator = params.entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry<String, String> next = iterator.next();
            if (!HRStringUtils.isNotEmpty((String)next.getValue())) continue;
            stringBuilder.append(next.getKey()).append("=").append(next.getValue());
            if (!iterator.hasNext()) continue;
            stringBuilder.append("&");
        }
        return stringBuilder.toString();
    }

    public boolean checkLastRecordInvalidAndReconfirmed(AttConfirmRecordModel currentModel) {
        DynamicObject attFileDy;
        long employeeId;
        Map<Long, Tuple<Date, Date>> map;
        if (AttConRecordTypeEnum.BY_DATE == currentModel.getType() && AttConfirmDataStatusEnum.EFFECT == currentModel.getDataStatus() && (AttConRecordStatusEnum.GEN == currentModel.getStatus() || AttConRecordStatusEnum.SEND == currentModel.getStatus()) && WTCCollections.isNotEmpty(map = this.getAllAttFileMapWithEmployeeId(employeeId = WTCDynamicObjectUtils.getBaseDataId((DynamicObject)(attFileDy = AttFileQueryServiceImpl.getInstance().queryOneAttFile("employee", (Object)currentModel.getAttFile())), (String)"employee")))) {
            Set<Long> attFileBoIds = map.keySet();
            AttConfirmRecordQueryParam queryParam = new AttConfirmRecordQueryParam();
            queryParam.setAttFileBoIdSet(attFileBoIds);
            QFilter qFilter = new QFilter("createtime", "<=", (Object)currentModel.getCreateTime()).and(new QFilter("id", "!=", (Object)currentModel.getId()));
            queryParam.setCustomQFilter(qFilter);
            queryParam.setStartDate(currentModel.getStartDate());
            queryParam.setEndDate(currentModel.getEndDate());
            queryParam.setQueryNotEffect(true);
            List<AttConfirmRecordModel> recordModels = AttConfirmQueryServiceImpl.getInstance().queryAttConfirmRecordModelList(queryParam);
            AttConfirmRecordModel recordModel = recordModels.stream().max(Comparator.comparing(AttConfirmRecordModel::getCreateTime)).orElse(null);
            if (recordModel != null && AttConfirmDataStatusEnum.INVALID == recordModel.getDataStatus() && recordModel.getReceiver() != 0L && recordModel.getConFirmer() != 0L && recordModel.getConFirmer() == recordModel.getReceiver() && AttConRecordModeEnum.RECEIVER_CONFIRM == recordModel.getConfirmMode()) {
                return true;
            }
        }
        return false;
    }

    private Map<Long, Tuple<Date, Date>> getAllAttFileMapWithEmployeeId(Long employeeId) {
        AttFileQueryParam attFileQueryParam = new AttFileQueryParam();
        attFileQueryParam.setAuthCheck(Boolean.valueOf(false));
        attFileQueryParam.setEmpPersonSetIds(Collections.singleton(employeeId));
        attFileQueryParam.setProperties(this.getNeedQueryColumn());
        Map<Long, List<DynamicObject>> map = AttFileQueryServiceImpl.getInstance().queryAttFiles(attFileQueryParam).stream().collect(Collectors.groupingBy(ob -> ob.getLong("boid")));
        HashMap tupleMap = Maps.newHashMapWithExpectedSize((int)16);
        map.forEach((boid, dynamicObjectList) -> {
            DynamicObject dynamicObject = (DynamicObject)dynamicObjectList.get(0);
            Date startDate = dynamicObject.getDate("startDate");
            Date endDate = dynamicObject.getDate("endDate");
            if (startDate != null && endDate != null) {
                tupleMap.put(boid, new Tuple((Object)startDate, (Object)endDate));
            }
        });
        LOG.info("tupleMap info :{}", (Object)tupleMap);
        return tupleMap;
    }

    private String getNeedQueryColumn() {
        return WTCStringUtils.joinOnComma((String[])new String[]{"boid", "atttag.attendstatus", "endDate", "startDate"});
    }
}

