/*
 * Decompiled with CFR 0.152.
 */
package kd.wtc.wtp.business.attconfirm;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import kd.bos.bill.BillShowParameter;
import kd.bos.bill.OperationStatus;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.ext.hr.ruleengine.controls.TargetCondition;
import kd.bos.ext.hr.ruleengine.infos.RuleConditionInfo;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.IPageCache;
import kd.bos.form.ShowType;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.operate.FormOperate;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.hr.hbp.business.servicehelper.HRBaseServiceHelper;
import kd.wtc.wtbs.business.personfilter.PersonFilterServiceImpl;
import kd.wtc.wtbs.business.personfilter.utils.JudgeConditionService;
import kd.wtc.wtbs.common.util.WTCSerializationUtils;

public class AttConfirmRuleHelper {
    private static final Log LOG = LogFactory.getLog(AttConfirmRuleHelper.class);

    public static AttConfirmRuleHelper getInstance() {
        return SingletonInstance.SINGLETON;
    }

    public void setPersonRange(IFormView view, IDataModel model, IPageCache pageCache, String pageCacheStr, String metaEntity, long id) {
        HRBaseServiceHelper hrBaseServiceHelper = new HRBaseServiceHelper("wtbd_perfilterconfig");
        QFilter qFilter = new QFilter("metanumber", "=", (Object)metaEntity);
        QFilter filter = new QFilter("basedataid", "=", (Object)id);
        DynamicObject conditions = hrBaseServiceHelper.queryOne("conditions", new QFilter[]{qFilter, filter});
        FormShowParameter formShowParameter = new FormShowParameter();
        formShowParameter.setStatus(view.getFormShowParameter().getStatus());
        formShowParameter.setFormId("wtbd_personfilter");
        formShowParameter.getOpenStyle().setTargetKey("flexperscope");
        formShowParameter.getOpenStyle().setShowType(ShowType.InContainer);
        if (!"A".equals(model.getDataEntity().get("status"))) {
            formShowParameter.setStatus(OperationStatus.VIEW);
        }
        view.showForm(formShowParameter);
        String pageId = formShowParameter.getPageId();
        pageCache.put(pageCacheStr, pageId);
        if (Objects.nonNull(conditions)) {
            IFormView childView = view.getView(pageId);
            TargetCondition targetCondition = (TargetCondition)childView.getControl("targetconditionap");
            targetCondition.setValue(conditions.getString("conditions"));
        }
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs args, IPageCache pageCache, IFormView view, String pageCacheId) {
        String operateKey = ((FormOperate)args.getSource()).getOperateKey();
        boolean contains = Arrays.asList("save", "submit", "submitandaudit").contains(operateKey);
        if (!contains) {
            return;
        }
        String childPageId = pageCache.get(pageCacheId);
        IFormView childView = view.getView(childPageId);
        TargetCondition targetCondition = (TargetCondition)childView.getControl("targetconditionap");
        String value = targetCondition.getValue();
        if (value != null) {
            if (value.contains("is_or_isSub")) {
                view.showTipNotification(ResManager.loadKDString((String)"\u6682\u4e0d\u652f\u6301\u201c\u7b49\u4e8e/...\u7684\u4e0b\u7ea7\u201d\uff0c\u8bf7\u91cd\u65b0\u9009\u62e9\u5176\u4ed6\u9009\u9879\u3002", (String)"AttConfirmRuleHelper_1", (String)"wtc-wtp-formplugin", (Object[])new Object[0]));
                args.setCancel(true);
                return;
            }
            RuleConditionInfo accessDto = (RuleConditionInfo)WTCSerializationUtils.fromJsonString((String)value, RuleConditionInfo.class);
            List conditionExpressList = accessDto.getConditionExpressList();
            if (CollectionUtils.isEmpty((Collection)conditionExpressList)) {
                view.showTipNotification(ResManager.loadKDString((String)"\u8bf7\u6309\u8981\u6c42\u586b\u5199\u201c\u4eba\u5458\u8303\u56f4\u201d\u3002", (String)"AttConfirmRuleHelper_2", (String)"wtc-wtp-formplugin", (Object[])new Object[0]));
                args.setCancel(true);
                return;
            }
        } else {
            view.showTipNotification(ResManager.loadKDString((String)"\u8bf7\u6309\u8981\u6c42\u586b\u5199\u201c\u4eba\u5458\u8303\u56f4\u201d\u3002", (String)"AttConfirmRuleHelper_2", (String)"wtc-wtp-formplugin", (Object[])new Object[0]));
            args.setCancel(true);
            return;
        }
        Map stringObjectMap = JudgeConditionService.checkConfigJson((String)value);
        if (!stringObjectMap.isEmpty() && !((Boolean)stringObjectMap.get("isSucess")).booleanValue()) {
            view.showTipNotification(stringObjectMap.get("errorMsg").toString());
            args.setCancel(true);
        }
    }

    public void afterDoOperation(AfterDoOperationEventArgs afterDoOperationEventArgs, IPageCache pageCache, IFormView view, IDataModel model, String pageCacheId) {
        String operateKey = afterDoOperationEventArgs.getOperateKey();
        List<String> operate = Arrays.asList("save", "submit", "submitandaudit");
        List<String> otherOperate = Arrays.asList("unsubmit", "unaudit");
        if (operate.contains(operateKey)) {
            boolean isSuccess = afterDoOperationEventArgs.getOperationResult().isSuccess();
            if (!isSuccess) {
                return;
            }
            String childPageId = pageCache.get(pageCacheId);
            IFormView childView = view.getView(childPageId);
            TargetCondition targetCondition = (TargetCondition)childView.getControl("targetconditionap");
            String value = targetCondition.getValue();
            Long pkValue = (Long)model.getDataEntity().getPkValue();
            if (value != null) {
                try (TXHandle txHandle = TX.required();){
                    String formId = ((BillShowParameter)view.getFormShowParameter()).getFormId();
                    PersonFilterServiceImpl.getInstance().updateConfig(formId, value, pkValue);
                    HRBaseServiceHelper exPushHelper = new HRBaseServiceHelper(formId);
                    long id = model.getDataEntity().getLong("id");
                    QFilter qFilter = new QFilter("id", "=", (Object)id);
                    DynamicObject configDyn = exPushHelper.loadDynamicObject(new QFilter[]{qFilter, qFilter});
                    if (configDyn != null) {
                        exPushHelper.updateOne(configDyn);
                    }
                }
            }
            view.updateView();
        }
        if ("pusnewentry".equals(operateKey)) {
            int size = model.getEntryEntity("pussetentity").size();
            if (size == 0) {
                view.setEnable(Boolean.FALSE, size, new String[]{"recipientplugin"});
            } else {
                view.setEnable(Boolean.FALSE, size - 1, new String[]{"recipientplugin"});
            }
        }
        if (otherOperate.contains(operateKey)) {
            view.updateView();
        }
    }

    private static class SingletonInstance {
        private static final AttConfirmRuleHelper SINGLETON = new AttConfirmRuleHelper();

        private SingletonInstance() {
        }
    }
}

