/*
 * Decompiled with CFR 0.152.
 */
package kd.wtc.wtp.business.attconfirm.impl;

import com.alibaba.fastjson.JSON;
import java.math.BigDecimal;
import java.time.LocalDate;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.db.DB;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.entity.MainEntityType;
import kd.bos.exception.KDBizException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.MetadataServiceHelper;
import kd.hr.hbp.business.servicehelper.HRBaseServiceHelper;
import kd.wtc.wtbs.business.servicehelper.WTCServiceHelper;
import kd.wtc.wtbs.business.util.WTCDynamicObjectUtils;
import kd.wtc.wtbs.business.web.file.AttFileQueryServiceImpl;
import kd.wtc.wtbs.common.helper.WTCAppContextHelper;
import kd.wtc.wtbs.common.helper.WTCValidatorHelper;
import kd.wtc.wtbs.common.model.attfile.AttFileF7QueryParam;
import kd.wtc.wtbs.common.model.period.PerAttPeriod;
import kd.wtc.wtbs.common.util.Tuple;
import kd.wtc.wtbs.common.util.WTCCollections;
import kd.wtc.wtbs.common.util.WTCDateUtils;
import kd.wtc.wtbs.common.util.WTCStringUtils;
import kd.wtc.wtbs.common.util.third.collect.Lists;
import kd.wtc.wtbs.common.util.third.collect.Maps;
import kd.wtc.wtbs.common.util.third.collect.Sets;
import kd.wtc.wtp.business.attconfirm.AttConfirmHelper;
import kd.wtc.wtp.business.attconfirm.IAttConfirmOpService;
import kd.wtc.wtp.business.attconfirm.impl.AttConfirmQueryServiceImpl;
import kd.wtc.wtp.business.attconfirm.impl.AttConfirmRuleServiceImpl;
import kd.wtc.wtp.business.attstateinfo.AttStateInfoService;
import kd.wtc.wtp.common.enums.attconfirm.AttConDayTypeEnum;
import kd.wtc.wtp.common.enums.attconfirm.AttConRecordDataSourceEnum;
import kd.wtc.wtp.common.enums.attconfirm.AttConRecordStatusEnum;
import kd.wtc.wtp.common.enums.attconfirm.AttConRecordTypeEnum;
import kd.wtc.wtp.common.enums.attconfirm.AttConfirmDataStatusEnum;
import kd.wtc.wtp.common.enums.attconfirm.AttConfirmRecordOpEnum;
import kd.wtc.wtp.common.kdstring.AttConfirmKDString;
import kd.wtc.wtp.common.model.attconfirm.AttConfirmRecordGenModel;
import kd.wtc.wtp.common.model.attconfirm.AttConfirmRecordModel;
import kd.wtc.wtp.common.model.attconfirm.AttConfirmRecordOpParam;
import kd.wtc.wtp.common.model.attconfirm.AttConfirmRecordOpResult;
import kd.wtc.wtp.common.model.attconfirm.AttConfirmRecordQueryParam;
import kd.wtc.wtp.common.model.attconfirm.AttConfirmRecordTipsModel;
import kd.wtc.wtp.common.model.attstateinfo.AttStateInfoBO;

public class AttConfirmAddOpServiceImpl
implements IAttConfirmOpService {
    private static final Log LOG = LogFactory.getLog(AttConfirmAddOpServiceImpl.class);

    public static AttConfirmAddOpServiceImpl getInstance() {
        return (AttConfirmAddOpServiceImpl)WTCAppContextHelper.getBean(AttConfirmAddOpServiceImpl.class);
    }

    @Override
    public AttConfirmRecordOpResult opAttConfirmRecord(AttConfirmRecordOpParam attConfirmRecordOpParam) {
        AttConfirmRecordGenModel genModel;
        HRBaseServiceHelper checkQueryService = new HRBaseServiceHelper("wtam_attconrecord");
        if (checkQueryService.isExists(new QFilter("datastatus", "=", (Object)Character.valueOf(' ')))) {
            throw new KDBizException(AttConfirmKDString.checkUpgradeSuccess());
        }
        if (LOG.isInfoEnabled() && null != (genModel = attConfirmRecordOpParam.getAttConfirmRecordGenModel())) {
            LOG.info("opAttConfirmRecord# genScope:{},confirmScope:{},type:{},overHandleType:{},fileBoIdSet:{},personIdSet:{}", new Object[]{genModel.getGenScope(), genModel.getConfirmScope(), genModel.getType(), genModel.getOverHandleType(), genModel.getFileBoIdSet(), genModel.getPersonIdSet()});
        }
        AttConfirmRecordGenModel attConfirmRecordGenModel = attConfirmRecordOpParam.getAttConfirmRecordGenModel();
        WTCValidatorHelper.verify((Object)attConfirmRecordGenModel);
        Set fileBoIdSet = attConfirmRecordGenModel.getFileBoIdSet();
        AttConRecordTypeEnum type = attConfirmRecordGenModel.getType();
        List<AttConfirmRecordModel> existAttConfirmRecordModelList = this.getExistRecordModelMap(attConfirmRecordGenModel, fileBoIdSet, type);
        Map<Long, AttStateInfoBO> attStateInfoMap = AttStateInfoService.getInstance().queryAttStateInfoByBoid(new ArrayList<Long>(fileBoIdSet)).stream().collect(Collectors.toMap(AttStateInfoBO::getFileBoid, Function.identity(), (a, b) -> a));
        HashMap genAttConfirmRecordModelMap = Maps.newHashMapWithExpectedSize((int)fileBoIdSet.size());
        if (AttConRecordTypeEnum.BY_DATE == type) {
            this.genByDate(attConfirmRecordGenModel, fileBoIdSet, existAttConfirmRecordModelList, attStateInfoMap, genAttConfirmRecordModelMap);
        } else {
            this.genByPerAttPeriod(attConfirmRecordGenModel, fileBoIdSet, existAttConfirmRecordModelList, attStateInfoMap, genAttConfirmRecordModelMap);
        }
        List addIdAttConfirmRecordModelList = genAttConfirmRecordModelMap.values().stream().flatMap(Collection::stream).collect(Collectors.toList());
        if (LOG.isInfoEnabled()) {
            LOG.info("opAttConfirmRecord#addIdAttConfirmRecordModelList:{}", (Object)addIdAttConfirmRecordModelList.size());
        }
        long[] longs = DB.genGlobalLongIds((int)addIdAttConfirmRecordModelList.size());
        for (int i = 0; i < addIdAttConfirmRecordModelList.size(); ++i) {
            AttConfirmRecordModel model = (AttConfirmRecordModel)addIdAttConfirmRecordModelList.get(i);
            model.setId(longs[i]);
        }
        List<AttConfirmRecordModel> billAttConfirmRecordModelList = addIdAttConfirmRecordModelList.stream().filter(d -> d.getOpStatus() == Boolean.TRUE).collect(Collectors.toList());
        if (LOG.isInfoEnabled()) {
            LOG.info("opAttConfirmRecord#billAttConfirmRecordModelList:{}", (Object)billAttConfirmRecordModelList.size());
        }
        List<DynamicObject> attConfirmBillDyList = AttConfirmHelper.getInstance().genAttConfirmBillHisData(billAttConfirmRecordModelList, false);
        if (attConfirmRecordGenModel.isZeroItemNoGen()) {
            Iterator<DynamicObject> iterator = attConfirmBillDyList.iterator();
            HashSet billNoItemSet = Sets.newHashSetWithExpectedSize((int)attConfirmBillDyList.size());
            while (iterator.hasNext()) {
                DynamicObject next = iterator.next();
                if (next == null) continue;
                DynamicObjectCollection dynamicObjectCollection = next.getDynamicObjectCollection("entryentity");
                if (dynamicObjectCollection == null || dynamicObjectCollection.isEmpty()) {
                    long baseDataId = WTCDynamicObjectUtils.getBaseDataId((DynamicObject)next, (String)"attconrecord");
                    billNoItemSet.add(baseDataId);
                    iterator.remove();
                    continue;
                }
                BigDecimal sum = BigDecimal.ZERO;
                for (DynamicObject dynamicObject : dynamicObjectCollection) {
                    String itemValue = dynamicObject.getString("value");
                    if (WTCStringUtils.isEmpty((String)itemValue)) continue;
                    BigDecimal v = BigDecimal.valueOf(Double.parseDouble(itemValue));
                    sum = sum.add(v);
                }
                if (sum.compareTo(BigDecimal.ZERO) != 0) continue;
                long baseDataId = WTCDynamicObjectUtils.getBaseDataId((DynamicObject)next, (String)"attconrecord");
                billNoItemSet.add(baseDataId);
                iterator.remove();
            }
            if (WTCCollections.isNotEmpty((Collection)billNoItemSet)) {
                for (AttConfirmRecordModel attConfirmRecordModel : addIdAttConfirmRecordModelList) {
                    if (!billNoItemSet.contains(attConfirmRecordModel.getId())) continue;
                    attConfirmRecordModel.setOpStatus(null);
                    attConfirmRecordModel.setMsg(AttConfirmKDString.getItemNoResultTips());
                }
            }
        }
        List saveAttConfirmRecordModelList = addIdAttConfirmRecordModelList.stream().filter(e -> e.getOpStatus() == Boolean.TRUE).collect(Collectors.toList());
        if (LOG.isInfoEnabled()) {
            LOG.info("opAttConfirmRecord#saveAttConfirmRecordModelList:{}", (Object)saveAttConfirmRecordModelList.size());
        }
        HRBaseServiceHelper queryService = new HRBaseServiceHelper("wtam_attconrecord");
        long currUserId = RequestContext.get().getCurrUserId();
        Date date = new Date();
        TXHandle txHandle = TX.required();
        HRBaseServiceHelper helper = new HRBaseServiceHelper("wtam_attconfirmbill");
        MainEntityType dataEntityType = MetadataServiceHelper.getDataEntityType((String)"wtam_attconrecord");
        try {
            queryService.save((DynamicObject[])saveAttConfirmRecordModelList.stream().map(d -> this.genAttConfirmRecordDy(currUserId, date, (AttConfirmRecordModel)d, dataEntityType)).toArray(DynamicObject[]::new));
            AttConfirmHelper.getInstance().saveAttConfirmBill(helper, attConfirmBillDyList);
        }
        catch (Exception ex) {
            txHandle.markRollback();
            LOG.warn("AttConfirmPushOpServiceImpl error :", (Throwable)ex);
            throw new KDBizException(AttConfirmKDString.getSystemErrorTips());
        }
        finally {
            txHandle.close();
        }
        if (WTCCollections.isNotEmpty(addIdAttConfirmRecordModelList) && addIdAttConfirmRecordModelList.size() < 10 && LOG.isInfoEnabled()) {
            LOG.info("AttConfirmRecordAddResult json {}", (Object)JSON.toJSONString(addIdAttConfirmRecordModelList));
        }
        Map<Long, List<AttConfirmRecordModel>> culResultMap = addIdAttConfirmRecordModelList.stream().collect(Collectors.groupingBy(AttConfirmRecordModel::getAttFile));
        AttConfirmRecordOpResult attConfirmRecordOpResult = this.getAttConfirmRecordOpResult(fileBoIdSet, culResultMap);
        attConfirmRecordOpResult.setOp(AttConfirmRecordOpEnum.ADD);
        return attConfirmRecordOpResult;
    }

    private DynamicObject genAttConfirmRecordDy(long currUserId, Date date, AttConfirmRecordModel attConfirmRecordModel, MainEntityType dataEntityType) {
        DynamicObject dynamicObject = new DynamicObject((DynamicObjectType)dataEntityType);
        dynamicObject.set("id", (Object)attConfirmRecordModel.getId());
        dynamicObject.set("attfile", (Object)attConfirmRecordModel.getAttFile());
        dynamicObject.set("attfileversion", (Object)attConfirmRecordModel.getAttFileVersion());
        dynamicObject.set("type", (Object)attConfirmRecordModel.getType().getCode());
        dynamicObject.set("confirmendtime", (Object)attConfirmRecordModel.getConfirmEndTime());
        dynamicObject.set("overhandletype", (Object)attConfirmRecordModel.getOverHandleType().getCode());
        dynamicObject.set("enddate", (Object)attConfirmRecordModel.getEndDate());
        dynamicObject.set("startdate", (Object)attConfirmRecordModel.getStartDate());
        dynamicObject.set("perattperiod", (Object)attConfirmRecordModel.getPerAttPeriod());
        dynamicObject.set("confirmlock", (Object)attConfirmRecordModel.isConfirmLock());
        dynamicObject.set("showlast", (Object)attConfirmRecordModel.isShowLast());
        dynamicObject.set("creator", (Object)currUserId);
        dynamicObject.set("createtime", (Object)date);
        dynamicObject.set("status", (Object)AttConRecordStatusEnum.GEN.getCode());
        dynamicObject.set("receiver", (Object)attConfirmRecordModel.getReceiver());
        dynamicObject.set("confirmendtime", (Object)attConfirmRecordModel.getConfirmEndTime());
        dynamicObject.set("datastatus", (Object)attConfirmRecordModel.getDataStatus().getCode());
        AttConRecordDataSourceEnum genDataSource = attConfirmRecordModel.getGenDataSource();
        if (null != genDataSource) {
            dynamicObject.set("source", (Object)genDataSource.getCode());
        }
        dynamicObject.set("genrule", (Object)attConfirmRecordModel.getGenRuleId());
        return dynamicObject;
    }

    private AttConfirmRecordOpResult getAttConfirmRecordOpResult(Set<Long> fileBoIdSet, Map<Long, List<AttConfirmRecordModel>> genAttConfirmRecordModelMap) {
        HashSet notRunSet = Sets.newHashSetWithExpectedSize((int)fileBoIdSet.size());
        HashSet successRunSet = Sets.newHashSetWithExpectedSize((int)fileBoIdSet.size());
        HashSet failRunSet = Sets.newHashSetWithExpectedSize((int)fileBoIdSet.size());
        HashSet partSuccessRunSet = Sets.newHashSetWithExpectedSize((int)fileBoIdSet.size());
        ArrayList attConfirmRecordTipsModels = Lists.newArrayListWithExpectedSize((int)(fileBoIdSet.size() * 10));
        genAttConfirmRecordModelMap.forEach((k, v) -> {
            if (WTCCollections.isEmpty((Collection)v)) {
                notRunSet.add(k);
            } else {
                long countNotRun = v.stream().filter(d -> d.getOpStatus() == null).count();
                long countRunSuccess = v.stream().filter(d -> d.getOpStatus() == Boolean.TRUE).count();
                for (AttConfirmRecordModel attConfirmRecordModel : v) {
                    if (Boolean.TRUE == attConfirmRecordModel.getOpStatus()) continue;
                    attConfirmRecordTipsModels.add(new AttConfirmRecordTipsModel(attConfirmRecordModel.getName(), attConfirmRecordModel.getPersonNum(), attConfirmRecordModel.getStartDate(), attConfirmRecordModel.getEndDate(), attConfirmRecordModel.getMsg(), attConfirmRecordModel.getFileNumber()));
                }
                if (countRunSuccess > 0L) {
                    if (countRunSuccess == (long)v.size()) {
                        successRunSet.add(k);
                    } else {
                        partSuccessRunSet.add(k);
                    }
                } else if (countNotRun == (long)v.size()) {
                    notRunSet.add(k);
                } else {
                    failRunSet.add(k);
                }
            }
        });
        AttConfirmRecordOpResult attConfirmRecordOpResult = new AttConfirmRecordOpResult();
        attConfirmRecordOpResult.setFailCount(failRunSet.size());
        attConfirmRecordOpResult.setNoRunCount(notRunSet.size());
        attConfirmRecordOpResult.setSuccessCount(successRunSet.size());
        attConfirmRecordOpResult.setTotalCount(fileBoIdSet.size());
        attConfirmRecordOpResult.setPartSuccessCount(partSuccessRunSet.size());
        attConfirmRecordOpResult.setName(AttConfirmKDString.getOpResultNameFile());
        attConfirmRecordOpResult.setUnit(AttConfirmKDString.getOpResultUnitFile());
        attConfirmRecordOpResult.setAttConfirmRecordTipsModels((List)attConfirmRecordTipsModels);
        return attConfirmRecordOpResult;
    }

    private void genByPerAttPeriod(AttConfirmRecordGenModel attConfirmRecordGenModel, Set<Long> fileBoIdSet, List<AttConfirmRecordModel> existAttConfirmRecordModelList, Map<Long, AttStateInfoBO> attStateInfoMap, Map<Long, List<AttConfirmRecordModel>> genAttConfirmRecordModelMap) {
        Integer confirmLimit = (Integer)attConfirmRecordGenModel.getConfirmScope().getKey();
        if (confirmLimit == null) {
            confirmLimit = 0;
        }
        Date confirmEndDate = WTCDateUtils.addDays((Date)WTCDateUtils.getZeroDate((Date)new Date()), (int)confirmLimit);
        Set perAttPeriodSet = attConfirmRecordGenModel.getPerAttPeriodSet();
        Map<Long, List<PerAttPeriod>> perAttPeriodMap = perAttPeriodSet.stream().collect(Collectors.groupingBy(PerAttPeriod::getFileBoId));
        Map<Long, Long> personToUserIdMap = this.getPersonToUserIdMap(perAttPeriodSet.stream().map(PerAttPeriod::getPersonId).collect(Collectors.toList()));
        Map fileBaseDataMap = AttFileQueryServiceImpl.getInstance().queryAttFileByIds("boid,name,personnum,number", new ArrayList<Long>(fileBoIdSet)).stream().collect(Collectors.toMap(d -> d.getLong("boid"), Function.identity(), (a, b) -> a));
        Map<Long, Set<Long>> authPeriodEntryByPerson = this.getAuthPeriodEntryByPerson(attConfirmRecordGenModel, perAttPeriodSet);
        for (Long fileBoId : fileBoIdSet) {
            List attConfirmRecordModelList = genAttConfirmRecordModelMap.computeIfAbsent(fileBoId, key -> Lists.newArrayListWithExpectedSize((int)10));
            List<PerAttPeriod> perAttPeriodList = perAttPeriodMap.get(fileBoId);
            DynamicObject fileBaseDy = (DynamicObject)fileBaseDataMap.get(fileBoId);
            if (fileBaseDy == null) continue;
            String name = fileBaseDy.getString("name");
            String fileNumber = fileBaseDy.getString("number");
            String personNum = fileBaseDy.getString("personnum");
            if (WTCCollections.isEmpty(perAttPeriodList)) {
                AttConfirmRecordModel attConfirmRecordModel = new AttConfirmRecordModel();
                attConfirmRecordModelList.add(attConfirmRecordModel);
                attConfirmRecordModel.setAttFile(fileBoId.longValue());
                attConfirmRecordModel.setPersonNum(personNum);
                attConfirmRecordModel.setName(name);
                attConfirmRecordModel.setFileNumber(fileNumber);
                attConfirmRecordModel.setOpStatus(null);
                attConfirmRecordModel.setMsg(AttConfirmKDString.getNoPerAttPeriodTips());
                continue;
            }
            Map existRecordModelMap = existAttConfirmRecordModelList.stream().collect(Collectors.toMap(AttConfirmRecordModel::getPerAttPeriod, Function.identity(), (a, b) -> a));
            for (PerAttPeriod perAttPeriod : perAttPeriodList) {
                AttConfirmRecordModel attConfirmRecordModel = new AttConfirmRecordModel();
                attConfirmRecordModelList.add(attConfirmRecordModel);
                attConfirmRecordModel.setAttFile(fileBoId.longValue());
                attConfirmRecordModel.setPersonNum(personNum);
                attConfirmRecordModel.setName(name);
                attConfirmRecordModel.setFileNumber(fileNumber);
                Date perAttEndDate = perAttPeriod.getPerAttEndDate();
                attConfirmRecordModel.setStartDate(perAttPeriod.getPerAttBeginDate());
                attConfirmRecordModel.setEndDate(perAttEndDate);
                AttConfirmRecordModel existAttConfirmRecordModel = (AttConfirmRecordModel)existRecordModelMap.get(perAttPeriod.getPrimaryId());
                if (existAttConfirmRecordModel != null) {
                    attConfirmRecordModel.setOpStatus(null);
                    attConfirmRecordModel.setMsg(AttConfirmKDString.attConfirmRecordExist());
                    continue;
                }
                if (this.attCalNotEnd(attStateInfoMap, fileBoId, perAttEndDate, attConfirmRecordModel)) continue;
                long personId = perAttPeriod.getPersonId();
                Long userId = personToUserIdMap.get(personId);
                if (userId == null || userId == 0L) {
                    attConfirmRecordModel.setOpStatus(Boolean.FALSE);
                    attConfirmRecordModel.setMsg(AttConfirmKDString.getNotUser());
                    continue;
                }
                Set<Long> authPeriodEntryIdSet = authPeriodEntryByPerson.get(personId);
                if (WTCCollections.isEmpty(authPeriodEntryIdSet) || !authPeriodEntryIdSet.contains(perAttPeriod.getAttPeriodId())) {
                    attConfirmRecordModel.setMsg(AttConfirmKDString.getNotFileAuth());
                    attConfirmRecordModel.setOpStatus(Boolean.FALSE);
                    continue;
                }
                attConfirmRecordModel.setReceiver(userId.longValue());
                this.setBaseProperties(attConfirmRecordGenModel, fileBoId, perAttPeriod.getPerAttBeginDate(), perAttEndDate, attConfirmRecordModel);
                attConfirmRecordModel.setAttFileVersion(perAttPeriod.getFileId().longValue());
                attConfirmRecordModel.setPerAttPeriod(perAttPeriod.getPrimaryId().longValue());
                attConfirmRecordModel.setOpStatus(Boolean.TRUE);
                attConfirmRecordModel.setConfirmEndTime(confirmEndDate);
                this.fillGenSourceAndGenRuleId(attConfirmRecordModel, attConfirmRecordGenModel);
            }
        }
    }

    private Map<Long, Set<Long>> getAuthPeriodEntryByPerson(AttConfirmRecordGenModel attConfirmRecordGenModel, Set<PerAttPeriod> perAttPeriodSet) {
        Map<Long, List<PerAttPeriod>> groupingByPerson = perAttPeriodSet.stream().collect(Collectors.groupingBy(PerAttPeriod::getPersonId));
        HashMap authPeriodEntryByPerson = Maps.newHashMapWithExpectedSize((int)groupingByPerson.size());
        groupingByPerson.forEach((k, v) -> {
            HashSet authPeriodEntryIdSet = Sets.newHashSetWithExpectedSize((int)v.size());
            for (PerAttPeriod perAttPeriod : v) {
                if (!this.checkAttConfirmPeriodAuth(perAttPeriod, attConfirmRecordGenModel)) continue;
                authPeriodEntryIdSet.add(perAttPeriod.getAttPeriodId());
            }
            authPeriodEntryByPerson.put(k, authPeriodEntryIdSet);
        });
        return authPeriodEntryByPerson;
    }

    private boolean checkAttConfirmPeriodAuth(PerAttPeriod perAttPeriod, AttConfirmRecordGenModel attConfirmRecordGenModel) {
        Map attConfirmAuthFileMap = attConfirmRecordGenModel.getAttConfirmAuthFileMap();
        Date attPeriodStartDate = perAttPeriod.getAttPeriodStartDate();
        Date attPeriodEndDate = perAttPeriod.getAttPeriodEndDate();
        Long fileBoId = perAttPeriod.getFileBoId();
        List attConfirmAttFiles = (List)attConfirmAuthFileMap.get(fileBoId);
        for (AttConfirmRecordGenModel.AttConfirmAttFile attConfirmAttFile : attConfirmAttFiles) {
            if (!attConfirmAttFile.isHasAuth()) continue;
            Date startDate = attConfirmAttFile.getStartDate();
            Date endDate = attConfirmAttFile.getEndDate();
            if (attPeriodStartDate.compareTo(endDate) > 0 || attPeriodEndDate.compareTo(startDate) < 0) continue;
            return true;
        }
        return false;
    }

    private void fillGenSourceAndGenRuleId(AttConfirmRecordModel attConfirmRecordModel, AttConfirmRecordGenModel attConfirmRecordGenModel) {
        attConfirmRecordModel.setGenDataSource(attConfirmRecordGenModel.getGenSource());
        attConfirmRecordModel.setGenRuleId(attConfirmRecordGenModel.getGenRuleId());
    }

    private void genByDate(AttConfirmRecordGenModel attConfirmRecordGenModel, Set<Long> fileBoIdSet, List<AttConfirmRecordModel> existAttConfirmRecordModelList, Map<Long, AttStateInfoBO> attStateInfoMap, Map<Long, List<AttConfirmRecordModel>> genAttConfirmRecordModelMap) {
        List dataScope = attConfirmRecordGenModel.getDataScope();
        Integer confirmLimit = (Integer)attConfirmRecordGenModel.getConfirmScope().getKey();
        if (confirmLimit == null) {
            confirmLimit = 0;
        }
        Date confirmEndDate = WTCDateUtils.addDays((Date)WTCDateUtils.getZeroDate((Date)new Date()), (int)confirmLimit);
        HashMap rosterWorkLimitDataMap = Maps.newHashMapWithExpectedSize((int)fileBoIdSet.size());
        if (WTCCollections.isEmpty((Collection)dataScope)) {
            Tuple genScope = attConfirmRecordGenModel.getGenScope();
            if (genScope == null) {
                return;
            }
            AttConDayTypeEnum value = (AttConDayTypeEnum)genScope.getValue();
            Integer confirmDateLimit = (Integer)genScope.getKey();
            if (confirmDateLimit == null) {
                confirmDateLimit = 0;
            }
            if (AttConDayTypeEnum.WORK == value) {
                rosterWorkLimitDataMap.putAll(AttConfirmRuleServiceImpl.getInstance().queryRosterWorkLimitData(fileBoIdSet, confirmDateLimit));
                if (LOG.isInfoEnabled()) {
                    HashMap logMap = new HashMap();
                    int ct = 0;
                    for (Map.Entry entry : rosterWorkLimitDataMap.entrySet()) {
                        if (ct >= 10) break;
                        logMap.put(entry.getKey(), entry.getValue());
                        ++ct;
                    }
                    LOG.info("AttConfirmAddOpServiceImpl#AttConDayTypeEnum.WORK:{}", (Object)JSON.toJSONString(logMap));
                }
            } else if (AttConDayTypeEnum.NORMAL == value) {
                Date nowDate = WTCDateUtils.getZeroDate((Date)new Date());
                for (int i = confirmDateLimit.intValue(); i > 0; --i) {
                    Date date = WTCDateUtils.addDays((Date)nowDate, (int)(-i));
                    dataScope.add(date);
                }
            }
        }
        Map fileBaseDataMap = AttFileQueryServiceImpl.getInstance().queryAttFileByIds("boid,name,personnum,number", new ArrayList<Long>(fileBoIdSet)).stream().collect(Collectors.toMap(d -> d.getLong("boid"), Function.identity(), (a, b) -> a));
        Map attConfirmAuthFileMap = attConfirmRecordGenModel.getAttConfirmAuthFileMap();
        Set<Long> authPersonId = this.getAuthPersonIds(attConfirmRecordGenModel.getPersonIdSet());
        Map<Long, Long> personToUserIdMap = this.getPersonToUserIdMap(new ArrayList<Long>(attConfirmRecordGenModel.getPersonIdSet()));
        Map<Long, List<AttConfirmRecordModel>> existRecordModelMap = existAttConfirmRecordModelList.stream().collect(Collectors.groupingBy(AttConfirmRecordModel::getAttFile));
        for (Long l : fileBoIdSet) {
            DynamicObject fileBaseDy;
            List attConfirmRecordModelList = genAttConfirmRecordModelMap.computeIfAbsent(l, key -> Lists.newArrayListWithExpectedSize((int)10));
            List<AttConfirmRecordModel> recordModelList = existRecordModelMap.get(l);
            HashMap checkMap = Maps.newHashMapWithExpectedSize((int)16);
            if (WTCCollections.isNotEmpty(recordModelList)) {
                recordModelList.forEach(d -> checkMap.put(d.getStartDate(), d));
            }
            if (WTCCollections.isEmpty((Collection)dataScope) && null == (dataScope = (List)rosterWorkLimitDataMap.get(l)) || (fileBaseDy = (DynamicObject)fileBaseDataMap.get(l)) == null) continue;
            String name = fileBaseDy.getString("name");
            String personNum = fileBaseDy.getString("personnum");
            String fileNumber = fileBaseDy.getString("number");
            for (Date date : dataScope) {
                AttConfirmRecordModel attConfirmRecordModel = new AttConfirmRecordModel();
                attConfirmRecordModel.setAttFile(l.longValue());
                attConfirmRecordModelList.add(attConfirmRecordModel);
                attConfirmRecordModel.setStartDate(date);
                attConfirmRecordModel.setEndDate(date);
                attConfirmRecordModel.setName(name);
                attConfirmRecordModel.setFileNumber(fileNumber);
                attConfirmRecordModel.setPersonNum(personNum);
                if (checkMap.get(date) != null) {
                    attConfirmRecordModel.setOpStatus(null);
                    attConfirmRecordModel.setMsg(AttConfirmKDString.attConfirmRecordExist());
                    continue;
                }
                if (this.attCalNotEnd(attStateInfoMap, l, date, attConfirmRecordModel)) continue;
                this.setBaseProperties(attConfirmRecordGenModel, l, date, date, attConfirmRecordModel);
                attConfirmRecordModel.setPerAttPeriod(0L);
                List attConfirmAttFiles = (List)attConfirmAuthFileMap.get(l);
                Optional<AttConfirmRecordGenModel.AttConfirmAttFile> first = attConfirmAttFiles.stream().filter(d -> d.getStartDate().compareTo(date) <= 0 && d.getEndDate().compareTo(date) >= 0).findFirst();
                boolean present = first.isPresent();
                if (!present) {
                    attConfirmRecordModel.setMsg(AttConfirmKDString.getNotFileVersion());
                    attConfirmRecordModel.setOpStatus(Boolean.FALSE);
                    continue;
                }
                AttConfirmRecordGenModel.AttConfirmAttFile attConfirmAttFile = first.get();
                attConfirmRecordModel.setAttFileVersion(attConfirmAttFile.getId());
                if (!authPersonId.contains(attConfirmAttFile.getPersonId())) {
                    attConfirmRecordModel.setMsg(AttConfirmKDString.getNotFileVersionAuth());
                    attConfirmRecordModel.setOpStatus(Boolean.FALSE);
                    continue;
                }
                long personId = attConfirmAttFile.getPersonId();
                Long userId = personToUserIdMap.get(personId);
                if (userId == null || userId == 0L) {
                    attConfirmRecordModel.setOpStatus(Boolean.FALSE);
                    attConfirmRecordModel.setMsg(AttConfirmKDString.getNotUser());
                    continue;
                }
                attConfirmRecordModel.setOpStatus(Boolean.TRUE);
                attConfirmRecordModel.setReceiver(userId.longValue());
                attConfirmRecordModel.setConfirmEndTime(confirmEndDate);
                this.fillGenSourceAndGenRuleId(attConfirmRecordModel, attConfirmRecordGenModel);
            }
        }
    }

    private Set<Long> getAuthPersonIds(Set<Long> filePersonIdSet) {
        AttFileF7QueryParam attFileQueryParam = new AttFileF7QueryParam();
        attFileQueryParam.setPersonSetIds(filePersonIdSet);
        attFileQueryParam.setProperties("person.id");
        attFileQueryParam.setPermField("attfileversion");
        attFileQueryParam.setAppId("wtam");
        attFileQueryParam.setFormId("wtam_attconrecord");
        return AttFileQueryServiceImpl.getInstance().queryAttFilesByCustomAuth(attFileQueryParam).stream().map(d -> d.getLong("person.id")).collect(Collectors.toSet());
    }

    private Map<Long, Long> getPersonToUserIdMap(List<Long> personIdList) {
        HashMap personToUserIdMap = Maps.newHashMapWithExpectedSize((int)personIdList.size());
        HashMap<String, List<Long>> idMaps = new HashMap<String, List<Long>>(16);
        idMaps.put("person", personIdList);
        Map userInfo = (Map)WTCServiceHelper.invokeHRMPService((String)"hrpi", (String)"IHRPIPersonService", (String)"getUserIdByPersonInfo", (Object[])new Object[]{idMaps});
        if (userInfo != null && ((Boolean)userInfo.get("success")).booleanValue() && userInfo.get("data") != null) {
            Map userData = (Map)userInfo.get("data");
            userData.forEach((k, v) -> {
                Map userDataMap;
                Long userId;
                if (k != 0L && v != null && (userId = (Long)(userDataMap = (Map)v).get("user")) != 0L) {
                    personToUserIdMap.put(k, userId);
                }
            });
        }
        return personToUserIdMap;
    }

    private boolean attCalNotEnd(Map<Long, AttStateInfoBO> attStateInfoMap, Long fileBoId, Date endDate, AttConfirmRecordModel attConfirmRecordModel) {
        AttStateInfoBO attStateInfoBO = attStateInfoMap.get(fileBoId);
        if (attStateInfoBO == null || attStateInfoBO.getAccountTo() == null) {
            attConfirmRecordModel.setMsg(AttConfirmKDString.getAttCalNotEnd());
            attConfirmRecordModel.setOpStatus(Boolean.FALSE);
            return true;
        }
        Date accountTo = WTCDateUtils.getZeroDate((Date)attStateInfoBO.getAccountTo());
        if (accountTo.before(endDate)) {
            attConfirmRecordModel.setMsg(AttConfirmKDString.getAttCalNotEnd());
            attConfirmRecordModel.setOpStatus(Boolean.FALSE);
            return true;
        }
        return false;
    }

    private void setBaseProperties(AttConfirmRecordGenModel attConfirmRecordGenModel, Long fileBoId, Date startDate, Date endDate, AttConfirmRecordModel attConfirmRecordModel) {
        attConfirmRecordModel.setType(attConfirmRecordGenModel.getType());
        attConfirmRecordModel.setStartDate(startDate);
        attConfirmRecordModel.setEndDate(endDate);
        attConfirmRecordModel.setConfirmLock(attConfirmRecordGenModel.isConfirmLock());
        attConfirmRecordModel.setShowLast(attConfirmRecordGenModel.isShowLast());
        attConfirmRecordModel.setAttFile(fileBoId.longValue());
        attConfirmRecordModel.setType(attConfirmRecordGenModel.getType());
        attConfirmRecordModel.setOverHandleType(attConfirmRecordGenModel.getOverHandleType());
        attConfirmRecordModel.setStatus(AttConRecordStatusEnum.GEN);
        attConfirmRecordModel.setDataStatus(AttConfirmDataStatusEnum.EFFECT);
    }

    private List<AttConfirmRecordModel> getExistRecordModelMap(AttConfirmRecordGenModel attConfirmRecordGenModel, Set<Long> fileBoIdSet, AttConRecordTypeEnum type) {
        AttConfirmQueryServiceImpl instance = AttConfirmQueryServiceImpl.getInstance();
        AttConfirmRecordQueryParam attConfirmRecordQueryParam = new AttConfirmRecordQueryParam();
        attConfirmRecordQueryParam.setType(type);
        attConfirmRecordQueryParam.setAttFileBoIdSet(fileBoIdSet);
        if (AttConRecordTypeEnum.BY_DATE == type) {
            List dataScope = attConfirmRecordGenModel.getDataScope();
            if (WTCCollections.isEmpty((Collection)dataScope)) {
                Date endDte = WTCDateUtils.toDate((LocalDate)LocalDate.now());
                attConfirmRecordQueryParam.setStartDate(WTCDateUtils.addDays((Date)endDte, (int)-100));
                attConfirmRecordQueryParam.setEndDate(endDte);
            } else {
                attConfirmRecordQueryParam.setStartDate((Date)dataScope.get(0));
                attConfirmRecordQueryParam.setEndDate((Date)dataScope.get(dataScope.size() - 1));
            }
        } else {
            attConfirmRecordQueryParam.setPerAttPeriodIdSet(attConfirmRecordGenModel.getPerAttPeriodSet().stream().map(PerAttPeriod::getPrimaryId).collect(Collectors.toSet()));
        }
        attConfirmRecordQueryParam.setStatus(AttConfirmRecordQueryParam.getQueryAttConRecordStatusEnum((AttConRecordStatusEnum[])new AttConRecordStatusEnum[]{AttConRecordStatusEnum.GEN, AttConRecordStatusEnum.SEND, AttConRecordStatusEnum.CONFIRM, AttConRecordStatusEnum.NOT_CONFIRM}));
        return instance.queryAttConfirmRecordModelList(attConfirmRecordQueryParam);
    }
}

