/*
 * Decompiled with CFR 0.152.
 */
package kd.wtc.wtp.business.attconfirm.impl;

import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.user.UserServiceHelper;
import kd.bos.util.CollectionUtils;
import kd.wtc.wtbs.business.web.attperiod.PerAttPeriodQueryServiceImpl;
import kd.wtc.wtbs.business.web.file.AttFileQueryServiceImpl;
import kd.wtc.wtbs.common.model.attfile.AttFileQueryParam;
import kd.wtc.wtbs.common.model.period.PerAttPeriod;
import kd.wtc.wtbs.common.model.period.PerAttPeriodQueryParam;
import kd.wtc.wtbs.common.util.third.collect.Sets;
import kd.wtc.wtp.business.attconfirm.IAttConfirmCheckService;
import kd.wtc.wtp.business.attconfirm.impl.AttConfirmRuleServiceImpl;
import kd.wtc.wtp.business.attstateinfo.AttStateInfoService;
import kd.wtc.wtp.common.enums.attconfirm.AttConRecordStatusEnum;
import kd.wtc.wtp.common.enums.attconfirm.AttConRecordTypeEnum;
import kd.wtc.wtp.common.kdstring.AttConfirmKDString;
import kd.wtc.wtp.common.model.attconfirm.AttConfirmRecordModel;
import kd.wtc.wtp.common.model.attstateinfo.AttStateInfoBO;

public class AttConfirmCheckServiceImpl
implements IAttConfirmCheckService {
    public static AttConfirmCheckServiceImpl getInstance() {
        return SingletonInstance.SINGLETON;
    }

    @Override
    public void checkReceiverIsEqualToCurrentUser(List<AttConfirmRecordModel> recordModelList) {
        long currentUserId = UserServiceHelper.getCurrentUserId();
        for (AttConfirmRecordModel recordModel : recordModelList) {
            if (!Boolean.TRUE.equals(recordModel.getOpStatus())) continue;
            if (currentUserId == recordModel.getReceiver()) {
                recordModel.setOpStatus(Boolean.TRUE);
                continue;
            }
            recordModel.setMsg(AttConfirmKDString.getDoNotHaveAccessToThisAttConfirmForm());
            recordModel.setOpStatus(Boolean.FALSE);
        }
    }

    @Override
    public void checkStatusIsRevoked(List<AttConfirmRecordModel> recordModelList, boolean isConfirmOp) {
        for (AttConfirmRecordModel recordModel : recordModelList) {
            if (!Boolean.TRUE.equals(recordModel.getOpStatus())) continue;
            if (AttConRecordStatusEnum.REVOKE != recordModel.getStatus()) {
                recordModel.setOpStatus(Boolean.TRUE);
                continue;
            }
            if (isConfirmOp) {
                recordModel.setMsg(AttConfirmKDString.getAttConfirmIsRevokedByConfirmOp());
            } else {
                recordModel.setMsg(AttConfirmKDString.getAttConfirmIsRevoked());
            }
            recordModel.setOpStatus(null);
        }
    }

    @Override
    public void checkPerAttPeriodIsValidByPeriod(List<AttConfirmRecordModel> recordModelList, boolean isConfirmOp) {
        List perAttPeriodIds = recordModelList.stream().map(AttConfirmRecordModel::getPerAttPeriod).collect(Collectors.toList());
        PerAttPeriodQueryParam queryParam = new PerAttPeriodQueryParam();
        queryParam.setExtendQFilter(new QFilter("id", "in", perAttPeriodIds));
        List periodAndStateInfos = PerAttPeriodQueryServiceImpl.getInstance().queryPerAttPeriodEntity(queryParam);
        List effectivePerAttPeriodIds = periodAndStateInfos.stream().map(PerAttPeriod::getPrimaryId).collect(Collectors.toList());
        for (AttConfirmRecordModel recordModel : recordModelList) {
            if (!Boolean.TRUE.equals(recordModel.getOpStatus()) || AttConRecordTypeEnum.BY_PERIOD != recordModel.getType()) continue;
            if (effectivePerAttPeriodIds.contains(recordModel.getPerAttPeriod())) {
                recordModel.setOpStatus(Boolean.TRUE);
                continue;
            }
            if (isConfirmOp) {
                recordModel.setMsg(AttConfirmKDString.getAttConfirmPerAttPeriodInvalidByConfirmOp());
            } else {
                recordModel.setMsg(AttConfirmKDString.getAttConfirmPerAttPeriodInvalid());
            }
            recordModel.setOpStatus(null);
        }
    }

    @Override
    public void checkAccountToAfterEndDate(List<AttConfirmRecordModel> recordModelList, boolean isConfirmOp) {
        List<Long> attFileBoIds = recordModelList.stream().map(AttConfirmRecordModel::getAttFile).collect(Collectors.toList());
        List<AttStateInfoBO> attStateInfoBOList = AttStateInfoService.getInstance().queryAttStateInfoByBoid(attFileBoIds);
        Map<Long, AttStateInfoBO> map = attStateInfoBOList.stream().collect(Collectors.toMap(AttStateInfoBO::getFileBoid, infoBo -> infoBo, (a, b) -> a));
        for (AttConfirmRecordModel recordModel : recordModelList) {
            long attFileId;
            AttStateInfoBO attStateInfoBO;
            if (!Boolean.TRUE.equals(recordModel.getOpStatus()) || (attStateInfoBO = map.get(attFileId = recordModel.getAttFile())) == null) continue;
            Date accountDate = attStateInfoBO.getAccountTo();
            if (accountDate == null || recordModel.getEndDate().compareTo(accountDate) <= 0) {
                recordModel.setOpStatus(Boolean.TRUE);
                continue;
            }
            if (isConfirmOp) {
                if (AttConRecordTypeEnum.BY_DATE == recordModel.getType()) {
                    recordModel.setMsg(AttConfirmKDString.getUnableToConfirmCausePartialDatesNotAccountByDayConfirmOp());
                } else {
                    recordModel.setMsg(AttConfirmKDString.getUnableToConfirmCausePartialDatesNotAccountByPeriodConfirmOp());
                }
            } else {
                recordModel.setMsg(AttConfirmKDString.getUnableToConfirmCausePartialDatesNotAccount());
            }
            recordModel.setOpStatus(Boolean.FALSE);
        }
    }

    @Override
    public void checkAttFileIsDiscard(List<AttConfirmRecordModel> recordModels) {
        Set fileBoIds = recordModels.stream().map(AttConfirmRecordModel::getAttFile).collect(Collectors.toSet());
        AttFileQueryParam queryParam = new AttFileQueryParam(false);
        queryParam.setSetBoIds(fileBoIds);
        queryParam.setBeCurrent(Boolean.TRUE);
        queryParam.setProperties("id");
        queryParam.setUsableStatus((Set)Sets.newHashSet((Object[])new String[]{"-1"}));
        List fileBoDys = AttFileQueryServiceImpl.getInstance().queryAttFiles(queryParam);
        if (CollectionUtils.isEmpty((Collection)fileBoDys)) {
            return;
        }
        List discardFileBoIds = fileBoDys.stream().map(dy -> dy.getLong("id")).collect(Collectors.toList());
        for (AttConfirmRecordModel recordModel : recordModels) {
            if (!Boolean.TRUE.equals(recordModel.getOpStatus())) continue;
            if (discardFileBoIds.contains(recordModel.getAttFile())) {
                recordModel.setMsg(AttConfirmKDString.confirmBillAttFileIsDiscard());
                recordModel.setOpStatus(Boolean.FALSE);
                continue;
            }
            recordModel.setOpStatus(Boolean.TRUE);
        }
    }

    @Override
    public String checkGenRuleScopeDate(DynamicObject dy) {
        if (null == dy) {
            return "";
        }
        Date startDate = AttConfirmRuleServiceImpl.getInstance().handleGenScopeByPeriod(dy, "startmonth", "startdays");
        Date endDate = AttConfirmRuleServiceImpl.getInstance().handleGenScopeByPeriod(dy, "endmonth", "enddays");
        if (null != startDate && null != endDate && endDate.before(startDate)) {
            return AttConfirmKDString.getCheckDateTips();
        }
        return "";
    }

    @Override
    public void checkStartDateIsAfterLockTo(List<AttConfirmRecordModel> recordModelList) {
        List<Long> attFileBoIds = recordModelList.stream().map(AttConfirmRecordModel::getAttFile).collect(Collectors.toList());
        List<AttStateInfoBO> attStateInfoBOList = AttStateInfoService.getInstance().queryAttStateInfoByBoid(attFileBoIds);
        Map<Long, AttStateInfoBO> map = attStateInfoBOList.stream().collect(Collectors.toMap(AttStateInfoBO::getFileBoid, infoBo -> infoBo, (a, b) -> a));
        for (AttConfirmRecordModel recordModel : recordModelList) {
            long attFileId;
            AttStateInfoBO attStateInfoBO;
            if (!Boolean.TRUE.equals(recordModel.getOpStatus()) || (attStateInfoBO = map.get(attFileId = recordModel.getAttFile())) == null) continue;
            Date startDate = recordModel.getStartDate();
            Date lockTo = attStateInfoBO.getLockTo();
            if (startDate == null || lockTo == null || startDate.compareTo(lockTo) > 0) continue;
            recordModel.setOpStatus(Boolean.FALSE);
            recordModel.setMsg(AttConfirmKDString.getStartDateIsAfterLockToTips((Date)lockTo));
        }
    }

    private static class SingletonInstance {
        private static final AttConfirmCheckServiceImpl SINGLETON = new AttConfirmCheckServiceImpl();

        private SingletonInstance() {
        }
    }
}

