/*
 * Decompiled with CFR 0.152.
 */
package kd.wtc.wtp.business.attconfirm.impl;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.servicehelper.user.UserServiceHelper;
import kd.bos.util.CollectionUtils;
import kd.wtc.wtbs.common.helper.WTCAppContextHelper;
import kd.wtc.wtbs.common.util.third.collect.Lists;
import kd.wtc.wtp.business.attconfirm.AttConfirmHelper;
import kd.wtc.wtp.business.attconfirm.IAttConfirmOpService;
import kd.wtc.wtp.business.attconfirm.impl.AttConfirmCheckServiceImpl;
import kd.wtc.wtp.business.attconfirm.impl.AttConfirmQueryServiceImpl;
import kd.wtc.wtp.business.attstateinfo.AttStateInfoService;
import kd.wtc.wtp.common.enums.attconfirm.AttConRecordModeEnum;
import kd.wtc.wtp.common.enums.attconfirm.AttConRecordStatusEnum;
import kd.wtc.wtp.common.enums.attconfirm.AttConfirmDataStatusEnum;
import kd.wtc.wtp.common.enums.attconfirm.AttConfirmRecordOpEnum;
import kd.wtc.wtp.common.kdstring.AttConfirmKDString;
import kd.wtc.wtp.common.model.attconfirm.AttConfirmRecordModel;
import kd.wtc.wtp.common.model.attconfirm.AttConfirmRecordOpParam;
import kd.wtc.wtp.common.model.attconfirm.AttConfirmRecordOpResult;
import kd.wtc.wtp.common.model.attconfirm.AttConfirmRecordQueryParam;
import kd.wtc.wtp.common.model.attconfirm.AttConfirmRecordTipsModel;
import kd.wtc.wtp.common.model.attstateinfo.AttStateInfoBO;

public class AttConfirmProxyOpServiceImpl
implements IAttConfirmOpService {
    private static final Log LOG = LogFactory.getLog(AttConfirmProxyOpServiceImpl.class);

    public static AttConfirmProxyOpServiceImpl getInstance() {
        return (AttConfirmProxyOpServiceImpl)WTCAppContextHelper.getBean(AttConfirmProxyOpServiceImpl.class);
    }

    @Override
    public AttConfirmRecordOpResult opAttConfirmRecord(AttConfirmRecordOpParam attConfirmRecordOpParam) {
        List<AttConfirmRecordModel> recordModelList = attConfirmRecordOpParam.getAttConfirmRecordModelList();
        if (CollectionUtils.isEmpty((Collection)recordModelList)) {
            if (attConfirmRecordOpParam.getAttConfirmRecordIds() == null) {
                if (LOG.isDebugEnabled()) {
                    LOG.debug("inputParam AttConfirmRecordModelList is null.");
                }
                return new AttConfirmRecordOpResult();
            }
            AttConfirmRecordQueryParam queryParam = new AttConfirmRecordQueryParam();
            queryParam.setIds(attConfirmRecordOpParam.getAttConfirmRecordIds());
            queryParam.setQueryNotEffect(true);
            queryParam.setQueryNotEffect(true);
            recordModelList = AttConfirmQueryServiceImpl.getInstance().queryAttConfirmRecordModelList(queryParam);
        }
        if (CollectionUtils.isEmpty((Collection)recordModelList)) {
            return new AttConfirmRecordOpResult();
        }
        recordModelList.forEach(model -> model.setOpStatus(Boolean.TRUE));
        this.proxyDataStatusAndStatusValidate(recordModelList);
        AttConfirmCheckServiceImpl instance = AttConfirmCheckServiceImpl.getInstance();
        instance.checkStatusIsRevoked(recordModelList, true);
        instance.checkAttFileIsDiscard(recordModelList);
        if (AttConfirmRecordOpEnum.COMFIRM == attConfirmRecordOpParam.getOp()) {
            instance.checkReceiverIsEqualToCurrentUser(recordModelList);
        }
        instance.checkPerAttPeriodIsValidByPeriod(recordModelList, true);
        instance.checkAccountToAfterEndDate(recordModelList, true);
        attConfirmRecordOpParam.setAttConfirmRecordModelList(recordModelList);
        int successCount = 0;
        int failedCount = 0;
        int notRunCount = 0;
        ArrayList attConfirmRecordTipsModels = Lists.newArrayListWithExpectedSize((int)recordModelList.size());
        ArrayList<AttConfirmRecordModel> successRecordModels = new ArrayList<AttConfirmRecordModel>(recordModelList.size());
        for (AttConfirmRecordModel recordModel : recordModelList) {
            Boolean opStatus = recordModel.getOpStatus();
            if (opStatus == null) {
                ++notRunCount;
                attConfirmRecordTipsModels.add(new AttConfirmRecordTipsModel(recordModel.getName(), recordModel.getPersonNum(), recordModel.getStartDate(), recordModel.getEndDate(), recordModel.getMsg(), recordModel.getFileNumber()));
                continue;
            }
            if (opStatus.booleanValue()) {
                if (recordModel.getConFirmer() == 0L) {
                    recordModel.setConFirmer(UserServiceHelper.getCurrentUserId());
                }
                if (recordModel.getConfirmTime() == null) {
                    recordModel.setConfirmTime(new Date());
                }
                if (recordModel.getConfirmMode() == null) {
                    if (AttConfirmRecordOpEnum.COMFIRM == attConfirmRecordOpParam.getOp()) {
                        recordModel.setConfirmMode(AttConRecordModeEnum.RECEIVER_CONFIRM);
                    } else if (AttConfirmRecordOpEnum.PROXY == attConfirmRecordOpParam.getOp()) {
                        recordModel.setConfirmMode(AttConRecordModeEnum.HR_CONFIRM);
                    }
                }
                recordModel.setStatus(AttConRecordStatusEnum.CONFIRM);
                successRecordModels.add(recordModel);
                ++successCount;
                continue;
            }
            ++failedCount;
            attConfirmRecordTipsModels.add(new AttConfirmRecordTipsModel(recordModel.getName(), recordModel.getPersonNum(), recordModel.getStartDate(), recordModel.getEndDate(), recordModel.getMsg(), recordModel.getFileNumber()));
        }
        try (TXHandle txHandle = TX.required();){
            AttConfirmHelper.getInstance().updateAttConfirmRecordData(successRecordModels);
            AttConfirmHelper.getInstance().genAttConfirmBillHisData(successRecordModels, true);
            List<Long> attFileBoIds = successRecordModels.stream().map(AttConfirmRecordModel::getAttFile).collect(Collectors.toList());
            List<AttStateInfoBO> attStateInfoBOList = AttStateInfoService.getInstance().queryAttStateInfoByBoid(attFileBoIds);
            Map<Long, AttStateInfoBO> attStateInfoBoMap = attStateInfoBOList.stream().collect(Collectors.toMap(AttStateInfoBO::getFileBoid, infoBo -> infoBo, (a, b) -> a));
            Map<Long, Date> recordModelMap = successRecordModels.stream().filter(AttConfirmRecordModel::isConfirmLock).filter(model -> model.getEndDate() != null && attStateInfoBoMap.get(model.getAttFile()) != null && (((AttStateInfoBO)attStateInfoBoMap.get(model.getAttFile())).getLockTo() == null || model.getEndDate().compareTo(((AttStateInfoBO)attStateInfoBoMap.get(model.getAttFile())).getLockTo()) > 0)).collect(Collectors.toMap(AttConfirmRecordModel::getAttFile, AttConfirmRecordModel::getEndDate, (a, b) -> a));
            AttStateInfoService.getInstance().lockTo(recordModelMap);
        }
        AttConfirmRecordOpResult opResult = new AttConfirmRecordOpResult();
        opResult.setTotalCount(recordModelList.size());
        opResult.setSuccessCount(successCount);
        opResult.setFailCount(failedCount);
        opResult.setNoRunCount(notRunCount);
        opResult.setUnit(AttConfirmKDString.getOpResultUnitAttConfirmRecord());
        opResult.setName(AttConfirmKDString.getAttConfirmRecordText());
        opResult.setAttConfirmRecordTipsModels((List)attConfirmRecordTipsModels);
        opResult.setOp(AttConfirmRecordOpEnum.PROXY);
        return opResult;
    }

    private void proxyDataStatusAndStatusValidate(List<AttConfirmRecordModel> recordModelList) {
        for (AttConfirmRecordModel recordModel : recordModelList) {
            if (AttConfirmDataStatusEnum.DISCARD == recordModel.getDataStatus()) {
                this.setFailedOpStatusAndMsg(recordModel, AttConfirmKDString.getAttConfirmProxyByDiscardTips());
                continue;
            }
            if (AttConfirmDataStatusEnum.INVALID == recordModel.getDataStatus()) {
                this.setFailedOpStatusAndMsg(recordModel, AttConfirmKDString.getAttConfirmProxyByInvalidTips());
                continue;
            }
            if (AttConfirmDataStatusEnum.EFFECT != recordModel.getDataStatus()) continue;
            if (AttConRecordStatusEnum.REVOKE == recordModel.getStatus()) {
                this.setFailedOpStatusAndMsg(recordModel, AttConfirmKDString.getAttConfirmProxyByRevokedTips());
                continue;
            }
            if (AttConRecordStatusEnum.CONFIRM != recordModel.getStatus()) continue;
            this.setFailedOpStatusAndMsg(recordModel, AttConfirmKDString.getAttConfirmProxyByConfirmedTips());
        }
    }

    private void setFailedOpStatusAndMsg(AttConfirmRecordModel recordModel, String attConfirmDiscardTips) {
        recordModel.setOpStatus(Boolean.FALSE);
        recordModel.setMsg(attConfirmDiscardTips);
    }
}

