/*
 * Decompiled with CFR 0.152.
 */
package kd.wtc.wtp.business.attconfirm.impl;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.entity.ILocaleString;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.db.DB;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.exception.KDBizException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.coderule.CodeRuleServiceHelper;
import kd.bos.servicehelper.user.UserServiceHelper;
import kd.bos.servicehelper.workflow.MessageCenterServiceHelper;
import kd.bos.url.UrlService;
import kd.bos.workflow.engine.msg.info.MessageInfo;
import kd.hr.hbp.business.servicehelper.HRBaseServiceHelper;
import kd.hr.hbp.common.util.HRStringUtils;
import kd.wtc.wtbs.business.util.WTCDynamicObjectUtils;
import kd.wtc.wtbs.business.web.file.AttFileQueryServiceImpl;
import kd.wtc.wtbs.business.web.mservice.HRPIMServiceImpl;
import kd.wtc.wtbs.common.helper.WTCAppContextHelper;
import kd.wtc.wtbs.common.util.WTCCollections;
import kd.wtc.wtbs.common.util.third.collect.Lists;
import kd.wtc.wtbs.common.util.third.time.StopWatch;
import kd.wtc.wtp.business.attconfirm.AttConfirmHelper;
import kd.wtc.wtp.business.attconfirm.IAttConfirmOpService;
import kd.wtc.wtp.common.enums.attconfirm.AttConRecordDataSourceEnum;
import kd.wtc.wtp.common.enums.attconfirm.AttConRecordPushStatusEnum;
import kd.wtc.wtp.common.enums.attconfirm.AttConRecordStatusEnum;
import kd.wtc.wtp.common.enums.attconfirm.AttConfirmDataStatusEnum;
import kd.wtc.wtp.common.enums.attconfirm.AttConfirmRecordOpEnum;
import kd.wtc.wtp.common.kdstring.AttConfirmKDString;
import kd.wtc.wtp.common.model.attconfirm.AttConfirmRecordModel;
import kd.wtc.wtp.common.model.attconfirm.AttConfirmRecordOpParam;
import kd.wtc.wtp.common.model.attconfirm.AttConfirmRecordOpResult;
import kd.wtc.wtp.common.model.attconfirm.AttConfirmRecordTipsModel;
import kd.wtc.wtp.common.model.attconfirm.MsgPushModel;

public class AttConfirmPushOpServiceImpl
implements IAttConfirmOpService {
    private static final Log LOG = LogFactory.getLog(AttConfirmPushOpServiceImpl.class);

    public static AttConfirmPushOpServiceImpl getInstance() {
        return (AttConfirmPushOpServiceImpl)WTCAppContextHelper.getBean(AttConfirmPushOpServiceImpl.class);
    }

    @Override
    public AttConfirmRecordOpResult opAttConfirmRecord(AttConfirmRecordOpParam attConfirmRecordOpParam) {
        MsgPushModel msgPushModel = attConfirmRecordOpParam.getMsgPushModel();
        if (msgPushModel == null) {
            if (LOG.isWarnEnabled()) {
                LOG.warn("msgTemplate is null.");
            }
            throw new KDBizException(AttConfirmKDString.getSystemErrorTips());
        }
        StopWatch stopWatch = StopWatch.createStarted();
        this.pushDataStatusAndStatusValidate(attConfirmRecordOpParam);
        Map<Long, Long> map = this.saveAttConfirmPushRecord(attConfirmRecordOpParam);
        stopWatch.stop();
        if (LOG.isInfoEnabled()) {
            LOG.info(" AttConfirmPushOpServiceImpl opAttConfirmRecord cost: {} ", (Object)stopWatch.getTime());
        }
        this.sendMessage(attConfirmRecordOpParam, map);
        AttConfirmRecordOpResult result = new AttConfirmRecordOpResult();
        List recordModels = attConfirmRecordOpParam.getAttConfirmRecordModelList();
        if (WTCCollections.isEmpty((Collection)recordModels)) {
            return result;
        }
        result.setTotalCount(recordModels.size());
        List failedConfirmRecordModels = recordModels.stream().filter(recordModel -> Boolean.FALSE.equals(recordModel.getOpStatus())).collect(Collectors.toList());
        result.setFailCount(failedConfirmRecordModels.size());
        result.setSuccessCount(recordModels.size() - failedConfirmRecordModels.size());
        result.setNoRunCount(0);
        result.setUnit(AttConfirmKDString.getOpResultUnitAttConfirmRecord());
        result.setName(AttConfirmKDString.getAttConfirmRecordText());
        List attConfirmRecordTipsModels = failedConfirmRecordModels.stream().map(recordModel -> new AttConfirmRecordTipsModel(recordModel.getName(), recordModel.getPersonNum(), recordModel.getStartDate(), recordModel.getEndDate(), recordModel.getMsg(), recordModel.getFileNumber())).collect(Collectors.toList());
        result.setAttConfirmRecordTipsModels(attConfirmRecordTipsModels);
        result.setOp(AttConfirmRecordOpEnum.ROLLBACK);
        return result;
    }

    private void pushDataStatusAndStatusValidate(AttConfirmRecordOpParam attConfirmRecordOpParam) {
        List recordModelList = attConfirmRecordOpParam.getAttConfirmRecordModelList();
        recordModelList.forEach(recordModel -> recordModel.setOpStatus(Boolean.TRUE));
        for (AttConfirmRecordModel recordModel2 : recordModelList) {
            if (AttConfirmDataStatusEnum.DISCARD == recordModel2.getDataStatus()) {
                this.setFailedOpStatusAndMsg(recordModel2, AttConfirmKDString.getAttConfirmPushByDiscardTips());
                continue;
            }
            if (AttConfirmDataStatusEnum.INVALID == recordModel2.getDataStatus()) {
                this.setFailedOpStatusAndMsg(recordModel2, AttConfirmKDString.getAttConfirmPushByInvalidTips());
                continue;
            }
            if (AttConfirmDataStatusEnum.EFFECT != recordModel2.getDataStatus()) continue;
            if (AttConRecordStatusEnum.NOT_CONFIRM == recordModel2.getStatus()) {
                this.setFailedOpStatusAndMsg(recordModel2, AttConfirmKDString.getAttConfirmPushByNotConfirmTips());
                continue;
            }
            if (AttConRecordStatusEnum.REVOKE == recordModel2.getStatus()) {
                this.setFailedOpStatusAndMsg(recordModel2, AttConfirmKDString.getAttConfirmPushByRevokedTips());
                continue;
            }
            if (AttConRecordStatusEnum.CONFIRM != recordModel2.getStatus()) continue;
            this.setFailedOpStatusAndMsg(recordModel2, AttConfirmKDString.getAttConfirmPushByConfirmedTips());
        }
    }

    private void setFailedOpStatusAndMsg(AttConfirmRecordModel recordModel, String attConfirmRevokedTips) {
        recordModel.setOpStatus(Boolean.FALSE);
        recordModel.setMsg(attConfirmRevokedTips);
    }

    private Map<Long, Long> saveAttConfirmPushRecord(AttConfirmRecordOpParam attConfirmRecordOpParam) {
        List attConfirmRecordModelList = attConfirmRecordOpParam.getAttConfirmRecordModelList();
        ArrayList<AttConfirmRecordModel> updateRecordModelList = new ArrayList<AttConfirmRecordModel>(10);
        List fileVersionIds = attConfirmRecordModelList.stream().map(AttConfirmRecordModel::getAttFileVersion).collect(Collectors.toList());
        List attFileVersionDys = AttFileQueryServiceImpl.getInstance().queryAttFileByIds(null, fileVersionIds);
        Map map = attFileVersionDys.stream().collect(Collectors.toMap(dy -> dy.getLong("id"), Function.identity(), (a, b) -> a));
        long[] longIds = DB.genGlobalLongIds((int)attConfirmRecordModelList.size());
        long[] pkIds = DB.genGlobalLongIds((int)attConfirmRecordModelList.size());
        String msgChannel = attConfirmRecordOpParam.getMsgPushModel().getMsgChannel();
        HRBaseServiceHelper helper = new HRBaseServiceHelper("wtam_attconpushrecord");
        DynamicObjectCollection saveDys = new DynamicObjectCollection();
        for (int i = 0; i < attConfirmRecordModelList.size(); ++i) {
            AttConfirmRecordModel recordModel = (AttConfirmRecordModel)attConfirmRecordModelList.get(i);
            if (!Boolean.TRUE.equals(recordModel.getOpStatus())) continue;
            recordModel.setMsgId(longIds[i]);
            DynamicObject pushRecordDy = helper.generateEmptyDynamicObject();
            String name = String.format(AttConfirmKDString.getAttConfirmPushRecordTitle(), recordModel.getName());
            pushRecordDy.set("id", (Object)pkIds[i]);
            pushRecordDy.set("name", (Object)name);
            pushRecordDy.set("number", (Object)"");
            pushRecordDy.set("attconrecord", (Object)recordModel.getId());
            pushRecordDy.set("attfile", (Object)recordModel.getAttFile());
            pushRecordDy.set("attfileversion", map.get(recordModel.getAttFileVersion()));
            pushRecordDy.set("perattperiod", (Object)recordModel.getPerAttPeriod());
            pushRecordDy.set("sendtime", (Object)new Date());
            pushRecordDy.set("sender", (Object)RequestContext.get().getCurrUserId());
            pushRecordDy.set("msgtemplate", (Object)attConfirmRecordOpParam.getMsgPushModel().getMsgTemplate());
            pushRecordDy.set("msgid", (Object)recordModel.getMsgId());
            pushRecordDy.set("creator", (Object)UserServiceHelper.getCurrentUserId());
            pushRecordDy.set("receiver", (Object)recordModel.getReceiver());
            AttConRecordDataSourceEnum pushDataSource = recordModel.getPushDataSource();
            if (null != pushDataSource) {
                pushRecordDy.set("source", (Object)pushDataSource.getCode());
            }
            pushRecordDy.set("pushrule", (Object)recordModel.getPushRuleId());
            if (HRStringUtils.equals((String)"mcenter", (String)msgChannel)) {
                pushRecordDy.set("status", (Object)AttConRecordPushStatusEnum.SUCCESS.getCode());
            } else {
                pushRecordDy.set("status", (Object)AttConRecordPushStatusEnum.TOBEPUSHED.getCode());
            }
            saveDys.add((Object)pushRecordDy);
            updateRecordModelList.add(recordModel);
            recordModel.setStatus(AttConRecordStatusEnum.SEND);
        }
        StopWatch stopWatch = StopWatch.createStarted();
        CodeRuleServiceHelper.injectNumbers((String)"wtam_attconpushrecord", (List)saveDys);
        stopWatch.stop();
        if (LOG.isInfoEnabled()) {
            LOG.info(" AttConfirmPushOpServiceImpl CodeRuleServiceHelper#injectNumbers cost: {} ", (Object)stopWatch.getTime());
        }
        try (TXHandle txHandle = TX.required();){
            helper.save(saveDys);
            Map<Long, Long> resultMap = saveDys.stream().collect(Collectors.toMap(dy -> WTCDynamicObjectUtils.getBaseDataId((DynamicObject)dy, (String)"attconrecord"), dy -> dy.getLong("id"), (a, b) -> a));
            AttConfirmHelper.getInstance().updateAttConfirmRecordData(updateRecordModelList);
            Map<Long, Long> map2 = resultMap;
            return map2;
        }
    }

    private void sendMessage(AttConfirmRecordOpParam attConfirmRecordOpParam, Map<Long, Long> confirmPushRecordMap) {
        List attConfirmRecordModelList = attConfirmRecordOpParam.getAttConfirmRecordModelList();
        HRBaseServiceHelper msgTemplateHelper = new HRBaseServiceHelper("msg_template");
        DynamicObject msgTemplateDy = msgTemplateHelper.queryOne((Object)attConfirmRecordOpParam.getMsgPushModel().getMsgTemplate());
        List confirmRecordIds = attConfirmRecordModelList.stream().map(AttConfirmRecordModel::getId).collect(Collectors.toList());
        HRBaseServiceHelper helper = new HRBaseServiceHelper("wtam_attconfirmbill");
        DynamicObject[] attConfirmBillDys = helper.queryOriginalArray("id, attconrecord", new QFilter[]{new QFilter("attconrecord", "in", confirmRecordIds)});
        Map<Long, Long> map = Arrays.stream(attConfirmBillDys).collect(Collectors.toMap(dy -> WTCDynamicObjectUtils.getBaseDataId((DynamicObject)dy, (String)"attconrecord"), dy -> dy.getLong("id"), (a, b) -> a));
        ILocaleString attConfirmPushDayMsg = attConfirmRecordOpParam.getMsgPushModel().getMsgContent();
        String msgChannel = attConfirmRecordOpParam.getMsgPushModel().getMsgChannel();
        Set userIds = attConfirmRecordModelList.stream().map(AttConfirmRecordModel::getReceiver).collect(Collectors.toSet());
        Map userInfo = HRPIMServiceImpl.getInstance().queryPersonInfoByUserIds(new ArrayList(userIds));
        HashMap<Long, Long> userEmpIdMap = new HashMap<Long, Long>(userIds.size());
        if (userInfo != null && ((Boolean)userInfo.get("success")).booleanValue() && userInfo.get("data") != null) {
            Map userData = (Map)userInfo.get("data");
            for (Long userId : userIds) {
                Map data = (Map)userData.get(userId);
                if (data == null) continue;
                userEmpIdMap.put(userId, (Long)data.get("employee"));
            }
        }
        ArrayList messageInfoList = Lists.newArrayListWithExpectedSize((int)attConfirmRecordModelList.size());
        for (AttConfirmRecordModel recordModel : attConfirmRecordModelList) {
            if (Boolean.FALSE.equals(recordModel.getOpStatus())) continue;
            MessageInfo message = new MessageInfo();
            message.setId(Long.valueOf(recordModel.getMsgId()));
            message.setUserIds(Collections.singletonList(recordModel.getReceiver()));
            message.setSenderId(Long.valueOf(RequestContext.get().getCurrUserId()));
            message.setType(msgTemplateDy.getString("msgtype"));
            message.setEntityNumber("wtam_attconpushrecord");
            message.setNestBillno("wtam_attconpushrecord");
            message.setBizDataId(confirmPushRecordMap.get(recordModel.getId()));
            message.setContentUrl(AttConfirmPushOpServiceImpl.buildAttConfirmPushUrl(recordModel, map.get(recordModel.getId()), (Long)userEmpIdMap.get(recordModel.getReceiver())));
            message.setNotifyType(msgChannel);
            LocaleString messageTitle = new LocaleString();
            messageTitle.setLocaleValue(AttConfirmKDString.getMessageTitle());
            message.setMessageTitle((ILocaleString)messageTitle);
            LocaleString messageTag = new LocaleString();
            messageTag.setLocaleValue(AttConfirmKDString.getMessageTag());
            message.setMessageTag((ILocaleString)messageTag);
            message.setTemplateNumber(msgTemplateDy.getString("number"));
            message.setMessageContent(attConfirmPushDayMsg);
            messageInfoList.add(message);
        }
        MessageCenterServiceHelper.batchSendMessages((List)messageInfoList);
    }

    private static String buildAttConfirmPushUrl(AttConfirmRecordModel recordModel, Long confirmRecordId, Long employeeId) {
        HashMap<String, String> params = new HashMap<String, String>(16);
        params.put("formId", "wtss_attconfirmlistpc");
        params.put("type", "base");
        params.put("openStyle", "modal");
        params.put("pkId", String.valueOf(confirmRecordId));
        params.put("testId", String.valueOf(confirmRecordId));
        params.put("cache_attfile_boid", String.valueOf(recordModel.getAttFile()));
        if (employeeId != null) {
            params.put("cache_id_employeeid", String.valueOf(employeeId));
        }
        params.put("confirmtype", recordModel.getType().getCode());
        params.put("currentrecordid", String.valueOf(recordModel.getId()));
        params.put("source", "msgcenter");
        return AttConfirmPushOpServiceImpl.getUrl(params);
    }

    private static String getUrl(Map<String, String> params) {
        StringBuilder stringBuilder = new StringBuilder(UrlService.getDomainContextUrl()).append("/?");
        Iterator<Map.Entry<String, String>> iterator = params.entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry<String, String> next = iterator.next();
            if (!HRStringUtils.isNotEmpty((String)next.getValue())) continue;
            stringBuilder.append(next.getKey()).append("=").append(next.getValue());
            if (!iterator.hasNext()) continue;
            stringBuilder.append("&");
        }
        return stringBuilder.toString();
    }
}

