/*
 * Decompiled with CFR 0.152.
 */
package kd.wtc.wtp.business.attconfirm.impl;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.orm.query.QFilter;
import kd.hr.hbp.business.servicehelper.HRBaseServiceHelper;
import kd.wtc.wtbs.business.util.WTCDynamicObjectUtils;
import kd.wtc.wtbs.common.helper.WTCAppContextHelper;
import kd.wtc.wtbs.common.util.WTCStringUtils;
import kd.wtc.wtbs.common.util.third.collect.Lists;
import kd.wtc.wtp.business.attconfirm.IAttConfirmQueryService;
import kd.wtc.wtp.common.enums.attconfirm.AttConRecordModeEnum;
import kd.wtc.wtp.common.enums.attconfirm.AttConRecordOverHandleTypeEnum;
import kd.wtc.wtp.common.enums.attconfirm.AttConRecordStatusEnum;
import kd.wtc.wtp.common.enums.attconfirm.AttConRecordTypeEnum;
import kd.wtc.wtp.common.enums.attconfirm.AttConfirmDataStatusEnum;
import kd.wtc.wtp.common.model.attconfirm.AttConfirmRecordModel;
import kd.wtc.wtp.common.model.attconfirm.AttConfirmRecordQueryParam;

public class AttConfirmQueryServiceImpl
implements IAttConfirmQueryService {
    private static final HRBaseServiceHelper queryService = new HRBaseServiceHelper("wtam_attconrecord");

    public static AttConfirmQueryServiceImpl getInstance() {
        return (AttConfirmQueryServiceImpl)WTCAppContextHelper.getBean(AttConfirmQueryServiceImpl.class);
    }

    @Override
    public List<AttConfirmRecordModel> queryAttConfirmRecordModelList(AttConfirmRecordQueryParam attConfirmRecordQueryParam) {
        QFilter qFilter = this.getQFilter(attConfirmRecordQueryParam);
        if (qFilter == null) {
            return Collections.emptyList();
        }
        String properties = WTCStringUtils.joinStr((String[])new String[]{"id", ",", "attfile", ",", "attfileversion.textname", ",", "attfile.personnum", ",", "type", ",", "attfileversion", ",", "confirmtime", ",", "attfile.number", ",", "revoketime", ",", "overhandletype", ",", "enddate", ",", "startdate", ",", "confirmer", ",", "confirmmode", ",", "perattperiod", ",", "confirmlock", ",", "receiver", ",", "revoker", ",", "showlast", ",", "confirmendtime", ",", "status", ",", "createtime", ",", "datastatus"});
        DynamicObject[] dynamicObjects = queryService.queryOriginalArray(properties, new QFilter[]{qFilter});
        return this.getAttConfirmRecordModelList(dynamicObjects);
    }

    private List<AttConfirmRecordModel> getAttConfirmRecordModelList(DynamicObject[] dynamicObjects) {
        ArrayList recordModelList = Lists.newArrayListWithExpectedSize((int)dynamicObjects.length);
        for (DynamicObject dynamicObject : dynamicObjects) {
            AttConfirmRecordModel attConfirmRecordModel = new AttConfirmRecordModel();
            attConfirmRecordModel.setId(dynamicObject.getLong("id"));
            attConfirmRecordModel.setAttFile(WTCDynamicObjectUtils.getBaseDataId((DynamicObject)dynamicObject, (String)"attfile"));
            attConfirmRecordModel.setName(dynamicObject.getString("attfileversion.textname"));
            attConfirmRecordModel.setFileNumber(dynamicObject.getString("attfile.number"));
            attConfirmRecordModel.setPersonNum(dynamicObject.getString("attfile.personnum"));
            attConfirmRecordModel.setAttFileVersion(WTCDynamicObjectUtils.getBaseDataId((DynamicObject)dynamicObject, (String)"attfileversion"));
            attConfirmRecordModel.setType(AttConRecordTypeEnum.getEnumByCode((String)dynamicObject.getString("type")));
            attConfirmRecordModel.setConfirmEndTime(dynamicObject.getDate("confirmendtime"));
            attConfirmRecordModel.setConfirmTime(dynamicObject.getDate("confirmtime"));
            attConfirmRecordModel.setRevokeTime(dynamicObject.getDate("revoketime"));
            attConfirmRecordModel.setOverHandleType(AttConRecordOverHandleTypeEnum.getEnumByCode((String)dynamicObject.getString("overhandletype")));
            attConfirmRecordModel.setEndDate(dynamicObject.getDate("enddate"));
            attConfirmRecordModel.setStartDate(dynamicObject.getDate("startdate"));
            attConfirmRecordModel.setConFirmer(dynamicObject.getLong("confirmer"));
            attConfirmRecordModel.setConfirmMode(AttConRecordModeEnum.getEnumByCode((String)dynamicObject.getString("confirmmode")));
            attConfirmRecordModel.setPerAttPeriod(dynamicObject.getLong("perattperiod"));
            attConfirmRecordModel.setConfirmLock(dynamicObject.getBoolean("confirmlock"));
            attConfirmRecordModel.setReceiver(dynamicObject.getLong("receiver"));
            attConfirmRecordModel.setRevoker(dynamicObject.getLong("revoker"));
            attConfirmRecordModel.setShowLast(dynamicObject.getBoolean("showlast"));
            attConfirmRecordModel.setStatus(AttConRecordStatusEnum.getEnumByCode((String)dynamicObject.getString("status")));
            attConfirmRecordModel.setCreateTime(dynamicObject.getDate("createtime"));
            attConfirmRecordModel.setDataStatus(AttConfirmDataStatusEnum.getDataStatusEnumByCode((String)dynamicObject.getString("datastatus")));
            recordModelList.add(attConfirmRecordModel);
        }
        return recordModelList;
    }

    @Override
    public DynamicObject[] queryAttConfirmPushRecordList(String properties, QFilter[] qFilter) {
        HRBaseServiceHelper helper = new HRBaseServiceHelper("wtam_attconpushrecord");
        return helper.queryOriginalArray(properties, qFilter);
    }

    @Override
    public DynamicObject[] queryAttConfirmRecordDyList(AttConfirmRecordQueryParam attConfirmRecordQueryParam) {
        QFilter qFilter = this.getQFilter(attConfirmRecordQueryParam);
        if (qFilter == null) {
            return null;
        }
        String properties = WTCStringUtils.joinStr((String[])new String[]{"id", ",", "attfile", ",", "attfileversion.textname", ",", "type", ",", "attfileversion", ",", "confirmtime", ",", "revoketime", ",", "overhandletype", ",", "enddate", ",", "startdate", ",", "confirmer", ",", "confirmmode", ",", "perattperiod", ",", "confirmlock", ",", "receiver", ",", "revoker", ",", "showlast", ",", "confirmendtime", ",", "status", ",", "createtime"});
        return queryService.queryOriginalArray(properties, new QFilter[]{qFilter});
    }

    @Override
    public List<Long> updateDataStatusAttConfirmRecord(QFilter cusQFilter, AttConfirmDataStatusEnum attConfirmDataStatusEnum) {
        DynamicObject[] queryData = queryService.query("id,datastatus", new QFilter[]{cusQFilter});
        if (queryData != null && queryData.length > 0) {
            for (DynamicObject queryDatum : queryData) {
                queryDatum.set("datastatus", (Object)attConfirmDataStatusEnum.getCode());
            }
            queryService.update(queryData);
            return Arrays.stream(queryData).map(d -> d.getLong("id")).collect(Collectors.toList());
        }
        return new ArrayList<Long>(0);
    }
}

