/*
 * Decompiled with CFR 0.152.
 */
package kd.wtc.wtp.business.attconfirm.impl;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.user.UserServiceHelper;
import kd.bos.servicehelper.workflow.MessageCenterServiceHelper;
import kd.bos.util.CollectionUtils;
import kd.hr.hbp.business.servicehelper.HRBaseServiceHelper;
import kd.wtc.wtbs.common.helper.WTCAppContextHelper;
import kd.wtc.wtbs.common.util.third.collect.Lists;
import kd.wtc.wtp.business.attconfirm.AttConfirmHelper;
import kd.wtc.wtp.business.attconfirm.IAttConfirmOpService;
import kd.wtc.wtp.business.attconfirm.impl.AttConfirmCheckServiceImpl;
import kd.wtc.wtp.business.attconfirm.impl.AttConfirmQueryServiceImpl;
import kd.wtc.wtp.common.enums.attconfirm.AttConRecordStatusEnum;
import kd.wtc.wtp.common.enums.attconfirm.AttConfirmDataStatusEnum;
import kd.wtc.wtp.common.enums.attconfirm.AttConfirmRecordOpEnum;
import kd.wtc.wtp.common.kdstring.AttConfirmKDString;
import kd.wtc.wtp.common.model.attconfirm.AttConfirmRecordModel;
import kd.wtc.wtp.common.model.attconfirm.AttConfirmRecordOpParam;
import kd.wtc.wtp.common.model.attconfirm.AttConfirmRecordOpResult;
import kd.wtc.wtp.common.model.attconfirm.AttConfirmRecordQueryParam;
import kd.wtc.wtp.common.model.attconfirm.AttConfirmRecordTipsModel;

public class AttConfirmRollBackOpServiceImpl
implements IAttConfirmOpService {
    private static final Log LOG = LogFactory.getLog(AttConfirmRollBackOpServiceImpl.class);

    public static AttConfirmRollBackOpServiceImpl getInstance() {
        return (AttConfirmRollBackOpServiceImpl)WTCAppContextHelper.getBean(AttConfirmRollBackOpServiceImpl.class);
    }

    @Override
    public AttConfirmRecordOpResult opAttConfirmRecord(AttConfirmRecordOpParam attConfirmRecordOpParam) {
        AttConfirmRecordQueryParam queryParam = new AttConfirmRecordQueryParam();
        queryParam.setIds(attConfirmRecordOpParam.getAttConfirmRecordIds());
        queryParam.setQueryNotEffect(true);
        List<AttConfirmRecordModel> recordModels = AttConfirmQueryServiceImpl.getInstance().queryAttConfirmRecordModelList(queryParam);
        Map<Long, AttConRecordStatusEnum> recordStatusMap = recordModels.stream().collect(Collectors.toMap(AttConfirmRecordModel::getId, AttConfirmRecordModel::getStatus, (a, b) -> a));
        ArrayList<AttConfirmRecordModel> successRecordModels = new ArrayList<AttConfirmRecordModel>(10);
        int successCount = 0;
        int failedCount = 0;
        int notRunCount = 0;
        recordModels.forEach(model -> model.setOpStatus(Boolean.TRUE));
        AttConfirmCheckServiceImpl.getInstance().checkStartDateIsAfterLockTo(recordModels);
        this.revokeDataStatusAndStatusValidate(recordModels);
        AttConfirmCheckServiceImpl.getInstance().checkPerAttPeriodIsValidByPeriod(recordModels, false);
        ArrayList attConfirmRecordTipsModels = Lists.newArrayListWithExpectedSize((int)recordModels.size());
        for (AttConfirmRecordModel recordModel : recordModels) {
            AttConfirmRecordTipsModel attConfirmRecordTipsModel;
            if (Boolean.TRUE.equals(recordModel.getOpStatus())) {
                recordModel.setRevoker(UserServiceHelper.getCurrentUserId());
                recordModel.setRevokeTime(new Date());
                recordModel.setStatus(AttConRecordStatusEnum.REVOKE);
                successRecordModels.add(recordModel);
                ++successCount;
                continue;
            }
            if (Boolean.FALSE.equals(recordModel.getOpStatus())) {
                ++failedCount;
                attConfirmRecordTipsModel = new AttConfirmRecordTipsModel(recordModel.getName(), recordModel.getPersonNum(), recordModel.getStartDate(), recordModel.getEndDate(), recordModel.getMsg(), recordModel.getFileNumber());
                attConfirmRecordTipsModels.add(attConfirmRecordTipsModel);
                continue;
            }
            ++notRunCount;
            attConfirmRecordTipsModel = new AttConfirmRecordTipsModel(recordModel.getName(), recordModel.getPersonNum(), recordModel.getStartDate(), recordModel.getEndDate(), recordModel.getMsg(), recordModel.getFileNumber());
            attConfirmRecordTipsModels.add(attConfirmRecordTipsModel);
        }
        List<Long> successRecordModelIds = successRecordModels.stream().map(AttConfirmRecordModel::getId).collect(Collectors.toList());
        this.retractMessage(successRecordModelIds);
        try (TXHandle txHandle = TX.required();){
            AttConfirmHelper.getInstance().updateAttConfirmRecordData(successRecordModels);
            List<AttConfirmRecordModel> genAttConfirmBIllList = successRecordModels.stream().filter(model -> AttConRecordStatusEnum.CONFIRM != recordStatusMap.get(model.getId())).collect(Collectors.toList());
            AttConfirmHelper.getInstance().genAttConfirmBillHisData(genAttConfirmBIllList, true);
        }
        AttConfirmRecordOpResult result = new AttConfirmRecordOpResult();
        result.setTotalCount(recordModels.size());
        result.setSuccessCount(successCount);
        result.setFailCount(failedCount);
        result.setNoRunCount(notRunCount);
        result.setUnit(AttConfirmKDString.getOpResultUnitAttConfirmRecord());
        result.setName(AttConfirmKDString.getAttConfirmRecordText());
        result.setAttConfirmRecordTipsModels((List)attConfirmRecordTipsModels);
        result.setOp(AttConfirmRecordOpEnum.ROLLBACK);
        return result;
    }

    private void revokeDataStatusAndStatusValidate(List<AttConfirmRecordModel> recordModelList) {
        for (AttConfirmRecordModel recordModel : recordModelList) {
            if (AttConfirmDataStatusEnum.DISCARD == recordModel.getDataStatus()) {
                recordModel.setOpStatus(Boolean.FALSE);
                recordModel.setMsg(AttConfirmKDString.getAttConfirmRevokeByDiscardTips());
                continue;
            }
            if (AttConfirmDataStatusEnum.INVALID != recordModel.getDataStatus()) continue;
            recordModel.setOpStatus(Boolean.FALSE);
            recordModel.setMsg(AttConfirmKDString.getAttConfirmRevokeByInvalidTips());
        }
    }

    private void retractMessage(List<Long> recordIds) {
        if (CollectionUtils.isEmpty(recordIds)) {
            return;
        }
        HRBaseServiceHelper helper = new HRBaseServiceHelper("wtam_attconpushrecord");
        DynamicObject[] pushRecordDys = helper.queryOriginalArray("msgid", new QFilter[]{new QFilter("attconrecord", "in", recordIds)});
        List<Long> msgIds = Arrays.stream(pushRecordDys).map(dy -> dy.getLong("msgid")).collect(Collectors.toList());
        msgIds.forEach(MessageCenterServiceHelper::retractMessage);
    }
}

