/*
 * Decompiled with CFR 0.152.
 */
package kd.wtc.wtp.business.attconfirm.impl;

import java.text.ParseException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.ILocaleString;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.hr.hbp.business.servicehelper.HRBaseServiceHelper;
import kd.wtc.wtbs.business.personfilter.PersonFilterServiceImpl;
import kd.wtc.wtbs.business.util.WTCDynamicObjectUtils;
import kd.wtc.wtbs.business.web.WTCRosterService;
import kd.wtc.wtbs.business.web.attperiod.PerAttPeriodQueryServiceImpl;
import kd.wtc.wtbs.business.web.file.AttFileQueryServiceImpl;
import kd.wtc.wtbs.common.enums.DateAttribute;
import kd.wtc.wtbs.common.helper.WTCAppContextHelper;
import kd.wtc.wtbs.common.model.attfile.AttFileQueryParam;
import kd.wtc.wtbs.common.model.period.PerAttPeriod;
import kd.wtc.wtbs.common.model.period.PerAttPeriodQueryParam;
import kd.wtc.wtbs.common.util.Tuple;
import kd.wtc.wtbs.common.util.WTCCollections;
import kd.wtc.wtbs.common.util.WTCDateUtils;
import kd.wtc.wtbs.common.util.third.collect.Lists;
import kd.wtc.wtbs.common.util.third.collect.Maps;
import kd.wtc.wtbs.common.util.third.time.StopWatch;
import kd.wtc.wtp.business.attconfirm.AttConfirmRuleService;
import kd.wtc.wtp.business.attconfirm.impl.AttConfirmQueryServiceImpl;
import kd.wtc.wtp.common.enums.attconfirm.AttConDayTypeEnum;
import kd.wtc.wtp.common.enums.attconfirm.AttConRecordDataSourceEnum;
import kd.wtc.wtp.common.enums.attconfirm.AttConRecordOverHandleTypeEnum;
import kd.wtc.wtp.common.enums.attconfirm.AttConRecordStatusEnum;
import kd.wtc.wtp.common.enums.attconfirm.AttConRecordTypeEnum;
import kd.wtc.wtp.common.enums.attconfirm.AttConfirmRecordOpEnum;
import kd.wtc.wtp.common.enums.attconfirm.AttConfirmScopeEnum;
import kd.wtc.wtp.common.model.attconfirm.AttConfirmRecordGenModel;
import kd.wtc.wtp.common.model.attconfirm.AttConfirmRecordModel;
import kd.wtc.wtp.common.model.attconfirm.AttConfirmRecordOpParam;
import kd.wtc.wtp.common.model.attconfirm.AttConfirmRecordQueryParam;
import kd.wtc.wtp.common.model.attconfirm.MsgPushModel;

public class AttConfirmRuleServiceImpl
implements AttConfirmRuleService {
    private static final Log LOG = LogFactory.getLog(AttConfirmRuleServiceImpl.class);
    public static final String SPLIT_LINE = "-";
    private static HRBaseServiceHelper ATT_PERSON_HELPER = new HRBaseServiceHelper("wtp_attendperson");
    private static HRBaseServiceHelper ATT_CONFIRM_GEN_RULE_HELPER = new HRBaseServiceHelper("wtp_attconfirmgenrule");
    private static HRBaseServiceHelper ATT_CONFIRM_PUSH_RULE_HELPER = new HRBaseServiceHelper("wtp_attconfirmpushrule");

    public static AttConfirmRuleServiceImpl getInstance() {
        return (AttConfirmRuleServiceImpl)WTCAppContextHelper.getBean(AttConfirmRuleServiceImpl.class);
    }

    @Override
    public List<AttConfirmRecordOpParam> attConfirmGen(String fNumber, AttConRecordTypeEnum attConRecordTypeEnum) {
        ArrayList<AttConfirmRecordOpParam> attConfirmRecordOpParamList = new ArrayList<AttConfirmRecordOpParam>();
        QFilter[] filter = new QFilter[]{new QFilter("number", "=", (Object)fNumber)};
        DynamicObject dy = ATT_CONFIRM_GEN_RULE_HELPER.loadDynamicObject(filter);
        if (dy == null) {
            return attConfirmRecordOpParamList;
        }
        Long ruleId = dy.getLong("id");
        Set<Long> attPersonIdSet = this.handleScope(ruleId, "wtp_attconfirmgenrule");
        if (WTCCollections.isEmpty(attPersonIdSet)) {
            LOG.info("attConfirmGen match attPersonIdSet size = 0");
            return Collections.emptyList();
        }
        int batchSize = WTCAppContextHelper.getSysParams().getIntValue("kd.wtc.wtp.attConfirm.batchSize", 1000);
        List batchList = Lists.partition(new ArrayList<Long>(attPersonIdSet), (int)batchSize);
        for (List idLists : batchList) {
            if (AttConRecordTypeEnum.BY_DATE == attConRecordTypeEnum) {
                attConfirmRecordOpParamList.add(this.genByType(dy, "day", new HashSet<Long>(idLists)));
            }
            if (AttConRecordTypeEnum.BY_PERIOD != attConRecordTypeEnum) continue;
            attConfirmRecordOpParamList.add(this.genByType(dy, "period", new HashSet<Long>(idLists)));
        }
        LOG.info("attConfirmGen ruleId : {} ", (Object)ruleId);
        if (CollectionUtils.isEmpty(attConfirmRecordOpParamList)) {
            return attConfirmRecordOpParamList;
        }
        for (AttConfirmRecordOpParam attConfirmRecordOpParam : attConfirmRecordOpParamList) {
            if (attConfirmRecordOpParam == null) continue;
            AttConfirmRecordGenModel attConfirmRecordGenModel = attConfirmRecordOpParam.getAttConfirmRecordGenModel();
            attConfirmRecordGenModel.setPersonIdSet(attPersonIdSet);
            attConfirmRecordGenModel.setGenSource(AttConRecordDataSourceEnum.SCHEDULE_TASK);
            attConfirmRecordGenModel.setGenRuleId(ruleId);
        }
        return attConfirmRecordOpParamList;
    }

    @Override
    public Map<String, List<AttConfirmRecordOpParam>> attConfirmGenerateRule(List<String> fNumberList, AttConRecordTypeEnum attConRecordTypeEnum) {
        if (CollectionUtils.isEmpty(fNumberList)) {
            return Maps.newHashMapWithExpectedSize((int)16);
        }
        HashMap resMap = Maps.newHashMapWithExpectedSize((int)fNumberList.size());
        for (String number : fNumberList) {
            List<AttConfirmRecordOpParam> attConfirmGenList = this.attConfirmGen(number, attConRecordTypeEnum);
            if (CollectionUtils.isEmpty(attConfirmGenList)) continue;
            resMap.put(number, attConfirmGenList);
        }
        return resMap;
    }

    @Override
    public List<AttConfirmRecordOpParam> attConfirmPushRule(List<String> fNumberList, AttConRecordTypeEnum attConRecordTypeEnum) {
        ArrayList<AttConfirmRecordOpParam> resList = new ArrayList<AttConfirmRecordOpParam>();
        for (String number : fNumberList) {
            List<AttConfirmRecordOpParam> attConfirmRecordOpParams = this.attConfirmPush(number, attConRecordTypeEnum);
            if (!WTCCollections.isNotEmpty(attConfirmRecordOpParams)) continue;
            resList.addAll(attConfirmRecordOpParams);
        }
        return resList;
    }

    @Override
    public List<AttConfirmRecordOpParam> attConfirmPush(String fNumber, AttConRecordTypeEnum attConRecordTypeEnum) {
        QFilter[] filter = new QFilter[]{new QFilter("number", "=", (Object)fNumber)};
        DynamicObject dy = ATT_CONFIRM_PUSH_RULE_HELPER.loadDynamicObject(filter);
        if (null == dy) {
            return Collections.emptyList();
        }
        Long ruleId = dy.getLong("id");
        LOG.info("attConfirmPush ruleId : {} ", (Object)ruleId);
        Set<Long> attPersonIdSet = this.handleScope(ruleId, "wtp_attconfirmpushrule");
        if (WTCCollections.isEmpty(attPersonIdSet)) {
            LOG.info("attConfirmPush match attPersonIdSet size = 0");
            return Collections.emptyList();
        }
        ArrayList result = Lists.newArrayListWithExpectedSize((int)10);
        AttFileQueryParam attFileQueryParam = new AttFileQueryParam(false);
        attFileQueryParam.setProperties("boid");
        attFileQueryParam.setAttPersonSetIds(attPersonIdSet);
        Set fileBoIdSet = AttFileQueryServiceImpl.getInstance().queryAttFiles(attFileQueryParam).stream().map(d -> d.getLong("boid")).collect(Collectors.toSet());
        int batchSize = WTCAppContextHelper.getSysParams().getIntValue("kd.wtc.wtp.attConfirm.batchSize", 1000);
        List batchList = Lists.partition(new ArrayList(fileBoIdSet), (int)batchSize);
        for (List ids : batchList) {
            AttConfirmRecordOpParam rsp;
            if (AttConRecordTypeEnum.BY_DATE == attConRecordTypeEnum || attConRecordTypeEnum == null) {
                rsp = new AttConfirmRecordOpParam();
                this.genConfirmPushRecordByType(rsp, dy, new HashSet<Long>(ids), "openbyday", "pushrange", "msgschme.id", "msgtemplate.id", "msgtemplate.msgtemplate", "msgtemplate.msgchannel");
                if (WTCCollections.isNotEmpty((Collection)rsp.getAttConfirmRecordModelList())) {
                    result.add(rsp);
                }
            }
            if (AttConRecordTypeEnum.BY_PERIOD != attConRecordTypeEnum && attConRecordTypeEnum != null) continue;
            rsp = new AttConfirmRecordOpParam();
            this.genConfirmPushRecordByType(rsp, dy, new HashSet<Long>(ids), "openbyperiod", "pushrangepr", "msgschmepr.id", "msgtemplatepr.id", "msgtemplatepr.msgtemplate", "msgtemplatepr.msgchannel");
            if (!WTCCollections.isNotEmpty((Collection)rsp.getAttConfirmRecordModelList())) continue;
            result.add(rsp);
        }
        result.stream().map(AttConfirmRecordOpParam::getAttConfirmRecordModelList).filter(WTCCollections::isNotEmpty).flatMap(Collection::stream).forEach(attConfirmRecordModel -> {
            attConfirmRecordModel.setPushDataSource(AttConRecordDataSourceEnum.SCHEDULE_TASK);
            attConfirmRecordModel.setPushRuleId(ruleId);
        });
        return result;
    }

    private void genConfirmPushRecordByType(AttConfirmRecordOpParam rsp, DynamicObject dy, Set<Long> boIds, String openPam, String pushRangePam, String msgSchmeIdPam, String msgTemplateIdPam, String msgcontentPam, String msgchannelPam) {
        if (dy.getBoolean(openPam)) {
            rsp.setOp(AttConfirmRecordOpEnum.PUSH);
            int pushRange = dy.getInt(pushRangePam);
            Date nowDate = new Date();
            QFilter qFilter = new QFilter("createtime", "<=", (Object)nowDate);
            Date nowZeroDate = WTCDateUtils.getZeroDate((Date)nowDate);
            if (pushRange == 0) {
                qFilter.and(new QFilter("createtime", ">=", (Object)nowZeroDate));
            } else {
                Date startDate = WTCDateUtils.addDays((Date)nowZeroDate, (int)(-pushRange));
                qFilter.and(new QFilter("createtime", ">=", (Object)startDate));
            }
            long msgSchId = dy.getLong(msgSchmeIdPam);
            long msgTemplateId = dy.getLong(msgTemplateIdPam);
            MsgPushModel msgPushModel = new MsgPushModel();
            msgPushModel.setMsgScene(msgSchId);
            msgPushModel.setMsgTemplate(msgTemplateId);
            ILocaleString msgContent = dy.getLocaleString(msgcontentPam);
            msgPushModel.setMsgContent(msgContent);
            String msgChannel = dy.getString(msgchannelPam);
            msgPushModel.setMsgChannel(msgChannel);
            rsp.setMsgPushModel(msgPushModel);
            AttConfirmRecordQueryParam queryPam = new AttConfirmRecordQueryParam();
            queryPam.setAttFileBoIdSet(boIds);
            HashSet<AttConRecordStatusEnum> status = new HashSet<AttConRecordStatusEnum>();
            status.add(AttConRecordStatusEnum.GEN);
            status.add(AttConRecordStatusEnum.SEND);
            queryPam.setStatus(status);
            queryPam.setCustomQFilter(qFilter);
            switch (openPam) {
                case "openbyday": {
                    queryPam.setType(AttConRecordTypeEnum.BY_DATE);
                    break;
                }
                case "openbyperiod": {
                    queryPam.setType(AttConRecordTypeEnum.BY_PERIOD);
                    break;
                }
            }
            List<AttConfirmRecordModel> attConfirmRecordModelList = AttConfirmQueryServiceImpl.getInstance().queryAttConfirmRecordModelList(queryPam);
            rsp.setAttConfirmRecordModelList(attConfirmRecordModelList);
        }
    }

    private Set<Long> handleScope(Long ruleId, String metaEntity) {
        QFilter[] qFilter = new QFilter[]{};
        DynamicObject[] query = ATT_PERSON_HELPER.query("id", qFilter);
        Set personSetIds = Arrays.stream(query).mapToLong(dyy -> WTCDynamicObjectUtils.getBaseDataId((DynamicObject)dyy, (String)"id")).boxed().collect(Collectors.toSet());
        StopWatch stopWatch = StopWatch.createStarted();
        Map infoMap = PersonFilterServiceImpl.getInstance().getFilterInfo(ruleId, metaEntity, personSetIds);
        Set attPersonIdSet = (Set)infoMap.get("attperson");
        Set attFileVIdSet = (Set)infoMap.get("attfile");
        stopWatch.stop();
        LOG.info(" handleScope PersonFilterServiceImpl getFilterInfo metaEntity:{} cost: {} ", (Object)metaEntity, (Object)stopWatch.getTime());
        if (CollectionUtils.isEmpty((Collection)attPersonIdSet) && CollectionUtils.isEmpty((Collection)attFileVIdSet)) {
            return new HashSet<Long>();
        }
        AttFileQueryParam attFileQueryParam = new AttFileQueryParam();
        attFileQueryParam.setProperties("id,boid,attperson.id");
        if (!CollectionUtils.isEmpty((Collection)attPersonIdSet)) {
            attFileQueryParam.setPersonSetIds(attPersonIdSet);
        }
        if (!CollectionUtils.isEmpty((Collection)attFileVIdSet)) {
            attFileQueryParam.setqFilter(new QFilter("id", "in", (Object)attFileVIdSet));
        }
        List attFiles = AttFileQueryServiceImpl.getInstance().queryAttFiles(attFileQueryParam);
        return attFiles.stream().map(dynamicObject -> dynamicObject.getLong("attperson.id")).collect(Collectors.toSet());
    }

    private AttConfirmRecordOpParam genByType(DynamicObject dy, String type, Set<Long> attPersonIdSet) {
        AttConfirmRecordGenModel attConfirmRecordGenModel = null;
        AttConfirmRecordOpParam attConfirmRecordOpParam = null;
        switch (type) {
            case "day": {
                attConfirmRecordGenModel = this.initRuleDataFromAcByDay(dy);
                break;
            }
            case "period": {
                attConfirmRecordGenModel = this.initRuleDataFromAcByPeriod(dy, attPersonIdSet);
                break;
            }
        }
        if (null != attConfirmRecordGenModel) {
            attConfirmRecordOpParam = new AttConfirmRecordOpParam();
            attConfirmRecordOpParam.setOp(AttConfirmRecordOpEnum.ADD);
            attConfirmRecordOpParam.setAttConfirmRecordGenModel(attConfirmRecordGenModel);
        }
        return attConfirmRecordOpParam;
    }

    private AttConfirmRecordGenModel initRuleDataFromAcByPeriod(DynamicObject dy, Set<Long> attPersonIdSet) {
        AttConfirmRecordGenModel attConfirmRecordGenModel = new AttConfirmRecordGenModel();
        if (null == dy) {
            LOG.warn("kd.wtc.wtp.business.attconfirm.impl.AttConfirmRuleServiceImpl.initRuleDataFromAcByPeriod error ");
            return null;
        }
        if (!dy.getBoolean("openbyperiod")) {
            return null;
        }
        Date startDate = this.handleGenScopeByPeriod(dy, "startmonth", "startdays");
        Date endDate = this.handleGenScopeByPeriod(dy, "endmonth", "enddays");
        if (null != startDate && null != endDate) {
            Tuple genScope = new Tuple((Object)startDate, (Object)endDate);
            attConfirmRecordGenModel.setGenScopePeriod(genScope);
        }
        Integer acByPeriod = dy.getInt("acbyperiod");
        Tuple confirmScope = new Tuple((Object)acByPeriod, (Object)AttConDayTypeEnum.DAY);
        attConfirmRecordGenModel.setConfirmScope(confirmScope);
        attConfirmRecordGenModel.setType(AttConRecordTypeEnum.BY_PERIOD);
        String overDueFex2 = dy.getString("overbypr");
        AttConRecordOverHandleTypeEnum enumByCode = AttConRecordOverHandleTypeEnum.getEnumByCode((String)overDueFex2);
        attConfirmRecordGenModel.setOverHandleType(enumByCode);
        attConfirmRecordGenModel.setZeroItemNoGen(dy.getBoolean("nogenpr"));
        attConfirmRecordGenModel.setConfirmLock(dy.getBoolean("showconfirmpr"));
        attConfirmRecordGenModel.setShowLast(dy.getBoolean("showlastbypr"));
        PerAttPeriodQueryParam param = new PerAttPeriodQueryParam();
        param.setProperties("id, attfileid, attfilevid, startdate, enddate,attperson,periodentry.begindate,periodentry.enddate");
        param.setAttPersonIdSet(attPersonIdSet);
        param.setStartDate(startDate);
        param.setEndDate(endDate);
        List perAttPeriodDy = PerAttPeriodQueryServiceImpl.getInstance().queryPerAttPeriodDy(param);
        HashSet<PerAttPeriod> perAttPeriodSets = new HashSet<PerAttPeriod>(16);
        if (WTCCollections.isNotEmpty((Collection)perAttPeriodDy)) {
            for (DynamicObject v : perAttPeriodDy) {
                PerAttPeriod perAttPeriod = new PerAttPeriod();
                perAttPeriod.setPrimaryId(Long.valueOf(v.getLong("id")));
                perAttPeriod.setFileId(Long.valueOf(v.getLong("attfilevid")));
                perAttPeriod.setFileBoId(Long.valueOf(v.getLong("attfileid")));
                perAttPeriod.setPerAttBeginDate(v.getDate("startdate"));
                perAttPeriod.setPerAttEndDate(v.getDate("enddate"));
                perAttPeriod.setAttPeriodStartDate(v.getDate("periodentry.begindate"));
                perAttPeriod.setAttPeriodEndDate(v.getDate("periodentry.enddate"));
                perAttPeriod.setPersonId(Long.valueOf(v.getLong("attperson")));
                perAttPeriodSets.add(perAttPeriod);
            }
        }
        attConfirmRecordGenModel.setPerAttPeriodSet(perAttPeriodSets);
        return attConfirmRecordGenModel;
    }

    public Date handleGenScopeByPeriod(DynamicObject dy, String mouth, String days) {
        String startMouth = dy.getString(mouth);
        Date mouthDate = null;
        if (AttConfirmScopeEnum.LAST_MOUTH.getCode().equals(startMouth)) {
            mouthDate = this.obtScopeDate(dy, days, -1);
        } else if (AttConfirmScopeEnum.CURRENT_MOUTH.getCode().equals(startMouth)) {
            mouthDate = this.obtScopeDate(dy, days, 0);
        }
        return mouthDate;
    }

    private Date obtScopeDate(DynamicObject dy, String days, Integer custom) {
        Integer nowYear = WTCDateUtils.getNowYear();
        Integer nowMonth = WTCDateUtils.getNowMonth();
        Integer startDays = dy.getInt(days);
        String dateStr = nowYear + SPLIT_LINE + nowMonth + SPLIT_LINE + startDays;
        try {
            Date parseDate = WTCDateUtils.parseDate((String)dateStr, (String)"yyyy-MM-dd");
            Date startMouthDate = WTCDateUtils.getCustomMouth((Date)parseDate, (Integer)custom);
            return startMouthDate;
        }
        catch (ParseException e) {
            LOG.warn("initRuleDataFromAcByPeriod parseDate error ", (Throwable)e);
            return null;
        }
    }

    private AttConfirmRecordGenModel initRuleDataFromAcByDay(DynamicObject dy) {
        if (null == dy) {
            LOG.warn("kd.wtc.wtp.business.attconfirm.impl.AttConfirmRuleServiceImpl.initRuleDataFromAcByDay error ");
            return null;
        }
        AttConfirmRecordGenModel attConfirmRecordGenModel = new AttConfirmRecordGenModel();
        if (!dy.getBoolean("openbyday")) {
            return null;
        }
        Integer generateScopeByDay = dy.getInt("genscopebyday");
        String advanceUnit0 = dy.getString("scopeunit");
        AttConDayTypeEnum dayTypeEnum = AttConDayTypeEnum.getEnumByCode((String)advanceUnit0);
        Tuple genScope = new Tuple((Object)generateScopeByDay, (Object)dayTypeEnum);
        attConfirmRecordGenModel.setGenScope(genScope);
        Integer acByDayInteger = dy.getInt("acbyday");
        Tuple confirmScope = new Tuple((Object)acByDayInteger, (Object)AttConDayTypeEnum.DAY);
        attConfirmRecordGenModel.setConfirmScope(confirmScope);
        attConfirmRecordGenModel.setType(AttConRecordTypeEnum.BY_DATE);
        String overdueFex1 = dy.getString("overbyday");
        AttConRecordOverHandleTypeEnum enumByCode = AttConRecordOverHandleTypeEnum.getEnumByCode((String)overdueFex1);
        attConfirmRecordGenModel.setOverHandleType(enumByCode);
        attConfirmRecordGenModel.setZeroItemNoGen(dy.getBoolean("nogen"));
        attConfirmRecordGenModel.setConfirmLock(dy.getBoolean("showconfirm"));
        attConfirmRecordGenModel.setShowLast(dy.getBoolean("showlast"));
        attConfirmRecordGenModel.setDataScope(new ArrayList());
        return attConfirmRecordGenModel;
    }

    private int compareDate(Date date, Date anotherDate) {
        return WTCDateUtils.getZeroDate((Date)date).compareTo(WTCDateUtils.getZeroDate((Date)anotherDate));
    }

    public Map<Long, List<Date>> queryRosterWorkLimitData(Set<Long> fileBoIdSet, int dateLimit) {
        AttFileQueryParam attFileQueryParam = new AttFileQueryParam();
        attFileQueryParam.setSetBoIds(fileBoIdSet);
        attFileQueryParam.setProperties("boid,startdate,enddate,attperson");
        attFileQueryParam.setBeCurrent(Boolean.TRUE);
        Map fileBoMap = AttFileQueryServiceImpl.getInstance().queryAttFiles(attFileQueryParam).stream().collect(Collectors.toMap(d -> d.getLong("boid"), Function.identity(), (a, b) -> a));
        String property = "id,attperson,attfilebase,rosterdate,dateproperty,rostertype";
        QFilter filter = new QFilter("shift", "!=", (Object)0L);
        filter.and(new QFilter("rostertype", "=", (Object)Character.valueOf('0')));
        filter.and(new QFilter("dateproperty", "=", (Object)DateAttribute.WORKDAY.getId()));
        Date endQueryDate = WTCDateUtils.addDays((Date)new Date(), (int)-1);
        Date startQueryDate = WTCDateUtils.addDays((Date)endQueryDate, (int)(-dateLimit * 10 + 1));
        DynamicObject[] personRosterDyArr = WTCRosterService.getPersonRosterWithFilter((String)property, fileBoIdSet, (Date)WTCDateUtils.getZeroDate((Date)startQueryDate), (Date)WTCDateUtils.getZeroDate((Date)endQueryDate), (QFilter)filter);
        Map<Long, List<DynamicObject>> personRosterMap = Arrays.stream(personRosterDyArr).collect(Collectors.groupingBy(dynamicObject -> dynamicObject.getLong("attfilebase")));
        HashMap result = Maps.newHashMapWithExpectedSize((int)fileBoIdSet.size());
        HashMap personLimitMap = Maps.newHashMapWithExpectedSize((int)fileBoIdSet.size());
        for (Map.Entry<Long, List<DynamicObject>> entries : personRosterMap.entrySet()) {
            int i;
            int effectDateLimit = dateLimit;
            Long fileBoId = entries.getKey();
            DynamicObject fileBo = (DynamicObject)fileBoMap.get(fileBoId);
            List<DynamicObject> value = entries.getValue();
            if (fileBo == null || WTCCollections.isEmpty(value)) continue;
            long attPersonId = fileBo.getLong("attperson");
            ArrayList resultValue = Lists.newArrayListWithExpectedSize((int)value.size());
            List<DynamicObject> effectDataList = value.stream().filter(d -> this.compareDate(d.getDate("rosterdate"), fileBo.getDate("startdate")) >= 0 && this.compareDate(d.getDate("rosterdate"), fileBo.getDate("enddate")) <= 0).sorted(Comparator.comparing(d -> d.getDate("rosterdate"))).collect(Collectors.toList());
            Integer existLimit = (Integer)personLimitMap.get(attPersonId);
            if (existLimit != null) {
                effectDateLimit = dateLimit - existLimit;
            } else {
                existLimit = 0;
            }
            if (effectDataList.size() < effectDateLimit) {
                for (i = 0; i < effectDataList.size(); ++i) {
                    this.addResultValue(resultValue, effectDataList, i);
                }
                i = existLimit + effectDataList.size();
                personLimitMap.put(attPersonId, i);
            } else {
                for (i = effectDataList.size() - 1; i >= effectDataList.size() - effectDateLimit; --i) {
                    this.addResultValue(resultValue, effectDataList, i);
                }
            }
            result.put(fileBoId, resultValue);
        }
        return result;
    }

    private void addResultValue(List<Date> resultValue, List<DynamicObject> effectDataList, int i) {
        DynamicObject dynamicObject = effectDataList.get(i);
        Date date = dynamicObject.getDate("rosterdate");
        resultValue.add(date);
    }
}

