/*
 * Decompiled with CFR 0.152.
 */
package kd.wtc.wtp.business.attfile;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.servicehelper.basedata.BaseDataServiceHelper;
import kd.hr.hbp.business.servicehelper.HRBaseServiceHelper;
import kd.hr.hbp.business.servicehelper.HRMServiceHelper;
import kd.hr.hbp.common.util.HRCollUtil;
import kd.hr.hbp.common.util.HRMapUtils;
import kd.hr.hbp.common.util.HRObjectUtils;
import kd.hr.hbp.common.util.HRStringUtils;
import kd.wtc.wtbs.business.history.service.WTCHisServiceHelper;
import kd.wtc.wtbs.business.util.WTCDynamicObjectUtils;
import kd.wtc.wtbs.business.web.file.AttFileQueryServiceImpl;
import kd.wtc.wtbs.business.web.file.schedule.AttFileScheduleServiceImpl;
import kd.wtc.wtbs.business.web.mservice.HAOSMServiceImpl;
import kd.wtc.wtbs.business.web.mservice.HRPIMServiceImpl;
import kd.wtc.wtbs.business.web.wtte.sysparam.AttRecordParamService;
import kd.wtc.wtbs.common.bill.BillPermQueryParam;
import kd.wtc.wtbs.common.bill.BillQueryParam;
import kd.wtc.wtbs.common.bill.BusitripBillQueryParam;
import kd.wtc.wtbs.common.bill.OtBillQueryParam;
import kd.wtc.wtbs.common.bill.SupSignBillQueryParam;
import kd.wtc.wtbs.common.bill.VaBatchBillQueryParam;
import kd.wtc.wtbs.common.bill.VaBillQueryParam;
import kd.wtc.wtbs.common.enums.AttFileScheduleEnum;
import kd.wtc.wtbs.common.enums.bill.BillApplyTypeEnum;
import kd.wtc.wtbs.common.enums.file.AttStatusEnum;
import kd.wtc.wtbs.common.helper.WTCAppContextHelper;
import kd.wtc.wtbs.common.model.attfile.AttFileQueryParam;
import kd.wtc.wtbs.common.model.attfile.AttFileScheduleQueryParam;
import kd.wtc.wtbs.common.predata.wtp.PreDataAttend;
import kd.wtc.wtbs.common.util.WTCCollectionIndexUtil;
import kd.wtc.wtbs.common.util.WTCCollections;
import kd.wtc.wtbs.common.util.WTCDateUtils;
import kd.wtc.wtbs.common.util.WTCInteDateUtil;
import kd.wtc.wtbs.common.util.WTCOrgUnitServiceHelper;
import kd.wtc.wtbs.common.util.WTCStringUtils;
import kd.wtc.wtbs.common.util.third.collect.Lists;
import kd.wtc.wtbs.common.util.third.collect.Maps;
import kd.wtc.wtbs.common.util.third.collect.Sets;
import kd.wtc.wtbs.wtte.common.model.AttRecordParam;
import kd.wtc.wtp.business.attfile.AttFileHelper;
import kd.wtc.wtp.business.attfile.AttFileModifyCheckService;
import kd.wtc.wtp.business.attfile.AttFileServiceImpl;
import kd.wtc.wtp.business.attstateinfo.AttStateInfoService;
import kd.wtc.wtp.common.constants.AttFileConstants;
import kd.wtc.wtp.common.enums.AttFileEntrySkipPageEnum;
import kd.wtc.wtp.common.kdstring.AttFileKDString;
import kd.wtc.wtp.common.model.attstateinfo.AttStateInfoBO;
import kd.wtc.wtp.common.model.file.FileSaveDto;
import kd.wtc.wtp.enums.attfile.AttFileStopAttBillQueryEnum;

public class AttFileCheckService
implements AttFileConstants {
    private static final Log LOG = LogFactory.getLog(AttFileCheckService.class);
    private Boolean operateCheck;

    public static AttFileCheckService getInstance() {
        return (AttFileCheckService)WTCAppContextHelper.getBean(AttFileCheckService.class);
    }

    public Boolean getOperateCheck() {
        if (this.operateCheck == null) {
            return Boolean.TRUE;
        }
        return this.operateCheck;
    }

    public void setOperateCheck(Boolean operateCheck) {
        this.operateCheck = operateCheck;
    }

    public Map<Integer, Set<String>> checkAddAttFile(Map<Long, FileSaveDto> depempToFileCoreDataMap, List<DynamicObject> attFileList, boolean alertAll) {
        return this.checkAddAttFile(depempToFileCoreDataMap, attFileList, alertAll, null);
    }

    public Map<Integer, Set<String>> checkAddAttFile(Map<Long, FileSaveDto> depempToFileCoreDataMap, List<DynamicObject> attFileList, boolean alertAll, Map<String, Object> cusMap) {
        if (CollectionUtils.isEmpty(attFileList)) {
            return Collections.emptyMap();
        }
        this.reSetAttTag(attFileList);
        HashMap resultMap = Maps.newHashMapWithExpectedSize((int)attFileList.size());
        long hrDefaultRootOrgId = WTCOrgUnitServiceHelper.getHRDefaultRootOrgId();
        AttRecordParam attRecordParam = AttRecordParamService.getAttRecordParam((long)hrDefaultRootOrgId);
        List affiliateAdminOrgIdList = attFileList.stream().map(dy -> dy.getLong("affiliateadminorg.id")).collect(Collectors.toList());
        Map orgMap = HAOSMServiceImpl.getInstance().batchGetOrgInfo(WTCHisServiceHelper.getMinEndDate(), WTCHisServiceHelper.getMaxEndDate(), affiliateAdminOrgIdList);
        List<Long> employeeIdList = attFileList.stream().filter(dy -> dy.getLong("employee.id") != 0L).map(dy -> dy.getLong("employee.id")).collect(Collectors.toList());
        AttFileQueryParam attFileQueryParam = new AttFileQueryParam(false);
        Set employeeIds = attFileList.stream().map(dy -> dy.getLong("employee.id")).collect(Collectors.toSet());
        attFileQueryParam.setEmpPersonSetIds(employeeIds);
        attFileQueryParam.setBeCurrent(Boolean.TRUE);
        attFileQueryParam.setProperties(AttFileQueryParam.baseProperties + "," + "org,org.id,org.name,org.number,affiliateadminorg,affiliateadminorg.id,affiliateadminorg.number,affiliateadminorg.name,empgroup,empgroup.id,empgroup.number,empgroup.name,dependency,dependency.id,dependency.number,dependency.name,dependencytype,dependencytype.id,dependencytype.number,dependencytype.name,workplace,workplace.id,workplace.number,workplace.name,atttag.id,atttag.number,atttag.name" + "," + "person.id,person.number,person.name" + "," + "employee,employee.id,employee.empnumber,employee.startdate,employee.enddate,employee.sysenddate");
        List attFileDys = AttFileQueryServiceImpl.getInstance().queryAttFiles(attFileQueryParam);
        Map attFileExistMap = attFileDys.stream().sorted(Comparator.comparing(file -> file.getDate("startdate"))).collect(Collectors.toMap(d -> WTCDynamicObjectUtils.getBaseDataId((DynamicObject)d, (String)"employee"), Function.identity(), (a, b) -> b));
        Map<Long, Long> attFileBoIdToEmployeeMap = attFileDys.stream().collect(Collectors.toMap(dy -> dy.getLong("boid"), dy -> WTCDynamicObjectUtils.getBaseDataId((DynamicObject)dy, (String)"employee"), (a, b) -> a));
        List fileIdList = attFileList.stream().filter(file -> 0L != file.getLong("id")).map(file -> file.get("id")).collect(Collectors.toList());
        Set existFileSet = AttFileQueryServiceImpl.getInstance().queryAttFileByIds("id", fileIdList).stream().map(file -> file.getLong("id")).collect(Collectors.toSet());
        if (!CollectionUtils.isEmpty(existFileSet)) {
            return Collections.emptyMap();
        }
        List<Long> hasLastBoDataBoIdList = attFileExistMap.values().stream().map(d -> d.getLong("boid")).collect(Collectors.toList());
        List<AttStateInfoBO> attStateInfoBOS = AttStateInfoService.getInstance().queryAttStateInfoByBoid(hasLastBoDataBoIdList);
        Map attStateInfoBOMap = attStateInfoBOS.stream().filter(Objects::nonNull).collect(Collectors.toMap(attStateInfoBo -> (Long)attFileBoIdToEmployeeMap.get(attStateInfoBo.getFileBoid()), Function.identity(), (oldValue, newValue) -> oldValue));
        Map<Long, Map<String, Object>> empentrelMap = this.getCheckEmpenTrelData(employeeIdList);
        for (int i = 0; i < attFileList.size(); ++i) {
            Map<String, Object> labrelStatusMap;
            boolean ifPersonHaveFiles;
            DynamicObject attFileDy = attFileList.get(i);
            Date startDate = attFileDy.getDate("startdate");
            long affiliateAdminOrgId = attFileDy.getLong("affiliateadminorg.id");
            long employeeId = attFileDy.getLong("employee.id");
            long orgId = attFileDy.getLong("org.id");
            DynamicObject personExistFileDy = (DynamicObject)attFileExistMap.get(attFileDy.getLong("employee.id"));
            boolean bl = ifPersonHaveFiles = !HRObjectUtils.isEmpty((Object)personExistFileDy);
            if (employeeId == 0L) continue;
            if (startDate == null || orgId == 0L) {
                String msg = ResManager.loadKDString((String)"\u6863\u6848\u6570\u636e\u6709\u8bef\uff0c\u6863\u6848\u5f00\u59cb\u65e5\u671f\u6216\u8005\u8003\u52e4\u7ec4\u7ec7\u4e3a\u7a7a\u3002", (String)"AttFileCheckService_0", (String)"wtc-wtp-business", (Object[])new Object[0]);
                this.addResultMsg((Map<Integer, Set<String>>)resultMap, i, msg);
                continue;
            }
            String checkOrgStartDateMsg = AttFileCheckService.checkOrgStartDate(affiliateAdminOrgId, startDate, orgMap);
            if (!"".equals(checkOrgStartDateMsg)) {
                this.addResultMsg((Map<Integer, Set<String>>)resultMap, i, checkOrgStartDateMsg);
            }
            if ((labrelStatusMap = empentrelMap.get(employeeId)) != null && Boolean.TRUE.equals(labrelStatusMap.get("labrelstatusprd_stop"))) {
                String checkLabRelStatusPrdStop = AttFileCheckService.checkLabRelStatusPrdStop(ifPersonHaveFiles, labrelStatusMap, startDate, alertAll);
                if (HRStringUtils.isNotEmpty((String)checkLabRelStatusPrdStop)) {
                    this.addResultMsg((Map<Integer, Set<String>>)resultMap, i, checkLabRelStatusPrdStop);
                }
            } else {
                if (AttStatusEnum.ATT_STOP.getCode().equals(attFileDy.get("atttag.attendstatus"))) {
                    this.addResultMsg((Map<Integer, Set<String>>)resultMap, i, ResManager.loadKDString((String)"\u65e0\u6cd5\u65b0\u589e\u5df2\u505c\u6b62\u8003\u52e4\u7684\u6863\u6848\u3002", (String)"AttFileCheckService_7", (String)"wtc-wtp-business", (Object[])new Object[0]));
                }
                if (ifPersonHaveFiles) {
                    String billCheckMsg;
                    String msg;
                    Date effectDate = personExistFileDy.getDate("bsed");
                    String effectDateStr = WTCInteDateUtil.formatDateBySysTzAndUserFmt((Date)effectDate);
                    if (orgId == personExistFileDy.getLong("org.id")) {
                        msg = ResManager.loadKDString((String)"\u8be5\u8003\u52e4\u7ec4\u7ec7\u5df2\u5b58\u5728\u6b64\u4eba\u5458\u8003\u52e4\u6863\u6848\u3002", (String)"AttFileCheckService_1", (String)"wtc-wtp-business", (Object[])new Object[0]);
                        this.addResultMsg((Map<Integer, Set<String>>)resultMap, i, msg);
                    }
                    if ((WTCCollections.isEmpty(cusMap) || cusMap.get("sourcetype") == null) && alertAll && !startDate.after(effectDate)) {
                        msg = ResManager.loadKDString((String)"\u6863\u6848\u5f00\u59cb\u65e5\u671f\u53ea\u80fd\u665a\u4e8e{0}\u3002", (String)"AttFileCheckService_2", (String)"wtc-wtp-business", (Object[])new Object[]{effectDateStr});
                        this.addResultMsg((Map<Integer, Set<String>>)resultMap, i, msg);
                    }
                    AttStateInfoBO attStateInfoBO = (AttStateInfoBO)attStateInfoBOMap.get(WTCDynamicObjectUtils.getBaseDataId((DynamicObject)attFileDy, (String)"employee"));
                    HashSet msgSet = Sets.newHashSetWithExpectedSize((int)16);
                    AttFileModifyCheckService.getInstance().checkAttStateInfo(attRecordParam, msgSet, attFileDy, attStateInfoBO, true);
                    if (WTCCollections.isNotEmpty((Collection)msgSet)) {
                        this.addResultMsg((Map<Integer, Set<String>>)resultMap, i, msgSet);
                    }
                    personExistFileDy.set("bsed", (Object)attFileDy.getDate("bsed"));
                    if (Boolean.TRUE.equals(this.getOperateCheck()) && WTCStringUtils.isNotEmpty((String)(billCheckMsg = AttFileHelper.callIfHasBusinessData(personExistFileDy, PreDataAttend.PD_SHIFT)))) {
                        this.addResultMsg((Map<Integer, Set<String>>)resultMap, i, billCheckMsg);
                    }
                }
            }
            FileSaveDto fileSaveDto = depempToFileCoreDataMap.get(attFileDy.getLong("depemp.id"));
            if (fileSaveDto == null) {
                String msg = ResManager.loadKDString((String)"\u7ec4\u7ec7\u4eba\u4fe1\u606f\u4e0d\u5b8c\u6574\uff0c\u8bf7\u91cd\u65b0\u9009\u62e9\u4eba\u5458\u6216\u5c97\u4f4d\u3002", (String)"AttFileCheckService_3", (String)"wtc-wtp-business", (Object[])new Object[0]);
                this.addResultMsg((Map<Integer, Set<String>>)resultMap, i, msg);
            } else {
                Date empStartDate = fileSaveDto.getEmpStartDate();
                String empStartDateStr = WTCInteDateUtil.formatDateBySysTzAndUserFmt((Date)empStartDate);
                if (alertAll && startDate.compareTo(empStartDate) < 0) {
                    String msg = ResManager.loadKDString((String)"\u6863\u6848\u5f00\u59cb\u65e5\u671f\u4e0d\u80fd\u65e9\u4e8e\u6240\u5728\u884c\u653f\u7ec4\u7ec7\u7684\u4efb\u804c\u5f00\u59cb\u65e5\u671f{0}\u3002", (String)"AttFileCheckService_4", (String)"wtc-wtp-business", (Object[])new Object[]{empStartDateStr});
                    this.addResultMsg((Map<Integer, Set<String>>)resultMap, i, msg);
                }
            }
            if (!ifPersonHaveFiles) continue;
            this.addResultMsg((Map<Integer, Set<String>>)resultMap, i, "showNewConfirm");
        }
        return resultMap;
    }

    public void reSetAttTag(List<DynamicObject> attFileList) {
        Object[] attTagPkArr = attFileList.stream().filter(d -> WTCStringUtils.isEmpty((String)d.getString("atttag.attendstatus")) && d.getLong("atttag.id") != 0L).map(d -> d.get("atttag.id")).toArray();
        HRBaseServiceHelper attendTagBaseServiceHelper = new HRBaseServiceHelper("wtbd_attendtag");
        Map attendTagDyMap = Arrays.stream(attendTagBaseServiceHelper.loadDynamicObjectArray(attTagPkArr)).collect(Collectors.toMap(d -> d.getLong("id"), Function.identity()));
        for (DynamicObject attFileSet : attFileList) {
            DynamicObject attendTagDy;
            if (!WTCStringUtils.isEmpty((String)attFileSet.getString("atttag.attendstatus")) || (attendTagDy = (DynamicObject)attendTagDyMap.get(attFileSet.getLong("atttag.id"))) == null) continue;
            attFileSet.set("atttag", (Object)attendTagDy);
        }
    }

    private void addResultMsg(Map<Integer, Set<String>> resultMap, int i, String msg) {
        HashSet setErrMsg = resultMap.get(i);
        if (CollectionUtils.isEmpty(setErrMsg)) {
            setErrMsg = Sets.newHashSetWithExpectedSize((int)16);
            setErrMsg.add(msg);
            resultMap.put(i, setErrMsg);
        } else {
            setErrMsg.add(msg);
        }
    }

    private void addResultMsg(Map<Integer, Set<String>> resultMap, int i, Set<String> msgSet) {
        HashSet setErrMsg = resultMap.get(i);
        if (CollectionUtils.isEmpty(setErrMsg)) {
            setErrMsg = Sets.newHashSetWithExpectedSize((int)16);
            setErrMsg.addAll(msgSet);
            resultMap.put(i, setErrMsg);
        } else {
            setErrMsg.addAll(msgSet);
        }
    }

    private static String checkLabRelStatusPrdStop(boolean ifPersonHaveFiles, Map<String, Object> checkEmp, Date startDate, boolean alertAll) {
        if (ifPersonHaveFiles) {
            return ResManager.loadKDString((String)"\u8be5\u4eba\u5458\u5df2\u5b58\u5728\u6863\u6848\uff0c\u7528\u5de5\u5df2\u7ec8\u6b62\uff0c\u65e0\u6cd5\u65b0\u589e\u3002", (String)"AttFileCheckService_5", (String)"wtc-wtp-business", (Object[])new Object[0]);
        }
        if (alertAll && startDate.after((Date)checkEmp.get("enddate"))) {
            return ResManager.loadKDString((String)"\u6863\u6848\u5f00\u59cb\u65e5\u671f\u4e0d\u5141\u8bb8\u665a\u4e8e\u8be5\u4eba\u5458\u7684\u7528\u5de5\u7ed3\u675f\u65e5\u671f\u3002", (String)"AttFileCheckService_6", (String)"wtc-wtp-business", (Object[])new Object[0]);
        }
        return null;
    }

    private static String checkOrgStartDate(Long affiliateAdminOrgId, Date bsedDate, Map<Long, List<Map<String, Object>>> orgMap) {
        List<Map<String, Object>> orgVersionList;
        if (affiliateAdminOrgId == null || bsedDate == null) {
            return "";
        }
        if (!HRMapUtils.isEmpty(orgMap) && HRCollUtil.isNotEmpty(orgVersionList = orgMap.get(affiliateAdminOrgId))) {
            orgVersionList.sort(Comparator.comparing(map -> (Date)map.get("bsed")));
            Date orgDate = (Date)orgVersionList.get(0).get("bsed");
            String bsedDateStr = WTCInteDateUtil.formatDateBySysTzAndUserFmt((Date)bsedDate);
            String orgDateStr = WTCInteDateUtil.formatDateBySysTzAndUserFmt((Date)orgDate);
            if (bsedDate.before(orgDate)) {
                return AttFileKDString.getAttFileAndOrgBsedDateTips((Object[])new Object[]{bsedDateStr, orgDateStr});
            }
            return "";
        }
        return AttFileKDString.getAttFileAndOrgBsedDateNotExistTips();
    }

    private Map<Long, Map<String, Object>> getCheckEmpenTrelData(List<Long> employeeIdList) {
        List empenTrelMapList = HRPIMServiceImpl.getInstance().listBatchEmployeeAttachs(employeeIdList, null, "hrpi_empentrel");
        HashMap res = Maps.newHashMapWithExpectedSize((int)empenTrelMapList.size());
        for (Map empenTrelMap : empenTrelMapList) {
            long employeeId = (Long)empenTrelMap.get("employee");
            HashMap resMap = Maps.newHashMapWithExpectedSize((int)2);
            resMap.put("labrelstatusprd_stop", Boolean.FALSE);
            if (LABRELSTATUSPRD_STOP_ID.equals(empenTrelMap.get("labrelstatusprd_id"))) {
                resMap.put("labrelstatusprd_stop", Boolean.TRUE);
                resMap.put("enddate", empenTrelMap.get("enddate"));
            }
            res.put(employeeId, resMap);
        }
        return res;
    }

    public List<Map<String, Object>> getWsOverlapQueryParam(Set<Long> employeeIdSet, Map<Long, DynamicObject> checkWsMap, Map<Long, DynamicObject> checkFileMap) {
        ArrayList queryParam = Lists.newArrayListWithExpectedSize((int)16);
        AttFileQueryServiceImpl fileQueryInstance = AttFileQueryServiceImpl.getInstance();
        AttFileQueryParam attFileQueryParam = new AttFileQueryParam(false);
        attFileQueryParam.setEmpPersonSetIds(employeeIdSet);
        attFileQueryParam.setBeCurrent(Boolean.TRUE);
        attFileQueryParam.setProperties(WTCStringUtils.joinStr((String[])new String[]{AttFileQueryParam.baseProperties, ",", "person.id,person.number,person.name", ",", "employee.id"}));
        List fileQueryDys = fileQueryInstance.queryAttFiles(attFileQueryParam);
        Map<Long, List<DynamicObject>> fileMapByEmployeeId = fileQueryDys.stream().collect(Collectors.groupingBy(fileDy -> fileDy.getLong("employee.id")));
        Set fileBoIds = fileQueryDys.stream().map(dynamicObject -> dynamicObject.getLong("boid")).collect(Collectors.toSet());
        Map wsMap = AttFileScheduleServiceImpl.getInstance().queryAttFileSchedule(fileBoIds, AttFileScheduleEnum.WS, false);
        Date maxEndDate = WTCHisServiceHelper.getMaxEndDate();
        for (Map.Entry<Long, List<DynamicObject>> entryFile : fileMapByEmployeeId.entrySet()) {
            DynamicObject checkAttFile;
            Long employeeId = entryFile.getKey();
            if (employeeId == null || employeeId == 0L || (checkAttFile = checkFileMap.get(employeeId)) == null) continue;
            Date checkFileStartDate = checkAttFile.getDate("startdate");
            Date checkFileEndDate = checkAttFile.getDate("enddate");
            List<DynamicObject> fileBoDys = entryFile.getValue();
            fileBoDys.sort(Comparator.comparing(d -> d.getDate("startdate")));
            for (DynamicObject fileDy2 : fileBoDys) {
                long checkFileBoId;
                DynamicObject checkWsSch;
                Date fileStartDate = WTCDateUtils.addDays((Date)fileDy2.getDate("startdate"), (int)-1);
                Date fileEndDate = WTCDateUtils.addDays((Date)fileDy2.getDate("enddate"), (int)1);
                if (fileStartDate.after(checkFileEndDate) || fileEndDate.before(checkFileStartDate) || (checkWsSch = checkWsMap.get(checkFileBoId = checkAttFile.getLong("boid"))) == null) continue;
                Date checkWsStartDate = checkWsSch.getDate("bsed");
                Date checkWsEndDate = checkWsSch.getDate("bsled");
                if (fileStartDate.after(checkWsEndDate) || fileEndDate.before(checkWsStartDate)) continue;
                this.addParam(queryParam, wsMap, maxEndDate, fileDy2, checkAttFile, checkWsSch);
            }
        }
        return queryParam;
    }

    private void addParam(List<Map<String, Object>> queryParam, Map<Long, List<DynamicObject>> wsMap, Date maxEndDate, DynamicObject fileDy, DynamicObject checkAttFile, DynamicObject checkWsSch) {
        long checkFileBoId = checkAttFile.getLong("boid");
        long checkWsId = checkWsSch.getLong("ws.id");
        Date checkWsStartDate = checkWsSch.getDate("bsed");
        Date checkWsEndDate = checkWsSch.getDate("bsled");
        Date checkFileDyStartDate = checkAttFile.getDate("startdate");
        Date checkFileDyEndDate = checkAttFile.getDate("enddate");
        long fileBoId = fileDy.getLong("boid");
        List<DynamicObject> wsSchDyList = wsMap.get(fileBoId);
        if (!CollectionUtils.isEmpty(wsSchDyList)) {
            wsSchDyList.sort(Comparator.comparing(d -> d.getDate("bsed")));
            for (int i = 0; i < wsSchDyList.size(); ++i) {
                DynamicObject wsSchDy = wsSchDyList.get(i);
                Date wsStartDate = wsSchDy.getDate("bsed");
                Date wsEndDate = wsSchDy.getDate("bsled");
                long wsId = wsSchDy.getLong("ws.id");
                if (checkWsStartDate.compareTo(wsStartDate) > 0 && checkWsStartDate.compareTo(wsEndDate) <= 0) {
                    if (checkWsStartDate.before(checkFileDyStartDate)) {
                        checkWsStartDate = checkFileDyStartDate;
                    }
                    this.addQueryParam(queryParam, checkFileBoId, checkWsId, checkWsStartDate, wsId, true);
                }
                if (checkWsEndDate.compareTo(maxEndDate) < 0 && checkWsEndDate.compareTo(wsStartDate) >= 0 && checkWsEndDate.compareTo(wsEndDate) < 0) {
                    if (checkWsEndDate.after(checkFileDyEndDate)) {
                        checkWsEndDate = checkFileDyEndDate;
                    }
                    this.addQueryParam(queryParam, checkFileBoId, checkWsId, checkWsEndDate, wsId, false);
                }
                if (wsId == checkWsId) continue;
                if (checkWsStartDate.compareTo(wsStartDate) == 0) {
                    if (i == 0) continue;
                    DynamicObject lastWsSchDy = wsSchDyList.get(i - 1);
                    long lastWsId = lastWsSchDy.getLong("ws.id");
                    this.addQueryParam(queryParam, checkFileBoId, checkWsId, checkWsStartDate, lastWsId, true);
                }
                if (checkWsEndDate.compareTo(maxEndDate) >= 0 || checkWsEndDate.compareTo(wsEndDate) != 0 || i == wsSchDyList.size() - 1) continue;
                DynamicObject nextWsSchDy = wsSchDyList.get(i + 1);
                long nextWsId = nextWsSchDy.getLong("ws.id");
                this.addQueryParam(queryParam, checkFileBoId, checkWsId, checkWsStartDate, nextWsId, false);
            }
        }
    }

    private void addQueryParam(List<Map<String, Object>> queryParam, long checkFileBoId, long checkWsId, Date wsCheckDate, long wsId, boolean checkStartData) {
        HashMap queryMap = Maps.newHashMapWithExpectedSize((int)5);
        if (checkStartData) {
            queryMap.put("bizKey", this.getStartWsOverlapKey(checkFileBoId, checkWsId));
            queryMap.put("startDate", WTCDateUtils.addDays((Date)wsCheckDate, (int)-1));
            queryMap.put("endDate", wsCheckDate);
            queryMap.put("startDateWorkScheduleId", wsId);
            queryMap.put("endDateWorkScheduleId", checkWsId);
        } else {
            queryMap.put("bizKey", this.getEndWsOverlapKey(checkFileBoId, checkWsId));
            queryMap.put("startDate", wsCheckDate);
            queryMap.put("endDate", WTCDateUtils.addDays((Date)wsCheckDate, (int)1));
            queryMap.put("startDateWorkScheduleId", checkWsId);
            queryMap.put("endDateWorkScheduleId", wsId);
        }
        queryParam.add(queryMap);
    }

    public String getStartWsOverlapKey(long checkFileBoId, long checkWsId) {
        return WTCStringUtils.joinStr((String[])new String[]{String.valueOf(checkFileBoId), "_", String.valueOf(checkWsId)});
    }

    public String getEndWsOverlapKey(long checkFileBoId, long checkWsId) {
        return WTCStringUtils.joinStr((String[])new String[]{String.valueOf(checkFileBoId), "_", String.valueOf(checkWsId), "_"});
    }

    public Map<Long, List<String>> checkAdjust(Long orgId, List<Long> boIds) {
        if (CollectionUtils.isEmpty(boIds)) {
            return null;
        }
        HashMap<Long, List<String>> allErrMsgMap = new HashMap<Long, List<String>>(16);
        if (null == orgId) {
            String orgNull = ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u65b0\u7684\u8003\u52e4\u7ba1\u7406\u7ec4\u7ec7\u3002", (String)"AttFileCheckService_8", (String)"wtc-wtp-business", (Object[])new Object[0]);
            allErrMsgMap.put(0L, Collections.singletonList(orgNull));
            return allErrMsgMap;
        }
        List<DynamicObject> needCheckBos = this.getNeedCheckBos(boIds, Boolean.TRUE, Boolean.FALSE);
        this.checkTouchBo(orgId, needCheckBos, allErrMsgMap);
        this.checkPlan(orgId, boIds, allErrMsgMap);
        return allErrMsgMap;
    }

    public Map<Long, List<String>> checkAdjustShow(List<Long> boIds) {
        if (CollectionUtils.isEmpty(boIds)) {
            return null;
        }
        HashMap<Long, List<String>> allErrMsgMap = new HashMap<Long, List<String>>(16);
        List<DynamicObject> needCheckBos = this.getNeedCheckBos(boIds, Boolean.FALSE, Boolean.FALSE);
        this.checkSettle(needCheckBos, allErrMsgMap);
        this.checkBill(boIds, allErrMsgMap);
        return allErrMsgMap;
    }

    private void checkBill(List<Long> boIds, Map<Long, List<String>> allErrMsgMap) {
        Map<String, List<DynamicObject>> billDataMap = this.getCheckDataMap(boIds);
        HashMap<Long, Set<String>> errMap = new HashMap<Long, Set<String>>(16);
        for (Map.Entry<String, List<DynamicObject>> entry : billDataMap.entrySet()) {
            String billType = entry.getKey();
            List<DynamicObject> result = entry.getValue();
            if (CollectionUtils.isEmpty(result)) continue;
            HashMap<Long, List<DynamicObject>> boIdBillDataMap = new HashMap<Long, List<DynamicObject>>(16);
            if ("signCardData".equalsIgnoreCase(billType)) {
                Map<Long, List<DynamicObject>> collect = result.stream().collect(Collectors.groupingBy(d -> WTCDynamicObjectUtils.getBaseDataId((DynamicObject)d, (String)"attfilebo.id")));
                boIdBillDataMap.putAll(collect);
            } else if ("batchVaBillData".equals(billType)) {
                boIdBillDataMap.putAll(result.stream().flatMap(dys -> dys.getDynamicObjectCollection("entryentity").stream()).collect(Collectors.groupingBy(d -> WTCDynamicObjectUtils.getBaseDataId((DynamicObject)d, (String)"attfile"))));
                billType = "vaBillData";
            } else {
                boIdBillDataMap.putAll(result.stream().collect(Collectors.groupingBy(d -> WTCDynamicObjectUtils.getBaseDataId((DynamicObject)d, (String)"attfile"))));
            }
            this.collectErrMap(billType, new HashSet<Long>(boIds), boIdBillDataMap, errMap);
        }
        for (Map.Entry<String, List<Object>> entry : errMap.entrySet()) {
            ArrayList<String> errByBoIdLists = new ArrayList<String>(10);
            Long boId = (Long)((Object)entry.getKey());
            Set errLists = (Set)((Object)entry.getValue());
            String fillMsg = String.join((CharSequence)"\u3001", errLists);
            String err = ResManager.loadKDString((String)"\u5f53\u524d\u6863\u6848\u4e0b\u5df2\u5b58\u5728%s\uff0c\u4e0d\u5141\u8bb8\u8c03\u6574\u3002\u5efa\u8bae\u5e9f\u5f03\u6863\u6848\u540e\u91cd\u65b0\u521b\u5efa\u3002", (String)"AttFileCheckService_10", (String)"wtc-wtp-business", (Object[])new Object[]{fillMsg});
            errByBoIdLists.add(err);
            this.fillErrMap(allErrMsgMap, errByBoIdLists, boId);
        }
    }

    public Map<String, List<DynamicObject>> getCheckDataMap(List<Long> boIds) {
        HashMap<String, List<DynamicObject>> billDataMap = new HashMap<String, List<DynamicObject>>(10);
        if (WTCCollections.isEmpty(boIds)) {
            return billDataMap;
        }
        HashSet<Long> attFileBoIdSet = new HashSet<Long>(boIds);
        String selectProperties = "id,attfilebo.id,status,source,remark,modifytype";
        List<DynamicObject> scBillData = AttFileServiceImpl.getInstance().querySignCardsData(attFileBoIdSet, "id,attfilebo.id,status,source,remark,modifytype");
        if (WTCCollections.isNotEmpty(scBillData)) {
            billDataMap.put("signCardData", scBillData);
        }
        String properties = "id,attfile";
        BusitripBillQueryParam tpQueryParam = new BusitripBillQueryParam();
        tpQueryParam.setProperties("id,attfile");
        tpQueryParam.setAttFileBoIdSet(attFileBoIdSet);
        List<DynamicObject> tpBillData = AttFileServiceImpl.getInstance().queryTpBillData(tpQueryParam);
        if (WTCCollections.isNotEmpty(tpBillData)) {
            billDataMap.put("tpBillData", tpBillData);
        }
        VaBillQueryParam vaBillQueryParam = new VaBillQueryParam();
        vaBillQueryParam.setProperties("id,attfile");
        vaBillQueryParam.setAttFileBoIdSet(attFileBoIdSet);
        vaBillQueryParam.setApplyTypeVal((List)Lists.newArrayList((Object[])new String[]{BillApplyTypeEnum.SELF.getCode(), BillApplyTypeEnum.OTHER.getCode()}));
        List<DynamicObject> vaBillData = AttFileServiceImpl.getInstance().queryVaBillData(vaBillQueryParam);
        if (WTCCollections.isNotEmpty(vaBillData)) {
            billDataMap.put("vaBillData", vaBillData);
        }
        OtBillQueryParam otBillQueryParam = new OtBillQueryParam();
        otBillQueryParam.setProperties("id,attfile");
        otBillQueryParam.setAttFileBoIdSet(attFileBoIdSet);
        List<DynamicObject> otBillData = AttFileServiceImpl.getInstance().queryOtBillData(otBillQueryParam);
        if (WTCCollections.isNotEmpty(otBillData)) {
            billDataMap.put("otBillData", otBillData);
        }
        SupSignBillQueryParam signBillQueryParam = new SupSignBillQueryParam();
        signBillQueryParam.setProperties("id,attfile");
        signBillQueryParam.setAttFileBoIdSet(attFileBoIdSet);
        List<DynamicObject> signCardData = AttFileServiceImpl.getInstance().querySignCardData(signBillQueryParam);
        if (WTCCollections.isNotEmpty(signCardData)) {
            billDataMap.put("supBillData", signCardData);
        }
        BusitripBillQueryParam busitripBillQueryParam = new BusitripBillQueryParam();
        busitripBillQueryParam.setProperties("id,attfile");
        busitripBillQueryParam.setAttFileBoIdSet(attFileBoIdSet);
        List<DynamicObject> swsBillData = AttFileServiceImpl.getInstance().querySwsBillData(busitripBillQueryParam);
        if (WTCCollections.isNotEmpty(swsBillData)) {
            billDataMap.put("swsBillData", swsBillData);
        }
        VaBatchBillQueryParam vaBatchBillQueryParam = new VaBatchBillQueryParam();
        VaBillQueryParam batchVaBillQueryParam = new VaBillQueryParam();
        batchVaBillQueryParam.setAttFileBoIdSet(attFileBoIdSet);
        vaBatchBillQueryParam.setSingleQueryParam(batchVaBillQueryParam);
        List<DynamicObject> batchVaBillData = AttFileServiceImpl.getInstance().queryBatchVaBillData(vaBatchBillQueryParam);
        if (WTCCollections.isNotEmpty(batchVaBillData)) {
            billDataMap.put("batchVaBillData", batchVaBillData);
        }
        return billDataMap;
    }

    private void collectErrMap(String billType, Set<Long> attFileBoIdSet, Map<Long, List<DynamicObject>> boIdBillDataMap, Map<Long, Set<String>> errMap) {
        String billName = this.getBillNameByBIllTye(billType);
        if (HRStringUtils.isEmpty((String)billName)) {
            return;
        }
        for (Long boId : attFileBoIdSet) {
            List<DynamicObject> list = boIdBillDataMap.get(boId);
            if (CollectionUtils.isEmpty(list)) continue;
            Set<String> strings = errMap.get(boId);
            if (strings != null) {
                strings.add(billName);
                continue;
            }
            HashSet errList = Sets.newHashSetWithExpectedSize((int)10);
            errList.add(billName);
            errMap.put(boId, errList);
        }
    }

    private void checkSettle(List<DynamicObject> needCheckBos, Map<Long, List<String>> allErrMsgMap) {
        if (LOG.isInfoEnabled()) {
            LOG.info("AttFileCheckService#checkSettle#needCheckBos:{}", needCheckBos);
        }
        Set<Long> boIds = needCheckBos.stream().map(needCheckBo -> WTCDynamicObjectUtils.getBaseDataId((DynamicObject)needCheckBo, (String)"boid")).collect(Collectors.toSet());
        HashMap<Long, String> attStateInfoCheckMap = new HashMap<Long, String>(16);
        List<DynamicObject> attStateInfoList = AttStateInfoService.getInstance().queryAttStateInfo(boIds);
        for (DynamicObject dynamicObject : attStateInfoList) {
            String checkCount;
            Long fileBoID = WTCDynamicObjectUtils.getBaseDataId((DynamicObject)dynamicObject, (String)"fileboid");
            Date frozenstartdate = dynamicObject.getDate("frozenstartdate");
            Date frozenenddate = dynamicObject.getDate("frozenenddate");
            Date lockTo = dynamicObject.getDate("lockto");
            Date storageto = dynamicObject.getDate("storageto");
            if (null == frozenstartdate && null == frozenenddate && null == lockTo && null == storageto || !WTCStringUtils.isEmpty((String)(checkCount = (String)attStateInfoCheckMap.get(fileBoID)))) continue;
            attStateInfoCheckMap.put(fileBoID, "1");
        }
        for (Map.Entry entry : attStateInfoCheckMap.entrySet()) {
            Long boId = (Long)entry.getKey();
            if (!"1".equals(attStateInfoCheckMap.get(boId))) continue;
            String settleInfoErrMsg = ResManager.loadKDString((String)"\u5f53\u524d\u6863\u6848\u5df2\u8fdb\u884c\u4e86\u7ed3\u7b97\u64cd\u4f5c\uff0c\u4e0d\u5141\u8bb8\u8c03\u6574\u3002\u5efa\u8bae\u5e9f\u5f03\u6863\u6848\u540e\u91cd\u65b0\u521b\u5efa\u3002", (String)"AttFileCheckService_9", (String)"wtc-wtp-business", (Object[])new Object[0]);
            ArrayList<String> errList = new ArrayList<String>();
            errList.add(settleInfoErrMsg);
            this.fillErrMap(allErrMsgMap, errList, boId);
        }
    }

    public List<DynamicObject> getNeedCheckBos(List<Long> boIds, Boolean isCurrentVersion, Boolean isLoad) {
        AttFileQueryParam attFileQueryParam = new AttFileQueryParam();
        attFileQueryParam.setSetBoIds(new HashSet<Long>(boIds));
        attFileQueryParam.setAttStatus(null);
        attFileQueryParam.setBeCurrent(isCurrentVersion);
        attFileQueryParam.setAuthCheck(Boolean.FALSE);
        HashSet set = Sets.newHashSet((Object[])new String[]{"-3", "-2", "-1", "0", "1", "2"});
        attFileQueryParam.setHisStatus((Set)set);
        if (!isLoad.booleanValue()) {
            attFileQueryParam.setProperties("id,boid,sourcevid,attperson.id,bsed,bsled,number,startdate,enddate,dependency.name,dependency.id,org.id,empposorgrel.id,cmpemp.id,empposorgrel.adminorg.id,cmpemp.company.id,empposorgrel.job.id,empposorgrel.position.id,affiliateadminorg.id,empgroup.id,dependencytype.id,workplace.id,ismanaged,atttag.id,employee");
        }
        return AttFileQueryServiceImpl.getInstance().queryAttFiles(attFileQueryParam);
    }

    private void checkTouchBo(Long orgId, List<DynamicObject> attFileObjects, Map<Long, List<String>> allErrMsgMap) {
        Map<Long, Long> employeeIdBoIdMap = attFileObjects.stream().collect(Collectors.toMap(dy -> WTCDynamicObjectUtils.getBaseDataId((DynamicObject)dy, (String)"employee"), dy -> dy.getLong("boid"), (a, b) -> b));
        List employeeIds = attFileObjects.stream().map(d -> WTCDynamicObjectUtils.getBaseDataId((DynamicObject)d, (String)"employee")).collect(Collectors.toList());
        AttFileQueryParam attFileQueryPamTwo = new AttFileQueryParam();
        attFileQueryPamTwo.setEmpPersonSetIds(new HashSet(employeeIds));
        attFileQueryPamTwo.setAttStatus(null);
        attFileQueryPamTwo.setBeCurrent(Boolean.TRUE);
        attFileQueryPamTwo.setAuthCheck(Boolean.FALSE);
        attFileQueryPamTwo.setProperties("id,boid,attperson.id,bsed,bsled,number,startdate,enddate,dependency.name,dependency.id,org.id,empposorgrel.id,cmpemp.id,empposorgrel.adminorg.id,cmpemp.company.id,empposorgrel.job.id,empposorgrel.position.id,affiliateadminorg.id,empgroup.id,dependencytype.id,workplace.id,ismanaged,atttag.id,employee");
        List allAttFileObjects = AttFileQueryServiceImpl.getInstance().queryAttFiles(attFileQueryPamTwo);
        Map<Long, List<DynamicObject>> employeeIdAttFileMap = allAttFileObjects.stream().collect(Collectors.groupingBy(d -> WTCDynamicObjectUtils.getBaseDataId((DynamicObject)d, (String)"employee")));
        for (Map.Entry<Long, List<DynamicObject>> entry : employeeIdAttFileMap.entrySet()) {
            Long employeeId = entry.getKey();
            List<DynamicObject> attFileByPersonIdList = entry.getValue();
            attFileByPersonIdList.sort(Comparator.comparing(d -> d.getDate("startdate")));
            Long boId = employeeIdBoIdMap.get(employeeId);
            int h = attFileByPersonIdList.size();
            ArrayList<String> preNextBoErrMsgList = new ArrayList<String>();
            for (int i = 0; i < h; ++i) {
                DynamicObject dy2;
                DynamicObject dynamicObject = attFileByPersonIdList.get(i);
                Long boIdFromDB = dynamicObject.getLong("boid");
                if (!boIdFromDB.equals(boId)) continue;
                if (i - 1 >= 0) {
                    dy2 = attFileByPersonIdList.get(i - 1);
                    this.fillAttFileErrMsg(orgId, preNextBoErrMsgList, dy2);
                }
                if (i + 1 > h - 1) continue;
                dy2 = attFileByPersonIdList.get(i + 1);
                this.fillAttFileErrMsg(orgId, preNextBoErrMsgList, dy2);
            }
            if (CollectionUtils.isEmpty(preNextBoErrMsgList)) continue;
            this.fillErrMap(allErrMsgMap, preNextBoErrMsgList, boId);
        }
    }

    private void checkPlan(Long orgId, List<Long> boIds, Map<Long, List<String>> allErrMsgMap) {
        List needCheckAtt = AttFileEntrySkipPageEnum.getNeedCheckSkipPageEnum();
        if (CollectionUtils.isEmpty((Collection)needCheckAtt)) {
            return;
        }
        HashMap<String, Map<List<DynamicObject>, List<DynamicObject>>> attFileEntrySkipPairMap = new HashMap<String, Map<List<DynamicObject>, List<DynamicObject>>>();
        HashMap<Long, List<String>> tempErrMsgMap = new HashMap<Long, List<String>>();
        for (AttFileEntrySkipPageEnum attFileEntrySkipPage : needCheckAtt) {
            List<DynamicObject> planDys = this.getPlanDys(orgId, attFileEntrySkipPage);
            AttFileScheduleEnum attFileSchedule = AttFileScheduleEnum.getAttFileScheduleEnumByKey((String)attFileEntrySkipPage.getKey());
            if (null == attFileSchedule) {
                return;
            }
            AttFileScheduleQueryParam scheduleQueryParam = new AttFileScheduleQueryParam();
            scheduleQueryParam.setFileBoIdSet(new HashSet<Long>(boIds));
            scheduleQueryParam.setLoad(Boolean.FALSE);
            String selects = "id,attfileid ," + attFileSchedule.getKey() + "";
            scheduleQueryParam.setProperties(selects);
            List attFileScheduleDys = AttFileScheduleServiceImpl.getInstance().queryAttFileScheduleByList(attFileSchedule, scheduleQueryParam);
            if (CollectionUtils.isEmpty(planDys) || CollectionUtils.isEmpty((Collection)attFileScheduleDys)) continue;
            HashMap<List<DynamicObject>, List> pair = new HashMap<List<DynamicObject>, List>();
            pair.put(planDys, attFileScheduleDys);
            attFileEntrySkipPairMap.put(attFileEntrySkipPage.getKey(), pair);
        }
        this.collectCheckPlanMap(attFileEntrySkipPairMap, tempErrMsgMap);
        this.comBoxErrMsg(tempErrMsgMap, allErrMsgMap);
    }

    private void collectCheckPlanMap(Map<String, Map<List<DynamicObject>, List<DynamicObject>>> attFileEntrySkipPairMap, Map<Long, List<String>> tempErrMsgMap) {
        for (Map.Entry<String, Map<List<DynamicObject>, List<DynamicObject>>> skip : attFileEntrySkipPairMap.entrySet()) {
            String attFileEntrySkipPageKey = skip.getKey();
            Map<List<DynamicObject>, List<DynamicObject>> skipValue = skip.getValue();
            if (skipValue == null) continue;
            for (Map.Entry<List<DynamicObject>, List<DynamicObject>> skipEntry : skipValue.entrySet()) {
                List<DynamicObject> planDys = skipEntry.getKey();
                List<DynamicObject> attFileScheduleDys = skipEntry.getValue();
                Map<Long, List<DynamicObject>> personIdAttFileMap = attFileScheduleDys.stream().collect(Collectors.groupingBy(d -> WTCDynamicObjectUtils.getBaseDataId((DynamicObject)d, (String)"attfileid")));
                Set planIdSets = planDys.stream().map(d -> d.getLong("id")).collect(Collectors.toSet());
                for (Map.Entry<Long, List<DynamicObject>> entry : personIdAttFileMap.entrySet()) {
                    AttFileScheduleEnum attFileScheduleEnum;
                    Long boId = entry.getKey();
                    ArrayList<String> errMsgList = new ArrayList<String>();
                    List<DynamicObject> dyDataList = entry.getValue();
                    Set attFileScheduleIdSets = dyDataList.stream().map(d -> d.getLong(attFileEntrySkipPageKey)).collect(Collectors.toSet());
                    if (planIdSets.containsAll(attFileScheduleIdSets) || null == (attFileScheduleEnum = AttFileScheduleEnum.getAttFileScheduleEnumByKey((String)attFileEntrySkipPageKey))) continue;
                    String pageId = attFileScheduleEnum.getPageId();
                    String scheduleName = AttFileScheduleEnum.getScheduleNameByPageId((String)pageId);
                    errMsgList.add(scheduleName);
                    this.fillErrMap(tempErrMsgMap, errMsgList, boId);
                }
            }
        }
    }

    private void comBoxErrMsg(Map<Long, List<String>> tempErrMsgMap, Map<Long, List<String>> allErrMsgMap) {
        ArrayList<String> errByBoIdLists = new ArrayList<String>(10);
        for (Map.Entry<Long, List<String>> entry : tempErrMsgMap.entrySet()) {
            Long boId = entry.getKey();
            List<String> errLists = entry.getValue();
            if (CollectionUtils.isEmpty(errLists)) continue;
            String fillMsg = String.join((CharSequence)"\u3001", errLists);
            String err = ResManager.loadKDString((String)"\u9009\u62e9\u7684\u8003\u52e4\u7ba1\u7406\u7ec4\u7ec7\u4e0e\u5f53\u524d\u6863\u6848\u4e0b\u7684%s\u5b58\u5728\u7ba1\u63a7\u51b2\u7a81\uff0c\u65e0\u6cd5\u8c03\u6574\u3002\u8bf7\u9009\u62e9\u53ef\u540c\u65f6\u9002\u7528\u4e8e\u4e24\u4e2a\u8003\u52e4\u7ec4\u7ec7\u7684\u65b9\u6848\uff0c\u7136\u540e\u91cd\u8bd5\u3002", (String)"AttFileCheckService_12", (String)"wtc-wtp-business", (Object[])new Object[]{fillMsg});
            errByBoIdLists.add(err);
            this.fillErrMap(allErrMsgMap, errByBoIdLists, boId);
        }
    }

    private void fillAttFileErrMsg(Long orgId, List<String> preNextBoErrMsgList, DynamicObject dy) {
        Long preBoOrgId;
        if (dy != null && orgId.equals(preBoOrgId = Long.valueOf(dy.getLong("org.id")))) {
            String affFileNumber = dy.getString("number");
            String affFileNumberMsg = ResManager.loadKDString((String)"\u6240\u9009\u8003\u52e4\u7ba1\u7406\u7ec4\u7ec7\u4e0e\u4eba\u5458\u7684\u53e6\u4e00\u4efd\u8003\u52e4\u6863\u6848%s\u76f8\u540c\uff0c\u8bf7\u4fee\u6539\u3002", (String)"AttFileCheckService_11", (String)"wtc-wtp-business", (Object[])new Object[]{affFileNumber});
            preNextBoErrMsgList.add(affFileNumberMsg);
        }
    }

    private void fillErrMap(Map<Long, List<String>> allErrMsgMap, List<String> errMsgList, Long boId) {
        if (!CollectionUtils.isEmpty(errMsgList)) {
            List<String> strings = allErrMsgMap.get(boId);
            if (null != strings) {
                strings.addAll(errMsgList);
            } else {
                allErrMsgMap.put(boId, errMsgList);
            }
        }
    }

    private List<DynamicObject> getPlanDys(Long orgId, AttFileEntrySkipPageEnum metaFlag) {
        String selects = "name,id ";
        QFilter baseDataFilter = BaseDataServiceHelper.getBaseDataFilter((String)metaFlag.getValue(), (Long)orgId);
        if (baseDataFilter != null) {
            QFilter[] checkQFilters = new QFilter[]{baseDataFilter};
            DynamicObject[] dys = new HRBaseServiceHelper(metaFlag.getValue()).queryOriginalArray("name,id ", checkQFilters);
            return Arrays.stream(dys).collect(Collectors.toList());
        }
        return new ArrayList<DynamicObject>();
    }

    private String getBillNameByBIllTye(String billType) {
        String billName;
        switch (billType) {
            case "signCardData": {
                billName = ResManager.loadKDString((String)"\u539f\u59cb\u5361", (String)"AttFileServiceImpl_7", (String)"wtc-wtp-business", (Object[])new Object[0]);
                break;
            }
            case "tpBillData": {
                billName = ResManager.loadKDString((String)"\u51fa\u5dee\u5355", (String)"AttFileServiceImpl_3", (String)"wtc-wtp-business", (Object[])new Object[0]);
                break;
            }
            case "vaBillData": {
                billName = ResManager.loadKDString((String)"\u4f11\u5047\u5355", (String)"AttFileServiceImpl_5", (String)"wtc-wtp-business", (Object[])new Object[0]);
                break;
            }
            case "otBillData": {
                billName = ResManager.loadKDString((String)"\u52a0\u73ed\u5355", (String)"AttFileServiceImpl_4", (String)"wtc-wtp-business", (Object[])new Object[0]);
                break;
            }
            case "supBillData": {
                billName = ResManager.loadKDString((String)"\u8865\u7b7e\u5355", (String)"AttFileServiceImpl_6", (String)"wtc-wtp-business", (Object[])new Object[0]);
                break;
            }
            case "swsBillData": {
                billName = ResManager.loadKDString((String)"\u8c03\u73ed\u5355", (String)"AttFileServiceImpl_10", (String)"wtc-wtp-business", (Object[])new Object[0]);
                break;
            }
            default: {
                billName = "";
            }
        }
        return billName;
    }

    public Map<Long, List<DynamicObject>> getEmployeeFileMap(Set<Long> employeeIdSet) {
        AttFileQueryParam attFileQueryParam = new AttFileQueryParam(false);
        attFileQueryParam.setqFilter(new QFilter("employee.id", "in", employeeIdSet));
        attFileQueryParam.setBeCurrent(Boolean.TRUE);
        attFileQueryParam.setAuthCheck(Boolean.FALSE);
        attFileQueryParam.setProperties("id,boid,name,number,startdate,employee.id");
        List files = AttFileQueryServiceImpl.getInstance().queryAttFiles(attFileQueryParam);
        return files.stream().collect(Collectors.groupingBy(fileDy -> fileDy.getLong("employee.id")));
    }

    public Map<Long, Long> geFileBoToEmployeeMap(Set<Long> employeeIdSet) {
        HashMap synFileBoIdMap = Maps.newHashMapWithExpectedSize((int)employeeIdSet.size());
        if (WTCCollections.isNotEmpty(employeeIdSet)) {
            Map<Long, List<DynamicObject>> employeeFileMap = AttFileCheckService.getInstance().getEmployeeFileMap(employeeIdSet);
            for (Map.Entry<Long, List<DynamicObject>> entries : employeeFileMap.entrySet()) {
                List<DynamicObject> value = entries.getValue();
                value.sort(Comparator.comparing(dy -> dy.getDate("startdate")));
                Collections.reverse(value);
                WTCCollectionIndexUtil.getEleFromList(value, (int)0).ifPresent(ele -> {
                    Long cfr_ignored_0 = (Long)synFileBoIdMap.put(ele.getLong("boid"), entries.getKey());
                });
            }
        }
        return synFileBoIdMap;
    }

    public Map<Long, Boolean> checkAttFileIsDiscard(Set<Long> attFileIds) {
        AttFileQueryParam queryParam = new AttFileQueryParam(false);
        queryParam.setUsableStatus((Set)Sets.newHashSet((Object[])new String[]{"0", "-1"}));
        queryParam.setProperties("id, usablestatus");
        queryParam.setqFilter(new QFilter("id", "in", attFileIds));
        List dyList = AttFileQueryServiceImpl.getInstance().queryAttFiles(queryParam);
        return dyList.stream().collect(Collectors.toMap(dy -> dy.getLong("id"), dy -> "-1".equals(dy.getString("usablestatus")), (a, b) -> a));
    }

    public Map<String, List<DynamicObject>> getStopAttCheckDataMap(List<Long> boIds, boolean isCheckAuth, Date startDate, Date endDate) {
        LinkedHashMap<String, List<DynamicObject>> billDataMap = new LinkedHashMap<String, List<DynamicObject>>(10);
        if (WTCCollections.isEmpty(boIds)) {
            return billDataMap;
        }
        HashSet<Long> attFileBoIdSet = new HashSet<Long>(boIds);
        String selectProperties = "id,attfilebo.id,status,source,remark,modifytype";
        List<DynamicObject> scBillData = AttFileServiceImpl.getInstance().querySignCardsData(attFileBoIdSet, startDate, endDate, isCheckAuth, "id,attfilebo.id,status,source,remark,modifytype");
        if (WTCCollections.isNotEmpty(scBillData)) {
            billDataMap.put("signCardData", scBillData);
        }
        String properties = "id,attfile,billno";
        OtBillQueryParam otBillQueryParam = new OtBillQueryParam();
        otBillQueryParam.setProperties("");
        otBillQueryParam.setAttFileBoIdSet(attFileBoIdSet);
        otBillQueryParam.setStartDate(startDate);
        otBillQueryParam.setEndDate(endDate);
        List<DynamicObject> otBillData = AttFileServiceImpl.getInstance().queryBillForRealTimeDutyDate((BillQueryParam)otBillQueryParam, AttFileStopAttBillQueryEnum.OT, isCheckAuth);
        if (WTCCollections.isNotEmpty(otBillData)) {
            billDataMap.put("otBillData", otBillData);
        }
        VaBillQueryParam vaBillQueryParam = new VaBillQueryParam();
        vaBillQueryParam.setProperties("");
        vaBillQueryParam.setApplyTypeVal((List)Lists.newArrayList((Object[])new String[]{BillApplyTypeEnum.SELF.getCode(), BillApplyTypeEnum.OTHER.getCode()}));
        vaBillQueryParam.setAttFileBoIdSet(attFileBoIdSet);
        vaBillQueryParam.setStartDate(startDate);
        vaBillQueryParam.setEndDate(endDate);
        List<DynamicObject> vaBillData = AttFileServiceImpl.getInstance().queryBillForRealTimeDutyDate((BillQueryParam)vaBillQueryParam, AttFileStopAttBillQueryEnum.VA, isCheckAuth);
        if (WTCCollections.isNotEmpty(vaBillData)) {
            billDataMap.put("vaBillData", vaBillData);
        }
        BusitripBillQueryParam tpQueryParam = new BusitripBillQueryParam();
        tpQueryParam.setProperties("");
        tpQueryParam.setAttFileBoIdSet(attFileBoIdSet);
        tpQueryParam.setStartDate(startDate);
        tpQueryParam.setEndDate(endDate);
        List<DynamicObject> tpBillData = AttFileServiceImpl.getInstance().queryBillForRealTimeDutyDate((BillQueryParam)tpQueryParam, AttFileStopAttBillQueryEnum.TP, isCheckAuth);
        if (WTCCollections.isNotEmpty(tpBillData)) {
            billDataMap.put("tpBillData", tpBillData);
        }
        SupSignBillQueryParam signBillQueryParam = new SupSignBillQueryParam();
        signBillQueryParam.setProperties("");
        signBillQueryParam.setAttFileBoIdSet(attFileBoIdSet);
        signBillQueryParam.setStartDate(startDate);
        signBillQueryParam.setEndDate(endDate);
        List<DynamicObject> signCardData = AttFileServiceImpl.getInstance().queryBillForRealTimeDutyDate((BillQueryParam)signBillQueryParam, AttFileStopAttBillQueryEnum.SIGNCARD, isCheckAuth);
        if (WTCCollections.isNotEmpty(signCardData)) {
            billDataMap.put("supBillData", signCardData);
        }
        BillQueryParam billQueryParam = new BillQueryParam();
        if (isCheckAuth) {
            BillPermQueryParam billPermQueryParam = new BillPermQueryParam(Long.valueOf(RequestContext.get().getCurrUserId()), "wtam", "wts_swshiftbill", "org", "47150e89000000ac", new HashMap(0));
            billQueryParam.setBillPermQueryParam(billPermQueryParam);
        }
        billQueryParam.setProperties("");
        billQueryParam.setAttFileBoIdSet(attFileBoIdSet);
        billQueryParam.setStartDate(startDate);
        billQueryParam.setEndDate(endDate);
        List swsDataList = (List)HRMServiceHelper.invokeBizService((String)"wtc", (String)"wts", (String)"ISwsBillService", (String)"queryBill", (Object[])new Object[]{billQueryParam});
        if (WTCCollections.isNotEmpty((Collection)swsDataList)) {
            billDataMap.put("swsBillData", swsDataList);
        }
        VaBillQueryParam vaBillQueryParam1 = new VaBillQueryParam();
        vaBillQueryParam1.setProperties("");
        vaBillQueryParam1.setAttFileBoIdSet(attFileBoIdSet);
        vaBillQueryParam1.setStartDate(startDate);
        vaBillQueryParam1.setEndDate(endDate);
        VaBatchBillQueryParam vaBatchBillQueryParam = new VaBatchBillQueryParam();
        vaBatchBillQueryParam.setSingleQueryParam(vaBillQueryParam1);
        List<DynamicObject> batchVaBillDataList = AttFileServiceImpl.getInstance().queryBatchVaBillForRealTimeDutyDate(vaBatchBillQueryParam, AttFileStopAttBillQueryEnum.BATCH_VA, isCheckAuth);
        if (WTCCollections.isNotEmpty(batchVaBillDataList)) {
            billDataMap.put("batchVaBillData", batchVaBillDataList);
        }
        return billDataMap;
    }
}

