/*
 * Decompiled with CFR 0.152.
 */
package kd.wtc.wtp.business.attfile;

import java.util.Arrays;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.orm.util.CollectionUtils;
import kd.hr.hbp.business.servicehelper.HRBaseServiceHelper;
import kd.hr.hbp.common.util.HRObjectUtils;
import kd.wtc.wtbs.business.history.service.WTCHisServiceHelper;
import kd.wtc.wtbs.business.model.attendperson.HRPIEntityPropertyConst;
import kd.wtc.wtbs.business.util.WTCDynamicObjectUtils;
import kd.wtc.wtbs.business.web.mservice.HRPIMServiceImpl;
import kd.wtc.wtbs.common.helper.WTCAppContextHelper;
import kd.wtc.wtbs.common.util.WTCDateUtils;
import kd.wtc.wtbs.common.util.third.collect.Maps;
import kd.wtc.wtbs.common.util.third.util.StringUtils;
import kd.wtc.wtp.common.model.file.FileSaveDto;

public class AttFileCoreDataService {
    public static AttFileCoreDataService getInstance() {
        return (AttFileCoreDataService)WTCAppContextHelper.getBean(AttFileCoreDataService.class);
    }

    public Map<Long, FileSaveDto> getFileSaveDtoMapByEmpIds(List<Long> empPosOrgRelIdList) {
        if (CollectionUtils.isEmpty(empPosOrgRelIdList)) {
            return Collections.emptyMap();
        }
        List empPosOrgRelDyListAll = HRPIMServiceImpl.getInstance().listInfoById(empPosOrgRelIdList, "hrpi_empposorgrel");
        List empPosOrgRelDyList = empPosOrgRelDyListAll.stream().filter(dy -> dy.getBoolean("isprimary")).collect(Collectors.toList());
        List personIdList = empPosOrgRelDyList.stream().map(emp -> emp.getLong("person.id")).collect(Collectors.toList());
        List contrWorkLocArr = HRPIMServiceImpl.getInstance().listIntersectBusinessInfo("hrpi_contrworkloc", StringUtils.join(Arrays.asList(HRPIEntityPropertyConst.CONTRWORKLOC_FIELDS), (String)","), WTCHisServiceHelper.getMinEndDate(), WTCHisServiceHelper.getMaxEndDate(), personIdList, null, null);
        Map<Long, List<DynamicObject>> contrWorkLocArrGroupBy = contrWorkLocArr.stream().collect(Collectors.groupingBy(d -> WTCDynamicObjectUtils.getBaseDataId((DynamicObject)d, (String)"employee")));
        HashMap fileSaveDtoHashMap = Maps.newHashMapWithExpectedSize((int)empPosOrgRelDyList.size());
        for (DynamicObject empPosOrgRelDy : empPosOrgRelDyList) {
            FileSaveDto fileSaveDto = new FileSaveDto();
            fileSaveDto.setPersonId(Long.valueOf(empPosOrgRelDy.getLong("person.id")));
            fileSaveDto.setPersonNumber(empPosOrgRelDy.getString("person.number"));
            fileSaveDto.setPersonName(empPosOrgRelDy.getString("person.name"));
            fileSaveDto.setEmployeeId(Long.valueOf(empPosOrgRelDy.getLong("employee.id")));
            fileSaveDto.setCmpempId(Long.valueOf(empPosOrgRelDy.getLong("cmpemp.id")));
            fileSaveDto.setDepempId(Long.valueOf(empPosOrgRelDy.getLong("depemp.id")));
            fileSaveDto.setAdminOrgId(Long.valueOf(empPosOrgRelDy.getLong("adminorg.id")));
            fileSaveDto.setCompanyId(Long.valueOf(empPosOrgRelDy.getLong("company.id")));
            fileSaveDto.setJobId(Long.valueOf(empPosOrgRelDy.getLong("job.id")));
            fileSaveDto.setPositionId(Long.valueOf(empPosOrgRelDy.getLong("position.id")));
            fileSaveDto.setManagingScopeId(Long.valueOf(empPosOrgRelDy.getLong("cmpemp.managingscope.id")));
            fileSaveDto.setWorkPlaceId(Long.valueOf(empPosOrgRelDy.getLong("workplace.id")));
            Date empPosOrgRelStartDate = empPosOrgRelDy.getDate("startdate");
            fileSaveDto.setEmpStartDate(empPosOrgRelStartDate);
            fileSaveDto.setEmpEndDate(empPosOrgRelDy.getDate("enddate"));
            fileSaveDto.setEmpPosOrgRelId(Long.valueOf(empPosOrgRelDy.getLong("id")));
            fileSaveDtoHashMap.put(empPosOrgRelDy.getLong("depemp_id"), fileSaveDto);
            List<DynamicObject> contrWorkLocDyList = contrWorkLocArrGroupBy.get(empPosOrgRelDy.getLong("employee.id"));
            long agreedLocationId = this.getAgreeLocation(contrWorkLocDyList, empPosOrgRelStartDate);
            fileSaveDto.setAgreedLocation(Long.valueOf(agreedLocationId));
        }
        return fileSaveDtoHashMap;
    }

    private long getAgreeLocation(List<DynamicObject> contrWorkLocDyList, Date empPosOrgRelStartDate) {
        if (CollectionUtils.isEmpty(contrWorkLocDyList)) {
            return 0L;
        }
        for (DynamicObject contrWorkLocDy : contrWorkLocDyList) {
            Date dateEnd;
            Date dateStart = contrWorkLocDy.getDate("startdate");
            if (!WTCDateUtils.betweenDay((Date)empPosOrgRelStartDate, (Date)dateStart, (Date)(dateEnd = contrWorkLocDy.getDate("enddate")))) continue;
            return contrWorkLocDy.getLong("agreedlocation.id");
        }
        return 0L;
    }

    public void initFileByFileSaveDto(FileSaveDto fileSaveDto, DynamicObject fileDynamicObject, IDataModel model) {
        DynamicObject personDy = this.getDy("hrpi_person", fileSaveDto.getPersonId());
        Object personObj = fileDynamicObject.get("person");
        if (personObj instanceof DynamicObject && ((DynamicObject)personObj).getDataEntityType().getProperties().containsKey((Object)"personindexid")) {
            personDy.set("personindexid", (Object)fileDynamicObject.getLong("person.personindexid"));
        }
        personDy.set("number", (Object)fileSaveDto.getPersonNumber());
        this.setDataEntity(model, fileDynamicObject, "personnum", fileSaveDto.getPersonNumber());
        this.setDataEntity(model, fileDynamicObject, "person", personDy);
        this.setDataEntity(model, fileDynamicObject, "name", fileSaveDto.getPersonName());
        this.setDataEntity(model, fileDynamicObject, "employee", this.getDy("hrpi_employee", fileSaveDto.getEmployeeId()));
        this.setDataEntity(model, fileDynamicObject, "cmpemp", this.getDy("hrpi_cmpemp", fileSaveDto.getCmpempId()));
        if (model != null) {
            model.setValue("hrpiempposorgrel", null);
            model.setValue("empposorgrel", null);
        }
        this.updateFileEmpDataByFileSaveDto(fileSaveDto, fileDynamicObject, model);
        this.setDataEntity(model, fileDynamicObject, "bsed", fileSaveDto.getEmpStartDate());
        if (0L == fileDynamicObject.getLong("id")) {
            this.setDataEntity(model, fileDynamicObject, "startdate", fileSaveDto.getEmpStartDate());
            this.setDataEntity(model, fileDynamicObject, "enddate", WTCHisServiceHelper.getMaxEndDate());
        }
    }

    public void updateFileEmpDataByFileSaveDto(FileSaveDto fileSaveDto, DynamicObject fileDynamicObject, IDataModel model) {
        this.setDataEntity(model, fileDynamicObject, "depemp", this.getDy("hrpi_depemp", fileSaveDto.getDepempId()));
        if (HRObjectUtils.isEmpty((Object)fileDynamicObject.getDynamicObject("workplace")) && fileSaveDto.getWorkPlaceId() != null) {
            this.setDataEntity(model, fileDynamicObject, "workplace", this.getDy("hbss_workplace", fileSaveDto.getWorkPlaceId()));
        }
        if (HRObjectUtils.isEmpty((Object)fileDynamicObject.getDynamicObject("affiliateadminorg"))) {
            this.setDataEntity(model, fileDynamicObject, "affiliateadminorg", this.getDy("haos_adminorghr", fileSaveDto.getAdminOrgId()));
        }
        this.setDataEntity(model, fileDynamicObject, "company", this.getDy("haos_adminorghr", fileSaveDto.getCompanyId()));
        this.setDataEntity(model, fileDynamicObject, "adminorg", this.getDy("haos_adminorghr", fileSaveDto.getAdminOrgId()));
        this.setDataEntity(model, fileDynamicObject, "position", this.getDy("hbpm_positionhr", fileSaveDto.getPositionId()));
        this.setDataEntity(model, fileDynamicObject, "job", this.getDy("hbjm_jobhr", fileSaveDto.getJobId()));
        this.setDataEntity(model, fileDynamicObject, "managingscope", this.getDy("hbss_managingscope", fileSaveDto.getManagingScopeId()));
        this.setDataEntity(model, fileDynamicObject, "agreedlocation", this.getDy("hbss_workplace", fileSaveDto.getAgreedLocation()));
        this.setDataEntity(model, fileDynamicObject, "hrpiempposorgrel", this.getDy("hrpi_empposorgrel", fileSaveDto.getEmpPosOrgRelId()));
        this.setDataEntity(model, fileDynamicObject, "empposorgrel", this.getDy("wtp_depempjob", fileSaveDto.getEmpPosOrgRelId()));
    }

    private DynamicObject getDy(String entity, Long id) {
        HRBaseServiceHelper affiliateAdminOrgHelper = new HRBaseServiceHelper(entity);
        DynamicObject dy = affiliateAdminOrgHelper.generateEmptyDynamicObject();
        dy.set("id", (Object)id);
        return dy;
    }

    private void setDataEntity(IDataModel model, DynamicObject fileDataEntity, String key, Object value) {
        if (model != null) {
            model.setValue(key, value);
        } else {
            fileDataEntity.set(key, value);
        }
    }
}

