/*
 * Decompiled with CFR 0.152.
 */
package kd.wtc.wtp.business.attfile;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;
import kd.bos.dataentity.OperateOption;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.form.IFormView;
import kd.bos.form.ShowType;
import kd.bos.list.ListShowParameter;
import kd.bos.orm.util.CollectionUtils;
import kd.hr.hbp.common.util.HRStringUtils;
import kd.wtc.wtbs.business.bill.BillCommonService;
import kd.wtc.wtbs.business.history.service.WTCHisServiceHelper;
import kd.wtc.wtbs.business.license.CertControlType;
import kd.wtc.wtbs.business.license.CertService;
import kd.wtc.wtbs.business.servicehelper.WTCServiceHelper;
import kd.wtc.wtbs.business.util.WTCDynamicObjectUtils;
import kd.wtc.wtbs.business.web.attperiod.PerAttPeriodQueryServiceImpl;
import kd.wtc.wtbs.business.web.file.AttFileQueryServiceImpl;
import kd.wtc.wtbs.business.web.integration.AttIntegrationServiceImpl;
import kd.wtc.wtbs.common.bill.OpenBillListParam;
import kd.wtc.wtbs.common.enums.bill.BillApplyTypeEnum;
import kd.wtc.wtbs.common.enums.bill.BillTypeEnum;
import kd.wtc.wtbs.common.helper.WTCAppContextHelper;
import kd.wtc.wtbs.common.model.attfile.AttFileQueryParam;
import kd.wtc.wtbs.common.model.period.PerAttPeriod;
import kd.wtc.wtbs.common.model.period.PerAttPeriodQueryParam;
import kd.wtc.wtbs.common.predata.wtp.PreDataAttend;
import kd.wtc.wtbs.common.util.WTCCollectionIndexUtil;
import kd.wtc.wtbs.common.util.WTCCollections;
import kd.wtc.wtbs.common.util.WTCStringUtils;
import kd.wtc.wtbs.common.util.third.collect.Maps;
import kd.wtc.wtp.business.attfile.AttFileCheckService;
import kd.wtc.wtp.business.attfile.AttFileServiceImpl;
import kd.wtc.wtp.business.attstateinfo.AttStateInfoService;
import kd.wtc.wtp.business.utils.ViewUtils;
import kd.wtc.wtp.common.constants.AttFileConstants;
import kd.wtc.wtp.common.enums.FileCheckBusDataEnum;
import kd.wtc.wtp.common.kdstring.AttFileKDString;
import kd.wtc.wtp.common.model.attstateinfo.AttStateInfoBO;
import kd.wtc.wtp.common.model.file.AttFileDiscardCheckModel;

public class AttFileDiscardCheckService
implements AttFileConstants {
    public static AttFileDiscardCheckService getInstance() {
        return (AttFileDiscardCheckService)WTCAppContextHelper.getBean(AttFileDiscardCheckService.class);
    }

    public Map<Long, List<String>> checkDiscardFile(List<DynamicObject> dataEntities, AttFileDiscardCheckModel attFileDiscardCheckModel, OperateOption option) {
        if (WTCCollections.isEmpty(dataEntities)) {
            return Collections.emptyMap();
        }
        List boIdList = dataEntities.stream().map(dy -> dy.getLong("boid")).collect(Collectors.toList());
        HashMap resultMsgList = Maps.newHashMapWithExpectedSize((int)dataEntities.size());
        for (Long boId : boIdList) {
            resultMsgList.put(boId, new ArrayList());
        }
        this.checkAttFileDiscard(dataEntities, resultMsgList);
        if (AttFileDiscardCheckService.checkResultMsg(resultMsgList)) {
            return resultMsgList;
        }
        if (attFileDiscardCheckModel != null && !attFileDiscardCheckModel.isFromCoordination()) {
            this.checkAttFileLatestDiscardAuth(dataEntities, resultMsgList);
            if (AttFileDiscardCheckService.checkResultMsg(resultMsgList)) {
                return resultMsgList;
            }
        }
        if (!"fromcoordination".equals(option.getVariables().get("fromcoordination"))) {
            this.checkAttFileVersionAuth(dataEntities, resultMsgList);
        }
        if (AttFileDiscardCheckService.checkResultMsg(resultMsgList)) {
            return resultMsgList;
        }
        if (WTCStringUtils.isEmpty((String)((String)option.getVariables().get("fromcoordination")))) {
            this.checkCertWithEmployeeHasMutiFile(dataEntities, resultMsgList);
        }
        return resultMsgList;
    }

    private void checkCertWithEmployeeHasMutiFile(List<DynamicObject> dataEntities, Map<Long, List<String>> resultMsgMap) {
        Set employeeIdSet = dataEntities.stream().filter(dy -> PreDataAttend.PD_LEAVE == WTCDynamicObjectUtils.getBaseDataId((DynamicObject)dy, (String)"atttag")).map(dataEntity -> WTCDynamicObjectUtils.getBaseDataId((DynamicObject)dataEntity, (String)"employee")).collect(Collectors.toSet());
        Set excludeFileBoIds = dataEntities.stream().map(dataEntity -> dataEntity.getLong("boid")).collect(Collectors.toSet());
        AttFileQueryParam attFileQueryParam = new AttFileQueryParam(false);
        attFileQueryParam.setEmpPersonSetIds(employeeIdSet);
        attFileQueryParam.setBoDelSetIds(excludeFileBoIds);
        attFileQueryParam.setProperties("person, boid");
        attFileQueryParam.setBeCurrent(Boolean.TRUE);
        List multiFileDys = AttFileQueryServiceImpl.getInstance().queryAttFiles(attFileQueryParam);
        if (kd.bos.util.CollectionUtils.isEmpty((Collection)multiFileDys)) {
            return;
        }
        Map<Long, Long> multiPersonToFileBoMap = multiFileDys.stream().collect(Collectors.toMap(multiFileDy -> WTCDynamicObjectUtils.getBaseDataId((DynamicObject)multiFileDy, (String)"person"), multiFileDy -> multiFileDy.getLong("boid"), (a, b) -> a));
        Map checkMap = CertService.certControl((String)"wtp", (String)"wtp_attfilebase", new ArrayList<Long>(multiPersonToFileBoMap.keySet()), (CertControlType)CertControlType.VALIDATORANDAPPLYCHECK);
        Map msg = (Map)checkMap.get("msg");
        if (HRStringUtils.equals((String)String.valueOf(checkMap.get("isforbidden")), (String)"true")) {
            for (List<String> tipList : resultMsgMap.values()) {
                tipList.add((String)msg.get("message"));
            }
        }
    }

    public void checkAttFileDiscard(List<DynamicObject> dataEntities, Map<Long, List<String>> resultMsgList) {
        for (DynamicObject dataEntity : dataEntities) {
            if (!"-1".equals(dataEntity.getString("usablestatus"))) continue;
            AttFileDiscardCheckService.addResultMsg(resultMsgList, dataEntity.getLong("boid"), AttFileKDString.fileDiscarded());
        }
    }

    public Map<Long, Long> checkAttFileLatestDiscardAuth(List<DynamicObject> dataEntities, Map<Long, List<String>> resultMsgList) {
        HashMap boToLastBoMap = Maps.newHashMapWithExpectedSize((int)dataEntities.size());
        Set<Long> employeeIdSet = dataEntities.stream().map(dy1 -> dy1.getLong("employee.id")).collect(Collectors.toSet());
        Map personAttFileMap = dataEntities.stream().collect(Collectors.toMap(d -> d.getLong("employee.id"), Function.identity(), (a, b) -> b));
        Map<Long, List<DynamicObject>> fileMapByPersonId = AttFileCheckService.getInstance().getEmployeeFileMap(employeeIdSet);
        for (Map.Entry<Long, List<DynamicObject>> entryFile : fileMapByPersonId.entrySet()) {
            Long employeeId = entryFile.getKey();
            if (employeeId == null || employeeId == 0L) continue;
            long discardBoId = ((DynamicObject)personAttFileMap.get(employeeId)).getLong("boid");
            List<DynamicObject> filesByPerson = fileMapByPersonId.get(employeeId);
            filesByPerson.sort(Comparator.comparing(dy -> dy.getDate("startdate")));
            Collections.reverse(filesByPerson);
            WTCCollectionIndexUtil.getEleFromList(filesByPerson, (int)0).ifPresent(ele -> {
                if (discardBoId != ele.getLong("boid")) {
                    AttFileDiscardCheckService.addResultMsg(resultMsgList, discardBoId, AttFileKDString.discardLastFile((String)ele.getString("number")));
                }
            });
            WTCCollectionIndexUtil.getEleFromList(filesByPerson, (int)1).ifPresent(ele -> boToLastBoMap.put(discardBoId, ele.getLong("boid")));
        }
        return boToLastBoMap;
    }

    public void checkAttFileVersionAuth(List<DynamicObject> dataEntities, Map<Long, List<String>> resultMsgList) {
        Set fileBoIdSet = dataEntities.stream().map(d -> d.getLong("boid")).collect(Collectors.toSet());
        AttFileQueryParam attFileQueryParamAuth = new AttFileQueryParam();
        attFileQueryParamAuth.setSetBoIds(fileBoIdSet);
        attFileQueryParamAuth.setProperties("id,boid");
        List hasAuthFileList = AttFileQueryServiceImpl.getInstance().queryAttFiles(attFileQueryParamAuth);
        Map<Long, List<DynamicObject>> hasAuthFileMap = hasAuthFileList.stream().collect(Collectors.groupingBy(fileDy -> fileDy.getLong("boid")));
        AttFileQueryParam attFileQueryParamNoAuth = new AttFileQueryParam();
        attFileQueryParamNoAuth.setSetBoIds(fileBoIdSet);
        attFileQueryParamNoAuth.setAuthCheck(Boolean.FALSE);
        attFileQueryParamNoAuth.setProperties("id,boid");
        List noAuthFileList = AttFileQueryServiceImpl.getInstance().queryAttFiles(attFileQueryParamNoAuth);
        Map<Long, List<DynamicObject>> allFileMapCheck = noAuthFileList.stream().collect(Collectors.groupingBy(fileDy -> fileDy.getLong("boid")));
        for (Map.Entry<Long, List<DynamicObject>> entryFile : allFileMapCheck.entrySet()) {
            Long boId = entryFile.getKey();
            if (boId == null || boId == 0L) continue;
            List<DynamicObject> allFilesCheck = allFileMapCheck.get(boId);
            List<DynamicObject> hasAuthFilesCheck = hasAuthFileMap.get(boId);
            if (!WTCCollections.isNotEmpty(allFilesCheck) || !WTCCollections.isEmpty(hasAuthFilesCheck) && allFilesCheck.size() <= hasAuthFilesCheck.size()) continue;
            AttFileDiscardCheckService.addResultMsg(resultMsgList, boId, AttFileKDString.discardNoAuth());
        }
    }

    public void samePersonOtherBoProcess(Map<Long, Long> boToLastBoMap, Map<Long, DynamicObject> personAttFileMap, Map<Long, List<String>> resultMsgList) {
        this.samePersonOtherBoProcessNew(boToLastBoMap, personAttFileMap, resultMsgList, Maps.newLinkedHashMapWithExpectedSize((int)16));
    }

    public void samePersonOtherBoProcessNew(Map<Long, Long> boToLastBoMap, Map<Long, DynamicObject> personAttFileMap, Map<Long, List<String>> resultMsgList, Map<Long, List<String>> topTipsMap) {
        Map attPushData;
        Collection<Long> lastBoIdCollection = boToLastBoMap.values();
        List<AttStateInfoBO> attStateInfoBOS = AttStateInfoService.getInstance().queryAttStateInfoByBoid(new ArrayList<Long>(lastBoIdCollection));
        Map<Long, Date> discardBoIdLockDateMap = attStateInfoBOS.stream().filter(i -> i.getLockTo() != null).collect(Collectors.toMap(AttStateInfoBO::getFileBoid, AttStateInfoBO::getLockTo));
        AttFileQueryParam attFileQueryParam = new AttFileQueryParam(false);
        attFileQueryParam.setBeCurrent(Boolean.TRUE);
        attFileQueryParam.setSetBoIds(new HashSet<Long>(lastBoIdCollection));
        attFileQueryParam.setProperties("boid,enddate,number");
        List lastFileList = AttFileQueryServiceImpl.getInstance().queryAttFiles(attFileQueryParam);
        Map lastFileMap = lastFileList.stream().collect(Collectors.toMap(dy -> dy.getLong("boid"), Function.identity(), (a, b) -> a));
        List dates = lastFileList.stream().map(dy -> dy.getDate("enddate")).collect(Collectors.toList());
        Date minEndDate = dates.stream().min(Date::compareTo).orElseGet(WTCHisServiceHelper::getMinEndDate);
        Date maxEndDate = dates.stream().max(Date::compareTo).orElseGet(WTCHisServiceHelper::getMaxEndDate);
        PerAttPeriodQueryParam perAttPeriodQueryParam = new PerAttPeriodQueryParam();
        perAttPeriodQueryParam.setAttFileBoIdSet(new HashSet<Long>(lastBoIdCollection));
        perAttPeriodQueryParam.setStartDate(minEndDate);
        perAttPeriodQueryParam.setEndDate(maxEndDate);
        List perAttPeriodList = PerAttPeriodQueryServiceImpl.getInstance().queryPerAttPeriodEntity(perAttPeriodQueryParam);
        Map<Long, List<PerAttPeriod>> lastPerAttPeriodMap = perAttPeriodList.stream().collect(Collectors.groupingBy(PerAttPeriod::getFileBoId));
        HashMap attPushFileBoIdMap = Maps.newHashMapWithExpectedSize((int)boToLastBoMap.size());
        HashMap lastBoToBoMap = Maps.newHashMapWithExpectedSize((int)boToLastBoMap.size());
        boToLastBoMap.forEach((discardBoId, lastBoId) -> {
            DynamicObject lastFile = (DynamicObject)lastFileMap.get(lastBoId);
            DynamicObject discardFile = (DynamicObject)personAttFileMap.get(discardBoId);
            lastBoToBoMap.put(lastBoId, discardBoId);
            if (lastFile != null && discardFile != null) {
                AttFileDiscardCheckService.addResultMsg(topTipsMap, discardBoId, AttFileKDString.discardBaseMsg2((String)lastFile.getString("number")));
                AttFileDiscardCheckService.addResultMsg(topTipsMap, discardBoId, "\n");
                AttFileDiscardCheckService.addResultMsg(resultMsgList, discardBoId, AttFileKDString.discardNormalAtt1());
                AttFileDiscardCheckService.addResultMsg(resultMsgList, discardBoId, "\n");
                Date endDate = lastFile.getDate("enddate");
                List lastPerAttPeriodList = (List)lastPerAttPeriodMap.get(lastBoId);
                if (WTCCollections.isNotEmpty((Collection)lastPerAttPeriodList)) {
                    AttFileDiscardCheckService.addResultMsg(topTipsMap, discardBoId, AttFileKDString.discardBaseMsg1((String)lastFile.getString("number"), (String)((PerAttPeriod)lastPerAttPeriodList.get(lastPerAttPeriodList.size() - 1)).getPerAttPeriodName()));
                    Optional<PerAttPeriod> any = lastPerAttPeriodList.stream().filter(d -> d.getPerAttBeginDate().compareTo(endDate) <= 0 && d.getPerAttEndDate().compareTo(endDate) >= 0).findAny();
                    if (any.isPresent()) {
                        PerAttPeriod perAttPeriod = any.get();
                        Date perAttBeginDate = perAttPeriod.getPerAttBeginDate();
                        Date lackDate = (Date)discardBoIdLockDateMap.get(lastBoId);
                        if (lackDate != null && lackDate.compareTo(perAttBeginDate) >= 0) {
                            AttFileDiscardCheckService.addResultMsg(resultMsgList, discardBoId, AttFileKDString.discardAttPeriodLock());
                            AttFileDiscardCheckService.addResultMsg(resultMsgList, discardBoId, "\n");
                        }
                        attPushFileBoIdMap.put(lastBoId, perAttPeriod);
                    }
                }
            }
        });
        if (WTCCollections.isNotEmpty((Map)attPushFileBoIdMap) && WTCCollections.isNotEmpty((Map)(attPushData = (Map)WTCServiceHelper.invokeBizService((String)"wtc", (String)"wtis", (String)"IPayAttDataService", (String)"queryPushData", (Object[])new Object[]{new ArrayList(attPushFileBoIdMap.keySet()), "id", attPushFileBoIdMap.values().stream().map(PerAttPeriod::getAttPeriodId).collect(Collectors.toList())})))) {
            attPushFileBoIdMap.forEach((fileBoId, perAttPeriod) -> {
                if (attPushData.get(fileBoId) != null) {
                    AttFileDiscardCheckService.addResultMsg(resultMsgList, (Long)lastBoToBoMap.get(fileBoId), AttFileKDString.discardAttPushMsg());
                }
            });
        }
    }

    private static void addResultMsg(Map<Long, List<String>> resultMsgSet, Long boid, String msg) {
        List<String> msgSet = resultMsgSet.get(boid);
        msgSet.add(msg);
        resultMsgSet.put(boid, msgSet);
    }

    private static boolean checkResultMsg(Map<Long, List<String>> map) {
        for (Map.Entry<Long, List<String>> entry : map.entrySet()) {
            List<String> dy = entry.getValue();
            if (CollectionUtils.isEmpty(dy)) continue;
            return true;
        }
        return false;
    }

    public void checkDataHyperLinkClick(Object returnData, IFormView view, List<Long> fileBoIdList) {
        FileCheckBusDataEnum fileCheckBusDataEnum = FileCheckBusDataEnum.getEnumByCode((String)returnData.toString());
        if (WTCCollections.isEmpty(fileBoIdList)) {
            return;
        }
        if (fileCheckBusDataEnum != null) {
            ListShowParameter listShowParameter = null;
            switch (fileCheckBusDataEnum) {
                case OT: {
                    OpenBillListParam openBillListParam = new OpenBillListParam(BillTypeEnum.OVERTIMEBILL, BillApplyTypeEnum.OTHER, fileBoIdList);
                    openBillListParam.setInitBillStatus(AttFileServiceImpl.getInstance().fillBillStatus());
                    listShowParameter = BillCommonService.openBillList((OpenBillListParam)openBillListParam);
                    break;
                }
                case VA: {
                    OpenBillListParam openBillListParam1 = new OpenBillListParam(BillTypeEnum.VACATIONBILL, BillApplyTypeEnum.OTHER, fileBoIdList);
                    openBillListParam1.setInitBillStatus(AttFileServiceImpl.getInstance().fillBillStatus());
                    listShowParameter = BillCommonService.openBillList((OpenBillListParam)openBillListParam1);
                    break;
                }
                case BUS: {
                    OpenBillListParam openBillListParam2 = new OpenBillListParam(BillTypeEnum.EVECTIONBILL, BillApplyTypeEnum.OTHER, fileBoIdList);
                    openBillListParam2.setInitBillStatus(AttFileServiceImpl.getInstance().fillBillStatus());
                    listShowParameter = BillCommonService.openBillList((OpenBillListParam)openBillListParam2);
                    break;
                }
                case SUP: {
                    OpenBillListParam openBillListParam3 = new OpenBillListParam(BillTypeEnum.SUPPLEMENTBILL, BillApplyTypeEnum.OTHER, fileBoIdList);
                    openBillListParam3.setInitBillStatus(AttFileServiceImpl.getInstance().fillBillStatus());
                    listShowParameter = BillCommonService.openBillList((OpenBillListParam)openBillListParam3);
                    break;
                }
                case ATT_PUSH: {
                    AttIntegrationServiceImpl.getInstance().jumpPayAttPushTask(view);
                    break;
                }
                case SIGN_CARD: {
                    HashMap param = Maps.newHashMapWithExpectedSize((int)16);
                    param.put("attFileBoIdList", fileBoIdList);
                    ViewUtils.jumpSignCardListView(param, view, ShowType.MainNewTabPage);
                    break;
                }
                case SWS: {
                    OpenBillListParam openBillListParam4 = new OpenBillListParam(BillTypeEnum.ADJUSTMENTBILL, BillApplyTypeEnum.OTHER, fileBoIdList);
                    openBillListParam4.setInitBillStatus(AttFileServiceImpl.getInstance().fillBillStatus());
                    listShowParameter = BillCommonService.openBillList((OpenBillListParam)openBillListParam4);
                    break;
                }
                case BATCH_VA: {
                    OpenBillListParam openBillListParam5 = new OpenBillListParam(BillTypeEnum.VACATIONBILLBATCH, BillApplyTypeEnum.BATCH, fileBoIdList);
                    openBillListParam5.setInitBillStatus(AttFileServiceImpl.getInstance().fillBillStatus());
                    listShowParameter = BillCommonService.openBillList((OpenBillListParam)openBillListParam5);
                    break;
                }
            }
            if (listShowParameter != null) {
                view.showForm(listShowParameter);
            }
        }
    }
}

