/*
 * Decompiled with CFR 0.152.
 */
package kd.wtc.wtp.business.attfile;

import com.alibaba.fastjson.JSONObject;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.atomic.AtomicReference;
import java.util.stream.Collectors;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.metadata.IMetadata;
import kd.bos.dataentity.metadata.clr.DataEntityPropertyCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.AppMetadataCache;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.filter.CommonBaseDataFilterColumn;
import kd.bos.filter.FilterColumn;
import kd.bos.form.CloseCallBack;
import kd.bos.form.ConfirmCallBackListener;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.MessageBoxOptions;
import kd.bos.form.OpenStyle;
import kd.bos.form.ShowType;
import kd.bos.form.StyleCss;
import kd.bos.form.control.Control;
import kd.bos.form.events.FilterContainerInitArgs;
import kd.bos.form.field.BasedataEdit;
import kd.bos.form.field.TextEdit;
import kd.bos.form.field.events.BeforeF7SelectEvent;
import kd.bos.form.field.events.BeforeF7SelectListener;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.list.ListShowParameter;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.permission.api.HasPermOrgResult;
import kd.bos.servicehelper.MetadataServiceHelper;
import kd.bos.servicehelper.permission.PermissionServiceHelper;
import kd.hr.hbp.business.domain.model.newhismodel.api.revise.HisReviseRecordReturnParamBo;
import kd.hr.hbp.business.servicehelper.HRBaseServiceHelper;
import kd.hr.hbp.common.api.HrApiResponse;
import kd.hr.hbp.common.util.HRDateTimeUtils;
import kd.hr.hbp.common.util.HRDynamicObjectUtils;
import kd.hr.hbp.common.util.HRObjectUtils;
import kd.hr.hbp.common.util.HRStringUtils;
import kd.hr.hies.business.export.ExportHeaderWriterFormat;
import kd.hr.impt.common.dto.ImportBillData;
import kd.wtc.wtbs.business.auth.HRAuthService;
import kd.wtc.wtbs.business.bill.BillCommonService;
import kd.wtc.wtbs.business.history.service.WTCHisServiceHelper;
import kd.wtc.wtbs.business.servicehelper.WTCServiceHelper;
import kd.wtc.wtbs.business.util.WTCDynamicObjectUtils;
import kd.wtc.wtbs.business.util.WTCPermUtils;
import kd.wtc.wtbs.business.web.DataBaseValidatorService;
import kd.wtc.wtbs.business.web.file.AttFileQueryServiceImpl;
import kd.wtc.wtbs.business.web.file.schedule.AttFileScheduleServiceImpl;
import kd.wtc.wtbs.business.web.mservice.HRPIMServiceImpl;
import kd.wtc.wtbs.common.bill.OpenBillListParam;
import kd.wtc.wtbs.common.enums.AttFilePlanEnum;
import kd.wtc.wtbs.common.enums.AttFileScheduleEnum;
import kd.wtc.wtbs.common.enums.AttModeEnum;
import kd.wtc.wtbs.common.enums.bill.BillApplyTypeEnum;
import kd.wtc.wtbs.common.enums.bill.BillTypeEnum;
import kd.wtc.wtbs.common.enums.file.AttStatusEnum;
import kd.wtc.wtbs.common.enums.file.FileTypeEnum;
import kd.wtc.wtbs.common.model.attfile.AttFileQueryParam;
import kd.wtc.wtbs.common.model.attfile.AttFileScheduleQueryParam;
import kd.wtc.wtbs.common.predata.hbss.PreDataBizType;
import kd.wtc.wtbs.common.predata.wtp.PreDataAttend;
import kd.wtc.wtbs.common.util.SystemParamQueryUtil;
import kd.wtc.wtbs.common.util.Tuple;
import kd.wtc.wtbs.common.util.WTCCollectionIndexUtil;
import kd.wtc.wtbs.common.util.WTCCollections;
import kd.wtc.wtbs.common.util.WTCDateUtils;
import kd.wtc.wtbs.common.util.WTCInteDateUtil;
import kd.wtc.wtbs.common.util.WTCStringUtils;
import kd.wtc.wtbs.common.util.third.collect.Lists;
import kd.wtc.wtbs.common.util.third.collect.Maps;
import kd.wtc.wtbs.common.util.third.collect.Sets;
import kd.wtc.wtp.business.attfile.AttFileCheckService;
import kd.wtc.wtp.business.utils.ViewUtils;
import kd.wtc.wtp.common.constants.AttFileConstants;
import kd.wtc.wtp.common.constants.MuTableTuple;
import kd.wtc.wtp.common.enums.FileCheckBusDataEnum;
import kd.wtc.wtp.common.enums.FileGroupEnum;
import kd.wtc.wtp.common.kdstring.AttFileKDString;

public class AttFileHelper
implements AttFileConstants {
    private static final Log LOGGER = LogFactory.getLog(AttFileHelper.class);
    private static final Set<Long> AUTH_EMP_GROUP_TYPE_IDS = Sets.newHashSetWithExpectedSize((int)16);

    private AttFileHelper() {
    }

    public static Set<Long> getAuthEmpGroupType() {
        if (AUTH_EMP_GROUP_TYPE_IDS.isEmpty()) {
            AUTH_EMP_GROUP_TYPE_IDS.add(PreDataBizType.PD_104010L);
        }
        return AUTH_EMP_GROUP_TYPE_IDS;
    }

    public static void empGroupFilterContainer(FilterContainerInitArgs args, String empGroupFieldName) {
        List commonFilterColumns = args.getCommonFilterColumns();
        for (FilterColumn commonFilterColumn : commonFilterColumns) {
            String fieldName = commonFilterColumn.getFieldName();
            if (!empGroupFieldName.equals(fieldName)) continue;
            List comboItems = ((CommonBaseDataFilterColumn)commonFilterColumn).getComboItems();
            HRBaseServiceHelper empGroupServiceHelper = new HRBaseServiceHelper("hbss_empgroup");
            DynamicObject[] empGroupDys = empGroupServiceHelper.queryOriginalArray("id", new QFilter[]{new QFilter("bussinessfield", "not in", AttFileHelper.getAuthEmpGroupType())});
            if (empGroupDys == null || empGroupDys.length <= 0) continue;
            Set empGroupIds = Arrays.stream(empGroupDys).map(emp -> String.valueOf(emp.getLong("id"))).collect(Collectors.toSet());
            comboItems.removeIf(next -> empGroupIds.contains(next.getValue()));
        }
    }

    public static Map<Long, List<Map<String, Object>>> getDirectSuperiorByDepempId(List<Long> depId) {
        return HRPIMServiceImpl.getInstance().getDirectSuperiorByDepempId(depId);
    }

    public static List<Map<String, Object>> getMainChargeByOrg(List<Long> adminOrgId) {
        return HRPIMServiceImpl.getInstance().getMainChargeByOrg(adminOrgId);
    }

    public static void setIsManaged(String name, IDataModel model) {
        if ("adminorg".equals(name) || "affiliateadminorg".equals(name)) {
            DynamicObject entity = model.getDataEntity();
            Long adminOrgId = entity.getLong("adminorg.id");
            Long affiliateAdminOrgId = entity.getLong("affiliateadminorg.id");
            model.setValue("ismanaged", (Object)(!affiliateAdminOrgId.equals(adminOrgId) ? 1 : 0));
        }
    }

    public static void setCardIsMustInput(IDataModel model, IFormView view) {
        Control control = view.getControl("mode");
        if (control != null) {
            String mode = model.getDataEntity().getString("mode");
            TextEdit card = (TextEdit)view.getControl("card");
            if (card != null) {
                card.setMustInput(!AttModeEnum.NO_CARD.getCode().equals(mode));
            }
            view.updateView("card");
        }
    }

    public static boolean getCardIsMustInput(String mode) {
        if (HRStringUtils.isEmpty((String)mode)) {
            return false;
        }
        return !AttModeEnum.NO_CARD.getCode().equals(mode);
    }

    public static void setTimeZoneByWs(String name, IDataModel model) {
        if ("ws".equals(name)) {
            DynamicObject worksch = model.getDataEntity().getDynamicObject("ws");
            DynamicObject timeZone = model.getDataEntity().getDynamicObject("tz");
            if (!HRObjectUtils.isEmpty((Object)worksch) && HRObjectUtils.isEmpty((Object)timeZone)) {
                model.setValue("tz", (Object)worksch.getDynamicObject("timezoneid"));
            }
        }
    }

    public static void addFileEntrySelectListener(IFormView view, BeforeF7SelectListener selectListener) {
        for (AttFilePlanEnum value : AttFilePlanEnum.values()) {
            String sign = value.getSign();
            BasedataEdit planBaseDataEdit = (BasedataEdit)view.getControl(sign);
            if (planBaseDataEdit == null) continue;
            planBaseDataEdit.addBeforeF7SelectListener(selectListener);
        }
        BasedataEdit periodBaseDataEdit = (BasedataEdit)view.getControl("period");
        periodBaseDataEdit.addBeforeF7SelectListener(selectListener);
        BasedataEdit wsBaseDataEdit = (BasedataEdit)view.getControl("ws");
        wsBaseDataEdit.addBeforeF7SelectListener(selectListener);
    }

    public static void setEntryF7QFilter(BeforeF7SelectEvent event, String key, IFormView view, DynamicObject entity) {
        switch (key) {
            case "vp": 
            case "tp": 
            case "otp": 
            case "ex": 
            case "ad": 
            case "idp": 
            case "mhs": 
            case "att": 
            case "cp": 
            case "fm": 
            case "period": 
            case "ws": 
            case "atttag": 
            case "qt": 
            case "swshift": {
                DynamicObject org = entity.getDynamicObject("org");
                if (HRObjectUtils.isEmpty((Object)org)) {
                    view.showErrorNotification(ResManager.loadKDString((String)"\u8bf7\u5148\u9009\u62e9\u201c\u8003\u52e4\u7ba1\u7406\u7ec4\u7ec7\u201d\u3002", (String)"AttFileHelper_0", (String)"wtc-wtp-business", (Object[])new Object[0]));
                    event.setCancel(true);
                    return;
                }
                ListShowParameter showParameter = (ListShowParameter)event.getFormShowParameter();
                showParameter.setUseOrgId(org.getLong("id"));
                break;
            }
        }
    }

    public static Map<Long, String> checkAttFileVersionAuth(DynamicObject[] dataEntities, List<DynamicObject> attFileList, int type, boolean ifSchImport) {
        HashMap fileBoIdCheckAuthMsg = Maps.newHashMapWithExpectedSize((int)16);
        if (dataEntities != null && dataEntities.length > 0) {
            Map<Long, List<DynamicObject>> boIdEntityMap;
            Set<Long> fileBoIdSet;
            if (type == 0) {
                fileBoIdSet = Arrays.stream(dataEntities).map(dy -> dy.getLong("boid")).collect(Collectors.toSet());
                attFileList = AttFileHelper.getAttFileByFileBoId(fileBoIdSet, true);
                boIdEntityMap = Arrays.stream(dataEntities).collect(Collectors.groupingBy(dy -> dy.getLong("boid")));
            } else {
                attFileList = attFileList.stream().filter(dy -> !dy.getBoolean("iscurrentversion")).collect(Collectors.toList());
                fileBoIdSet = Arrays.stream(dataEntities).map(dy -> WTCDynamicObjectUtils.getBaseDataId((DynamicObject)dy, (String)"attfileid")).collect(Collectors.toSet());
                boIdEntityMap = Arrays.stream(dataEntities).collect(Collectors.groupingBy(dy -> WTCDynamicObjectUtils.getBaseDataId((DynamicObject)dy, (String)"attfileid")));
            }
            Map<Long, List<DynamicObject>> boIdFileListMap = attFileList.stream().collect(Collectors.groupingBy(dy -> dy.getLong("boid")));
            fileBoIdSet.forEach(fileBoId -> {
                List fileList = (List)boIdFileListMap.get(fileBoId);
                if (WTCCollections.isNotEmpty((Collection)fileList)) {
                    AttFileHelper.sortAttFileList(fileList, "bsed", false);
                    List<MuTableTuple<Date, Date>> dateRangeList = fileList.stream().map(dy -> new MuTableTuple((Object)dy.getDate("bsed"), (Object)dy.getDate("bsled"))).collect(Collectors.toList());
                    AttFileHelper.mergeDateRangeList(dateRangeList);
                    HashMap fileBoIdDateRangeListMap = Maps.newHashMapWithExpectedSize((int)boIdFileListMap.size());
                    fileBoIdDateRangeListMap.put(fileBoId, dateRangeList);
                    if (WTCCollections.isNotEmpty((Map)fileBoIdDateRangeListMap)) {
                        ((List)boIdEntityMap.get(fileBoId)).forEach(dy -> {
                            Tuple<Long, Tuple<Date, Date>> fileBoIdDateRange = AttFileHelper.getFileBoIdDateRange(type, dy, ifSchImport, boIdFileListMap);
                            if (fileBoIdDateRange != null && !AttFileHelper.checkIfHaveAuth((List)fileBoIdDateRangeListMap.get(fileBoIdDateRange.getKey()), (Date)((Tuple)fileBoIdDateRange.getValue()).getKey(), (Date)((Tuple)fileBoIdDateRange.getValue()).getValue())) {
                                AttFileHelper.setFileVersionCheckErrMsg(fileBoIdCheckAuthMsg, (Long)fileBoIdDateRange.getKey(), (Date)((Tuple)fileBoIdDateRange.getValue()).getKey(), (Date)((Tuple)fileBoIdDateRange.getValue()).getValue());
                            }
                        });
                    }
                } else {
                    AttFileHelper.setFileCheckErrMsg(fileBoIdCheckAuthMsg, fileBoId);
                }
            });
        }
        return fileBoIdCheckAuthMsg;
    }

    private static void setFileVersionCheckErrMsg(Map<Long, String> fileBoIdCheckAuthMsg, Long fileBoId, Date startDate, Date endDate) {
        fileBoIdCheckAuthMsg.put(fileBoId, AttFileKDString.getNonAttFileVersionDateRangeAuth((Object[])new Object[]{WTCInteDateUtil.formatDateBySysTzAndUserFmt((Date)startDate), WTCInteDateUtil.formatDateBySysTzAndUserFmt((Date)endDate)}));
    }

    private static void setFileCheckErrMsg(Map<Long, String> fileBoIdCheckAuthMsg, Long fileBoId) {
        fileBoIdCheckAuthMsg.put(fileBoId, AttFileKDString.getNonAttFileAnyVersionDateRangeAuth());
    }

    private static Tuple<Long, Tuple<Date, Date>> getFileBoIdDateRange(int type, DynamicObject dy, boolean ifSchImport, Map<Long, List<DynamicObject>> boIdFileListMap) {
        if (type == 0) {
            return new Tuple((Object)dy.getLong("boid"), (Object)new Tuple((Object)dy.getDate("bsed"), (Object)(dy.getDate("bsled") == null ? WTCHisServiceHelper.getMaxEndDate() : dy.getDate("bsled"))));
        }
        AttFileScheduleEnum attFileScheduleEnum = AttFileScheduleEnum.getAttFileScheduleEnumByPageId((String)dy.getDataEntityType().getName().replace("_dg", ""));
        if (attFileScheduleEnum != null) {
            long fileBoId = WTCDynamicObjectUtils.getBaseDataId((DynamicObject)dy, (String)"attfileid");
            if (attFileScheduleEnum.isTimeHis()) {
                Date fileStartDate = boIdFileListMap.get(fileBoId).get(0).getDate("startdate");
                Date scheduleStartDate = ifSchImport && dy.getDate("bsed") == null ? fileStartDate : dy.getDate("bsed");
                Date scheduleEndDate = dy.getDate("bsled") == null ? WTCHisServiceHelper.getMaxEndDate() : dy.getDate("bsled");
                return new Tuple((Object)fileBoId, (Object)new Tuple((Object)scheduleStartDate, (Object)scheduleEndDate));
            }
            return new Tuple((Object)fileBoId, (Object)new Tuple((Object)dy.getDate("startdate"), (Object)(dy.getDate("enddate") == null ? WTCHisServiceHelper.getMaxEndDate() : dy.getDate("enddate"))));
        }
        return null;
    }

    private static boolean checkIfHaveAuth(List<MuTableTuple<Date, Date>> dateRangeList, Date beginDate, Date endDate) {
        for (MuTableTuple<Date, Date> dateRange : dateRangeList) {
            if (beginDate.getTime() < ((Date)dateRange.getKey()).getTime() || endDate.getTime() > ((Date)dateRange.getValue()).getTime()) continue;
            return true;
        }
        return false;
    }

    private static void mergeDateRangeList(List<MuTableTuple<Date, Date>> dateRangeList) {
        if (WTCCollections.isNotEmpty(dateRangeList)) {
            for (int i = dateRangeList.size() - 1; i >= 0; --i) {
                MuTableTuple<Date, Date> dateRange = dateRangeList.get(i);
                if (i >= dateRangeList.size() - 1) continue;
                MuTableTuple<Date, Date> afterDateRange = dateRangeList.get(i + 1);
                if (WTCDateUtils.addDays((Date)((Date)dateRange.getValue()), (int)1).getTime() != ((Date)afterDateRange.getKey()).getTime()) continue;
                dateRangeList.remove(afterDateRange);
                dateRange.setValue(afterDateRange.getValue());
            }
        }
    }

    public static String callIfHasBusinessData(DynamicObject dataEntity, long attTagId) {
        String otStr;
        boolean needCheck = AttFileHelper.needCheckBillBusinessData(attTagId);
        if (!needCheck) {
            return "";
        }
        Date bsed = dataEntity.getDate("bsed");
        Long boId = dataEntity.getLong("boid");
        Map<String, Integer> checkMap = AttFileHelper.getCheckMap(AttFileCheckService.getInstance().getStopAttCheckDataMap(Collections.singletonList(boId), false, bsed, WTCHisServiceHelper.getMaxEndDate()), true);
        if (WTCCollections.isEmpty(checkMap)) {
            return "";
        }
        String businessData = null;
        String punctuation = ResManager.loadKDString((String)"\u3001", (String)"AttFileHelper_17", (String)"wtc-wtp-business", (Object[])new Object[0]);
        if (checkMap.containsKey("signCardData") && checkMap.get("signCardData") > 0) {
            businessData = ResManager.loadKDString((String)"\u539f\u59cb\u5361", (String)"AttFileHelper_23", (String)"wtc-wtp-business", (Object[])new Object[0]);
        }
        if (checkMap.containsKey("vaBillData") && checkMap.get("vaBillData") > 0) {
            String vaStr = ResManager.loadKDString((String)"\u4f11\u5047\u5355", (String)"AttFileHelper_14", (String)"wtc-wtp-business", (Object[])new Object[0]);
            businessData = WTCStringUtils.isNotEmpty((String)businessData) ? businessData + punctuation + vaStr : vaStr;
        }
        if (checkMap.containsKey("tpBillData") && checkMap.get("tpBillData") > 0) {
            String btStr = ResManager.loadKDString((String)"{0}\u5355", (String)"AttFileHelper_15", (String)"wtc-wtp-business", (Object[])new Object[]{BillTypeEnum.EVECTIONBILL.getBillName()});
            businessData = WTCStringUtils.isNotEmpty((String)businessData) ? businessData + punctuation + btStr : btStr;
        }
        if (checkMap.containsKey("otBillData") && checkMap.get("otBillData") > 0) {
            otStr = ResManager.loadKDString((String)"\u52a0\u73ed\u5355", (String)"AttFileHelper_16", (String)"wtc-wtp-business", (Object[])new Object[0]);
            businessData = WTCStringUtils.isNotEmpty((String)businessData) ? businessData + punctuation + otStr : otStr;
        }
        if (checkMap.containsKey("supBillData") && checkMap.get("supBillData") > 0) {
            otStr = ResManager.loadKDString((String)"\u8865\u7b7e\u5355", (String)"AttFileHelper_24", (String)"wtc-wtp-business", (Object[])new Object[0]);
            businessData = WTCStringUtils.isNotEmpty((String)businessData) ? businessData + punctuation + otStr : otStr;
        }
        if (checkMap.containsKey("swsBillData") && checkMap.get("swsBillData") > 0) {
            otStr = ResManager.loadKDString((String)"\u8c03\u73ed\u5355", (String)"AttFileHelper_25", (String)"wtc-wtp-business", (Object[])new Object[0]);
            businessData = WTCStringUtils.isNotEmpty((String)businessData) ? businessData + punctuation + otStr : otStr;
        }
        if (WTCStringUtils.isNotEmpty((String)businessData)) {
            String bsedStr = WTCInteDateUtil.formatDateBySysTzAndUserFmt((Date)bsed);
            return ResManager.loadKDString((String)"\u8be5\u5458\u5de5\u81ea{0}\u505c\u6b62\u8003\u52e4\u540e\u4ecd\u5b58\u5728{1}\uff0c\u5bfc\u81f4\u4fe1\u606f\u5f02\u5e38\u3002", (String)"AttFileHelper_12", (String)"wtc-wtp-business", (Object[])new Object[]{bsedStr, businessData});
        }
        return "";
    }

    private static boolean needCheckBillBusinessData(long baseDataId) {
        Object attFileCheck;
        if (PreDataAttend.PD_LEAVE == baseDataId) {
            return true;
        }
        if (PreDataAttend.PD_SHIFT == baseDataId && (attFileCheck = SystemParamQueryUtil.loadAppParameterFromCache((String)"attfilecheck", (String)"wtp")) != null) {
            return (Boolean)attFileCheck;
        }
        return false;
    }

    public static QFilter resetDateQFilter(String startDateStr, String endDateStr, Iterator<QFilter> iterator, QFilter dateQFilter, QFilter qFilter) {
        Date startTime = null;
        Date endTime = null;
        List qFilterList = qFilter.getNests(true).stream().map(QFilter.QFilterNest::getFilter).collect(Collectors.toList());
        qFilterList.add(qFilter);
        for (QFilter filter : qFilterList) {
            if (!"bsed".equals(filter.getProperty())) continue;
            Object value1 = filter.getValue();
            if (value1 instanceof Date) {
                Date date = (Date)value1;
                if (startTime == null) {
                    startTime = (Date)value1;
                } else if (startTime.compareTo(date) > 0) {
                    endTime = startTime;
                    startTime = date;
                } else {
                    endTime = date;
                }
            }
            filter.__setProperty("id");
            filter.__setCP(">=");
            filter.__setValue((Object)0);
        }
        return startTime != null && endTime != null ? WTCHisServiceHelper.getDateQFilter(startTime, endTime, (String)startDateStr, (String)endDateStr) : null;
    }

    public static void copySaveNotTimeHisModelData(DynamicObject formObject, DynamicObject toObject, String isAddNew) {
        HRDynamicObjectUtils.copy((DynamicObject)formObject, (DynamicObject)toObject, (Set)WTCHisServiceHelper.getHisIgnoreKeysSet());
        if (!"true".equals(isAddNew)) {
            toObject.set("datastatus", null);
            toObject.set("iscurrentversion", (Object)Boolean.TRUE);
        }
    }

    public static List<DynamicObject> getAttFileByFileBoId(Set<Long> fileBoIds, boolean authCheck) {
        return AttFileHelper.getAttFileByFileBoId(fileBoIds, null, authCheck, null, null);
    }

    public static List<DynamicObject> getAttFileByFileBoId(Set<Long> fileBoIds, Set<Long> notInFileBoIdSet, boolean authCheck, String baseProperties, Boolean beCurrent) {
        AttFileQueryParam attFileQueryParam = new AttFileQueryParam(false);
        attFileQueryParam.setSetBoIds(fileBoIds);
        if (beCurrent == null) {
            attFileQueryParam.setBeCurrent(Boolean.FALSE);
        } else {
            attFileQueryParam.setBeCurrent(beCurrent);
        }
        if (WTCStringUtils.isEmpty((String)baseProperties)) {
            attFileQueryParam.setProperties(AttFileQueryParam.baseProperties);
        } else {
            attFileQueryParam.setProperties(baseProperties);
        }
        if (WTCCollections.isNotEmpty(notInFileBoIdSet)) {
            attFileQueryParam.setBoDelSetIds(notInFileBoIdSet);
        }
        attFileQueryParam.setAuthCheck(Boolean.valueOf(authCheck));
        return AttFileQueryServiceImpl.getInstance().queryAttFiles(attFileQueryParam);
    }

    public static List<DynamicObject> queryAttListByPersonIdSet(Set<Long> employeeIdSet) {
        AttFileQueryParam attFileQueryParam = new AttFileQueryParam();
        attFileQueryParam.setEmpPersonSetIds(new HashSet<Long>(employeeIdSet));
        attFileQueryParam.setBeCurrent(null);
        attFileQueryParam.setAuthCheck(Boolean.FALSE);
        return AttFileQueryServiceImpl.getInstance().queryAttFiles(attFileQueryParam);
    }

    public static void sortAttFileList(List<DynamicObject> attFileList, String sortBy, boolean reverse) {
        if (reverse) {
            attFileList.sort(Comparator.comparing(dynamicObject -> ((DynamicObject)dynamicObject).getDate(sortBy)).reversed());
        } else {
            attFileList.sort(Comparator.comparing(dynamicObject -> dynamicObject.getDate(sortBy)));
        }
    }

    public static List<QFilter> getScheduleCommonQFilter(boolean isTimeHis, Object isShowHisVersion, Object listSource, String pageId, String appId) {
        return AttFileHelper.getScheduleListFilter(true, isTimeHis, isShowHisVersion, listSource, pageId, appId);
    }

    public static List<QFilter> getScheduleListFilter(boolean isDetailsPage, boolean isTimeHis, Object isShowHisVersion, Object listSource, String fromId, String appId) {
        ArrayList dateFileters = Lists.newArrayListWithExpectedSize((int)2);
        if (Boolean.TRUE == isShowHisVersion) {
            dateFileters.add(new QFilter("iscurrentversion", "=", (Object)"0"));
        } else {
            QFilter dataPermisQFilter;
            if (isTimeHis) {
                dateFileters.add(new QFilter("iscurrentversion", "=", (Object)Boolean.FALSE));
                if ("details".equals(listSource)) {
                    dateFileters.add(WTCHisServiceHelper.dataStatusValidQFilter());
                }
            } else {
                dateFileters.add(new QFilter("iscurrentversion", "=", (Object)Boolean.TRUE));
                dateFileters.add(new QFilter("datastatus", "=", (Object)"1"));
                if (isDetailsPage) {
                    dateFileters.add(new QFilter("busistatus", "=", (Object)"1"));
                }
            }
            if ((dataPermisQFilter = HRAuthService.getInstance().getDataRule(Long.valueOf(RequestContext.get().getCurrUserId()), appId, fromId, "47150e89000000ac", Collections.emptyMap())) != null) {
                dateFileters.add(dataPermisQFilter);
            }
        }
        return dateFileters;
    }

    public static void checkCard(List<DynamicObject> entityDyList, Map<String, String> cardCheckErrMap, boolean entityIsFile, boolean isAdd) {
        if (CollectionUtils.isEmpty(entityDyList)) {
            return;
        }
        int size = entityDyList.size();
        HashSet cardSet = Sets.newHashSetWithExpectedSize((int)size);
        HashMap paramCard = Maps.newHashMapWithExpectedSize((int)size);
        HashMap cardMustInput = Maps.newHashMapWithExpectedSize((int)size);
        HashMap cardIndexMap = Maps.newHashMapWithExpectedSize((int)size);
        Map<Object, Object> cardPersonIndexIdMap = Maps.newHashMapWithExpectedSize((int)size);
        Object person = entityDyList.get(0).getDataEntityType().getProperties().get((Object)"person");
        if (person != null) {
            cardPersonIndexIdMap = entityDyList.stream().filter(dy -> WTCStringUtils.isNotEmpty((String)dy.getString("card"))).collect(Collectors.toMap(info -> info.getString("card"), info -> info.getLong("person.personindexid"), (n1, n2) -> n1));
        }
        AttFileHelper.checkCardHelper(entityDyList, cardSet, entityIsFile, paramCard, cardMustInput, cardIndexMap, cardCheckErrMap);
        AttFileHelper.checkCard(cardPersonIndexIdMap, paramCard, cardMustInput, isAdd, cardIndexMap, cardCheckErrMap);
    }

    private static void checkCardHelper(List<DynamicObject> entityDyList, Set<String> cardSet, boolean entityIsFile, Map<String, Long> paramCard, Map<String, Boolean> cardMustInput, Map<String, String> cardIndexMap, Map<String, String> cardCheckErrMap) {
        for (int i = 0; i < entityDyList.size(); ++i) {
            String card;
            DynamicObject entityDy = entityDyList.get(i);
            if (entityDy.getDataEntityType().getProperties().containsKey((Object)"type") && FileTypeEnum.VCFILE.getFileType().equals(entityDy.getString("type")) || !HRStringUtils.isNotEmpty((String)(card = entityDy.getString("card")))) continue;
            if (cardSet.contains(card)) {
                cardCheckErrMap.put(cardIndexMap.get(card), ResManager.loadKDString((String)"\u8bf7\u6838\u5bf9\u60a8\u586b\u5199\u7684\u8003\u52e4\u5361\u53f7\uff0c\u4e0e\u5176\u4ed6\u8003\u52e4\u4eba\u5458\u7684\u6570\u636e\u5b58\u5728\u91cd\u590d\u3002", (String)"AttFileHelper_18", (String)"wtc-wtp-business", (Object[])new Object[0]));
            }
            cardIndexMap.put(card, String.valueOf(i));
            cardSet.add(card);
            long value = entityIsFile ? entityDy.getLong("boid") : entityDy.getLong("attfileid.id");
            paramCard.put(card, value);
            List propertiesList = entityDy.getDataEntityType().getProperties().stream().map(IMetadata::getName).collect(Collectors.toList());
            if (propertiesList.contains("mode")) {
                cardMustInput.put(card, AttFileHelper.getCardIsMustInput(entityDy.getString("mode")));
                continue;
            }
            cardMustInput.put(card, null);
        }
    }

    public static String checkCardPage(Map<String, Long> cardPersonIndexIdMap, Map<String, Long> paramCard, Map<String, Boolean> cardMustInput, boolean isAdd) {
        return AttFileHelper.checkCard(cardPersonIndexIdMap, paramCard, cardMustInput, isAdd, null, null);
    }

    public static String checkCard(Map<String, Long> cardPersonIndexIdMap, Map<String, Long> paramCard, Map<String, Boolean> cardMustInput, boolean isAdd, Map<String, String> cardIndexMap, Map<String, String> cardCheckErrMap) {
        for (String cardStr : paramCard.keySet()) {
            String msg = DataBaseValidatorService.checkCard((String)cardStr, (Boolean)cardMustInput.get(cardStr));
            if (!HRStringUtils.isNotEmpty((String)msg)) continue;
            if (cardIndexMap != null && cardCheckErrMap != null) {
                cardCheckErrMap.put(cardIndexMap.get(cardStr), msg);
                continue;
            }
            return msg;
        }
        String errMsg = ResManager.loadKDString((String)"\u8bf7\u6838\u5bf9\u60a8\u586b\u5199\u7684\u8003\u52e4\u5361\u53f7\uff0c\u4e0e\u5176\u4ed6\u8003\u52e4\u4eba\u5458\u7684\u6570\u636e\u5b58\u5728\u91cd\u590d\u3002", (String)"AttFileHelper_18", (String)"wtc-wtp-business", (Object[])new Object[0]);
        AttFileScheduleQueryParam attFileScheduleQueryParam = new AttFileScheduleQueryParam();
        attFileScheduleQueryParam.setLoad(Boolean.FALSE);
        attFileScheduleQueryParam.setqFilter(new QFilter("card", "in", paramCard.keySet()));
        Map longListMap = AttFileScheduleServiceImpl.getInstance().queryAttFileSchedule(AttFileScheduleEnum.CARD, attFileScheduleQueryParam);
        if (CollectionUtils.isEmpty((Map)longListMap)) {
            return "";
        }
        Set fileBoIdList = longListMap.values().stream().flatMap(dy -> dy.stream().map(dy2 -> dy2.getLong("attfileid"))).collect(Collectors.toSet());
        Set currentSet = paramCard.values().stream().filter(dy -> dy != 0L).collect(Collectors.toSet());
        if (!CollectionUtils.isEmpty(currentSet)) {
            fileBoIdList.addAll(currentSet);
        }
        Map<String, List<DynamicObject>> cardAndScheduleDyMap = longListMap.values().stream().flatMap(Collection::stream).collect(Collectors.toList()).stream().collect(Collectors.groupingBy(file -> file.getString("CARD")));
        AttFileQueryParam attFileQueryParam = new AttFileQueryParam(false);
        attFileQueryParam.setBeCurrent(Boolean.TRUE);
        attFileQueryParam.setSetBoIds(fileBoIdList);
        attFileQueryParam.setProperties(WTCStringUtils.joinStr((String[])new String[]{"attperson.id", ",", "id", ",", "person.personindexid"}));
        List files = AttFileQueryServiceImpl.getInstance().queryAttFiles(attFileQueryParam);
        if (CollectionUtils.isEmpty((Collection)files)) {
            return "";
        }
        if (AttFileHelper.checkIfRepeat(cardPersonIndexIdMap, files, paramCard, cardAndScheduleDyMap)) {
            if (cardIndexMap != null && cardCheckErrMap != null) {
                longListMap.forEach((key, value) -> value.forEach(dy -> {
                    String indexStr;
                    if (dy != null && WTCStringUtils.isNotEmpty((String)(indexStr = (String)cardIndexMap.get(dy.get("card"))))) {
                        cardCheckErrMap.put(indexStr, errMsg);
                    }
                }));
            }
            return errMsg;
        }
        return "";
    }

    private static boolean checkIfRepeat(Map<String, Long> cardPersonIndexIdMap, List<DynamicObject> files, Map<String, Long> paramCard, Map<String, List<DynamicObject>> cardAndScheduleDyMap) {
        Map<Long, Long> fileBoIdAndPersonIndexIdMap = files.stream().collect(Collectors.toMap(dy -> dy.getLong("id"), dy -> dy.getLong("person.personindexid")));
        for (Map.Entry<String, Long> entries : paramCard.entrySet()) {
            boolean checkFlag;
            Long fileBoId = entries.getValue();
            String cardStr = entries.getKey();
            List<DynamicObject> scheduleDyList = cardAndScheduleDyMap.get(cardStr);
            Long currentDataBasePersonIndexId = fileBoIdAndPersonIndexIdMap.get(fileBoId);
            if (currentDataBasePersonIndexId == null) {
                currentDataBasePersonIndexId = cardPersonIndexIdMap.get(cardStr);
            }
            boolean bl = checkFlag = HRStringUtils.isEmpty((String)cardStr) || CollectionUtils.isEmpty(scheduleDyList);
            if (checkFlag) continue;
            for (DynamicObject scheduleDy : scheduleDyList) {
                long attFileBoId = scheduleDy.getLong("attfileid");
                Long attPersonIndexId = fileBoIdAndPersonIndexIdMap.get(attFileBoId);
                if (attPersonIndexId == null || Objects.equals(currentDataBasePersonIndexId, attPersonIndexId)) continue;
                return true;
            }
        }
        return false;
    }

    public static String getPersonDateFileKey(DynamicObject file, Date date) {
        String dateString = HRDateTimeUtils.format((Date)date, (String)"yyyy-MM-dd");
        Long personId = file.getLong("person_id");
        return personId + dateString;
    }

    public static List<Date> getDateListByDateRange(Date startDate, Date endDate) {
        if ((startDate = WTCDateUtils.getZeroDate((Date)startDate)).equals(endDate = WTCDateUtils.getZeroDate((Date)endDate))) {
            return Collections.singletonList(startDate);
        }
        ArrayList dateList = Lists.newArrayListWithExpectedSize((int)16);
        Date date = startDate;
        if (endDate.after(startDate)) {
            while (true) {
                dateList.add(date);
                if (!date.before(endDate)) {
                    return dateList;
                }
                date = HRDateTimeUtils.addDay((Date)date, (long)1L);
            }
        }
        return null;
    }

    public static void addOrgQFilter(List<QFilter> qFilters, FormShowParameter formShowParameter, IFormView parentView) {
        Map customParams = formShowParameter.getCustomParams();
        Object fileF7AppId = customParams.get("fileF7AppId");
        Object fileF7FormId = customParams.get("fileF7FormId");
        if (fileF7AppId != null && fileF7FormId != null) {
            qFilters.add(AttFileHelper.getAttFileF7OrgFilter(String.valueOf(fileF7AppId), String.valueOf(fileF7FormId)));
        } else {
            MainEntityType dataEntityType;
            MainEntityType mainEntityType = dataEntityType = parentView != null ? MetadataServiceHelper.getDataEntityType((String)parentView.getEntityId()) : null;
            if (dataEntityType != null && HRStringUtils.isNotEmpty((String)dataEntityType.getMainOrg())) {
                qFilters.add(AttFileHelper.getAttFileF7OrgFilter(parentView.getFormShowParameter().getAppId(), parentView.getEntityId()));
            }
        }
    }

    public static QFilter getAttFileF7OrgFilter(String appId, String formId) {
        HasPermOrgResult hasPermOrgResult = PermissionServiceHelper.getAllPermOrgs((Long)RequestContext.get().getCurrUserId(), (String)appId, (String)formId, (String)"47150e89000000ac");
        if (hasPermOrgResult != null && !hasPermOrgResult.hasAllOrgPerm() && !hasPermOrgResult.getHasPermOrgs().isEmpty()) {
            return new QFilter("org", "in", (Object)hasPermOrgResult.getHasPermOrgs());
        }
        return null;
    }

    public static QFilter[] getAuthQFilter(String formId) {
        QFilter[] qFilters = new QFilter[2];
        String permItemId = "47150e89000000ac";
        long userId = RequestContext.get().getCurrUserId();
        String entityNum = AttFileHelper.isVaFileGroup(formId) ? FileGroupEnum.VA.getFilePageId() : FileGroupEnum.ATT.getFilePageId();
        String appId = AttFileHelper.isVaFileGroup(formId) ? "wtabm" : "wtam";
        QFilter permQFilter = WTCPermUtils.getDataRule((long)userId, (String)AppMetadataCache.getAppInfo((String)appId).getId(), (String)entityNum, (String)permItemId, new HashMap(1));
        if (permQFilter != null) {
            String property = permQFilter.getProperty();
            permQFilter.__setProperty(WTCStringUtils.joinOnDot((String[])new String[]{"attfilevid", property}));
            List nests = permQFilter.getNests(true);
            for (QFilter.QFilterNest nest : nests) {
                nest.getFilter().__setProperty(WTCStringUtils.joinOnDot((String[])new String[]{"attfilevid", nest.getFilter().getProperty()}));
            }
        }
        qFilters[0] = permQFilter;
        HasPermOrgResult allPermOrgs = WTCPermUtils.getAllPermOrgs((String)appId, (String)entityNum);
        if (allPermOrgs != null && !allPermOrgs.hasAllOrgPerm() && !allPermOrgs.getHasPermOrgs().isEmpty()) {
            qFilters[1] = new QFilter("attfilevid.org", "in", (Object)allPermOrgs.getHasPermOrgs());
        }
        return qFilters;
    }

    private static boolean isVaFileGroup(String formId) {
        return FileGroupEnum.VA.getPageId().equals(formId);
    }

    public static void resetSubmitOPs(Map<String, String> submitOPs, String scheduleStr) {
        AttFileScheduleEnum[] values;
        for (AttFileScheduleEnum value : values = AttFileScheduleEnum.values()) {
            String opStr = value.isTimeHis() ? "save" : "saverule";
            submitOPs.put(value.getPageId() + scheduleStr, opStr);
        }
    }

    public static void resetImportOpAndScheduleOrgID(List<ImportBillData> billDatas) {
        List allPageId = AttFileScheduleEnum.getAllPageId();
        List scheduleImportDataList = billDatas.stream().filter(importBillData -> allPageId.contains(importBillData.getMainEntityId().replace("_dg", ""))).collect(Collectors.toList());
        if (scheduleImportDataList.size() == 0) {
            return;
        }
        Set attFileNumbers = scheduleImportDataList.stream().flatMap(importBillData -> importBillData.getData().values().stream()).filter(value -> ((JSONObject)value).containsKey((Object)"attfileid")).map(value -> String.valueOf(((JSONObject)((JSONObject)value).get((Object)"attfileid")).get((Object)"number"))).collect(Collectors.toSet());
        AttFileQueryParam attFileQueryParam = new AttFileQueryParam(false);
        attFileQueryParam.setBeCurrent(Boolean.TRUE);
        attFileQueryParam.setSetFileNumber(attFileNumbers);
        attFileQueryParam.setUsableStatus((Set)Sets.newHashSet((Object[])new String[]{"0", "-1"}));
        attFileQueryParam.setProperties("number, org.number");
        List attFileDyList = AttFileQueryServiceImpl.getInstance().queryAttFiles(attFileQueryParam);
        Map<String, String> attFileOrgMap = attFileDyList.stream().collect(Collectors.toMap(attFileDy -> attFileDy.getString("number"), attFileDy -> attFileDy.getString("org.number"), (a, b) -> a));
        for (ImportBillData importBillData2 : billDatas) {
            if (!scheduleImportDataList.contains(importBillData2)) continue;
            Collection values = importBillData2.getData().values();
            for (Object value2 : values) {
                String attFileNumber;
                String orgNumber;
                if (!((JSONObject)value2).containsKey((Object)"attfileid") || !HRStringUtils.isNotEmpty((String)(orgNumber = attFileOrgMap.get(attFileNumber = String.valueOf(((JSONObject)((JSONObject)value2).get((Object)"attfileid")).get((Object)"number")))))) continue;
                JSONObject jsonObject = new JSONObject();
                jsonObject.put("number", (Object)orgNumber);
                ((JSONObject)value2).put("org", (Object)jsonObject);
            }
        }
    }

    public static void resetExportFields(List<ExportHeaderWriterFormat> headerWriterFormats, String replaceStr) {
        List allPageId = AttFileScheduleEnum.getAllPageId();
        headerWriterFormats.forEach(x -> {
            if (!allPageId.contains(x.getEnityName().replace(replaceStr, ""))) {
                return;
            }
            x.getProperties().remove("org");
            x.getFields().remove("org");
            if (kd.bos.util.CollectionUtils.isNotEmpty((Collection)x.getNext())) {
                x.getNext().forEach(n -> n.setStartColNumber(n.getStartColNumber() + 2));
            }
        });
    }

    public static DynamicObject[] filterAuditedBaseData(DynamicObject[] dyArray) {
        ArrayList<DynamicObject> list = new ArrayList<DynamicObject>();
        for (DynamicObject dy : dyArray) {
            DataEntityPropertyCollection properties = dy.getDataEntityType().getProperties();
            if (properties.containsKey((Object)"status") && !"C".equals(dy.getString("status")) || properties.containsKey((Object)"enable") && !"1".equals(dy.getString("enable"))) continue;
            list.add(dy);
        }
        return list.toArray(new DynamicObject[0]);
    }

    public static void getDepQueryParamList(List<Map<String, Object>> queryList, DynamicObject data) {
        Long positionId;
        Long adminOrg;
        HashMap queryObject = Maps.newHashMapWithExpectedSize((int)3);
        String personNum = data.getString("person.number");
        if (WTCStringUtils.isNotEmpty((String)personNum)) {
            queryObject.put("number", personNum);
        }
        if (!(adminOrg = Long.valueOf(data.getLong("adminorg_id"))).equals(0L)) {
            queryObject.put("adminorg", adminOrg);
        }
        if (!(positionId = Long.valueOf(data.getLong("position_id"))).equals(0L)) {
            queryObject.put("position", positionId);
        }
        queryList.add(queryObject);
    }

    public static String checkAttFileIsDiscard(Long attFileId) {
        AttFileQueryParam attFileQueryParam = new AttFileQueryParam(false);
        attFileQueryParam.setUsableStatus((Set)Sets.newHashSet((Object[])new String[]{"0", "-1"}));
        attFileQueryParam.setProperties("usablestatus");
        attFileQueryParam.setqFilter(new QFilter("id", "=", (Object)attFileId));
        DynamicObject dy = AttFileQueryServiceImpl.getInstance().queryOneAttFiles(attFileQueryParam);
        if (dy != null && "-1".equals(dy.get("usablestatus"))) {
            return ResManager.loadKDString((String)"\u6863\u6848\u5df2\u5e9f\u5f03\uff0c\u65e0\u6cd5\u64cd\u4f5c\u3002", (String)"AttFileHelper_19", (String)"wtc-wtp-business", (Object[])new Object[0]);
        }
        return "";
    }

    public static String checkIsDiscard(IFormView view) {
        if (view == null) {
            return "";
        }
        Object boId = view.getFormShowParameter().getCustomParams().get("boid");
        if (boId != null) {
            return AttFileHelper.checkAttFileIsDiscard(Long.valueOf(String.valueOf(boId)));
        }
        return "";
    }

    public static void resetBaseScheduleDate(Object[] dynamicObjects) {
        List<Object> dys = Arrays.stream(dynamicObjects).filter(object -> object instanceof DynamicObject).filter(dy -> AttFileScheduleEnum.getIsTimeHisByPageId((String)((DynamicObject)dy).getDataEntityType().getName().replace("_dg", ""))).filter(dy -> ((DynamicObject)dy).getLong("boid") == 0L).collect(Collectors.toList());
        if (dys.size() == 0) {
            return;
        }
        Map<Long, DynamicObject> attFileMap = AttFileHelper.getAttFileDate(dys);
        if (attFileMap.size() == 0) {
            return;
        }
        for (Object object2 : dynamicObjects) {
            if (!dys.contains(object2)) continue;
            DynamicObject dy2 = (DynamicObject)object2;
            DynamicObject attFileDy = attFileMap.get(WTCDynamicObjectUtils.getBaseDataId((DynamicObject)dy2, (String)"attfileid"));
            dy2.set("bsed", (Object)attFileDy.getDate("startdate"));
            dy2.set("bsled", (Object)WTCDateUtils.getMaxEndDate());
        }
    }

    private static Map<Long, DynamicObject> getAttFileDate(List<Object> dys) {
        Set attFileIdSet = dys.stream().map(dy -> WTCDynamicObjectUtils.getBaseDataId((DynamicObject)((DynamicObject)dy), (String)"attfileid")).collect(Collectors.toSet());
        AttFileQueryParam queryParam = new AttFileQueryParam(false);
        queryParam.setProperties("boid, startdate, enddate");
        queryParam.setSetBoIds(attFileIdSet);
        queryParam.setBeCurrent(Boolean.TRUE);
        List attFileDys = AttFileQueryServiceImpl.getInstance().queryAttFiles(queryParam);
        return attFileDys.stream().collect(Collectors.toMap(dy -> dy.getLong("boid"), dy -> dy, (a, b) -> a));
    }

    public static Map<String, Map<Long, String>> processingDiscardReturnResults(List<Long> fileBoIds) {
        HashMap map = Maps.newHashMapWithExpectedSize((int)fileBoIds.size());
        for (Long fileBoId : fileBoIds) {
            map.put(fileBoId, "");
        }
        HashMap resultMap = Maps.newHashMapWithExpectedSize((int)1);
        resultMap.put("success", map);
        return resultMap;
    }

    public static HrApiResponse<List<HisReviseRecordReturnParamBo>> obtainReviseRecordByBoId(Long attFileId) {
        AttFileQueryParam param = new AttFileQueryParam(false);
        param.setProperties("id,boid");
        param.setBoId(attFileId.longValue());
        HashSet set = Sets.newHashSet((Object[])new String[]{"-3", "-2", "-1", "0", "1", "2"});
        param.setHisStatus((Set)set);
        param.setBeCurrent(Boolean.FALSE);
        List dynamicObjectList = AttFileQueryServiceImpl.getInstance().queryAttFiles(param);
        if (!CollectionUtils.isEmpty((Collection)dynamicObjectList)) {
            List fvIds = dynamicObjectList.stream().mapToLong(dy -> WTCDynamicObjectUtils.getBaseDataId((DynamicObject)dy, (String)"id")).boxed().collect(Collectors.toList());
            return WTCHisServiceHelper.getReviseRecord((String)"wtp_attfilebase", (Long)attFileId, fvIds);
        }
        return null;
    }

    public static void genShowDiscardConfirmPageByBusinessData(List<DynamicObject> dataEntities, Map<Long, List<String>> resultMsgMap, List<Long> boIdList, IFormPlugin plugin, IFormView view, long rollbackId) {
        AttFileHelper.genShowDiscardConfirmPageByBusinessDataNew(dataEntities, resultMsgMap, boIdList, plugin, view, rollbackId, new HashMap<Long, List<String>>());
    }

    public static void genShowDiscardConfirmPageByBusinessDataNew(List<DynamicObject> dataEntities, Map<Long, List<String>> resultMsgMap, List<Long> boIdList, IFormPlugin plugin, IFormView view, long rollbackId, Map<Long, List<String>> topTipsMap) {
        String formId = "wtp_discardconfirms";
        Map<Object, Object> checkDataMap = Maps.newHashMapWithExpectedSize((int)16);
        if (1110L != rollbackId) {
            Map<String, List<DynamicObject>> checkDataMapBill = AttFileCheckService.getInstance().getCheckDataMap(boIdList);
            checkDataMap = AttFileHelper.getCheckMap(checkDataMapBill, false);
            Map attPushData = (Map)WTCServiceHelper.invokeBizService((String)"wtc", (String)"wtis", (String)"IPayAttDataService", (String)"queryPushData", (Object[])new Object[]{boIdList, "id", null});
            if (WTCCollections.isNotEmpty((Map)attPushData)) {
                List collect = attPushData.values().stream().flatMap(Collection::stream).collect(Collectors.toList());
                checkDataMap.put("attPushData", collect.size());
            }
            if (!CollectionUtils.isEmpty((Map)checkDataMap)) {
                boolean nodata = true;
                for (Map.Entry<Object, Object> entry : checkDataMap.entrySet()) {
                    if (entry.getValue() != null && (Integer)entry.getValue() > 0) {
                        nodata = false;
                    }
                    formId = nodata ? "wtp_discardconfirms" : "wtp_discardconfirmm";
                }
            }
            if (WTCCollections.isNotEmpty((Collection)resultMsgMap.get(boIdList.get(0))) || WTCCollections.isNotEmpty((Collection)topTipsMap.get(boIdList.get(0)))) {
                formId = "wtp_discardconfirmm";
            }
        }
        if ("wtp_discardconfirmm".equals(formId) || 1110L == rollbackId) {
            FormShowParameter parameter = new FormShowParameter();
            parameter.setFormId(formId);
            parameter.getOpenStyle().setShowType(ShowType.Modal);
            parameter.setCustomParam("checkDataMap", (Object)checkDataMap);
            parameter.setCustomParam("discard_bo", boIdList);
            parameter.setCustomParam("person.name", (Object)"");
            parameter.setCustomParam("number", (Object)"");
            WTCCollectionIndexUtil.getEleFromList(dataEntities, (int)0).ifPresent(ele -> {
                parameter.setCustomParam("person.name", (Object)ele.getString("person.name"));
                parameter.setCustomParam("number", (Object)ele.getString("number"));
            });
            parameter.setCustomParam("person.id", (Object)WTCDynamicObjectUtils.getBaseDataId((DynamicObject)dataEntities.get(0), (String)"person"));
            parameter.setCustomParam("coordinationType", (Object)String.valueOf(rollbackId));
            if (!CollectionUtils.isEmpty((Collection)topTipsMap.get(boIdList.get(0)))) {
                parameter.setCustomParam("toptipssupple", topTipsMap.get(boIdList.get(0)));
            }
            if (!CollectionUtils.isEmpty((Collection)resultMsgMap.get(boIdList.get(0)))) {
                parameter.setCustomParam("warntext", resultMsgMap.get(boIdList.get(0)));
            }
            int resultMsgSize = resultMsgMap.get(boIdList.get(0)).size();
            int entrySize = checkDataMap.size();
            int addHigh = 0;
            if (1210L == rollbackId) {
                addHigh += 50;
            }
            AttFileHelper.resetBusiFormSize(resultMsgSize, entrySize, parameter, addHigh);
            parameter.setCloseCallBack(new CloseCallBack(plugin, "discard"));
            view.showForm(parameter);
        } else {
            AtomicReference<String> personName = new AtomicReference<String>("");
            AtomicReference<String> number = new AtomicReference<String>("");
            WTCCollectionIndexUtil.getEleFromList(dataEntities, (int)0).ifPresent(ele -> {
                personName.set(ele.getString("person.name"));
                number.set(ele.getString("number"));
            });
            String text = "";
            if (1210L == rollbackId) {
                Long attPersonId = dataEntities.stream().map(dataEntity -> dataEntity.getLong("attperson.id")).findFirst().orElse(null);
                if (attPersonId != null) {
                    AttFileQueryParam queryParam = new AttFileQueryParam(false);
                    queryParam.setBeCurrent(Boolean.TRUE);
                    queryParam.setProperties("number");
                    queryParam.setPersonSetIds((Set)Sets.newHashSet((Object[])new Long[]{attPersonId}));
                    List dys = AttFileQueryServiceImpl.getInstance().queryAttFiles(queryParam);
                    Set numberList = dys.stream().map(dy -> dy.getString("number")).collect(Collectors.toSet());
                    if (WTCCollections.isNotEmpty(numberList)) {
                        String join = WTCStringUtils.join(new ArrayList(numberList), (String)"\u3001");
                        text = AttFileKDString.discardNormalAttBaseByCoordinationM((String)personName.get(), (String)join);
                    }
                }
            } else {
                text = AttFileKDString.discardNormalAttBase((String)personName.get(), (String)number.get()) + AttFileKDString.discardConfirm();
            }
            view.showConfirm(text, MessageBoxOptions.OKCancel, new ConfirmCallBackListener("wtp_discardconfirms"));
        }
    }

    private static void resetBusiFormSize(int resultMsgSize, int entrySize, FormShowParameter parameter, int addHigh) {
        OpenStyle style = new OpenStyle();
        StyleCss cssValue = new StyleCss();
        int highBase = 200 + addHigh;
        if (entrySize > 0) {
            highBase += 100;
        }
        highBase += 40 * entrySize;
        if (resultMsgSize >= 2 && resultMsgSize < 4) {
            highBase += 100;
        } else if (resultMsgSize == 4) {
            highBase += 140;
        } else if (resultMsgSize >= 5 && resultMsgSize < 7) {
            highBase += 160;
        } else if (resultMsgSize == 7) {
            highBase += 180;
        }
        cssValue.setWidth("554px");
        cssValue.setHeight(highBase + "px");
        style.setInlineStyleCss(cssValue);
        style.setShowType(ShowType.Modal);
        parameter.setOpenStyle(style);
    }

    private static void resetNoDataFormSize(int resultMsgSize, FormShowParameter parameter) {
        OpenStyle style = new OpenStyle();
        StyleCss cssValue = new StyleCss();
        cssValue.setWidth("530px");
        cssValue.setHeight("430px");
        style.setInlineStyleCss(cssValue);
        style.setShowType(ShowType.Modal);
        parameter.setOpenStyle(style);
    }

    public static String getDiscardPageTopTipsByCoordination(Long personId, String personName, String plugin, Set<Long> boIdSet) {
        AttFileQueryParam queryParam = new AttFileQueryParam(false);
        queryParam.setAttPersonId(personId.longValue());
        queryParam.setBeCurrent(Boolean.valueOf(true));
        if (kd.bos.util.CollectionUtils.isNotEmpty(boIdSet)) {
            queryParam.setSetBoIds(boIdSet);
        }
        queryParam.setProperties("number");
        List dys = AttFileQueryServiceImpl.getInstance().queryAttFiles(queryParam);
        if (kd.bos.util.CollectionUtils.isNotEmpty((Collection)dys)) {
            String[] attFileNumberArray = (String[])dys.stream().map(dy -> dy.getString("number")).distinct().toArray(String[]::new);
            StringBuilder stringBuilder = new StringBuilder();
            for (int i = 0; i < attFileNumberArray.length; ++i) {
                String numberStr = attFileNumberArray[i];
                if (i != 0) {
                    stringBuilder.append("\u3001");
                }
                stringBuilder.append(numberStr);
            }
            if ("M".equals(plugin)) {
                return AttFileKDString.discardNormalAttBaseByCoordinationM((String)personName, (String)stringBuilder.toString());
            }
            return AttFileKDString.discardNormalAttBaseByCoordinationS((String)personName, (String)stringBuilder.toString());
        }
        return "";
    }

    public static void handleTextName(DynamicObject[] dataEntities) {
        for (DynamicObject dy : dataEntities) {
            String name = dy.getString("name");
            dy.set("textname", (Object)name);
        }
    }

    public static void logAttFileField(DynamicObject dyLog, String tips, Log log) {
        if (dyLog == null) {
            return;
        }
        log.info("att file field log {}, card{},atttag{},dependency{},empgroup{},workplace{}", new Object[]{tips, dyLog.getString("card"), WTCDynamicObjectUtils.getBaseDataId((DynamicObject)dyLog, (String)"atttag"), WTCDynamicObjectUtils.getBaseDataId((DynamicObject)dyLog, (String)"dependency"), WTCDynamicObjectUtils.getBaseDataId((DynamicObject)dyLog, (String)"empgroup"), WTCDynamicObjectUtils.getBaseDataId((DynamicObject)dyLog, (String)"workplace")});
    }

    public static Map<String, Integer> getCheckMap(Map<String, List<DynamicObject>> checkDataMapBill, boolean isSumBatch) {
        Integer batchVaBillDataSize;
        LinkedHashMap<String, Integer> checkDataMap = new LinkedHashMap<String, Integer>(checkDataMapBill.size());
        if (WTCCollections.isNotEmpty(checkDataMapBill)) {
            checkDataMapBill.forEach((k, v) -> {
                if (WTCCollections.isNotEmpty((Collection)v) && v.size() > 0) {
                    checkDataMap.put((String)k, v.size());
                }
            });
        }
        if (isSumBatch && (batchVaBillDataSize = (Integer)checkDataMap.get("batchVaBillData")) != null) {
            checkDataMap.remove("batchVaBillData");
            checkDataMap.merge("vaBillData", batchVaBillDataSize, Integer::sum);
        }
        return checkDataMap;
    }

    public static boolean isStopAttendance(DynamicObject dataEntity) {
        String attStatus = dataEntity.getString("atttag.attendstatus");
        if (AttStatusEnum.ATT_STOP.getCode().equals(attStatus)) {
            long boId = dataEntity.getLong("boid");
            DynamicObject existsFileDy = AttFileQueryServiceImpl.getInstance().queryOneAttFile("atttag.attendstatus", (Object)boId);
            if (existsFileDy != null) {
                return !attStatus.equals(existsFileDy.getString("atttag.attendstatus"));
            }
        }
        return false;
    }

    public static void jumpToCheckDataPage(String fileCheckBusDataType, List<Long> fileBoIdList, Date startDate, Date endDate, List<String> billNoList, IFormView view, String operaKey) {
        FileCheckBusDataEnum fileCheckBusDataEnum = FileCheckBusDataEnum.getEnumByCode((String)fileCheckBusDataType);
        if (WTCCollections.isEmpty(fileBoIdList)) {
            return;
        }
        if (startDate != null) {
            startDate = WTCDateUtils.getYesterday((Date)startDate);
        }
        if (fileCheckBusDataEnum != null) {
            ListShowParameter listShowParameter = null;
            switch (fileCheckBusDataEnum) {
                case OT: {
                    listShowParameter = AttFileHelper.getBillListParamByStopAtt(startDate, endDate, billNoList, BillTypeEnum.OVERTIMEBILL, fileBoIdList);
                    break;
                }
                case VA: {
                    if ("changebill".equals(operaKey)) {
                        listShowParameter = AttFileHelper.getBillListParamByStopAtt(startDate, endDate, billNoList, BillTypeEnum.VACATIONBILL, fileBoIdList);
                        break;
                    }
                    if (!"changebatchbill".equals(operaKey)) break;
                    listShowParameter = AttFileHelper.getBillListParamByStopAtt(startDate, endDate, billNoList, BillTypeEnum.VACATIONBILLBATCH, fileBoIdList);
                    break;
                }
                case BUS: {
                    listShowParameter = AttFileHelper.getBillListParamByStopAtt(startDate, endDate, billNoList, BillTypeEnum.EVECTIONBILL, fileBoIdList);
                    break;
                }
                case SUP: {
                    listShowParameter = AttFileHelper.getBillListParamByStopAtt(startDate, endDate, billNoList, BillTypeEnum.SUPPLEMENTBILL, fileBoIdList);
                    break;
                }
                case SIGN_CARD: {
                    HashMap param = Maps.newHashMapWithExpectedSize((int)16);
                    param.put("attFileBoIdList", fileBoIdList);
                    param.put("startdate", JSONObject.toJSONString((Object)startDate));
                    param.put("enddate", JSONObject.toJSONString((Object)endDate));
                    ViewUtils.jumpSignCardListView(param, view, ShowType.MainNewTabPage);
                    break;
                }
                case SWS: {
                    listShowParameter = AttFileHelper.getBillListParamByStopAtt(startDate, endDate, billNoList, BillTypeEnum.ADJUSTMENTBILL, fileBoIdList);
                    listShowParameter.setAppId("wtam");
                    break;
                }
            }
            if (listShowParameter != null) {
                view.showForm(listShowParameter);
            }
        }
    }

    private static ListShowParameter getBillListParamByStopAtt(Date startDate, Date endDate, List<String> billNoList, BillTypeEnum adjustmentbill, List<Long> objects) {
        OpenBillListParam openBillListParam = new OpenBillListParam(adjustmentbill, BillApplyTypeEnum.OTHER, objects);
        openBillListParam.setInitBillNo(billNoList);
        openBillListParam.setStartDate(startDate);
        openBillListParam.setEndDate(endDate);
        openBillListParam.setOpenSource("OPEN_SOURCE_STOP_ATTFILE");
        openBillListParam.setCheckRightAppId("wtam");
        openBillListParam.setLimitedBillStatus(false);
        ListShowParameter listShowParameter = BillCommonService.openBillList((OpenBillListParam)openBillListParam);
        return listShowParameter;
    }
}

