/*
 * Decompiled with CFR 0.152.
 */
package kd.wtc.wtp.business.attfile;

import com.alibaba.fastjson.JSON;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.function.Function;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.metadata.IDataEntityType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.hr.hbp.common.util.HRCollUtil;
import kd.hr.hbp.common.util.HRMapUtils;
import kd.hr.hbp.common.util.HRStringUtils;
import kd.wtc.wtbs.business.history.service.WTCHisServiceHelper;
import kd.wtc.wtbs.business.util.WTCDynamicObjectUtils;
import kd.wtc.wtbs.business.web.attperiod.PerAttPeriodQueryServiceImpl;
import kd.wtc.wtbs.business.web.file.AttFileQueryServiceImpl;
import kd.wtc.wtbs.business.web.mservice.HAOSMServiceImpl;
import kd.wtc.wtbs.business.web.mservice.HRPIMServiceImpl;
import kd.wtc.wtbs.business.web.wtte.sysparam.AttRecordParamService;
import kd.wtc.wtbs.common.enums.file.AttStatusEnum;
import kd.wtc.wtbs.common.helper.WTCAppContextHelper;
import kd.wtc.wtbs.common.model.attfile.AttFileQueryParam;
import kd.wtc.wtbs.common.model.period.PerAttPeriod;
import kd.wtc.wtbs.common.model.period.PerAttPeriodQueryParam;
import kd.wtc.wtbs.common.util.WTCCollectionIndexUtil;
import kd.wtc.wtbs.common.util.WTCCollections;
import kd.wtc.wtbs.common.util.WTCDateUtils;
import kd.wtc.wtbs.common.util.WTCInteDateUtil;
import kd.wtc.wtbs.common.util.WTCOrgUnitServiceHelper;
import kd.wtc.wtbs.common.util.WTCStringUtils;
import kd.wtc.wtbs.common.util.third.collect.Maps;
import kd.wtc.wtbs.common.util.third.collect.Sets;
import kd.wtc.wtbs.wtte.common.model.AttRecordParam;
import kd.wtc.wtp.business.attfile.AttFileCheckService;
import kd.wtc.wtp.business.attfile.AttFileHelper;
import kd.wtc.wtp.business.attperson.AttPersonCheckService;
import kd.wtc.wtp.business.attstateinfo.AttStateInfoService;
import kd.wtc.wtp.common.constants.AttFileConstants;
import kd.wtc.wtp.common.kdstring.AttFileKDString;
import kd.wtc.wtp.common.model.attstateinfo.AttStateInfoBO;

public class AttFileModifyCheckService
implements AttFileConstants {
    public static AttFileModifyCheckService getInstance() {
        return (AttFileModifyCheckService)WTCAppContextHelper.getBean(AttFileModifyCheckService.class);
    }

    private long getEmpPosOrgRelId(DynamicObject FileDy) {
        long empPosOrgRel;
        long l = empPosOrgRel = FileDy.get("hrpiempposorgrel") instanceof Long ? FileDy.getLong("hrpiempposorgrel") : FileDy.getLong("hrpiempposorgrel.id");
        if (empPosOrgRel == 0L) {
            empPosOrgRel = FileDy.get("empposorgrel") instanceof Long ? FileDy.getLong("empposorgrel") : FileDy.getLong("empposorgrel.id");
        }
        return empPosOrgRel;
    }

    private String checkOrgStartDate(Long affiliateAdminOrgId, Date bsedDate) {
        List orgVersionList;
        if (affiliateAdminOrgId == null || bsedDate == null) {
            return "";
        }
        Map orgMap = HAOSMServiceImpl.getInstance().batchGetOrgInfo(bsedDate, WTCHisServiceHelper.getMaxEndDate(), Collections.singletonList(affiliateAdminOrgId));
        if (!HRMapUtils.isEmpty((Map)orgMap) && HRCollUtil.isNotEmpty((Collection)(orgVersionList = (List)orgMap.get(affiliateAdminOrgId)))) {
            orgVersionList.sort(Comparator.comparing(map -> (Date)map.get("bsed")));
            Date orgDate = (Date)((Map)orgVersionList.get(0)).get("bsed");
            String bsedDateStr = WTCInteDateUtil.formatDateBySysTzAndUserFmt((Date)bsedDate);
            String orgDateStr = WTCInteDateUtil.formatDateBySysTzAndUserFmt((Date)orgDate);
            if (bsedDate.before(orgDate)) {
                return AttFileKDString.getAttFileAndOrgBsedDateTips((Object[])new Object[]{bsedDateStr, orgDateStr});
            }
            return "";
        }
        return AttFileKDString.getAttFileAndOrgBsedDateNotExistTips();
    }

    private void initHrPiEmpEntrElCheckMap(List<DynamicObject> checkDataList, Map<Long, Map<String, Object>> hrPiEmpEntrElCheckMap) {
        if (WTCCollections.isEmpty(hrPiEmpEntrElCheckMap)) {
            List employeeIdList = checkDataList.stream().map(d -> WTCDynamicObjectUtils.getBaseDataId((DynamicObject)d, (String)"employee")).collect(Collectors.toList());
            List employeeDataMapList = HRPIMServiceImpl.getInstance().listBatchEmployeeAttachs(employeeIdList, null, "hrpi_empentrel");
            for (Map hrPiEmpEntrElMap : employeeDataMapList) {
                HashMap res = Maps.newHashMapWithExpectedSize((int)2);
                res.put("labrelstatusprd_stop", Boolean.FALSE);
                if (hrPiEmpEntrElMap != null && LABRELSTATUSPRD_STOP_ID.equals(hrPiEmpEntrElMap.get("labrelstatusprd_id"))) {
                    res.put("labrelstatusprd_stop", Boolean.TRUE);
                    res.put("enddate", hrPiEmpEntrElMap.get("enddate"));
                }
                if (hrPiEmpEntrElMap == null || hrPiEmpEntrElMap.get("employee") == null) continue;
                hrPiEmpEntrElCheckMap.put((Long)hrPiEmpEntrElMap.get("employee"), res);
            }
        }
    }

    public Map<Integer, Set<String>> checkModifyFile(List<DynamicObject> checkDataList) {
        return this.checkModifyFile(checkDataList, Collections.emptyMap());
    }

    public Map<Integer, Set<String>> checkModifyFile(List<DynamicObject> checkDataList, Map<String, Object> customMap) {
        if (WTCCollections.isEmpty(checkDataList)) {
            return Collections.emptyMap();
        }
        AttFileCheckService.getInstance().reSetAttTag(checkDataList);
        HashMap result = Maps.newHashMapWithExpectedSize((int)checkDataList.size());
        Map<Long, DynamicObject> empPosOrgRelDyMap = this.getEmpPosOrgRelDyMap(checkDataList);
        HashMap hrPiEmpEntrElCheckMap = Maps.newHashMapWithExpectedSize((int)checkDataList.size());
        HashMap fileBoIdMsgMap = Maps.newHashMapWithExpectedSize((int)16);
        if (WTCCollections.isEmpty(customMap) || !"fromcoordination".equals(customMap.get("fromcoordination"))) {
            fileBoIdMsgMap.putAll(AttFileHelper.checkAttFileVersionAuth(checkDataList.toArray(new DynamicObject[0]), null, 0, false));
        }
        List<Long> attFileBoIdList = checkDataList.stream().map(d -> d.getLong("boid")).collect(Collectors.toList());
        Map<Long, DynamicObject> existAttStopFileMap = this.getExistAttStopFileMap(attFileBoIdList);
        List<AttStateInfoBO> attStateInfoBOS = AttStateInfoService.getInstance().queryAttStateInfoByBoid(attFileBoIdList);
        Map<Long, List<PerAttPeriod>> perAttPeriodMapGroupByFileBoId = this.getPerAttPeriodMapGroupByFileBoId(checkDataList, attStateInfoBOS);
        long hrDefaultRootOrgId = WTCOrgUnitServiceHelper.getHRDefaultRootOrgId();
        AttRecordParam attRecordParam = AttRecordParamService.getAttRecordParam((long)hrDefaultRootOrgId);
        Map frozeAllInfoMap = attStateInfoBOS.stream().filter(Objects::nonNull).collect(Collectors.toMap(AttStateInfoBO::getFileBoid, Function.identity(), (oldValue, newValue) -> oldValue));
        for (int i = 0; i < checkDataList.size(); ++i) {
            String existStopAttMsg;
            String msg;
            HashSet msgSet = Sets.newHashSetWithExpectedSize((int)16);
            DynamicObject modifyDy = checkDataList.get(i);
            Date bsed = modifyDy.getDate("bsed");
            Date bsled = modifyDy.getDate("bsled");
            Date startDate = modifyDy.getDate("startdate");
            Date endDate = modifyDy.getDate("enddate");
            String endDateStr = WTCInteDateUtil.formatDateBySysTzAndUserFmt((Date)endDate);
            String startDateStr = WTCInteDateUtil.formatDateBySysTzAndUserFmt((Date)startDate);
            long fileBoId = modifyDy.getLong("boid");
            if (bsled == null) {
                bsled = WTCHisServiceHelper.getMaxEndDate();
            }
            this.baseDateCheck(msgSet, modifyDy, bsed, bsled, startDate, endDate, endDateStr, startDateStr);
            long empPosOrgRelId = this.getEmpPosOrgRelId(modifyDy);
            DynamicObject empPosOrgRelDy = empPosOrgRelDyMap.get(empPosOrgRelId);
            if (empPosOrgRelDy == null) {
                msgSet.add(AttFileKDString.empPosOrgRelNotEffect());
                result.put(i, msgSet);
                continue;
            }
            Date empStartDate = empPosOrgRelDy.getDate("startdate");
            String empStartDateStr = WTCInteDateUtil.formatDateBySysTzAndUserFmt((Date)empStartDate);
            Long attFileAdminOrgId = modifyDy.getLong("affiliateadminorg.id");
            String checkOrgStartDateMsg = this.checkOrgStartDate(attFileAdminOrgId, bsed);
            if (WTCStringUtils.isNotEmpty((String)checkOrgStartDateMsg)) {
                msgSet.add(checkOrgStartDateMsg);
            }
            if (bsed.before(empStartDate)) {
                msgSet.add(ResManager.loadKDString((String)"\u751f\u6548\u65e5\u671f\u4e0d\u80fd\u65e9\u4e8e\u6240\u5728\u884c\u653f\u7ec4\u7ec7\u7684\u4efb\u804c\u5f00\u59cb\u65e5\u671f{0}", (String)"AttFileModifyCheckService_4", (String)"wtc-wtp-business", (Object[])new Object[]{empStartDateStr}));
            }
            if (WTCStringUtils.isNotEmpty((String)(msg = this.checkExistAttStopFileDate(existAttStopFileMap, bsled, fileBoId)))) {
                msgSet.add(msg);
            }
            if (AttStatusEnum.ATT_NORMAL.getCode().equals(modifyDy.getString("atttag.attendstatus"))) {
                if (bsled.after(endDate)) {
                    msgSet.add(ResManager.loadKDString((String)"\u5931\u6548\u65e5\u671f\u5e94\u65e9\u4e8e\u6216\u7b49\u4e8e\u6863\u6848\u7ed3\u675f\u65e5\u671f{0}\u3002", (String)"AttFileModifyCheckService_5", (String)"wtc-wtp-business", (Object[])new Object[]{endDateStr}));
                }
            } else if (AttStatusEnum.ATT_STOP.getCode().equals(modifyDy.getString("atttag.attendstatus"))) {
                this.checkStopAtt(checkDataList, hrPiEmpEntrElCheckMap, msgSet, modifyDy, bsed);
            }
            if (WTCCollections.isNotEmpty((Map)fileBoIdMsgMap) && WTCStringUtils.isNotEmpty((String)(existStopAttMsg = (String)fileBoIdMsgMap.get(fileBoId)))) {
                msgSet.add(existStopAttMsg);
            }
            AttStateInfoBO attStateInfoBO = (AttStateInfoBO)frozeAllInfoMap.get(fileBoId);
            Date lockToDate = attStateInfoBO.getLockTo();
            this.perAttPeriodCheck(perAttPeriodMapGroupByFileBoId, msgSet, modifyDy, fileBoId, lockToDate);
            this.checkAttStateInfo(attRecordParam, msgSet, modifyDy, attStateInfoBO, false);
            result.put(i, msgSet);
        }
        Map<Integer, String> errMap = AttFileModifyCheckService.getInstance().checkAttPersonOtherInfo(checkDataList);
        for (int i = 0; i < checkDataList.size(); ++i) {
            String errMsg = errMap.get(i);
            if (!HRStringUtils.isNotEmpty((String)errMsg)) continue;
            Set errTips = (Set)result.get(i);
            errTips.add(errMsg);
        }
        return result;
    }

    public String checkExistAttStopFileDate(Map<Long, DynamicObject> existAttStopFileMap, Date bsled, long fileBoId) {
        DynamicObject stopAttFileDy = existAttStopFileMap.get(fileBoId);
        if (stopAttFileDy != null) {
            Date stopAttFileStartDate = stopAttFileDy.getDate("bsed");
            Date stopAttFileEndDate = stopAttFileDy.getDate("bsled");
            if (bsled.compareTo(stopAttFileStartDate) >= 0) {
                return ResManager.loadKDString((String)"\u5458\u5de5\u5728{0}\u81f3{1}\u6863\u6848\u5df2\u505c\u6b62\u8003\u52e4\uff0c\u4fdd\u5b58\u5931\u8d25\u3002", (String)"AttFileModifyCheckService_12", (String)"wtc-wtp-business", (Object[])new Object[]{WTCInteDateUtil.formatDateBySysTzAndUserFmt((Date)stopAttFileStartDate), WTCInteDateUtil.formatDateBySysTzAndUserFmt((Date)stopAttFileEndDate)});
            }
        }
        return "";
    }

    public Map<Long, DynamicObject> getExistAttStopFileMap(List<Long> attFileBoIdList) {
        AttFileQueryParam attFileQueryParamStopAtt = new AttFileQueryParam(false);
        attFileQueryParamStopAtt.setAttStatus(AttStatusEnum.ATT_STOP);
        attFileQueryParamStopAtt.setBeCurrent(Boolean.valueOf(false));
        attFileQueryParamStopAtt.setAuthCheck(Boolean.valueOf(false));
        attFileQueryParamStopAtt.setSetBoIds(new HashSet<Long>(attFileBoIdList));
        attFileQueryParamStopAtt.setProperties("id,boid,bsed,bsled");
        return AttFileQueryServiceImpl.getInstance().queryAttFiles(attFileQueryParamStopAtt).stream().sorted(Comparator.comparing(file -> file.getDate("bsed"))).collect(Collectors.toMap(d -> d.getLong("boid"), Function.identity(), (a, b) -> b));
    }

    private void perAttPeriodCheck(Map<Long, List<PerAttPeriod>> perAttPeriodMapGroupByFileBoId, Set<String> msgSet, DynamicObject modifyDy, long fileBoId, Date lockToDate) {
        List<PerAttPeriod> perAttPeriodList;
        Optional<PerAttPeriod> any;
        if (AttStatusEnum.ATT_STOP.getCode().equals(modifyDy.getString("atttag.attendstatus")) && lockToDate != null && (any = (perAttPeriodList = perAttPeriodMapGroupByFileBoId.get(fileBoId)).stream().filter(d -> d != null && d.getPerAttBeginDate().compareTo(lockToDate) <= 0 && d.getPerAttEndDate().compareTo(lockToDate) >= 0).findAny()).isPresent()) {
            PerAttPeriod perAttPeriod = any.get();
            Date fileBseDate = WTCDateUtils.addDays((Date)modifyDy.getDate("bsed"), (int)-1);
            if (fileBseDate.compareTo(perAttPeriod.getPerAttBeginDate()) >= 0 && fileBseDate.before(perAttPeriod.getPerAttEndDate())) {
                msgSet.add(ResManager.loadKDString((String)"\u505c\u6b62\u8003\u52e4\u65e5\u671f\u6240\u5728\u4eba\u5458\u8003\u52e4\u671f\u95f4\u4e3a\u9501\u5b9a\u72b6\u6001\uff0c\u8bf7\u5148\u89e3\u9501\u540e\u64cd\u4f5c\u3002", (String)"AttFileModifyCheckService_8", (String)"wtc-wtp-business", (Object[])new Object[0]));
            }
        }
    }

    private void baseDateCheck(Set<String> msgSet, DynamicObject modifyDy, Date bsed, Date bsled, Date startDate, Date endDate, String endDateStr, String startDateStr) {
        if (bsled.before(bsed)) {
            msgSet.add(ResManager.loadKDString((String)"\u5931\u6548\u65e5\u671f\u4e0d\u5141\u8bb8\u65e9\u4e8e\u751f\u6548\u65e5\u671f\u3002", (String)"AttFileModifyCheckService_1", (String)"wtc-wtp-business", (Object[])new Object[0]));
        }
        if (modifyDy.getDate("bsed").compareTo(startDate) < 0) {
            msgSet.add(ResManager.loadKDString((String)"\u751f\u6548\u65e5\u671f\u4e0d\u80fd\u65e9\u4e8e\u6863\u6848\u5f00\u59cb\u65e5\u671f{0}\u3002", (String)"AttFileModifyCheckService_2", (String)"wtc-wtp-business", (Object[])new Object[]{startDateStr}));
        }
        if (bsed.after(endDate)) {
            msgSet.add(ResManager.loadKDString((String)"\u751f\u6548\u65e5\u671f\u5e94\u65e9\u4e8e\u6216\u7b49\u4e8e\u6863\u6848\u7ed3\u675f\u65e5\u671f{0}\u3002", (String)"AttFileModifyCheckService_3", (String)"wtc-wtp-business", (Object[])new Object[]{endDateStr}));
        }
    }

    private Map<Long, DynamicObject> getEmpPosOrgRelDyMap(List<DynamicObject> checkDataList) {
        List empPosOrgRelIdList = checkDataList.stream().map(this::getEmpPosOrgRelId).collect(Collectors.toList());
        QFilter empPosOrgRelIdQFilter = new QFilter("id", "in", empPosOrgRelIdList);
        DynamicObject[] empPosOrgRelDyListAll = HRPIMServiceImpl.getInstance().listFieldsFilterInfo("id,startdate", empPosOrgRelIdQFilter, "hrpi_empposorgrel");
        return Arrays.stream(empPosOrgRelDyListAll).collect(Collectors.toMap(d -> d.getLong("id"), Function.identity()));
    }

    public void checkAttStateInfo(AttRecordParam attRecordParam, Set<String> msgSet, DynamicObject modifyDy, AttStateInfoBO attStateInfoBO, boolean isAdd) {
        Date frozenEndDate;
        Date frozenStartDate;
        if (attStateInfoBO == null) {
            return;
        }
        Date lockToDate = attStateInfoBO.getLockTo();
        if (lockToDate != null && !modifyDy.getDate("bsed").after(lockToDate)) {
            if (!isAdd) {
                msgSet.add(String.format(Locale.ROOT, ResManager.loadKDString((String)"\u751f\u6548\u65e5\u671f\u53ea\u80fd\u665a\u4e8e\u8be5\u4eba\u5458\u7684\u5df2\u9501\u5b9a\u81f3%s\u3002", (String)"AttFileModifyCheckService_9", (String)"wtc-wtp-business", (Object[])new Object[0]), WTCInteDateUtil.formatDateBySysTzAndUserFmt((Date)lockToDate)));
            } else {
                msgSet.add(String.format(Locale.ROOT, ResManager.loadKDString((String)"\u6863\u6848\u5f00\u59cb\u65e5\u671f\u53ea\u80fd\u665a\u4e8e\u8be5\u4eba\u5458\u7684\u5df2\u9501\u5b9a\u81f3%s\u3002", (String)"AttFileModifyCheckService_10", (String)"wtc-wtp-business", (Object[])new Object[0]), WTCInteDateUtil.formatDateBySysTzAndUserFmt((Date)lockToDate)));
            }
        }
        if (attRecordParam != null && attRecordParam.isAttefile() && this.checkFrozenDate(frozenStartDate = attStateInfoBO.getFrozenStartDate(), frozenEndDate = attStateInfoBO.getFronzenEnDate(), modifyDy)) {
            msgSet.add(String.format(ResManager.loadKDString((String)"\u5df2\u51bb\u7ed3\u7684\u65e5\u671f\u8303\u56f4\u5185\u4e0d\u5141\u8bb8\u7f16\u8f91\u6863\u6848\u76f8\u5173\u4fe1\u606f\uff0c\u5df2\u51bb\u7ed3\u8303\u56f4\uff1a%1$s\u81f3%2$S\u3002", (String)"AttFileModifyCheckService_11", (String)"wtc-wtp-business", (Object[])new Object[0]), WTCInteDateUtil.formatDateBySysTzAndUserFmt((Date)frozenStartDate), WTCInteDateUtil.formatDateBySysTzAndUserFmt((Date)frozenEndDate)));
        }
    }

    private void checkStopAtt(List<DynamicObject> checkDataList, Map<Long, Map<String, Object>> hrPiEmpEntrElCheckMap, Set<String> msgSet, DynamicObject modifyDy, Date bsed) {
        long baseDataId;
        String hasBusinessData;
        Long employeeId;
        Map<String, Object> checkEmp;
        this.initHrPiEmpEntrElCheckMap(checkDataList, hrPiEmpEntrElCheckMap);
        if (WTCCollections.isNotEmpty(hrPiEmpEntrElCheckMap) && WTCCollections.isNotEmpty(checkEmp = hrPiEmpEntrElCheckMap.get(employeeId = Long.valueOf(modifyDy.getLong("employee.id"))))) {
            Object empEndDateObj = checkEmp.get("enddate");
            if (Boolean.FALSE.equals(checkEmp.get("labrelstatusprd_stop")) || empEndDateObj == null) {
                msgSet.add(ResManager.loadKDString((String)"\u8be5\u4eba\u5458\u672a\u7528\u5de5\u7ec8\u6b62\uff0c\u4e0d\u5141\u8bb8\u505c\u6b62\u8003\u52e4\u3002", (String)"AttFileModifyCheckService_6", (String)"wtc-wtp-business", (Object[])new Object[0]));
            }
            if (empEndDateObj != null) {
                Date empEndDate = (Date)empEndDateObj;
                String empEndDateStr = WTCInteDateUtil.formatDateBySysTzAndUserFmt((Date)empEndDate);
                if (!bsed.after(empEndDate)) {
                    msgSet.add(ResManager.loadKDString((String)"\u505c\u6b62\u8003\u52e4\u7684\u751f\u6548\u65e5\u671f\u53ea\u80fd\u665a\u4e8e\u7528\u5de5\u7ed3\u675f\u65e5\u671f{0}\u3002", (String)"AttFileModifyCheckService_7", (String)"wtc-wtp-business", (Object[])new Object[]{empEndDateStr}));
                }
            }
        }
        if (WTCStringUtils.isNotEmpty((String)(hasBusinessData = AttFileHelper.callIfHasBusinessData(modifyDy, baseDataId = WTCDynamicObjectUtils.getBaseDataId((DynamicObject)modifyDy, (String)"atttag"))))) {
            msgSet.add(hasBusinessData);
        }
    }

    private boolean checkFrozenDate(Date frozenStartDate, Date frozenEndDate, DynamicObject dataEntity) {
        boolean check;
        if (frozenStartDate == null || frozenEndDate == null) {
            return false;
        }
        Date modifyTime = dataEntity.getDate("bsed");
        Date endDate = dataEntity.getDate("bsled");
        if (frozenStartDate.compareTo(modifyTime) <= 0 && frozenEndDate.compareTo(modifyTime) >= 0) {
            return true;
        }
        boolean bl = check = (endDate == null || endDate.compareTo(frozenEndDate) >= 0) && modifyTime.compareTo(frozenStartDate) <= 0;
        if (check) {
            return true;
        }
        return endDate != null && frozenStartDate.compareTo(endDate) <= 0 && frozenEndDate.compareTo(endDate) >= 0;
    }

    private Map<Long, List<PerAttPeriod>> getPerAttPeriodMapGroupByFileBoId(List<DynamicObject> checkDataList, List<AttStateInfoBO> attStateInfoBOS) {
        Set stopAttFileBoIdSet = checkDataList.stream().filter(dynamicObject -> AttStatusEnum.ATT_STOP.getCode().equals(dynamicObject.getString("atttag.attendstatus"))).map(d -> d.getLong("boid")).collect(Collectors.toSet());
        List attStopAttStateInfoBOS = attStateInfoBOS.stream().filter(d -> stopAttFileBoIdSet.contains(d.getFileBoid()) && d.getLockTo() != null).collect(Collectors.toList());
        if (WTCCollections.isNotEmpty(attStopAttStateInfoBOS)) {
            Date lockToMin = attStopAttStateInfoBOS.stream().min(Comparator.comparing(AttStateInfoBO::getLockTo)).orElseGet(AttStateInfoBO::new).getLockTo();
            Date lockToMax = attStopAttStateInfoBOS.stream().max(Comparator.comparing(AttStateInfoBO::getLockTo)).orElseGet(AttStateInfoBO::new).getLockTo();
            PerAttPeriodQueryParam perAttPeriodQueryParam = new PerAttPeriodQueryParam();
            perAttPeriodQueryParam.setAttFileBoIdSet(stopAttFileBoIdSet);
            perAttPeriodQueryParam.setStartDate(lockToMin);
            perAttPeriodQueryParam.setEndDate(lockToMax);
            List perAttPeriodList = PerAttPeriodQueryServiceImpl.getInstance().queryPerAttPeriodEntity(perAttPeriodQueryParam);
            return perAttPeriodList.stream().collect(Collectors.groupingBy(PerAttPeriod::getFileBoId));
        }
        return Collections.emptyMap();
    }

    public Map<Integer, String> checkAttPersonOtherInfo(List<DynamicObject> checkDataList) {
        AtomicBoolean isExits = new AtomicBoolean(false);
        WTCCollectionIndexUtil.getEleFromList(checkDataList, (int)0).map(DynamicObject::getDataEntityType).map(IDataEntityType::getProperties).ifPresent(properties -> isExits.set(properties.containsKey((Object)"qtfirsteffectdate")));
        if (!CollectionUtils.isEmpty(checkDataList) && !isExits.get()) {
            return Maps.newHashMapWithExpectedSize((int)1);
        }
        HashMap checkMap = Maps.newHashMapWithExpectedSize((int)checkDataList.size());
        for (int i = 0; i < checkDataList.size(); ++i) {
            HashMap map = Maps.newHashMapWithExpectedSize((int)16);
            DynamicObject dy = checkDataList.get(i);
            map.put("person", JSON.toJSONString((Object)WTCDynamicObjectUtils.getBaseDataId((DynamicObject)dy, (String)"person")));
            map.put("startdate", JSON.toJSONString((Object)dy.getDate("startdate")));
            map.put("qtfirsteffectdate", JSON.toJSONString((Object)dy.getDate("qtfirsteffectdate")));
            checkMap.put(i, map);
        }
        if (checkMap.size() > 0) {
            return AttPersonCheckService.getInstance().checkQTFirstEffectDate(checkMap);
        }
        return Maps.newHashMapWithExpectedSize((int)1);
    }
}

