/*
 * Decompiled with CFR 0.152.
 */
package kd.wtc.wtp.business.attfile;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.hr.hbp.business.servicehelper.HRBaseServiceHelper;
import kd.hr.hbp.common.util.HRCollUtil;
import kd.hr.hbp.common.util.HRStringUtils;
import kd.wtc.wtbs.business.history.service.WTCHisServiceHelper;
import kd.wtc.wtbs.business.util.WTCDynamicObjectUtils;
import kd.wtc.wtbs.common.enums.AttFilePlanEnum;
import kd.wtc.wtbs.common.enums.AttFileScheduleEnum;
import kd.wtc.wtbs.common.util.WTCDateUtils;
import kd.wtc.wtbs.common.util.WTCInteDateUtil;
import kd.wtc.wtp.common.constants.AttFileConstants;
import kd.wtc.wtp.common.model.file.AttFilePlanScheduleCutVo;
import kd.wtc.wtp.constants.attfile.AttFileBaseKDString;

public class AttFilePlanHelper
implements AttFileConstants {
    private static final Log LOG = LogFactory.getLog(AttFilePlanHelper.class);
    private static final String SELECT_PLAN_PROPERTIES = "firstbsed,id,name";

    private AttFilePlanHelper() {
    }

    public static Map<String, Map<Long, List<DynamicObject>>> genRulePlanMap(String source, List<DynamicObject> dataList) {
        HashMap<String, Map<Long, List<DynamicObject>>> result = new HashMap<String, Map<Long, List<DynamicObject>>>(16);
        if (HRStringUtils.equals((String)"1", (String)source)) {
            return AttFilePlanHelper.initAllRulePlan(result, dataList);
        }
        if (HRStringUtils.equals((String)"2", (String)source)) {
            return AttFilePlanHelper.initScheduleRulePlan(result, dataList);
        }
        return result;
    }

    private static Map<String, Map<Long, List<DynamicObject>>> initScheduleRulePlan(Map<String, Map<Long, List<DynamicObject>>> result, List<DynamicObject> dataList) {
        HashMap<String, HashSet<Long>> planMap = new HashMap<String, HashSet<Long>>(16);
        for (DynamicObject dynamicObject : dataList) {
            String entityName = dynamicObject.getDataEntityType().getName();
            String key = AttFileScheduleEnum.getScheduleKeyByPageId((String)entityName);
            AttFilePlanEnum planEnum = AttFilePlanEnum.getBySign((String)key);
            if (null == planEnum) continue;
            HashSet<Long> planIds = (HashSet<Long>)planMap.get(entityName);
            if (HRCollUtil.isEmpty((Collection)planIds)) {
                planIds = new HashSet<Long>(dataList.size());
            }
            planIds.add(WTCDynamicObjectUtils.getBaseDataId((DynamicObject)dynamicObject, (String)planEnum.getEntityId()));
            planMap.put(entityName, planIds);
        }
        for (Map.Entry entry : planMap.entrySet()) {
            AttFilePlanHelper.queryPlan((String)entry.getKey(), (Set)entry.getValue(), result);
        }
        return result;
    }

    private static void queryPlan(String entityName, Set<Long> planIds, Map<String, Map<Long, List<DynamicObject>>> result) {
        String key = AttFileScheduleEnum.getScheduleKeyByPageId((String)entityName);
        AttFilePlanEnum planEnum = AttFilePlanEnum.getBySign((String)key);
        if (null == planEnum || HRCollUtil.isEmpty(planIds)) {
            return;
        }
        QFilter filter = AttFilePlanHelper.getPlanFilter();
        HRBaseServiceHelper planHelper = new HRBaseServiceHelper(planEnum.getEntityNumber());
        QFilter idFilter = new QFilter("id", "in", planIds).and(filter);
        Map<Long, List<DynamicObject>> group = Arrays.stream(planHelper.query(SELECT_PLAN_PROPERTIES, new QFilter[]{idFilter})).collect(Collectors.groupingBy(dy -> dy.getLong("id")));
        result.put(planEnum.getSign(), group);
    }

    private static QFilter getPlanFilter() {
        return WTCHisServiceHelper.dataStatusValidQFilter().and(WTCHisServiceHelper.isCurrentVersion((boolean)true));
    }

    private static Map<String, Map<Long, List<DynamicObject>>> initAllRulePlan(Map<String, Map<Long, List<DynamicObject>>> result, List<DynamicObject> dataList) {
        Map<Long, List<DynamicObject>> foGroup;
        HRBaseServiceHelper foHelper;
        Set<Long> vpIds = new HashSet<Long>(dataList.size());
        Set<Long> qtIds = new HashSet<Long>(dataList.size());
        Set<Long> tpIds = new HashSet<Long>(dataList.size());
        Set<Long> otpIds = new HashSet<Long>(dataList.size());
        Set<Long> exIds = new HashSet<Long>(dataList.size());
        Set<Long> adIds = new HashSet<Long>(dataList.size());
        Set<Long> idpIds = new HashSet<Long>(dataList.size());
        Set<Long> attIds = new HashSet<Long>(dataList.size());
        Set<Long> fmIds = new HashSet<Long>(dataList.size());
        Set<Long> swShiftIds = new HashSet<Long>(dataList.size());
        for (DynamicObject data : dataList) {
            vpIds.add(WTCDynamicObjectUtils.getBaseDataId((DynamicObject)data, (String)AttFilePlanEnum.VP.getSign()));
            qtIds.add(WTCDynamicObjectUtils.getBaseDataId((DynamicObject)data, (String)AttFilePlanEnum.QT.getSign()));
            tpIds.add(WTCDynamicObjectUtils.getBaseDataId((DynamicObject)data, (String)AttFilePlanEnum.TP.getSign()));
            otpIds.add(WTCDynamicObjectUtils.getBaseDataId((DynamicObject)data, (String)AttFilePlanEnum.OTP.getSign()));
            exIds.add(WTCDynamicObjectUtils.getBaseDataId((DynamicObject)data, (String)AttFilePlanEnum.EXS.getSign()));
            adIds.add(WTCDynamicObjectUtils.getBaseDataId((DynamicObject)data, (String)AttFilePlanEnum.AD.getSign()));
            idpIds.add(WTCDynamicObjectUtils.getBaseDataId((DynamicObject)data, (String)AttFilePlanEnum.IDP.getSign()));
            attIds.add(WTCDynamicObjectUtils.getBaseDataId((DynamicObject)data, (String)AttFilePlanEnum.ATT.getSign()));
            fmIds.add(WTCDynamicObjectUtils.getBaseDataId((DynamicObject)data, (String)AttFilePlanEnum.FM.getSign()));
            swShiftIds.add(WTCDynamicObjectUtils.getBaseDataId((DynamicObject)data, (String)AttFilePlanEnum.SWSHIFT.getSign()));
        }
        QFilter commonFilter = AttFilePlanHelper.getPlanFilter();
        if (HRCollUtil.isNotEmpty(vpIds = vpIds.stream().filter(id -> id > 0L).collect(Collectors.toSet()))) {
            HRBaseServiceHelper vpHelper = new HRBaseServiceHelper(AttFilePlanEnum.VP.getEntityNumber());
            QFilter vpFilter = new QFilter("id", "in", vpIds).and(commonFilter);
            Map<Long, List<DynamicObject>> vpGroup = Arrays.stream(vpHelper.query(SELECT_PLAN_PROPERTIES, new QFilter[]{vpFilter})).collect(Collectors.groupingBy(dy -> dy.getLong("id")));
            result.put(AttFilePlanEnum.VP.getSign(), vpGroup);
        }
        if (HRCollUtil.isNotEmpty(qtIds = qtIds.stream().filter(id -> id > 0L).collect(Collectors.toSet()))) {
            HRBaseServiceHelper qtHelper = new HRBaseServiceHelper(AttFilePlanEnum.QT.getEntityNumber());
            QFilter qtFilter = new QFilter("id", "in", qtIds).and(commonFilter);
            Map<Long, List<DynamicObject>> qtGroup = Arrays.stream(qtHelper.query(SELECT_PLAN_PROPERTIES, new QFilter[]{qtFilter})).collect(Collectors.groupingBy(dy -> dy.getLong("id")));
            result.put(AttFilePlanEnum.QT.getSign(), qtGroup);
        }
        if (HRCollUtil.isNotEmpty(tpIds = tpIds.stream().filter(id -> id > 0L).collect(Collectors.toSet()))) {
            HRBaseServiceHelper tpHelper = new HRBaseServiceHelper(AttFilePlanEnum.TP.getEntityNumber());
            QFilter tpFilter = new QFilter("id", "in", tpIds).and(commonFilter);
            Map<Long, List<DynamicObject>> tpGroup = Arrays.stream(tpHelper.query(SELECT_PLAN_PROPERTIES, new QFilter[]{tpFilter})).collect(Collectors.groupingBy(dy -> dy.getLong("id")));
            result.put(AttFilePlanEnum.TP.getSign(), tpGroup);
        }
        if (HRCollUtil.isNotEmpty(otpIds = otpIds.stream().filter(id -> id > 0L).collect(Collectors.toSet()))) {
            HRBaseServiceHelper otpHelper = new HRBaseServiceHelper(AttFilePlanEnum.OTP.getEntityNumber());
            QFilter otpFilter = new QFilter("id", "in", otpIds).and(commonFilter);
            Map<Long, List<DynamicObject>> otpGroup = Arrays.stream(otpHelper.query(SELECT_PLAN_PROPERTIES, new QFilter[]{otpFilter})).collect(Collectors.groupingBy(dy -> dy.getLong("id")));
            result.put(AttFilePlanEnum.OTP.getSign(), otpGroup);
        }
        if (HRCollUtil.isNotEmpty(exIds = exIds.stream().filter(id -> id > 0L).collect(Collectors.toSet()))) {
            HRBaseServiceHelper exHelper = new HRBaseServiceHelper(AttFilePlanEnum.EXS.getEntityNumber());
            QFilter exFilter = new QFilter("id", "in", exIds).and(commonFilter);
            Map<Long, List<DynamicObject>> exGroup = Arrays.stream(exHelper.query(SELECT_PLAN_PROPERTIES, new QFilter[]{exFilter})).collect(Collectors.groupingBy(dy -> dy.getLong("id")));
            result.put(AttFilePlanEnum.EXS.getSign(), exGroup);
        }
        if (HRCollUtil.isNotEmpty(adIds = adIds.stream().filter(id -> id > 0L).collect(Collectors.toSet()))) {
            HRBaseServiceHelper adHelper = new HRBaseServiceHelper(AttFilePlanEnum.AD.getEntityNumber());
            QFilter adFilter = new QFilter("id", "in", adIds).and(commonFilter);
            Map<Long, List<DynamicObject>> adGroup = Arrays.stream(adHelper.query(SELECT_PLAN_PROPERTIES, new QFilter[]{adFilter})).collect(Collectors.groupingBy(dy -> dy.getLong("id")));
            result.put(AttFilePlanEnum.AD.getSign(), adGroup);
        }
        if (HRCollUtil.isNotEmpty(idpIds = idpIds.stream().filter(id -> id > 0L).collect(Collectors.toSet()))) {
            HRBaseServiceHelper idpHelper = new HRBaseServiceHelper(AttFilePlanEnum.IDP.getEntityNumber());
            QFilter idpFilter = new QFilter("id", "in", idpIds).and(commonFilter);
            Map<Long, List<DynamicObject>> idpGroup = Arrays.stream(idpHelper.query(SELECT_PLAN_PROPERTIES, new QFilter[]{idpFilter})).collect(Collectors.groupingBy(dy -> dy.getLong("id")));
            result.put(AttFilePlanEnum.IDP.getSign(), idpGroup);
        }
        if (HRCollUtil.isNotEmpty(attIds = attIds.stream().filter(id -> id > 0L).collect(Collectors.toSet()))) {
            HRBaseServiceHelper attHelper = new HRBaseServiceHelper(AttFilePlanEnum.ATT.getEntityNumber());
            QFilter attFilter = new QFilter("id", "in", attIds).and(commonFilter);
            Map<Long, List<DynamicObject>> attGroup = Arrays.stream(attHelper.query(SELECT_PLAN_PROPERTIES, new QFilter[]{attFilter})).collect(Collectors.groupingBy(dy -> dy.getLong("id")));
            result.put(AttFilePlanEnum.ATT.getSign(), attGroup);
        }
        if (HRCollUtil.isNotEmpty(fmIds = fmIds.stream().filter(id -> id > 0L).collect(Collectors.toSet()))) {
            foHelper = new HRBaseServiceHelper(AttFilePlanEnum.FM.getEntityNumber());
            QFilter foFilter = new QFilter("id", "in", fmIds).and(commonFilter);
            foGroup = Arrays.stream(foHelper.query(SELECT_PLAN_PROPERTIES, new QFilter[]{foFilter})).collect(Collectors.groupingBy(dy -> dy.getLong("id")));
            result.put(AttFilePlanEnum.FM.getSign(), foGroup);
        }
        if (HRCollUtil.isNotEmpty(swShiftIds = swShiftIds.stream().filter(id -> id > 0L).collect(Collectors.toSet()))) {
            foHelper = new HRBaseServiceHelper(AttFilePlanEnum.SWSHIFT.getEntityNumber());
            QFilter swShiftFilter = new QFilter("id", "in", swShiftIds).and(commonFilter);
            foGroup = Arrays.stream(foHelper.query(SELECT_PLAN_PROPERTIES, new QFilter[]{swShiftFilter})).collect(Collectors.groupingBy(dy -> dy.getLong("id")));
            result.put(AttFilePlanEnum.SWSHIFT.getSign(), foGroup);
        }
        return result;
    }

    public static Map<Long, List<String>> validatePlan(String source, List<DynamicObject> dataList, Map<String, Map<Long, List<DynamicObject>>> planMap) {
        HashMap<Long, List<String>> errMsgMap = new HashMap<Long, List<String>>(dataList.size());
        boolean isScheduleSource = HRStringUtils.equals((String)"2", (String)source);
        for (DynamicObject data : dataList) {
            if (AttFileScheduleEnum.getIsTimeHisByPageId((String)data.getDataEntityType().getName())) continue;
            ArrayList<String> errMsgList = isScheduleSource ? new ArrayList<String>(1) : new ArrayList(8);
            Date startDate = data.getDate("startdate");
            Date endDate = data.getDate("enddate");
            if (null == startDate) continue;
            if (!isScheduleSource) {
                AttFilePlanHelper.validateAllRulePlan(data, errMsgList, planMap, startDate, endDate);
            } else {
                AttFilePlanHelper.validateScheduleRulePlan(data, errMsgList, planMap, startDate, endDate);
            }
            if (!HRCollUtil.isNotEmpty(errMsgList)) continue;
            errMsgMap.put((Long)data.getPkValue(), errMsgList);
        }
        return errMsgMap;
    }

    private static void validateAllRulePlan(DynamicObject data, List<String> errMsgList, Map<String, Map<Long, List<DynamicObject>>> planMap, Date startDate, Date endDate) {
        AttFilePlanEnum[] planEnums;
        for (AttFilePlanEnum planEnum : planEnums = AttFilePlanEnum.values()) {
            long planId = WTCDynamicObjectUtils.getBaseDataId((DynamicObject)data, (String)planEnum.getSign());
            String errMsg = AttFilePlanHelper.validatePlanDate(planId, startDate, endDate, planMap.get(planEnum.getSign()), planEnum.getPageName());
            if (!HRStringUtils.isNotEmpty((String)errMsg)) continue;
            errMsgList.add(errMsg);
        }
    }

    private static void validateScheduleRulePlan(DynamicObject data, List<String> errMsgList, Map<String, Map<Long, List<DynamicObject>>> planMap, Date startDate, Date endDate) {
        String entityName = data.getDataEntityType().getName();
        String key = AttFileScheduleEnum.getScheduleKeyByPageId((String)entityName);
        AttFilePlanEnum planEnum = AttFilePlanEnum.getBySign((String)key);
        if (null == planEnum) {
            return;
        }
        long planId = WTCDynamicObjectUtils.getBaseDataId((DynamicObject)data, (String)planEnum.getEntityId());
        String errMsg = AttFilePlanHelper.validatePlanDate(planId, startDate, endDate, planMap.get(planEnum.getSign()), planEnum.getPageName());
        if (HRStringUtils.isNotEmpty((String)errMsg)) {
            errMsgList.add(errMsg);
        }
    }

    private static String validatePlanDate(long planId, Date startDate, Date endDate, Map<Long, List<DynamicObject>> planMap, String planName) {
        String name;
        if (planId <= 0L) {
            return null;
        }
        if (null == endDate) {
            endDate = WTCDateUtils.getMaxEndDate();
        }
        if (endDate.before(startDate)) {
            return null;
        }
        List<DynamicObject> planList = planMap.get(planId);
        String string = name = HRCollUtil.isEmpty(planList) ? planName : planList.get(0).getString("name");
        if (HRCollUtil.isEmpty(planList)) {
            return AttFileBaseKDString.planDataErrorTips((String)name);
        }
        Date firstBsed = planList.get(0).getDate("firstbsed");
        if (null == firstBsed) {
            return AttFileBaseKDString.planDataErrorTips((String)name);
        }
        if (firstBsed.after(startDate)) {
            String start = WTCInteDateUtil.formatDateBySysTzAndUserFmt((Date)startDate);
            Date minEnd = firstBsed.after(endDate) ? endDate : WTCDateUtils.getBeforeDate((Date)firstBsed);
            String end = WTCInteDateUtil.formatDateBySysTzAndUserFmt((Date)minEnd);
            return AttFileBaseKDString.planDateTips((String)start, (String)end, (String)name);
        }
        if (firstBsed.after(endDate)) {
            String start = WTCInteDateUtil.formatDateBySysTzAndUserFmt((Date)startDate);
            String end = WTCInteDateUtil.formatDateBySysTzAndUserFmt((Date)endDate);
            return AttFileBaseKDString.planDateTips((String)start, (String)end, (String)name);
        }
        return null;
    }

    public static Map<String, List<DynamicObject>> cutSchedulePlanList(List<DynamicObject> notTimeHisDyList, Set<Long> attFileBoIdSet) {
        if (LOG.isInfoEnabled()) {
            LOG.info("AttFilePlanHelper.cutSchedulePlanList start ...");
        }
        ArrayList<AttFilePlanScheduleCutVo> result = new ArrayList<AttFilePlanScheduleCutVo>(notTimeHisDyList.size() * 2);
        Map<String, List<DynamicObject>> notTimeHisDyGroupMap = notTimeHisDyList.stream().collect(Collectors.groupingBy(dy -> dy.getDataEntityType().getName()));
        for (Map.Entry<String, List<DynamicObject>> notTimeHisDyEntry : notTimeHisDyGroupMap.entrySet()) {
            String name = notTimeHisDyEntry.getKey();
            List<DynamicObject> notTimeHisDys = notTimeHisDyEntry.getValue();
            AttFilePlanHelper.genSchedulePlanData(name, notTimeHisDys, result, attFileBoIdSet);
        }
        HashMap<String, List<DynamicObject>> resultMap = new HashMap<String, List<DynamicObject>>(4);
        for (AttFilePlanScheduleCutVo vo : result) {
            String entityName = vo.getSchedule().getDataEntityType().getName();
            if (entityName.contains("_dg") && !vo.isExistCut()) {
                ArrayList<DynamicObject> importList = (ArrayList<DynamicObject>)resultMap.get("importList");
                if (null == importList) {
                    importList = new ArrayList<DynamicObject>(result.size());
                }
                importList.add(vo.getSchedule());
                resultMap.put("importList", importList);
                continue;
            }
            if (entityName.contains("_dg") && (!entityName.contains("_dg") || !vo.isExistCut())) continue;
            ArrayList<DynamicObject> newList = (ArrayList<DynamicObject>)resultMap.get("newList");
            if (null == newList) {
                newList = new ArrayList<DynamicObject>(result.size());
            }
            newList.add(vo.getSchedule());
            resultMap.put("newList", newList);
        }
        if (LOG.isInfoEnabled()) {
            LOG.info("AttFilePlanHelper.cutSchedulePlanList end ...");
        }
        return resultMap;
    }

    private static void genSchedulePlanData(String name, List<DynamicObject> notTimeHisDys, List<AttFilePlanScheduleCutVo> result, Set<Long> attFileBoIdSet) {
        if (LOG.isInfoEnabled()) {
            LOG.info("AttFilePlanHelper.genSchedulePlanData start ...");
        }
        HRBaseServiceHelper serviceHelper = new HRBaseServiceHelper(name);
        String key = AttFileScheduleEnum.getScheduleKeyByPageId((String)name);
        AttFilePlanEnum planEnum = AttFilePlanEnum.getBySign((String)key);
        if (null == planEnum) {
            LOG.warn("cutSchedulePlan,not found pageId[{}]", (Object)name);
            return;
        }
        QFilter filter = new QFilter("attfileid.id", "in", attFileBoIdSet).and(AttFilePlanHelper.getPlanFilter()).and(new QFilter("busistatus", "=", (Object)"1"));
        DynamicObject[] currentScheduleDys = serviceHelper.loadDynamicObjectArray(new QFilter[]{filter});
        Map<Long, List<DynamicObject>> currentMap = Arrays.stream(currentScheduleDys).collect(Collectors.groupingBy(dy -> dy.getLong("attfileid.id")));
        HashMap<Long, List<AttFilePlanScheduleCutVo>> pendingMap = new HashMap<Long, List<AttFilePlanScheduleCutVo>>(attFileBoIdSet.size());
        Comparator<DynamicObject> comparator = Comparator.comparing(dy -> dy.getDate("startdate"));
        notTimeHisDys.sort(comparator);
        for (DynamicObject dynamicObject : notTimeHisDys) {
            Long attFileBoId = dynamicObject.getLong("attfileid.id");
            List<DynamicObject> currentDys = currentMap.get(attFileBoId);
            List<AttFilePlanScheduleCutVo> pendingDys = AttFilePlanHelper.cutCurrentSchedule(pendingMap, dynamicObject, currentDys, attFileBoId, serviceHelper, planEnum);
            pendingMap.put(attFileBoId, pendingDys);
        }
        for (Map.Entry entry : pendingMap.entrySet()) {
            List voList = (List)entry.getValue();
            for (AttFilePlanScheduleCutVo vo : voList) {
                if (null == vo.getSchedule() || vo.isExistNotChange()) continue;
                result.add(vo);
            }
        }
        if (LOG.isInfoEnabled()) {
            LOG.info("AttFilePlanHelper.genSchedulePlanData end ...");
        }
    }

    private static List<AttFilePlanScheduleCutVo> cutCurrentSchedule(Map<Long, List<AttFilePlanScheduleCutVo>> pendingMap, DynamicObject notTimeHisDy, List<DynamicObject> currentDys, Long attFileBoId, HRBaseServiceHelper serviceHelper, AttFilePlanEnum planEnum) {
        List<AttFilePlanScheduleCutVo> pendingDys = pendingMap.get(attFileBoId);
        if (HRCollUtil.isEmpty(currentDys) && HRCollUtil.isEmpty(pendingDys)) {
            ArrayList<AttFilePlanScheduleCutVo> list = new ArrayList<AttFilePlanScheduleCutVo>(1);
            AttFilePlanScheduleCutVo vo = new AttFilePlanScheduleCutVo();
            vo.setSchedule(notTimeHisDy);
            list.add(vo);
            return list;
        }
        if (HRCollUtil.isNotEmpty(currentDys) && HRCollUtil.isEmpty(pendingDys)) {
            return AttFilePlanHelper.cutPendingSchedule(currentDys, new ArrayList<AttFilePlanScheduleCutVo>(0), notTimeHisDy, serviceHelper, planEnum);
        }
        if (HRCollUtil.isNotEmpty(pendingDys)) {
            return AttFilePlanHelper.cutPendingSchedule(new ArrayList<DynamicObject>(0), pendingDys, notTimeHisDy, serviceHelper, planEnum);
        }
        return pendingDys;
    }

    private static List<AttFilePlanScheduleCutVo> cutPendingSchedule(List<DynamicObject> currentDys, List<AttFilePlanScheduleCutVo> pendingDys, DynamicObject notTimeHisDy, HRBaseServiceHelper serviceHelper, AttFilePlanEnum planEnum) {
        List<AttFilePlanScheduleCutVo> existDys;
        if (HRCollUtil.isNotEmpty(pendingDys)) {
            existDys = pendingDys;
        } else {
            ArrayList<AttFilePlanScheduleCutVo> list = new ArrayList<AttFilePlanScheduleCutVo>(currentDys.size());
            for (DynamicObject dy : currentDys) {
                AttFilePlanScheduleCutVo vo2 = new AttFilePlanScheduleCutVo();
                vo2.setSchedule(dy);
                vo2.setExistNotChange(true);
                list.add(vo2);
            }
            existDys = list;
        }
        Comparator<AttFilePlanScheduleCutVo> comparator = Comparator.comparing(vo -> vo.getSchedule().getDate("startdate"));
        existDys.sort(comparator);
        ArrayList<AttFilePlanScheduleCutVo> newPendingDys = new ArrayList<AttFilePlanScheduleCutVo>(existDys.size() + 1);
        Date compareStartDate = notTimeHisDy.getDate("startdate");
        Date compareEndDate = notTimeHisDy.getDate("enddate");
        long newId = notTimeHisDy.getLong("id");
        for (AttFilePlanScheduleCutVo existVo : existDys) {
            AttFilePlanScheduleCutVo vo3;
            AttFilePlanScheduleCutVo vo4;
            boolean isExistNotChange = existVo.isExistNotChange();
            DynamicObject existDy = existVo.getSchedule();
            long existId = existDy.getLong("id");
            if (newId == existId && newId > 0L) continue;
            Date curStartDate = existDy.getDate("startdate");
            Date curEndDate = existDy.getDate("enddate");
            if (!compareStartDate.after(curStartDate) && !compareEndDate.before(curStartDate) && compareEndDate.before(curEndDate)) {
                Date curStartDatePlus = WTCDateUtils.getNextDate((Date)compareEndDate);
                existDy.set("startdate", (Object)curStartDatePlus);
                vo4 = new AttFilePlanScheduleCutVo();
                vo4.setSchedule(existDy);
                vo4.setExistCut(true);
                newPendingDys.add(vo4);
                continue;
            }
            if (!compareEndDate.before(curEndDate) && compareStartDate.after(curStartDate) && !compareStartDate.after(curEndDate)) {
                Date curEndDateMinus = WTCDateUtils.getBeforeDate((Date)compareStartDate);
                existDy.set("enddate", (Object)curEndDateMinus);
                vo4 = new AttFilePlanScheduleCutVo();
                vo4.setSchedule(existDy);
                vo4.setExistCut(true);
                newPendingDys.add(vo4);
                continue;
            }
            if (compareStartDate.after(curStartDate) && compareEndDate.after(curStartDate) && compareEndDate.before(curEndDate)) {
                Date curFirstEnd = WTCDateUtils.getBeforeDate((Date)compareStartDate);
                Date pendingEnd = existDy.getDate("enddate");
                existDy.set("enddate", (Object)curFirstEnd);
                AttFilePlanScheduleCutVo vo5 = new AttFilePlanScheduleCutVo();
                vo5.setExistCut(true);
                vo5.setSchedule(existDy);
                newPendingDys.add(vo5);
                DynamicObject curLastDy = serviceHelper.generateEmptyDynamicObject();
                Date curLastStart = WTCDateUtils.getNextDate((Date)compareEndDate);
                curLastDy.set("startdate", (Object)curLastStart);
                curLastDy.set("enddate", (Object)pendingEnd);
                curLastDy.set("attfileid", (Object)existDy.getLong("attfileid.id"));
                curLastDy.set("attfilevid", (Object)existDy.getLong("attfilevid.id"));
                curLastDy.set("org", (Object)existDy.getLong("org.id"));
                curLastDy.set(planEnum.getSign(), (Object)existDy.getLong(planEnum.getEntityId()));
                curLastDy.set("attendstatus", (Object)existDy.getString("attendstatus"));
                curLastDy.set("busistatus", (Object)existDy.getString("busistatus"));
                AttFilePlanScheduleCutVo cutVo = new AttFilePlanScheduleCutVo();
                cutVo.setSchedule(curLastDy);
                newPendingDys.add(cutVo);
                continue;
            }
            if (!compareStartDate.after(curStartDate) && !compareEndDate.before(curStartDate)) {
                existDy.set("busistatus", (Object)"0");
                vo3 = new AttFilePlanScheduleCutVo();
                vo3.setExistCut(true);
                vo3.setSchedule(existDy);
                newPendingDys.add(vo3);
                continue;
            }
            if (compareEndDate.after(curStartDate) && compareStartDate.before(curEndDate)) continue;
            vo3 = new AttFilePlanScheduleCutVo();
            vo3.setSchedule(existDy);
            if (isExistNotChange) {
                vo3.setExistNotChange(true);
            }
            newPendingDys.add(vo3);
        }
        AttFilePlanScheduleCutVo vo6 = new AttFilePlanScheduleCutVo();
        vo6.setSchedule(notTimeHisDy);
        newPendingDys.add(vo6);
        newPendingDys.sort(comparator);
        return newPendingDys;
    }
}

