/*
 * Decompiled with CFR 0.152.
 */
package kd.wtc.wtp.business.attfile;

import com.alibaba.fastjson.JSON;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;
import kd.bos.bill.OperationStatus;
import kd.bos.cache.DistributeSessionlessCache;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.exception.ErrorCode;
import kd.bos.exception.KDBizException;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.ShowType;
import kd.bos.id.ID;
import kd.bos.list.ListShowParameter;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.mvc.cache.PageCache;
import kd.bos.orm.ORM;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.hr.hbp.business.domain.model.newhismodel.HisResponse;
import kd.hr.hbp.business.domain.model.newhismodel.HisVersionReviseResultBo;
import kd.hr.hbp.business.domain.model.newhismodel.HisVersionReviseReturnDataBo;
import kd.hr.hbp.business.domain.model.newhismodel.VersionChangeRespData;
import kd.hr.hbp.business.servicehelper.HRBaseServiceHelper;
import kd.hr.hbp.business.servicehelper.HRMServiceHelper;
import kd.hr.hbp.business.servicehelper.QueryEntityServiceHelper;
import kd.hr.hbp.common.api.HrApiResponse;
import kd.hr.hbp.common.model.AuthorizedOrgResultWithSub;
import kd.hr.hbp.common.util.HRDateTimeUtils;
import kd.hr.hbp.common.util.HRDynamicObjectUtils;
import kd.hr.hbp.common.util.HRStringUtils;
import kd.wtc.wtbd.business.workschedule.AttFileWorkScheduleService;
import kd.wtc.wtbd.common.entity.workschedule.AttFileWorkSchCheckReq;
import kd.wtc.wtbs.business.history.service.WTCCommonHisService;
import kd.wtc.wtbs.business.history.service.WTCHisServiceHelper;
import kd.wtc.wtbs.business.license.CertControlType;
import kd.wtc.wtbs.business.license.CertService;
import kd.wtc.wtbs.business.model.attendperson.AttendPersonCurrResult;
import kd.wtc.wtbs.business.servicehelper.WTCServiceHelper;
import kd.wtc.wtbs.business.util.WTCDynamicObjectUtils;
import kd.wtc.wtbs.business.web.DataBaseEditService;
import kd.wtc.wtbs.business.web.attendperson.AttendPersonSynService;
import kd.wtc.wtbs.business.web.attendperson.AttendPersonUpdateServiceImpl;
import kd.wtc.wtbs.business.web.file.AttFileQueryServiceImpl;
import kd.wtc.wtbs.business.web.wtte.sysparam.AttRecordParamService;
import kd.wtc.wtbs.common.bill.BillPermQueryParam;
import kd.wtc.wtbs.common.bill.BillQueryParam;
import kd.wtc.wtbs.common.bill.BusitripBillQueryParam;
import kd.wtc.wtbs.common.bill.OtBillQueryParam;
import kd.wtc.wtbs.common.bill.SupSignBillQueryParam;
import kd.wtc.wtbs.common.bill.VaBatchBillQueryParam;
import kd.wtc.wtbs.common.bill.VaBillQueryParam;
import kd.wtc.wtbs.common.enums.AttFileScheduleEnum;
import kd.wtc.wtbs.common.enums.AttendEnum;
import kd.wtc.wtbs.common.enums.file.AttStatusEnum;
import kd.wtc.wtbs.common.model.attfile.AttFileQueryParam;
import kd.wtc.wtbs.common.model.attfile.AttFileScheduleQueryParam;
import kd.wtc.wtbs.common.util.WTCCacheUtils;
import kd.wtc.wtbs.common.util.WTCCollectionIndexUtil;
import kd.wtc.wtbs.common.util.WTCCollections;
import kd.wtc.wtbs.common.util.WTCDateUtils;
import kd.wtc.wtbs.common.util.WTCMaps;
import kd.wtc.wtbs.common.util.WTCStringUtils;
import kd.wtc.wtbs.common.util.third.collect.Lists;
import kd.wtc.wtbs.common.util.third.collect.Maps;
import kd.wtc.wtbs.common.util.third.collect.Sets;
import kd.wtc.wtbs.common.util.third.time.StopWatch;
import kd.wtc.wtbs.wtte.common.model.AttRecordParam;
import kd.wtc.wtp.business.attconfirm.AttConfirmHelper;
import kd.wtc.wtp.business.attconfirm.impl.AttConfirmQueryServiceImpl;
import kd.wtc.wtp.business.attfile.AttFileCheckService;
import kd.wtc.wtp.business.attfile.AttFileHelper;
import kd.wtc.wtp.business.attfile.IAttFileService;
import kd.wtc.wtp.business.attfile.cert.AttFileCertService;
import kd.wtc.wtp.business.attfile.schedule.AttFileScheduleBusiness;
import kd.wtc.wtp.business.attfile.schedule.AttFileScheduleCheckHelper;
import kd.wtc.wtp.business.attfile.schedule.AttFileScheduleServiceImpl;
import kd.wtc.wtp.business.attstateinfo.AttStateInfoService;
import kd.wtc.wtp.common.enums.FileGroupEnum;
import kd.wtc.wtp.common.enums.attconfirm.AttConRecordTypeEnum;
import kd.wtc.wtp.common.enums.attconfirm.AttConfirmDataStatusEnum;
import kd.wtc.wtp.common.kdstring.AttFileKDString;
import kd.wtc.wtp.common.model.attconfirm.AttConfirmRecordModel;
import kd.wtc.wtp.common.model.attconfirm.AttConfirmRecordQueryParam;
import kd.wtc.wtp.common.model.attstateinfo.AttStateInfoBO;
import kd.wtc.wtp.common.model.attstateinfo.AttStateInfoInitModel;
import kd.wtc.wtp.enums.attfile.AttFileStopAttBillQueryEnum;

public class AttFileServiceImpl
implements IAttFileService {
    private static final Log LOG = LogFactory.getLog(AttFileServiceImpl.class);

    public static AttFileServiceImpl getInstance() {
        return SingletonInstance.SINGLETON;
    }

    @Override
    public List<Map<String, String>> addAttFile(DynamicObject[] saveEntities, Long mainBoId) {
        ArrayList rosterSynDataList = Lists.newArrayListWithExpectedSize((int)10);
        List<Long> personCertIds = AttFileCertService.getAddCertDealId(Arrays.asList(saveEntities));
        int length = saveEntities.length;
        long[] attFileBaseLongIds = ORM.create().genLongIds("wtp_attfilebase", length);
        long[] wtteInfoLongIds = ORM.create().genLongIds("wtp_attstateinfo", length);
        HRBaseServiceHelper wtteInfoHelper = new HRBaseServiceHelper("wtp_attstateinfo");
        HRBaseServiceHelper hrBaseServiceHelper = new HRBaseServiceHelper("wtp_depempjob");
        for (int i = 0; i < length; ++i) {
            DynamicObject saveEntity = saveEntities[i];
            String usableStatus = saveEntity.getString("usablestatus");
            if (WTCStringUtils.isEmpty((String)usableStatus)) {
                saveEntity.set("usablestatus", (Object)"0");
            }
            long fileId = saveEntity.getLong("id") == 0L ? attFileBaseLongIds[i] : saveEntity.getLong("id");
            saveEntity.set("id", (Object)fileId);
            DynamicObject wtteInfoDy = wtteInfoHelper.generateEmptyDynamicObject();
            wtteInfoDy.set("id", (Object)wtteInfoLongIds[i]);
            saveEntity.set("wtteinfo", (Object)wtteInfoDy);
            if (saveEntity.getLong("hrpiempposorgrel.id") == 0L) continue;
            DynamicObject emptyDynamicObject = hrBaseServiceHelper.generateEmptyDynamicObject();
            emptyDynamicObject.set("id", (Object)saveEntity.getLong("hrpiempposorgrel.id"));
            saveEntity.set("empposorgrel", (Object)emptyDynamicObject);
        }
        if (saveEntities.length == 0) {
            return rosterSynDataList;
        }
        HisResponse versionChangeRespDataHisResponse = WTCCommonHisService.saveTimeHisModelData((DynamicObject[])saveEntities, (String)saveEntities[0].getDataEntityType().getExtendName(), (Long)mainBoId, (Boolean)Boolean.FALSE);
        if (versionChangeRespDataHisResponse.getData() == null || ((VersionChangeRespData)versionChangeRespDataHisResponse.getData()).getNewDynamicObjects() == null) {
            return rosterSynDataList;
        }
        DynamicObject[] newDynamicObjects = ((VersionChangeRespData)versionChangeRespDataHisResponse.getData()).getNewDynamicObjects();
        this.saveAttPersonOtherInfoFromFileDy(saveEntities);
        ArrayList attStateInfoInitModelArrayList = Lists.newArrayListWithExpectedSize((int)saveEntities.length);
        long orgId = saveEntities[0].getLong("org.id");
        AttRecordParam attRecordParam = AttRecordParamService.getAttRecordParam((long)orgId);
        LOG.info("orgId = {},AttRecordParam = {}", (Object)orgId, (Object)(attRecordParam == null ? "" : JSON.toJSONString((Object)attRecordParam)));
        HashSet employeeIdSet = Sets.newHashSetWithExpectedSize((int)newDynamicObjects.length);
        ArrayList saveSuccessFileVersion = Lists.newArrayListWithExpectedSize((int)newDynamicObjects.length);
        for (DynamicObject saveEntity : newDynamicObjects) {
            if (saveEntity.getBoolean("iscurrentversion")) continue;
            this.genWtteInfoDy(attRecordParam, saveEntity, attStateInfoInitModelArrayList);
            employeeIdSet.add(WTCDynamicObjectUtils.getBaseDataId((DynamicObject)saveEntity, (String)"employee"));
            saveSuccessFileVersion.add(saveEntity);
        }
        List<DynamicObject> attFileList = AttFileHelper.queryAttListByPersonIdSet(employeeIdSet);
        List<DynamicObject> attFileFirstVersionList = this.getFirstAttFileList(attFileList);
        List<DynamicObject[]> list = this.batchSynUpdatePreBOEndDate(attFileList, attFileFirstVersionList);
        DynamicObject[] needUpdateAttFileArr = list.get(0);
        DynamicObject[] stopAttendAttFileArr = list.get(1);
        try (TXHandle tx = TX.required();){
            try {
                CertService.certControlOfAttPerson((String)"wtp", (String)"wtp_attfilebase", new HashSet<Long>(personCertIds), (CertControlType)CertControlType.VALIDATORANDAPPLIED);
                AttFileScheduleServiceImpl.getInstance().saveAttFileSchedule(saveSuccessFileVersion.toArray(new DynamicObject[0]), mainBoId, rosterSynDataList);
                AttStateInfoService.getInstance().initAttStateInfo(attStateInfoInitModelArrayList);
                if (needUpdateAttFileArr != null && needUpdateAttFileArr.length > 0) {
                    this.attFileRevise(needUpdateAttFileArr);
                }
                if (stopAttendAttFileArr != null && stopAttendAttFileArr.length > 0) {
                    this.copyAttFile(stopAttendAttFileArr);
                    this.updateAttFile(stopAttendAttFileArr, ID.genLongId(), true, true);
                    this.invalidAttConfirmData(stopAttendAttFileArr);
                }
            }
            catch (Throwable throwable) {
                tx.markRollback();
                throw new KDBizException(throwable, new ErrorCode("", throwable.getMessage()), new Object[0]);
            }
        }
        return rosterSynDataList;
    }

    private void invalidAttConfirmData(DynamicObject[] stopAttendAttFileArr) {
        if (stopAttendAttFileArr == null || stopAttendAttFileArr.length == 0) {
            return;
        }
        Map<Long, Date> lastFileBoIdToEndDateMap = Arrays.stream(stopAttendAttFileArr).collect(Collectors.toMap(d -> d.getLong("boid"), d -> d.getDate("enddate"), (a, b) -> a));
        AttConfirmRecordQueryParam attConfirmRecordQueryParam = new AttConfirmRecordQueryParam();
        attConfirmRecordQueryParam.setAttFileBoIdSet(lastFileBoIdToEndDateMap.keySet());
        attConfirmRecordQueryParam.setType(AttConRecordTypeEnum.BY_DATE);
        List<AttConfirmRecordModel> attConfirmRecordModelList = AttConfirmQueryServiceImpl.getInstance().queryAttConfirmRecordModelList(attConfirmRecordQueryParam);
        HashSet invalidAttConfirmIdSet = Sets.newHashSetWithExpectedSize((int)attConfirmRecordModelList.size());
        for (AttConfirmRecordModel attConfirmRecordModel : attConfirmRecordModelList) {
            Date startDate = attConfirmRecordModel.getStartDate();
            long attFile = attConfirmRecordModel.getAttFile();
            Date fileEndDate = lastFileBoIdToEndDateMap.get(attFile);
            if (fileEndDate == null || startDate == null || !startDate.after(fileEndDate)) continue;
            invalidAttConfirmIdSet.add(attConfirmRecordModel.getId());
        }
        if (WTCCollections.isNotEmpty((Collection)invalidAttConfirmIdSet)) {
            AttConfirmQueryServiceImpl.getInstance().updateDataStatusAttConfirmRecord(new QFilter("id", "in", (Object)invalidAttConfirmIdSet), AttConfirmDataStatusEnum.INVALID);
            AttConfirmHelper.getInstance().sendMessageWhenAttConRecordInvalidity(new ArrayList<Long>(invalidAttConfirmIdSet), null);
        }
    }

    @Override
    public void attFileRevise(DynamicObject[] needUpdateAttFileArr) {
        HrApiResponse reviseResultBo = WTCCommonHisService.reviseVersion((DynamicObject[])needUpdateAttFileArr, (String)"wtp_attfilebase");
        if (!reviseResultBo.isSuccess()) {
            throw new KDBizException(reviseResultBo.getErrorMessage());
        }
        DynamicObject[] successRevise = ((HisVersionReviseResultBo)reviseResultBo.getData()).getReturnDataBo().getReturnData();
        HRBaseServiceHelper hrBaseServiceHelper = new HRBaseServiceHelper("wtp_attfilebase");
        hrBaseServiceHelper.save(successRevise);
    }

    @Override
    public void attFileRevise(DynamicObject[] needUpdateAttFileArr, AttFileScheduleEnum attFileScheduleEnum) {
        String pageId = attFileScheduleEnum.getPageId();
        HRBaseServiceHelper hrBaseServiceHelper = new HRBaseServiceHelper(pageId);
        if (AttFileScheduleEnum.getIsTimeHisByPageId((String)pageId)) {
            hrBaseServiceHelper.update(needUpdateAttFileArr);
        } else {
            HisVersionReviseReturnDataBo returnDataBo;
            HrApiResponse reviseResultBo = WTCCommonHisService.reviseVersion((DynamicObject[])needUpdateAttFileArr, (String)pageId);
            if (null != reviseResultBo && null != reviseResultBo.getData() && null != (returnDataBo = ((HisVersionReviseResultBo)reviseResultBo.getData()).getReturnDataBo())) {
                DynamicObject[] successRevise = returnDataBo.getReturnData();
                hrBaseServiceHelper.save(this.eliminateReviseStatus(successRevise));
            }
        }
    }

    private DynamicObject[] eliminateReviseStatus(DynamicObject[] successRevise) {
        if (successRevise != null) {
            ArrayList dyList = Lists.newArrayListWithExpectedSize((int)successRevise.length);
            for (DynamicObject dynamicObject : successRevise) {
                if ("-4".equals(dynamicObject.getString("datastatus"))) continue;
                dyList.add(dynamicObject);
            }
            DynamicObject[] dyArr = new DynamicObject[dyList.size()];
            return dyList.toArray(dyArr);
        }
        return null;
    }

    private void copyAttFile(DynamicObject[] updateAttFileArr) {
        if (updateAttFileArr != null) {
            for (int index = 0; index < updateAttFileArr.length; ++index) {
                DynamicObject file = updateAttFileArr[index];
                HRBaseServiceHelper hrBaseServiceHelper = new HRBaseServiceHelper("wtp_attfilebase");
                DynamicObject dynamicObject = hrBaseServiceHelper.generateEmptyDynamicObject();
                HRDynamicObjectUtils.copy((DynamicObject)file, (DynamicObject)dynamicObject, (boolean)true);
                updateAttFileArr[index] = dynamicObject;
            }
        }
    }

    private List<DynamicObject[]> batchSynUpdatePreBOEndDate(List<DynamicObject> attFileList, List<DynamicObject> attFileFirstVersionList) {
        Map<Long, List<DynamicObject>> employeeIdMap = attFileFirstVersionList.stream().collect(Collectors.groupingBy(dy -> dy.getLong("employee.id")));
        ArrayList needUpdateAttFileList = Lists.newArrayListWithExpectedSize((int)attFileList.size());
        ArrayList stopAttendAttFileList = Lists.newArrayListWithExpectedSize((int)attFileList.size());
        Map<Long, List<DynamicObject>> boIdMap = attFileList.stream().collect(Collectors.groupingBy(dy -> dy.getLong("boid")));
        Date maxEndDate = WTCHisServiceHelper.getMaxEndDate();
        employeeIdMap.forEach((key, val) -> {
            Map<Long, Date> boIdEndDateMap = this.getBoIdEndDateMap((List<DynamicObject>)val);
            boIdEndDateMap.forEach((boId, endDate) -> {
                List boList = (List)boIdMap.get(boId);
                List<DynamicObject> noBoList = boList.stream().filter(item -> !item.getBoolean("iscurrentversion")).collect(Collectors.toList());
                AttFileHelper.sortAttFileList(noBoList, "bsed", true);
                for (int index = 0; index < noBoList.size(); ++index) {
                    DynamicObject att = noBoList.get(index);
                    att.set("enddate", endDate);
                    Date sDate = att.getDate("bsed");
                    Date eDate = att.getDate("bsled");
                    Date addNextBsedDate = HRDateTimeUtils.addDay((Date)endDate, (long)1L);
                    if (sDate != null && eDate != null && addNextBsedDate.compareTo(sDate) >= 0 && addNextBsedDate.compareTo(eDate) <= 0) {
                        HRBaseServiceHelper hrBaseServiceHelper = new HRBaseServiceHelper("wtbd_attendtag");
                        HRBaseServiceHelper attFileBaseServiceHelper = new HRBaseServiceHelper("wtp_attfilebase");
                        DynamicObject attend = hrBaseServiceHelper.generateEmptyDynamicObject();
                        attend.set("id", (Object)AttendEnum.SHIFT.getId());
                        DynamicObject stopAtt = attFileBaseServiceHelper.generateEmptyDynamicObject();
                        HRDynamicObjectUtils.copy((DynamicObject)att, (DynamicObject)stopAtt, (Set)WTCHisServiceHelper.getHisIgnoreKeysSet());
                        stopAtt.set("atttag", (Object)attend);
                        stopAtt.set("bsed", (Object)addNextBsedDate);
                        stopAtt.set("firstbsed", att.get("firstbsed"));
                        stopAtt.set("datastatus", (Object)"-3");
                        stopAtt.set("bsled", (Object)maxEndDate);
                        stopAttendAttFileList.add(stopAtt);
                    }
                    needUpdateAttFileList.add(att);
                }
            });
        });
        DynamicObject[] needUpdateAttFileArr = new DynamicObject[needUpdateAttFileList.size()];
        needUpdateAttFileList.toArray(needUpdateAttFileArr);
        DynamicObject[] stopAttendAttFileArr = new DynamicObject[stopAttendAttFileList.size()];
        stopAttendAttFileList.toArray(stopAttendAttFileArr);
        ArrayList list = Lists.newArrayListWithExpectedSize((int)2);
        list.add(needUpdateAttFileArr);
        list.add(stopAttendAttFileArr);
        return list;
    }

    private List<DynamicObject> getFirstAttFileList(List<DynamicObject> attFileList) {
        return attFileList.stream().filter(item -> item.getDate("startdate").equals(item.getDate("bsed")) && !item.getBoolean("iscurrentversion") && ("0".equals(item.getString("datastatus")) || "2".equals(item.getString("datastatus")) || "1".equals(item.getString("datastatus")))).collect(Collectors.toList());
    }

    private Map<Long, Date> getBoIdEndDateMap(List<DynamicObject> attFileFirstVersionList) {
        AttFileHelper.sortAttFileList(attFileFirstVersionList, "bsed", false);
        HashMap boIdEndDateMap = Maps.newHashMapWithExpectedSize((int)(attFileFirstVersionList.size() - 1));
        for (int i = 0; i < attFileFirstVersionList.size() - 1; ++i) {
            DynamicObject att = attFileFirstVersionList.get(i);
            Date originalEndDate = att.getDate("enddate");
            if (!HRDateTimeUtils.format((Date)originalEndDate, (String)"yyyy-MM-dd").equals("2999-12-31")) continue;
            DynamicObject preAtt = attFileFirstVersionList.get(i + 1);
            Date preStartDate = preAtt.getDate("bsed");
            Date endDate = HRDateTimeUtils.addDay((Date)preStartDate, (long)-1L);
            boIdEndDateMap.put(att.getLong("boid"), endDate);
        }
        return boIdEndDateMap;
    }

    private void genWtteInfoDy(AttRecordParam attRecordParam, DynamicObject saveEntity, List<AttStateInfoInitModel> attStateInfoInitModelArrayList) {
        Date fileStartDate = saveEntity.getDate("bsed");
        if (attRecordParam != null && attRecordParam.getRecaldate() != null && fileStartDate.before(attRecordParam.getRecaldate())) {
            fileStartDate = attRecordParam.getRecaldate();
        }
        AttStateInfoInitModel attStateInfoInitModel = new AttStateInfoInitModel();
        attStateInfoInitModel.setFileBoId(Long.valueOf(saveEntity.getLong("boid")));
        attStateInfoInitModel.setAllowReAccountTime(fileStartDate);
        attStateInfoInitModel.setPersonId(Long.valueOf(saveEntity.getLong("attperson.id")));
        attStateInfoInitModel.setId(Long.valueOf(saveEntity.getLong("wtteinfo.id")));
        attStateInfoInitModelArrayList.add(attStateInfoInitModel);
    }

    @Override
    public void updateAttFile(DynamicObject[] fileEntities, Long mainBoId, boolean cancelNotSupported, boolean synFileVid) {
        int i;
        if (fileEntities == null || fileEntities.length == 0) {
            return;
        }
        DynamicObject[] newFileEntities = new DynamicObject[fileEntities.length];
        for (i = 0; i < newFileEntities.length; ++i) {
            newFileEntities[i] = (DynamicObject)fileEntities[i].getDataEntityType().createInstance();
        }
        for (i = 0; i < newFileEntities.length; ++i) {
            HRDynamicObjectUtils.copy((DynamicObject)fileEntities[i], (DynamicObject)newFileEntities[i]);
        }
        fileEntities = newFileEntities;
        Map<String, List<Long>> updateCertDealId = AttFileCertService.getUpdateCertDealId(Arrays.asList(fileEntities));
        List empPosIds = Arrays.stream(fileEntities).map(data -> {
            long aLong = data.getLong("hrpiempposorgrel.id");
            if (aLong == 0L) {
                aLong = data.getLong("empposorgrel.id");
            }
            if (aLong == 0L) {
                if (data.get("hrpiempposorgrel") != null) {
                    LOG.info("\u4efb\u804c\u7ecf\u5386\u5f02\u5e38\u6570\u636ehrpiempposorgrel {}", (Object)data.get("hrpiempposorgrel").toString());
                }
                if (data.get("empposorgrel") != null) {
                    LOG.info("\u4efb\u804c\u7ecf\u5386\u5f02\u5e38\u6570\u636eempposorgrel {}", (Object)data.get("empposorgrel").toString());
                }
                throw new KDBizException(ResManager.loadKDString((String)"\u4efb\u804c\u7ecf\u5386\u6570\u636e\u5f02\u5e38\u3002", (String)"AttFileServiceImpl_0", (String)"wtc-wtp-business", (Object[])new Object[0]));
            }
            return aLong;
        }).collect(Collectors.toList());
        List personIds = Arrays.stream(fileEntities).map(data -> data.getLong("person.id")).collect(Collectors.toList());
        Set<Long> employeeIds = Arrays.stream(fileEntities).map(data -> WTCDynamicObjectUtils.getBaseDataId((DynamicObject)data, (String)"employee")).collect(Collectors.toSet());
        Date startDate = WTCHisServiceHelper.getMinEndDate();
        Date endDate = WTCHisServiceHelper.getMaxEndDate();
        HRBaseServiceHelper hrBaseServiceHelper = new HRBaseServiceHelper("wtp_depempjob");
        HashMap boIdEndDateMap = Maps.newHashMapWithExpectedSize((int)16);
        ArrayList needReviseList = Lists.newArrayListWithExpectedSize((int)16);
        boolean ifHandleStopAtt = false;
        for (DynamicObject fileEntity : fileEntities) {
            DynamicObject[] entityStartDate = fileEntity.getDate("bsed");
            Date entityEndDate = fileEntity.getDate("bsled");
            if (fileEntity.getLong("hrpiempposorgrel.id") != 0L) {
                DynamicObject emptyDynamicObject = hrBaseServiceHelper.generateEmptyDynamicObject();
                emptyDynamicObject.set("id", (Object)fileEntity.getLong("hrpiempposorgrel.id"));
                fileEntity.set("empposorgrel", (Object)emptyDynamicObject);
            }
            if (entityStartDate != null && startDate.before((Date)entityStartDate)) {
                startDate = entityStartDate;
            }
            if (entityEndDate != null && endDate.after(entityEndDate)) {
                endDate = entityEndDate;
            }
            if (entityStartDate != null && AttStatusEnum.ATT_STOP.getCode().equals(fileEntity.get("atttag.attendstatus"))) {
                ifHandleStopAtt = true;
                Date reviseEndDate = HRDateTimeUtils.addDay((Date)entityStartDate, (long)-1L);
                fileEntity.set("enddate", (Object)reviseEndDate);
                boIdEndDateMap.put(fileEntity.getLong("boid"), reviseEndDate);
            }
            fileEntity.set("datastatus", (Object)"-3");
        }
        HisResponse versionChangeRespDataHisResponse = WTCCommonHisService.saveTimeHisModelData((DynamicObject[])fileEntities, (String)fileEntities[0].getDataEntityType().getExtendName(), (Long)mainBoId, (boolean)false, (boolean)cancelNotSupported);
        if (versionChangeRespDataHisResponse.getData() == null || ((VersionChangeRespData)versionChangeRespDataHisResponse.getData()).getNewDynamicObjects() == null) {
            return;
        }
        Set<Long> fileBoIds = Arrays.stream(fileEntities).map(dy -> dy.getLong("boid")).collect(Collectors.toSet());
        List<DynamicObject> personAttFileList = AttFileHelper.queryAttListByPersonIdSet(employeeIds);
        Map<Long, List<DynamicObject>> attBoIdMap = personAttFileList.stream().collect(Collectors.groupingBy(dy -> dy.getLong("boid")));
        if (ifHandleStopAtt) {
            for (DynamicObject fileEntity : fileEntities) {
                List<DynamicObject> boList = attBoIdMap.get(fileEntity.getLong("boid"));
                if (!WTCCollections.isNotEmpty(boList)) continue;
                boList.forEach(dy -> {
                    if (!dy.getBoolean("iscurrentversion") && !needReviseList.contains(dy) && boIdEndDateMap.get(dy.getLong("boid")) != null) {
                        dy.set("enddate", boIdEndDateMap.get(dy.getLong("boid")));
                        needReviseList.add(dy);
                    }
                });
            }
        }
        HashMap map = Maps.newHashMapWithExpectedSize((int)16);
        map.put("employee", Arrays.stream(fileEntities).map(d -> WTCDynamicObjectUtils.getBaseDataId((DynamicObject)d, (String)"employee")).collect(Collectors.toList()));
        AttendPersonCurrResult attendPersonCurrResult = AttendPersonSynService.getInstance().checkAndGetPersonDataCustom(personIds, empPosIds, null, (Map)map);
        AttendPersonSynService.getInstance().setEarliestAndLatestDate(fileEntities, attendPersonCurrResult);
        AttendPersonSynService.getInstance().updateAttPerson(attendPersonCurrResult);
        List<DynamicObject> attFileByFileList = AttFileHelper.getAttFileByFileBoId(fileBoIds, false);
        try (TXHandle tx = TX.required();){
            try {
                List<Long> deleteIds = updateCertDealId.get("delete");
                CertService.certControl((String)"wtp", (String)"wtp_attfilebase", deleteIds, (CertControlType)CertControlType.VALIDATORANDRELEASE);
                List<Long> addIds = updateCertDealId.get("add");
                CertService.certControl((String)"wtp", (String)"wtp_attfilebase", addIds, (CertControlType)CertControlType.VALIDATORANDAPPLIED);
                this.cutAllBaseAndRuleSchedule(attFileByFileList, null, mainBoId, true);
                if (WTCCollections.isNotEmpty((Collection)needReviseList)) {
                    DynamicObject[] needRevise = new DynamicObject[needReviseList.size()];
                    needReviseList.toArray(needRevise);
                    this.attFileRevise(needRevise);
                    this.invalidAttConfirmData(needRevise);
                }
                this.updateException(fileEntities);
            }
            catch (Throwable throwable) {
                tx.markRollback();
                throw new KDBizException(throwable, new ErrorCode("", throwable.getMessage()), new Object[0]);
            }
        }
    }

    private void updateException(DynamicObject[] fileEntities) {
        List<Long> fileBoIdList = Arrays.stream(fileEntities).map(dy -> dy.getLong("boid")).collect(Collectors.toList());
        List<AttStateInfoBO> attStateInfoBOS = AttStateInfoService.getInstance().queryAttStateInfoByBoid(fileBoIdList);
        if (!CollectionUtils.isEmpty(attStateInfoBOS)) {
            HashMap fileBoIdWtteDyMap = Maps.newHashMapWithExpectedSize((int)fileEntities.length);
            ArrayList needUpdateFileBoIdList = Lists.newArrayListWithExpectedSize((int)fileEntities.length);
            Map<Long, Date> accountToMap = attStateInfoBOS.stream().filter(arg -> arg.getAccountTo() != null).collect(Collectors.toMap(AttStateInfoBO::getFileBoid, AttStateInfoBO::getAccountTo, (oldValue, newValue) -> oldValue));
            for (DynamicObject file : fileEntities) {
                Long fileBoId = file.getLong("boid");
                Date bsed = file.getDate("bsed");
                Date accountToDate = accountToMap.get(fileBoId);
                if (!AttendEnum.LEAVE.getId().equals(file.getLong("atttag.id")) && !AttendEnum.SHIFT.getId().equals(file.getLong("atttag.id")) || accountToDate == null || bsed == null || accountToDate.getTime() < bsed.getTime()) continue;
                HashMap newWtteDyMap = Maps.newHashMapWithExpectedSize((int)3);
                newWtteDyMap.put("isinfoexc", Boolean.TRUE);
                newWtteDyMap.put("excstartdate", bsed);
                newWtteDyMap.put("excenddate", accountToDate);
                fileBoIdWtteDyMap.put(fileBoId, newWtteDyMap);
                needUpdateFileBoIdList.add(fileBoId);
            }
            if (WTCMaps.isNotEmpty((Map)fileBoIdWtteDyMap)) {
                AttStateInfoService.getInstance().updateExcInfo(fileBoIdWtteDyMap, needUpdateFileBoIdList);
            }
        }
    }

    @Override
    public void cutAllBaseAndRuleSchedule(List<DynamicObject> allFileList, Set<AttFileScheduleEnum> updateScheduleEnumSet, Long mainBoId, boolean ifCheck) {
        if (WTCCollections.isNotEmpty(allFileList)) {
            Set attFileBoIdSet = allFileList.stream().map(d -> d.getLong("boid")).collect(Collectors.toSet());
            Map<Long, String> nameMap = allFileList.stream().collect(Collectors.toMap(a -> a.getLong("boid"), b -> b.getString("number"), (k1, k2) -> k1));
            if (WTCCollections.isNotEmpty(attFileBoIdSet)) {
                ArrayList tobeUpdateBaseScheduleSet = Lists.newArrayListWithExpectedSize((int)16);
                ArrayList tobeUpdatePlanScheduleSet = Lists.newArrayListWithExpectedSize((int)16);
                ArrayList tobeUpdatePlanScheduleBoSet = Lists.newArrayListWithExpectedSize((int)16);
                HashSet hadBeenCutResultScheduleIdSet = Sets.newHashSetWithExpectedSize((int)16);
                HashMap beginCut = Maps.newHashMapWithExpectedSize((int)16);
                AttFileScheduleEnum[] attFileScheduleEnumArr = AttFileScheduleEnum.values();
                Arrays.stream(attFileScheduleEnumArr).forEach(scheduleEnum -> {
                    Map<Long, List<DynamicObject>> fileBoIdListMap;
                    Map<Long, List<DynamicObject>> fileBoIdScheduleMap;
                    if ((WTCCollections.isEmpty((Collection)updateScheduleEnumSet) || updateScheduleEnumSet.contains(scheduleEnum)) && WTCCollections.isNotEmpty(fileBoIdScheduleMap = this.queryAttFileScheduleByAttFileIdAndDay(attFileBoIdSet, (AttFileScheduleEnum)scheduleEnum)) && WTCCollections.isNotEmpty(fileBoIdListMap = allFileList.stream().collect(Collectors.groupingBy(d -> d.getLong("boid"))))) {
                        fileBoIdListMap.forEach((fileBoId, fileList) -> {
                            fileList.sort(Comparator.comparing(o -> o.getDate("bsed")));
                            for (int j = 0; j < fileList.size(); ++j) {
                                DynamicObject file = (DynamicObject)fileList.get(j);
                                List scheduleDyList = (List)fileBoIdScheduleMap.get(file.getLong("boid"));
                                List<DynamicObject> resultScheduleDyList = this.getScheduleDyByDate(scheduleDyList, file.getDate("bsed"), file.getDate("bsled"), (AttFileScheduleEnum)scheduleEnum);
                                resultScheduleDyList.sort((o1, o2) -> {
                                    if (scheduleEnum.isTimeHis()) {
                                        return o1.getDate("bsed").compareTo(o2.getDate("bsed"));
                                    }
                                    return o1.getDate("startdate").compareTo(o2.getDate("startdate"));
                                });
                                if (!WTCCollections.isNotEmpty(resultScheduleDyList)) continue;
                                HRBaseServiceHelper hrBaseServiceHelper = new HRBaseServiceHelper(scheduleEnum.getPageId());
                                int size = resultScheduleDyList.size();
                                for (int i = 0; i < size; ++i) {
                                    DynamicObject newScheduleDy = hrBaseServiceHelper.generateEmptyDynamicObject();
                                    DynamicObject currentScheduleDy = resultScheduleDyList.get(i);
                                    HRDynamicObjectUtils.copy((DynamicObject)currentScheduleDy, (DynamicObject)newScheduleDy, (Set)WTCHisServiceHelper.getHisIgnoreKeysSet());
                                    String attendStatus = currentScheduleDy.getString("attendstatus");
                                    if (scheduleEnum.isTimeHis()) {
                                        if (WTCDynamicObjectUtils.getBaseDataId((DynamicObject)currentScheduleDy, (String)"attfilevid") == WTCDynamicObjectUtils.getBaseDataId((DynamicObject)file, (String)"id") && !HRStringUtils.isEmpty((String)attendStatus) && HRStringUtils.equals((String)attendStatus, (String)file.getString("atttag.attendstatus"))) continue;
                                        newScheduleDy.set("attendstatus", (Object)file.getString("atttag.attendstatus"));
                                        newScheduleDy.set("attfilevid", (Object)WTCDynamicObjectUtils.getDy((String)"wtp_attfilebase", (Long)file.getLong("id")));
                                        if (i == 0 && file.getDate("bsed").getTime() > file.getDate("startdate").getTime() && newScheduleDy.getDate("bsed") != null && file.getDate("bsed").compareTo(newScheduleDy.getDate("bsed")) > 0) {
                                            newScheduleDy.set("bsed", (Object)file.getDate("bsed"));
                                        }
                                        if (i == size - 1 && file.getDate("bsled").getTime() < WTCHisServiceHelper.getMaxEndDate().getTime() && newScheduleDy.getDate("bsled") != null && file.getDate("bsled").compareTo(newScheduleDy.getDate("bsled")) < 0) {
                                            newScheduleDy.set("bsled", (Object)file.getDate("bsled"));
                                        }
                                        tobeUpdateBaseScheduleSet.add(newScheduleDy);
                                        continue;
                                    }
                                    this.accessPlanScheduleBorder(beginCut, hadBeenCutResultScheduleIdSet, (List<DynamicObject>)fileList, currentScheduleDy, j, tobeUpdatePlanScheduleSet, tobeUpdatePlanScheduleBoSet, file, resultScheduleDyList, hrBaseServiceHelper);
                                }
                            }
                        });
                    }
                });
                if (WTCCollections.isNotEmpty((Collection)tobeUpdateBaseScheduleSet)) {
                    this.saveScheduleHis(tobeUpdateBaseScheduleSet, true, null, mainBoId, nameMap, ifCheck);
                }
                if (WTCCollections.isNotEmpty((Collection)tobeUpdatePlanScheduleSet)) {
                    this.saveScheduleHis(tobeUpdatePlanScheduleSet, false, null, mainBoId, nameMap, ifCheck);
                }
                if (WTCCollections.isNotEmpty((Collection)tobeUpdatePlanScheduleBoSet)) {
                    this.saveScheduleHis(tobeUpdatePlanScheduleBoSet, false, "true", mainBoId, nameMap, ifCheck);
                }
            }
        }
    }

    private boolean judgeIfIntersect(DynamicObject currentScheduleDy, DynamicObject file) {
        return currentScheduleDy.getDate("startdate").getTime() <= file.getDate("bsled").getTime() && currentScheduleDy.getDate("enddate").getTime() >= file.getDate("bsed").getTime();
    }

    private void cutSchedule(List<DynamicObject> fileList, HRBaseServiceHelper scheduleServiceHelper, DynamicObject scheduleDy, DynamicObject file, Date startDate, Date endDate, Set<Long> hadBeenCutResultScheduleIdSet, List<DynamicObject> tobeUpdatePlanScheduleBoSet, List<DynamicObject> tobeUpdatePlanScheduleSet) {
        if (!hadBeenCutResultScheduleIdSet.contains(scheduleDy.getLong("id"))) {
            DynamicObject newScheduleDy = scheduleServiceHelper.generateEmptyDynamicObject();
            HRDynamicObjectUtils.copy((DynamicObject)scheduleDy, (DynamicObject)newScheduleDy, (Set)WTCHisServiceHelper.getHisIgnoreKeysSet());
            newScheduleDy.set("startdate", (Object)startDate);
            newScheduleDy.set("enddate", (Object)endDate);
            if (endDate.getTime() <= file.getDate("bsled").getTime()) {
                DynamicObject fileVidDy = this.getFileVidDy(startDate, endDate, fileList);
                this.setVidAndAttendStatus(newScheduleDy, fileVidDy);
            }
            tobeUpdatePlanScheduleSet.add(newScheduleDy);
            hadBeenCutResultScheduleIdSet.add(scheduleDy.getLong("id"));
        } else {
            tobeUpdatePlanScheduleBoSet.add(this.addPlanScheduleBo(fileList, scheduleServiceHelper, scheduleDy, startDate, endDate));
        }
    }

    private void setVidAndAttendStatus(DynamicObject newScheduleDy, DynamicObject fileVidDy) {
        if (fileVidDy != null) {
            HRBaseServiceHelper attFileServiceHelper = new HRBaseServiceHelper("wtp_attfilebase");
            DynamicObject attFile = attFileServiceHelper.generateEmptyDynamicObject();
            HRDynamicObjectUtils.copy((DynamicObject)fileVidDy, (DynamicObject)attFile);
            attFile.set("id", fileVidDy.get("id"));
            newScheduleDy.set("attfilevid", (Object)attFile);
            newScheduleDy.set("attendstatus", (Object)fileVidDy.getString("atttag.attendstatus"));
        }
    }

    private void updateScheduleAttFileVId(List<DynamicObject> fileList, HRBaseServiceHelper scheduleServiceHelper, DynamicObject scheduleDy, List<DynamicObject> tobeUpdatePlanScheduleSet) {
        DynamicObject newScheduleDy = scheduleServiceHelper.generateEmptyDynamicObject();
        HRDynamicObjectUtils.copy((DynamicObject)scheduleDy, (DynamicObject)newScheduleDy, (Set)WTCHisServiceHelper.getHisIgnoreKeysSet());
        DynamicObject fileVidDy = this.getFileVidDy(scheduleDy.getDate("startdate"), scheduleDy.getDate("enddate"), fileList);
        if (fileVidDy != null && WTCDynamicObjectUtils.getBaseDataId((DynamicObject)newScheduleDy, (String)"attfilevid") != fileVidDy.getLong("id")) {
            this.setVidAndAttendStatus(newScheduleDy, fileVidDy);
            tobeUpdatePlanScheduleSet.add(newScheduleDy);
        }
    }

    private DynamicObject getFileVidDy(Date startDate, Date endDate, List<DynamicObject> fileList) {
        for (DynamicObject dy : fileList) {
            if (dy.getDate("bsed").getTime() > startDate.getTime() || dy.getDate("bsled").getTime() < endDate.getTime()) continue;
            return dy;
        }
        return null;
    }

    private DynamicObject addPlanScheduleBo(List<DynamicObject> fileList, HRBaseServiceHelper scheduleServiceHelper, DynamicObject copyFrom, Date startDate, Date endDate) {
        DynamicObject newScheduleBoDy = scheduleServiceHelper.generateEmptyDynamicObject();
        HRDynamicObjectUtils.copy((DynamicObject)copyFrom, (DynamicObject)newScheduleBoDy, (Set)WTCHisServiceHelper.getHisIgnoreKeysSet());
        DynamicObject fileVidDy = this.getFileVidDy(startDate, endDate, fileList);
        this.setVidAndAttendStatus(newScheduleBoDy, fileVidDy);
        newScheduleBoDy.set("startdate", (Object)startDate);
        newScheduleBoDy.set("enddate", (Object)endDate);
        newScheduleBoDy.set("boid", null);
        newScheduleBoDy.set("id", null);
        newScheduleBoDy.set("sourcevid", null);
        return newScheduleBoDy;
    }

    private void accessPlanScheduleBorder(Map<Long, Boolean> beginCut, Set<Long> hadBeenCutResultScheduleIdSet, List<DynamicObject> fileList, DynamicObject currentScheduleDy, int j, List<DynamicObject> tobeUpdatePlanScheduleSet, List<DynamicObject> tobeUpdatePlanScheduleBoSet, DynamicObject file, List<DynamicObject> resultScheduleDyList, HRBaseServiceHelper scheduleServiceHelper) {
        if (WTCCollections.isNotEmpty(resultScheduleDyList)) {
            Date scheduleStartDate = currentScheduleDy.getDate("startdate");
            Date scheduleEndDate = currentScheduleDy.getDate("enddate");
            Date fileBsed = file.getDate("bsed");
            Date fileBsled = file.getDate("bsled");
            Date preStartDate = scheduleStartDate;
            if (this.judgeIfIntersect(currentScheduleDy, file)) {
                Date startDate = WTCDateUtils.getMaxDate((Date)scheduleStartDate, (Date)fileBsed);
                Date endDate = WTCDateUtils.getMinDate((Date)scheduleEndDate, (Date)fileBsled);
                if (scheduleStartDate.getTime() < fileBsed.getTime() || scheduleEndDate.getTime() > fileBsled.getTime()) {
                    if (scheduleStartDate.getTime() < fileBsed.getTime()) {
                        if (beginCut.get(currentScheduleDy.getLong("id")) != null) {
                            preStartDate = fileList.get(j - 1).getDate("bsed");
                        }
                        this.cutSchedule(fileList, scheduleServiceHelper, currentScheduleDy, file, preStartDate, WTCDateUtils.addDays((Date)fileBsed, (int)-1), hadBeenCutResultScheduleIdSet, tobeUpdatePlanScheduleBoSet, tobeUpdatePlanScheduleSet);
                        if (scheduleEndDate.getTime() <= fileBsled.getTime()) {
                            tobeUpdatePlanScheduleBoSet.add(this.addPlanScheduleBo(fileList, scheduleServiceHelper, currentScheduleDy, startDate, endDate));
                        }
                        beginCut.put(currentScheduleDy.getLong("id"), true);
                    }
                    if (j == fileList.size() - 1 && scheduleEndDate.getTime() > fileBsled.getTime()) {
                        this.cutSchedule(fileList, scheduleServiceHelper, currentScheduleDy, file, WTCDateUtils.addDays((Date)fileBsed, (int)1), scheduleEndDate, hadBeenCutResultScheduleIdSet, tobeUpdatePlanScheduleBoSet, tobeUpdatePlanScheduleSet);
                    }
                } else {
                    this.updateScheduleAttFileVId(fileList, scheduleServiceHelper, currentScheduleDy, tobeUpdatePlanScheduleSet);
                }
            }
        }
    }

    private void saveScheduleHis(List<DynamicObject> tobeUpdateScheduleList, boolean ifTimeHis, String isAddNew, Long mainBoId, Map<Long, String> nameMap, boolean ifCheck) {
        if (WTCCollections.isNotEmpty(tobeUpdateScheduleList)) {
            Map<String, List<DynamicObject>> scheduleMap = tobeUpdateScheduleList.stream().collect(Collectors.groupingBy(dy -> dy.getDataEntityType().getName()));
            scheduleMap.forEach((pageId, scheduleList) -> {
                if (ifTimeHis) {
                    AttFileScheduleServiceImpl.getInstance().addAttFileBaseSchedule(scheduleList.toArray(new DynamicObject[0]), mainBoId);
                } else {
                    AttFileScheduleServiceImpl.getInstance().addAttFileRuleSchedule(scheduleList.toArray(new DynamicObject[0]), mainBoId, isAddNew, null);
                }
            });
            if (ifCheck) {
                List attPeriodList;
                String errMsg = "";
                List workSchList = tobeUpdateScheduleList.stream().filter(dy -> dy.getDataEntityType().getName().startsWith(AttFileScheduleEnum.WS.getPageId())).collect(Collectors.toList());
                if (WTCCollections.isNotEmpty(workSchList)) {
                    List attFileBoIdList = tobeUpdateScheduleList.stream().map(dy -> WTCDynamicObjectUtils.getBaseDataId((DynamicObject)dy, (String)"attfileid")).collect(Collectors.toList());
                    HashMap workSchCheckReqsMap = Maps.newHashMapWithExpectedSize((int)attFileBoIdList.size());
                    for (DynamicObject workSch : workSchList) {
                        long wsId = WTCDynamicObjectUtils.getBaseDataId((DynamicObject)workSch, (String)AttFileScheduleEnum.WS.getKey());
                        AttFileWorkSchCheckReq attFileWorkSchCheckReq = new AttFileWorkSchCheckReq();
                        attFileWorkSchCheckReq.setScheduleId(wsId);
                        attFileWorkSchCheckReq.setStartDate(workSch.getDate("bsed"));
                        Date bsled = workSch.getDate("bsled");
                        attFileWorkSchCheckReq.setEndDate(bsled);
                        if (bsled == null || "2999-12-31".equals(WTCDateUtils.date2Str((Date)bsled, (String)"yyyy-MM-dd"))) {
                            attFileWorkSchCheckReq.setLatest(true);
                        }
                        List attFileWorkSchCheckReqs = workSchCheckReqsMap.computeIfAbsent(WTCDynamicObjectUtils.getBaseDataId((DynamicObject)workSch, (String)"attfileid"), key -> Lists.newArrayList());
                        attFileWorkSchCheckReqs.add(attFileWorkSchCheckReq);
                    }
                    if (WTCCollections.isNotEmpty((Map)workSchCheckReqsMap)) {
                        Map validateResMap = AttFileWorkScheduleService.getInstance().checkAttFileWorkSchedule((Map)workSchCheckReqsMap);
                        errMsg = AttFileScheduleBusiness.getValidateResMapStr(validateResMap, nameMap);
                    }
                }
                if (WTCCollections.isNotEmpty(attPeriodList = tobeUpdateScheduleList.stream().filter(dy -> dy.getDataEntityType().getName().startsWith(AttFileScheduleEnum.PERIOD.getPageId())).collect(Collectors.toList()))) {
                    Set<Long> fileBoIds = attPeriodList.stream().map(dy -> WTCDynamicObjectUtils.getBaseDataId((DynamicObject)dy, (String)"attfileid")).collect(Collectors.toSet());
                    String periodMsg = AttFileScheduleCheckHelper.getInstance().attPeriodSerialCheck(fileBoIds);
                    if (HRStringUtils.isNotEmpty((String)periodMsg)) {
                        errMsg = HRStringUtils.isNotEmpty((String)errMsg) ? String.join((CharSequence)"\n", errMsg, periodMsg) : periodMsg;
                    }
                }
                if (HRStringUtils.isNotEmpty((String)errMsg)) {
                    String key2 = "schedule_Msg" + mainBoId;
                    String cacheKey = WTCCacheUtils.getKey((String)"wtp", (String)key2);
                    DistributeSessionlessCache redis = WTCCacheUtils.getCache();
                    redis.put(cacheKey, (Object)errMsg, 120, TimeUnit.SECONDS);
                }
            }
        }
    }

    private List<DynamicObject> getScheduleDyByDate(List<DynamicObject> scheduleDyList, Date startDate, Date endDate, AttFileScheduleEnum scheduleEnum) {
        ArrayList resultScheduleDyList = Lists.newArrayListWithExpectedSize((int)16);
        if (WTCCollections.isNotEmpty(scheduleDyList)) {
            for (DynamicObject scheduleDy : scheduleDyList) {
                if (scheduleEnum.isTimeHis()) {
                    if (endDate.getTime() < scheduleDy.getDate("bsed").getTime() || startDate.getTime() > scheduleDy.getDate("bsled").getTime()) continue;
                    resultScheduleDyList.add(scheduleDy);
                    continue;
                }
                if (endDate.getTime() < scheduleDy.getDate("startdate").getTime() || startDate.getTime() > scheduleDy.getDate("enddate").getTime()) continue;
                resultScheduleDyList.add(scheduleDy);
            }
        }
        return resultScheduleDyList;
    }

    private Map<Long, List<DynamicObject>> queryAttFileScheduleByAttFileIdAndDay(Set<Long> attFileBoIdSet, AttFileScheduleEnum scheduleEnum) {
        AttFileScheduleQueryParam queryParam = new AttFileScheduleQueryParam();
        queryParam.setFileBoIdSet(attFileBoIdSet);
        queryParam.setLoad(Boolean.TRUE);
        return kd.wtc.wtbs.business.web.file.schedule.AttFileScheduleServiceImpl.getInstance().queryAttFileSchedule(scheduleEnum, queryParam);
    }

    @Override
    public void openFileHeader(IFormView iFormView, Long empPosOrgRelId, Long fileId, String targetKey) {
        FormShowParameter formShowParameter = DataBaseEditService.getFormShowParameter((String)"wtp_attfilesummary", (ShowType)ShowType.InContainer);
        formShowParameter.getOpenStyle().setShowType(ShowType.InContainer);
        formShowParameter.getOpenStyle().setTargetKey(targetKey);
        HashMap map = Maps.newHashMapWithExpectedSize((int)2);
        map.put("empposorgrel", empPosOrgRelId);
        map.put("attfileid", fileId);
        formShowParameter.setCustomParam("customvariables", (Object)map);
        formShowParameter.setStatus(OperationStatus.VIEW);
        formShowParameter.setHasRight(true);
        iFormView.showForm(formShowParameter);
    }

    @Override
    public void openFileSchedule(IFormView iFormView, Map<String, Object> customParams, String targetKey) {
        FormShowParameter formShowParameter = DataBaseEditService.getFormShowParameter((String)"wtp_baseplanschedule", (ShowType)ShowType.InContainer);
        formShowParameter.getOpenStyle().setTargetKey(targetKey);
        formShowParameter.setCustomParams(customParams);
        formShowParameter.setCustomParam("boid", customParams.get("boid"));
        formShowParameter.setCustomParam("filetype", iFormView.getFormShowParameter().getCustomParam("filetype"));
        iFormView.showForm(formShowParameter);
    }

    @Override
    public void updateFileName(List<DynamicObject> fileEntities) {
        HRBaseServiceHelper hrBaseServiceHelper = new HRBaseServiceHelper("wtp_attfilebase");
        DynamicObject[] fileArr = new DynamicObject[fileEntities.size()];
        for (int index = 0; index < fileEntities.size(); ++index) {
            fileArr[index] = fileEntities.get(index);
        }
        hrBaseServiceHelper.update(fileArr);
    }

    @Override
    public void genPermOrgResultWithSubCache(ListShowParameter listParameter, boolean isCheckIgnoreConfig, String permProKey, PageCache cache) {
        boolean isIgnoreDataRule;
        boolean isF7 = listParameter.isLookUp();
        if (!isF7) {
            return;
        }
        String permEntityId = (String)listParameter.getCustomParam("customHREntityNumber");
        if (HRStringUtils.isEmpty((String)permEntityId)) {
            permEntityId = listParameter.getBillFormId();
        }
        String permItemId = "47150e89000000ac";
        permEntityId = QueryEntityServiceHelper.getDataEntityNumber((String)permEntityId);
        String appId = FileGroupEnum.of((String)permEntityId).getAppId();
        if (isCheckIgnoreConfig && (isIgnoreDataRule = ((Boolean)HRMServiceHelper.invokeHRMPService((String)"hrcs", (String)"IHRCSBizDataPermissionService", (String)"isIgnoreEntityDataRule", (Object[])new Object[]{appId, permEntityId})).booleanValue())) {
            AuthorizedOrgResultWithSub permResult = AuthorizedOrgResultWithSub.allOrg();
            cache.put("perm_org_result", SerializationUtils.toJsonString((Object)permResult));
            return;
        }
        long userId = RequestContext.get().getCurrUserId();
        AuthorizedOrgResultWithSub permResult = (AuthorizedOrgResultWithSub)HRMServiceHelper.invokeHRMPService((String)"hrcs", (String)"IHRCSBizDataPermissionService", (String)"getAuthorizedAdminOrgsWithSub", (Object[])new Object[]{userId, appId, permEntityId, permItemId, permProKey});
        cache.put("perm_org_result_withsub", SerializationUtils.toJsonString((Object)permResult));
    }

    public void saveAttPersonOtherInfoFromFileDy(DynamicObject[] dys) {
        if (dys == null || dys.length == 0 || !dys[0].getDataEntityType().getProperties().containsKey((Object)"qtfirsteffectdate")) {
            return;
        }
        Map<Long, Date> fileStartDateMap = Arrays.stream(dys).collect(Collectors.toMap(dy -> WTCDynamicObjectUtils.getBaseDataId((DynamicObject)dy, (String)"attperson"), dy -> dy.getDate("startdate"), (a, b) -> a));
        HashMap otherInfoSaveMap = Maps.newHashMapWithExpectedSize((int)dys.length);
        for (DynamicObject dy2 : dys) {
            Date qtFirstEffectDate = dy2.getDate("qtfirsteffectdate");
            if (qtFirstEffectDate == null) continue;
            HashMap fieldMap = Maps.newHashMapWithExpectedSize((int)16);
            fieldMap.put("qtfirsteffectdate", qtFirstEffectDate);
            long personId = WTCDynamicObjectUtils.getBaseDataId((DynamicObject)dy2, (String)"person");
            otherInfoSaveMap.put(personId, fieldMap);
        }
        if (otherInfoSaveMap.size() > 0) {
            HashMap paramMap = Maps.newHashMapWithExpectedSize((int)16);
            paramMap.put("notCheck", JSON.toJSONString(fileStartDateMap));
            AttendPersonUpdateServiceImpl.getInstance().updateOtherInfo((Map)otherInfoSaveMap, (Map)paramMap);
        }
    }

    @Override
    public void adjust(Long orgId, List<Long> boIds) {
        AttFileScheduleEnum[] fileScheduleEnums;
        LOG.info("AttFileServiceImpl#adjust# start orgId:{},boIds:{}", (Object)orgId, boIds);
        List<DynamicObject> needCheckBos = AttFileCheckService.getInstance().getNeedCheckBos(boIds, Boolean.FALSE, Boolean.TRUE);
        if (CollectionUtils.isEmpty(needCheckBos)) {
            return;
        }
        needCheckBos.forEach(file -> file.set("org", (Object)orgId));
        AttFileServiceImpl.getInstance().attFileRevise(needCheckBos.toArray(new DynamicObject[0]));
        for (AttFileScheduleEnum schedule : fileScheduleEnums = AttFileScheduleEnum.values()) {
            AttFileScheduleQueryParam scheduleQueryParam = new AttFileScheduleQueryParam();
            scheduleQueryParam.setFileBoIdSet(new HashSet<Long>(boIds));
            scheduleQueryParam.setLoad(Boolean.TRUE);
            List attFileScheduleDys = kd.wtc.wtbs.business.web.file.schedule.AttFileScheduleServiceImpl.getInstance().queryAttFileScheduleByList(schedule, scheduleQueryParam);
            if (CollectionUtils.isEmpty((Collection)attFileScheduleDys)) continue;
            attFileScheduleDys.forEach(file -> file.set("org", (Object)orgId));
            AttFileServiceImpl.getInstance().attFileRevise(attFileScheduleDys.toArray(new DynamicObject[0]), schedule);
        }
        LOG.info("AttFileServiceImpl#adjust# end.");
    }

    @Override
    public List<DynamicObject> queryTpBillData(BusitripBillQueryParam param) {
        if (param == null || CollectionUtils.isEmpty((Collection)param.getAttFileBoIdSet())) {
            return new ArrayList<DynamicObject>(10);
        }
        if (null == param.getInvalid()) {
            param.setInvalid(Boolean.FALSE);
        }
        if (CollectionUtils.isEmpty((Collection)param.getBillStatusSet())) {
            param.setBillStatusSet(this.fillBillStatus());
        }
        try {
            List result = (List)WTCServiceHelper.invokeBizService((String)"wtc", (String)"wtam", (String)"ITpBillService", (String)"defaultQuery", (Object[])new Object[]{param});
            param.setInvalid(Boolean.TRUE);
            param.setBillStatusSet(this.fillBillStatusForInvalid());
            List resultForInvalid = (List)WTCServiceHelper.invokeBizService((String)"wtc", (String)"wtam", (String)"ITpBillService", (String)"defaultQuery", (Object[])new Object[]{param});
            result = result == null ? new ArrayList(10) : result;
            result.addAll(resultForInvalid);
            return result;
        }
        catch (Exception ex) {
            String kdString = ResManager.loadKDString((String)"\u51fa\u5dee\u5355", (String)"AttFileServiceImpl_3", (String)"wtc-wtp-business", (Object[])new Object[0]);
            String err = ResManager.loadKDString((String)"\u67e5\u8be2%s\u5931\u8d25\u3002", (String)"AttFileServiceImpl_2", (String)"wtc-wtp-business", (Object[])new Object[]{kdString});
            LOG.error(err, (Throwable)ex);
            throw new KDBizException(err);
        }
    }

    @Override
    public List<DynamicObject> queryVaBillData(VaBillQueryParam param) {
        if (param == null || CollectionUtils.isEmpty((Collection)param.getAttFileBoIdSet())) {
            return new ArrayList<DynamicObject>(10);
        }
        if (null == param.getInvalid()) {
            param.setInvalid(Boolean.FALSE);
        }
        if (CollectionUtils.isEmpty((Collection)param.getBillStatusSet())) {
            param.setBillStatusSet(this.fillBillStatus());
        }
        try {
            List result = (List)WTCServiceHelper.invokeBizService((String)"wtc", (String)"wtabm", (String)"IVaBillService", (String)"defaultQuery", (Object[])new Object[]{param});
            param.setInvalid(Boolean.TRUE);
            param.setBillStatusSet(this.fillBillStatusForInvalid());
            List resultForInvalid = (List)WTCServiceHelper.invokeBizService((String)"wtc", (String)"wtabm", (String)"IVaBillService", (String)"defaultQuery", (Object[])new Object[]{param});
            result = result == null ? new ArrayList(10) : result;
            result.addAll(resultForInvalid);
            return result;
        }
        catch (Exception ex) {
            String kdString = ResManager.loadKDString((String)"\u4f11\u5047\u5355", (String)"AttFileServiceImpl_5", (String)"wtc-wtp-business", (Object[])new Object[0]);
            String err = ResManager.loadKDString((String)"\u67e5\u8be2%s\u5931\u8d25\u3002", (String)"AttFileServiceImpl_2", (String)"wtc-wtp-business", (Object[])new Object[]{kdString});
            LOG.error(err, (Throwable)ex);
            throw new KDBizException(err);
        }
    }

    @Override
    public List<DynamicObject> queryOtBillData(OtBillQueryParam param) {
        if (param == null || CollectionUtils.isEmpty((Collection)param.getAttFileBoIdSet())) {
            return new ArrayList<DynamicObject>(10);
        }
        if (null == param.getInvalid()) {
            param.setInvalid(Boolean.FALSE);
        }
        if (CollectionUtils.isEmpty((Collection)param.getBillStatusSet())) {
            param.setBillStatusSet(this.fillBillStatus());
        }
        try {
            List result = (List)WTCServiceHelper.invokeBizService((String)"wtc", (String)"wtom", (String)"IOtBillService", (String)"defaultQuery", (Object[])new Object[]{param});
            param.setInvalid(Boolean.TRUE);
            param.setBillStatusSet(this.fillBillStatusForInvalid());
            List resultForInvalid = (List)WTCServiceHelper.invokeBizService((String)"wtc", (String)"wtom", (String)"IOtBillService", (String)"defaultQuery", (Object[])new Object[]{param});
            result = result == null ? new ArrayList(10) : result;
            result.addAll(resultForInvalid);
            return result;
        }
        catch (Exception ex) {
            String kdString = ResManager.loadKDString((String)"\u52a0\u73ed\u5355", (String)"AttFileServiceImpl_4", (String)"wtc-wtp-business", (Object[])new Object[0]);
            String err = ResManager.loadKDString((String)"\u67e5\u8be2%s\u5931\u8d25\u3002", (String)"AttFileServiceImpl_2", (String)"wtc-wtp-business", (Object[])new Object[]{kdString});
            LOG.error(err, (Throwable)ex);
            throw new KDBizException(err);
        }
    }

    @Override
    public List<DynamicObject> querySignCardData(SupSignBillQueryParam param) {
        if (param == null || CollectionUtils.isEmpty((Collection)param.getAttFileBoIdSet())) {
            return new ArrayList<DynamicObject>(10);
        }
        if (null == param.getInvalid()) {
            param.setInvalid(Boolean.FALSE);
        }
        if (CollectionUtils.isEmpty((Collection)param.getBillStatusSet())) {
            param.setBillStatusSet(this.fillBillStatus());
        }
        try {
            List result = (List)WTCServiceHelper.invokeBizService((String)"wtc", (String)"wtpm", (String)"ISignCardBillService", (String)"defaultQuery", (Object[])new Object[]{param});
            param.setInvalid(Boolean.TRUE);
            param.setBillStatusSet(this.fillBillStatusForInvalid());
            List resultForInvalid = (List)WTCServiceHelper.invokeBizService((String)"wtc", (String)"wtpm", (String)"ISignCardBillService", (String)"defaultQuery", (Object[])new Object[]{param});
            result = result == null ? new ArrayList(10) : result;
            result.addAll(resultForInvalid);
            return result;
        }
        catch (Exception ex) {
            String kdString = ResManager.loadKDString((String)"\u8865\u7b7e\u5355", (String)"AttFileServiceImpl_6", (String)"wtc-wtp-business", (Object[])new Object[0]);
            String err = ResManager.loadKDString((String)"\u67e5\u8be2%s\u5931\u8d25\u3002", (String)"AttFileServiceImpl_2", (String)"wtc-wtp-business", (Object[])new Object[]{kdString});
            LOG.error(err, (Throwable)ex);
            throw new KDBizException(err);
        }
    }

    @Override
    public List<DynamicObject> querySignCardsData(Set<Long> attFileBoIds, String selectProperties) {
        if (CollectionUtils.isEmpty(attFileBoIds)) {
            return new ArrayList<DynamicObject>();
        }
        try {
            List result = (List)WTCServiceHelper.invokeBizService((String)"wtc", (String)"wtpd", (String)"ISignCardService", (String)"querySignCards", (Object[])new Object[]{attFileBoIds, selectProperties});
            return result;
        }
        catch (Exception ex) {
            String kdString = ResManager.loadKDString((String)"\u539f\u59cb\u5361", (String)"AttFileServiceImpl_7", (String)"wtc-wtp-business", (Object[])new Object[0]);
            String err = ResManager.loadKDString((String)"\u67e5\u8be2%s\u5931\u8d25\u3002", (String)"AttFileServiceImpl_2", (String)"wtc-wtp-business", (Object[])new Object[]{kdString});
            LOG.error(err, (Throwable)ex);
            throw new KDBizException(err);
        }
    }

    @Override
    public List<DynamicObject> obtainSettleInfo(Set<Long> attFileBoIds, String selectProperties) {
        if (CollectionUtils.isEmpty(attFileBoIds)) {
            return Collections.emptyList();
        }
        try {
            List result = (List)WTCServiceHelper.invokeBizService((String)"wtc", (String)"wtte", (String)"ISettleInfoService", (String)"obtainSettleInfo", (Object[])new Object[]{attFileBoIds, selectProperties});
            return result;
        }
        catch (Exception ex) {
            String kdString = ResManager.loadKDString((String)"\u7ed3\u7b97\u4fe1\u606f", (String)"AttFileServiceImpl_8", (String)"wtc-wtp-business", (Object[])new Object[0]);
            String err = ResManager.loadKDString((String)"\u67e5\u8be2%s\u5931\u8d25\u3002", (String)"AttFileServiceImpl_2", (String)"wtc-wtp-business", (Object[])new Object[]{kdString});
            LOG.error(err, (Throwable)ex);
            throw new KDBizException(err);
        }
    }

    @Override
    public void updateSettleInfo(Set<Long> attFileBoIds, Long orgId) {
        if (CollectionUtils.isEmpty(attFileBoIds) || orgId == null) {
            return;
        }
        try {
            WTCServiceHelper.invokeBizService((String)"wtc", (String)"wtte", (String)"ISettleInfoService", (String)"updateSettleInfo", (Object[])new Object[]{attFileBoIds, orgId});
        }
        catch (Exception ex) {
            String err = ResManager.loadKDString((String)"\u66f4\u65b0\u7ed3\u7b97\u4fe1\u606f\u8003\u52e4\u7ba1\u7406\u7ec4\u7ec7\u5931\u8d25\u3002", (String)"AttFileServiceImpl_9", (String)"wtc-wtp-business", (Object[])new Object[0]);
            LOG.error(err, (Throwable)ex);
            throw new KDBizException(err);
        }
    }

    @Override
    public Map<String, Object> rollBackFileToNormalAtt(Set<Long> boIdSet) {
        HashMap result = Maps.newHashMapWithExpectedSize((int)16);
        HashSet sourceEntitySet = Sets.newHashSetWithExpectedSize((int)16);
        sourceEntitySet.add("wtp_attfilebase");
        sourceEntitySet.add("wtp_attfilemodify");
        sourceEntitySet.add("wtp_attfilemodifybase");
        StopWatch stopWatch = StopWatch.createStarted();
        HRBaseServiceHelper businessEventHelper = new HRBaseServiceHelper("wtbs_busieventreltpl");
        QFilter businessEventQFilter = new QFilter("status", "=", (Object)"1");
        businessEventQFilter.and(new QFilter("sourceentity", "in", (Object)sourceEntitySet));
        businessEventQFilter.and(new QFilter("boid", "in", boIdSet));
        DynamicObject[] query = businessEventHelper.query("event,boid", businessEventQFilter.toArray());
        stopWatch.stop();
        LOG.info("rollBackFileToNormalAtt  get file eventId consuming {}", (Object)stopWatch.getTime());
        Map<Long, Set<Long>> boIdToEventMap = Arrays.stream(query).collect(Collectors.groupingBy(d -> d.getLong("boid"), Collectors.mapping(d -> d.getLong("event"), Collectors.toSet())));
        Set<Long> eventIdSet = boIdToEventMap.values().stream().flatMap(Collection::stream).collect(Collectors.toSet());
        for (AttFileScheduleEnum value : AttFileScheduleEnum.values()) {
            sourceEntitySet.add(value.getPageId());
        }
        try {
            this.rollBackData(boIdSet, sourceEntitySet, boIdToEventMap, eventIdSet);
        }
        catch (Exception exception) {
            LOG.error("rollBackFileToNormalAtt err", (Throwable)exception);
            try {
                for (AttFileScheduleEnum value : AttFileScheduleEnum.values()) {
                    sourceEntitySet.remove(value.getPageId());
                }
                this.rollBackData(boIdSet, sourceEntitySet, boIdToEventMap, eventIdSet);
            }
            catch (Exception exceptionStill) {
                LOG.error("rollBackFileToNormalAtt only attFile err", (Throwable)exception);
                throw new KDBizException(AttFileKDString.fileRollbackErrMsg());
            }
            AttFileQueryParam attFileQueryParam2 = new AttFileQueryParam(false);
            attFileQueryParam2.setSetBoIds(boIdSet);
            attFileQueryParam2.setBeCurrent(Boolean.TRUE);
            attFileQueryParam2.setProperties("number");
            List lastBoFileList = AttFileQueryServiceImpl.getInstance().queryAttFiles(attFileQueryParam2);
            Set fileNumberSet = lastBoFileList.stream().map(d -> d.getString("number")).collect(Collectors.toSet());
            StringBuilder stringBuilder = new StringBuilder();
            for (String fileNum : fileNumberSet) {
                stringBuilder.append(fileNum);
            }
            result.put("rollbackFileOnly", stringBuilder.toString());
        }
        return result;
    }

    private void rollBackData(Set<Long> boIdSet, Set<String> sourceEntitySet, Map<Long, Set<Long>> boIdToEventMap, Set<Long> eventIdSet) {
        if (WTCCollections.isEmpty(boIdSet)) {
            LOG.info("rollBackData boIdSet is null");
            return;
        }
        HashSet rollBackBoIdSet = Sets.newHashSetWithExpectedSize((int)boIdSet.size());
        rollBackBoIdSet.addAll(boIdSet);
        AttFileScheduleQueryParam attFileScheduleQueryParam = new AttFileScheduleQueryParam();
        attFileScheduleQueryParam.setProperties("boid");
        attFileScheduleQueryParam.setFileBoIdSet(boIdSet);
        for (AttFileScheduleEnum value : AttFileScheduleEnum.values()) {
            Set schBoIdSet = kd.wtc.wtbs.business.web.file.schedule.AttFileScheduleServiceImpl.getInstance().queryAttFileScheduleByList(value, attFileScheduleQueryParam).stream().map(d -> d.getLong("boid")).collect(Collectors.toSet());
            if (!WTCCollections.isNotEmpty(schBoIdSet)) continue;
            rollBackBoIdSet.addAll(schBoIdSet);
        }
        StopWatch stopWatch = StopWatch.createStarted();
        Map eventListByBoId = WTCCommonHisService.getEventList(eventIdSet, (Set)rollBackBoIdSet, sourceEntitySet);
        stopWatch.stop();
        LOG.info("rollBackData  getEventList consuming {}", (Object)stopWatch.getTime());
        Iterator iterator = eventListByBoId.entrySet().iterator();
        HashSet successEventIdSet = Sets.newHashSetWithExpectedSize((int)eventIdSet.size());
        while (iterator.hasNext()) {
            Map.Entry next = iterator.next();
            List value = (List)next.getValue();
            Long key = (Long)next.getKey();
            if (successEventIdSet.contains(key)) continue;
            StopWatch stopWatch1 = StopWatch.createStarted();
            WTCCommonHisService.revertEvent((Long)key, (List)value, (String)"1O9FOLRY18YW");
            stopWatch1.stop();
            LOG.info("rollBackData  revertEvent consuming {}", (Object)stopWatch1.getTime());
            Set<Long> successRollbackFileBoId = this.getSuccessRollbackFileBoId(boIdSet);
            if (!WTCCollections.isNotEmpty(successRollbackFileBoId)) continue;
            for (Long successFileBoId : successRollbackFileBoId) {
                Set<Long> successSubEventIdSet = boIdToEventMap.get(successFileBoId);
                if (!WTCCollections.isNotEmpty(successSubEventIdSet)) continue;
                successEventIdSet.addAll(successSubEventIdSet);
            }
        }
    }

    private Set<Long> getSuccessRollbackFileBoId(Set<Long> boIdSet) {
        HashSet result = Sets.newHashSetWithExpectedSize((int)boIdSet.size());
        AttFileQueryParam attFileQueryParam = new AttFileQueryParam(false);
        attFileQueryParam.setSetBoIds(boIdSet);
        attFileQueryParam.setProperties("boid,bsed,atttag,atttag.attendstatus");
        Map<Long, List<DynamicObject>> groupByMap = AttFileQueryServiceImpl.getInstance().queryAttFiles(attFileQueryParam).stream().collect(Collectors.groupingBy(d -> d.getLong("boid")));
        for (List<DynamicObject> dynamicObjects : groupByMap.values()) {
            dynamicObjects.sort((o1, o2) -> o2.getDate("bsed").compareTo(o1.getDate("bsed")));
            WTCCollectionIndexUtil.getEleFromList(dynamicObjects, (int)0).ifPresent(ele -> {
                if (!AttStatusEnum.ATT_STOP.getCode().equals(ele.get("atttag.attendstatus"))) {
                    result.add(ele.getLong("boid"));
                }
            });
        }
        return result;
    }

    public Set<String> fillBillStatus() {
        HashSet<String> billStatusSet = new HashSet<String>(16);
        billStatusSet.add("A");
        billStatusSet.add("B");
        billStatusSet.add("C");
        billStatusSet.add("D");
        billStatusSet.add("G");
        return billStatusSet;
    }

    private Set<String> fillBillStatusForInvalid() {
        HashSet<String> billStatusSet = new HashSet<String>(16);
        billStatusSet.add("A");
        billStatusSet.add("B");
        billStatusSet.add("D");
        billStatusSet.add("G");
        return billStatusSet;
    }

    @Override
    public List<DynamicObject> querySwsBillData(BusitripBillQueryParam param) {
        if (param == null || CollectionUtils.isEmpty((Collection)param.getAttFileBoIdSet())) {
            return new ArrayList<DynamicObject>(10);
        }
        if (null == param.getInvalid()) {
            param.setInvalid(Boolean.FALSE);
        }
        if (CollectionUtils.isEmpty((Collection)param.getBillStatusSet())) {
            param.setBillStatusSet(this.fillBillStatus());
        }
        try {
            List result = (List)HRMServiceHelper.invokeBizService((String)"wtc", (String)"wts", (String)"ISwsBillService", (String)"queryBill", (Object[])new Object[]{param});
            return result;
        }
        catch (Exception ex) {
            String kdString = ResManager.loadKDString((String)"\u8c03\u73ed\u5355", (String)"AttFileServiceImpl_10", (String)"wtc-wtp-business", (Object[])new Object[0]);
            String err = ResManager.loadKDString((String)"\u67e5\u8be2%s\u5931\u8d25\u3002", (String)"AttFileServiceImpl_2", (String)"wtc-wtp-business", (Object[])new Object[]{kdString});
            LOG.warn("AttFileServiceImpl.querySwsBillData" + err, (Throwable)ex);
            throw new KDBizException(err);
        }
    }

    @Override
    public List<DynamicObject> querySignCardsData(Set<Long> attFileBoIds, Date startDate, Date endDate, boolean checkAuth, String selectProperties) {
        if (CollectionUtils.isEmpty(attFileBoIds)) {
            return new ArrayList<DynamicObject>();
        }
        try {
            List result = (List)WTCServiceHelper.invokeBizService((String)"wtc", (String)"wtpd", (String)"ISignCardService", (String)"getSignCards", (Object[])new Object[]{attFileBoIds, startDate, endDate, checkAuth, selectProperties});
            return result;
        }
        catch (Exception ex) {
            String kdString = ResManager.loadKDString((String)"\u539f\u59cb\u5361", (String)"AttFileServiceImpl_7", (String)"wtc-wtp-business", (Object[])new Object[0]);
            String err = ResManager.loadKDString((String)"\u67e5\u8be2%s\u5931\u8d25\u3002", (String)"AttFileServiceImpl_2", (String)"wtc-wtp-business", (Object[])new Object[]{kdString});
            LOG.warn("AttFileServiceImpl.querySignCardsData" + err, (Throwable)ex);
            throw new KDBizException(err);
        }
    }

    public List<DynamicObject> queryBillForRealTimeDutyDate(BillQueryParam param, AttFileStopAttBillQueryEnum queryEnum, boolean isCheckAuth) {
        BillPermQueryParam billPermQueryParam;
        if (param == null || CollectionUtils.isEmpty((Collection)param.getAttFileBoIdSet())) {
            return new ArrayList<DynamicObject>(10);
        }
        if (null == param.getInvalid()) {
            param.setInvalid(Boolean.FALSE);
        }
        if (CollectionUtils.isEmpty((Collection)param.getBillStatusSet())) {
            param.setBillStatusSet(this.stopAttFileEffectBillStatus());
        }
        if (isCheckAuth && param.getBillPermQueryParam() == null && (billPermQueryParam = (BillPermQueryParam)WTCServiceHelper.invokeBizService((String)"wtc", (String)queryEnum.getAppId(), (String)queryEnum.getServiceName(), (String)"getDefaultPerm", (Object[])new Object[0])) != null) {
            param.setBillPermQueryParam(billPermQueryParam);
        }
        try {
            List result = (List)WTCServiceHelper.invokeBizService((String)"wtc", (String)queryEnum.getAppId(), (String)queryEnum.getServiceName(), (String)queryEnum.getMethodName(), (Object[])new Object[]{param});
            param.setInvalid(Boolean.TRUE);
            param.setBillStatusSet(this.stopAttFileCancelBillStatus());
            List resultForInvalid = (List)WTCServiceHelper.invokeBizService((String)"wtc", (String)queryEnum.getAppId(), (String)queryEnum.getServiceName(), (String)queryEnum.getMethodName(), (Object[])new Object[]{param});
            result = result == null ? new ArrayList(10) : result;
            result.addAll(resultForInvalid);
            return result;
        }
        catch (Exception ex) {
            String err = ResManager.loadKDString((String)"\u67e5\u8be2%s\u5931\u8d25\u3002", (String)"AttFileServiceImpl_2", (String)"wtc-wtp-business", (Object[])new Object[]{queryEnum.getDescription().loadKDString()});
            LOG.warn("AttFileServiceImpl.queryBillForRealTimeDutyDate" + err, (Throwable)ex);
            throw new KDBizException(err);
        }
    }

    private Set<String> stopAttFileEffectBillStatus() {
        HashSet<String> billStatusSet = new HashSet<String>(16);
        billStatusSet.add("B");
        billStatusSet.add("C");
        billStatusSet.add("D");
        return billStatusSet;
    }

    private Set<String> stopAttFileCancelBillStatus() {
        HashSet<String> billStatusSet = new HashSet<String>(16);
        billStatusSet.add("B");
        billStatusSet.add("D");
        return billStatusSet;
    }

    @Override
    public List<DynamicObject> queryBatchVaBillData(VaBatchBillQueryParam queryParam) {
        VaBillQueryParam param = queryParam.getSingleQueryParam();
        if (param == null || CollectionUtils.isEmpty((Collection)param.getAttFileBoIdSet())) {
            return new ArrayList<DynamicObject>(10);
        }
        if (null == param.getInvalid()) {
            param.setInvalid(Boolean.FALSE);
        }
        if (CollectionUtils.isEmpty((Collection)param.getBillStatusSet())) {
            param.setBillStatusSet(this.fillBillStatus());
        }
        try {
            List result = (List)WTCServiceHelper.invokeBizService((String)"wtc", (String)"wtabm", (String)"IVaBatchBillService", (String)"queryRealTimeByDutyDate", (Object[])new Object[]{queryParam});
            param.setInvalid(Boolean.TRUE);
            param.setBillStatusSet(this.fillBillStatusForInvalid());
            List resultForInvalid = (List)WTCServiceHelper.invokeBizService((String)"wtc", (String)"wtabm", (String)"IVaBatchBillService", (String)"queryRealTimeByDutyDate", (Object[])new Object[]{queryParam});
            result = result == null ? new ArrayList(10) : result;
            result.addAll(resultForInvalid);
            return result;
        }
        catch (Exception ex) {
            String kdString = ResManager.loadKDString((String)"\u6279\u91cf\u4f11\u5047\u5355", (String)"AttFileServiceImpl_11", (String)"wtc-wtp-business", (Object[])new Object[0]);
            String err = ResManager.loadKDString((String)"\u67e5\u8be2%s\u5931\u8d25\u3002", (String)"AttFileServiceImpl_2", (String)"wtc-wtp-business", (Object[])new Object[]{kdString});
            LOG.error(err, (Throwable)ex);
            throw new KDBizException(err);
        }
    }

    public List<DynamicObject> queryBatchVaBillForRealTimeDutyDate(VaBatchBillQueryParam queryParam, AttFileStopAttBillQueryEnum queryEnum, boolean isCheckAuth) {
        BillPermQueryParam billPermQueryParam;
        VaBillQueryParam param = queryParam.getSingleQueryParam();
        if (param == null || CollectionUtils.isEmpty((Collection)param.getAttFileBoIdSet())) {
            return new ArrayList<DynamicObject>(10);
        }
        if (null == param.getInvalid()) {
            param.setInvalid(Boolean.FALSE);
        }
        if (CollectionUtils.isEmpty((Collection)param.getBillStatusSet())) {
            param.setBillStatusSet(this.stopAttFileEffectBillStatus());
        }
        if (isCheckAuth && queryParam.getBillPermQueryParam() == null && (billPermQueryParam = (BillPermQueryParam)WTCServiceHelper.invokeBizService((String)"wtc", (String)queryEnum.getAppId(), (String)queryEnum.getServiceName(), (String)"getDefaultPerm", (Object[])new Object[0])) != null) {
            queryParam.setBillPermQueryParam(billPermQueryParam);
        }
        try {
            List result = (List)WTCServiceHelper.invokeBizService((String)"wtc", (String)queryEnum.getAppId(), (String)queryEnum.getServiceName(), (String)queryEnum.getMethodName(), (Object[])new Object[]{queryParam});
            param.setInvalid(Boolean.TRUE);
            param.setBillStatusSet(this.stopAttFileCancelBillStatus());
            List resultForInvalid = (List)WTCServiceHelper.invokeBizService((String)"wtc", (String)queryEnum.getAppId(), (String)queryEnum.getServiceName(), (String)queryEnum.getMethodName(), (Object[])new Object[]{queryParam});
            result = result == null ? new ArrayList(10) : result;
            result.addAll(resultForInvalid);
            return result;
        }
        catch (Exception ex) {
            String err = ResManager.loadKDString((String)"\u67e5\u8be2%s\u5931\u8d25\u3002", (String)"AttFileServiceImpl_2", (String)"wtc-wtp-business", (Object[])new Object[]{queryEnum.getDescription().loadKDString()});
            LOG.warn("AttFileServiceImpl.queryBatchVaBillForRealTimeDutyDate" + err, (Throwable)ex);
            throw new KDBizException(err);
        }
    }

    private static class SingletonInstance {
        private static final AttFileServiceImpl SINGLETON = new AttFileServiceImpl();

        private SingletonInstance() {
        }
    }
}

