/*
 * Decompiled with CFR 0.152.
 */
package kd.wtc.wtp.business.attfile;

import com.alibaba.fastjson.JSON;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import kd.bos.cache.DistributeSessionlessCache;
import kd.bos.dataentity.OperateOption;
import kd.bos.dlock.DLock;
import kd.bos.exception.KDBizException;
import kd.hr.hbp.common.util.HRStringUtils;
import kd.wtc.wtbs.common.helper.WTCAppContextHelper;
import kd.wtc.wtbs.common.util.WTCCacheUtils;
import kd.wtc.wtbs.common.util.WTCCollections;
import kd.wtc.wtbs.common.util.WTCStringUtils;
import kd.wtc.wtbs.common.util.third.collect.Maps;
import kd.wtc.wtp.common.enums.AttFileTaskCacheInfoEnum;
import kd.wtc.wtp.common.kdstring.AttFileKDString;

public class AttFileSyncService {
    private static final int CACHE_TIME = 1800;
    private static final long TRY_LOCK_TIME = 10000L;
    private static final String CACHE_KEY_REDIS = "AttFileTaskSynBoId_Cache";
    private static final String LOCK_KEY = "AttFileTaskSynLockKey";

    public static AttFileSyncService getInstance() {
        return (AttFileSyncService)WTCAppContextHelper.getBean(AttFileSyncService.class);
    }

    public Map<Long, String> checkFileBoIds(Set<Long> boIdSet) {
        if (WTCCollections.isEmpty(boIdSet)) {
            return Collections.emptyMap();
        }
        HashMap fileVidMap = Maps.newHashMapWithExpectedSize((int)boIdSet.size());
        String cacheKey = WTCCacheUtils.getKey((String)"wtp", (String)CACHE_KEY_REDIS);
        DistributeSessionlessCache redis = WTCCacheUtils.getCache();
        String fileBoIdStr = (String)redis.get(cacheKey);
        if (WTCStringUtils.isNotEmpty((String)fileBoIdStr)) {
            Map existCacheMap = (Map)JSON.parseObject((String)fileBoIdStr, Map.class);
            for (Long boId : boIdSet) {
                if (!existCacheMap.containsKey(boId)) continue;
                fileVidMap.put(boId, existCacheMap.get(boId));
            }
        }
        return fileVidMap;
    }

    public Map<Long, String> lockFileBoIds(Set<Long> boIdSet, AttFileTaskCacheInfoEnum attFileTaskCacheInfoEnum) {
        HashMap fileVidMap;
        block21: {
            if (WTCCollections.isEmpty(boIdSet)) {
                return Collections.emptyMap();
            }
            fileVidMap = Maps.newHashMapWithExpectedSize((int)boIdSet.size());
            DistributeSessionlessCache redis = WTCCacheUtils.getCache();
            String cacheKey = WTCCacheUtils.getKey((String)"wtp", (String)CACHE_KEY_REDIS);
            String lockKey = WTCCacheUtils.getKey((String)"wtp", (String)LOCK_KEY);
            HashMap cacheMap = Maps.newHashMapWithExpectedSize((int)boIdSet.size());
            try (DLock lock = DLock.create((String)lockKey);){
                if (lock.tryLock(10000L)) {
                    String fileBoIdStr = (String)redis.get(cacheKey);
                    if (WTCStringUtils.isEmpty((String)fileBoIdStr)) {
                        for (Long boId : boIdSet) {
                            cacheMap.put(boId, attFileTaskCacheInfoEnum.code);
                        }
                    } else {
                        Map existCacheMap = (Map)JSON.parseObject((String)fileBoIdStr, Map.class);
                        if (WTCCollections.isNotEmpty((Map)existCacheMap)) {
                            cacheMap.putAll(existCacheMap);
                            existCacheMap.clear();
                        }
                        for (Long boId : boIdSet) {
                            if (cacheMap.containsKey(boId)) {
                                fileVidMap.put(boId, cacheMap.get(boId));
                                continue;
                            }
                            cacheMap.put(boId, attFileTaskCacheInfoEnum.code);
                        }
                    }
                    if (WTCCollections.isNotEmpty((Map)cacheMap)) {
                        redis.put(cacheKey, (Object)JSON.toJSONString((Object)cacheMap), 1800);
                    }
                    break block21;
                }
                throw new KDBizException(AttFileKDString.getLockTimeOut());
            }
        }
        return fileVidMap;
    }

    public void unLockFileBoIds(Set<Long> fileBoIdSet) {
        block16: {
            if (WTCCollections.isEmpty(fileBoIdSet)) {
                return;
            }
            DistributeSessionlessCache cache = WTCCacheUtils.getCache();
            String cacheKey = WTCCacheUtils.getKey((String)"wtp", (String)CACHE_KEY_REDIS);
            String lockKey = WTCCacheUtils.getKey((String)"wtp", (String)LOCK_KEY);
            try (DLock lock = DLock.create((String)lockKey);){
                if (lock.tryLock(10000L)) {
                    Map map;
                    String fileBoIdStr = (String)cache.get(cacheKey);
                    if (WTCStringUtils.isNotEmpty((String)fileBoIdStr) && WTCCollections.isNotEmpty((Map)(map = (Map)JSON.parseObject((String)fileBoIdStr, Map.class)))) {
                        for (Long fileBoId : fileBoIdSet) {
                            map.remove(fileBoId);
                        }
                        cache.put(cacheKey, (Object)JSON.toJSONString((Object)map), 1800);
                    }
                    break block16;
                }
                throw new KDBizException(AttFileKDString.getLockTimeOut());
            }
        }
    }

    public Map<Long, String> cacheAttFileSynAndSetOp(OperateOption option, Set<Long> synFileBoIdSet, AttFileTaskCacheInfoEnum attFileTaskCacheInfoEnum, String removeKey) {
        if (WTCCollections.isNotEmpty(synFileBoIdSet)) {
            Map<Long, String> taskRunData = AttFileSyncService.getInstance().lockFileBoIds(synFileBoIdSet, attFileTaskCacheInfoEnum);
            if (WTCCollections.isNotEmpty(taskRunData)) {
                synFileBoIdSet.removeAll(taskRunData.keySet());
            }
            option.setVariableValue(removeKey, JSON.toJSONString(synFileBoIdSet));
            return taskRunData;
        }
        return Collections.emptyMap();
    }

    public void removeFileSynOpCache(OperateOption operateOption, String removeKey) {
        Map variables = operateOption.getVariables();
        String fileRemoveStr = (String)variables.get(removeKey);
        if (HRStringUtils.isNotEmpty((String)fileRemoveStr)) {
            Set set = (Set)JSON.parseObject((String)fileRemoveStr, Set.class);
            AttFileSyncService.getInstance().unLockFileBoIds(set);
        }
    }
}

