/*
 * Decompiled with CFR 0.152.
 */
package kd.wtc.wtp.business.attfile.adjust;

import com.alibaba.fastjson.JSON;
import java.time.LocalDate;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.hr.hbp.business.servicehelper.HRBaseServiceHelper;
import kd.wtc.wtbs.business.model.attendperson.AdminOrg;
import kd.wtc.wtbs.business.model.attendperson.Company;
import kd.wtc.wtbs.business.model.attendperson.Job;
import kd.wtc.wtbs.business.model.attendperson.Position;
import kd.wtc.wtbs.business.timeseq.TimeSeqBo;
import kd.wtc.wtbs.common.util.WTCDateUtils;
import kd.wtc.wtbs.common.util.third.collect.Lists;
import kd.wtc.wtbs.common.util.third.collect.Maps;
import kd.wtc.wtp.common.model.file.AttFileAdjustModel;

public abstract class AbstractAttFileAdjustUpdateStrategy {
    private static final Log LOG = LogFactory.getLog(AbstractAttFileAdjustUpdateStrategy.class);

    public abstract String getSelectProperties();

    public abstract String getAttFileVidNumber();

    public abstract String getCompanyVidNumber();

    public abstract String getDepartmentVidNumber();

    public abstract String getPositionVidNumber();

    public abstract String getJobVidNumber();

    public abstract String getOwnDateNumber();

    public abstract QFilter[] getQFilters(List<Long> var1, List<Long> var2);

    public abstract HRBaseServiceHelper getServiceHelper();

    public void adjustUpdate(List<AttFileAdjustModel> attFileAdjustModels) {
        if (LOG.isDebugEnabled()) {
            LOG.debug("adjustUpdate attFileAdjustModels : {}", (Object)JSON.toJSONString(attFileAdjustModels));
        }
        ArrayList attFileVidList = Lists.newArrayListWithExpectedSize((int)attFileAdjustModels.size());
        ArrayList attFileBidList = Lists.newArrayListWithExpectedSize((int)attFileAdjustModels.size());
        HashMap vidToAttFileAdjustModelMap = Maps.newHashMapWithExpectedSize((int)attFileAdjustModels.size());
        for (AttFileAdjustModel attFileAdjustModel : attFileAdjustModels) {
            attFileVidList.add(attFileAdjustModel.getVersionId());
            attFileBidList.add(attFileAdjustModel.getBoId());
            vidToAttFileAdjustModelMap.put(attFileAdjustModel.getVersionId(), attFileAdjustModel);
        }
        LOG.info("adjustUpdate attFileVidList : {}", (Object)attFileVidList);
        DynamicObject[] dynamicObjects = this.getServiceHelper().query(this.getSelectProperties(), this.getQFilters(attFileVidList, attFileBidList));
        ArrayList<DynamicObject> updateList = new ArrayList<DynamicObject>(16);
        for (DynamicObject dynamicObject : dynamicObjects) {
            long attFileVid = dynamicObject.getLong(this.getAttFileVidNumber() + ".id");
            Date ownDate = dynamicObject.getDate(this.getOwnDateNumber());
            long oldCompanyVid = dynamicObject.getLong(this.getCompanyVidNumber() + ".id");
            long oldDepartmentVid = dynamicObject.getLong(this.getDepartmentVidNumber() + ".id");
            long oldPositionVid = dynamicObject.getLong(this.getPositionVidNumber() + ".id");
            long oldJobVid = dynamicObject.getLong(this.getJobVidNumber() + ".id");
            AttFileAdjustModel attFileAdjustModel = (AttFileAdjustModel)vidToAttFileAdjustModelMap.get(attFileVid);
            if (attFileAdjustModel == null) continue;
            boolean needUpdate = false;
            LocalDate localDate = WTCDateUtils.toLocalDate((Date)ownDate);
            TimeSeqBo companyModel = attFileAdjustModel.getCompanyModel();
            if (companyModel != null) {
                Company company = (Company)companyModel.getVersionByDate(localDate);
                if (company != null) {
                    long newCompanyVid = company.getId();
                    if (oldCompanyVid != newCompanyVid) {
                        dynamicObject.set(this.getCompanyVidNumber(), (Object)newCompanyVid);
                        needUpdate = true;
                    }
                } else {
                    dynamicObject.set(this.getCompanyVidNumber(), null);
                    needUpdate = true;
                }
            } else {
                dynamicObject.set(this.getCompanyVidNumber(), null);
                needUpdate = true;
            }
            TimeSeqBo adminOrgModel = attFileAdjustModel.getAdminOrgModel();
            if (adminOrgModel != null) {
                AdminOrg department = (AdminOrg)adminOrgModel.getVersionByDate(localDate);
                if (department != null) {
                    long newDepartmentVid = department.getId();
                    if (oldDepartmentVid != newDepartmentVid) {
                        dynamicObject.set(this.getDepartmentVidNumber(), (Object)newDepartmentVid);
                        needUpdate = true;
                    }
                } else {
                    dynamicObject.set(this.getDepartmentVidNumber(), null);
                    needUpdate = true;
                }
            } else {
                dynamicObject.set(this.getDepartmentVidNumber(), null);
                needUpdate = true;
            }
            TimeSeqBo positionModel = attFileAdjustModel.getPositionModel();
            if (positionModel != null) {
                Position position = (Position)positionModel.getVersionByDate(localDate);
                if (position != null) {
                    long newPositionVid = position.getId();
                    if (oldPositionVid != newPositionVid) {
                        dynamicObject.set(this.getPositionVidNumber(), (Object)newPositionVid);
                        needUpdate = true;
                    }
                } else {
                    dynamicObject.set(this.getPositionVidNumber(), null);
                    needUpdate = true;
                }
            } else {
                dynamicObject.set(this.getPositionVidNumber(), null);
                needUpdate = true;
            }
            TimeSeqBo jobModel = attFileAdjustModel.getJobModel();
            if (jobModel != null) {
                Job job = (Job)jobModel.getVersionByDate(localDate);
                if (job != null) {
                    long newJobVid = job.getId();
                    if (oldJobVid != newJobVid) {
                        dynamicObject.set(this.getJobVidNumber(), (Object)newJobVid);
                        needUpdate = true;
                    }
                } else {
                    dynamicObject.set(this.getJobVidNumber(), null);
                    needUpdate = true;
                }
            } else {
                dynamicObject.set(this.getJobVidNumber(), null);
                needUpdate = true;
            }
            if (!needUpdate) continue;
            updateList.add(dynamicObject);
        }
        LOG.info("adjustUpdate update count :{}", (Object)updateList.size());
        this.getServiceHelper().update(updateList.toArray(new DynamicObject[0]));
    }
}

