/*
 * Decompiled with CFR 0.152.
 */
package kd.wtc.wtp.business.attfile.adjust;

import java.util.List;
import kd.wtc.wtbs.common.helper.WTCAppContextHelper;
import kd.wtc.wtbs.common.util.third.collect.Lists;
import kd.wtc.wtp.business.attfile.adjust.AbstractAttFileAdjustUpdateStrategy;
import kd.wtc.wtp.business.attfile.adjust.ExRecordAdjustUpdateService;
import kd.wtc.wtp.business.attfile.adjust.RecordDailyAdjustUpdateService;
import kd.wtc.wtp.business.attfile.adjust.RecordPeriodAdjustUpdateService;
import kd.wtc.wtp.common.model.file.AttFileAdjustModel;
import kd.wtc.wtp.enums.attfile.AttFileAdjustEnum;

public class AttFileAdjustUpdateService {
    private static final int ATTFILE_BATCH_NUM = WTCAppContextHelper.getProjectParams().getIntValue("kd.wtc.wtp.attfileUpdateBatchNum", 10);

    public void refreshDownBusinessData(List<AttFileAdjustModel> attFileAdjustModels, List<AttFileAdjustEnum> adjustEnums) {
        List partition = Lists.partition(attFileAdjustModels, (int)ATTFILE_BATCH_NUM);
        for (List list : partition) {
            this.dealByStrategy(list, adjustEnums);
        }
    }

    public void dealByStrategy(List<AttFileAdjustModel> attFileAdjustModels, List<AttFileAdjustEnum> adjustEnums) {
        for (AttFileAdjustEnum adjustEnum : adjustEnums) {
            AbstractAttFileAdjustUpdateStrategy strategy = this.getStrategyInstance(adjustEnum);
            if (strategy == null) continue;
            strategy.adjustUpdate(attFileAdjustModels);
        }
    }

    private AbstractAttFileAdjustUpdateStrategy getStrategyInstance(AttFileAdjustEnum adjustEnum) {
        AbstractAttFileAdjustUpdateStrategy instance = null;
        if (adjustEnum == AttFileAdjustEnum.DAILYRECORD) {
            instance = RecordDailyAdjustUpdateService.getInstance();
        } else if (adjustEnum == AttFileAdjustEnum.EXRECORD) {
            instance = ExRecordAdjustUpdateService.getInstance();
        } else if (adjustEnum == AttFileAdjustEnum.SUMRECORD) {
            instance = RecordPeriodAdjustUpdateService.getInstance();
        }
        return instance;
    }
}

