/*
 * Decompiled with CFR 0.152.
 */
package kd.wtc.wtp.business.attfile.cert;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.hr.hbp.common.util.HRStringUtils;
import kd.wtc.wtbs.business.license.CertService;
import kd.wtc.wtbs.common.util.third.collect.Maps;

public class AttFileCertService {
    public static List<Long> getAddCertDealId(List<DynamicObject> files) {
        Set personIds = files.stream().map(dyn -> {
            long selectId = dyn.getLong("selectperson.person.id");
            if (dyn.get("attperson") instanceof Long) {
                return selectId == 0L ? dyn.getLong("attperson") : selectId;
            }
            return selectId == 0L ? dyn.getLong("attperson.id") : selectId;
        }).collect(Collectors.toSet());
        List attFiles = CertService.getAttFileQueryRes(personIds, (String)"id,attperson,atttag.attendstatus,startdate,enddate,bsed,bsled");
        Map<Long, List<DynamicObject>> id2Attfiles = attFiles.stream().collect(Collectors.groupingBy(dyn -> dyn.getLong("attperson.id")));
        ArrayList<Long> needAddCert = new ArrayList<Long>(files.size());
        for (DynamicObject file : files) {
            List<DynamicObject> dynsOfFile;
            String fileStatus = file.getString("atttag.attendstatus");
            if ("2".equals(fileStatus) || !"1".equals(fileStatus)) continue;
            Long personId = file.getLong("selectperson.person.id");
            if (personId == null || Long.valueOf(0L).equals(personId)) {
                personId = file.get("attperson") instanceof DynamicObject ? Long.valueOf(file.getLong("attperson.id")) : Long.valueOf(file.getLong("attperson"));
            }
            if ((dynsOfFile = id2Attfiles.get(personId)) == null || dynsOfFile.size() == 0) {
                needAddCert.add(personId);
                continue;
            }
            List efftiveFiles = dynsOfFile.stream().filter(attfile -> HRStringUtils.equals((String)"1", (String)attfile.getString("atttag.attendstatus"))).collect(Collectors.toList());
            if (efftiveFiles.size() > 0) continue;
            needAddCert.add(personId);
        }
        return needAddCert;
    }

    public static Map<String, List<Long>> getUpdateCertDealId(List<DynamicObject> files) {
        Set personIds = files.stream().map(dyn -> dyn.getLong("attperson.id")).collect(Collectors.toSet());
        List attFiles = CertService.getAttFileQueryRes(personIds, (String)"id,atttag.attendstatus,attperson,hisversion,startdate,enddate,bsed,bsled");
        Map<Long, List<DynamicObject>> id2AllFiles = attFiles.stream().collect(Collectors.groupingBy(dyn -> dyn.getLong("attperson")));
        ArrayList<Long> needAddCert = new ArrayList<Long>(files.size());
        ArrayList<Long> needRelaseCert = new ArrayList<Long>(files.size());
        for (DynamicObject file : files) {
            Long personId = file.getLong("attperson.id");
            List<DynamicObject> attpersons = id2AllFiles.get(personId);
            if (attpersons == null || attpersons.size() == 0) continue;
            long oldId = 0L;
            if (file.getString("iscurrentversion").equals("true") && HRStringUtils.isEmpty((String)file.getString("hisversion"))) {
                oldId = file.getLong("sourcevid");
            } else {
                List oldFiles = attpersons.stream().filter(dyn -> dyn.getString("hisversion").equals(file.getString("hisversion"))).collect(Collectors.toList());
                if (oldFiles.size() > 0) {
                    oldId = ((DynamicObject)oldFiles.get(0)).getLong("id");
                }
            }
            if (oldId == 0L) continue;
            long finalOldId = oldId;
            List<DynamicObject> personsNotCurrent = attpersons.stream().filter(person -> person.getLong("id") != finalOldId).collect(Collectors.toList());
            long finalOldIdTemp = oldId;
            List res = attpersons.stream().filter(dyn -> dyn.getLong("id") == finalOldIdTemp).collect(Collectors.toList());
            if (res.size() == 0 || HRStringUtils.equals((String)((DynamicObject)res.get(0)).getString("atttag.attendstatus"), (String)file.getString("atttag.attendstatus"))) continue;
            AttFileCertService.CertDealWithStatus(personsNotCurrent, needAddCert, file, personId, (DynamicObject)res.get(0), "2", "1");
            AttFileCertService.CertDealWithStatus(personsNotCurrent, needRelaseCert, file, personId, (DynamicObject)res.get(0), "1", "2");
        }
        HashMap dealRes = Maps.newHashMapWithExpectedSize((int)2);
        dealRes.put("add", needAddCert);
        dealRes.put("delete", needRelaseCert);
        return dealRes;
    }

    private static void CertDealWithStatus(List<DynamicObject> filesWithoutOld, List<Long> needDealCert, DynamicObject file, Long personId, DynamicObject oldFile, String s, String s2) {
        if (s.equals(oldFile.getString("atttag.attendstatus")) && s2.equals(file.getString("atttag.attendstatus"))) {
            long size = filesWithoutOld.stream().filter(dyn -> dyn.getString("atttag.attendstatus").equals("1")).count();
            if (size > 0L) {
                return;
            }
            needDealCert.add(personId);
        }
    }
}

