/*
 * Decompiled with CFR 0.152.
 */
package kd.wtc.wtp.business.attfile.discard.impl;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.Callable;
import java.util.concurrent.Future;
import java.util.stream.Collectors;
import kd.bos.dataentity.OperateOption;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.threads.ThreadPool;
import kd.bos.threads.ThreadPools;
import kd.bos.util.CollectionUtils;
import kd.hr.hbp.business.servicehelper.HRBaseServiceHelper;
import kd.sdk.wtc.wtp.business.attfile.IAttFileDiscardExpandService;
import kd.wtc.wtbs.business.history.service.WTCHisServiceHelper;
import kd.wtc.wtbs.business.license.CertControlType;
import kd.wtc.wtbs.business.license.CertService;
import kd.wtc.wtbs.business.model.attendperson.AttendPersonCurrResult;
import kd.wtc.wtbs.business.util.WTCDynamicObjectUtils;
import kd.wtc.wtbs.business.web.attendperson.AttendPersonSynService;
import kd.wtc.wtbs.business.web.file.AttFileQueryServiceImpl;
import kd.wtc.wtbs.common.helper.WTCAppContextHelper;
import kd.wtc.wtbs.common.model.attfile.AttFileQueryParam;
import kd.wtc.wtbs.common.util.WTCCollections;
import kd.wtc.wtbs.common.util.WTCDateUtils;
import kd.wtc.wtbs.common.util.WTCMaps;
import kd.wtc.wtbs.common.util.WTCStringUtils;
import kd.wtc.wtbs.common.util.third.collect.Lists;
import kd.wtc.wtbs.common.util.third.collect.Maps;
import kd.wtc.wtbs.common.util.third.collect.Sets;
import kd.wtc.wtp.business.attconfirm.impl.AttConfirmQueryServiceImpl;
import kd.wtc.wtp.business.attfile.AttFileServiceImpl;
import kd.wtc.wtp.business.attfile.discard.IAttFileDiscardService;
import kd.wtc.wtp.business.attfile.event.AttFileDiscardEventCallable;
import kd.wtc.wtp.business.attfile.event.AttFileEventServiceImpl;
import kd.wtc.wtp.business.attperiod.PerAttPeriodDataService;
import kd.wtc.wtp.business.attstateinfo.AttStateInfoService;
import kd.wtc.wtp.common.enums.attconfirm.AttConfirmDataStatusEnum;
import kd.wtc.wtp.common.enums.event.EventStatusEnum;
import kd.wtc.wtp.common.kdstring.AttFileKDString;
import kd.wtc.wtp.common.model.attstateinfo.AttStateInfoBO;
import kd.wtc.wtp.common.model.file.AttFileDiscardCheckModel;
import kd.wtc.wtp.common.model.file.event.AttFileEventInfoModel;
import kd.wtc.wtp.common.model.file.event.AttFileEventInitModel;
import kd.wtc.wtp.common.model.file.event.AttFileEventSubModel;

public class AttFileDiscardServiceImpl
implements IAttFileDiscardService {
    private static final Log LOG = LogFactory.getLog(AttFileDiscardServiceImpl.class);
    private static final String DISCARD_ATT_FILE_THREAD_POOL_NAME = "wtc_wtp_attfilediscard";

    public static AttFileDiscardServiceImpl getInstance() {
        return (AttFileDiscardServiceImpl)WTCAppContextHelper.getBean(AttFileDiscardServiceImpl.class);
    }

    @Override
    public List<Long> discardAttFileHandler(AttFileDiscardCheckModel attFileDiscardCheckModel) {
        ArrayList<Long> fileBoIds = new ArrayList<Long>(new HashSet(attFileDiscardCheckModel.getFileBoIds()));
        AttFileEventServiceImpl eventCoordinationService = AttFileEventServiceImpl.getInstance();
        AttFileEventInitModel<IAttFileDiscardExpandService> attFileEventInitModel = eventCoordinationService.initEventMainModel(fileBoIds, "discard", IAttFileDiscardExpandService.class);
        Map subModelMap = attFileEventInitModel.getSubModelMap();
        Map eventInfoModelMap = attFileEventInitModel.getEventInfoModelMap();
        List mainModelList = attFileEventInitModel.getMainModelList();
        if (WTCCollections.isNotEmpty((Map)subModelMap)) {
            eventCoordinationService.startEventAndSubEvent(attFileEventInitModel);
            HashMap iAttFileDiscardEventServiceMap = Maps.newHashMapWithExpectedSize((int)16);
            for (Map.Entry entries : subModelMap.entrySet()) {
                IAttFileDiscardExpandService attFileDiscardEventService;
                List subModelList = (List)entries.getValue();
                String key = (String)entries.getKey();
                AttFileEventInfoModel attFileEventInfoModel = (AttFileEventInfoModel)eventInfoModelMap.get(key);
                if (attFileEventInfoModel == null || (attFileDiscardEventService = (IAttFileDiscardExpandService)attFileEventInfoModel.getT()) == null) continue;
                iAttFileDiscardEventServiceMap.put(attFileDiscardEventService, subModelList);
            }
            ThreadPool threadPool = ThreadPools.newFixedThreadPool((String)WTCStringUtils.joinStr((String[])new String[]{DISCARD_ATT_FILE_THREAD_POOL_NAME, UUID.randomUUID().toString()}), (int)iAttFileDiscardEventServiceMap.size());
            ArrayList submitFutureList = Lists.newArrayListWithExpectedSize((int)10);
            iAttFileDiscardEventServiceMap.forEach((k, value) -> {
                AttFileDiscardEventCallable attFileDiscardEventCallable = new AttFileDiscardEventCallable((List<Long>)fileBoIds, (IAttFileDiscardExpandService)k, (List<AttFileEventSubModel>)value);
                Future submit = threadPool.submit((Callable)attFileDiscardEventCallable);
                submitFutureList.add(submit);
            });
            boolean dataHandler = true;
            for (Future booleanFuture : submitFutureList) {
                Boolean aBoolean = null;
                try {
                    aBoolean = (Boolean)booleanFuture.get();
                }
                catch (Exception exception) {
                    LOG.warn((Throwable)exception);
                    dataHandler = false;
                    break;
                }
                if (Boolean.FALSE != aBoolean) continue;
                LOG.warn("submitFutureListFalse:{}", (Object)booleanFuture);
                dataHandler = false;
            }
            threadPool.close();
            if (dataHandler) {
                this.discardAttFile(attFileDiscardCheckModel);
                mainModelList.forEach(d -> d.setEventStatusEnum(EventStatusEnum.SUCCESS));
                eventCoordinationService.updateMainEventStatus(mainModelList);
                return Collections.emptyList();
            }
            return fileBoIds;
        }
        this.discardAttFile(attFileDiscardCheckModel);
        return fileBoIds;
    }

    @Override
    public void discardAttFile(AttFileDiscardCheckModel attFileDiscardCheckModel) {
        List fileBoIds = attFileDiscardCheckModel.getFileBoIds();
        ArrayList handlerData = Lists.newArrayListWithExpectedSize((int)fileBoIds.size());
        AttFileQueryParam attFileQueryParam = new AttFileQueryParam(false);
        attFileQueryParam.setSetBoIds(new HashSet(fileBoIds));
        attFileQueryParam.setBeCurrent(Boolean.FALSE);
        List files = AttFileQueryServiceImpl.getInstance().queryAttFiles(attFileQueryParam);
        for (DynamicObject file : files) {
            file.set("usablestatus", (Object)"-1");
        }
        handlerData.addAll(files);
        HashSet lastBoIdSet = Sets.newHashSetWithExpectedSize((int)fileBoIds.size());
        Set employeeList = files.stream().map(d -> d.getLong("employee.id")).collect(Collectors.toSet());
        AttFileQueryParam attFileQueryParam1 = new AttFileQueryParam(false);
        attFileQueryParam1.setProperties("boid,employee.id,startdate");
        QFilter qFilter = new QFilter("employee", "in", employeeList);
        qFilter.and(new QFilter("boid", "not in", (Object)fileBoIds));
        attFileQueryParam1.setqFilter(qFilter);
        List employeeAttFileList = AttFileQueryServiceImpl.getInstance().queryAttFiles(attFileQueryParam1);
        Map<Long, List<DynamicObject>> employeeAttFileMap = employeeAttFileList.stream().collect(Collectors.groupingBy(d -> d.getLong("employee.id")));
        for (Map.Entry<Long, List<DynamicObject>> entries : employeeAttFileMap.entrySet()) {
            List<DynamicObject> value = entries.getValue();
            if (!WTCCollections.isNotEmpty(value)) continue;
            value.sort(Comparator.comparing(d -> d.getDate("startdate")));
            DynamicObject dynamicObject = value.get(value.size() - 1);
            lastBoIdSet.add(dynamicObject.getLong("boid"));
        }
        HashMap fileBoIdAndPersonIdMap = Maps.newHashMapWithExpectedSize((int)lastBoIdSet.size());
        if (WTCCollections.isNotEmpty((Collection)lastBoIdSet)) {
            DynamicObject[] reviseEndDateDyArr;
            Map<String, Object> rollbackResult = AttFileServiceImpl.getInstance().rollBackFileToNormalAtt(lastBoIdSet);
            OperateOption option = attFileDiscardCheckModel.getOption();
            if (WTCCollections.isNotEmpty(rollbackResult) && null != rollbackResult.get("rollbackFileOnly") && option != null) {
                option.setVariableValue("rollbackFileOnly", AttFileKDString.fileRollbackOnly((String)rollbackResult.get("rollbackFileOnly").toString()));
            }
            Date maxEndDate = WTCHisServiceHelper.getMaxEndDate();
            AttFileQueryParam attFileQueryParam2 = new AttFileQueryParam(false);
            attFileQueryParam2.setSetBoIds((Set)lastBoIdSet);
            attFileQueryParam2.setBeCurrent(Boolean.FALSE);
            List lastBoFileList = AttFileQueryServiceImpl.getInstance().queryAttFiles(attFileQueryParam2);
            fileBoIdAndPersonIdMap.putAll(lastBoFileList.stream().collect(Collectors.toMap(dy -> dy.getLong("boid"), dy -> WTCDynamicObjectUtils.getBaseDataId((DynamicObject)dy, (String)"attperson"), (a, b) -> a)));
            for (DynamicObject dynamicObject : reviseEndDateDyArr = (DynamicObject[])lastBoFileList.stream().filter(d -> d.getDate("enddate").before(maxEndDate)).toArray(DynamicObject[]::new)) {
                dynamicObject.set("enddate", (Object)maxEndDate);
            }
            AttFileServiceImpl.getInstance().attFileRevise(reviseEndDateDyArr);
            if (!attFileDiscardCheckModel.isFromCoordination()) {
                List leavePersonIds = attFileDiscardCheckModel.getLeavePersonIds();
                List addCertPersonIds = leavePersonIds.stream().filter(fileBoIdAndPersonIdMap::containsValue).collect(Collectors.toList());
                CertService.certControlOfAttPerson((String)"wtp", (String)"wtp_attfilebase", new HashSet(addCertPersonIds), (CertControlType)CertControlType.VALIDATORANDAPPLIED);
            }
        }
        Set<Long> personSet = files.stream().map(d -> d.getLong("person.id")).collect(Collectors.toSet());
        this.handleAttPersonData(fileBoIds, files, personSet);
        AttFileServiceImpl.getInstance().attFileRevise(handlerData.toArray(new DynamicObject[0]));
        if (WTCCollections.isNotEmpty((Map)fileBoIdAndPersonIdMap)) {
            PerAttPeriodDataService.getInstance().processAndSavePerAttPeriodData(fileBoIdAndPersonIdMap, false, false);
            this.clearExcInfo(fileBoIdAndPersonIdMap.keySet());
        }
        AttConfirmQueryServiceImpl.getInstance().updateDataStatusAttConfirmRecord(new QFilter("attfile", "in", (Object)fileBoIds), AttConfirmDataStatusEnum.DISCARD);
        if (WTCCollections.isNotEmpty(personSet)) {
            CertService.certControl((String)"wtp", (String)"wtp_attfilebase", new ArrayList<Long>(personSet), (CertControlType)CertControlType.VALIDATORANDRELEASE);
        }
    }

    public void handleAttPersonData(List<Long> fileBoIds, List<DynamicObject> files, Set<Long> personSet) {
        AttFileQueryParam attFileQueryParam2 = new AttFileQueryParam(false);
        attFileQueryParam2.setPersonSetIds(personSet);
        attFileQueryParam2.setBeCurrent(Boolean.valueOf(true));
        attFileQueryParam2.setProperties("boid,employee, person.id, startdate, empposorgrel");
        attFileQueryParam2.setqFilter(new QFilter("boid", "not in", fileBoIds));
        attFileQueryParam2.setOrderBy("startdate");
        List existsAttFileDys = AttFileQueryServiceImpl.getInstance().queryAttFiles(attFileQueryParam2);
        Map<Long, List<DynamicObject>> personToExistsAttFileDysMap = existsAttFileDys.stream().collect(Collectors.groupingBy(dy -> dy.getLong("person.id")));
        HRBaseServiceHelper hrBaseServiceHelper = new HRBaseServiceHelper("wtp_attendperson");
        DynamicObject[] dynamicObjects = hrBaseServiceHelper.loadDynamicObjectArray(personSet.toArray());
        personSet.removeAll(existsAttFileDys.stream().map(d -> d.getLong("person.id")).collect(Collectors.toSet()));
        for (DynamicObject dynamicObject : dynamicObjects) {
            long personId = dynamicObject.getLong("id");
            if (personToExistsAttFileDysMap.containsKey(personId)) {
                dynamicObject.set("latestattenddate", (Object)WTCDateUtils.getMaxEndDate());
                continue;
            }
            dynamicObject.set("earliestattenddate", null);
            dynamicObject.set("latestattenddate", null);
        }
        hrBaseServiceHelper.update(dynamicObjects);
        HashMap personToLastAttFileDyMap = Maps.newHashMapWithExpectedSize((int)personToExistsAttFileDysMap.size());
        ArrayList<Long> handlePeronIds = new ArrayList<Long>();
        ArrayList<Long> handleEmpPosOrgRelList = new ArrayList<Long>();
        ArrayList<Long> handleEmployeeList = new ArrayList<Long>();
        for (Map.Entry<Long, List<DynamicObject>> mapEntry : personToExistsAttFileDysMap.entrySet()) {
            List<DynamicObject> attFileList = mapEntry.getValue();
            if (!CollectionUtils.isNotEmpty(attFileList)) continue;
            attFileList.sort(Comparator.comparing(attFileDy -> attFileDy.getDate("startdate")));
            personToLastAttFileDyMap.put(mapEntry.getKey(), attFileList.get(attFileList.size() - 1));
        }
        for (DynamicObject fileDy : files) {
            long lastEmployeeId;
            long personId = fileDy.getLong("person.id");
            long employeeId = WTCDynamicObjectUtils.getBaseDataId((DynamicObject)fileDy, (String)"employee");
            DynamicObject lastAttFileDy = (DynamicObject)personToLastAttFileDyMap.get(personId);
            if (lastAttFileDy == null || employeeId == (lastEmployeeId = WTCDynamicObjectUtils.getBaseDataId((DynamicObject)lastAttFileDy, (String)"employee"))) continue;
            handlePeronIds.add(personId);
            handleEmployeeList.add(lastEmployeeId);
            handleEmpPosOrgRelList.add(WTCDynamicObjectUtils.getBaseDataId((DynamicObject)lastAttFileDy, (String)"empposorgrel"));
        }
        if (CollectionUtils.isEmpty(handlePeronIds)) {
            return;
        }
        HashMap map = Maps.newHashMapWithExpectedSize((int)16);
        map.put("employee", handleEmployeeList);
        AttendPersonCurrResult attendPersonCurrResult = AttendPersonSynService.getInstance().checkAndGetPersonDataCustom(handlePeronIds, handleEmpPosOrgRelList, null, (Map)map);
        AttendPersonSynService.getInstance().updateAttPerson(attendPersonCurrResult);
    }

    private void clearExcInfo(Collection<Long> fileBoIdCollection) {
        List<AttStateInfoBO> attStateInfoBOS = AttStateInfoService.getInstance().queryAttStateInfoByBoid(new ArrayList<Long>(fileBoIdCollection));
        HashMap fileBoIdWtteDyMap = Maps.newHashMapWithExpectedSize((int)1);
        ArrayList needUpdateFileBoIdList = Lists.newArrayListWithExpectedSize((int)1);
        HashMap newWtteDyMap = Maps.newHashMapWithExpectedSize((int)3);
        newWtteDyMap.put("isinfoexc", Boolean.FALSE);
        newWtteDyMap.put("excstartdate", null);
        newWtteDyMap.put("excenddate", null);
        for (AttStateInfoBO attStateInfoBO : attStateInfoBOS) {
            Long fileBoId = attStateInfoBO.getFileBoid();
            fileBoIdWtteDyMap.put(fileBoId, newWtteDyMap);
            needUpdateFileBoIdList.add(fileBoId);
        }
        if (WTCMaps.isNotEmpty((Map)fileBoIdWtteDyMap)) {
            AttStateInfoService.getInstance().updateExcInfo(fileBoIdWtteDyMap, needUpdateFileBoIdList);
        }
    }
}

