/*
 * Decompiled with CFR 0.152.
 */
package kd.wtc.wtp.business.attfile.event;

import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.Callable;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.sdk.wtc.wtp.business.attfile.IAttFileDiscardExpandService;
import kd.wtc.wtbs.common.util.WTCCollections;
import kd.wtc.wtbs.common.util.third.time.StopWatch;
import kd.wtc.wtp.business.attfile.event.AttFileEventServiceImpl;
import kd.wtc.wtp.common.enums.event.EventStatusEnum;
import kd.wtc.wtp.common.model.file.event.AttFileEventSubModel;

public class AttFileDiscardEventCallable
implements Callable<Boolean> {
    private static final Log LOG = LogFactory.getLog(AttFileDiscardEventCallable.class);
    private List<Long> fileBoIds;
    private IAttFileDiscardExpandService attFileDiscardEventService;
    private List<AttFileEventSubModel> subModelList;

    public AttFileDiscardEventCallable() {
    }

    public AttFileDiscardEventCallable(List<Long> fileBoIds, IAttFileDiscardExpandService attFileDiscardEventService, List<AttFileEventSubModel> subModelList) {
        this.fileBoIds = fileBoIds;
        this.attFileDiscardEventService = attFileDiscardEventService;
        this.subModelList = subModelList;
    }

    @Override
    public Boolean call() {
        try {
            if (this.attFileDiscardEventService != null) {
                StopWatch stopWatch = StopWatch.createStarted();
                Map handlerResult = this.attFileDiscardEventService.handleAttFileRelateData(this.fileBoIds);
                this.handlerEventData(this.subModelList, handlerResult);
                stopWatch.stop();
                LOG.info("AttFileDiscardEventCallable class name {},consuming {}", (Object)this.attFileDiscardEventService.getClass().getName(), (Object)stopWatch.getTime());
            }
        }
        catch (Exception exception) {
            LOG.warn("AttFileDiscardEventCallable.call error", (Throwable)exception);
            return Boolean.FALSE;
        }
        return Boolean.TRUE;
    }

    private void handlerEventData(List<AttFileEventSubModel> subModelList, Map<String, Map<Long, String>> handlerResult) {
        Set<Long> successEntityId = this.getSuccessEntityId(handlerResult);
        AttFileEventServiceImpl eventCoordinationService = AttFileEventServiceImpl.getInstance();
        for (AttFileEventSubModel eventCoordinationSubModel : subModelList) {
            if (successEntityId.contains(eventCoordinationSubModel.getEntityId())) {
                eventCoordinationSubModel.setEventStatusEnum(EventStatusEnum.SUCCESS);
                continue;
            }
            eventCoordinationSubModel.setEventStatusEnum(EventStatusEnum.FAIL);
        }
        eventCoordinationService.updateSubEventStatus(subModelList);
    }

    private Set<Long> getSuccessEntityId(Map<String, Map<Long, String>> stringMapMap) {
        if (WTCCollections.isEmpty(stringMapMap)) {
            return Collections.emptySet();
        }
        Map<Long, String> successMap = stringMapMap.get("success");
        if (WTCCollections.isNotEmpty(successMap) && WTCCollections.isNotEmpty(successMap.keySet())) {
            return successMap.keySet();
        }
        return Collections.emptySet();
    }
}

