/*
 * Decompiled with CFR 0.152.
 */
package kd.wtc.wtp.business.attfile.event;

import com.alibaba.fastjson.JSON;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.hr.hbp.business.servicehelper.HRBaseServiceHelper;
import kd.wtc.wtbs.common.util.WTCCollections;
import kd.wtc.wtbs.common.util.WTCStringUtils;
import kd.wtc.wtbs.common.util.third.collect.Maps;
import kd.wtc.wtp.business.attfile.event.AttFileEventServiceImpl;
import kd.wtc.wtp.business.attfile.event.IAttFileEventService;
import kd.wtc.wtp.common.enums.event.EventStatusEnum;
import kd.wtc.wtp.common.model.file.event.AttFileEventInfoModel;
import kd.wtc.wtp.common.model.file.event.AttFileEventModel;

public abstract class AttFileEventAbstractService
implements IAttFileEventService {
    private static final Log LOG = LogFactory.getLog(AttFileEventAbstractService.class);

    protected <T> Map<String, AttFileEventInfoModel<T>> getEventInfoModel(String eventSign, Class<T> claType) {
        HashMap resultMap = Maps.newHashMapWithExpectedSize((int)16);
        if (WTCStringUtils.isEmpty((String)eventSign)) {
            return resultMap;
        }
        HRBaseServiceHelper hrBaseServiceHelper = new HRBaseServiceHelper("wtp_attfileeventinfo");
        DynamicObject[] dynamicObjects = hrBaseServiceHelper.loadDynamicObjectArray(new QFilter[]{new QFilter("operatetype", "=", (Object)eventSign)});
        AttFileEventServiceImpl attFileEventService = AttFileEventServiceImpl.getInstance();
        for (DynamicObject eventInfoDy : dynamicObjects) {
            String subEventType = eventInfoDy.getString("subeventtype");
            if (!WTCStringUtils.isNotEmpty((String)subEventType)) continue;
            String className = eventInfoDy.getString("classname");
            AttFileEventInfoModel attFileEventInfoModel = new AttFileEventInfoModel();
            boolean enable = eventInfoDy.getBoolean("enable");
            boolean sysPreset = eventInfoDy.getBoolean("issyspreset");
            attFileEventInfoModel.setId(Long.valueOf(eventInfoDy.getLong("id")));
            attFileEventInfoModel.setClassName(className);
            attFileEventInfoModel.setDescription(eventInfoDy.getString("description"));
            attFileEventInfoModel.setEnable(enable);
            attFileEventInfoModel.setSysPreset(sysPreset);
            attFileEventInfoModel.setOperateType(eventInfoDy.getString("operatetype"));
            attFileEventInfoModel.setSubEventType(subEventType);
            if (!enable) continue;
            resultMap.put(attFileEventInfoModel.getSubEventType(), attFileEventInfoModel);
            if (!sysPreset) continue;
            T clsInstance = attFileEventService.getClsInstance(claType, className);
            attFileEventInfoModel.setT(clsInstance);
        }
        if (LOG.isInfoEnabled()) {
            LOG.info("getEventInfoModel result {}", (Object)JSON.toJSONString((Object)resultMap));
        }
        return resultMap;
    }

    protected void updateEventStatus(List<? extends AttFileEventModel> subModelList, String entityNumber) {
        if (WTCCollections.isEmpty(subModelList)) {
            return;
        }
        HRBaseServiceHelper subHelper = new HRBaseServiceHelper(entityNumber);
        Object[] pkIds = subModelList.stream().map(AttFileEventModel::getId).toArray();
        DynamicObject[] dynamicObjects = subHelper.loadDynamicObjectArray(pkIds);
        Map subModeMap = subModelList.stream().collect(Collectors.toMap(AttFileEventModel::getId, Function.identity(), (a, b) -> a));
        Date date = new Date();
        long currUserId = RequestContext.get().getCurrUserId();
        for (DynamicObject dynamicObject : dynamicObjects) {
            EventStatusEnum eventStatusEnum;
            long id = dynamicObject.getLong("id");
            AttFileEventModel attFileEventModel = (AttFileEventModel)subModeMap.get(id);
            if (attFileEventModel == null || EventStatusEnum.SUCCESS != (eventStatusEnum = attFileEventModel.getEventStatusEnum()) && EventStatusEnum.FAIL != eventStatusEnum) continue;
            dynamicObject.set("status", (Object)eventStatusEnum.getCode());
            dynamicObject.set("modifytime", (Object)date);
            dynamicObject.set("modifier", (Object)currUserId);
            if (EventStatusEnum.SUCCESS != eventStatusEnum) continue;
            dynamicObject.set("endtime", (Object)date);
        }
        subHelper.update(dynamicObjects);
    }
}

