/*
 * Decompiled with CFR 0.152.
 */
package kd.wtc.wtp.business.attfile.event;

import java.lang.reflect.Constructor;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.exception.KDBizException;
import kd.bos.id.ID;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.util.CollectionUtils;
import kd.hr.hbp.business.servicehelper.HRBaseServiceHelper;
import kd.wtc.wtbs.common.helper.WTCAppContextHelper;
import kd.wtc.wtbs.common.util.WTCCollections;
import kd.wtc.wtbs.common.util.third.collect.Lists;
import kd.wtc.wtbs.common.util.third.collect.Maps;
import kd.wtc.wtbs.common.util.third.util.MapUtils;
import kd.wtc.wtp.business.attfile.event.AttFileEventAbstractService;
import kd.wtc.wtp.common.enums.event.EventStatusEnum;
import kd.wtc.wtp.common.kdstring.AttFileKDString;
import kd.wtc.wtp.common.model.file.event.AttFileAttFileEventMainModel;
import kd.wtc.wtp.common.model.file.event.AttFileEventInfoModel;
import kd.wtc.wtp.common.model.file.event.AttFileEventInitModel;
import kd.wtc.wtp.common.model.file.event.AttFileEventSubModel;

public class AttFileEventServiceImpl
extends AttFileEventAbstractService {
    private static final Log LOG = LogFactory.getLog(AttFileEventServiceImpl.class);

    public static AttFileEventServiceImpl getInstance() {
        return (AttFileEventServiceImpl)WTCAppContextHelper.getBean(AttFileEventServiceImpl.class);
    }

    @Override
    public <T> AttFileEventInitModel<T> initEventMainModel(List<Long> entityIdList, String eventSign, Class<T> claType) {
        AttFileEventInitModel attFileEventInitModel = new AttFileEventInitModel();
        if (WTCCollections.isEmpty(entityIdList)) {
            return attFileEventInitModel;
        }
        ArrayList mainModelList = Lists.newArrayListWithExpectedSize((int)entityIdList.size());
        Map<String, AttFileEventInfoModel<T>> eventInfoModelMap = this.getEventInfoModel(eventSign, claType);
        if (WTCCollections.isEmpty(eventInfoModelMap)) {
            return attFileEventInitModel;
        }
        Date date = new Date();
        long[] genLongIds = ID.genLongIds((int)entityIdList.size());
        for (int i = 0; i < entityIdList.size(); ++i) {
            long genEventId = genLongIds[i];
            Long entityId = entityIdList.get(i);
            AttFileAttFileEventMainModel attFileEventMainModel = new AttFileAttFileEventMainModel();
            attFileEventMainModel.setId(Long.valueOf(genEventId));
            attFileEventMainModel.setEntityId(entityId);
            attFileEventMainModel.setOperateType(eventSign);
            attFileEventMainModel.setStartTime(date);
            attFileEventMainModel.setEventStatusEnum(EventStatusEnum.TOBE_EXECUTED);
            mainModelList.add(attFileEventMainModel);
        }
        long[] subEventIds = ID.genLongIds((int)(entityIdList.size() * eventInfoModelMap.size()));
        int j = 0;
        HashMap subModelMap = Maps.newHashMapWithExpectedSize((int)eventInfoModelMap.size());
        for (AttFileEventInfoModel<T> attFileEventInfoModel : eventInfoModelMap.values()) {
            ArrayList subModelList = Lists.newArrayListWithExpectedSize((int)entityIdList.size());
            for (AttFileAttFileEventMainModel attFileEventMainModel : mainModelList) {
                AttFileEventSubModel eventCoordinationSubModel = new AttFileEventSubModel();
                eventCoordinationSubModel.setEventId(attFileEventMainModel.getId());
                eventCoordinationSubModel.setStartTime(date);
                eventCoordinationSubModel.setEntityId(attFileEventMainModel.getEntityId());
                eventCoordinationSubModel.setEventStatusEnum(EventStatusEnum.TOBE_EXECUTED);
                eventCoordinationSubModel.setEventInfoId(attFileEventInfoModel.getId());
                eventCoordinationSubModel.setId(Long.valueOf(subEventIds[j]));
                ++j;
                subModelList.add(eventCoordinationSubModel);
            }
            subModelMap.put(attFileEventInfoModel.getSubEventType(), subModelList);
        }
        attFileEventInitModel.setMainModelList((List)mainModelList);
        attFileEventInitModel.setSubModelMap((Map)subModelMap);
        attFileEventInitModel.setEventInfoModelMap(eventInfoModelMap);
        return attFileEventInitModel;
    }

    @Override
    public <T> void startEventAndSubEvent(AttFileEventInitModel<T> attFileEventInitModel) {
        HRBaseServiceHelper mainHelper = new HRBaseServiceHelper("wtp_attfileeventlog");
        HRBaseServiceHelper subHelper = new HRBaseServiceHelper("wtp_attfilesubeventlog");
        List mainModelList = attFileEventInitModel.getMainModelList();
        Map subModelMap = attFileEventInitModel.getSubModelMap();
        if (CollectionUtils.isEmpty((Collection)mainModelList) && MapUtils.isEmpty((Map)subModelMap)) {
            return;
        }
        Long currUserId = RequestContext.get().getCurrUserId();
        String batchnumber = UUID.randomUUID().toString().replace("-", "");
        Date date = new Date();
        ArrayList mainList = Lists.newArrayListWithExpectedSize((int)mainModelList.size());
        for (Object mainModel : mainModelList) {
            DynamicObject dynamicObject = mainHelper.generateEmptyDynamicObject();
            Long entityId = mainModel.getEntityId();
            dynamicObject.set("attfile", (Object)entityId);
            dynamicObject.set("operatetype", (Object)mainModel.getOperateType());
            dynamicObject.set("starttime", (Object)mainModel.getStartTime());
            dynamicObject.set("endtime", (Object)mainModel.getEndTime());
            EventStatusEnum eventStatusEnum = mainModel.getEventStatusEnum();
            if (null != eventStatusEnum) {
                dynamicObject.set("status", (Object)eventStatusEnum.getCode());
            }
            dynamicObject.set("id", (Object)mainModel.getId());
            dynamicObject.set("createtime", (Object)date);
            dynamicObject.set("modifytime", (Object)date);
            dynamicObject.set("creator", (Object)currUserId);
            dynamicObject.set("modifier", (Object)currUserId);
            dynamicObject.set("batchnumber", (Object)batchnumber);
            mainList.add(dynamicObject);
        }
        ArrayList subList = Lists.newArrayListWithExpectedSize((int)mainModelList.size());
        for (Map.Entry entry : subModelMap.entrySet()) {
            List subModelList = (List)entry.getValue();
            for (AttFileEventSubModel subModel : subModelList) {
                DynamicObject subDy = subHelper.generateEmptyDynamicObject();
                subDy.set("event", (Object)subModel.getEventId());
                subDy.set("eventinfo", (Object)subModel.getEventInfoId());
                subDy.set("starttime", (Object)subModel.getStartTime());
                subDy.set("endtime", (Object)subModel.getEndTime());
                EventStatusEnum eventStatusEnum = subModel.getEventStatusEnum();
                if (null != eventStatusEnum) {
                    subDy.set("status", (Object)eventStatusEnum.getCode());
                }
                subDy.set("id", (Object)subModel.getId());
                subDy.set("createtime", (Object)date);
                subDy.set("modifytime", (Object)date);
                subDy.set("creator", (Object)currUserId);
                subDy.set("modifier", (Object)currUserId);
                subList.add(subDy);
            }
        }
        Throwable throwable = null;
        try (TXHandle txHandle = TX.requiresNew();){
            try {
                mainHelper.save(mainList.toArray(new DynamicObject[0]));
                subHelper.save(subList.toArray(new DynamicObject[0]));
            }
            catch (Exception exp) {
                txHandle.markRollback();
                throw exp;
            }
        }
        catch (Throwable throwable2) {
            Throwable throwable3 = throwable2;
            throw throwable2;
        }
    }

    @Override
    public <T> T getClsInstance(Class<T> claType, String className) {
        try {
            Class<?> aClass = Class.forName(className);
            Constructor<?> constructor = aClass.getDeclaredConstructor(new Class[0]);
            return (T)constructor.newInstance(new Object[0]);
        }
        catch (Exception exception) {
            LOG.error("EventCoordinationAbstractService.getClsInstance err {},className{}", (Object)exception, (Object)className);
            throw new KDBizException(AttFileKDString.fileDiscardFail());
        }
    }

    @Override
    public void updateSubEventStatus(List<AttFileEventSubModel> subModelList) {
        this.updateEventStatus(subModelList, "wtp_attfilesubeventlog");
    }

    @Override
    public void updateMainEventStatus(List<AttFileAttFileEventMainModel> mainModelList) {
        this.updateEventStatus(mainModelList, "wtp_attfileeventlog");
    }
}

