/*
 * Decompiled with CFR 0.152.
 */
package kd.wtc.wtp.business.attfile.schedule;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.entity.property.BasedataProp;
import kd.bos.id.ID;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.servicehelper.MetadataServiceHelper;
import kd.hr.hbp.business.servicehelper.HRBaseServiceHelper;
import kd.hr.hbp.common.util.HRStringUtils;
import kd.wtc.wtbd.business.workschedule.AttFileWorkScheduleService;
import kd.wtc.wtbd.common.entity.workschedule.AttFileWorkSchCheckReq;
import kd.wtc.wtbd.common.entity.workschedule.AttFileWorkSchCheckRes;
import kd.wtc.wtbs.business.servicehelper.WTCServiceHelper;
import kd.wtc.wtbs.business.util.WTCDynamicObjectUtils;
import kd.wtc.wtbs.business.web.file.schedule.AttFileScheduleServiceImpl;
import kd.wtc.wtbs.common.enums.AttFileScheduleEnum;
import kd.wtc.wtbs.common.model.attfile.AttFileScheduleQueryParam;
import kd.wtc.wtbs.common.util.WTCCollections;
import kd.wtc.wtbs.common.util.WTCDateUtils;
import kd.wtc.wtbs.common.util.third.collect.Lists;
import kd.wtc.wtbs.common.util.third.collect.Maps;

public class AttFileScheduleBusiness {
    private static final Log log = LogFactory.getLog(AttFileScheduleBusiness.class);

    public static void setPlanEndDate(DynamicObject scheduleDy) {
        Date currEndDate = scheduleDy.getDate("enddate");
        if (currEndDate == null) {
            scheduleDy.set("enddate", (Object)WTCDateUtils.getMaxEndDate());
        }
    }

    public static void setStartEndDate(Map<Long, List<DynamicObject>> attFileGroupMap, DynamicObject scheduleDy) {
        DynamicObject attFileDy;
        List boDyList;
        long attFileId = scheduleDy.getLong("attfileid.id");
        List<DynamicObject> attFileVidList = attFileGroupMap.get(attFileId);
        if (!CollectionUtils.isEmpty(attFileVidList) && !CollectionUtils.isEmpty(boDyList = attFileVidList.stream().filter(info -> Boolean.TRUE.equals(info.getBoolean("iscurrentversion"))).collect(Collectors.toList())) && (attFileDy = (DynamicObject)boDyList.get(0)) != null) {
            if (scheduleDy.getDate("bsed") == null) {
                scheduleDy.set("bsed", (Object)attFileDy.getDate("startdate"));
            }
            if (scheduleDy.getDate("bsled") == null) {
                scheduleDy.set("bsled", (Object)attFileDy.getDate("enddate"));
            }
        }
    }

    public static void setEndDateAttFileVid(Map<Long, List<DynamicObject>> attFileGroupMap, DynamicObject scheduleDy, String pageId) {
        HRBaseServiceHelper fileHRBaseServiceHelper = new HRBaseServiceHelper("wtp_attfilebase");
        long attFileBoId = scheduleDy.getLong("attfileid.id");
        List<DynamicObject> attFileDyList = attFileGroupMap.get(attFileBoId);
        if (!CollectionUtils.isEmpty(attFileDyList)) {
            Date endDate = scheduleDy.getDate(AttFileScheduleEnum.getDateStrByPageId((boolean)false, (String)pageId));
            List attFileVidList = attFileDyList.stream().filter(info -> Boolean.FALSE.equals(info.getBoolean("iscurrentversion"))).filter(item -> endDate.compareTo(item.getDate("bsed")) >= 0 && endDate.compareTo(item.getDate("bsled")) <= 0).collect(Collectors.toList());
            if (!CollectionUtils.isEmpty(attFileVidList)) {
                DynamicObject dynamicObject = fileHRBaseServiceHelper.generateEmptyDynamicObject();
                dynamicObject.set("id", (Object)((DynamicObject)attFileVidList.get(0)).getLong("id"));
                scheduleDy.set("attfilevid", (Object)dynamicObject);
            }
        }
    }

    public static DynamicObject genNewFileSchDy(AttFileScheduleEnum scheduleEnum, long genLongId, DynamicObject fileEntity) {
        long orgId = WTCDynamicObjectUtils.getBaseDataId((DynamicObject)fileEntity, (String)"org");
        if (!fileEntity.getDataEntityType().getProperties().containsKey((Object)scheduleEnum.getKey()) || fileEntity.get(scheduleEnum.getKey()) == null) {
            return null;
        }
        if (scheduleEnum == AttFileScheduleEnum.CARD && HRStringUtils.isEmpty((String)((String)fileEntity.get(scheduleEnum.getKey())))) {
            return null;
        }
        DynamicObject scheduleDy = new DynamicObject((DynamicObjectType)MetadataServiceHelper.getDataEntityType((String)scheduleEnum.getPageId()));
        Object sch = fileEntity.get(scheduleEnum.getKey());
        IDataEntityProperty iDataEntityProperty = (IDataEntityProperty)scheduleDy.getDataEntityType().getProperties().get((Object)scheduleEnum.getKey());
        if (iDataEntityProperty instanceof BasedataProp && sch instanceof Long) {
            String baseEntityId = ((BasedataProp)iDataEntityProperty).getBaseEntityId();
            HRBaseServiceHelper schServiceHelper = new HRBaseServiceHelper(baseEntityId);
            DynamicObject emptyDynamicObject = schServiceHelper.generateEmptyDynamicObject();
            emptyDynamicObject.set("id", sch);
            sch = emptyDynamicObject;
        }
        scheduleDy.set(scheduleEnum.getKey(), sch);
        scheduleDy.set(AttFileScheduleEnum.getDateStrByPageId((boolean)true, (String)scheduleEnum.getPageId()), (Object)fileEntity.getDate("bsed"));
        scheduleDy.set(AttFileScheduleEnum.getDateStrByPageId((boolean)false, (String)scheduleEnum.getPageId()), (Object)fileEntity.getDate("bsled"));
        scheduleDy.set("id", (Object)genLongId);
        AttFileScheduleBusiness.setOrgDy(orgId, scheduleDy);
        if (!scheduleEnum.isTimeHis()) {
            scheduleDy.set("busistatus", (Object)"1");
        }
        HRBaseServiceHelper hrBaseServiceHelper = new HRBaseServiceHelper("wtp_attfilebase");
        DynamicObject fileDySet = hrBaseServiceHelper.generateEmptyDynamicObject();
        fileDySet.set("id", (Object)fileEntity.getLong("boid"));
        fileDySet.set("org", fileEntity.get("org"));
        scheduleDy.set("attfileid", (Object)fileDySet);
        long fileId = fileEntity.getLong("id");
        if (fileId == 0L) {
            fileEntity.set("id", (Object)ID.genLongId());
        }
        scheduleDy.set("attfilevid", (Object)fileEntity.getLong("id"));
        scheduleDy.set("attendstatus", (Object)fileEntity.getString("atttag.attendstatus"));
        return scheduleDy;
    }

    public static void setOrgDy(long orgId, DynamicObject scheduleDy) {
        IDataEntityProperty orGDataEntityProperty = (IDataEntityProperty)scheduleDy.getDataEntityType().getProperties().get((Object)"org");
        if (orGDataEntityProperty instanceof BasedataProp) {
            String baseEntityId = ((BasedataProp)orGDataEntityProperty).getBaseEntityId();
            HRBaseServiceHelper orgServiceHelper = new HRBaseServiceHelper(baseEntityId);
            DynamicObject emptyDynamicObject = orgServiceHelper.generateEmptyDynamicObject();
            emptyDynamicObject.set("id", (Object)orgId);
            scheduleDy.set("org", (Object)emptyDynamicObject);
        } else {
            scheduleDy.set("org", (Object)orgId);
        }
    }

    public static List<Map<String, String>> getSyncRosterParam(DynamicObject[] attFileSchDys) {
        ArrayList<Map<String, String>> dataList = new ArrayList<Map<String, String>>();
        if (attFileSchDys != null) {
            for (DynamicObject dataEntity : attFileSchDys) {
                if (!dataEntity.getDataEntityType().getName().startsWith(AttFileScheduleEnum.WS.getPageId())) continue;
                HashMap map = Maps.newHashMap();
                map.put("attFileBoId", String.valueOf(WTCDynamicObjectUtils.getBaseDataId((DynamicObject)dataEntity, (String)"attfileid")));
                map.put("orgId", String.valueOf(WTCDynamicObjectUtils.getBaseDataId((DynamicObject)dataEntity, (String)"attfileid.org")));
                map.put("startDate", WTCDateUtils.date2Str((Date)dataEntity.getDate("bsed"), (String)"yyyy-MM-dd"));
                map.put("endDate", WTCDateUtils.date2Str((Date)dataEntity.getDate("bsled"), (String)"yyyy-MM-dd"));
                map.put("workSchId", String.valueOf(WTCDynamicObjectUtils.getBaseDataId((DynamicObject)dataEntity, (String)AttFileScheduleEnum.WS.getKey())));
                dataList.add(map);
            }
        }
        return dataList;
    }

    public static Object fileSyncRoster(boolean async, List<Map<String, String>> reqDataMap) {
        if (WTCCollections.isNotEmpty(reqDataMap)) {
            return WTCServiceHelper.invokeWtcWtsBizService((String)"IScheduleService", (String)"syncRosterByAttFile", (Object[])new Object[]{async, reqDataMap});
        }
        return null;
    }

    public static Object fileSyncRoster(boolean async, List<Map<String, String>> reqDataMap, Map<String, String> customParam) {
        if (WTCCollections.isNotEmpty(reqDataMap)) {
            HashMap<String, String> cusHashMap = new HashMap<String, String>();
            if (WTCCollections.isNotEmpty(customParam) && "fromcoordination".equals(customParam.get("fromcoordination"))) {
                cusHashMap.put("wtc_roster_control_file_version_right", "false");
            }
            return WTCServiceHelper.invokeWtcWtsBizService((String)"IScheduleService", (String)"syncRosterByAttFile", (Object[])new Object[]{async, reqDataMap, cusHashMap});
        }
        return null;
    }

    private static void validateWs(Set<Long> attFileBoIds) {
        Map<Long, List<DynamicObject>> attFileWsDyMap = AttFileScheduleBusiness.queryAttFileIfFirstAddWs(attFileBoIds);
        HashMap nameMap = Maps.newHashMapWithExpectedSize((int)attFileWsDyMap.size());
        HashMap workSchCheckReqsMap = Maps.newHashMapWithExpectedSize((int)attFileBoIds.size());
        for (Map.Entry<Long, List<DynamicObject>> attFileWsEntry : attFileWsDyMap.entrySet()) {
            List attFileWorkSchCheckReqs = workSchCheckReqsMap.computeIfAbsent(attFileWsEntry.getKey(), key -> Lists.newArrayList());
            for (DynamicObject dataEntity : attFileWsEntry.getValue()) {
                nameMap.put(attFileWsEntry.getKey(), dataEntity.getString("attfileid.number"));
                long wsId = WTCDynamicObjectUtils.getBaseDataId((DynamicObject)dataEntity, (String)AttFileScheduleEnum.WS.getKey());
                AttFileWorkSchCheckReq attFileWorkSchCheckReq = new AttFileWorkSchCheckReq();
                attFileWorkSchCheckReq.setScheduleId(wsId);
                attFileWorkSchCheckReq.setStartDate(dataEntity.getDate("bsed"));
                Date bsled = dataEntity.getDate("bsled");
                attFileWorkSchCheckReq.setEndDate(bsled);
                if (bsled == null || "2999-12-31".equals(WTCDateUtils.date2Str((Date)bsled, (String)"yyyy-MM-dd"))) {
                    attFileWorkSchCheckReq.setLatest(true);
                }
                attFileWorkSchCheckReqs.add(attFileWorkSchCheckReq);
            }
        }
        Map validateResMap = AttFileWorkScheduleService.getInstance().checkAttFileWorkSchedule((Map)workSchCheckReqsMap);
        AttFileScheduleBusiness.getValidateResMapStr(validateResMap, nameMap);
    }

    public static String validateWsSchedule(Set<Long> attFileBoIds) {
        Map<Long, List<DynamicObject>> attFileWsDyMap = AttFileScheduleBusiness.queryAttFileIfFirstAddWs(attFileBoIds);
        HashMap nameMap = Maps.newHashMapWithExpectedSize((int)attFileWsDyMap.size());
        HashMap workSchCheckReqsMap = Maps.newHashMapWithExpectedSize((int)attFileBoIds.size());
        for (Map.Entry<Long, List<DynamicObject>> attFileWsEntry : attFileWsDyMap.entrySet()) {
            List attFileWorkSchCheckReqs = workSchCheckReqsMap.computeIfAbsent(attFileWsEntry.getKey(), key -> Lists.newArrayList());
            for (DynamicObject dataEntity : attFileWsEntry.getValue()) {
                nameMap.put(attFileWsEntry.getKey(), dataEntity.getString("attfileid.number"));
                long wsId = WTCDynamicObjectUtils.getBaseDataId((DynamicObject)dataEntity, (String)AttFileScheduleEnum.WS.getKey());
                AttFileWorkSchCheckReq attFileWorkSchCheckReq = new AttFileWorkSchCheckReq();
                attFileWorkSchCheckReq.setScheduleId(wsId);
                attFileWorkSchCheckReq.setStartDate(dataEntity.getDate("bsed"));
                Date bsled = dataEntity.getDate("bsled");
                attFileWorkSchCheckReq.setEndDate(bsled);
                if (bsled == null || "2999-12-31".equals(WTCDateUtils.date2Str((Date)bsled, (String)"yyyy-MM-dd"))) {
                    attFileWorkSchCheckReq.setLatest(true);
                }
                attFileWorkSchCheckReqs.add(attFileWorkSchCheckReq);
            }
        }
        Map validateResMap = AttFileWorkScheduleService.getInstance().checkAttFileWorkSchedule((Map)workSchCheckReqsMap);
        return AttFileScheduleBusiness.getValidateResMapStr(validateResMap, nameMap);
    }

    @Deprecated
    public static void handleValidateResMap(Map<Long, AttFileWorkSchCheckRes> validateResMap, Map<Long, String> nameMap) {
    }

    public static String getValidateResMapStr(Map<Long, AttFileWorkSchCheckRes> validateResMap, Map<Long, String> nameMap) {
        ArrayList errMsgs = Lists.newArrayList();
        for (Map.Entry<Long, AttFileWorkSchCheckRes> entry : validateResMap.entrySet()) {
            List messages;
            if (entry.getValue().isSuccess() || CollectionUtils.isEmpty((Collection)(messages = entry.getValue().getMessages()))) continue;
            errMsgs.add(messages.get(0));
        }
        if (WTCCollections.isNotEmpty((Collection)errMsgs)) {
            return String.join((CharSequence)"\n", errMsgs);
        }
        return "";
    }

    private static Map<Long, List<DynamicObject>> queryAttFileIfFirstAddWs(Set<Long> attFileBoIdSet) {
        AttFileScheduleQueryParam attFileScheduleQueryParam = new AttFileScheduleQueryParam();
        attFileScheduleQueryParam.setLoad(Boolean.FALSE);
        attFileScheduleQueryParam.setFileBoIdSet(attFileBoIdSet);
        attFileScheduleQueryParam.setProperties("ws,attfileid.name  name, attfileid.number ,attfileid,bsed,bsled");
        Map wsMap = AttFileScheduleServiceImpl.getInstance().queryAttFileSchedule(AttFileScheduleEnum.WS, attFileScheduleQueryParam);
        return wsMap;
    }
}

