/*
 * Decompiled with CFR 0.152.
 */
package kd.wtc.wtp.business.attfile.schedule;

import com.kingdee.bos.qing.util.MapUtils;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import kd.bos.dataentity.OperateOption;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.ArrayUtils;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.exception.KDBizException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.hr.hbp.business.servicehelper.HRBaseServiceHelper;
import kd.hr.hbp.common.util.HRDateTimeUtils;
import kd.hr.hbp.common.util.HRObjectUtils;
import kd.wtc.wtbs.business.servicehelper.WTCServiceHelper;
import kd.wtc.wtbs.business.util.WTCDynamicObjectUtils;
import kd.wtc.wtbs.business.web.file.AttFileQueryServiceImpl;
import kd.wtc.wtbs.business.web.file.schedule.AttFileScheduleServiceImpl;
import kd.wtc.wtbs.common.enums.AttFileScheduleEnum;
import kd.wtc.wtbs.common.helper.WTCAppContextHelper;
import kd.wtc.wtbs.common.model.attfile.AttFileQueryParam;
import kd.wtc.wtbs.common.model.attfile.AttFileScheduleQueryParam;
import kd.wtc.wtbs.common.util.Tuple;
import kd.wtc.wtbs.common.util.WTCCollections;
import kd.wtc.wtbs.common.util.WTCDateUtils;
import kd.wtc.wtbs.common.util.WTCInteDateUtil;
import kd.wtc.wtbs.common.util.WTCMaps;
import kd.wtc.wtbs.common.util.WTCStringUtils;
import kd.wtc.wtbs.common.util.third.collect.Lists;
import kd.wtc.wtbs.common.util.third.collect.Maps;
import kd.wtc.wtbs.common.util.third.collect.Sets;
import kd.wtc.wtp.business.attfile.AttFileCheckService;
import kd.wtc.wtp.business.attfile.AttFileHelper;
import kd.wtc.wtp.common.kdstring.AttFileKDString;
import kd.wtc.wtp.common.model.attstateinfo.AttStateInfoBO;

public class AttFileScheduleCheckHelper {
    private static final Log LOG = LogFactory.getLog(AttFileScheduleCheckHelper.class);

    public static AttFileScheduleCheckHelper getInstance() {
        return (AttFileScheduleCheckHelper)WTCAppContextHelper.getBean(AttFileScheduleCheckHelper.class);
    }

    public static Map<String, Boolean> checkShiftOverlap(String pageId, List<DynamicObject> dataList, List<DynamicObject> attFileDyList) {
        if (pageId.startsWith(AttFileScheduleEnum.WS.getPageId())) {
            Map<Long, DynamicObject> checkFileMap = attFileDyList.stream().collect(Collectors.toMap(dy -> dy.getLong("employee.id"), Function.identity(), (a, b) -> a));
            Set<Long> employeeSetIds = attFileDyList.stream().map(dy -> dy.getLong("employee.id")).collect(Collectors.toSet());
            Map<Long, DynamicObject> checkWsMap = dataList.stream().collect(Collectors.toMap(dynamicObject -> dynamicObject.getLong("attfileid.id"), Function.identity(), (a, b) -> a));
            List<Map<String, Object>> wsOverlapQueryParam = AttFileCheckService.getInstance().getWsOverlapQueryParam(employeeSetIds, checkWsMap, checkFileMap);
            return (Map)WTCServiceHelper.invokeWtcWtsBizService((String)"IScheduleService", (String)"isShiftPeriodOverlap", (Object[])new Object[]{wsOverlapQueryParam});
        }
        return Collections.emptyMap();
    }

    public static Map<String, String> checkCard(String pageId, List<DynamicObject> dataList, boolean addNewFlag) {
        if (pageId.startsWith(AttFileScheduleEnum.CARD.getPageId())) {
            HashMap cardCheckErrMap = Maps.newHashMapWithExpectedSize((int)dataList.size());
            AttFileHelper.checkCard(dataList, cardCheckErrMap, false, addNewFlag);
            return cardCheckErrMap;
        }
        return Collections.emptyMap();
    }

    public static String checkShiftOverLapEntity(Map<String, Boolean> shiftIfOverlapReturnMap, DynamicObject scheduleDy) {
        if (WTCMaps.isNotEmpty(shiftIfOverlapReturnMap)) {
            long wsId;
            long fileBoId;
            AttFileCheckService attFileCheckService = AttFileCheckService.getInstance();
            Boolean startBoolean = shiftIfOverlapReturnMap.get(attFileCheckService.getStartWsOverlapKey(fileBoId = scheduleDy.getLong("attfileid.id"), wsId = scheduleDy.getLong("ws.id")));
            if (startBoolean != null && startBoolean.booleanValue()) {
                Date fileDate;
                Date startDate = scheduleDy.getDate("bsed");
                if (startDate.before(fileDate = scheduleDy.getDate("attfileid.startdate"))) {
                    startDate = fileDate;
                }
                Date beforeStartDate = HRDateTimeUtils.addDay((Date)startDate, (long)-1L);
                return AttFileKDString.getShiftPeriodOverlapTips((String)WTCInteDateUtil.formatDateBySysTzAndUserFmt((Date)beforeStartDate), (String)WTCInteDateUtil.formatDateBySysTzAndUserFmt((Date)startDate));
            }
            Boolean endBoolean = shiftIfOverlapReturnMap.get(attFileCheckService.getEndWsOverlapKey(fileBoId, wsId));
            if (endBoolean != null && endBoolean.booleanValue()) {
                Date fileDate;
                Date endDate = scheduleDy.getDate("bsled");
                if (endDate.after(fileDate = scheduleDy.getDate("attfileid.enddate"))) {
                    endDate = fileDate;
                }
                Date endDateNext = HRDateTimeUtils.addDay((Date)endDate, (long)1L);
                return AttFileKDString.getShiftPeriodOverlapTips((String)WTCInteDateUtil.formatDateBySysTzAndUserFmt((Date)endDate), (String)WTCInteDateUtil.formatDateBySysTzAndUserFmt((Date)endDateNext));
            }
        }
        return null;
    }

    public static String checkDateScope(Map<Long, List<DynamicObject>> scheduleDyGroupMap, DynamicObject scheduleDy, String pageId) {
        long attFileId = scheduleDy.getLong("attfileid.id");
        List<DynamicObject> scheduleDyList = scheduleDyGroupMap.get(attFileId);
        if (CollectionUtils.isEmpty(scheduleDyList)) {
            return null;
        }
        Date beginDate = scheduleDy.getDate(AttFileScheduleEnum.getDateStrByPageId((boolean)true, (String)pageId));
        Date endDate = scheduleDy.getDate(AttFileScheduleEnum.getDateStrByPageId((boolean)false, (String)pageId));
        boolean isOverlap = false;
        Date overlapStart = null;
        Date overlapEnd = null;
        for (DynamicObject row : scheduleDyList) {
            boolean isCurrVersion = row.getBoolean("iscurrentversion");
            String business = row.getString("busistatus");
            long boId = row.getLong("boid");
            if (boId == scheduleDy.getLong("boid") || !isCurrVersion || !"1".equals(business)) continue;
            Date beginDateRow = row.getDate(AttFileScheduleEnum.getDateStrByPageId((boolean)true, (String)pageId));
            Date endDateRow = row.getDate(AttFileScheduleEnum.getDateStrByPageId((boolean)false, (String)pageId));
            if (beginDate.compareTo(endDateRow) > 0 || endDate.compareTo(beginDateRow) < 0) continue;
            isOverlap = true;
            overlapStart = beginDateRow;
            overlapEnd = endDateRow;
            break;
        }
        return null;
    }

    public static String checkBeginDateAndEndDate(DynamicObject scheduleDy, String pageId) {
        String beginDateStr = AttFileScheduleEnum.getDateStrByPageId((boolean)true, (String)pageId);
        String endDateStr = AttFileScheduleEnum.getDateStrByPageId((boolean)false, (String)pageId);
        Date endDate = scheduleDy.getDate(endDateStr);
        Date beginDate = scheduleDy.getDate(beginDateStr);
        if (endDate != null && endDate.before(beginDate)) {
            return ResManager.loadKDString((String)"\u5f00\u59cb\u65e5\u671f\u4e0d\u80fd\u665a\u4e8e\u7ed3\u675f\u65e5\u671f\u3002", (String)"AttFileScheduleCheckHelper_1", (String)"wtc-wtp-business", (Object[])new Object[0]);
        }
        return null;
    }

    public static String checkPeriod(Map<Long, DynamicObject> scheduleDyMap, DynamicObject scheduleDy, String pageId) {
        AttFileScheduleEnum attFileScheduleEnum = AttFileScheduleEnum.getAttFileScheduleEnumByPageId((String)pageId);
        if (!AttFileScheduleEnum.PERIOD.equals((Object)attFileScheduleEnum)) {
            return null;
        }
        Date date = scheduleDy.getDate(AttFileScheduleEnum.getDateStrByPageId((boolean)true, (String)pageId));
        Long periodId = WTCDynamicObjectUtils.getBaseDataId((DynamicObject)scheduleDy, (String)"period");
        DynamicObject period = scheduleDyMap.get(periodId);
        if (period == null) {
            return ResManager.loadKDString((String)"\u6240\u9009\u8003\u52e4\u5468\u671f\u4e0d\u5b58\u5728\uff0c\u8bf7\u7ef4\u62a4\u8003\u52e4\u5468\u671f\u6216\u5c1d\u8bd5\u66f4\u6362\u8003\u52e4\u5468\u671f\u3002", (String)"AttFileScheduleCheckHelper_2", (String)"wtc-wtp-business", (Object[])new Object[0]);
        }
        DynamicObjectCollection periodEntry = period.getDynamicObjectCollection("attperiodentry");
        if (CollectionUtils.isEmpty((Collection)periodEntry)) {
            return ResManager.loadKDString((String)"\u6240\u9009\u8003\u52e4\u5468\u671f\u4e0d\u5b58\u5728\uff0c\u8bf7\u7ef4\u62a4\u8003\u52e4\u5468\u671f\u6216\u5c1d\u8bd5\u66f4\u6362\u8003\u52e4\u5468\u671f\u3002", (String)"AttFileScheduleCheckHelper_2", (String)"wtc-wtp-business", (Object[])new Object[0]);
        }
        List list = periodEntry.stream().sorted(Comparator.comparing(en -> en.getDate("begindate"))).collect(Collectors.toList());
        DynamicObject perioDy = (DynamicObject)list.get(0);
        Date begindate = perioDy.getDate("begindate");
        DynamicObject lastPerioDy = (DynamicObject)list.get(list.size() - 1);
        Date lastEnddate = lastPerioDy.getDate("enddate");
        if (date.before(begindate)) {
            Date preDate = HRDateTimeUtils.addDay((Date)begindate, (long)-1L);
            return String.format(ResManager.loadKDString((String)"\u60a8\u9009\u62e9\u7684\u8003\u52e4\u5468\u671f\u6700\u65e9\u5f00\u59cb\u65e5\u671f\u4e3a%1$s\u3002\u672c\u6b21\u8f93\u5165\u7684\u5f00\u59cb\u65e5\u671f\u65e9\u4e8e%2$s\uff0c\u5c06\u5bfc\u81f4%3$s\u81f3%4$s\u671f\u95f4\u65e0\u6cd5\u751f\u6210\u8003\u52e4\u7ed3\u679c\u3002\u8bf7\u5148\u7ef4\u62a4\u8003\u52e4\u5468\u671f\u3002", (String)"AttFileScheduleCheckHelper_4", (String)"wtc-wtp-business", (Object[])new Object[0]), WTCInteDateUtil.formatDateBySysTzAndUserFmt((Date)begindate), WTCInteDateUtil.formatDateBySysTzAndUserFmt((Date)begindate), WTCInteDateUtil.formatDateBySysTzAndUserFmt((Date)date), WTCInteDateUtil.formatDateBySysTzAndUserFmt((Date)preDate));
        }
        if (date.after(lastEnddate)) {
            return String.format(ResManager.loadKDString((String)"\u6240\u9009\u8003\u52e4\u5468\u671f\u6700\u665a\u7684\u8003\u52e4\u671f\u95f4\u7ed3\u675f\u65e5\u671f\u4e3a%1$s\uff0c\u672c\u6b21\u8f93\u5165\u7684\u5f00\u59cb\u65e5\u671f\u665a\u4e8e\u8be5\u65e5\u671f\uff0c\u4f1a\u5bfc\u81f4%2$s\u8d77\u65e0\u6cd5\u51fa\u8003\u52e4\u7ed3\u679c\uff0c\u8bf7\u5148\u7ef4\u62a4\u8003\u52e4\u5468\u671f\u3002", (String)"AttFileScheduleCheckHelper_5", (String)"wtc-wtp-business", (Object[])new Object[0]), WTCInteDateUtil.formatDateBySysTzAndUserFmt((Date)lastEnddate), WTCInteDateUtil.formatDateBySysTzAndUserFmt((Date)date));
        }
        return null;
    }

    public static String checkFrozeDate(Map<Long, AttStateInfoBO> frozeAllInfoMap, DynamicObject scheduleDy, String pageId) {
        Date startDate = scheduleDy.getDate(AttFileScheduleEnum.getDateStrByPageId((boolean)true, (String)pageId));
        Date endDate = scheduleDy.getDate(AttFileScheduleEnum.getDateStrByPageId((boolean)false, (String)pageId));
        Long attFileBoId = scheduleDy.getLong("attfileid.id");
        AttStateInfoBO attStateInfoBO = frozeAllInfoMap.get(attFileBoId);
        if (attStateInfoBO == null) {
            return null;
        }
        Date frozenStartDate = attStateInfoBO.getFrozenStartDate();
        Date frozenEndDate = attStateInfoBO.getFronzenEnDate();
        if (frozenStartDate == null || frozenEndDate == null) {
            return null;
        }
        if (frozenStartDate.compareTo(endDate) <= 0 && frozenEndDate.compareTo(startDate) >= 0) {
            return String.format(ResManager.loadKDString((String)"\u5df2\u51bb\u7ed3\u7684\u65e5\u671f\u8303\u56f4\u5185\u4e0d\u5141\u8bb8\u7f16\u8f91\u6863\u6848\u4fe1\u606f\uff0c\u5df2\u51bb\u7ed3\u8303\u56f4\uff1a%1$s\u81f3%2$S\u3002", (String)"AttFileScheduleCheckHelper_6", (String)"wtc-wtp-business", (Object[])new Object[0]), WTCInteDateUtil.formatDateBySysTzAndUserFmt((Date)frozenStartDate), WTCInteDateUtil.formatDateBySysTzAndUserFmt((Date)frozenEndDate));
        }
        return null;
    }

    public static String checkStorageToDateNoTime(Map<Long, Date> storageMap, DynamicObject scheduleDy, String pageId) {
        Long attFileBoId = scheduleDy.getLong("attfileid.id");
        Date date = scheduleDy.getDate(AttFileScheduleEnum.getDateStrByPageId((boolean)true, (String)pageId));
        Date sealToDate = storageMap.get(attFileBoId);
        if (sealToDate != null && date != null && !date.after(sealToDate)) {
            return ResManager.loadKDString((String)"\u5f00\u59cb\u65e5\u671f\u53ea\u80fd\u665a\u4e8e\u8be5\u4eba\u5458\u7684\u5df2\u9501\u5b9a\u81f3{0}\u3002", (String)"AttFileScheduleCheckHelper_7", (String)"wtc-wtp-business", (Object[])new Object[]{WTCInteDateUtil.formatDateBySysTzAndUserFmt((Date)sealToDate)});
        }
        return null;
    }

    public static String checkStorageToDate(Map<Long, DynamicObject> scheduleDyMap, Map<Long, Date> storageMap, DynamicObject scheduleDy, String pageId) {
        Long attFileBoId = scheduleDy.getLong("attfileid.id");
        Date sealToDate = storageMap.get(attFileBoId);
        if (sealToDate == null) {
            return null;
        }
        String oldStartDateStr = AttFileScheduleEnum.getDateStrByPageId((boolean)true, (String)pageId);
        String oldEndDateStr = AttFileScheduleEnum.getDateStrByPageId((boolean)false, (String)pageId);
        String key = Objects.requireNonNull(AttFileScheduleEnum.getAttFileScheduleEnumByPageId((String)pageId)).getKey();
        DynamicObject oldDy = scheduleDyMap.get(scheduleDy.getLong("id"));
        Date oldStartDate = null;
        Date oldEndDate = null;
        Long oldScheduleKey = null;
        if (oldDy != null) {
            oldStartDate = oldDy.getDate(oldStartDateStr);
            oldEndDate = oldDy.getDate(oldEndDateStr);
            oldScheduleKey = oldDy.getLong(key + ".id");
        }
        if (oldStartDate == null || oldEndDate == null || oldStartDate.compareTo(sealToDate) > 0) {
            Date startDate = scheduleDy.getDate(AttFileScheduleEnum.getDateStrByPageId((boolean)true, (String)pageId));
            if (startDate.compareTo(sealToDate) <= 0) {
                return ResManager.loadKDString((String)"\u5f00\u59cb\u65e5\u671f\u53ea\u80fd\u665a\u4e8e\u6240\u9009\u4eba\u5458\u7684\u5df2\u9501\u5b9a\u81f3{0}\u3002", (String)"AttFileScheduleCheckHelper_8", (String)"wtc-wtp-business", (Object[])new Object[]{WTCInteDateUtil.formatDateBySysTzAndUserFmt((Date)sealToDate)});
            }
        } else {
            if (oldEndDate.compareTo(sealToDate) < 0) {
                return ResManager.loadKDString((String)"\u4eba\u5458\u5df2\u9501\u5b9a\u81f3{0}\uff0c\u4e0d\u5141\u8bb8\u7f16\u8f91\u6863\u6848\u4fe1\u606f\u3002", (String)"AttFileScheduleCheckHelper_9", (String)"wtc-wtp-business", (Object[])new Object[]{WTCInteDateUtil.formatDateBySysTzAndUserFmt((Date)sealToDate)});
            }
            if (oldStartDate.compareTo(sealToDate) <= 0 && oldEndDate.compareTo(sealToDate) >= 0) {
                Date endDate = scheduleDy.getDate(oldEndDateStr);
                Date startDate = scheduleDy.getDate(oldStartDateStr);
                Object scheduleKey = scheduleDy.get(key);
                Object object = scheduleKey = scheduleKey instanceof DynamicObject ? ((DynamicObject)scheduleKey).getPkValue() : scheduleKey;
                if (oldStartDate.compareTo(startDate) != 0 || !HRObjectUtils.equals((Object)oldScheduleKey, (Object)scheduleKey) || endDate != null && endDate.compareTo(sealToDate) < 0) {
                    return ResManager.loadKDString((String)"\u4eba\u5458\u5df2\u9501\u5b9a\u81f3{0}\uff0c\u4ec5\u5141\u8bb8\u7f16\u8f91\u7ed3\u675f\u65e5\u671f\u3001\u63cf\u8ff0\uff0c\u4e14\u7ed3\u675f\u65e5\u671f\u4e0d\u5141\u8bb8\u65e9\u4e8e\u5df2\u9501\u5b9a\u81f3\u3002", (String)"AttFileScheduleCheckHelper_10", (String)"wtc-wtp-business", (Object[])new Object[]{WTCInteDateUtil.formatDateBySysTzAndUserFmt((Date)sealToDate)});
                }
            }
        }
        return null;
    }

    public static String checkStartDate(Map<Long, DynamicObject> attFileDyMap, ExtendedDataEntity dataEntity, OperateOption operateOption) {
        DynamicObject scheduleDy = dataEntity.getDataEntity();
        String pageId = scheduleDy.getDataEntityType().getName();
        Date date = scheduleDy.getDate(AttFileScheduleEnum.getDateStrByPageId((boolean)true, (String)pageId));
        Date firstBsed = AttFileScheduleCheckHelper.getFirstBsed(attFileDyMap, WTCDynamicObjectUtils.getBaseDataId((DynamicObject)scheduleDy, (String)"attfileid"));
        if (date != null && date.before(firstBsed)) {
            return ResManager.loadKDString((String)"\u5f00\u59cb\u65e5\u671f\u4e0d\u80fd\u65e9\u4e8e\u8be5\u6863\u6848\u7684\u6863\u6848\u5f00\u59cb\u65e5\u671f{0}\u3002", (String)"AttFileScheduleCheckHelper_11", (String)"wtc-wtp-business", (Object[])new Object[]{WTCInteDateUtil.formatDateBySysTzAndUserFmt((Date)firstBsed)});
        }
        return null;
    }

    private static Date getFirstBsed(Map<Long, DynamicObject> attFileDyMap, long attFileId) {
        String tips = ResManager.loadKDString((String)"\u672a\u83b7\u53d6\u5230\u6863\u6848\u6700\u65e9\u751f\u6548\u65e5\u671f", (String)"AttFileScheduleCheckHelper_12", (String)"wtc-wtp-business", (Object[])new Object[0]);
        if (attFileId == 0L) {
            throw new KDBizException(tips);
        }
        DynamicObject attFileDy = attFileDyMap.get(attFileId);
        if (attFileDy == null) {
            throw new KDBizException(tips);
        }
        return attFileDy.getDate("firstbsed");
    }

    public static String checkHaveBeenSet(Map<Long, List<DynamicObject>> scheduleDyGroupMap, DynamicObject scheduleDy, String pageId, Map<Long, Long> checkSelfMap) {
        long attFileBoId = scheduleDy.getLong("attfileid.id");
        List<DynamicObject> scheduleList = scheduleDyGroupMap.get(attFileBoId);
        if (checkSelfMap.get(attFileBoId) != null || !CollectionUtils.isEmpty(scheduleList)) {
            String scheduleName = AttFileScheduleEnum.getScheduleNameByPageId((String)pageId);
            return ResManager.loadKDString((String)"\u8be5\u4eba\u5458\u5df2\u5b58\u5728%s\u3002", (String)"AttFileScheduleCheckHelper_13", (String)"wtc-wtp-business", (Object[])new Object[]{scheduleName});
        }
        checkSelfMap.put(attFileBoId, attFileBoId);
        return null;
    }

    public static boolean checkCardExists(Map<Long, List<DynamicObject>> scheduleDyGroupMap, DynamicObject scheduleDy) {
        if (scheduleDy.getDynamicObjectType().getName().startsWith(AttFileScheduleEnum.CARD.getPageId())) {
            long attFileId = scheduleDy.getLong("attfileid.id");
            return scheduleDyGroupMap.get(attFileId) != null;
        }
        return true;
    }

    public Map<Long, List<kd.bos.dataentity.Tuple<Date, Date>>> checkFileScheduleInterruptDate(List<DynamicObject> fileScheduleList, boolean discard) {
        if (CollectionUtils.isEmpty(fileScheduleList)) {
            return Collections.emptyMap();
        }
        HashMap returnData = Maps.newHashMapWithExpectedSize((int)fileScheduleList.size());
        if (discard) {
            for (DynamicObject dynamicObject : fileScheduleList) {
                ArrayList value = Lists.newArrayListWithExpectedSize((int)1);
                value.add(new kd.bos.dataentity.Tuple((Object)dynamicObject.getDate("startdate"), (Object)dynamicObject.getDate("enddate")));
                returnData.put(dynamicObject.getLong("id"), value);
            }
            return returnData;
        }
        Set fileBoIdSet = fileScheduleList.stream().map(d -> WTCDynamicObjectUtils.getBaseDataId((DynamicObject)d, (String)"attfileid")).collect(Collectors.toSet());
        DynamicObject dynamicObject = fileScheduleList.get(0);
        if (dynamicObject == null) {
            return returnData;
        }
        boolean getFileDate = true;
        Map<Object, Object> fileBoMap = Maps.newHashMapWithExpectedSize((int)16);
        if (dynamicObject.getDate("attfileid.startdate") == null) {
            fileBoMap = AttFileQueryServiceImpl.getInstance().queryAttFileByIds("id,startdate,enddate", new ArrayList(fileBoIdSet)).stream().collect(Collectors.toMap(d -> d.getLong("id"), Function.identity()));
            getFileDate = false;
        }
        AttFileScheduleEnum scheduleEnum = AttFileScheduleEnum.getAttFileScheduleEnumByPageId((String)dynamicObject.getDataEntityType().getExtendName());
        Set scheduleIdSet = fileScheduleList.stream().map(d -> d.getLong("id")).collect(Collectors.toSet());
        AttFileScheduleQueryParam attFileScheduleQueryParam = new AttFileScheduleQueryParam();
        attFileScheduleQueryParam.setFileBoIdSet(fileBoIdSet);
        attFileScheduleQueryParam.setProperties("id,startdate,enddate,attfileid");
        attFileScheduleQueryParam.setqFilter(new QFilter("id", "not in", scheduleIdSet));
        List existScheduleAllList = AttFileScheduleServiceImpl.getInstance().queryAttFileScheduleByList(scheduleEnum, attFileScheduleQueryParam);
        ArrayList allSchList = Lists.newArrayListWithExpectedSize((int)16);
        HRBaseServiceHelper hrBaseServiceHelper = new HRBaseServiceHelper(scheduleEnum.getPageId());
        existScheduleAllList.forEach(d -> this.addOneSchDy(allSchList, hrBaseServiceHelper, (DynamicObject)d));
        fileScheduleList.forEach(d -> this.addOneSchDy(allSchList, hrBaseServiceHelper, (DynamicObject)d));
        Map<Long, List<DynamicObject>> existScheduleMap = allSchList.stream().collect(Collectors.groupingBy(dy -> WTCDynamicObjectUtils.getBaseDataId((DynamicObject)dy, (String)"attfileid")));
        for (DynamicObject currentSchedule : fileScheduleList) {
            this.setScheduleInterruptDate(returnData, getFileDate, fileBoMap, existScheduleMap, currentSchedule);
        }
        return returnData;
    }

    private void setScheduleInterruptDate(Map<Long, List<kd.bos.dataentity.Tuple<Date, Date>>> returnData, boolean getFileDate, Map<Long, DynamicObject> fileBoMap, Map<Long, List<DynamicObject>> existScheduleMap, DynamicObject currentSchedule) {
        long fileBoId = WTCDynamicObjectUtils.getBaseDataId((DynamicObject)currentSchedule, (String)"attfileid");
        List<DynamicObject> existScheduleList = existScheduleMap.get(fileBoId);
        if (CollectionUtils.isEmpty(existScheduleList)) {
            return;
        }
        existScheduleList.sort(Comparator.comparing(d -> d.getDate("startdate")));
        for (int i = 0; i < existScheduleList.size(); ++i) {
            DynamicObject existSchedule = existScheduleList.get(i);
            if (currentSchedule.getLong("id") != existSchedule.getLong("id")) continue;
            ArrayList dateList = Lists.newArrayListWithExpectedSize((int)2);
            if (i == 0) {
                this.addFileStartTupleDate(getFileDate, fileBoMap, currentSchedule, fileBoId, dateList);
                if (i == existScheduleList.size() - 1) {
                    this.addFileEndTupleDate(getFileDate, fileBoMap, currentSchedule, fileBoId, dateList);
                }
                if (i <= existScheduleList.size() - 2) {
                    this.addNextSchTupleDate(currentSchedule, existScheduleList, i, dateList);
                }
            } else if (i == existScheduleList.size() - 1) {
                this.addLastSchTupleDate(currentSchedule, existScheduleList, i, dateList);
                this.addFileEndTupleDate(getFileDate, fileBoMap, currentSchedule, fileBoId, dateList);
            } else {
                this.addLastSchTupleDate(currentSchedule, existScheduleList, i, dateList);
                this.addNextSchTupleDate(currentSchedule, existScheduleList, i, dateList);
            }
            if (CollectionUtils.isEmpty((Collection)dateList)) continue;
            returnData.put(currentSchedule.getLong("id"), dateList);
        }
    }

    private void addNextSchTupleDate(DynamicObject currentSchedule, List<DynamicObject> existScheduleList, int i, List<kd.bos.dataentity.Tuple<Date, Date>> dateList) {
        Date checkDate;
        Date endDate = currentSchedule.getDate("enddate");
        DynamicObject nextDy = existScheduleList.get(i + 1);
        Date nextStartDate = nextDy.getDate("startdate");
        if (nextStartDate.after(checkDate = WTCDateUtils.addDays((Date)endDate, (int)1))) {
            dateList.add((kd.bos.dataentity.Tuple<Date, Date>)new kd.bos.dataentity.Tuple((Object)checkDate, (Object)WTCDateUtils.addDays((Date)nextStartDate, (int)-1)));
        }
    }

    private void addLastSchTupleDate(DynamicObject currentSchedule, List<DynamicObject> existScheduleList, int i, List<kd.bos.dataentity.Tuple<Date, Date>> dateList) {
        DynamicObject lastDy;
        Date lastEndDate;
        Date checkDate;
        Date startDate = currentSchedule.getDate("startdate");
        if (startDate.after(checkDate = WTCDateUtils.addDays((Date)(lastEndDate = (lastDy = existScheduleList.get(i - 1)).getDate("enddate")), (int)1))) {
            dateList.add((kd.bos.dataentity.Tuple<Date, Date>)new kd.bos.dataentity.Tuple((Object)checkDate, (Object)WTCDateUtils.addDays((Date)startDate, (int)-1)));
        }
    }

    private void addOneSchDy(List<DynamicObject> allSchList, HRBaseServiceHelper hrBaseServiceHelper, DynamicObject d) {
        DynamicObject emptyCopyDyObj = hrBaseServiceHelper.generateEmptyDynamicObject();
        emptyCopyDyObj.set("id", (Object)d.getLong("id"));
        emptyCopyDyObj.set("startdate", (Object)d.getDate("startdate"));
        emptyCopyDyObj.set("enddate", (Object)d.getDate("enddate"));
        emptyCopyDyObj.set("attfileid", (Object)WTCDynamicObjectUtils.getBaseDataId((DynamicObject)d, (String)"attfileid"));
        allSchList.add(emptyCopyDyObj);
    }

    private void addFileStartTupleDate(boolean getFileDate, Map<Long, DynamicObject> fileBoMap, DynamicObject currentSchedule, long fileBoId, List<kd.bos.dataentity.Tuple<Date, Date>> dateList) {
        Date fileStartDate;
        Date startDate = currentSchedule.getDate("startdate");
        if (startDate.after(fileStartDate = getFileDate ? currentSchedule.getDate("attfileid.startdate") : fileBoMap.get(fileBoId).getDate("startdate"))) {
            dateList.add((kd.bos.dataentity.Tuple<Date, Date>)new kd.bos.dataentity.Tuple((Object)fileStartDate, (Object)WTCDateUtils.addDays((Date)startDate, (int)-1)));
        }
    }

    private void addFileEndTupleDate(boolean getFileDate, Map<Long, DynamicObject> fileBoMap, DynamicObject currentSchedule, long fileBoId, List<kd.bos.dataentity.Tuple<Date, Date>> dateList) {
        Date endDate;
        Date fileEndDate = getFileDate ? currentSchedule.getDate("attfileid.enddate") : fileBoMap.get(fileBoId).getDate("enddate");
        if (fileEndDate.after(endDate = currentSchedule.getDate("enddate"))) {
            dateList.add((kd.bos.dataentity.Tuple<Date, Date>)new kd.bos.dataentity.Tuple((Object)WTCDateUtils.addDays((Date)endDate, (int)1), (Object)fileEndDate));
        }
    }

    @Deprecated
    public void attPeriodCheck(Set<Long> fileBoIds) {
        if (WTCCollections.isEmpty(fileBoIds)) {
            return;
        }
        Map wtpPeriodScheduleMap = AttFileScheduleServiceImpl.getInstance().queryAttFileSchedule(fileBoIds, AttFileScheduleEnum.PERIOD, false);
        if (WTCCollections.isEmpty((Map)wtpPeriodScheduleMap)) {
            return;
        }
        Map<Long, Set<Long>> obtPeriodIdMap = this.obtPeriodIdMap(wtpPeriodScheduleMap);
        HashSet periodIdSet = Sets.newHashSetWithExpectedSize((int)16);
        obtPeriodIdMap.values().forEach(periodIdSet::addAll);
        LinkedHashMap periodIdCodeNameMap = Maps.newLinkedHashMapWithExpectedSize((int)16);
        Map<Long, Tuple<Date, Date>> timeIntervalMap = this.loadTimeIntervalDate(periodIdSet, periodIdCodeNameMap);
        ArrayList errMsgList = Lists.newArrayList();
        if (WTCCollections.isEmpty(timeIntervalMap)) {
            LOG.warn("\u6839\u636efileBoIds\u672a\u67e5\u8be2\u5230\u8003\u52e4\u671f\u95f4");
            errMsgList.add("attendance cycle data does not exist ");
            if (WTCCollections.isNotEmpty((Collection)errMsgList)) {
                throw new KDBizException(String.join((CharSequence)"\n", errMsgList));
            }
        }
        HashMap<Long, Map<Long, List<Tuple<Date, Date>>>> errMap = new HashMap<Long, Map<Long, List<Tuple<Date, Date>>>>();
        this.doCheck(wtpPeriodScheduleMap, timeIntervalMap, obtPeriodIdMap, errMap);
        if (WTCCollections.isEmpty(errMap)) {
            return;
        }
        this.handleErrMap(errMap, periodIdCodeNameMap, errMsgList);
    }

    public String attPeriodSerialCheck(Set<Long> fileBoIds) {
        if (WTCCollections.isEmpty(fileBoIds)) {
            return "";
        }
        Map wtpPeriodScheduleMap = AttFileScheduleServiceImpl.getInstance().queryAttFileSchedule(fileBoIds, AttFileScheduleEnum.PERIOD, false);
        if (WTCCollections.isEmpty((Map)wtpPeriodScheduleMap)) {
            return "";
        }
        Map<Long, Set<Long>> obtPeriodIdMap = this.obtPeriodIdMap(wtpPeriodScheduleMap);
        HashSet periodIdSet = Sets.newHashSetWithExpectedSize((int)16);
        obtPeriodIdMap.values().forEach(periodIdSet::addAll);
        LinkedHashMap periodIdCodeNameMap = Maps.newLinkedHashMapWithExpectedSize((int)16);
        Map<Long, Tuple<Date, Date>> timeIntervalMap = this.loadTimeIntervalDate(periodIdSet, periodIdCodeNameMap);
        ArrayList errMsgList = Lists.newArrayList();
        if (WTCCollections.isEmpty(timeIntervalMap)) {
            LOG.warn("\u6839\u636efileBoIds\u672a\u67e5\u8be2\u5230\u8003\u52e4\u671f\u95f4");
            errMsgList.add("attendance cycle data does not exist ");
            if (WTCCollections.isNotEmpty((Collection)errMsgList)) {
                return String.join((CharSequence)"\n", errMsgList);
            }
        }
        HashMap<Long, Map<Long, List<Tuple<Date, Date>>>> errMap = new HashMap<Long, Map<Long, List<Tuple<Date, Date>>>>();
        this.doCheck(wtpPeriodScheduleMap, timeIntervalMap, obtPeriodIdMap, errMap);
        if (WTCCollections.isEmpty(errMap)) {
            return "";
        }
        return this.handleErrMap(errMap, periodIdCodeNameMap, errMsgList);
    }

    public Set<Long> getCheckParam(DynamicObject[] attFileSchDys) {
        HashSet boIdSets = Sets.newHashSetWithExpectedSize((int)16);
        if (ArrayUtils.isNotEmpty((Object[])attFileSchDys)) {
            String name = attFileSchDys[0].getDataEntityType().getName();
            if ("wtp_attfilebase".equals(name) || "wtp_vafilebase".equals(name)) {
                for (DynamicObject dataEntity : attFileSchDys) {
                    long baseDataId = WTCDynamicObjectUtils.getBaseDataId((DynamicObject)dataEntity, (String)"period");
                    if (baseDataId == 0L) continue;
                    boIdSets.add(dataEntity.getLong("boid"));
                }
                return boIdSets;
            }
            for (DynamicObject dataEntity : attFileSchDys) {
                if (!dataEntity.getDataEntityType().getName().startsWith(AttFileScheduleEnum.PERIOD.getPageId())) continue;
                boIdSets.add(WTCDynamicObjectUtils.getBaseDataId((DynamicObject)dataEntity, (String)"attfileid"));
            }
        }
        return boIdSets;
    }

    private String handleErrMap(Map<Long, Map<Long, List<Tuple<Date, Date>>>> errMap, Map<Long, String> periodIdCodeNameMap, List<String> errMsgList) {
        HashSet<Long> errBoIdSets = new HashSet<Long>(errMap.keySet());
        AttFileQueryParam attFileQueryParam = new AttFileQueryParam(false);
        attFileQueryParam.setSetBoIds(errBoIdSets);
        String selectFiles = WTCStringUtils.joinStr((String[])new String[]{"boid", ",", "number", ",", "name"});
        attFileQueryParam.setProperties(selectFiles);
        List attFileBases = AttFileQueryServiceImpl.getInstance().queryAttFiles(attFileQueryParam);
        Map<Long, String> boIdNumberMap = attFileBases.stream().collect(Collectors.toMap(dy -> dy.getLong("boid"), dy -> dy.getString("number"), (a, b) -> b));
        for (Map.Entry<Long, Map<Long, List<Tuple<Date, Date>>>> entry : errMap.entrySet()) {
            Long errBoId = entry.getKey();
            Map<Long, List<Tuple<Date, Date>>> errPeriodMap = entry.getValue();
            for (Map.Entry<Long, List<Tuple<Date, Date>>> e : errPeriodMap.entrySet()) {
                Long errPeriodId = e.getKey();
                List<Tuple<Date, Date>> errTupleList = e.getValue();
                if (CollectionUtils.isEmpty(errTupleList)) continue;
                Date startDate = (Date)errTupleList.get(0).getKey();
                Date endDate = (Date)errTupleList.get(0).getValue();
                String errBoNumber = boIdNumberMap.get(errBoId);
                String errMgs = this.getCheckErrMgs(errBoNumber, periodIdCodeNameMap.get(errPeriodId), startDate, endDate);
                errMsgList.add(errMgs);
            }
        }
        if (WTCCollections.isNotEmpty(errMsgList)) {
            return String.join((CharSequence)"\n", errMsgList);
        }
        return "";
    }

    private String getCheckErrMgs(String errBoNumber, String errPeriodId, Date startDate, Date endDate) {
        String errMsgFmt = ResManager.loadKDString((String)"\u8003\u52e4\u6863\u6848\u5728{0}\u81f3{1}\u65e5\u671f\u8303\u56f4\u5185\uff0c\u8003\u52e4\u5468\u671f\u201c{2}\u201d\u672a\u751f\u6210\u4eba\u5458\u8003\u52e4\u671f\u95f4\u6570\u636e\uff0c\u5c06\u4f1a\u5bfc\u81f4\u6838\u7b97\u62a5\u9519\uff0c\u8bf7\u66f4\u65b0\u8003\u52e4\u5468\u671f\uff08\u9519\u8bef\u7801\uff1aE2001\uff09\u3002", (String)"AttFileWorkScheduleService_02", (String)"wtc-wtp-business", (Object[])new Object[0]);
        String errMsg = MessageFormat.format(errMsgFmt, WTCInteDateUtil.formatDateBySysTzAndUserFmt((Date)startDate), WTCInteDateUtil.formatDateBySysTzAndUserFmt((Date)endDate), errPeriodId);
        return errMsg;
    }

    private Map<Long, Set<Long>> obtPeriodIdMap(Map<Long, List<DynamicObject>> wtpPeriodScheduleMap) {
        HashMap<Long, Set<Long>> periodIdMap = new HashMap<Long, Set<Long>>();
        if (wtpPeriodScheduleMap != null && !wtpPeriodScheduleMap.isEmpty()) {
            for (Map.Entry<Long, List<DynamicObject>> entry : wtpPeriodScheduleMap.entrySet()) {
                HashSet periodIdSet = Sets.newHashSetWithExpectedSize((int)16);
                for (DynamicObject dy : entry.getValue()) {
                    long baseDataId = WTCDynamicObjectUtils.getBaseDataId((DynamicObject)dy, (String)"period.id");
                    periodIdSet.add(baseDataId);
                    periodIdMap.put(entry.getKey(), periodIdSet);
                }
            }
        }
        return periodIdMap;
    }

    private Map<Long, Tuple<Date, Date>> loadTimeIntervalDate(Set<Long> periodIdSet, Map<Long, String> periodIdCodeNameMap) {
        HashMap<Long, Tuple<Date, Date>> mapRes = new HashMap<Long, Tuple<Date, Date>>();
        HRBaseServiceHelper scheduleHelper = new HRBaseServiceHelper("wtp_attperiodentry");
        DynamicObject[] masterList = scheduleHelper.queryOriginalArray("masterid.id , begindate , enddate , masterid.number , masterid.name ", new QFilter[]{new QFilter("masterid", "in", periodIdSet)});
        if (masterList == null || masterList.length == 0) {
            return mapRes;
        }
        Map<Long, List<DynamicObject>> periodDyMap = Arrays.stream(masterList).collect(Collectors.groupingBy(d -> WTCDynamicObjectUtils.getBaseDataId((DynamicObject)d, (String)"masterid.id")));
        for (Map.Entry<Long, List<DynamicObject>> entries : periodDyMap.entrySet()) {
            List<DynamicObject> value = entries.getValue();
            if (!kd.bos.util.CollectionUtils.isNotEmpty(value)) continue;
            value.sort(Comparator.comparing(d -> d.getDate("begindate")));
            DynamicObject dy0 = value.get(0);
            DynamicObject dyH = value.get(value.size() - 1);
            if (dy0 == null || dyH == null) continue;
            String name = dy0.getString("masterid.name");
            periodIdCodeNameMap.put(entries.getKey(), name);
            mapRes.put(entries.getKey(), (Tuple<Date, Date>)new Tuple((Object)dy0.getDate("begindate"), (Object)dyH.getDate("enddate")));
        }
        return mapRes;
    }

    private boolean doCheck(Map<Long, List<DynamicObject>> wtpPeriodScheduleMap, Map<Long, Tuple<Date, Date>> timeIntervalMap, Map<Long, Set<Long>> obtPeriodIdMap, Map<Long, Map<Long, List<Tuple<Date, Date>>>> errMap) {
        boolean isTrue = true;
        for (Map.Entry<Long, List<DynamicObject>> entry : wtpPeriodScheduleMap.entrySet()) {
            Long periodId;
            Long attFileBaseId = entry.getKey();
            List<DynamicObject> periodList = entry.getValue();
            if (kd.bos.util.CollectionUtils.isEmpty(periodList)) continue;
            Set<Long> periodSets = obtPeriodIdMap.get(attFileBaseId);
            periodList.sort(Comparator.comparing(d -> d.getDate("bsed")));
            int h = periodList.size() - 1;
            DynamicObject lastDy = periodList.get(h);
            List newPeriodList = IntStream.range(0, h).mapToObj(periodList::get).collect(Collectors.toCollection(() -> Lists.newArrayListWithExpectedSize((int)16)));
            if (kd.bos.util.CollectionUtils.isNotEmpty((Collection)newPeriodList)) {
                for (DynamicObject periodObj : newPeriodList) {
                    Long periodId2 = WTCDynamicObjectUtils.getBaseDataId((DynamicObject)periodObj, (String)"period.id");
                    if (!periodSets.contains(periodId2) || this.checks(attFileBaseId, periodId2, periodObj, timeIntervalMap.get(periodId2), errMap)) continue;
                    isTrue = false;
                }
            }
            if (!periodSets.contains(periodId = Long.valueOf(WTCDynamicObjectUtils.getBaseDataId((DynamicObject)lastDy, (String)"period.id"))) || this.checkLastInterval(attFileBaseId, periodId, lastDy, timeIntervalMap.get(periodId), errMap)) continue;
            isTrue = false;
        }
        return isTrue;
    }

    private boolean checkLastInterval(Long attFileBaseId, Long periodId, DynamicObject lastDy, Tuple<Date, Date> dateDateTuple, Map<Long, Map<Long, List<Tuple<Date, Date>>>> errMap) {
        Date periodStart = lastDy.getDate("bsed");
        Date periodEdn = lastDy.getDate("bsled");
        Date intervalStart = (Date)dateDateTuple.getKey();
        Date intervalEnd = (Date)dateDateTuple.getValue();
        if (periodStart.getTime() < intervalStart.getTime() || periodStart.getTime() > intervalEnd.getTime()) {
            Tuple dateTuple = new Tuple((Object)periodStart, (Object)periodEdn);
            this.fillErrMap(attFileBaseId, periodId, (Tuple<Date, Date>)dateTuple, errMap);
            return false;
        }
        return true;
    }

    private boolean checks(Long attFileBaseId, Long periodId, DynamicObject periodObj, Tuple<Date, Date> dateDateTuple, Map<Long, Map<Long, List<Tuple<Date, Date>>>> errMap) {
        Date periodStart = periodObj.getDate("bsed");
        Date periodEdn = periodObj.getDate("bsled");
        Date intervalStart = (Date)dateDateTuple.getKey();
        Date intervalEnd = (Date)dateDateTuple.getValue();
        if (intervalEnd.getTime() < periodStart.getTime() || intervalStart.getTime() > periodEdn.getTime()) {
            Tuple dateTuple = new Tuple((Object)periodStart, (Object)periodEdn);
            this.fillErrMap(attFileBaseId, periodId, (Tuple<Date, Date>)dateTuple, errMap);
        } else {
            Tuple dateTuple;
            if (intervalStart.getTime() >= periodStart.getTime()) {
                dateTuple = new Tuple((Object)periodStart, (Object)WTCDateUtils.add((Date)intervalStart, (int)5, (int)-1));
                this.fillErrMap(attFileBaseId, periodId, (Tuple<Date, Date>)dateTuple, errMap);
            }
            if (intervalEnd.getTime() <= periodEdn.getTime()) {
                dateTuple = new Tuple((Object)WTCDateUtils.add((Date)intervalEnd, (int)5, (int)1), (Object)periodEdn);
                this.fillErrMap(attFileBaseId, periodId, (Tuple<Date, Date>)dateTuple, errMap);
            }
        }
        return MapUtils.isEmpty(errMap);
    }

    private void fillErrMap(Long attFileBaseId, Long periodId, Tuple<Date, Date> dateTuple, Map<Long, Map<Long, List<Tuple<Date, Date>>>> errMap) {
        if (Objects.isNull(dateTuple)) {
            return;
        }
        if (Objects.nonNull(dateTuple.getKey()) && Objects.nonNull(dateTuple.getValue()) && ((Date)dateTuple.getKey()).getTime() > ((Date)dateTuple.getValue()).getTime()) {
            return;
        }
        if (errMap.containsKey(attFileBaseId)) {
            Map<Long, List<Tuple<Date, Date>>> periodTupleListMap = errMap.get(attFileBaseId);
            if (periodTupleListMap.containsKey(periodId)) {
                List<Tuple<Date, Date>> tuples = periodTupleListMap.get(periodId);
                tuples.add(dateTuple);
                periodTupleListMap.put(periodId, tuples);
            } else {
                ArrayList tuples = Lists.newArrayListWithCapacity((int)16);
                tuples.add(dateTuple);
                periodTupleListMap.put(periodId, tuples);
            }
        } else {
            HashMap periodTupleListMap = Maps.newHashMapWithExpectedSize((int)16);
            ArrayList tuples = Lists.newArrayListWithCapacity((int)16);
            tuples.add(dateTuple);
            periodTupleListMap.put(periodId, tuples);
            errMap.put(attFileBaseId, periodTupleListMap);
        }
    }
}

