/*
 * Decompiled with CFR 0.152.
 */
package kd.wtc.wtp.business.attfile.schedule;

import com.alibaba.fastjson.JSON;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import kd.bos.bill.BillShowParameter;
import kd.bos.bill.OperationStatus;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.ShowType;
import kd.bos.list.ListShowParameter;
import kd.bos.mvc.list.ListView;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.servicehelper.permission.PermissionServiceHelper;
import kd.hr.hbp.business.servicehelper.HRBaseServiceHelper;
import kd.wtc.wtbs.business.relate.WTCLeftRelateService;
import kd.wtc.wtbs.business.web.file.AttFileQueryServiceImpl;
import kd.wtc.wtbs.common.enums.AttFileScheduleEnum;
import kd.wtc.wtbs.common.enums.file.FileTypeEnum;
import kd.wtc.wtbs.common.model.attfile.AttFileQueryParam;
import kd.wtc.wtbs.common.util.WTCDateUtils;

public class AttFileSchedulePageService {
    public static long getAttFileVid(long attFileBoId, Date date) {
        AttFileQueryParam attFileQueryParam = new AttFileQueryParam(false);
        HashSet<Long> set = new HashSet<Long>(2);
        set.add(attFileBoId);
        attFileQueryParam.setSetBoIds(set);
        attFileQueryParam.setBeCurrent(Boolean.FALSE);
        attFileQueryParam.setProperties(AttFileQueryParam.baseProperties);
        Date endTime = WTCDateUtils.getDayStartTime((Date)date);
        List attFileDyList = AttFileQueryServiceImpl.getInstance().queryAttFiles(attFileQueryParam);
        List dynamicObjects = attFileDyList.stream().filter(item -> endTime.compareTo(item.getDate("bsed")) >= 0 && endTime.compareTo(item.getDate("bsled")) <= 0).collect(Collectors.toList());
        if (!CollectionUtils.isEmpty(dynamicObjects)) {
            return ((DynamicObject)dynamicObjects.get(0)).getLong("id");
        }
        return 0L;
    }

    public static void genShowScheduleDetails(IFormView view, AttFileScheduleEnum[] values) {
        view.getPageCache().put(JSON.toJSONString((Object)values), "true");
        for (AttFileScheduleEnum scheduleEnum : values) {
            Object fileType = view.getFormShowParameter().getCustomParam("filetype");
            if (!FileTypeEnum.ATTFILE.getFileType().equals(scheduleEnum.getFileType()) && !scheduleEnum.getFileType().equals(fileType)) {
                view.setVisible(Boolean.FALSE, new String[]{scheduleEnum.getOutFlexKey()});
                view.setVisible(Boolean.FALSE, new String[]{scheduleEnum.getCardFlexKey()});
                continue;
            }
            String pageId = scheduleEnum.getPageId();
            long userId = RequestContext.get().getCurrUserId();
            boolean hasViewPermission = PermissionServiceHelper.checkPermission((Long)userId, (String)view.getFormShowParameter().getAppId(), (String)pageId, (String)"47150e89000000ac");
            if (!hasViewPermission) {
                view.setVisible(Boolean.FALSE, new String[]{scheduleEnum.getOutFlexKey()});
                view.setVisible(Boolean.FALSE, new String[]{scheduleEnum.getCardFlexKey()});
                continue;
            }
            AttFileSchedulePageService.genDetailsScheduleList(view, scheduleEnum, pageId);
            AttFileSchedulePageService.genDetailsScheduleCard(view, scheduleEnum);
        }
    }

    private static void genDetailsScheduleCard(IFormView view, AttFileScheduleEnum scheduleEnum) {
        FormShowParameter parameter = new FormShowParameter();
        parameter.getOpenStyle().setShowType(ShowType.InContainer);
        parameter.getOpenStyle().setTargetKey(scheduleEnum.getCardFlexKey());
        parameter.setFormId("wtp_commonschedulecard");
        parameter.setCustomParam("boid", view.getFormShowParameter().getCustomParam("boid"));
        parameter.setCustomParam("currentRelatePage", (Object)scheduleEnum.getPageId());
        parameter.setCustomParam("attfileid", view.getFormShowParameter().getCustomParam("attfileid"));
        parameter.setCustomParam("name", (Object)scheduleEnum.getScheduleName());
        parameter.setHasRight(true);
        view.showForm(parameter);
    }

    private static void genDetailsScheduleList(IFormView view, AttFileScheduleEnum scheduleEnum, String pageId) {
        ListShowParameter parameter = new ListShowParameter();
        parameter.getOpenStyle().setShowType(ShowType.InContainer);
        parameter.getOpenStyle().setTargetKey(scheduleEnum.getInnerFlexKey());
        parameter.setFormId("wtp_schedulerimlesslist");
        parameter.setBillFormId(pageId);
        parameter.setCustomParam("currentRelatePage", (Object)pageId);
        HashMap<String, Object> map = new HashMap<String, Object>(2);
        map.put("boid", view.getFormShowParameter().getCustomParam("boid"));
        parameter.setCustomParam("customvariables", map);
        parameter.setCustomParam("attfileid", view.getFormShowParameter().getCustomParam("attfileid"));
        parameter.setCustomParam("boid", view.getFormShowParameter().getCustomParam("boid"));
        parameter.setCustomParam("listsource", (Object)"details");
        parameter.setHasRight(true);
        view.showForm((FormShowParameter)parameter);
        view.getPageCache().put(pageId, parameter.getPageId());
    }

    public static void addOp(IFormView view, Object boId, String isBaseSche, Object pkValue, Object attFileBoId) {
        BillShowParameter parameter = new BillShowParameter();
        parameter.setFormId(((ListView)view).getBillFormId());
        parameter.getOpenStyle().setShowType(ShowType.Modal);
        parameter.setParentPageId(view.getPageId());
        if (boId != null) {
            parameter.setPkId(boId);
            parameter.setCustomParam("isAddNew", (Object)"false");
        } else {
            parameter.setCustomParam("isAddNew", (Object)"true");
        }
        if (WTCLeftRelateService.isShowTopCommonSearch((IFormView)view)) {
            parameter.setCustomParam("attfileid", attFileBoId);
        } else {
            Map customParam = (Map)view.getFormShowParameter().getCustomParam("customvariables");
            if (customParam != null && customParam.get("boid") != null) {
                Object attFileId = ((Map)view.getFormShowParameter().getCustomParam("customvariables")).get("boid");
                parameter.setCustomParam("attfileid", attFileId);
            } else {
                Object attFileBoIdTag = attFileBoId != null ? attFileBoId : view.getFormShowParameter().getCustomParam("attfileid");
                attFileBoIdTag = attFileBoIdTag != null ? attFileBoIdTag : view.getFormShowParameter().getCustomParam("boid");
                parameter.setCustomParam("attfileid", attFileBoIdTag);
            }
        }
        parameter.setCustomParam("isBaseSche", (Object)isBaseSche);
        if (pkValue != null) {
            parameter.setCustomParam("rowid", pkValue);
            parameter.setStatus(OperationStatus.EDIT);
        } else {
            parameter.setCustomParam("isHavePlan", view.getFormShowParameter().getCustomParam("isHavePlan"));
            parameter.setStatus(OperationStatus.ADDNEW);
        }
        parameter.setCustomParam("operation", (Object)"edit");
        view.showForm((FormShowParameter)parameter);
    }

    public static void modifyOp(IFormView view, Object pkId) {
        BillShowParameter parameter = new BillShowParameter();
        parameter.setFormId(((ListView)view).getBillFormId());
        parameter.getOpenStyle().setShowType(ShowType.Modal);
        String formName = view.getFormShowParameter().getFormName().replace(ResManager.loadKDString((String)"\u5217\u8868", (String)"AttFileSchedulePageService_1", (String)"wtc-wtp-business", (Object[])new Object[0]), "");
        parameter.setParentPageId(view.getPageId());
        parameter.setStatus(OperationStatus.EDIT);
        parameter.setPkId(pkId);
        Object attFileId = AttFileSchedulePageService.getAttFileBoId((ListView)view, pkId);
        parameter.setCustomParam("attfileid", attFileId);
        parameter.setCustomParam("isBaseSche", (Object)"false");
        parameter.setCustomParam("rowid", pkId);
        parameter.setCustomParam("operation", (Object)"editrule");
        if (WTCLeftRelateService.isShowTopCommonSearch((IFormView)view)) {
            parameter.setCustomParam("is_show_top_common_search", (Object)Boolean.TRUE);
        }
        view.showForm((FormShowParameter)parameter);
    }

    private static Object getAttFileBoId(ListView view, Object pkId) {
        HRBaseServiceHelper helper = new HRBaseServiceHelper(view.getBillFormId());
        DynamicObject dynamicObject = helper.queryOne("boid,attfileid", pkId);
        return dynamicObject.get("attfileid.id");
    }

    public static void showHisVersion(IFormView view, Object pkId) {
        String billFormId = ((ListView)view).getBillFormId();
        HRBaseServiceHelper helper = new HRBaseServiceHelper(billFormId);
        DynamicObject boidDy = helper.queryOne("boid", new QFilter("id", "=", pkId));
        long boid = 0L;
        if (boidDy != null) {
            boid = boidDy.getLong("boid");
        }
        ListShowParameter parameter = new ListShowParameter();
        parameter.getOpenStyle().setShowType(ShowType.MainNewTabPage);
        parameter.setBillFormId(billFormId);
        ArrayList<QFilter> qFilters = new ArrayList<QFilter>(1);
        qFilters.add(new QFilter("boid", "=", (Object)boid));
        parameter.getListFilterParameter().setQFilters(qFilters);
        String formName = view.getFormShowParameter().getFormName().replace(ResManager.loadKDString((String)"\u5217\u8868", (String)"AttFileSchedulePageService_1", (String)"wtc-wtp-business", (Object[])new Object[0]), "");
        String caption = ResManager.loadKDString((String)"%s\u53d8\u66f4\u8bb0\u5f55", (String)"AttFileSchedulePageService_6", (String)"wtc-wtp-business", (Object[])new Object[]{formName});
        parameter.setCaption(caption);
        parameter.setCustomParam("isShowHisVersion", (Object)Boolean.TRUE);
        parameter.setCustomParam("fromPage", (Object)"fromHisAction");
        parameter.setCustomParam("boid", AttFileSchedulePageService.getAttFileBoId((ListView)view, pkId));
        view.showForm((FormShowParameter)parameter);
    }

    public static void refreshList(IFormView view) {
        IFormView parentView = view.getParentView();
        if (parentView != null) {
            parentView.invokeOperation("refresh");
            view.sendFormAction(parentView);
        }
    }

    public static QFilter getScheduleDateFileters(Object beginDate, Object endDate, boolean isHisTime) {
        String endDateStr;
        String startDateStr;
        if (isHisTime) {
            startDateStr = "bsed";
            endDateStr = "bsled";
        } else {
            startDateStr = "startdate";
            endDateStr = "enddate";
        }
        QFilter qFilters = new QFilter(startDateStr, "<=", endDate).and(new QFilter(endDateStr, ">=", endDate));
        qFilters.or(new QFilter(startDateStr, ">=", beginDate).and(new QFilter(endDateStr, "<=", endDate)));
        qFilters.or(new QFilter(startDateStr, "<=", beginDate).and(new QFilter(endDateStr, ">=", beginDate)));
        return qFilters;
    }

    public static DynamicObject queryAttFileDyByBoid(Long boid) {
        HRBaseServiceHelper helper = new HRBaseServiceHelper("wtp_attfilebase");
        QFilter qFilter = new QFilter("boid", "=", (Object)boid);
        qFilter.and(new QFilter("iscurrentversion", "=", (Object)Boolean.TRUE));
        return helper.loadDynamicObject(qFilter);
    }
}

