/*
 * Decompiled with CFR 0.152.
 */
package kd.wtc.wtp.business.attfile.schedule;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.utils.ArrayUtils;
import kd.bos.db.DB;
import kd.bos.orm.ORM;
import kd.bos.orm.query.QFilter;
import kd.hr.hbp.business.domain.model.newhismodel.HisVersionParamBo;
import kd.hr.hbp.business.servicehelper.HRBaseServiceHelper;
import kd.hr.hbp.common.constants.newhismodel.EnumHisOperateType;
import kd.hr.hbp.common.util.HRDynamicObjectUtils;
import kd.wtc.wtbs.business.history.service.WTCCommonHisService;
import kd.wtc.wtbs.common.enums.AttFileScheduleEnum;
import kd.wtc.wtbs.common.util.WTCCollectionIndexUtil;
import kd.wtc.wtbs.common.util.WTCCollections;
import kd.wtc.wtbs.common.util.third.collect.Lists;
import kd.wtc.wtbs.common.util.third.collect.Maps;
import kd.wtc.wtbs.common.util.third.collect.Sets;
import kd.wtc.wtp.business.attfile.AttFileHelper;
import kd.wtc.wtp.business.attfile.schedule.AttFileScheduleBusiness;
import kd.wtc.wtp.business.attfile.schedule.AttFileScheduleCheckHelper;
import kd.wtc.wtp.business.attfile.schedule.IAttFileScheduleService;

public class AttFileScheduleServiceImpl
implements IAttFileScheduleService {
    public static AttFileScheduleServiceImpl getInstance() {
        return SingletonInstance.singleton;
    }

    @Override
    public void saveAttFileSchedule(DynamicObject[] fileEntities, Long eventId, List<Map<String, String>> rosterSynDataList) {
        if (fileEntities == null || fileEntities.length == 0) {
            return;
        }
        if (eventId == null || eventId == 0L) {
            eventId = DB.genGlobalLongId();
        }
        List<Map<String, String>> dataList = null;
        ArrayList listHisVersionParamBo = Lists.newArrayListWithCapacity((int)AttFileScheduleEnum.values().length);
        for (AttFileScheduleEnum scheduleEnum : AttFileScheduleEnum.values()) {
            HisVersionParamBo hisVersionParamBo = this.getAttFileHisVersionParamBo(fileEntities, scheduleEnum);
            if (hisVersionParamBo == null) continue;
            listHisVersionParamBo.add(hisVersionParamBo);
            if (scheduleEnum != AttFileScheduleEnum.WS) continue;
            dataList = AttFileScheduleBusiness.getSyncRosterParam(hisVersionParamBo.getHisDyns());
        }
        if (WTCCollections.isNotEmpty((Collection)listHisVersionParamBo)) {
            WTCCommonHisService.batchSaveTimeHisModelData((List)listHisVersionParamBo, (Long)eventId);
        }
        if (dataList != null && !dataList.isEmpty()) {
            rosterSynDataList.addAll((Collection<Map<String, String>>)dataList);
        }
        Set<Long> checkParam = AttFileScheduleCheckHelper.getInstance().getCheckParam(fileEntities);
        AttFileScheduleCheckHelper.getInstance().attPeriodCheck(checkParam);
    }

    private Map<Long, Long> getAttFileIdAndWSIDMap(DynamicObject[] hisDyArr) {
        if (hisDyArr != null && hisDyArr.length > 0) {
            HashMap requestMap = Maps.newHashMapWithExpectedSize((int)hisDyArr.length);
            for (DynamicObject dy : hisDyArr) {
                requestMap.put(dy.getLong("attfilevid"), dy.getLong(AttFileScheduleEnum.WS.getKey() + "." + "id"));
            }
            return requestMap;
        }
        return null;
    }

    @Override
    public void addAttFileBaseSchedule(DynamicObject[] scheduleEntities, Long mainBoId) {
        int i;
        DynamicObject[] newDys = new DynamicObject[scheduleEntities.length];
        for (i = 0; i < newDys.length; ++i) {
            newDys[i] = (DynamicObject)scheduleEntities[i].getDataEntityType().createInstance();
        }
        for (i = 0; i < newDys.length; ++i) {
            HRDynamicObjectUtils.copy((DynamicObject)scheduleEntities[i], (DynamicObject)newDys[i], (Set)Sets.newHashSet((Object[])new String[]{"id"}));
            if (scheduleEntities[i].getDataEntityState().getFromDatabase()) continue;
            newDys[i].set("id", scheduleEntities[i].get("id"));
        }
        WTCCollectionIndexUtil.getEleFromArr((Object[])scheduleEntities, (int)0).ifPresent(ele -> WTCCommonHisService.saveTimeHisModelData((DynamicObject[])newDys, (String)ele.getDataEntityType().getName(), (Long)mainBoId, (boolean)Boolean.FALSE, (boolean)Boolean.TRUE));
        for (i = 0; i < newDys.length; ++i) {
            if (scheduleEntities[i].getDataEntityState().getFromDatabase()) continue;
            scheduleEntities[i].set("id", newDys[i].get("id"));
        }
    }

    @Override
    public void addAttFileRuleSchedule(DynamicObject[] scheduleEntities, Long mainBoId, String isAddNew, String importType) {
        if (scheduleEntities == null || scheduleEntities.length == 0) {
            return;
        }
        List<Object> saveList = Lists.newArrayListWithExpectedSize((int)scheduleEntities.length);
        String name = scheduleEntities[0].getDynamicObjectType().getName();
        HRBaseServiceHelper serviceHelper = new HRBaseServiceHelper(name);
        if ("new".equals(importType)) {
            saveList = Arrays.stream(scheduleEntities).collect(Collectors.toList());
        } else {
            for (DynamicObject scheduleEntity : scheduleEntities) {
                DynamicObject emptyDynamicObject = serviceHelper.generateEmptyDynamicObject();
                AttFileHelper.copySaveNotTimeHisModelData(scheduleEntity, emptyDynamicObject, isAddNew);
                saveList.add(emptyDynamicObject);
            }
        }
        WTCCommonHisService.saveNotTimeHisModelData((List)saveList, null, (String)scheduleEntities[0].getDataEntityType().getName(), (Long)mainBoId);
    }

    @Override
    public void queryAttFileSchedule(List<Long> attFileIds) {
    }

    @Override
    public void deleteOp(DynamicObject[] scheduleEntities) {
        if (ArrayUtils.isEmpty((Object[])scheduleEntities)) {
            return;
        }
        List ids = Arrays.stream(scheduleEntities).map(dataEntity -> dataEntity.getLong("id")).collect(Collectors.toList());
        QFilter qFilter = new QFilter("id", "in", ids);
        HRBaseServiceHelper helper = new HRBaseServiceHelper(scheduleEntities[0].getDataEntityType().getName());
        DynamicObject[] dys = helper.queryOriginalArray("boid", new QFilter[]{qFilter});
        List boIdList = Arrays.stream(dys).map(dy -> dy.getLong("boid")).collect(Collectors.toList());
        WTCCommonHisService.deleteBo((String)scheduleEntities[0].getDataEntityType().getName(), boIdList);
    }

    private HisVersionParamBo getAttFileHisVersionParamBo(DynamicObject[] fileEntities, AttFileScheduleEnum scheduleEnum) {
        ArrayList dynamicObjectList = Lists.newArrayList();
        long[] genLongIds = ORM.create().genLongIds(scheduleEnum.getPageId(), fileEntities.length);
        int size = fileEntities.length;
        for (int i = 0; i < size; ++i) {
            DynamicObject fileEntity = fileEntities[i];
            DynamicObject scheduleDy = AttFileScheduleBusiness.genNewFileSchDy(scheduleEnum, genLongIds[i], fileEntity);
            if (scheduleDy == null) continue;
            dynamicObjectList.add(scheduleDy);
        }
        if (dynamicObjectList.isEmpty()) {
            return null;
        }
        DynamicObject[] scheduleHisDynamicObjects = new DynamicObject[dynamicObjectList.size()];
        dynamicObjectList.toArray(scheduleHisDynamicObjects);
        HisVersionParamBo hisVersionParamBo = new HisVersionParamBo();
        hisVersionParamBo.setHisDyns(scheduleHisDynamicObjects);
        hisVersionParamBo.setEntityNumber(scheduleEnum.getPageId());
        hisVersionParamBo.setMainBoId(Long.valueOf(DB.genGlobalLongId()));
        hisVersionParamBo.setOperateType(EnumHisOperateType.SAVE_VERSION.getType());
        return hisVersionParamBo;
    }

    private static class SingletonInstance {
        private static final AttFileScheduleServiceImpl singleton = new AttFileScheduleServiceImpl();

        private SingletonInstance() {
        }
    }
}

