/*
 * Decompiled with CFR 0.152.
 */
package kd.wtc.wtp.business.attperiod;

import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.Function;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.clr.DataEntityPropertyCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.exception.ErrorCode;
import kd.bos.exception.KDBizException;
import kd.bos.form.IFormView;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.field.FieldEdit;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.servicehelper.MetadataServiceHelper;
import kd.hr.hbp.business.servicehelper.HRBaseServiceHelper;
import kd.hr.hbp.common.util.HRDateTimeUtils;
import kd.hr.hbp.common.util.HRObjectUtils;
import kd.hr.hbp.common.util.HRStringUtils;
import kd.wtc.wtbs.business.history.service.WTCSnapService;
import kd.wtc.wtbs.business.web.file.schedule.AttFileScheduleServiceImpl;
import kd.wtc.wtbs.common.enums.AttFileScheduleEnum;
import kd.wtc.wtbs.common.model.attfile.AttFileScheduleQueryParam;
import kd.wtc.wtbs.common.util.WTCDateUtils;
import kd.wtc.wtbs.common.util.third.collect.Lists;
import kd.wtc.wtbs.common.util.third.collect.Maps;
import kd.wtc.wtbs.common.util.third.collect.Sets;
import kd.wtc.wtbs.common.util.third.util.ArrayUtils;
import kd.wtc.wtbs.common.util.third.util.StringUtils;
import kd.wtc.wtp.business.attperiod.IAttPeriodNameMain;
import kd.wtc.wtp.business.attstateinfo.AttStateInfoService;
import kd.wtc.wtp.common.constants.attperiod.AttPeriodConstants;
import kd.wtc.wtp.common.model.attstateinfo.AttStateInfoBO;

public class AttPeriodService
implements AttPeriodConstants {
    private static final Log logger = LogFactory.getLog(AttPeriodService.class);
    private static final String LOOPTYPE_MONTH = "A";
    private static final String LOOPTYPE_HALF_MONTH = "B";
    private static final String LOOPTYPE_DAYS = "C";
    private static final int INT_FIVE = 5;
    private static final String CHART_SPIT = "-";
    private static final HRBaseServiceHelper ATTPERIODHELPER = new HRBaseServiceHelper("wtp_attperiod");
    private static final HRBaseServiceHelper ATTPERIODHISHELPER = new HRBaseServiceHelper("wtp_attperiodhis");
    private static final Set<String> ENTRY_UPDATE_NAMES = Sets.newHashSet((Object[])new String[]{"periodname", "quotestatus", "begindate", "enddate", "mhsa", "ascriptionyear", "ascriptionmonth"});
    private static final String WTP_ATTPERIODENTRYHIS = "wtp_attperiodentryhis";
    private static final String NUMBER_REGULAR_EXPRESSION = "^[a-z0-9A-Z|@|#|\\$|%|\\^|\\*|\\&|\\[|\\]|\\-|_|\\.]{0,50}$";
    private static final String SPECIAL_CHARACTERS_EXPRESSION = "^[^\\s]+(\\s+[^\\s]+){0,50}$";
    private static final String QUOTE_STATUS_TRUE = "1";
    private static final String QUOTE_STATUS_FALSE = "0";
    private static final String ATT_FILE_ID_QUERY = "id,attfileid,attfileid.id,attfileid.startdate,attfileid.enddate,bsed,bsled,period.id,attfilevid";
    private static final String ID = "id";
    private static final String MHSA = "mhsa";
    private static final String ISCURRENTVERSION = "iscurrentversion";

    public static void checkPeriodDays(BeforeDoOperationEventArgs args, String operateKey, IFormView view) {
        if ("save".equals(operateKey) || "submiteffect".equals(operateKey) || "submit".equals(operateKey)) {
            boolean flag;
            DynamicObject dataEntity = view.getModel().getDataEntity();
            long periodDays = dataEntity.getLong("perioddays");
            String loopType = dataEntity.getString("looptype");
            boolean bl = flag = LOOPTYPE_DAYS.equals(loopType) && (periodDays < 1L || periodDays > 999L);
            if (flag) {
                view.showErrorNotification(ResManager.loadKDString((String)"\u671f\u95f4\u5929\u6570\u8bf7\u8f93\u51651-999\u7684\u6b63\u6574\u6570\u3002", (String)"AttPeriodService_0", (String)"wtc-wtp-business", (Object[])new Object[0]));
                args.setCancel(true);
                return;
            }
            if (periodDays == 0L) {
                periodDays = 1L;
                view.getModel().setValue("perioddays", (Object)periodDays);
            }
        }
    }

    public static void generatePeriodNameOrCode(String key, IDataModel dataModel) {
        DynamicObject data = dataModel.getDataEntity();
        DynamicObjectCollection dy = dataModel.getEntryEntity("attperiodentry");
        if (Objects.isNull(dy)) {
            return;
        }
        String namePrefix = "number".equals(key) && (dy.size() == 0 || dy.size() > 0 && StringUtils.isEmpty((CharSequence)((DynamicObject)dy.get(0)).getString("periodcode"))) ? AttPeriodService.getDefaultNamePrefix("", data.getString("number")) : data.getString("nameprefix");
        String nameMain = data.getString("namemain");
        String namePostfix = data.getString("namepostfix");
        int serialNumber = data.getInt("serialnumber");
        AtomicReference<Date> date = new AtomicReference<Date>(new Date());
        Date dateTemp = data.getDate("createtime");
        if (dateTemp != null) {
            date.set(dateTemp);
        }
        String name = AttPeriodService.generatePeriodCode(namePrefix, nameMain, namePostfix, serialNumber, 0, nameMainStr -> {
            String nameStr = "";
            if (LOOPTYPE_MONTH.equals(nameMainStr)) {
                SimpleDateFormat simpleDateFormat = new SimpleDateFormat("yyyyMM");
                nameStr = simpleDateFormat.format((Date)date.get());
            } else {
                SimpleDateFormat simpleDateFormat = new SimpleDateFormat("yyyyMMdd");
                nameStr = simpleDateFormat.format((Date)date.get());
            }
            return nameStr;
        });
        dataModel.setValue("namedemo", (Object)name);
        dataModel.setValue("nameprefix", (Object)namePrefix);
    }

    public static String generatePeriodCode(String namePrefix, String nameMain, String namePostfix, int serialNumber, int seq, IAttPeriodNameMain attPeriodNameMain) {
        nameMain = attPeriodNameMain.generateNameMain(nameMain);
        int number = seq + 1;
        StringBuilder name = new StringBuilder();
        name.append(namePrefix).append(nameMain).append(namePostfix);
        if (serialNumber == 0) {
            return name.toString();
        }
        number = AttPeriodService.checkOutSerialNumber(number, serialNumber);
        name.append('-');
        name.append(AttPeriodService.generateSerialNumber(serialNumber, number));
        return name.toString();
    }

    private static int checkOutSerialNumber(int number, int serialNumber) {
        int maxNum = 9;
        if (serialNumber == 2) {
            maxNum = 99;
        }
        if (number > maxNum) {
            throw new KDBizException(ResManager.loadKDString((String)"\u6d41\u6c34\u53f7\u4f4d\u6570\u8d85\u51fa\u9650\u5236\uff0c\u8bf7\u91cd\u65b0\u8bbe\u7f6e\u3002", (String)"AttPeriodService_1", (String)"wtc-wtp-business", (Object[])new Object[0]));
        }
        number = number % maxNum == 0 ? maxNum : (number %= maxNum);
        return number;
    }

    public static String checkYearMouthExist(DynamicObjectCollection dynamicObjectCollection) {
        for (DynamicObject dynamic : dynamicObjectCollection) {
            Date beginDate = dynamic.getDate("begindate");
            Date endDate = dynamic.getDate("enddate");
            String ascriptionYear = dynamic.getString("ascriptionyearview");
            String ascriptionMonth = dynamic.getString("ascriptionmonth");
            if ((StringUtils.isNotEmpty((CharSequence)ascriptionYear) || StringUtils.isNotEmpty((CharSequence)ascriptionMonth)) && (beginDate == null || endDate == null)) {
                return ResManager.loadKDString((String)"\u8bf7\u5148\u586b\u5199\u5f00\u59cb\u65e5\u671f\u548c\u7ed3\u675f\u65e5\u671f\u3002", (String)"AttPeriodPlugin_18", (String)"wtc-wtp-business", (Object[])new Object[0]);
            }
            if (beginDate == null || endDate == null) {
                return "";
            }
            String beginDateStr = HRDateTimeUtils.format((Date)beginDate, (String)"yyyy");
            String endDateStr = HRDateTimeUtils.format((Date)endDate, (String)"yyyy");
            String yearView = dynamic.getString("ascriptionyear");
            if (StringUtils.isEmpty((CharSequence)yearView)) {
                return "";
            }
            int yearViewInter = Integer.parseInt(yearView);
            if (yearViewInter < Integer.parseInt(beginDateStr) || yearViewInter > Integer.parseInt(endDateStr)) {
                return ResManager.loadKDString((String)"\u6240\u5c5e\u5e74\u4efd\u201c{0}\u201d\u4e0d\u5728\u671f\u95f4\u7684\u5f00\u59cb\u65e5\u671f\u548c\u7ed3\u675f\u65e5\u671f\u8303\u56f4\u5185\u3002", (String)"AttPeriodPlugin_5", (String)"wtc-wtp-business", (Object[])new Object[]{yearView});
            }
            Date dateMouth = null;
            Date parseBeginDate = null;
            Date lastDateMouth = null;
            try {
                lastDateMouth = WTCDateUtils.getDayLastDate((Date)WTCDateUtils.getLastDayOfMonth((int)Integer.parseInt(endDateStr), (int)Integer.parseInt(HRDateTimeUtils.format((Date)endDate, (String)"MM"))));
                dateMouth = HRDateTimeUtils.parseDate((String)(yearView + CHART_SPIT + ascriptionMonth), (String)"yyyy-MM");
                String beginDateString = HRDateTimeUtils.format((Date)beginDate, (String)"yyyy-MM");
                parseBeginDate = HRDateTimeUtils.parseDate((String)beginDateString, (String)"yyyy-MM");
            }
            catch (ParseException ex) {
                logger.warn("AttPeriodService.checkYearMouthExist  error:{}", (Object)ex.getMessage());
            }
            if (null == dateMouth || !HRDateTimeUtils.dayBefore(dateMouth, parseBeginDate) && !HRDateTimeUtils.dayBefore((Date)lastDateMouth, dateMouth)) continue;
            return ResManager.loadKDString((String)"\u6240\u5c5e\u6708\u4efd\u201c{0}\u201d\u4e0d\u5728\u671f\u95f4\u7684\u5f00\u59cb\u65e5\u671f\u548c\u7ed3\u675f\u65e5\u671f\u8303\u56f4\u5185\u3002", (String)"AttPeriodPlugin_6", (String)"wtc-wtp-business", (Object[])new Object[]{ascriptionMonth});
        }
        return "";
    }

    public static String checkDateAttributionRules(DynamicObjectCollection dynamicObjects) {
        int dynamicObjectsSize = dynamicObjects.size();
        for (int i = 0; i < dynamicObjectsSize; ++i) {
            Date firstbsed;
            DynamicObject dynamic = (DynamicObject)dynamicObjects.get(i);
            Date beginDate = dynamic.getDate("begindate");
            if (null == beginDate) {
                return "";
            }
            DynamicObject mhsa = dynamic.getDynamicObject(MHSA);
            if (null == mhsa || null == (firstbsed = mhsa.getDate("firstbsed")) || !firstbsed.after(beginDate)) continue;
            return ResManager.loadKDString((String)"\u7b2c%s\u884c\u201c\u65e5\u671f\u5f52\u5c5e\u89c4\u5219\u201d\u7684\u6700\u65e9\u751f\u6548\u65e5\u671f\u665a\u4e8e\u671f\u95f4\u5f00\u59cb\u65e5\u671f\u3002", (String)"AttPeriodPlugin_7", (String)"wtc-wtp-business", (Object[])new Object[]{i + 1});
        }
        return "";
    }

    public static String generateSerialNumber(int length, int number) {
        if (length == 0) {
            return "";
        }
        StringBuilder serialNumber = new StringBuilder();
        for (int i = 0; i < length - 1 && number / 10 < length - 1; ++i) {
            serialNumber.append('0');
        }
        serialNumber.append(number);
        return serialNumber.toString();
    }

    public static void setLoopTypeMustInput(IFormView view, IDataModel dataModel) {
        String loopType;
        FieldEdit periodDate = (FieldEdit)view.getControl("perioddate");
        FieldEdit firstPeriodDate = (FieldEdit)view.getControl("firstperioddate");
        FieldEdit secondPeriodDate = (FieldEdit)view.getControl("secondperioddate");
        FieldEdit loopBeginDate = (FieldEdit)view.getControl("loopbegindate");
        FieldEdit periodNumber = (FieldEdit)view.getControl("perioddays");
        switch (loopType = dataModel.getDataEntity().getString("looptype")) {
            case "A": {
                periodDate.setMustInput(true);
                firstPeriodDate.setMustInput(false);
                secondPeriodDate.setMustInput(false);
                loopBeginDate.setMustInput(false);
                periodNumber.setMustInput(false);
                break;
            }
            case "B": {
                periodDate.setMustInput(false);
                firstPeriodDate.setMustInput(true);
                secondPeriodDate.setMustInput(true);
                loopBeginDate.setMustInput(false);
                periodNumber.setMustInput(false);
                break;
            }
            case "C": {
                periodDate.setMustInput(false);
                firstPeriodDate.setMustInput(false);
                secondPeriodDate.setMustInput(false);
                loopBeginDate.setMustInput(true);
                periodNumber.setMustInput(true);
                break;
            }
        }
    }

    public static int calculateTotalDays(Date beginDate, Date endDate) {
        return WTCDateUtils.daysBetween((Date)beginDate, (Date)endDate);
    }

    public static String calculateDateConflict(DynamicObjectCollection dynamicObjectCollection) {
        DynamicObjectCollection cloneObjectCollection = (DynamicObjectCollection)dynamicObjectCollection.clone();
        ArrayList<String> discontionList = new ArrayList<String>(10);
        ArrayList<String> overlapList = new ArrayList<String>(10);
        Calendar calendar = Calendar.getInstance();
        for (int i = 1; i < cloneObjectCollection.size(); ++i) {
            Date thisBeginDate = ((DynamicObject)cloneObjectCollection.get(i - 1)).getDate("begindate");
            Date lastEndDate = ((DynamicObject)cloneObjectCollection.get(i)).getDate("enddate");
            calendar.setTime(thisBeginDate);
            calendar.add(5, -1);
            String periodName = ((DynamicObject)cloneObjectCollection.get(i)).getString("periodname");
            String lastPeriodName = ((DynamicObject)cloneObjectCollection.get(i - 1)).getString("periodname");
            String str = String.format(ResManager.loadKDString((String)"%1$s\u4e0e%2$s", (String)"AttPeriodService_16", (String)"wtc-wtp-business", (Object[])new Object[0]), lastPeriodName, periodName);
            if (HRDateTimeUtils.dayAfter((Date)calendar.getTime(), (Date)lastEndDate)) {
                discontionList.add(str);
            }
            if (!HRDateTimeUtils.dayBefore((Date)calendar.getTime(), (Date)lastEndDate)) continue;
            overlapList.add(str);
        }
        if (!CollectionUtils.isEmpty(discontionList)) {
            String str = String.join((CharSequence)",", discontionList);
            return ResManager.loadKDString((String)"%s\u7684\u65e5\u671f\u5b58\u5728\u91cd\u53e0\u3001\u4e0d\u8fde\u7eed\u6216\u672a\u6309\u671f\u95f4\u964d\u5e8f\u65b9\u5f0f\u586b\u5199\u3002", (String)"AttPeriodService_3", (String)"wtc-wtp-business", (Object[])new Object[]{str});
        }
        if (!CollectionUtils.isEmpty(overlapList)) {
            String str = String.join((CharSequence)",", overlapList);
            return ResManager.loadKDString((String)"%s\u7684\u65e5\u671f\u5b58\u5728\u91cd\u53e0\u3001\u4e0d\u8fde\u7eed\u6216\u672a\u6309\u671f\u95f4\u964d\u5e8f\u65b9\u5f0f\u586b\u5199\u3002", (String)"AttPeriodService_3", (String)"wtc-wtp-business", (Object[])new Object[]{str});
        }
        return null;
    }

    public static Boolean validateDate(DynamicObjectCollection dynamicObjectCollection) {
        Boolean result = Boolean.TRUE;
        for (DynamicObject data : dynamicObjectCollection) {
            Date beginDate = data.getDate("begindate");
            Date endDate = data.getDate("enddate");
            if (endDate.getTime() >= beginDate.getTime()) continue;
            result = Boolean.FALSE;
        }
        return result;
    }

    public static Boolean validateDuplicateNameOrCode(DynamicObject dynamic, String perpertyName, Map<String, Long> map) {
        String value = dynamic.getString(perpertyName);
        Long seq = dynamic.getLong("seq");
        if (map.containsKey(value)) {
            return Boolean.TRUE;
        }
        map.put(value, seq);
        return Boolean.FALSE;
    }

    public static Boolean validateBeforeBatchAdd(IFormView view, IDataModel dataModel) {
        DynamicObject dynamicObject = dataModel.getDataEntity();
        String loopType = dynamicObject.getString("looptype");
        Boolean tag = Boolean.TRUE;
        ArrayList<String> emptyFiles = new ArrayList<String>(10);
        if (loopType == null) {
            String fileStr = ResManager.loadKDString((String)"\u201c\u5faa\u73af\u7c7b\u578b\u201d", (String)"AttPeriodService_5", (String)"wtc-wtp-business", (Object[])new Object[0]);
            emptyFiles.add(fileStr);
            tag = Boolean.FALSE;
        } else {
            String defaultmhsa = dynamicObject.getString("defaultmhsa");
            tag = AttPeriodService.loopTypeRelationCheck(loopType, emptyFiles, dynamicObject, view);
            if (defaultmhsa == null) {
                String fileStr = ResManager.loadKDString((String)"\u201c\u9ed8\u8ba4\u65e5\u671f\u5f52\u5c5e\u89c4\u5219\u201d", (String)"AttPeriodService_6", (String)"wtc-wtp-business", (Object[])new Object[0]);
                emptyFiles.add(fileStr);
                tag = Boolean.FALSE;
            }
        }
        if (!tag.booleanValue()) {
            if (!CollectionUtils.isEmpty(emptyFiles)) {
                view.showTipNotification(ResManager.loadKDString((String)"\u8bf7\u5148\u7ef4\u62a4\u57fa\u672c\u4fe1\u606f\u4e2d\u7684%s\u7684\u503c\u3002", (String)"AttPeriodService_7", (String)"wtc-wtp-business", (Object[])new Object[]{String.join((CharSequence)",", emptyFiles)}));
            }
            return tag;
        }
        int serialNumber = dynamicObject.getInt("serialnumber");
        if (serialNumber == 0 && !LOOPTYPE_MONTH.equals(loopType)) {
            view.showTipNotification(ResManager.loadKDString((String)"\u975e\u6708\u5faa\u73af\u7684\u8003\u52e4\u5468\u671f\u9700\u8981\u586b\u5199\u6d41\u6c34\u53f7\u4f4d\u6570\u3002", (String)"AttPeriodService_8", (String)"wtc-wtp-business", (Object[])new Object[0]));
            return Boolean.FALSE;
        }
        DynamicObjectCollection dynamicObjectCollection = dataModel.getEntryEntity("attperiodentry");
        if (!CollectionUtils.isEmpty((Collection)dynamicObjectCollection)) {
            ArrayList<Integer> emptyEntity = new ArrayList<Integer>(dynamicObjectCollection.size());
            for (DynamicObject entity : dynamicObjectCollection) {
                if (AttPeriodService.isEmptyEntry(entity)) {
                    emptyEntity.add(dynamicObjectCollection.indexOf((Object)entity));
                    continue;
                }
                if (entity.get("begindate") != null && entity.get("enddate") != null) continue;
                view.showTipNotification(ResManager.loadKDString((String)"\u8bf7\u5148\u7ef4\u62a4\u5df2\u6dfb\u52a0\u671f\u95f4\u7684\u5f00\u59cb\u65e5\u671f\u548c\u7ed3\u675f\u65e5\u671f", (String)"AttPeriodService_9", (String)"wtc-wtp-business", (Object[])new Object[0]));
                return Boolean.FALSE;
            }
            if (!CollectionUtils.isEmpty(emptyEntity)) {
                Integer[] index = new Integer[emptyEntity.size()];
                emptyEntity.toArray(index);
                dataModel.deleteEntryRows("attperiodentry", ArrayUtils.toPrimitive((Integer[])index));
                view.sendFormAction(view);
            }
        }
        return Boolean.TRUE;
    }

    private static Boolean loopTypeRelationCheck(String loopType, List<String> emptyFiles, DynamicObject dynamicObject, IFormView view) {
        Boolean tag = Boolean.TRUE;
        switch (loopType) {
            case "A": {
                String periodDate = dynamicObject.getString("perioddate");
                if (periodDate != null) break;
                String fileStr = ResManager.loadKDString((String)"\u201c\u671f\u95f4\u8d77\u59cb\u65e5\u201d", (String)"AttPeriodService_10", (String)"wtc-wtp-business", (Object[])new Object[0]);
                emptyFiles.add(fileStr);
                tag = Boolean.FALSE;
                break;
            }
            case "B": {
                String fileStr;
                String firstPeriodDate = dynamicObject.getString("firstperioddate");
                String secondPeriodDate = dynamicObject.getString("secondperioddate");
                if (StringUtils.isEmpty((CharSequence)firstPeriodDate)) {
                    fileStr = ResManager.loadKDString((String)"\u201c\u9996\u671f\u95f4\u8d77\u59cb\u65e5\u201d", (String)"AttPeriodService_11", (String)"wtc-wtp-business", (Object[])new Object[0]);
                    emptyFiles.add(fileStr);
                    tag = Boolean.FALSE;
                }
                if (StringUtils.isEmpty((CharSequence)secondPeriodDate)) {
                    fileStr = ResManager.loadKDString((String)"\u201c\u6b21\u671f\u95f4\u8d77\u59cb\u65e5\u201d", (String)"AttPeriodService_12", (String)"wtc-wtp-business", (Object[])new Object[0]);
                    emptyFiles.add(fileStr);
                    tag = Boolean.FALSE;
                }
                if (!StringUtils.isNotEmpty((CharSequence)firstPeriodDate) || !firstPeriodDate.equals(secondPeriodDate)) break;
                view.showTipNotification(ResManager.loadKDString((String)"\u201c\u9996\u671f\u95f4\u8d77\u59cb\u65e5\u201d\u4e0e\u201c\u6b21\u671f\u95f4\u8d77\u59cb\u65e5\u201d\u4e0d\u80fd\u4e3a\u540c\u4e00\u5929\u3002", (String)"AttPeriodService_13", (String)"wtc-wtp-business", (Object[])new Object[0]));
                tag = Boolean.FALSE;
                break;
            }
            case "C": {
                String fileStr;
                Date loopBeginDate = dynamicObject.getDate("loopbegindate");
                int periodNumber = dynamicObject.getInt("perioddays");
                if (loopBeginDate == null) {
                    fileStr = ResManager.loadKDString((String)"\u201c\u5faa\u73af\u57fa\u51c6\u8d77\u59cb\u65e5\u671f\u201d", (String)"AttPeriodService_14", (String)"wtc-wtp-business", (Object[])new Object[0]);
                    emptyFiles.add(fileStr);
                    tag = Boolean.FALSE;
                }
                if (periodNumber != 0) break;
                fileStr = ResManager.loadKDString((String)"\u201c\u671f\u95f4\u5929\u6570\u201d", (String)"AttPeriodService_15", (String)"wtc-wtp-business", (Object[])new Object[0]);
                emptyFiles.add(fileStr);
                tag = Boolean.FALSE;
                break;
            }
        }
        return tag;
    }

    public static boolean isEmptyEntry(DynamicObject entity) {
        DataEntityPropertyCollection propertyCollection = entity.getDataEntityType().getProperties();
        AtomicBoolean tag = new AtomicBoolean(true);
        List<String> checkProperty = Arrays.asList("periodcode", "periodname", "begindate", "enddate", "ascriptionyearview", "ascriptionmonth");
        propertyCollection.forEach(property -> {
            if (checkProperty.contains(property.getName()) && !HRObjectUtils.isEmpty((Object)entity.get(property.getName()))) {
                tag.getAndSet(false);
                return;
            }
        });
        return tag.get();
    }

    public static Map<String, Object> setDataBeforeBatchAdd(DynamicObject dynamicObject, DynamicObjectCollection dynamicObjectCollection) {
        HashMap<String, Object> data = new HashMap<String, Object>(16);
        long defaultRule = dynamicObject.getLong("defaultmhsa.id");
        data.put("defaultmhsa", defaultRule);
        String loopType = dynamicObject.getString("looptype");
        Long orgId = dynamicObject.getLong("createorg.id");
        data.put("looptype", loopType);
        data.put("createorg", orgId);
        switch (loopType) {
            case "A": {
                String periodDate = dynamicObject.getString("perioddate");
                data.put("perioddate", periodDate);
                break;
            }
            case "B": {
                String firstPeriodDate = dynamicObject.getString("firstperioddate");
                String secondPeriodDate = dynamicObject.getString("secondperioddate");
                data.put("firstperioddate", firstPeriodDate);
                data.put("secondperioddate", secondPeriodDate);
                break;
            }
            case "C": {
                Date loopBeginDate = dynamicObject.getDate("loopbegindate");
                data.put("loopbegindate", loopBeginDate);
                break;
            }
        }
        int periodNumber = dynamicObject.getInt("perioddays");
        data.put("perioddays", periodNumber);
        data.put("attperiodentry", dynamicObjectCollection);
        data.put("nameprefix", dynamicObject.getString("nameprefix"));
        data.put("namemain", dynamicObject.getString("namemain"));
        data.put("namepostfix", dynamicObject.getString("namepostfix"));
        data.put("serialnumber", dynamicObject.getInt("serialnumber"));
        if (!CollectionUtils.isEmpty((Collection)dynamicObjectCollection)) {
            dynamicObjectCollection.sort(Comparator.comparing(ao -> ao.getDate("begindate")));
            Date beginDate = ((DynamicObject)dynamicObjectCollection.get(0)).getDate("begindate");
            Date endDate = ((DynamicObject)dynamicObjectCollection.get(dynamicObjectCollection.size() - 1)).getDate("enddate");
            data.put("begindate", beginDate);
            data.put("enddate", endDate);
        }
        return data;
    }

    public static String getDateDay(Date date) {
        SimpleDateFormat sdf = new SimpleDateFormat("d");
        return sdf.format(date);
    }

    public static Date getDateLastDay(Date date) {
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(date);
        calendar.add(2, 1);
        calendar.set(5, 1);
        calendar.add(5, -1);
        return calendar.getTime();
    }

    public static boolean validateDayIsEqual(Date date, String day) {
        return "31".equals(day) ? AttPeriodService.isMonthLastDay(date) : AttPeriodService.getDateDay(date).equals(day);
    }

    public static boolean isMonthLastDay(Date date) {
        Calendar calendar = AttPeriodService.getDayOfMonth(date, 1);
        return calendar.get(5) == 1;
    }

    public static Date getYesterday(Date date) {
        Calendar calendar = AttPeriodService.getDayOfMonth(date, -1);
        return calendar.getTime();
    }

    public static Date getTomorrow(Date date) {
        Calendar calendar = AttPeriodService.getDayOfMonth(date, 1);
        return calendar.getTime();
    }

    private static Calendar getDayOfMonth(Date date, int amount) {
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(date);
        calendar.add(5, amount);
        return calendar;
    }

    public void lockAttPeriod(Map<Long, Date> lockTo) {
        List<Long> collect = lockTo.entrySet().stream().filter(unlockTo -> unlockTo.getValue() == null).map(Map.Entry::getKey).collect(Collectors.toList());
        if (!collect.isEmpty()) {
            List<AttStateInfoBO> stateInfoBOS = AttStateInfoService.getInstance().queryAttStateInfoByBoid(collect);
            lockTo.putAll(stateInfoBOS.stream().collect(HashMap::new, (map, item) -> map.put(item.getFileBoid(), item.getLockTo()), HashMap::putAll));
        }
        Set<Long> fileBoidSet = lockTo.keySet();
        Map periodScheduleMap = AttFileScheduleServiceImpl.getInstance().queryAttFileSchedule(fileBoidSet, AttFileScheduleEnum.PERIOD, false);
        DynamicObjectCollection currentCollection = new DynamicObjectCollection();
        ArrayList periodEntryList = Lists.newArrayListWithExpectedSize((int)16);
        for (Map.Entry<Long, Date> mapEntry : lockTo.entrySet()) {
            Long boId = mapEntry.getKey();
            Date lockDate = mapEntry.getValue();
            List schedulePeriodList = (List)periodScheduleMap.get(boId);
            if (null == lockDate || CollectionUtils.isEmpty((Collection)schedulePeriodList)) continue;
            schedulePeriodList.forEach(dynamicObject -> {
                if (dynamicObject.getDate("bsled").compareTo(lockDate) <= 0) {
                    periodEntryList.add(dynamicObject);
                }
                if (dynamicObject.getDate("bsled").compareTo(lockDate) >= 0 && dynamicObject.getDate("bsed").compareTo(lockDate) <= 0) {
                    dynamicObject.set("bsled", (Object)lockDate);
                    periodEntryList.add(dynamicObject);
                }
            });
        }
        this.getSavePeriodDy(currentCollection, periodEntryList, QUOTE_STATUS_TRUE, null);
        try (TXHandle handle = TX.required();){
            try {
                ATTPERIODHELPER.save(currentCollection);
                MainEntityType hisEntityType = MetadataServiceHelper.getDataEntityType((String)"wtp_attperiodhis");
                WTCSnapService.snapHisSave((MainEntityType)hisEntityType, (HRBaseServiceHelper)ATTPERIODHISHELPER, (DynamicObjectCollection)currentCollection);
                AttPeriodService.snapEntryHisSaveHis((DynamicObject[])currentCollection.stream().toArray(DynamicObject[]::new));
            }
            catch (Throwable throwable) {
                handle.markRollback();
                throw new KDBizException(throwable, new ErrorCode("", throwable.getMessage()), new Object[0]);
            }
        }
    }

    public void unLockAttPeriod(Map<Long, Date> unLockTo) {
        List<Long> collect = unLockTo.entrySet().stream().filter(unlockTo -> unlockTo.getValue() == null).map(Map.Entry::getKey).collect(Collectors.toList());
        if (!collect.isEmpty()) {
            List<AttStateInfoBO> stateInfoBOS = AttStateInfoService.getInstance().queryAttStateInfoByBoid(collect);
            unLockTo.putAll(stateInfoBOS.stream().collect(HashMap::new, (map, item) -> map.put(item.getFileBoid(), item.getLockTo()), HashMap::putAll));
        }
        Set<Long> fileBoidSet = unLockTo.keySet();
        AttFileScheduleQueryParam attFileScheduleQueryParam = new AttFileScheduleQueryParam();
        attFileScheduleQueryParam.setFileBoIdSet(fileBoidSet);
        attFileScheduleQueryParam.setProperties(ATT_FILE_ID_QUERY);
        Map periodScheduleMap = AttFileScheduleServiceImpl.getInstance().queryAttFileSchedule(AttFileScheduleEnum.PERIOD, attFileScheduleQueryParam);
        DynamicObjectCollection currentCollection = new DynamicObjectCollection();
        HashMap updateDate = Maps.newHashMapWithExpectedSize((int)16);
        ArrayList periodEntryList = Lists.newArrayListWithExpectedSize((int)16);
        for (Map.Entry<Long, Date> mapEntry : unLockTo.entrySet()) {
            Long fileBoid = mapEntry.getKey();
            Date lockDate = mapEntry.getValue();
            List schedulePeriodList = (List)periodScheduleMap.get(fileBoid);
            if (CollectionUtils.isEmpty((Collection)schedulePeriodList)) continue;
            if (null == lockDate) {
                periodEntryList.addAll(schedulePeriodList);
                continue;
            }
            Date finalLockDate = WTCDateUtils.addDays((Date)lockDate, (int)1);
            schedulePeriodList.forEach(dynamicObject -> {
                if (dynamicObject.getDate("bsed").compareTo(finalLockDate) >= 0) {
                    periodEntryList.add(dynamicObject);
                }
                if (dynamicObject.getDate("bsed").compareTo(finalLockDate) <= 0 && dynamicObject.getDate("bsled").compareTo(finalLockDate) >= 0) {
                    dynamicObject.set("bsed", (Object)finalLockDate);
                    periodEntryList.add(dynamicObject);
                }
            });
        }
        this.getSavePeriodDy(currentCollection, periodEntryList, QUOTE_STATUS_FALSE, updateDate);
        this.removeLockedData(currentCollection, updateDate);
        try (TXHandle handle = TX.required();){
            try {
                ATTPERIODHELPER.save(currentCollection);
                MainEntityType hisEntityType = MetadataServiceHelper.getDataEntityType((String)"wtp_attperiodhis");
                WTCSnapService.snapHisSave((MainEntityType)hisEntityType, (HRBaseServiceHelper)ATTPERIODHISHELPER, (DynamicObjectCollection)currentCollection);
                AttPeriodService.snapEntryHisSaveHis((DynamicObject[])currentCollection.stream().toArray(DynamicObject[]::new));
            }
            catch (Throwable throwable) {
                handle.markRollback();
                throw new KDBizException(throwable, new ErrorCode("", throwable.getMessage()), new Object[0]);
            }
        }
    }

    private void removeLockedData(DynamicObjectCollection currentCollection, Map<Long, Set<Long>> updateDate) {
        if (currentCollection == null || currentCollection.isEmpty()) {
            return;
        }
        HashSet removePeriodEntryIdSet = Sets.newHashSetWithExpectedSize((int)16);
        HRBaseServiceHelper attPeriodEntryHelper = new HRBaseServiceHelper("wtp_attperiodentry");
        DynamicObject[] attPeriodEntryArr = attPeriodEntryHelper.queryOriginalArray("id,masterid,begindate,enddate", new QFilter[]{new QFilter(ID, "in", updateDate.keySet())});
        Map<Long, Set<Long>> periodEntryFileIdMap = AttPeriodService.getPeriodEntryFileIdMap(attPeriodEntryArr);
        Map attPeriodEntryMap = Arrays.stream(attPeriodEntryArr).collect(Collectors.toMap(d -> d.getLong(ID), Function.identity()));
        List<AttStateInfoBO> attStateInfoBOS = AttStateInfoService.getInstance().queryAttStateInfoByBoid(periodEntryFileIdMap.values().stream().flatMap(Collection::stream).collect(Collectors.toList()));
        Map lockToMap = attStateInfoBOS.stream().collect(HashMap::new, (map, item) -> map.put(item.getFileBoid(), item.getLockTo()), HashMap::putAll);
        for (Map.Entry<Long, Set<Long>> entries : periodEntryFileIdMap.entrySet()) {
            Set<Long> fileBoIdSet = entries.getValue();
            Long entryId = entries.getKey();
            Set<Long> updateDateFileBoId = updateDate.get(entryId);
            fileBoIdSet.removeAll(updateDateFileBoId);
            if (CollectionUtils.isEmpty(fileBoIdSet)) continue;
            DynamicObject periodEntry = (DynamicObject)attPeriodEntryMap.get(entryId);
            for (Long fileBoId : fileBoIdSet) {
                Date lockDate = (Date)lockToMap.get(fileBoId);
                if (lockDate == null || periodEntry.getDate("begindate").compareTo(lockDate) > 0) continue;
                removePeriodEntryIdSet.add(periodEntry.getLong(ID));
            }
        }
        if (!CollectionUtils.isEmpty((Collection)removePeriodEntryIdSet)) {
            for (DynamicObject dynamicObject : currentCollection) {
                DynamicObjectCollection attPeriodEntry = dynamicObject.getDynamicObjectCollection("attperiodentry");
                for (DynamicObject periodEntry : attPeriodEntry) {
                    if (!removePeriodEntryIdSet.contains(periodEntry.getLong(ID))) continue;
                    periodEntry.set("quotestatus", (Object)QUOTE_STATUS_TRUE);
                }
            }
        }
    }

    public static Map<Long, Set<Long>> getPeriodEntryFileIdMapByPeriodEntryId(Set<Long> periodEntryIdSet) {
        if (CollectionUtils.isEmpty(periodEntryIdSet)) {
            return Collections.emptyMap();
        }
        HRBaseServiceHelper attPeriodEntryHelper = new HRBaseServiceHelper("wtp_attperiodentry");
        DynamicObject[] attPeriodEntryArr = attPeriodEntryHelper.queryOriginalArray("id,masterid,begindate,enddate", new QFilter[]{new QFilter(ID, "in", periodEntryIdSet)});
        return AttPeriodService.getPeriodEntryFileIdMap(attPeriodEntryArr);
    }

    private static Map<Long, Set<Long>> getPeriodEntryFileIdMap(DynamicObject[] attPeriodEntryArr) {
        long start = System.currentTimeMillis();
        logger.info("AttPeriodService.getPeriodEntryFileIdMap start {}", (Object)start);
        HashMap periodEntryAndFileIdMap = Maps.newHashMapWithExpectedSize((int)16);
        Map<Long, List<DynamicObject>> attPeriodEntryMap = Arrays.stream(attPeriodEntryArr).collect(Collectors.groupingBy(d -> d.getLong("masterid")));
        Set periodIdSet = Arrays.stream(attPeriodEntryArr).map(dynamicObject -> dynamicObject.getLong("masterid")).collect(Collectors.toSet());
        AttFileScheduleQueryParam attFileScheduleQueryParam = new AttFileScheduleQueryParam();
        attFileScheduleQueryParam.setProperties(ATT_FILE_ID_QUERY);
        attFileScheduleQueryParam.setLoad(Boolean.FALSE);
        attFileScheduleQueryParam.setqFilter(new QFilter("period", "in", periodIdSet));
        List filePeriodScheme = AttFileScheduleServiceImpl.getInstance().queryAttFileScheduleByList(AttFileScheduleEnum.PERIOD, attFileScheduleQueryParam);
        Map<Long, List<DynamicObject>> filePeriodSchemeMap = filePeriodScheme.stream().collect(Collectors.groupingBy(d -> d.getLong("attfileid.id")));
        for (Map.Entry<Long, List<DynamicObject>> entries : filePeriodSchemeMap.entrySet()) {
            Long fileBoId = entries.getKey();
            for (DynamicObject periodScheme : entries.getValue()) {
                long periodId;
                List<DynamicObject> periodEntryArr;
                Date bsedDate = periodScheme.getDate("bsed");
                Date blsedDate = periodScheme.getDate("bsled");
                Date startDate = periodScheme.getDate("attfileid.startdate");
                Date endDate = periodScheme.getDate("attfileid.enddate");
                if (startDate == null || endDate == null || CollectionUtils.isEmpty(periodEntryArr = attPeriodEntryMap.get(periodId = periodScheme.getLong("period.id")))) continue;
                for (DynamicObject periodEntry : periodEntryArr) {
                    Date periodEntryBegin = periodEntry.getDate("begindate");
                    Date periodEntryEnd = periodEntry.getDate("enddate");
                    if (bsedDate.compareTo(periodEntryEnd) > 0 || blsedDate.compareTo(periodEntryBegin) < 0 || startDate.compareTo(periodEntryEnd) > 0 || endDate.compareTo(periodEntryBegin) < 0) continue;
                    Set fileIdSet = (Set)periodEntryAndFileIdMap.get(periodEntry.getLong(ID));
                    if (CollectionUtils.isEmpty((Collection)fileIdSet)) {
                        fileIdSet = Sets.newHashSetWithExpectedSize((int)16);
                        fileIdSet.add(fileBoId);
                        periodEntryAndFileIdMap.put(periodEntry.getLong(ID), fileIdSet);
                        continue;
                    }
                    fileIdSet.add(fileBoId);
                }
            }
        }
        long end = System.currentTimeMillis();
        logger.info("AttPeriodService.getPeriodEntryFileIdMap end {},consuming {}", (Object)end, (Object)(end - start));
        return periodEntryAndFileIdMap;
    }

    private void getSavePeriodDy(DynamicObjectCollection currentCollection, List<DynamicObject> periodEntryList, String quoteStatus, Map<Long, Set<Long>> updateData) {
        Map periodMap = Arrays.stream(ATTPERIODHELPER.loadDynamicObjectArray((Object[])periodEntryList.stream().map(dy -> dy.getLong("period.id")).filter(dy -> dy != 0L).toArray(Long[]::new))).collect(Collectors.toMap(dy -> dy.getLong(ID), Function.identity()));
        if (periodMap.isEmpty()) {
            return;
        }
        for (DynamicObject periodEntry : periodEntryList) {
            Date startDate = periodEntry.getDate("bsed");
            Date endDate = periodEntry.getDate("bsled");
            Date fileStartDate = periodEntry.getDate("attfileid.startdate");
            boolean firstEntry = fileStartDate != null && fileStartDate.compareTo(startDate) == 0;
            DynamicObject period = (DynamicObject)periodMap.get(periodEntry.getLong("period.id"));
            if (period == null) continue;
            DynamicObjectCollection attPeriodEntry = period.getDynamicObjectCollection("attperiodentry");
            boolean updateQuoteStatus = false;
            if (QUOTE_STATUS_TRUE.equals(quoteStatus)) {
                for (DynamicObject dy2 : attPeriodEntry) {
                    if (QUOTE_STATUS_TRUE.equals(dy2.getString("quotestatus")) || dy2.getDate("begindate").compareTo(endDate) > 0 || dy2.getDate("enddate").compareTo(startDate) < 0) continue;
                    dy2.set("quotestatus", (Object)quoteStatus);
                    updateQuoteStatus = true;
                    logger.info("quoteStatus Changed quoteStatus = {},periodEntryId = {}", (Object)quoteStatus, (Object)dy2.getLong(ID));
                }
            } else {
                for (DynamicObject dy2 : attPeriodEntry) {
                    boolean update = !QUOTE_STATUS_FALSE.equals(dy2.getString("quotestatus")) && dy2.getDate("begindate").compareTo(endDate) <= 0 && dy2.getDate("enddate").compareTo(startDate) >= 0;
                    if (!update || !firstEntry && dy2.getDate("begindate").compareTo(startDate) < 0) continue;
                    dy2.set("quotestatus", (Object)quoteStatus);
                    HashSet updateDataFileBoIdSet = updateData.get(dy2.getLong(ID));
                    if (CollectionUtils.isEmpty(updateDataFileBoIdSet)) {
                        updateDataFileBoIdSet = Sets.newHashSetWithExpectedSize((int)16);
                        updateDataFileBoIdSet.add(periodEntry.getLong("attfileid.id"));
                        updateData.put(dy2.getLong(ID), updateDataFileBoIdSet);
                    } else {
                        updateDataFileBoIdSet.add(periodEntry.getLong("attfileid.id"));
                    }
                    updateQuoteStatus = true;
                    logger.info("quoteStatus Changed quoteStatus = {},periodEntryId = {}", (Object)quoteStatus, (Object)dy2.getLong(ID));
                }
            }
            if (!updateQuoteStatus) continue;
            currentCollection.add((Object)period);
        }
    }

    public static void snapEntryHisSaveHis(DynamicObject[] dataEntities) {
        if (dataEntities == null) {
            return;
        }
        Arrays.stream(dataEntities).forEach(dynamic -> {
            Long id = (Long)dynamic.getPkValue();
            DynamicObjectCollection dynamicObjectCollection = dynamic.getDynamicObjectCollection("attperiodentry");
            if (dynamicObjectCollection != null) {
                DynamicObjectCollection currentCollection = new DynamicObjectCollection();
                HRBaseServiceHelper filePeriodEntry = new HRBaseServiceHelper("wtp_attperiod");
                if (id != null && filePeriodEntry.isExists((Object)id)) {
                    DynamicObject dynamicObject = filePeriodEntry.loadSingle((Object)id);
                    DynamicObjectCollection dynamicObjectDbCollection = dynamicObject.getDynamicObjectCollection("attperiodentry");
                    HashMap<Long, DynamicObject> map = new HashMap<Long, DynamicObject>(dynamicObjectDbCollection.size());
                    map.putAll(dynamicObjectDbCollection.stream().collect(Collectors.toMap(key -> (Long)key.getPkValue(), value -> value)));
                    currentCollection = dynamicObjectCollection.stream().filter(ob -> (ob.getPkValue() != null || (Long)ob.getPkValue() != 0L) && AttPeriodService.attperiodEntryEqualValues(ob, (DynamicObject)map.get((Long)ob.getPkValue())) == false).collect(Collectors.toCollection(DynamicObjectCollection::new));
                } else {
                    currentCollection = (DynamicObjectCollection)dynamicObjectCollection.clone();
                }
                if (!CollectionUtils.isEmpty((Collection)currentCollection)) {
                    MainEntityType hisEntityType = MetadataServiceHelper.getDataEntityType((String)WTP_ATTPERIODENTRYHIS);
                    HRBaseServiceHelper hisHelper = new HRBaseServiceHelper(WTP_ATTPERIODENTRYHIS);
                    WTCSnapService.snapHisSave((MainEntityType)hisEntityType, (HRBaseServiceHelper)hisHelper, (DynamicObjectCollection)currentCollection);
                }
            }
        });
    }

    public static void handleBoName(DynamicObjectCollection dynamicObjectCollection) {
        Long boId;
        QFilter qFilter2;
        if (CollectionUtils.isEmpty((Collection)dynamicObjectCollection)) {
            return;
        }
        HRBaseServiceHelper wtpmhsHelper = new HRBaseServiceHelper("wtp_mhsascription");
        Set idSets = dynamicObjectCollection.stream().map(dynamicObject -> dynamicObject.getDynamicObject(MHSA)).filter(Objects::nonNull).map(d -> d.getLong(ID)).collect(Collectors.toSet());
        QFilter qFilter1 = new QFilter(ID, "in", idSets);
        DynamicObject[] dynamicObjects = wtpmhsHelper.loadDynamicObjectArray(new QFilter[]{qFilter1, qFilter2 = new QFilter(ISCURRENTVERSION, "=", (Object)QUOTE_STATUS_FALSE)});
        if (null == dynamicObjects || dynamicObjects.length == 0) {
            return;
        }
        HashMap<Long, Long> ruleIdBoIdMap = new HashMap<Long, Long>(16);
        for (DynamicObject obj : dynamicObjects) {
            boId = obj.getLong("boid");
            Long id = obj.getLong(ID);
            ruleIdBoIdMap.put(id, boId);
        }
        for (DynamicObject obj : dynamicObjectCollection) {
            DynamicObject mhsa = obj.getDynamicObject(MHSA);
            if (null == mhsa) continue;
            Long id = mhsa.getLong(ID);
            boId = (Long)ruleIdBoIdMap.get(id);
            if (boId != null) {
                mhsa.set(ID, (Object)boId);
            }
            obj.set(MHSA, (Object)mhsa);
        }
    }

    private static Boolean attperiodEntryEqualValues(DynamicObject oneObject, DynamicObject twoObject) {
        AtomicReference<Boolean> flag = new AtomicReference<Boolean>(Boolean.TRUE);
        if (Objects.isNull(twoObject)) {
            flag.set(Boolean.FALSE);
            return flag.get();
        }
        DataEntityPropertyCollection dataEntityPropertyCollection = oneObject.getDataEntityType().getProperties();
        dataEntityPropertyCollection.stream().forEach(property -> {
            String propertyName = property.getName();
            if (ENTRY_UPDATE_NAMES.contains(propertyName) && !Objects.equals(oneObject.get(propertyName), twoObject.get(propertyName))) {
                flag.set(Boolean.FALSE);
                return;
            }
        });
        return flag.get();
    }

    public static boolean validateBeginEndDateSection(Date beginTemp, Date endTemp, Date beginDate, Date endDate) {
        if (beginTemp == null || endTemp == null) {
            return true;
        }
        if (beginDate.getTime() >= beginTemp.getTime() && beginDate.getTime() <= endTemp.getTime()) {
            return false;
        }
        return endDate.getTime() < beginTemp.getTime() || endDate.getTime() > endTemp.getTime();
    }

    public static boolean validateCodeOrName(String value) {
        if (!AttPeriodService.validateSpecialCharacters(value)) {
            return false;
        }
        if (HRStringUtils.isNotEmpty((String)value)) {
            value = value.trim();
            return Pattern.matches(NUMBER_REGULAR_EXPRESSION, value);
        }
        return true;
    }

    public static boolean validateSpecialCharacters(String value) {
        if (HRStringUtils.isEmpty((String)value)) {
            return false;
        }
        Pattern compile = Pattern.compile(SPECIAL_CHARACTERS_EXPRESSION);
        Matcher matcher = compile.matcher(value);
        return matcher.find();
    }

    public static String getDefaultNamePrefix(String namePrefix, String number) {
        if (HRStringUtils.isNotEmpty((String)namePrefix)) {
            return namePrefix;
        }
        if (HRStringUtils.isEmpty((String)number)) {
            return number;
        }
        if (!AttPeriodService.validateCodeOrName(number)) {
            return "";
        }
        return number.length() <= 5 ? number + CHART_SPIT : number.substring(0, 5) + CHART_SPIT;
    }

    public static Date cycleMonth(Calendar beginCalendar, Calendar endCalendar, boolean isLastDay) {
        Date beginDate = beginCalendar.getTime();
        beginCalendar.add(2, 1);
        if (isLastDay) {
            int actualMaximum = beginCalendar.getActualMaximum(5);
            beginCalendar.set(5, actualMaximum);
        }
        endCalendar.setTime(beginCalendar.getTime());
        endCalendar.add(5, -1);
        return beginDate;
    }

    public static Date cycleHalfMonth(Map<String, Object> data, Calendar beginCalendar) {
        Date beginDate = beginCalendar.getTime();
        String firstPeriodDate = (String)data.get("firstperioddate");
        String secondPeriodDate = (String)data.get("secondperioddate");
        boolean monthTemp = true;
        if (Integer.parseInt(firstPeriodDate) > Integer.parseInt(secondPeriodDate)) {
            monthTemp = false;
        }
        if (AttPeriodService.validateDayIsEqual(beginDate, firstPeriodDate)) {
            if (monthTemp) {
                if ("31".equals(secondPeriodDate)) {
                    beginCalendar.setTime(AttPeriodService.getDateLastDay(beginDate));
                } else {
                    beginCalendar.set(5, Integer.parseInt(secondPeriodDate));
                }
            } else {
                beginCalendar.add(2, 1);
                beginCalendar.set(5, Integer.parseInt(secondPeriodDate));
            }
        } else if (monthTemp) {
            beginCalendar.add(2, 1);
            beginCalendar.set(5, Integer.parseInt(firstPeriodDate));
        } else if ("31".equals(firstPeriodDate)) {
            beginCalendar.setTime(AttPeriodService.getDateLastDay(beginDate));
        } else {
            beginCalendar.set(5, Integer.parseInt(firstPeriodDate));
        }
        return beginDate;
    }
}

