/*
 * Decompiled with CFR 0.152.
 */
package kd.wtc.wtp.business.attperiod;

import com.alibaba.fastjson.JSONArray;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.exception.ErrorCode;
import kd.bos.exception.KDBizException;
import kd.bos.exception.KDException;
import kd.bos.form.ShowType;
import kd.bos.list.ListShowParameter;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.util.CollectionUtils;
import kd.hr.hbp.business.servicehelper.HRBaseServiceHelper;
import kd.hr.hbp.common.util.HRStringUtils;
import kd.wtc.wtbs.business.history.service.WTCHisServiceHelper;
import kd.wtc.wtbs.business.util.WTCDynamicObjectUtils;
import kd.wtc.wtbs.business.web.file.AttFileQueryServiceImpl;
import kd.wtc.wtbs.common.helper.WTCAppContextHelper;
import kd.wtc.wtbs.common.model.attfile.AttFileQueryParam;
import kd.wtc.wtbs.common.util.WTCCollections;
import kd.wtc.wtbs.common.util.WTCDateUtils;
import kd.wtc.wtbs.common.util.third.collect.Lists;
import kd.wtc.wtbs.common.util.third.collect.Maps;
import kd.wtc.wtbs.common.util.third.collect.Sets;
import kd.wtc.wtp.business.attfile.AttFileSyncService;
import kd.wtc.wtp.business.attperiod.PeriodServiceHelper;
import kd.wtc.wtp.business.attperiod.PeriodSyncFormService;
import kd.wtc.wtp.business.attperiod.perperiod.model.AttFileVersionEntity;
import kd.wtc.wtp.business.attperiod.perperiod.model.PerPeriodGenPreEntity;
import kd.wtc.wtp.business.attperiod.perperiod.model.PeriodEntryEntity;
import kd.wtc.wtp.business.attperiod.perperiod.model.PeriodFileSchEntity;
import kd.wtc.wtp.business.attperiod.task.PerAttPeriodGenService;
import kd.wtc.wtp.business.attperiod.task.model.PerPeriodEntity;
import kd.wtc.wtp.business.attstateinfo.AttStateInfoService;
import kd.wtc.wtp.common.constants.attperiod.AttPeriodConstants;
import kd.wtc.wtp.common.enums.AttFileTaskCacheInfoEnum;
import kd.wtc.wtp.common.model.attstateinfo.AttStateInfoBO;
import kd.wtc.wtp.enums.attperiod.PeriodCutTypeEnum;
import kd.wtc.wtp.utils.PerAttPeriodUtils;

public class PerAttPeriodDataService
implements AttPeriodConstants {
    private static final Log LOG = LogFactory.getLog(PerAttPeriodDataService.class);
    private static final PerAttPeriodDataService INS = (PerAttPeriodDataService)WTCAppContextHelper.getBean(PerAttPeriodDataService.class);
    private static final HRBaseServiceHelper ATTPERIOD_SCHEDULE_HELPER = new HRBaseServiceHelper("wtp_periodschedule");
    private static final HRBaseServiceHelper ATTPERIODENTRY_HELPER = new HRBaseServiceHelper("wtp_attperiodentry");
    private static final HRBaseServiceHelper PERATTPERIOD_HELPER = new HRBaseServiceHelper("wtp_perattperiod");
    private static final HRBaseServiceHelper PERATTPERIODJOBDATA_HELPER = new HRBaseServiceHelper("wtp_perattperiodjobdata");
    private static final String ATTFILE_QUERY_PROPERTY = "id,boid,bsed,bsled,startdate,enddate,empposorgrel.datastatus";
    private static final String ATTPERIODSCH_QUERY_PROPERTY = "period,attfileid,attfilevid,bsed,bsled";
    private static final String PERIODENTRY_QUERY_PROPERTY = "masterid,entryid,enddate,begindate,name";
    private static final String PERATTPERIOD_QUERY_PROPERTY = "id,startdate,enddate,attfileid,attfilevid,periodentry,laststorage,firstnotstorage";

    public static PerAttPeriodDataService getInstance() {
        return INS;
    }

    public PerPeriodGenPreEntity getPerPeriodGenPreEntity(List<Long> fileBoIdList, Date startDate, Date endDate) {
        PerPeriodGenPreEntity perPeriodGenPreEntity = new PerPeriodGenPreEntity();
        if (CollectionUtils.isEmpty(fileBoIdList)) {
            return perPeriodGenPreEntity;
        }
        LOG.info("PerAttPeriodDataService.getPerPeriodGenPreEntity, startDate={}, endDate={} fileBoIdList={}", new Object[]{startDate, endDate, fileBoIdList.size() > 50 ? Integer.valueOf(fileBoIdList.size()) : fileBoIdList});
        HashMap<String, Date> dateMap = new HashMap<String, Date>();
        dateMap.put("minStartDate", null);
        dateMap.put("maxEndDate", null);
        Map<Long, List<AttFileVersionEntity>> attFileVersionMap = this.getFileVersion(fileBoIdList, startDate, endDate, dateMap);
        Date minStartDate = (Date)dateMap.get("minStartDate");
        Date maxEndDate = (Date)dateMap.get("maxEndDate");
        HashSet attPeriodIdSet = Sets.newHashSetWithExpectedSize((int)fileBoIdList.size());
        Map<Long, List<PeriodFileSchEntity>> periodFileSchMap = this.getPeriodFileSch(fileBoIdList, minStartDate, maxEndDate, attPeriodIdSet);
        Map<Long, List<PeriodEntryEntity>> periodEntryListMap = this.getPeriodEntryListMap(attPeriodIdSet, startDate, endDate);
        Map<Long, Map<String, PerPeriodEntity>> existPeriodEntryListMap = this.getExistPeriodEntryListMap(fileBoIdList);
        Map<Long, String> existsFileMap = AttFileSyncService.getInstance().lockFileBoIds(new HashSet<Long>(fileBoIdList), AttFileTaskCacheInfoEnum.ATT_FILE_PERIOD);
        PeriodSyncFormService.getInstance().saveUnDoExistsFileVid(existsFileMap.keySet());
        Map<Long, AttStateInfoBO> attStateInfoBOMap = AttStateInfoService.getInstance().queryAttStateInfoByBoid(fileBoIdList).stream().collect(Collectors.toMap(AttStateInfoBO::getFileBoid, Function.identity(), (a, b) -> a));
        perPeriodGenPreEntity.setAttFileVersionMap(attFileVersionMap);
        perPeriodGenPreEntity.setPeriodFileSchListMap(periodFileSchMap);
        perPeriodGenPreEntity.setPeriodEntryListMap(periodEntryListMap);
        perPeriodGenPreEntity.setExistPeriodEntryListMap(existPeriodEntryListMap);
        perPeriodGenPreEntity.setAttStateInfoMap(attStateInfoBOMap);
        perPeriodGenPreEntity.setPerAttPeriodSysParams(PerAttPeriodUtils.getPerAttPeriodSysParams());
        perPeriodGenPreEntity.setExistsAttFileMap(existsFileMap);
        return perPeriodGenPreEntity;
    }

    public void saveJobDataForAttPeriodUpdate(List<Long> attPeriodIdList) {
        LOG.info("PerAttPeriodDataService.forAttPeriodUpdate start");
        if (CollectionUtils.isEmpty(attPeriodIdList)) {
            return;
        }
        List<Long> fileBoIdList = this.queryAttPeriodSch(attPeriodIdList);
        this.saveJobData(fileBoIdList, "1");
    }

    private List<Long> queryAttPeriodSch(List<Long> attPeriodIdList) {
        ArrayList fileBoIdList = Lists.newArrayListWithExpectedSize((int)10);
        if (CollectionUtils.isEmpty(attPeriodIdList)) {
            return fileBoIdList;
        }
        QFilter currentQFilter = WTCHisServiceHelper.isCurrentVersion((boolean)false);
        QFilter attPeriodIdQFilter = new QFilter("period", "in", attPeriodIdList);
        QFilter dataStatusQFilter = WTCHisServiceHelper.dataStatusValidQFilter();
        DynamicObject[] attPeriodSchDyArr = ATTPERIOD_SCHEDULE_HELPER.query(ATTPERIODSCH_QUERY_PROPERTY, new QFilter[]{attPeriodIdQFilter, dataStatusQFilter, currentQFilter});
        if (attPeriodSchDyArr == null || attPeriodSchDyArr.length == 0) {
            return fileBoIdList;
        }
        return Arrays.stream(attPeriodSchDyArr).map(dy -> WTCDynamicObjectUtils.getBaseDataId((DynamicObject)dy, (String)"attfileid")).distinct().collect(Collectors.toList());
    }

    private void saveJobData(List<Long> fileBoIdList, String type) {
        if (CollectionUtils.isEmpty(fileBoIdList)) {
            return;
        }
        QFilter filter = new QFilter("attfileid", "in", fileBoIdList);
        Set<Long> existFileIdSet = this.queryNeedSyncAttFileJobData(filter);
        ArrayList perAttPeriodJobDataList = Lists.newArrayListWithExpectedSize((int)fileBoIdList.size());
        for (Long fileBoId : fileBoIdList) {
            if (existFileIdSet.contains(fileBoId)) continue;
            DynamicObject dy = PERATTPERIODJOBDATA_HELPER.generateEmptyDynamicObject();
            dy.set("attfileid", (Object)fileBoId);
            dy.set("type", (Object)type);
            perAttPeriodJobDataList.add(dy);
        }
        try {
            PERATTPERIODJOBDATA_HELPER.save(perAttPeriodJobDataList.toArray(new DynamicObject[0]));
        }
        catch (Exception ex) {
            LOG.warn("PerAttPeriodDataService.saveJobData error", (Throwable)ex);
            throw new KDException((Throwable)ex, new ErrorCode("PerAttPeriodDataService.saveJobData", "PerAttPeriodDataService.forAttPeriodUpdate error"), new Object[0]);
        }
    }

    public void processPerAttPeriod(String type, Map<Long, Long> fileBoIdAndPersonIdMap) {
        if (HRStringUtils.isNotEmpty((String)type)) {
            this.saveJobData(new ArrayList<Long>(fileBoIdAndPersonIdMap.keySet()), type);
        } else {
            this.processAndSavePerAttPeriodData(fileBoIdAndPersonIdMap);
        }
    }

    public void processPerAttPeriod(String type, Map<Long, Long> fileBoIdAndPersonIdMap, boolean synCheck) {
        if (HRStringUtils.isNotEmpty((String)type)) {
            this.saveJobData(new ArrayList<Long>(fileBoIdAndPersonIdMap.keySet()), type);
        } else {
            this.processAndSavePerAttPeriodData(fileBoIdAndPersonIdMap, false, synCheck);
        }
    }

    public void clearDataForTaskEnd(Set<Long> attFileBoIdSet) {
        LOG.info("PerAttPeriodDataService.clearDataForTaskEnd ");
        if (CollectionUtils.isEmpty(attFileBoIdSet)) {
            return;
        }
        QFilter qFilter = new QFilter("attfileid", "in", attFileBoIdSet);
        qFilter.and("type", "!=", (Object)"5");
        PERATTPERIODJOBDATA_HELPER.deleteByFilter(new QFilter[]{qFilter});
    }

    public void processAndSavePerAttPeriodData(Map<Long, Long> fileBoIdAndPersonIdMap, boolean ignoreCheck, boolean synCheck) {
        LOG.info("PerAttPeriodDataService.processAndSavePerAttPeriodData start fileBoIdAndPersonIdMap={}", fileBoIdAndPersonIdMap);
        if (fileBoIdAndPersonIdMap == null || fileBoIdAndPersonIdMap.size() == 0) {
            return;
        }
        Set<Long> fileBoIdSet = fileBoIdAndPersonIdMap.keySet();
        HashMap existsFileMap = Maps.newHashMapWithExpectedSize((int)16);
        if (synCheck) {
            existsFileMap.putAll(AttFileSyncService.getInstance().lockFileBoIds(fileBoIdSet, AttFileTaskCacheInfoEnum.ATT_FILE_PERIOD));
            PeriodSyncFormService.getInstance().saveUnDoExistsFileVid(existsFileMap.keySet());
        }
        try {
            if (WTCCollections.isNotEmpty((Map)existsFileMap) && existsFileMap.size() == fileBoIdSet.size()) {
                LOG.info("PerAttPeriodDataService.processAndSavePerAttPeriodData all fileBo running");
                return;
            }
            PeriodSyncFormService.getInstance().saveUnDoExistsFileVid(existsFileMap.keySet());
            PerPeriodGenPreEntity perPeriodGenPreEntity = this.getPerPeriodGenPreEntity(new ArrayList<Long>(fileBoIdAndPersonIdMap.keySet()), null, null);
            perPeriodGenPreEntity.setIgnoreCheck(ignoreCheck);
            ArrayList perPeriodEntityList = Lists.newArrayListWithExpectedSize((int)10);
            HashMap periodCutTypeEnumSetMap = Maps.newHashMapWithExpectedSize((int)2);
            periodCutTypeEnumSetMap.put(PeriodCutTypeEnum.CUT, Sets.newHashSetWithExpectedSize((int)16));
            periodCutTypeEnumSetMap.put(PeriodCutTypeEnum.NOT_CUT, Sets.newHashSetWithExpectedSize((int)16));
            for (Map.Entry<Long, Long> entry : fileBoIdAndPersonIdMap.entrySet()) {
                PerAttPeriodGenService.getInstance().synPerAttPeriod(entry.getValue(), entry.getKey(), perPeriodEntityList, periodCutTypeEnumSetMap, perPeriodGenPreEntity);
            }
            PeriodServiceHelper.getInstance().savePerPeriodDynData(perPeriodEntityList, periodCutTypeEnumSetMap);
            LOG.info("PerAttPeriodDataService.processAndSavePerAttPeriodData end");
        }
        catch (Exception exception) {
            LOG.error((Throwable)exception);
            throw new KDBizException("PerAttPeriod syn error");
        }
        finally {
            if (WTCCollections.isNotEmpty((Map)existsFileMap)) {
                fileBoIdSet.removeIf(existsFileMap::containsKey);
            }
            if (!CollectionUtils.isEmpty(fileBoIdSet)) {
                PeriodSyncFormService.getInstance().removeFileBoIdInRedis(new ArrayList<Long>(fileBoIdSet));
            }
        }
    }

    public void processAndSavePerAttPeriodData(Map<Long, Long> fileBoIdAndPersonIdMap, boolean ignoreCheck) {
        this.processAndSavePerAttPeriodData(fileBoIdAndPersonIdMap, ignoreCheck, true);
    }

    public void processAndSavePerAttPeriodData(Map<Long, Long> fileBoIdAndPersonIdMap) {
        this.processAndSavePerAttPeriodData(fileBoIdAndPersonIdMap, false);
    }

    private Map<Long, Map<String, PerPeriodEntity>> getExistPeriodEntryListMap(List<Long> fileBoIdList) {
        HashMap existPeriodEntryListMap = Maps.newHashMapWithExpectedSize((int)fileBoIdList.size());
        QFilter attFileBoIdQFilter = new QFilter("attfileid", "in", fileBoIdList);
        QFilter dateQFilter = new QFilter("busistatus", "=", (Object)"1");
        DynamicObject[] dyArr = PERATTPERIOD_HELPER.query(PERATTPERIOD_QUERY_PROPERTY, new QFilter[]{attFileBoIdQFilter, dateQFilter});
        if (dyArr == null || dyArr.length == 0) {
            return existPeriodEntryListMap;
        }
        List<DynamicObject> dyList = Arrays.stream(dyArr).sorted(Comparator.comparing(dy -> dy.getDate("startdate"))).collect(Collectors.toList());
        dyList.forEach(dy -> {
            PerPeriodEntity entity = new PerPeriodEntity();
            entity.setPerAttBeginDate(dy.getDate("startdate"));
            entity.setPerAttEndDate(dy.getDate("enddate"));
            entity.setPrimaryId(dy.getLong("id"));
            long fileBoId = WTCDynamicObjectUtils.getBaseDataId((DynamicObject)dy, (String)"attfileid");
            entity.setFileBoId(fileBoId);
            entity.setFileId(WTCDynamicObjectUtils.getBaseDataId((DynamicObject)dy, (String)"attfilevid"));
            entity.setAttPeriodId(WTCDynamicObjectUtils.getBaseDataId((DynamicObject)dy, (String)"periodentry"));
            entity.setFirstNotStorage(dy.getBoolean("firstnotstorage"));
            entity.setLastStorage(dy.getBoolean("laststorage"));
            Map mapPeriodEntryEntity = existPeriodEntryListMap.computeIfAbsent(fileBoId, value -> new HashMap());
            mapPeriodEntryEntity.put(PerAttPeriodGenService.getInstance().getLockUniqueKey(entity), entity);
        });
        return existPeriodEntryListMap;
    }

    private Map<Long, List<PeriodEntryEntity>> getPeriodEntryListMap(Set<Long> attPeriodIdSet, Date startDate, Date endDate) {
        Integer nowYear;
        Date lastDayOfMonth;
        QFilter periodEntryEndQFilter;
        DynamicObject[] dyArr;
        HashMap periodEntryListMap = Maps.newHashMapWithExpectedSize((int)attPeriodIdSet.size());
        if (CollectionUtils.isEmpty(attPeriodIdSet)) {
            return periodEntryListMap;
        }
        QFilter periodIdQFilter = new QFilter("masterid", "in", attPeriodIdSet);
        QFilter entryStartAndEndDateQFilter = null;
        if (startDate != null && endDate != null) {
            entryStartAndEndDateQFilter = new QFilter("begindate", "<=", (Object)endDate).and(new QFilter("enddate", ">=", (Object)startDate));
        }
        if ((dyArr = this.queryAttPeriodEntry(PERIODENTRY_QUERY_PROPERTY, new QFilter[]{periodIdQFilter, entryStartAndEndDateQFilter, periodEntryEndQFilter = new QFilter("begindate", "<=", (Object)(lastDayOfMonth = WTCDateUtils.getLastDayOfMonth((int)((nowYear = WTCDateUtils.getNowYear()) + 1), (int)12)))})) == null || dyArr.length == 0) {
            return periodEntryListMap;
        }
        List dyList = Arrays.stream(dyArr).sorted(Comparator.comparing(dy -> dy.getDate("begindate"))).collect(Collectors.toList());
        for (DynamicObject dy2 : dyList) {
            PeriodEntryEntity entity = new PeriodEntryEntity();
            entity.setEndDate(dy2.getDate("enddate"));
            entity.setStartDate(dy2.getDate("begindate"));
            entity.setId(dy2.getLong("id"));
            entity.setName(dy2.getString("name"));
            long attPeriodId = WTCDynamicObjectUtils.getBaseDataId((DynamicObject)dy2, (String)"masterid");
            entity.setHigherLevelId(attPeriodId);
            List linkedList = periodEntryListMap.computeIfAbsent(attPeriodId, value -> new ArrayList());
            linkedList.add(entity);
        }
        return periodEntryListMap;
    }

    private Map<Long, List<PeriodFileSchEntity>> getPeriodFileSch(List<Long> fileBoIdList, Date minStartDate, Date maxEndDate, Set<Long> attPeriodIdSet) {
        DynamicObject[] attPeriodSchDyArr;
        HashMap periodFileSchMap = Maps.newHashMapWithExpectedSize((int)fileBoIdList.size());
        QFilter currentQFilter = WTCHisServiceHelper.isCurrentVersion((boolean)false);
        QFilter dataStatusQFilter = WTCHisServiceHelper.dataStatusValidQFilter();
        QFilter attFileBoIdQFilter = new QFilter("attfileid", "in", fileBoIdList);
        QFilter dateQFilter = null;
        if (minStartDate != null && maxEndDate != null) {
            dateQFilter = new QFilter("bsed", "<=", (Object)maxEndDate).and(new QFilter("bsled", ">=", (Object)minStartDate));
        }
        if ((attPeriodSchDyArr = ATTPERIOD_SCHEDULE_HELPER.query(ATTPERIODSCH_QUERY_PROPERTY, new QFilter[]{attFileBoIdQFilter, dateQFilter, dataStatusQFilter, currentQFilter})) != null && attPeriodSchDyArr.length > 0) {
            List<DynamicObject> attPeriodSchDyList = Arrays.stream(attPeriodSchDyArr).sorted(Comparator.comparing(dy -> dy.getDate("bsed"))).collect(Collectors.toList());
            attPeriodSchDyList.forEach(dy -> {
                PeriodFileSchEntity entity = new PeriodFileSchEntity();
                entity.setEndDate(dy.getDate("bsled"));
                entity.setStartDate(dy.getDate("bsed"));
                entity.setId(WTCDynamicObjectUtils.getBaseDataId((DynamicObject)dy, (String)"period"));
                entity.setPeriodId(WTCDynamicObjectUtils.getBaseDataId((DynamicObject)dy, (String)"period"));
                long fileBoId = WTCDynamicObjectUtils.getBaseDataId((DynamicObject)dy, (String)"attfileid");
                entity.setHigherLevelId(fileBoId);
                List linkedList = periodFileSchMap.computeIfAbsent(fileBoId, value -> new ArrayList());
                linkedList.add(entity);
                attPeriodIdSet.add(entity.getId());
            });
        }
        return periodFileSchMap;
    }

    private Map<Long, List<AttFileVersionEntity>> getFileVersion(List<Long> fileBoIdList, Date startDate, Date endDate, Map<String, Date> dateMap) {
        HashMap attFileVersionMap = Maps.newHashMapWithExpectedSize((int)fileBoIdList.size());
        AttFileQueryParam param = new AttFileQueryParam();
        param.setStartDate(startDate);
        param.setEndDate(endDate);
        param.setAuthCheck(Boolean.FALSE);
        param.setSetBoIds(new HashSet<Long>(fileBoIdList));
        param.setProperties(ATTFILE_QUERY_PROPERTY);
        List attFileList = AttFileQueryServiceImpl.getInstance().queryAttFiles(param);
        if (CollectionUtils.isEmpty((Collection)attFileList)) {
            return attFileVersionMap;
        }
        attFileList.sort(Comparator.comparing(dy -> dy.getDate("bsed")));
        Date minStartDate = dateMap.get("minStartDate");
        Date maxEndDate = dateMap.get("maxEndDate");
        for (DynamicObject dy2 : attFileList) {
            AttFileVersionEntity entity = new AttFileVersionEntity();
            entity.setEndDate(WTCDateUtils.getMinDate((Date)dy2.getDate("enddate"), (Date)dy2.getDate("bsled")));
            entity.setStartDate(dy2.getDate("bsed"));
            entity.setId(dy2.getLong("id"));
            entity.setHigherLevelId(dy2.getLong("boid"));
            String dataStatus = dy2.getString("empposorgrel.datastatus");
            entity.setDataStatus(dataStatus);
            List linkedList = attFileVersionMap.computeIfAbsent(dy2.getLong("boid"), value -> new ArrayList());
            linkedList.add(entity);
            minStartDate = minStartDate == null ? dy2.getDate("bsed") : WTCDateUtils.getMinDate((Date)minStartDate, (Date)dy2.getDate("bsed"));
            maxEndDate = maxEndDate == null ? WTCDateUtils.getMinDate((Date)dy2.getDate("enddate"), (Date)dy2.getDate("bsled")) : WTCDateUtils.getMaxDate((Date)maxEndDate, (Date)WTCDateUtils.getMinDate((Date)dy2.getDate("enddate"), (Date)dy2.getDate("bsled")));
        }
        dateMap.put("minStartDate", minStartDate);
        dateMap.put("maxEndDate", maxEndDate);
        return attFileVersionMap;
    }

    private DynamicObject[] queryAttPeriodEntry(String selectProperty, QFilter[] qFilter) {
        return ATTPERIODENTRY_HELPER.query(selectProperty, qFilter);
    }

    public Set<Long> queryNeedSyncAttFileJobData(QFilter filter) {
        DynamicObject[] dyArr = PERATTPERIODJOBDATA_HELPER.query("id,attfileid", new QFilter[]{filter});
        return Arrays.stream(dyArr).map(dy -> WTCDynamicObjectUtils.getBaseDataId((DynamicObject)dy, (String)"attfileid")).collect(Collectors.toSet());
    }

    public Map<Long, Long> obtainNeedSyncAttFileJobData(QFilter filter) {
        DynamicObject[] dyArr = PERATTPERIODJOBDATA_HELPER.query("id,attfileid", new QFilter[]{filter});
        return Arrays.stream(dyArr).collect(Collectors.toMap(dy -> WTCDynamicObjectUtils.getBaseDataId((DynamicObject)dy, (String)"id"), dy -> WTCDynamicObjectUtils.getBaseDataId((DynamicObject)dy, (String)"attfileid"), (a, b) -> b));
    }

    public void processPerAttPeriodFromJobData() {
        LOG.info("PerAttPeriodDataService.processPerAttPeriodJobData start");
        QFilter typeQFilter = new QFilter("type", "=", (Object)"5");
        DynamicObject[] dyArr = PERATTPERIODJOBDATA_HELPER.query("id,attfileid", new QFilter[]{typeQFilter});
        if (dyArr == null || dyArr.length == 0) {
            LOG.info("PerAttPeriodDataService.processPerAttPeriodJobData dyArr is empty");
            return;
        }
        Set<Long> attFileBoIdSet = Arrays.stream(dyArr).map(dy -> WTCDynamicObjectUtils.getBaseDataId((DynamicObject)dy, (String)"attfileid")).collect(Collectors.toSet());
        PeriodSyncFormService.getInstance().runPeriodSynTaskBackground(attFileBoIdSet, null);
    }

    public ListShowParameter showPerAttPeriod(String pageId, Map<String, Object> subCustomParams, Set<Long> fileBoIds) {
        if (CollectionUtils.isNotEmpty(fileBoIds)) {
            subCustomParams.put("attfile", JSONArray.toJSONString(fileBoIds));
        }
        ListShowParameter listShowParameter = new ListShowParameter();
        listShowParameter.setBillFormId("wtp_perattperiod");
        Map customParams = listShowParameter.getCustomParams();
        customParams.putAll(subCustomParams);
        listShowParameter.setCustomParams(customParams);
        listShowParameter.setPageId(pageId);
        listShowParameter.getOpenStyle().setShowType(ShowType.MainNewTabPage);
        listShowParameter.setHasRight(false);
        return listShowParameter;
    }

    public void saveAndDeleteCutData(Map.Entry<PeriodCutTypeEnum, Set<Long>> mapEntry, PeriodCutTypeEnum key) {
        HRBaseServiceHelper helper = new HRBaseServiceHelper("wtp_perattperiodjobdata");
        if (PeriodCutTypeEnum.CUT == key) {
            Set<Long> attFileBoIdSet = mapEntry.getValue();
            if (attFileBoIdSet.size() == 0) {
                return;
            }
            ArrayList dyList = Lists.newArrayListWithExpectedSize((int)attFileBoIdSet.size());
            QFilter filter = new QFilter("attfileid", "in", mapEntry.getValue());
            filter.and(new QFilter("type", "=", (Object)"5"));
            Set<Long> existFileIdSet = PerAttPeriodDataService.getInstance().queryNeedSyncAttFileJobData(filter);
            for (Long attFileBoId : attFileBoIdSet) {
                if (existFileIdSet.contains(attFileBoId)) continue;
                DynamicObject dy = helper.generateEmptyDynamicObject();
                dy.set("type", (Object)"5");
                dy.set("attfileid", (Object)attFileBoId);
                dyList.add(dy);
            }
            helper.save(dyList.toArray(new DynamicObject[0]));
        } else if (PeriodCutTypeEnum.NOT_CUT == key) {
            Set<Long> attFileBoIdSet = mapEntry.getValue();
            if (attFileBoIdSet.size() == 0) {
                return;
            }
            QFilter qFilter = new QFilter("attfileid", "in", attFileBoIdSet);
            qFilter.and(new QFilter("type", "=", (Object)"5"));
            helper.deleteByFilter(qFilter.toArray());
        }
    }
}

